﻿#include	"AjcInternal.h"

//--------------------------------------------------------------------------------------------------------------//
//	インスタンスワーク																							//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	BOOL	fEnd;			//	検索終了フラグ
	BOOL	fNtcDir;		//	ディレクトリ通知フラグ
	int		Nest;			//	検索終了フラグ
	int		Count;			//	見つかったファイル／ディレクトリのカウンタ
	VOP		pWild;			//	ワイルドカード・パス群（多重文字列）へのポインタ
	BOOL	fSubDir;		//	サブディレクトリ検索フラグ
	UX		cbp;			//	コールバックパラメタ
	union {
		BOOL	(CALLBACK *cbA)(UI nest, BCP pPath, BCP pName, UI att, UI wtime, UX cbp);
		BOOL	(CALLBACK *cbW)(UI nest, WCP pPath, WCP pName, UI att, UI wtime, UX cbp);
	} u;
} WKENFILES, *PWKENFILES;

//--------------------------------------------------------------------------------------------------------------//
//	作業領域																									//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	fNotifySearchingDir = FALSE;

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
static	VO		GsefSearchA(PWKENFILES pW, C_BCP pDir);
static	BOOL	GsefSelectA(PWKENFILES pW, C_BCP pDir, C_BCP pFName);

static	VO		GsefSearchW(PWKENFILES pW, C_WCP pDir);
static	BOOL	GsefSelectW(PWKENFILES pW, C_WCP pDir, C_WCP pFName);


//==============================================================================================================//
//	Function	:	ファイル名検索時の検索フォルダの通知設定													//
//																												//
//	Argument	:	fNotify	- TRUE	: 検索フォルダを通知する													//
//							  FALSE : 検索フォルダは通知しない													//
//																												//
//	Return		:	なし																						//
//==============================================================================================================//
AJCEXPORT	VO	WINAPI	AjcSetNtcSearchingDir(BOOL fNotify)
{
	fNotifySearchingDir = fNotify;
}
//==============================================================================================================//
//	Function	:	指定ディレクトリ下のファイル名検索															//
//																												//
//	Argument	:	pDir	- ディレクトリパス名のアドレス														//
//					pWild	- ワイルドカード群のアドレス（複数時は'/'で区切る。NULL指定時は全検索）				//
//					fSubDir - TRUEを指定した場合サブディレクトリも検索する										//
//					cbp		- コールバックパラメタ																//
//					cb		- 検索したファイルパス名を通知するためのコールバック関数のアドレス					//
//																												//
//	Return		:	検索されたファイル数																		//
//==============================================================================================================//
//----- バイト文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT	int		WINAPI	AjcSearchFilesA(C_BCP pDir, C_BCP pWild, BOOL fSubDir, UX cbp, BOOL (CALLBACK *cb)(UI nest, BCP pPath, BCP pName, UI att, UI wtime, UX cbp))
{
	return AjcSearchFilesExA(pDir, pWild, fSubDir, FALSE, cbp, cb);
}
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -//
AJCEXPORT	int		WINAPI	AjcSearchFilesExA(C_BCP pDir, C_BCP pWild, BOOL fSubDir, BOOL fNtcDir, UX cbp, BOOL (CALLBACK *cb)(UI nest, BCP pPath, BCP pName, UI att, UI wtime, UX cbp))
{
	UI			stl;
	C_BCP		p;
	BCP			q, t;
	WKENFILES	wk;

	memset(&wk, 0, sizeof wk);
	wk.fEnd	   = FALSE;
	wk.fNtcDir = fNtcDir;
	wk.Nest	   = 0;
	wk.Count   = 0;
	wk.cbp	   = cbp;
	wk.u.cbA   = cb;
	wk.fSubDir = fSubDir;
	wk.pWild   = NULL;

	if (AjcPathIsDirectoryA(pDir) && pWild != NULL) {
		//-- 検索DIR通知 --//
		if (fNotifySearchingDir || wk.fNtcDir) {
			wk.fEnd = !wk.u.cbA(-1, (BCP)pDir, "", 0, 0, wk.cbp);
		}
		if (!wk.fEnd) {
			stl = (UI)strlen(pWild);
			if (wk.pWild = calloc(stl + 2, 1)) {
				p = pWild;			//	ソーステキストポインタ
				q = (BCP)wk.pWild;	//	バッファポインタ
				t = (BCP)wk.pWild;	//	１つのワイルドカードの先頭ポインタ
				while (*p != 0) {
					//	１つのワイルドカードをコピー
					while (*p != '/' && *p != ';' && *p != 0) {
						*q++ = *p++;
					}
					*q = 0;
					//	連続する '/' , ';' or ' ' をスキップ
					while (*p == '/' || *p == ';' || MAjcIsBlankA(*p)) {
						p++;
					}
					//	ワイルドカードの文字列長を設定（終端を含む）
					stl = (UI)strlen(t) + 1;
					//	ワイルドカードの両端の空白を除去
					AjcStrTrimExA(t, t, stl, " ");
					//	空白除去後のワールドカード文字列長設定（終端を含む）
					stl = (UI)strlen(t) + 1;
					//	バッファポインタを再設定
					t += stl;
					q = t;
				}
				//	多重文字列終端設定
				*q = 0;
				//	検索処理
				GsefSearchA(&wk, pDir);
				//	バッファ解放
				free(wk.pWild);
			}
		}
	}
	return wk.Count;
}
//--------------------------------------------------------------------------------------------------------------//
static	VO	GsefSearchA(PWKENFILES pW, C_BCP pDir)
{
	BC		wild[MAX_PATH];
	BC		subd[MAX_PATH];
	BC		buf[MAX_PATH];
	UX		fh;
	struct	_finddata_t fd;

	AjcSnPrintFA(wild, MAX_PATH, "%s", pDir);
	AjcPathCatA (wild, "*.*", MAX_PATH);

	if (!pW->fEnd) {	
		if ((fh = _findfirst(wild, &fd)) != -1) {
			do {
				if (fd.attrib & _A_SUBDIR) {
					if (mbscmp(fd.name, ".") != 0 && mbscmp(fd.name, "..") != 0) {
						//-- DIR名通知 ----//
						if (GsefSelectA(pW, pDir, fd.name)) {
							AjcSnPrintFA(buf, MAX_PATH, "%s", pDir);
							AjcPathCatA (buf, fd.name, MAX_PATH);
							pW->fEnd = !pW->u.cbA(pW->Nest, buf, fd.name, fd.attrib, (UI)fd.time_write, pW->cbp);
							pW->Count++;
							if (pW->fEnd) break;
						}
						//-- サブDIR検索 --//
						if (pW->fSubDir) {
							AjcSnPrintFA(subd, MAX_PATH, "%s", pDir);
							AjcPathCatA (subd, fd.name, MAX_PATH);
							//-- 検索DIR通知 --//
							if (fNotifySearchingDir || pW->fNtcDir) {
								pW->fEnd = !pW->u.cbA(-1, subd, "", fd.attrib, (UI)fd.time_write, pW->cbp);
								if (pW->fEnd) break;
							}
							pW->Nest++;
							GsefSearchA(pW, subd);
							pW->Nest--;
							if (pW->fEnd) break;
						}
					}
				}
				else {
					if (GsefSelectA(pW, pDir, fd.name)) {
						//-- ファイル名通知 --//
						AjcSnPrintFA(buf, MAX_PATH, "%s", pDir);
						AjcPathCatA (buf, fd.name, MAX_PATH);
						pW->fEnd = !pW->u.cbA(pW->Nest, buf, fd.name, fd.attrib, (UI)fd.time_write, pW->cbp);
						pW->Count++;
						if (pW->fEnd) break;
					}
				}
			} while (_findnext(fh, &fd) != -1);
			_findclose(fh);
		}
	}
}
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	GsefSelectA(PWKENFILES pW, C_BCP pDir, C_BCP pFName)
{
	BOOL	rc = FALSE;
	BCP		p;
	UI		i;
	BC		dir [MAX_PATH];		//	ディレクトリパス名（末尾に必ず'￥'を付加）
	BC		last[MAX_PATH];		//	末尾ディレクトリ名
	BC		wild[MAX_PATH];		//	ワイルドカード
	UI		dirL, lastL, wildL;

	if (pW->pWild != NULL && strlen(pW->pWild) != 0) {
		p = pW->pWild;
		strcpy(dir, pDir);
		AjcPathCatA(dir, "", MAX_PATH);
		while (*p != 0) {
			//----- ワイルドパスをパスとワイルドカードに分離(ex "SUB1\SUB2\*.txt" --> "SUB1\SUB2\", "*.txt") ---//
			last[0] = 0;
			wild[0] = 0;
			for (i = (UI)strlen(p) - 1; i > 0 && *(p + i) != '\\'; i--);
			if (*(p + i) == '\\') i++;
			memcpy(last, p, i);
			last[i] = 0;
			strcpy(wild, p + i);
			dirL  = (UI)strlen(dir);
			lastL = (UI)strlen(last);
			wildL = (UI)strlen(wild);

			if ((lastL == 0 || (dirL >= lastL && mbsicmp(&dir[dirL - lastL], last) == 0)) && PathMatchSpecA(pFName, wild)) {
				rc = TRUE;
				break;
			}
			p += (strlen(p) + 1);
		}
	}
	else {
		rc = TRUE;
	}
	return rc;
}

//----- ワイド文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT	int		WINAPI	AjcSearchFilesW(C_WCP pDir, C_WCP pWild, BOOL fSubDir, UX cbp, BOOL (CALLBACK *cb)(UI nest, WCP pPath, WCP pName, UI att, UI wtime, UX cbp))
{
	return AjcSearchFilesExW(pDir, pWild, fSubDir, FALSE, cbp, cb);
}
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -//
AJCEXPORT	int		WINAPI	AjcSearchFilesExW(C_WCP pDir, C_WCP pWild, BOOL fSubDir, BOOL fNtcDir, UX cbp, BOOL (CALLBACK *cb)(UI nest, WCP pPath, WCP pName, UI att, UI wtime, UX cbp))
{
	UI			stl;
	C_WCP		p;
	WCP			q, t;
	WKENFILES	wk;

	memset(&wk, 0, sizeof wk);
	wk.fEnd	   = FALSE;
	wk.fNtcDir = fNtcDir;
	wk.Nest	   = 0;
	wk.Count   = 0;
	wk.cbp	   = cbp;
	wk.u.cbW   = cb;
	wk.fSubDir = fSubDir;
	wk.pWild   = NULL;

	if (AjcPathIsDirectoryW(pDir) && pWild != NULL) {
		//-- 検索DIR通知 --//
		if (fNotifySearchingDir || wk.fNtcDir) {
			wk.fEnd = !wk.u.cbA(-1, (BCP)pDir, "", 0, 0, wk.cbp);
		}
		if (!wk.fEnd) {
			stl = (UI)wcslen(pWild);
			if (wk.pWild = calloc(stl + 2, 2)) {
				p = pWild;			//	ソーステキストポインタ
				q = (WCP)wk.pWild;	//	バッファポインタ
				t = (WCP)wk.pWild;	//	１つのワイルドカードの先頭ポインタ
				while (*p != 0) {
					//	１つのワイルドカードをコピー
					while (*p != L'/' && *p != L';' && *p != 0) {
						*q++ = *p++;
					}
					*q = 0;
					//	連続する '/' , ';' or ' ' をスキップ
					while (*p == L'/' || *p == L';' || MAjcIsBlankW(*p)) {
						p++;
					}
					//	ワイルドカードの文字列長を設定（終端を含む）
					stl = (UI)wcslen(t) + 1;
					//	ワイルドカードの両端の空白を除去
					AjcStrTrimExW(t, t, stl, L" ");
					//	空白除去後のワールドカード文字列長設定（終端を含む）
					stl = (UI)wcslen(t) + 1;
					//	バッファポインタを再設定
					t += stl;
					q = t;
				}
				//	多重文字列終端設定
				*q = 0;
				//	検索処理
				GsefSearchW(&wk, pDir);
				//	バッファ解放
				free(wk.pWild);
			}
		}
	}
	return wk.Count;
}
//--------------------------------------------------------------------------------------------------------------//
static	VO	GsefSearchW(PWKENFILES pW, C_WCP pDir)
{
	UW		wild[MAX_PATH];
	UW		subd[MAX_PATH];
	UW		buf[MAX_PATH];
	UX		fh;
	struct	_wfinddata_t fd;

	AjcSnPrintFW(wild, MAX_PATH, L"%s", pDir);
	AjcPathCatW (wild, L"*.*", MAX_PATH);

	if (!pW->fEnd) {	
		if ((fh = _wfindfirst(wild, &fd)) != -1) {
			do {
				if (fd.attrib & _A_SUBDIR) {
					if (wcscmp(fd.name, L".") != 0 && wcscmp(fd.name, L"..") != 0) {
						//-- DIR名通知 ----//
						if (GsefSelectW(pW, pDir, fd.name)) {
							AjcSnPrintFW(buf, MAX_PATH, L"%s", pDir);
							AjcPathCatW (buf, fd.name, MAX_PATH);
							pW->fEnd = !pW->u.cbW(pW->Nest, buf, fd.name, fd.attrib, (UI)fd.time_write, pW->cbp);
							pW->Count++;
							if (pW->fEnd) break;
						}
						//-- サブDIR検索 --//
						if (pW->fSubDir) {
							AjcSnPrintFW(subd, MAX_PATH, L"%s", pDir);
							AjcPathCatW (subd, fd.name, MAX_PATH);
							//-- 検索DIR通知 --//
							if (fNotifySearchingDir || pW->fNtcDir) {
								pW->fEnd = !pW->u.cbW(-1, subd, L"", fd.attrib, (UI)fd.time_write, pW->cbp);
								if (pW->fEnd) break;
							}
							pW->Nest++;
							GsefSearchW(pW, subd);
							pW->Nest--;
							if (pW->fEnd) break;
						}
					}
				}
				else {
					if (GsefSelectW(pW, pDir, fd.name)) {
						//-- ファイル名通知 --//
						AjcSnPrintFW(buf, MAX_PATH, L"%s", pDir);
						AjcPathCatW (buf, fd.name, MAX_PATH);
						pW->fEnd = !pW->u.cbW(pW->Nest, buf, fd.name, fd.attrib, (UI)fd.time_write, pW->cbp);
						pW->Count++;
						if (pW->fEnd) break;
					}
				}
			} while (_wfindnext(fh, &fd) != -1);
			_findclose(fh);
		}
	}
}
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	GsefSelectW(PWKENFILES pW, C_WCP pDir, C_WCP pFName)
{
	BOOL	rc = FALSE;
	WCP		p;
	UI		i;
	UW		dir [MAX_PATH];		//	ディレクトリパス名（末尾に必ず'￥'を付加）
	UW		last[MAX_PATH];		//	末尾ディレクトリ名
	UW		wild[MAX_PATH];		//	ワイルドカード
	UI		dirL, lastL, wildL;

	if (pW->pWild != NULL && wcslen(pW->pWild) != 0) {
		p = pW->pWild;
		wcscpy(dir, pDir);
		AjcPathCatW(dir, L"", MAX_PATH);
		while (*p != 0) {
			//----- ワイルドパスをパスとワイルドカードに分離(ex "SUB1\SUB2\*.txt" --> "SUB1\SUB2\", "*.txt") ---//
			last[0] = 0;
			wild[0] = 0;
			for (i = (UI)wcslen(p) - 1; i > 0 && *(p + i) != L'\\'; i--);
			if (*(p + i) == L'\\') i++;
			memcpy(last, p, i * 2);
			last[i] = 0;
			wcscpy(wild, p + i);
			dirL  = (UI)wcslen(dir);
			lastL = (UI)wcslen(last);
			wildL = (UI)wcslen(wild);

			if ((lastL == 0 || (dirL >= lastL && wcsicmp(&dir[dirL - lastL], last) == 0)) && PathMatchSpecW(pFName, wild)) {
				rc = TRUE;
				break;
			}
			p += (wcslen(p) + 1);
		}
	}
	else {
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	Function	:	マイコンピュータ内のファイル名検索															//
//																												//
//	Argument	:	pPath	- 検索するディレクトリ名のアドレス（NULL指定時は全検索）							//
//					pWild	- ワイルドカード群のアドレス（複数時は';' or '/'で区切る。NULL指定時は全検索）		//
//					fRemote - TRUEを指定した場合ネットワークドライブも検索する									//
//					cbp		- コールバックパラメタ																//
//					cb		- 検索したファイルパス名を通知するためのコールバック関数のアドレス					//
//																												//
//	Return		:	検索されたファイル数																		//
//==============================================================================================================//
//----- バイト文字用 -------------------------------------------------------------------------------------------//
typedef struct {
	UX		cbp;
	BOOL	(CALLBACK *cb)(UI nest, BCP pPath, BCP pName, UI att, UI wtime, UX cbp);
	BOOL	rc;
} SMAPARAMA, *PSMAPARAMA;
//--------------------------------------------------------------------------------------------------------------//
static	BOOL CALLBACK	cbSMAA(UI nest, BCP pPath, BCP pName, UI att, UI wtime, UX cbp)
{
	PSMAPARAMA	p = (PSMAPARAMA)cbp;
	p->rc = p->cb(nest, pPath, pName, att, wtime, p->cbp);
	return p->rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	int		WINAPI	AjcSearchMyComputerA(C_BCP pPath, C_BCP pWild, BOOL fRemote, UX cbp, BOOL (CALLBACK *cbFind)(UI nest, BCP pPath, BCP pName, UI att, UI wtime, UX cbp))
{
	return AjcSearchMyComputerExA(pPath, pWild, fRemote, FALSE, cbp, cbFind);
}
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -//
AJCEXPORT	int		WINAPI	AjcSearchMyComputerExA(C_BCP pPath, C_BCP pWild, BOOL fRemote, BOOL fNtcDir, UX cbp, BOOL (CALLBACK *cbFind)(UI nest, BCP pPath, BCP pName, UI att, UI wtime, UX cbp))
{
	int			rc = 0;
	BC			drv;
	BC			path[MAX_PATH];
	UI			typ;
	SMAPARAMA	prm;

	prm.cbp = cbp;
	prm.cb	= cbFind;
	prm.rc	= TRUE;

	for (drv = 'c'; drv <= 'z'; drv++) {
		AjcSnPrintFA(path, MAX_PATH, "%c:\\", drv);
		typ = GetDriveTypeA(path);
		if (typ == DRIVE_FIXED	|| (fRemote && typ == DRIVE_REMOTE)) {
			if (pPath != NULL) AjcPathCatA(path, pPath, MAX_PATH);
			rc += AjcSearchFilesA(path, pWild, TRUE, (UX)&prm, cbSMAA);
			if (prm.rc == FALSE) break;
		}
	}
	return rc;
}
//----- ワイド文字用 -------------------------------------------------------------------------------------------//
typedef struct {
	UX		cbp;
	BOOL	(CALLBACK *cb)(UI nest, WCP pPath, WCP pName, UI att, UI wtime, UX cbp);
	BOOL	rc;
} SMAPARAMW, *PSMAPARAMW;
//--------------------------------------------------------------------------------------------------------------//
static	BOOL CALLBACK	cbSMAW(UI nest, WCP pPath, WCP pName, UI att, UI wtime, UX cbp)
{
	PSMAPARAMW	p = (PSMAPARAMW)cbp;
	p->rc = p->cb(nest, pPath, pName, att, wtime, p->cbp);
	return p->rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	int		WINAPI	AjcSearchMyComputerW(C_WCP pPath, C_WCP pWild, BOOL fRemote, UX cbp, BOOL (CALLBACK *cbFind)(UI nest, WCP pPath, WCP pName, UI att, UI wtime, UX cbp))
{
	return AjcSearchMyComputerExW(pPath, pWild, fRemote, FALSE, cbp, cbFind);
}
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -//
AJCEXPORT	int		WINAPI	AjcSearchMyComputerExW(C_WCP pPath, C_WCP pWild, BOOL fRemote, BOOL fNtcDir, UX cbp, BOOL (CALLBACK *cbFind)(UI nest, WCP pPath, WCP pName, UI att, UI wtime, UX cbp))
{
	int			rc = 0;
	UW			drv;
	UW			path[MAX_PATH];
	UI			typ;
	SMAPARAMW	prm;

	prm.cbp = cbp;
	prm.cb	= cbFind;
	prm.rc	= TRUE;

	for (drv = L'c'; drv <= L'z'; drv++) {
		AjcSnPrintFW(path, MAX_PATH, L"%c:\\", drv);
		typ = GetDriveTypeW(path);
		if (typ == DRIVE_FIXED	|| (fRemote && typ == DRIVE_REMOTE)) {
			if (pPath != NULL) AjcPathCatW(path, pPath, MAX_PATH);
			rc += AjcSearchFilesW(path, pWild, TRUE, (UX)&prm, cbSMAW);
			if (prm.rc == FALSE) break;
		}
	}
	return rc;
}
