﻿#include	"AjcInternal.h"

//	英字名を含む全フォント情報収集

#define	TAG(A, B, C, D)  ((A << 0) + (B << 8) + (C << 16) + (D << 24))

//--------------------------------------------------------------------------------------------------------------//
//	拡張フォント情報																							//
//--------------------------------------------------------------------------------------------------------------//
//	'fvar' ヘッダ部
typedef union {
	UW		arr[8];
	struct {
		UW	majorVersion;
		UW	minorVersion;
		UW	axesArrayOffset;
		UW	reserved;
		UW	axisCount;
		UW	axisSize;
		UW	instanceCount;
		UW	instanceSize;
	} s;
} FVAR, *PFVAR;

//	'name' ヘッダ部
typedef union {
	UW		arr[6];
	struct {
		UW	platformId;
		UW	encodingId;
		UW	languageId;
		UW	nameId;
		UW	length;
		UW	stringOffset;
	} s;
} NAMES, *PNAMES;

//	'name' 拡張部
typedef struct {
	union {
		UW		arr[3];
		struct {
			UW	formatSelector;
			UW	nameRecordsCount;
			UW	storageOffset;
		} s;
	} u;
	NAMES	names[1];
} NAME, *PNAME;

//--------------------------------------------------------------------------------------------------------------//
//	作業領域																									//
//--------------------------------------------------------------------------------------------------------------//
static	HAJCAVS		hAvsFontList	= NULL;
static	UI			Count			= 0;
//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
static	int	CALLBACK cbEnumProc(const LOGFONTW *lpelfe, const TEXTMETRICW *lpntme, DWORD FontType, LPARAM lParam);
static	C_WCP		 SubRegistFontInfo(C_WCP pFontName, PCAJCFIFNODE pNode, UB flag);
static	VOP			 SubGetFontData(const LOGFONT *pLf, UI table);
static	WCP			 SubGetName(UW platformId, WCP pDat, UI len);

//==============================================================================================================//
//	英字名を含む全フォント情報収集																				//
//																												//
//	引　数	：	hAvs	-	英字名を含む全フォント情報格納するＡＶＳハンドル									//
//																												//
//	戻り値	：	≠０：フォント情報の個数																		//
//				＝０：失敗																						//
//==============================================================================================================//
UI	CorrectAllFonts(HAJCAVS hAvs)
{
	HDC		hdc = GetDC(NULL);
	LOGFONT	lf = {0};

	//	カウンタクリアー
	Count = 0;
	//	ＡＶＳハンドル退避
	hAvsFontList = hAvs;
	//	フォント列挙
	lf.lfCharSet = DEFAULT_CHARSET;
	EnumFontFamiliesExW(hdc, &lf, cbEnumProc, 0, 0);
	//	ＤＣ解放
	ReleaseDC(NULL, hdc);

	return Count;
}

//--------------------------------------------------------------------------------------------------------------//
static	int		CALLBACK cbEnumProc(const LOGFONTW *pLf, const TEXTMETRICW *pTm, DWORD FontType, LPARAM lParam)
{
	const ENUMLOGFONTEXDV *pExdv = (const ENUMLOGFONTEXDV *)pLf;
	const ENUMLOGFONTEX   *pEx   = &pExdv->elfEnumLogfontEx;

	HAJCAVL			hAvlSubFamilyNameIds = AjcAvlCreate(0, NULL, NULL);
	HAJCAVS			hAvsSubFamilyNames   = AjcAvsCreate(AJCCMP_IGNORE_WIDTH, 0, NULL);

	PFVAR			pFvar  = NULL;
	PNAME			pName  = NULL;
	PNAMES			pNames = NULL;
	UI				i, j;
	BCP				pStr;
	UBP				pSubfamilyNameId;
	WCP				pFamilyName = NULL;
	AJCFIFNODE		node;
	C_WCP			pOrg = NULL;

	//	フォント情報初期化
	memset(&node, 0, sizeof node);
	node.PitchAndFamily = pEx->elfLogFont.lfPitchAndFamily;
	node.CharSet        = pEx->elfLogFont.lfCharSet;
	node.pOrgName       = NULL;
	//	オリジナルのフォント情報登録
	pOrg = SubRegistFontInfo(pEx->elfLogFont.lfFaceName, &node, AJCFIF_ORG);

	//	フォント英語名収集
	if (hAvlSubFamilyNameIds != NULL && hAvsSubFamilyNames != NULL) {
		if (pEx->elfFullName[0] != 0 && pEx->elfFullName[0] != '@' && FontType != RASTER_FONTTYPE) {
			//	フォント情報ノード初期化
			memset(&node, 0, sizeof node);
			node.PitchAndFamily = pEx->elfLogFont.lfPitchAndFamily;
			node.CharSet        = pEx->elfLogFont.lfCharSet;
			//	FVAR
			if (pFvar = (PFVAR)SubGetFontData(pLf, TAG('f', 'v', 'a', 'r'))) {
				union {UBP ubp; UWP uwp;} pSfid;
				//	ヘッダ部 BE->LE変換
				for (i = 0; i < 8; i++) {
					pFvar->arr[i] = AjcExcWord(pFvar->arr[i]);
				}
				//	拡張部スキップ
				pSubfamilyNameId = (UBP)pFvar;
				pSubfamilyNameId +=	(sizeof(FVAR) + (pFvar->s.axisCount * pFvar->s.axisSize));
				//	サブファミリＩＤ収集
				for (i = 0, pSfid.ubp = pSubfamilyNameId; i < pFvar->s.instanceCount; i++, pSfid.ubp += pFvar->s.instanceSize) {
					*pSfid.uwp = AjcExcWord(*pSfid.uwp);
					AjcAvlInsNode(hAvlSubFamilyNameIds, *pSfid.uwp, NULL, 0);
				}
			}
			//	NAME
			if (pName = (PNAME)SubGetFontData(pLf, TAG('n', 'a', 'm', 'e'))) {
				//	ヘッダ部 BE->LE変換
				for (i = 0; i < 3; i++) {
					pName->u.arr[i] = AjcExcWord(pName->u.arr[i]);
				}
				//	ファミリ名，サブファミリ名収集
				for (i = 0; i < pName->u.s.nameRecordsCount; i++) {
					for (j = 0; j < 6; j++) {
						pName->names[i].arr[j] = AjcExcWord(pName->names[i].arr[j]);
					}
					pStr = (BCP)pName;
					pNames = &pName->names[i];
					pStr = pStr + pName->u.s.storageOffset + pName->names[i].s.stringOffset;

					if (pNames->s.languageId == 0x0409) {
						//	ファミリ名設定
						if (pNames->s.nameId == 1) {
							WCP	pFamily = SubGetName(pNames->s.platformId,
													 (WCP)((UBP)pName + (pName->u.s.storageOffset + pNames->s.stringOffset)),
													 pNames->s.length);
							if (pFamily != NULL) {
								//	初回ファミリ名の場合、ファミリ名退避
								if (pFamilyName == NULL) {
									pFamilyName = pFamily;
								}
								//	２回目以降のファミリ名検出の場合・・
								else {
									//	同一ファミリ名ならば、重複ファミリ名破棄
									if (wcscmp(pFamilyName, pFamily) == 0) {
										free(pFamily);
									}
									//	異なるファミリ名ならば・・（この条件は発生しないハズ）
									else {
										//	旧ファミリ名破棄
										free(pFamilyName);
										pFamilyName = NULL;
										//	ファミリ名退避
										pFamilyName = pFamily;
									}
								}
							}
						}
						//	サブファミリ名収集
						if (AjcAvlGetNodePtr(hAvlSubFamilyNameIds, pNames->s.nameId, NULL) != NULL) {
							WCP pStyle = SubGetName(pNames->s.platformId,
													(WCP)((UBP)pName + (pName->u.s.storageOffset + pNames->s.stringOffset)),
													pNames->s.length);
							if (pStyle != NULL) {
								AjcAvsInsNode(hAvsSubFamilyNames, pStyle, NULL, 0);
								free(pStyle);
							}
						}
					}
				}
			}
			//	フォント名を生成し蓄積
			if (pFamilyName != NULL) {
				UI			n;
				PCAJCAVSPTR pTop, p;
				//	英語名→オリジナル名ポインタ設定
				node.pOrgName = pOrg;
				//	フォントファミリ名ノード登録
				SubRegistFontInfo(pFamilyName, &node, AJCFIF_ENG);
				//	フォントサブファミリ名収集
				if (pTop = p = AjcAvsCreatePtrArr(hAvsSubFamilyNames, &n, FALSE)) {
					for (i = 0; i < n; i++, p++) {
						WC	txt[512];
						AjcSnPrintF(txt, AJCTSIZE(txt), L"%s %s", pFamilyName, p->pKey);
						//	フォントサブファミリ名ノード登録
						SubRegistFontInfo(txt, &node, AJCFIF_ENG | AJCFIF_SUB);
					}
					AjcAvsReleasePtrArr(hAvsSubFamilyNames, pTop);
				}
				free(pFamilyName);
				pFamilyName = FALSE;
			}
			else {
				//	AjcPrintF(L"英語名無し（%s）\n", pEx->elfFullName);
			}
		}
	}
	if (hAvlSubFamilyNameIds != NULL) AjcAvlDelete(hAvlSubFamilyNameIds);
	if (hAvsSubFamilyNames   != NULL) AjcAvsDelete(hAvsSubFamilyNames);
	if (pFvar                != NULL) free(pFvar);
	if (pName                != NULL) free(pName);

	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
static	C_WCP SubRegistFontInfo(C_WCP pFontName, PCAJCFIFNODE pNode, UB flag)
{
	C_WCP		rc = NULL;
	AJCFIFNODE	node;
	VOP			pNodePtr;

	//	未登録フォント名ならば、新規登録
	if (AjcAvsGetNode(hAvsFontList, pFontName, &node, sizeof node) == -1) {
		memcpy(&node, pNode, sizeof node);
		node.flag = flag;
		AjcAvsInsNode(hAvsFontList, pFontName, &node, sizeof node);
		Count++;
	}
	//	登録済みフォント名ならば、フラグ更新
	else {
		node.flag |= flag;
		AjcAvsRepNode(hAvsFontList, pFontName, &node, sizeof node);
	}
	if (pNodePtr = AjcAvsGetNodePtr(hAvsFontList, pFontName, NULL)) {
		rc = (C_WCP)AjcAvsGetNodeKey(hAvsFontList, pNodePtr);
	}
	return rc;
}

//--------------------------------------------------------------------------------------------------------------//
static	VOP	SubGetFontData(const LOGFONT *pLf, UI table) 
{
	VOP		rc = NULL;
	HDC		hdc, mdc;
	HFONT	hFSv;
	UI		sz;

	hdc  = GetDC(NULL);
	mdc  = CreateCompatibleDC(hdc);
	hFSv = SelectObject(mdc, CreateFontIndirect(pLf));

	do {
		if ((sz = GetFontData(mdc, table, 0, NULL,  0)) == GDI_ERROR) break;
		if ((rc = malloc(sz))                           == NULL     ) break;
		if ((sz = GetFontData(mdc, table, 0, rc  , sz)) == GDI_ERROR) break;
	} while(0);

	DeleteObject(SelectObject(mdc, hFSv));
	DeleteDC(mdc);
	ReleaseDC(NULL, hdc);

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
static	WCP	SubGetName(UW platformId, WCP pDat, UI len)
{
	WCP		rc = NULL;

	switch (platformId) {
		// Unicode: Probably, needs to handle the original data as a UTF-8 text.
		case 0:
			break;

		// Machintosh: Omitted in this sample since it is too complex.
		case 1:
			break;

		// Windows: Handle the original data as a UTF-16BE text.
		case 3:
		{	WCP		p, q;
			UI		lUni = len / 2;
			UI		i;
			if (rc = (WCP)malloc(len + 2)) {
				for (i = 0, p = pDat, q = rc; i < lUni; i++, p++, q++) {
					*q = (WC)AjcExcWord(*p);
				}
				*q = 0;
			}
		}
		break;
	}
	return rc;
}


