﻿#include	"AjcInternal.h"

///************************************************************************************************************///
//																												//
//	ヒープソート																								//
//																												//
///************************************************************************************************************///

//==============================================================================================================//
//	Function	:	ヒープソート																				//
//																												//
//	Argument	:	pBase  - ソートする配列の先頭アドレス														//
//					num    - 配列の要素数																		//
//					width  - 配列要素のサイズ（バイト数）														//
//					cbp    - コールバックパラメタ																//
//					cbComp - 配列要素の比較用コールバック														//
//																												//
//	Return		:	TRUE  - OK																					//
//					FALSE - 中止／エラー																		//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcHeapSort(VOP pBase, UI num, UI width, UX cbp, int (CALLBACK *cbComp)(C_VOP pElm1, C_VOP pElm2, BOOL *pStop, UX cbp))
{
	BOOL	rc = TRUE;
	UI		i, j, k;
	VOP		pWork = NULL;
	BOOL	fStop = FALSE;

	if (pBase != NULL && width > 0 && cbComp != NULL) {
		if (num >= 2) {
			if (pWork = AJCMEM(width)) {
				fStop = FALSE;
				num--;
				k = num / 2;
				do {
					i = k; memcpy(pWork, ((UB*)pBase) + (width * i), width);
					while ((j = 2 * i + 1) <= num) {
						if (j < num && cbComp(((UB*)pBase) + (width * j), ((UB*)pBase) + (width * (j + 1)), &fStop, cbp) < 0) j++;
						if (cbComp(pWork, ((UB*)pBase) + (width * j), &fStop, cbp) >= 0) break;
						memcpy(((UB*)pBase) + (width * i), ((UB*)pBase) + (width * j), width);
						i = j;
					}
					memcpy(((UB*)pBase) + (width * i), pWork, width);
				} while (k-- != 0  &&  !fStop);

				while (num > 0  &&  !fStop) {
					memcpy(pWork, ((UB*)pBase) + (width * num), width);
					memcpy(((UB*)pBase) + (width * num), pBase, width);
					num--;
					i = 0;
					while ((j = 2 * i + 1) <= num  &&  !fStop) {
						if (j < num && cbComp(((UB*)pBase) + (width * j), ((UB*)pBase) + (width * (j + 1)), &fStop, cbp) < 0) j++;
						if (cbComp(pWork, ((UB*)pBase) + (width * j), &fStop, cbp) >= 0) break;
						memcpy(((UB*)pBase) + (width * i), ((UB*)pBase) + (width * j), width);
						i = j;
					}
					memcpy(((UB*)pBase) + (width * i), pWork, width);
				}
				free(pWork);
			}
			else rc = FALSE;
		}
	}
	else rc = FALSE;

	if (fStop) rc = FALSE;

	return rc;

}
