﻿#include	"AjcInternal.h"

//==============================================================================================================//
//	イメージデータ読み出し																						//
//																												//
//	引　数	：	pImgInfo	- イメージ情報を格納するバッファのアドレス											//
//				szFileName	- イメージファイル・パス名															//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcImgFuncReadA(PAJC_IMGINFO pImgInfo, C_BCP pFilePath)
{
	BOOL	rc = FALSE;
	int		len;
	WCP		pTmp;

	if (pFilePath != NULL) {
		len = MultiByteToWideChar(CP_ACP, 0, pFilePath, -1, NULL, 0);
		if (len != 0 && (pTmp = AjcTAlloc(len))) {
			MultiByteToWideChar(CP_ACP, 0, pFilePath, -1, pTmp, len);
			rc = AjcImgFuncReadW(pImgInfo, pTmp);
			free(pTmp);
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcImgFuncReadW(PAJC_IMGINFO pImgInfo, C_WCP pFilePath)
{
	BOOL	rc = FALSE;
	WC		ext[_MAX_EXT];

	if (pImgInfo != NULL && pFilePath != NULL) {
		//----- イメージ情報クリアー ---------------------------------------------------------------------------//
		memset(pImgInfo, 0, sizeof(AJC_IMGINFO));
		//----- イメージファイル拡張子抽出 ---------------------------------------------------------------------//
		_wsplitpath(pFilePath, NULL, NULL, NULL, ext);

		//----- イメージファイル読み出し -----------------------------------------------------------------------//
		if (wcsicmp(ext, L".bmp") == 0) {
			pImgInfo->hBmp = AjcCreateDibFromFile(pFilePath, (UIP)&pImgInfo->width, (UIP)&pImgInfo->height, NULL, NULL);
			rc = pImgInfo->fValid = (pImgInfo->hBmp != NULL);
		}
		if (wcsicmp(ext, L".bmp") != 0	||	rc == FALSE)	 {
			IShellImageDataFactory	*pShellImageDataFactory = NULL;
			IShellImageData			*pShellImageData		= NULL;
			SIZE					sz;
			do {
				if (CoCreateInstance(CLSID_ShellImageDataFactory, NULL, CLSCTX_INPROC_SERVER, IID_PPV_ARGS(&pShellImageDataFactory)) != S_OK) break;
				if (pShellImageDataFactory->CreateImageFromFile(pFilePath, (IShellImageData **)&pShellImageData)					 != S_OK) break;
				if (pShellImageData->Decode(SHIMGDEC_DEFAULT, 0, 0) 																 != S_OK) break;
				if (pShellImageData->GetSize(&sz)																					 != S_OK) break;
				pImgInfo->hFactory = pShellImageDataFactory;
				pImgInfo->hImg	   = pShellImageData;
				pImgInfo->width    = sz.cx;
				pImgInfo->height   = sz.cy;
				pImgInfo->fValid   = TRUE;
				rc				   = TRUE;
			} while(0);
			//	エラー時はIShellImageDataFactoryを解放
			if (!rc && pImgInfo->hFactory != NULL) {
				((IShellImageDataFactory*)pImgInfo->hFactory)->Release();
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	イメージ描画																								//
//																												//
//	引　数	：	hdc			- 描画するデバイス・コンテキスト（描画先）											//
//				pImgInfo	- イメージ情報のアドレス		（描画元）											//
//				pSrc		- 描画元の長方形領域																//
//				hdc			- 描画先のＤＣ																		//
//				pDst		- 描画先の長方形領域																//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcImgFuncDraw(PAJC_IMGINFO pImgInfo, LPRECT pSrc, HDC hdc, LPRECT pDst)
{
	BOOL	rc = FALSE;
	HDC		hmd;

	if (pImgInfo != NULL && pSrc != NULL && hdc != NULL && pDst != NULL) {
		if (pImgInfo->fValid) {
			if		(pImgInfo->hBmp != NULL) {
				hmd = CreateCompatibleDC(hdc);
				SelectObject(hmd, pImgInfo->hBmp);
				StretchBlt(hdc, pDst->left, pDst->top, pDst->right - pDst->left , pDst->bottom - pDst->top,
						   hmd, pSrc->left, pSrc->top, pSrc->right - pSrc->left , pSrc->bottom - pSrc->top, SRCCOPY);
				DeleteDC(hmd);
				rc = TRUE;
			}
			else if (pImgInfo->hImg != NULL) {
				IShellImageData	*pShellImageData = (IShellImageData *)pImgInfo->hImg;
				if (pShellImageData->Draw(hdc, pDst, pSrc) == S_OK) {
					rc = TRUE;
				}
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	イメージデータ解放																							//
//																												//
//	引　数	：	pImgInfo	- イメージ情報のアドレス															//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT	 BOOL	WINAPI	AjcImgFuncRelease(PAJC_IMGINFO pImgInfo)
{
	BOOL	rc = FALSE;

	if (pImgInfo != NULL) {
		if (pImgInfo->fValid) {
			if (pImgInfo->hBmp != NULL) {
				DeleteObject(pImgInfo->hBmp);
				pImgInfo->hBmp = NULL;
				rc = TRUE;
			}
			else if (pImgInfo->hFactory != NULL) {
				IShellImageDataFactory	*pShellImageDataFactory = (IShellImageDataFactory *)pImgInfo->hFactory;
				pShellImageDataFactory->Release();
				pImgInfo->hFactory = NULL;
				pImgInfo->hImg	   = NULL;
				rc = TRUE;
			}
			pImgInfo->fValid = FALSE;
		}
	}
	return rc;
}

