﻿#ifndef	AJRCTLINTERNAL_H_
#define	AJRCTLINTERNAL_H_
/****************************************************************************************************************/

#pragma warning(disable:4996)

#include	"resource.h"

#ifndef _WIN64
#include	<AjrCst32.h>
#else
#include	<AjrCst64.h>
#endif

#include	<winnls.h>
#include	<stdio.h>
#include	<fcntl.h>
#include	<shlwapi.h>
#include	<mbctype.h>
#include	<mbstring.h>
#include	<locale.h>
#include	<shlwapi.h>
#include	<shellapi.h>
#include	<shlobj.h>
#include	<sys\types.h>
#include	<sys\stat.h>
#include	<stdio.h>
#include	<io.h>
#include	<sys\stat.h>
#include	<math.h>
#include	<limits.h>
#include	<float.h>
#include	<process.h>
#include	<conio.h>
#include	<mbstring.h>
#include	<Imagehlp.h>
#include	<shlobj.h>
#include	<setupapi.h>
#include	<tlhelp32.h>
#include	<shimgdata.h>
#include	<psapi.h>
#include	<Sddl.h>
#include	<CRTDBG.H>

//--------------------------------------------------------------------------------------------------------------//
//	ウインドに関連付けられたプロパティ名（SetProp() / GetProp()用）												//
//--------------------------------------------------------------------------------------------------------------//
#define	PN_SBCCBO		L"_AJC_SBC_CBO"						//	サブクラス化したコンボボックス

//--------------------------------------------------------------------------------------------------------------//
//	グローバルワーク																							//
//--------------------------------------------------------------------------------------------------------------//
extern	HINSTANCE	hDllInst;								//	ＤＬＬインスタンス
extern	HINSTANCE	hExeInst;								//	ＥＸＥインスタンス
extern	UL			MyProcessId;							//	自プロセスＩＤ
extern	BOOL		fExitProcess;							//	プロセスの終了を示すフラグ
extern	OSVERSIONINFO VerOs;								//	ＯＳバージョン情報
extern	int			LangId;									//	言語種別
extern	CPINFOEX	CpInfo;									//	コードページ情報
#define	CP_932		932										//	コードページ９３２（S-JIS)
extern	WC			szMyMbc[32];							//	コードページを表す文字列(ex "MBC(S-JIS)" / "MBC(CPnnn)")
extern	BOOL		fCmdWithHdl;							//	コントロールからの通知（WM_COMMAND）モード
															//		FALSE : lParam = イベントパラメタ
															//		TRUE  : lParam = コントロールのウインドハンドル
extern	WC			MyDirPath[MAX_PATH];					//	自ＤＬＬのディレクトリパス名
extern	WC			AppPath  [MAX_PATH];					//	アプリケーションパス名	  （ex. "d:\work\Sample.exe")
extern	WC			AppFName [MAX_PATH];					//	アプリケーションファイル名（ex. "Sample.exe"）
extern	WC			AppName  [MAX_PATH];					//	アプリケーション名		  （ex. "Sample"）

extern	BC			VersionStrA[16];						//	バージョン文字列（バイト文字）
extern	WC			VersionStrW[16];						//	バージョン文字列（ワイド文字）

//----- アイコン -----------------------------------------------------------------------------------------------//
extern	HICON		hIcoWide;								//	ワイド
extern	HICON		hIcoZoom;								//	ズーム
extern	HICON		hIcoForward;							//	右移動（右方向三角）
extern	HICON		hIcoBackward;							//	左移動（左方向三角）
extern	HICON		hIcoWrench;								//	レンチ
extern	HICON		hIcoClock;								//	時計マーク
extern	HICON		hIcoReset;								//	リセット／更新
extern	HICON		hIcoWipe;								//	ワイパー

//----- ビットマップ -------------------------------------------------------------------------------------------//
extern	HBITMAP		hBmpCls;								//	画面クリアー

//----- 共通描画オブジェクト -----------------------------------------------------------------------------------//
extern	HICON	hIcoApp;		//	ＡＰＰアイコン
extern	HBRUSH	hBruBtnFace;	//	コントロールの背景色ブラシ
extern	HPEN	hPenBtnFace;	//	コントロールの背景色ペン
extern	HPEN	hPenGrayText;	//	グレーテキストペン
extern	HPEN	hPenScale;		//	グラフのスケール色ペン

extern	HBRUSH	hBruRed;		//	ブラシ（赤）
extern	HPEN	hPenRed;		//	ペン　（赤）

extern	HFONT	hDefFontFix10;	//	デフォルトフォントハンドル（固定ピッチ）
extern	HFONT	hDefFontFix12;	//			〃				  （	〃	  ）
extern	HFONT	hDefFontFix14;	//			〃				  （	〃	  ）
extern	HFONT	hDefFontFix16;	//			〃				  （	〃	  ）
extern	HFONT	hDefFontFix18;	//			〃				  （	〃	  ）
extern	HFONT	hDefFontFix20;	//			〃				  （	〃	  ）
extern	HFONT	hDefFontFix22;	//			〃				  （	〃	  ）
extern	HFONT	hDefFontFix24;	//			〃				  （	〃	  ）
#define	hDefFontFix	hDefFontFix12

extern	HFONT	hDefFontVar10;	//	デフォルトフォントハンドル（可変ピッチ）
extern	HFONT	hDefFontVar12;	//			〃				  （	〃	  ）
extern	HFONT	hDefFontVar14;	//			〃				  （	〃	  ）
extern	HFONT	hDefFontVar16;	//			〃				  （	〃	  ）
extern	HFONT	hDefFontVar18;	//			〃				  （	〃	  ）
extern	HFONT	hDefFontVar20;	//			〃				  （	〃	  ）
extern	HFONT	hDefFontVar22;	//			〃				  （	〃	  ）
extern	HFONT	hDefFontVar24;	//			〃				  （	〃	  ）
#define	hDefFontVar	hDefFontVar12

//--------------------------------------------------------------------------------------------------------------//
//	マクロ																										//
//--------------------------------------------------------------------------------------------------------------//
#define		ISJPN				(AjcGetLangId() == AJCLID_JPN)
#define		LNGSEL(JPN, ENG)	(ISJPN ? JPN : ENG)

#define	IS_WIN9XME		 (VerOs.dwMajorVersion <= 4)
#define	IS_WIN2KXP		 (VerOs.dwMajorVersion >= 5)
#define	IS_WINXP		((VerOs.dwMajorVersion == 5 && VerOs.dwMinorVersion >= 1) || (VerOs.dwMajorVersion >= 6))
#define	IS_WINVISTA		 (VerOs.dwMajorVersion >= 6)
#define	IS_WIN7			((VerOs.dwMajorVersion == 6 && VerOs.dwMinorVersion >= 1) || (VerOs.dwMajorVersion >= 7))
#define	IS_WIN8			((VerOs.dwMajorVersion == 6 && VerOs.dwMinorVersion >= 2) || (VerOs.dwMajorVersion >= 7))

#define	MALLOC		AJCMEM
#define	FREE		AJCFREE

//	色コード
#define	RGB_BLACK		RGB(  0,   0,	0)
#define	RGB_RED			RGB(255,   0,	0)
#define	RGB_GREEN		RGB(  0, 255,	0)
#define	RGB_BLUE		RGB(  0,   0, 255)
#define	RGB_WHITE		RGB(255, 255, 255)


//	バイト文字ファンクション用文字列バッファ割り当て
#define	BCF_ALLOC(XXX)	if (XXX != NULL) {										\
							UI	stl = (UI)AjcByteCharToWideChar(XXX, NULL, 0);	\
							if (XXX##W = AjcTAllocW(stl)) {						\
								AjcByteCharToWideChar(XXX, XXX##W, stl);		\
							}													\
							else break;											\
						}														\
						else XXX##W = NULL


//--------------------------------------------------------------------------------------------------------------//
//	起動時初期設定／終了時後処理ファンクション																	//
//--------------------------------------------------------------------------------------------------------------//
extern	BOOL	AjcStcInit(VO);
extern	VO		AjcStcEnd (VO);

extern	BOOL	AjcCtrlInpValInit(VO);
extern	VO		AjcCtrlInpValEnd (VO);

extern	BOOL	AjcCtrlTmChartInit(VO);
extern	VO		AjcCtrlTmChartEnd (VO);

extern	BOOL	AjcCtrl3dGraphInit(VO);
extern	VO		AjcCtrl3dGraphEnd (VO);

extern	BOOL	AjcCtrlVT100Init(VO);
extern	VO		AjcCtrlVT100End (VO);

extern	BOOL	AjcCtrlTextEditInit(VO);
extern	VO		AjcCtrlTextEditEnd (VO);

extern	BOOL	AjcCtrlLogFileInit(VO);
extern	VO		AjcCtrlLogFileEnd (VO);

extern	BOOL	AjcCtrlBarGraphInit(VO);
extern	VO		AjcCtrlBarGraphEnd (VO);

extern	BOOL	AjcCtrlSerialCommInit(VO);
extern	VO		AjcCtrlSerialCommEnd (VO);

extern	BOOL	AjcCtrlSerialComPInit(VO);
extern	VO		AjcCtrlSerialComPEnd (VO);

extern	BOOL	AjcCtrlSockServerInit(VO);
extern	VO		AjcCtrlSockServerEnd (VO);

extern	BOOL	AjcCtrlSockClientInit(VO);
extern	VO		AjcCtrlSockClientEnd (VO);

extern	BOOL	AjcCtrlPowMgInit(VO);
extern	VO		AjcCtrlPowMgEnd(VO);

extern	BOOL	AjcCtrlListBoxInit(VO);
extern	VO		AjcCtrlListBoxEnd (VO);

extern	BOOL	AjcTipTxtInit(VO);
extern	VO		AjcTipTxtEnd (VO);

extern	BOOL	AjcTipCtlInit(VO);
extern	VO		AjcTipCtlEnd (VO);

extern	BOOL	AjcCipInit(VO);
extern	VO		AjcCipEnd(VO);

extern	BOOL	AjcPopupMenuInit(VO);
extern	VO		AjcPopupMenuEnd (VO);

extern	BOOL	AjcConInpInit(VO);
extern	VO		AjcConInpEnd(VO);

extern	BOOL	AjcWndItemPermInit(VO);
extern	VO		AjcWndItemPermEnd (VO);

extern	BOOL	AjcTimeMeasureInit(VO);
extern	VO		AjcTimeMeasureEnd (VO);

extern	BOOL	AjcProfileInit(VO);
extern	VO		AjcProfileEnd (VO);

extern	BOOL	AjcCfInit(VO);
extern	VO		AjcCfEnd (VO);

extern	BOOL	AjcDgcInit(VO);
extern	VO		AjcDgcEnd (VO);

extern	BOOL	AjcWatInit(VO);
extern	VO		AjcWatEnd (VO);

extern	BOOL	AjcTxoInit(VO);
extern	VO		AjcTxoEnd (VO);

//--------------------------------------------------------------------------------------------------------------//
//	外部サブ関数（AjcCtrlXXXX内 共通サブ関数）																	//
//--------------------------------------------------------------------------------------------------------------//
extern	UI		SubGetTipTextA(C_WCP pTip[], UI ix, BCP pBuf, UI lBuf);
extern	UI		SubGetTipTextW(C_WCP pTip[], UI ix, WCP pBuf, UI lBuf);

extern	BOOL	SubSetTipTextA(WCP pTip[], UI ix, C_BCP pTxt);
extern	BOOL	SubSetTipTextW(WCP pTip[], UI ix, C_WCP pTxt);


//	タイトル描画情報
typedef struct {
	HBITMAP		hBmpEna;	//	タイトルのビットマップ（ウインド許可状態時）
	HBITMAP		hBmpDis;	//		〃				  （ウインド禁止状態時）
	SIZE		szBmp;		//	タイトルのビットマップのサイズ
} CTRL_TTLINFO, *PCTRL_TTLINFO;
typedef const CTRL_TTLINFO *PCCTRL_TTLINFO;

//	タイトル描画用サブ関数
extern	BOOL	SubTtlBmpMake (PCTRL_TTLINFO  pT, HWND hwnd, C_WCP pTtlTxt, COLORREF txtColor, COLORREF bakColor, HFONT hFont);
extern	BOOL	SubTtlBmpDraw (PCCTRL_TTLINFO pT, HWND hwnd, HDC hdc, int y, int rMargin, BOOL fEnable);
extern	BOOL	SubTtlBmpDrawC(PCCTRL_TTLINFO pT, HWND hwnd, HDC hdc, int y, int rMargin, BOOL fEnable, COLORREF BkColor);
extern	BOOL	SubTtlBmpRemv (PCTRL_TTLINFO  pT);

//--------------------------------------------------------------------------------------------------------------//
//	外部サブ関数（AjcTipCtrl, AjcTipText共通サブ関数）															//
//--------------------------------------------------------------------------------------------------------------//
extern	BOOL	 AjcTipTextShowExInternal(int x, int y, int minWidth, int height, C_WCP pTxt, int msTime, HFONT hFont,
											 COLORREF TextColor, COLORREF BackGround, COLORREF BorderColor, HWND hCaller);

//----- 動的メッセージ定数 --------------------------------------------------------------------------------------//
#define	MSGSTR_NTC_TIPCHANGED	L"AjcCtrlXX_TipChanged"

//--------------------------------------------------------------------------------------------------------------//
//	AjrPowMg32/64との共通定義																					//
//--------------------------------------------------------------------------------------------------------------//
/*----- コマンドコード(wParam) ---------------------------------------------------------------------------------*/
												/*									lParam						*/
#define		AJCPMG_MSG_SETLATENCY		0x02	/*	電源復旧所要時間の設定			minute						*/
#define		AJCPMG_MSG_DISPLAY_ON		0x03	/*	ディスプレィの表示状態			TRUE / FALSE				*/
#define		AJCPMG_MSG_SHOW				0x04	/*	ウインド表示												*/
#define		AJCPMG_MSG_HIDE				0x05	/*	ウインド非表示												*/
#define		AJCPMG_MSG_EXIT_PROGRAM		0x0F	/*	プログラム終了					-							*/


#define		AJCPMG_MSG_CLEAR			0x10	/*	スケジュール クリアー		（WM_COPYDATA）					*/
#define		AJCPMG_MSG_RESUME			0x11	/*	電源復旧のスケジュール		（WM_COPYDATA）					*/
#define		AJCPMG_MSG_SCHEDULE			0x12	/*	プログラム実行スケジュール	（WM_COPYDATA）					*/

/*----- 年コード -----------------------------------------------------------------------------------------------*/
#define		AJCPMG_YEAR_WEEKLY			9000	/*	週間指定													*/

/*----- AjrPowMg32/64.exeとの共通サブ関数 ----------------------------------------------------------------------*/
AJCEXPORT	BOOL	WINAPI	AjcPmgSubTimeToStr(LPSYSTEMTIME pTime, BCP pStr, int lStr);
AJCEXPORT	BOOL	WINAPI	AjcPmgSubIsTimeValid(LPSYSTEMTIME pTime);


//--------------------------------------------------------------------------------------------------------------//
//	ラジオボタン統合化グループを示すプロパティ																	//
//--------------------------------------------------------------------------------------------------------------//
#ifdef UNICODE
	#define	SBCRADIOBTNS_GROUP_PROPNAME		SBCRADIOBTNS_GROUP_PROPNAMEW
#else
	#define	SBCRADIOBTNS_GROUP_PROPNAME		SBCRADIOBTNS_GROUP_PROPNAMEA
#endif

#define		SBCRADIOBTNS_GROUP_PROPNAMEA		 "SbcRadioBtns"
#define		SBCRADIOBTNS_GROUP_PROPNAMEW		L"SbcRadioBtns"

/*==============================================================================================================*/
/*																												*/
/*	制御文字コード																								*/
/*																												*/
/*==============================================================================================================*/
#define		CC_NUL		0x00
#define		CC_SOH		0x01
#define		CC_STX		0x02
#define		CC_ETX		0x03
#define		CC_EOT		0x04
#define		CC_ENQ		0x05
#define		CC_ACK		0x06
#define		CC_BEEP		0x07
#define		CC_BS		0x08
#define		CC_TAB		0x09
#define		CC_LF		0x0A
#define		CC_VT		0x0B
#define		CC_FF		0x0C
#define		CC_CR		0x0D
#define		CC_DLE		0x10
#define		CC_XON		0x11
#define		CC_XOFF		0x13
#define		CC_NAK		0x15
#define		CC_SYN		0x16
#define		CC_ETB		0x17
#define		CC_CAN		0x18
#define		CC_EOF		0x1A
#define		CC_ESC		0x1B
#define		CC_RIGHT	0x1C
#define		CC_LEFT		0x1D
#define		CC_UP		0x1E
#define		CC_DOWN		0x1F
#define		CC_SPACE	0x20
#define		CC_DEL		0x7F

#define		CC_CTRL_A	0x01
#define		CC_CTRL_B	0x02
#define		CC_CTRL_C	0x03
#define		CC_CTRL_D	0x04
#define		CC_CTRL_E	0x05
#define		CC_CTRL_F	0x06
#define		CC_CTRL_G	0x07
#define		CC_CTRL_H	0x08
#define		CC_CTRL_I	0x09
#define		CC_CTRL_J	0x0A
#define		CC_CTRL_K	0x0B
#define		CC_CTRL_L	0x0C
#define		CC_CTRL_M	0x0D
#define		CC_CTRL_N	0x0E
#define		CC_CTRL_O	0x0F
#define		CC_CTRL_P	0x10
#define		CC_CTRL_Q	0x11
#define		CC_CTRL_R	0x12
#define		CC_CTRL_S	0x13
#define		CC_CTRL_T	0x14
#define		CC_CTRL_U	0x15
#define		CC_CTRL_V	0x16
#define		CC_CTRL_W	0x17
#define		CC_CTRL_X	0x18
#define		CC_CTRL_Y	0x19
#define		CC_CTRL_Z	0x1A


/****************************************************************************************************************/
#endif
