﻿//
//	AjcMAlloc.c - メモリ割り当て，解放，メモリエラー検知
//
#include	"AjcInternal.h"

//--------------------------------------------------------------------------------------------------------------//
//	作業領域																									//
//--------------------------------------------------------------------------------------------------------------//
static	UX		cbParamA = 0;
static	UX		cbParamW = 0;
static	VO (CALLBACK *cbNtcErrA)(C_BCP pFName, UI lno, C_BCP pVer, UX cbp) = NULL;
static	VO (CALLBACK *cbNtcErrW)(C_WCP pFName, UI lno, C_WCP pVer, UX cbp) = NULL;


//==============================================================================================================//
//	メモリ割り当て																								//
//																												//
//	引　数	：	size		- 割り当てるバイト数																//
//				pFunc		- 呼び出し元のソースファイル名へのポインタ											//
//				lno			- 呼び出し元の行番号																//
//																												//
//	戻り値	：	≠NULL : 正常（割り当てたメモリの先頭アドレス）													//
//				＝NULL : エラー																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	VOP		WINAPI	AjcMAllocA(size_t size, C_BCP pFName, UI lno)
{
	VOP		rc = NULL;

	if ((rc = malloc(size)) == NULL) {
		if (cbNtcErrA != NULL) {
			C_BCP	p1 = pFName;
			C_BCP	p2 = pFName;
			while (*p2 != 0) {
				if (*p2 == '\\' || *p2 == '/') p1 = p2 + 1;
				p2++;
			}
			cbNtcErrA(p1, lno, VersionStrA, cbParamA);
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	VOP		WINAPI	AjcMAllocW(size_t size, C_WCP pFName, UI lno)
{
	VOP		rc = NULL;

	if ((rc = malloc(size)) == NULL) {
		if (cbNtcErrW != NULL) {
			C_WCP	p1 = pFName;
			C_WCP	p2 = pFName;
			while (*p2 != 0) {
				if (*p2 == L'\\' || *p2 == L'/') p1 = p2 + 1;
				p2++;
			}
			cbNtcErrW(p1, lno, VersionStrW, cbParamW);
		}
	}
	return rc;
}
//==============================================================================================================//
//	メモリ解放																									//
//																												//
//	引　数	：	pMem		- 割り当てたメモリの先頭アドレス													//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
AJCEXPORT	VO		WINAPI	AjcMFree(VOP pMem)
{
	if (pMem != NULL) {
		free(pMem);
	}
}
//==============================================================================================================//
//	メモリ割り当てエラー通知コールバックの設定																	//
//																												//
//	引　数	：	cbp				- コールバックパラメタ															//
//				cbNtcMemError	- コールバック関数																//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	VO		WINAPI	AjcSetMemErrorA(UX cbp, VO (CALLBACK *cbNtcMemError)(C_BCP pFName, UI lno, C_BCP pVer, UX cbp))
{
	cbParamA  = cbp;
	cbNtcErrA = cbNtcMemError;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	VO		WINAPI	AjcSetMemErrorW(UX cbp, VO (CALLBACK *cbNtcMemError)(C_WCP pFName, UI lno, C_WCP pVer, UX cbp))
{
	cbParamW  = cbp;
	cbNtcErrW = cbNtcMemError;
}
