﻿#include	"AjcInternal.h"
#include	<crtdbg.h>
#include	<assert.h>

//**************************************************************************************************************//
//																												//
//	メインモジュール																							//
//																												//
//**************************************************************************************************************//

//==============================================================================================================//
//	グローバルワーク																							//
//==============================================================================================================//
HINSTANCE	hDllInst;								//	ＤＬＬインスタンス
HINSTANCE	hExeInst;								//	ＥＸＥインスタンス
UL			MyProcessId;							//	自プロセスＩＤ
BOOL		fExitProcess = FALSE;					//	プロセスの終了を示すフラグ
OSVERSIONINFO VerOs;								//	ＯＳバージョン情報
int			LangId;									//	言語種別
CPINFOEX	CpInfo;									//	コードページ情報
WC			szMyMbc[32];							//	コードページを表す文字列(ex "MBC(S-JIS)" / "MBC(CPnnn)")
BOOL		fCmdWithHdl = FALSE;					//	コントロールからの通知（WM_COMMAND）モード
													//		FALSE : lParam = イベントパラメタ
													//		TRUE  : lParam = コントロールのウインドハンドル

WC			MyDirPath[MAX_PATH] = {0};				//	自ＤＬＬのディレクトリパス名
WC			AppPath  [MAX_PATH] = {0};				//	アプリケーションパス名	  （ex. "d:\work\Sample.exe")
WC			AppFName [MAX_PATH] = {0};				//	アプリケーションファイル名（ex. "Sample.exe"）
WC			AppName  [MAX_PATH] = {0};				//	アプリケーション名		  （ex. "Sample"）

BC			VersionStrA[16] = {0};					//	バージョン文字列（バイト文字）
WC			VersionStrW[16] = {0};					//	バージョン文字列（ワイド文字）

//----- アイコン -----------------------------------------------------------------------------------------------//
HICON		hIcoWide		= NULL;					//	ワイド
HICON		hIcoZoom		= NULL;					//	ズーム
HICON		hIcoForward		= NULL;					//	右移動（右方向三角）
HICON		hIcoBackward	= NULL;					//	左移動（左方向三角）
HICON		hIcoWrench		= NULL;					//	レンチ
HICON		hIcoClock		= NULL;					//	時計マーク
HICON		hIcoReset		= NULL;					//	リセット／更新
HICON		hIcoWipe		= NULL;					//	ワイパー

//----- ビットマップ -------------------------------------------------------------------------------------------//
HBITMAP		hBmpCls			= NULL;					//	画面クリアー

//----- 共通描画オブジェクト -----------------------------------------------------------------------------------//
HICON	hIcoApp		 = NULL;		//	ＡＰＰアイコン
BOOL	fNeedDeleteIcoApp = FALSE;	//	アイコンの削除が必要なことを示すフラグ

HBRUSH	hBruBtnFace	 = NULL;		//	コントロールの背景色ブラシ（ボタンフェース色）
HPEN	hPenBtnFace	 = NULL;		//	コントロールの背景色ペン　（ボタンフェース色）
HPEN	hPenGrayText = NULL;		//	グレーテキストペン　　　　（Disable時のテキスト色）
HPEN	hPenScale	 = NULL;		//	グラフのスケール色ペン　　（薄いグレー）

HBRUSH	hBruRed		 = NULL;		//	ブラシ（赤）
HPEN	hPenRed		 = NULL;		//	ペン　（赤）

HFONT	hDefFontFix10	= NULL;		//	デフォルトフォントハンドル（固定ピッチ）
HFONT	hDefFontFix12	= NULL;		//	デフォルトフォントハンドル（	〃	  ）
HFONT	hDefFontFix14	= NULL;		//	デフォルトフォントハンドル（	〃	  ）
HFONT	hDefFontFix16	= NULL;		//	デフォルトフォントハンドル（	〃	  ）
HFONT	hDefFontFix18	= NULL;		//	デフォルトフォントハンドル（	〃	  ）
HFONT	hDefFontFix20	= NULL;		//	デフォルトフォントハンドル（	〃	  ）
HFONT	hDefFontFix22	= NULL;		//	デフォルトフォントハンドル（	〃	  ）
HFONT	hDefFontFix24	= NULL;		//	デフォルトフォントハンドル（	〃	  ）


HFONT	hDefFontVar10 	= NULL;		//	デフォルトフォントハンドル（可変ピッチ）
HFONT	hDefFontVar12	= NULL;		//			〃				  （	〃	  ）
HFONT	hDefFontVar14	= NULL;		//			〃				  （	〃	  ）
HFONT	hDefFontVar16	= NULL;		//			〃				  （	〃	  ）
HFONT	hDefFontVar18	= NULL;		//			〃				  （	〃	  ）
HFONT	hDefFontVar20	= NULL;		//			〃				  （	〃	  ）
HFONT	hDefFontVar22	= NULL;		//			〃				  （	〃	  ）
HFONT	hDefFontVar24	= NULL;		//			〃				  （	〃	  ）

//--------------------------------------------------------------------------------------------------------------//
//	インスタンスキュー・ノードデータ																			//
//--------------------------------------------------------------------------------------------------------------//
#define		INSTQUEID	0x186F49B5

typedef	struct _INSTQUEHD {
	VO		(CALLBACK *cbCleanup)(VOP pHandle);
} XQUENODE, *PXQUENODE;


//--------------------------------------------------------------------------------------------------------------//
//	作業領域																									//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL		fInited = FALSE;						//	初期化済フラグ

static	HAJCXQUE	hXQueInst;								//	インスタンス・割り当てキュー

//==============================================================================================================//
//																												//
//	ＤｌｌＭａｉｎ																								//
//																												//
//==============================================================================================================//
static int	DllMain_ProcessAttach(HINSTANCE hInstance, DWORD fdwReason, PVOID pvReserved);
static int	DllMain_ProcessDetach(HINSTANCE hInstance, DWORD fdwReason, PVOID pvReserved);
//--------------------------------------------------------------------------------------------------------------//
int	 WINAPI	 DllMain (HINSTANCE hInstance, DWORD fdwReason, PVOID pvReserved)
{
	int			rc = TRUE;

	//	●プロセス起動
	if (fdwReason == DLL_PROCESS_ATTACH) {

		//	メモリ割り当て順序番号でブレークポイントを設定（メモリリークのデバッグ用）
		#ifdef _DEBUG
		//	_CrtSetBreakAlloc(246);
		#endif

		//	プロセス起動時 初期設定
		rc = DllMain_ProcessAttach(hInstance, fdwReason, pvReserved);

	}
	//	●プロセス終了
	else if (fdwReason == DLL_PROCESS_DETACH) {

		//	プロセス終了フラグ設定
		fExitProcess = TRUE;

		//	プロセス終了時 後処理
		rc = DllMain_ProcessDetach(hInstance, fdwReason, pvReserved);

		//	メモリ・リーク・チェック
		#ifdef _DEBUG
			if (_CrtDumpMemoryLeaks()) {
				Beep(120, 200);	Sleep(100);
				Beep(120, 200); Sleep(100);
				Beep(120, 500);
			}
		#endif

	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	インスタンス割り当て用キューのノード削除通知																//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	VO 	CALLBACK	cbXQueRemove(VOP pDat, UI len, UX cbp)
{
	PXQUENODE	pNode = (PXQUENODE)pDat;

	if (pNode->cbCleanup != NULL) {
		pNode->cbCleanup(pNode + 1);
	}
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	プロセス起動時 初期設定																						//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static int	DllMain_ProcessAttach(HINSTANCE hInstance, DWORD fdwReason, PVOID pvReserved)
{
	int		rc = FALSE;
	WC			LangTxt[16];
	LOGFONT		lf;
	WSADATA		wsaData;

	do {
		hDllInst	= hInstance;								//		ＤＬＬインスタンス退避
		hExeInst	= GetModuleHandle(NULL);					//		ＥＸＥインスタンス取得
		MyProcessId = GetCurrentProcessId();					//		自プロセスＩＤ取得
		InitCommonControls();									//		コモンコントロール初期化
		CoInitialize(NULL);										//		ＣＯＭ初期化

		//----- インスタンス割り当て用キュー生成 ---------------------------------------------//
		hXQueInst = AjcXQueCreate(0, cbXQueRemove);		//	生成
		AjcXQueEnableMultiThread(hXQueInst, TRUE);		//	マルチタスク許可

		//----- WinSock スタートアップ -------------------------------------------------------//
		WSAStartup(MAKEWORD(2, 0), &wsaData);

		//----- ＯＳバージョン情報設定 -------------------------------------------------------//
		VerOs.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
		GetVersionEx(&VerOs);

		//----- バージョン文字列設定 ---------------------------------------------------------//
		{
			UI		dummy;
			UI		lBuf, uiBuf;
			BCP		pBuf = NULL;
			UIP		pCodePage;
			WCP		pProductVersion = NULL;
			WC		path[MAX_PATH];
			WC		szKey[256];

			AjcSnPrintFA(VersionStrA, 16,  "?.?.?");
			AjcSnPrintFW(VersionStrW, 16, L"?.?.?");

			do {
				GetModuleFileName(hInstance, path, AJCTSIZE(path));
				if ((lBuf = GetFileVersionInfoSize(path, &dummy)) == 0) break;
				if ((pBuf = AjcTAllocA(lBuf)) == NULL) break;
				if (!GetFileVersionInfo(path, 0, lBuf, pBuf)) break;
				if (!VerQueryValue(pBuf, L"\\VarFileInfo\\Translation", (LPVOID*)&pCodePage, &uiBuf)) break;
				AjcSnPrintF(szKey, AJCTSIZE(szKey), L"\\StringFileInfo\\%04x%04x\\ProductVersion", LOWORD(*pCodePage), HIWORD(*pCodePage));
				if (!VerQueryValue(pBuf, szKey, (LPVOID*)&pProductVersion, &uiBuf)) break;
				wcsncpy(VersionStrW, pProductVersion, 16);
				VersionStrW[15] = 0;
				WideCharToMultiByte(CP_ACP, 0, VersionStrW, -1, VersionStrA, 16, NULL, NULL);
			} while (0);
			if (pBuf != NULL) free(pBuf);
		}
		//----- 言語種別設定 -----------------------------------------------------------------//
		AjcGetRegFileStr(L"Software\\AjrCstXX", L"General", L"Lang", L"", LangTxt, AJCTSIZE(LangTxt));
		AjcCloseRegFile();
		if		(wcsicmp(LangTxt, L"JPN") == 0) LangId = AJCLID_JPN;
		else if (wcsicmp(LangTxt, L"ENG") == 0) LangId = AJCLID_ENG;
		else									LangId = GetUserDefaultLangID();

		//----- コードページ情報設定 ---------------------------------------------------------//
		GetCPInfoEx(CP_ACP, 0, &CpInfo);
		if (CpInfo.CodePage == CP_932) wcscpy(szMyMbc, L"MBC(S-JIS)");
		else						   AjcSnPrintF(szMyMbc, AJCTSIZE(szMyMbc), L"MBC(CP%d)", CpInfo.CodePage);

		//----- 自ＤＬＬのディレクトリパス ---------------------------------------------------//
		if (GetModuleFileNameW(hDllInst, MyDirPath, AJCTSIZE(MyDirPath))) {
			WC	drv[_MAX_DRIVE], dir[_MAX_DIR];
			_wsplitpath(MyDirPath, drv, dir, NULL, NULL);
			_wmakepath (MyDirPath, drv, dir, NULL, NULL);
		}

		//----- ＥＸＥファイル名設定 ---------------------------------------------------------//
		if (GetModuleFileNameW(NULL, AppPath, AJCTSIZE(AppPath)) != 0) {
			WC fname[_MAX_FNAME], fext[_MAX_EXT];
			_wsplitpath(AppPath , NULL, NULL, fname  , fext);
			_wmakepath (AppFName, NULL, NULL, fname  , fext);
			_wsplitpath(AppPath , NULL, NULL, AppName, NULL);
		}

		//----- デフォルトフォント情報（固定ピッチ）------------------------------------------//
		lf.lfHeight		 = 10;			lf.lfStrikeOut		= 0;
		lf.lfWidth		 = 0;			lf.lfCharSet		= DEFAULT_CHARSET;
		lf.lfEscapement	 = 0;			lf.lfOutPrecision	= OUT_STRING_PRECIS;
		lf.lfOrientation = 0;			lf.lfClipPrecision	= CLIP_STROKE_PRECIS;
		lf.lfWeight		 = FW_NORMAL;	lf.lfQuality		= DRAFT_QUALITY;
		lf.lfItalic		 = 0;			lf.lfPitchAndFamily	= FIXED_PITCH;
		lf.lfUnderline	 = 0;			wcscpy(lf.lfFaceName, L"MS Gothic");
		if ((hDefFontFix10 = CreateFontIndirect(&lf)) == NULL) break;

		lf.lfHeight		 = 12;
		if ((hDefFontFix12 = CreateFontIndirect(&lf)) == NULL) break;

		lf.lfHeight		 = 14;
		if ((hDefFontFix14 = CreateFontIndirect(&lf)) == NULL) break;

		lf.lfHeight		 = 16;
		if ((hDefFontFix16 = CreateFontIndirect(&lf)) == NULL) break;

		lf.lfHeight		 = 18;
		if ((hDefFontFix18 = CreateFontIndirect(&lf)) == NULL) break;

		lf.lfHeight		 = 20;
		if ((hDefFontFix20 = CreateFontIndirect(&lf)) == NULL) break;

		lf.lfHeight		 = 22;
		if ((hDefFontFix22 = CreateFontIndirect(&lf)) == NULL) break;

		lf.lfHeight		 = 24;
		if ((hDefFontFix24 = CreateFontIndirect(&lf)) == NULL) break;

		//----- デフォルトフォント情報（可変ピッチ）------------------------------------------//
		lf.lfHeight		 = 10;			lf.lfStrikeOut		= 0;
		lf.lfWidth		 = 0;			lf.lfCharSet		= DEFAULT_CHARSET;
		lf.lfEscapement	 = 0;			lf.lfOutPrecision	= OUT_STROKE_PRECIS;
		lf.lfOrientation = 0;			lf.lfClipPrecision	= CLIP_STROKE_PRECIS;
		lf.lfWeight		 = FW_NORMAL;	lf.lfQuality		= DRAFT_QUALITY;
		lf.lfItalic		 = 0;			lf.lfPitchAndFamily	= VARIABLE_PITCH;
		lf.lfUnderline	 = 0;			wcscpy(lf.lfFaceName, L"MS UI Gothic");
		if ((hDefFontVar10 = CreateFontIndirect(&lf)) == NULL) break;

		lf.lfHeight		 = 12;
		if ((hDefFontVar12 = CreateFontIndirect(&lf)) == NULL) break;

		lf.lfHeight		 = 14;
		if ((hDefFontVar14 = CreateFontIndirect(&lf)) == NULL) break;

		lf.lfHeight		 = 16;
		if ((hDefFontVar16 = CreateFontIndirect(&lf)) == NULL) break;

		lf.lfHeight		 = 18;
		if ((hDefFontVar18 = CreateFontIndirect(&lf)) == NULL) break;

		lf.lfHeight		 = 20;
		if ((hDefFontVar20 = CreateFontIndirect(&lf)) == NULL) break;

		lf.lfHeight		 = 22;
		if ((hDefFontVar22 = CreateFontIndirect(&lf)) == NULL) break;

		lf.lfHeight		 = 24;
		if ((hDefFontVar24 = CreateFontIndirect(&lf)) == NULL) break;

		//----- アイコンロード（１６×１６）--------------------------------------------------//
		if ((hIcoWide		= (HICON)LoadImage(hDllInst, MAKEINTRESOURCE(IDI_WIDEBTN ), IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR)) == NULL) break;
		if ((hIcoZoom		= (HICON)LoadImage(hDllInst, MAKEINTRESOURCE(IDI_ZOOMBTN ), IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR)) == NULL) break;
		if ((hIcoForward	= (HICON)LoadImage(hDllInst, MAKEINTRESOURCE(IDI_FORWARD ), IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR)) == NULL) break;
		if ((hIcoBackward	= (HICON)LoadImage(hDllInst, MAKEINTRESOURCE(IDI_BACKWARD), IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR)) == NULL) break;
		if ((hIcoWrench		= (HICON)LoadImage(hDllInst, MAKEINTRESOURCE(IDI_WRENCH  ), IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR)) == NULL) break;
		if ((hIcoClock		= (HICON)LoadImage(hDllInst, MAKEINTRESOURCE(IDI_CLOCK	 ), IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR)) == NULL) break;
		if ((hIcoReset		= (HICON)LoadImage(hDllInst, MAKEINTRESOURCE(IDI_RESET	 ), IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR)) == NULL) break;
		if ((hIcoWipe		= (HICON)LoadImage(hDllInst, MAKEINTRESOURCE(IDI_WIPE	 ), IMAGE_ICON, 32, 32, LR_DEFAULTCOLOR)) == NULL) break;

		//-----	ビットマップロード -----------------------------------------------------------//
		if ((hBmpCls	= LoadBitmap(hDllInst, MAKEINTRESOURCE(IDB_CLS		))) == NULL) break;
		AjcChangeBitmapColor(hBmpCls, RGB(255, 255, 255), GetSysColor(COLOR_BTNFACE));
		

		//----- 共通描画オブジェクト生成 -----------------------------------------------------//
		if ((hIcoApp		= LoadIcon(hDllInst, MAKEINTRESOURCE(IDI_APPICON)))    == NULL) break;
		fNeedDeleteIcoApp	= TRUE;
		if ((hBruBtnFace	= CreateSolidBrush(		 GetSysColor(COLOR_BTNFACE)))  == NULL) break;
		if ((hPenBtnFace	= CreatePen(PS_SOLID, 1, GetSysColor(COLOR_BTNFACE)))  == NULL) break;
		if ((hPenGrayText	= CreatePen(PS_SOLID, 1, GetSysColor(COLOR_GRAYTEXT))) == NULL) break;
		if ((hPenScale		= CreatePen(PS_SOLID, 1, RGB(220, 220, 220)))		   == NULL) break;

		if ((hBruRed		= CreateSolidBrush(		 RGB(255,	0,	 0))		 ) == NULL) break;
		if ((hPenRed		= CreatePen(PS_SOLID, 1, RGB(255,	0,	 0))		 ) == NULL) break;

		//----- 起動時初期設定 ----------------------------------------------------------------//
		if (!AjcStcInit			  ()) break;
		if (!AjcCtrlInpValInit	  ()) break;
		if (!AjcCtrlTmChartInit	  ()) break;
		if (!AjcCtrl3dGraphInit	  ()) break;
		if (!AjcCtrlVT100Init	  ()) break;
	//	if (!AjcCtrlTextEditInit  ()) break;
		if (!AjcCtrlLogFileInit	  ()) break;
		if (!AjcCtrlBarGraphInit  ()) break;
		if (!AjcCtrlSerialComPInit()) break;
		if (!AjcCtrlSockServerInit()) break;
		if (!AjcCtrlSockClientInit()) break;
		if (!AjcCtrlListBoxInit   ()) break;
		if (!AjcTipTxtInit		  ()) break;
		if (!AjcTipCtlInit		  ()) break;
		if (!AjcCipInit 		  ()) break;
		if (!AjcPopupMenuInit	  ()) break;
		if (!AjcConInpInit		  ()) break;
		if (!AjcWndItemPermInit	  ()) break;
		if (!AjcTimeMeasureInit	  ()) break;
		if (!AjcProfileInit		  ()) break;
		if (!AjcCfInit			  ()) break;
		if (!AjcDgcInit			  ()) break;
		if (!AjcWatInit			  ()) break;
		if (!AjcTxoInit			  ()) break;

		rc = TRUE;
	} while(0);

	//	初期化済フラグ設定
	fInited = TRUE;

	return rc;
}

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	プロセス終了時 後処理																						//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static int	DllMain_ProcessDetach(HINSTANCE hInstance, DWORD fdwReason, PVOID pvReserved)
{
	if (fInited) {
		WSACleanup();											//		WinSock クリーンアップ
		AjcCloseRegFile();										//		レジストリキーハンドルをクローズ
		CoUninitialize();										//		ＣＯＭ後処理

		//----- インスタンス割当用キュー消去（残留インスタンスのクリーンアップ）--//
		AjcXQueDelete(hXQueInst);

		//----- 終了時後処理 -----------------------------------------------------//
		AjcStcEnd			();
		AjcCtrlInpValEnd	();
		AjcCtrlTmChartEnd	();
		AjcCtrl3dGraphEnd	();
		AjcCtrlVT100End		();
	//	AjcCtrlTextEditEnd	();
		AjcCtrlLogFileEnd	();
		AjcCtrlBarGraphEnd	();
		AjcCtrlSerialComPEnd();
		AjcCtrlSockServerEnd();
		AjcCtrlSockClientEnd();
		AjcCtrlListBoxEnd	();
		AjcTipTxtEnd		();
		AjcTipCtlEnd		();
		AjcCipEnd			();
		AjcPopupMenuEnd		();
		AjcConInpEnd		();
		AjcWndItemPermEnd	();
		AjcTimeMeasureEnd	();
		AjcProfileEnd		();
		AjcCfEnd			();
		AjcDgcEnd			();
		AjcWatEnd			();
		AjcTxoEnd			();

		//----- アイコン解放 -----------------------------------------------------//
		if (hIcoWide		!= NULL) {DeleteObject(hIcoWide    ); hIcoWide		= NULL;}
		if (hIcoZoom		!= NULL) {DeleteObject(hIcoZoom    ); hIcoZoom		= NULL;}
		if (hIcoForward		!= NULL) {DeleteObject(hIcoForward ); hIcoForward	= NULL;}
		if (hIcoBackward	!= NULL) {DeleteObject(hIcoBackward); hIcoBackward	= NULL;}
		if (hIcoWrench		!= NULL) {DeleteObject(hIcoWrench  ); hIcoWrench	= NULL;}
		if (hIcoClock		!= NULL) {DeleteObject(hIcoClock   ); hIcoClock		= NULL;}
		if (hIcoReset		!= NULL) {DeleteObject(hIcoReset   ); hIcoReset		= NULL;}
		if (hIcoWipe		!= NULL) {DeleteObject(hIcoWipe    ); hIcoWipe		= NULL;}

		//----- ビットマップ解放 -------------------------------------------------//
		if (hBmpCls			!= NULL) {DeleteObject(hBmpCls	   ); hBmpCls		= NULL;}

		//----- 共通描画オブジェクト開放 -----------------------------------------//
		if (hIcoApp 	 != NULL) {
			if (fNeedDeleteIcoApp) {DeleteObject(hIcoApp   ); hIcoApp		= NULL; fNeedDeleteIcoApp = FALSE;}
		}
		if (hBruBtnFace  != NULL) {DeleteObject(hBruBtnFace ); hBruBtnFace	= NULL;}
		if (hPenBtnFace  != NULL) {DeleteObject(hPenBtnFace ); hPenBtnFace	= NULL;}
		if (hPenGrayText != NULL) {DeleteObject(hPenGrayText); hPenGrayText = NULL;}
		if (hPenScale	 != NULL) {DeleteObject(hPenScale	); hPenScale	= NULL;}

		if (hBruRed 	 != NULL) {DeleteObject(hBruRed 	); hBruRed		= NULL;}
		if (hPenRed 	 != NULL) {DeleteObject(hPenRed 	); hPenRed		= NULL;}

		if (hDefFontFix10  != NULL) {DeleteObject(hDefFontFix10); hDefFontFix10	= NULL;}
		if (hDefFontFix12  != NULL) {DeleteObject(hDefFontFix12); hDefFontFix12	= NULL;}
		if (hDefFontFix14  != NULL) {DeleteObject(hDefFontFix14); hDefFontFix14	= NULL;}
		if (hDefFontFix16  != NULL) {DeleteObject(hDefFontFix16); hDefFontFix16	= NULL;}
		if (hDefFontFix18  != NULL) {DeleteObject(hDefFontFix18); hDefFontFix18	= NULL;}
		if (hDefFontFix20  != NULL) {DeleteObject(hDefFontFix20); hDefFontFix20	= NULL;}
		if (hDefFontFix22  != NULL) {DeleteObject(hDefFontFix22); hDefFontFix22	= NULL;}
		if (hDefFontFix24  != NULL) {DeleteObject(hDefFontFix24); hDefFontFix24	= NULL;}

		if (hDefFontVar10  != NULL) {DeleteObject(hDefFontVar10); hDefFontVar10	= NULL;}
		if (hDefFontVar12  != NULL) {DeleteObject(hDefFontVar12); hDefFontVar12	= NULL;}
		if (hDefFontVar14  != NULL) {DeleteObject(hDefFontVar14); hDefFontVar14	= NULL;}
		if (hDefFontVar16  != NULL) {DeleteObject(hDefFontVar16); hDefFontVar16	= NULL;}
		if (hDefFontVar18  != NULL) {DeleteObject(hDefFontVar18); hDefFontVar18	= NULL;}
		if (hDefFontVar20  != NULL) {DeleteObject(hDefFontVar20); hDefFontVar20	= NULL;}
		if (hDefFontVar22  != NULL) {DeleteObject(hDefFontVar22); hDefFontVar22	= NULL;}
		if (hDefFontVar24  != NULL) {DeleteObject(hDefFontVar24); hDefFontVar24	= NULL;}

		//	初期化済フラグリセット
		fInited = FALSE;

	}
	return TRUE;
}

//==============================================================================================================//
//	固定ピッチデフォルトフォント取得（非公開）																	//
//																												//
//	引　数	：	FontHeight - フォントの高さ																		//
//																												//
//	戻り値	：	フォントハンドル																				//
//==============================================================================================================//
AJCEXPORT	HFONT		WINAPI	AjcGetDefFontFix(int FontHeight)
{
	HFONT	rc;

	if		(FontHeight <= 10) rc = hDefFontFix10;
	else if (FontHeight <= 12) rc = hDefFontFix12;
	else if (FontHeight <= 14) rc = hDefFontFix14;
	else if (FontHeight <= 16) rc = hDefFontFix16;
	else if (FontHeight <= 18) rc = hDefFontFix18;
	else if (FontHeight <= 20) rc = hDefFontFix20;
	else if (FontHeight <= 22) rc = hDefFontFix22;
	else					   rc = hDefFontFix24;

	return rc;
}
//==============================================================================================================//
//	可変ピッチデフォルトフォント取得（非公開）																	//
//																												//
//	引　数	：	FontHeight - フォントの高さ																		//
//																												//
//	戻り値	：	フォントハンドル																				//
//==============================================================================================================//
AJCEXPORT	HFONT		WINAPI	AjcGetDefFontVar(int FontHeight)
{
	HFONT	rc;

	if		(FontHeight <= 10) rc = hDefFontVar10;
	else if (FontHeight <= 12) rc = hDefFontVar12;
	else if (FontHeight <= 14) rc = hDefFontVar14;
	else if (FontHeight <= 16) rc = hDefFontVar16;
	else if (FontHeight <= 18) rc = hDefFontVar18;
	else if (FontHeight <= 20) rc = hDefFontVar20;
	else if (FontHeight <= 22) rc = hDefFontVar22;
	else					   rc = hDefFontVar24;

	return rc;
}
//==============================================================================================================//
//	インストール種別（すべてのユーザ／このユーザ）読み出し	（非公開）											//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	TRUE  : すべてのユーザ																			//
//				FALSE : このユーザ																				//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcIsInstallAllUser(VO)
{
	BOOL		rc = FALSE;
	AJCREGTYPE	type;
	DWORD		val = 0;

	if (AjcRegGet(HKEY_LOCAL_MACHINE, L"Software\\AjrCstXX", L"AllUser", &type, &val, sizeof(DWORD)) == sizeof(DWORD)) {
		if (type == REG_DWORD && val == 123456789) {
			rc = TRUE;
		}
	}
	return rc;
}


//==============================================================================================================//
//	ＤＬＬインスタンス取得																						//
//																												//
//	引　数	：	なし（２つの引数は未使用）																		//
//																												//
//	戻り値	：	＝０ - OK																						//
//				≠０ - Error																					//
//==============================================================================================================//
AJCEXPORT	HINSTANCE	WINAPI	AjcGetDllInstance(void)
{
	return hDllInst;
}


//==============================================================================================================//
//	コントロール初期化	（この関数は、V2.6.0.7で廃止したが、互換性の為に残しています）							//
//																												//
//	引　数	：	なし（２つの引数は未使用）																		//
//																												//
//	戻り値	：	＝０ - OK																						//
//				≠０ - Error																					//
//==============================================================================================================//
AJCEXPORT	AJCINIT_RESULT	WINAPI	AjcInit(UL dmy1, UL dmy2)
{
	AJCINIT_RESULT	rc = AJCINIT_OK;
	static	BOOL fFirst = TRUE;

	if (fFirst) {	//初回？
		//----- 初回フラグクリアー -----------------------------------------------------------------------------//
		fFirst = FALSE;
	}
	return rc;
}
//==============================================================================================================//
//	コントロールからの通知（WM_COMMAND）モード設定																//
//																												//
//	引　数	：	fWithHandle	- コントロールからの通知（WM_COMMAND）モード										//
//									FALSE : lParam = イベントパラメタ											//
//									TRUE  : lParam = コントロールのウインドハンドル								//
//																												//
//	戻り値	：	＝０ - OK																						//
//				≠０ - Error																					//
//==============================================================================================================//
AJCEXPORT	VO				WINAPI	AjcSetCmdWithHdl(BOOL fWithHandle)
{
	fCmdWithHdl = fWithHandle;
}
//==============================================================================================================//
//	プリケーション名の設定																						//
//																												//
//	引　数	：	hIcon	- アイコンハンドル																		//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	VO			WINAPI	AjcSetAppNameA(C_BCP pName)
{
	if (pName != NULL) {
		MultiByteToWideChar(CP_ACP, 0, pName, -1, AppName, AJCTSIZE(AppName));
	}
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	VO			WINAPI	AjcSetAppNameW(C_WCP pName)
{
	if (pName != NULL) {
		AjcSnPrintFW(AppName, AJCTSIZE(AppName), L"%s", pName);
	}
}
//==============================================================================================================//
//	アイコンをプリケーション用に設定する																		//
//																												//
//	引　数	：	hIcon	- アイコンハンドル																		//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
AJCEXPORT	VO			WINAPI	AjcSetAppIcon(HICON hIcon)
{
	if (hIcon != NULL) {
		if (hIcoApp 	 != NULL) {
			if (fNeedDeleteIcoApp) {DeleteObject(hIcoApp   ); hIcoApp = NULL; fNeedDeleteIcoApp = FALSE;}
		}
		fNeedDeleteIcoApp	= FALSE;
		hIcoApp				= hIcon;
	}
}
//==============================================================================================================//
//	アイコンをMSIL用に切り替える																				//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
AJCEXPORT	VO	WINAPI	AjcChangeIconToMsil(VO)
{
	HICON	hIco	= NULL;

	if ((hIco = LoadIcon(hDllInst, MAKEINTRESOURCE(IDI_MSIL))) != NULL) {
		if (hIcoApp 	 != NULL) {
			if (fNeedDeleteIcoApp) {DeleteObject(hIcoApp   ); hIcoApp = NULL; fNeedDeleteIcoApp = FALSE;}
		}
		fNeedDeleteIcoApp	= TRUE;
		hIcoApp				= hIco;
	}
}
//==============================================================================================================//
//	インスタンス確保																							//
//																												//
//	引　数	：	size	  - 確保するインスタンスワークのバイト数												//
//				cbCleanup - インスタンスのクリーンアップ用コールバック関数（不要時はＮＵＬＬ）					//
//																												//
//	戻り値	：	≠NULL - 確保したインスタンスワークのアドレス													//
//				＝NULL - エラー																					//
//==============================================================================================================//
AJCEXPORT	VOP		WINAPI	AjcAllocInstance(int size, VO (CALLBACK *cbCleanup)(VOP pHandle))
{
	VOP			rc = NULL;
	PXQUENODE	pNode;
	XQUENODE	node;

	if (pNode = AjcXQueEnque(hXQueInst, NULL, sizeof(node) + size)) {
		pNode->cbCleanup = cbCleanup;
		memset(pNode + 1, 0, size);
		rc = pNode + 1;
	}

	return rc;
}
//==============================================================================================================//
//	インスタンス開放																							//
//																												//
//	引　数	：	pHandle	  - 開放するインスタンスワークのアドレス												//
//				size	  - 開放するインスタンスワークのバイト数												//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
AJCEXPORT	VO		WINAPI	AjcReleaseInstance(VOP pHandle)
{
	PXQUENODE	pNode = ((PXQUENODE)pHandle) - 1;
	AjcXQueRemove(hXQueInst, pNode);
}
//==============================================================================================================//
//	言語種別設定																								//
//																												//
//	引　数	：	Lid	  - 言語種別（AJCLID_JPN：日本語，その他：英語）											//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
AJCEXPORT	VO		WINAPI	AjcSetLangId	 (AJCLANGID Lid)
{
	LangId = (Lid == AJCLID_JPN ? AJCLID_JPN : AJCLID_ENG);
}
//==============================================================================================================//
//	言語種別取得																								//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	言語種別（AJCLID_JPN：日本語，その他：英語）													//
//==============================================================================================================//
AJCEXPORT	AJCLANGID	WINAPI	AjcGetLangId	 (VO)
{
	return LangId;
}

//==============================================================================================================//
//	テキスト・メモリ割り当て																					//
//																												//
//	引　数：	TextLength - 割り当てるテキスト文字数															//
//																												//
//	戻り値：	≠NULL : 割り当てたメモリのアドレス																//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BCP		WINAPI	AjcTAllocA(UI TextLength)
{
	return (BCP)AJCMEM(TextLength * sizeof(BC));
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	WCP		WINAPI	AjcTAllocW(UI TextLength)
{
	return (WCP)AJCMEM(TextLength * sizeof(WC));
}
//==============================================================================================================//
//	テキスト・メモリ開放																						//
//																												//
//	引　数：	pTxt - 開放するテキスト・メモリのアドレス														//
//																												//
//	戻り値：	なし																							//
//==============================================================================================================//
AJCEXPORT	VO		WINAPI	AjcTFree(VOP pTxt)
{
	if (pTxt != NULL) {
		free(pTxt);
	}
}
//==============================================================================================================//
//	Function	:	本ライブラリのバージョン（文字列）取得														//
//																												//
//	Argument	:	なし																						//
//																												//
//	Return		:	バージョン文字列のアドレス																	//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BCP		WINAPI	AjcGetVerStrA(VO)
{
	return VersionStrA;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	WCP		WINAPI	AjcGetVerStrW(VO)
{
	return VersionStrW;
}
//==============================================================================================================//
//	Function	:	本ライブラリのバージョン（文字列）をバッファに取得											//
//																												//
//	Argument	:	pBuf - バージョン文字列を格納するバッファのアドレス											//
//					lBuf - バージョン文字列を格納するバッファの文字数											//
//																												//
//	Return		:	バージョン文字列のアドレス																	//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	VO		WINAPI	AjcGetVersionA(BCP pBuf, int lBuf)
{
	AjcSnPrintFA(pBuf, lBuf, "%s", VersionStrA);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	VO		WINAPI	AjcGetVersionW(WCP pBuf, int lBuf)
{
	AjcSnPrintFW(pBuf, lBuf, L"%s", VersionStrW);
}
//==============================================================================================================//
//	Function	:	インスタンス内のリソースからバージョン（文字列）を取得										//
//																												//
//	Argument	:	hInst	- インスタンスハンドル																//
//					pVerBuf - バージョン文字列を格納するバッファのアドレス（不要時はＮＵＬＬ）					//
//					lVerBuf - バージョン文字列を格納するバッファの文字数										//
//																												//
//	Return		:	バージョン文字列を格納するのに必要場バッファサイズ（文字数）								//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	UI	WINAPI	AjcGetVerInResA(HINSTANCE hInst, BCP pVerBuf, int lVerBuf)
{
	UI		rc = 0;
	UI		lBuf;
	WCP		pBuf = NULL;

	if (lBuf = AjcGetVerInRes(hInst, NULL, 0)) {
		do {
			if ((pBuf = AjcTAlloc(lBuf)) == NULL) break;
			AjcGetVerInRes(hInst, pBuf, lBuf);
			rc = WideCharToMultiByte(CP_ACP, 0, pBuf, -1, NULL, 0, NULL, NULL);
			if (pVerBuf != NULL && lVerBuf > 0) {
				WideCharToMultiByte(CP_ACP, 0, pBuf, -1, pVerBuf, lVerBuf, NULL, NULL);
			}
		} while(0);
	}

	if (pBuf != NULL) free(pBuf);

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	UI	WINAPI	AjcGetVerInResW(HINSTANCE hInst, WCP pVerBuf, int lVerBuf)
{
	UI		rc = 0;
	UL		dummy;
	UI		lBuf, uiBuf;
	WCP		pBuf = NULL;
	UIP		pCodePage;
	WCP		pProductVersion = NULL;
	WC		path[MAX_PATH];
	WC		szKey[256];

	do {
		if (pVerBuf != NULL && lVerBuf > 0) {
			AjcSnPrintF(pVerBuf, lVerBuf,  L"?.?.?");
		}
		GetModuleFileName(hInst, path, AJCTSIZE(path));
		if ((lBuf = GetFileVersionInfoSize(path, &dummy)) == 0) break;
		if ((pBuf = AjcTAlloc(lBuf)) == NULL) break;
		if (!GetFileVersionInfo(path, 0, lBuf, pBuf)) break;
		if (!VerQueryValue(pBuf, L"\\VarFileInfo\\Translation", (LPVOID*)&pCodePage, &uiBuf)) break;
		AjcSnPrintF(szKey, AJCTSIZE(szKey), L"\\StringFileInfo\\%04x%04x\\ProductVersion", LOWORD(*pCodePage), HIWORD(*pCodePage));
		if (!VerQueryValue(pBuf, szKey, (LPVOID*)&pProductVersion, &uiBuf)) break;
		if (pVerBuf != NULL && lVerBuf > 0) {
			AjcSnPrintF(pVerBuf, lVerBuf, L"%s", pProductVersion);
		}
		rc = (UI)wcslen(pProductVersion) + 1;
	} while(0);

	if (pBuf != NULL) free(pBuf);

	return rc;
}

//==============================================================================================================//
//	Function	:	自ＢＩＮパス，ＩＮＣパス取得																//
//																												//
//	Argument	:	pBinPath - 自ＢＩＮパスを格納するバッファのアドレス											//
//					lBinPath - 　　〃　　　　　　　　　　　　　文字数											//
//					pIncPath - 自ＩＮＣパスを格納するバッファのアドレス	（不要時はNULL)							//
//					lIncPath - 　　〃　　　　　　　　　　　　　文字数											//
//																												//
//	Return		:	なし																						//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	VO		WINAPI	AjcGetMyPathA(BCP pBinPath, int lBinPath, BCP pIncPath, int lIncPath)
{
	BC		drv[_MAX_DRIVE], dir[_MAX_DIR];
	BC		AbsPath[MAX_PATH];

	//----- 自ＢＩＮパス作成 -------------------------------------------------------------------//
	GetModuleFileNameA(NULL, pBinPath, lBinPath);
	_splitpath(pBinPath, drv, dir, NULL, NULL);
	_makepath (pBinPath, drv, dir, NULL, NULL);
	if (PathCanonicalizeA(AbsPath, pBinPath)) {
		AjcSnPrintFA(pBinPath, lBinPath, "%s", AbsPath);
	}
	AjcPathCatA(pBinPath, "", lBinPath);
	//----- 自ＩＮＣパス作成 -------------------------------------------------------------------//
	if (pIncPath != NULL  &&  lIncPath > 0) {
		AjcSnPrintFA(pIncPath, lIncPath, "%s..\\inc", pBinPath);
		if (PathCanonicalizeA(AbsPath, pIncPath)) {
			AjcSnPrintFA(pIncPath, lIncPath, "%s", AbsPath);
		}
		AjcPathCatA(pIncPath, "", lIncPath);
	}
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	VO		WINAPI	AjcGetMyPathW(WCP pBinPath, int lBinPath, WCP pIncPath, int lIncPath)
{
	WC		drv[_MAX_DRIVE], dir[_MAX_DIR];
	WC		AbsPath[MAX_PATH];

	//----- 自ＢＩＮパス作成 -------------------------------------------------------------------//
	GetModuleFileNameW(NULL, pBinPath, lBinPath);
	_wsplitpath(pBinPath, drv, dir, NULL, NULL);
	_wmakepath (pBinPath, drv, dir, NULL, NULL);
	if (PathCanonicalizeW(AbsPath, pBinPath)) {
		AjcSnPrintFW(pBinPath, lBinPath, L"%s", AbsPath);
	}
	AjcPathCatW(pBinPath, L"", lBinPath);
	//----- 自ＩＮＣパス作成 -------------------------------------------------------------------//
	if (pIncPath != NULL  &&  lIncPath > 0) {
		AjcSnPrintFW(pIncPath, lIncPath, L"%s..\\inc", pBinPath);
		if (PathCanonicalizeW(AbsPath, pIncPath)) {
			AjcSnPrintFW(pIncPath, lIncPath, L"%s", AbsPath);
		}
		AjcPathCatW(pIncPath, L"", lIncPath);
	}
}
//==============================================================================================================//
//	先頭と末尾のセミコロンを削除し、中間の連続したセミコロンを１つにまとめる									//
//																												//
//	引　数	：	pStr	- PATH環境変数の内容																	//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	VO	WINAPI	AjcAdjustSemiCollonA(BCP pStr)
{
	int		len;
	BCP		p;

	if (pStr != NULL) {
		//----- 先頭のセミコロン削除 -------------------------------------//
		for (p = pStr, len = 0; *p == ';'; p++, len++);
		if (len != 0) {
			memmove(pStr, p, strlen(p) + 1);
		}
		//----- 末尾のセミコロン削除 -------------------------------------//
		len = (int)strlen(pStr);
		for (p = pStr + (len - 1); len > 0 && *p == ';'; p--, len--);
		if (*p != ';') {
			p++;
		}
		*p = 0;
		//----- 連続したセミコロンを１つにまとめる -----------------------//
		while (p = mbsstr(pStr, ";;")) {
			len = 2;
			while (*(p + len) == ';') {len++;}
			memmove(p + 1, p + len, strlen(p + len) + 1);
		}
	}
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	VO	WINAPI	AjcAdjustSemiCollonW(WCP pStr)
{
	int		len;
	WCP		p;

	if (pStr != NULL) {
		//----- 先頭のセミコロン削除 -------------------------------------//
		for (p = pStr, len = 0; *p == L';'; p++, len++);
		if (len != 0) {
			memmove(pStr, p, (wcslen(p) + 1) * 2);
		}
		//----- 末尾のセミコロン削除 -------------------------------------//
		len = (int)wcslen(pStr);
		for (p = pStr + (len - 1); len > 0 && *p == L';'; p--, len--);
		if (*p != L';') {
			p++;
		}
		*p = 0;
		//----- 連続したセミコロンを１つにまとめる -----------------------//
		while (p = wcsstr(pStr, L";;")) {
			len = 2;
			while (*(p + len) == L';') {len++;}
			memmove(p + 1, p + len, (wcslen(p + len) + 1) * 2);
		}
	}
}

//==============================================================================================================//
//	Function	:	メモリデータ取得																			//
//																												//
//	Argument	:	pMem - メモリアドレス																		//
//																												//
//	Return		:	メモリデータ																				//
//==============================================================================================================//
AJCEXPORT	UB		WINAPI	AjcMemPeekUB (C_UBP  pMem) {return *pMem;}
AJCEXPORT	UW		WINAPI	AjcMemPeekUW (C_UWP  pMem) {return *pMem;}
AJCEXPORT	UI		WINAPI	AjcMemPeekUL (C_UIP  pMem) {return *pMem;}
AJCEXPORT	ULL		WINAPI	AjcMemPeekULL(C_ULLP pMem) {return *pMem;}

AJCEXPORT	SB		WINAPI	AjcMemPeekSB (C_UBP  pMem) {return *pMem;}
AJCEXPORT	SW		WINAPI	AjcMemPeekSW (C_UWP  pMem) {return *pMem;}
AJCEXPORT	SI		WINAPI	AjcMemPeekSL (C_UIP  pMem) {return *pMem;}
AJCEXPORT	SLL		WINAPI	AjcMemPeekSLL(C_ULLP pMem) {return *pMem;}

//==============================================================================================================//
//	Function	:	メモリコピー																				//
//																												//
//	Argument	:	pDest - コピー先アドレス																	//
//					pSrc  - コピー元アドレス																	//
//					len   - コピーバイト数																		//
//																												//
//	Return		:	コピー先アドレス(=pDest)																	//
//==============================================================================================================//
AJCEXPORT	VOP		WINAPI	AjcMemCopy(VOP pDest, C_VOP pSrc, int len)
{
	if (pDest != NULL && pSrc != NULL) {
		memcpy(pDest, pSrc, len);
	}
	return pDest;
}
//==============================================================================================================//
//	Function	:	ワイド文字列長																				//
//																												//
//	Argument	:	pDest - コピー先アドレス																	//
//					pSrc  - コピー元アドレス																	//
//					len   - コピーバイト数																		//
//																												//
//	Return		:	ワイド文字列長																				//
//==============================================================================================================//
AJCEXPORT	int		WINAPI	AjcWStrLen(C_WCP pStr)
{
	int		rc = 0;

	if (pStr != NULL) {
		rc = (int)wcslen(pStr);
	}
	return rc;
}
//==============================================================================================================//
//	Function	:	ワイド文字列コピー																			//
//																												//
//	Argument	:	pDest - コピー先バイト文字アドレス															//
//					pSrc  - コピー元ワイド文字バッファのアドレス												//
//					len   - コピー元ワイド文字バッファの文字数（文字列終端'\0'を含む）							//
//																												//
//	Return		:	TRUE  - 正常																				//
//					FALSE - エラー（バッファが小さい／パラメタエラー）											//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcWStrCopy(WCP pDest, C_WCP pSrc, int len)
{
	BOOL		rc = FALSE;

	if (pDest != NULL && pSrc != NULL && len > 0) {
		int		stl = (int)wcslen(pSrc);
		wcsncpy(pDest, pSrc, len);
		pDest[len - 1] = 0;
		rc = (len > stl);
	}
	return rc;
}
//==============================================================================================================//
//	Function	:	バイト文字→ワイド文字変換																	//
//																												//
//	Argument	:	pSrc  - 変換元バイト文字アドレス															//
//					pDest - 変換先ワイド文字アドレス（NULL:変換に必要な文字数のみ取得）							//
//					lDest - 変換先ワイド文字数　　　（pDest=NULL時は０を指定）									//
//																												//
//	Return		:	変換したワイド文字数																		//
//==============================================================================================================//
AJCEXPORT	int		WINAPI	AjcByteCharToWideChar(C_BCP pSrc, WCP pDest, int lDest)
{
	int		rc = 0;

	if (pSrc != NULL) {
		rc = MultiByteToWideChar(CP_ACP, 0, pSrc, -1, pDest, lDest);
	}
	return rc;
}
//==============================================================================================================//
//	Function	:	ワイド文字→バイト文字変換																	//
//																												//
//	Argument	:	pSrc  - 変換元ワイド文字アドレス															//
//					pDest - 変換先バイト文字アドレス（NULL:変換に必要な文字数のみ取得）							//
//					lDest - 変換先バイト文字数　　　（pDest=NULL時は０を指定）									//
//																												//
//	Return		:	変換した文字のバイト数																		//
//==============================================================================================================//
AJCEXPORT	int		WINAPI	AjcWideCharToByteChar(C_WCP pSrc, BCP pDest, int lDest)
{
	int		rc = 0;

	if (pSrc != NULL) {
		rc = WideCharToMultiByte(CP_ACP, 0, pSrc, -1, pDest, lDest, NULL, NULL);
	}
	return rc;
}
//==============================================================================================================//
//	Function	:	レンジ分割のステップ値を算出（非公開）														//
//																												//
//	Argument	:	RangWidth 	- レンジ幅（高位値－低位値）													//
//					MinDiv		- 最小分割数																	//
//					MaxDiv		- 最大分割数																	//
//					pDigit		- 整数部桁数を格納するバッファのアドレス（不要時はNULL)							//
//					pPrec		- 小数部桁数を格納するバッファのアドレス（不要時はNULL)							//
//																												//
//	Return		:	ステップ値																					//
//==============================================================================================================//
AJCEXPORT	double	WINAPI	AjcCalcRangeStep(double RangeWidth, double MinDiv, double MaxDiv, UIP pDigit, UIP pPrec)
{
	double	step;
	UI		digit, prec;

	//	末桁を 5 or 0 に調整したステップ値を算出
	step = AjcRoundMultPow10(RangeWidth / MaxDiv, &digit, &prec);
	//	最小分割数を確保できない場合、末桁＝偶数で算出し直し
	if ((RangeWidth / step) < (double)MinDiv) {
		step = AjcAdjustMultPow10(RangeWidth / (double)MaxDiv, &digit, &prec, TRUE);
		//	最小分割数を確保できない場合、末桁＝任意で算出し直し
		if ((RangeWidth / step) < (double)MinDiv) {
			step = AjcAdjustMultPow10(RangeWidth / (double)MaxDiv, &digit, &prec, FALSE);
		}
	}
	//	整数桁数，少数桁数を設定
	if (pDigit != NULL) *pDigit = digit;
	if (pPrec  != NULL) *pPrec	= prec;

	return step;
}
//==============================================================================================================//
//	Function	:	バージョンダイアログ表示																	//
//																												//
//	Argument	:	hInst		- バージョンリソースを含むインスタンス											//
//					hBmpOrIcon	- トレードマーク（ビットマップ or アイコン）									//
//					SrtYY		- コピーライトの開始年															//
//					pWndTtl		- ウインドタイトル																//
//					pSubTtl		- サブタイトル																	//
//					pCpyRgt	   	- コピーライト名																//
//					knd			- トレードマークのリソース種別（AJCVER_BMAP / AJCVER_ICON)						//
//																												//
//	Return		:	コピーしたバイト数																			//
//==============================================================================================================//
typedef struct {
	AJCVER_RESKND	knd;
	UX				hTradeMark;
	int				SrtYY;
	WC				VerStr[16];
	WC				WndTtl[256];
	WC				SubTtl[256];
	WC				CpyRgt[256];

	HBITMAP			hBmpUrlA;
	HBITMAP			hBmpUrlB;
	HBITMAP			hBmpUrl;
} MYVERINFO, *PMYVERINFO;

AJC_DLGPROC_DEF(MyVerInfo);

//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	VO		WINAPI	AjcAjrAppVersionDialogA  (HWND hOwner, C_BCP pVerStr, HBITMAP hBmp, int SrtYY, C_BCP pWndTtl, C_BCP pSubTtl, C_BCP pCpyRgt)
{
	AjcAjrAppVersionDialogExA(hOwner, pVerStr, (UX)hBmp, SrtYY, pWndTtl, pSubTtl, pCpyRgt, AJCVER_BMAP);
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
AJCEXPORT	VO		WINAPI	AjcAjrAppVersionDialogExA(HWND hOwner, C_BCP pVerStr, UX hBmpOrIcon, int SrtYY, C_BCP pWndTtl, C_BCP pSubTtl, C_BCP pCpyRgt, AJCVER_RESKND knd)
{
	MYVERINFO	vi;

	memset(&vi, 0, sizeof vi);
	vi.knd			= knd;
	vi.hTradeMark	= hBmpOrIcon;
	vi.SrtYY		= SrtYY;

	if (pVerStr != NULL) {MultiByteToWideChar(CP_ACP, 0, pVerStr, -1, vi.VerStr, AJCTSIZE(vi.VerStr)); vi.VerStr[AJCTSIZE(vi.VerStr) - 1] = 0;}
	else				 {vi.VerStr[0] = 0;}
	if (pWndTtl != NULL) {MultiByteToWideChar(CP_ACP, 0, pWndTtl, -1, vi.WndTtl, AJCTSIZE(vi.WndTtl)); vi.WndTtl[AJCTSIZE(vi.WndTtl) - 1] = 0;}
	else				 {vi.WndTtl[0] = 0;}
	if (pSubTtl != NULL) {MultiByteToWideChar(CP_ACP, 0, pSubTtl, -1, vi.SubTtl, AJCTSIZE(vi.SubTtl)); vi.SubTtl[AJCTSIZE(vi.SubTtl) - 1] = 0;}
	else				 {vi.SubTtl[0] = 0;}
	if (pCpyRgt != NULL) {MultiByteToWideChar(CP_ACP, 0, pCpyRgt, -1, vi.CpyRgt, AJCTSIZE(vi.CpyRgt)); vi.CpyRgt[AJCTSIZE(vi.CpyRgt) - 1] = 0;}
	else				 {vi.SubTtl[0] = 0;}

	DialogBoxParam(hDllInst, MAKEINTRESOURCE(IDD_AJRVERINFO), hOwner, AJC_DLGPROC_NAME(MyVerInfo), (LPARAM)&vi);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	VO		WINAPI	AjcAjrAppVersionDialogW  (HWND hOwner, C_WCP pVerStr, HBITMAP hBmp, int SrtYY, C_WCP pWndTtl, C_WCP pSubTtl, C_WCP pCpyRgt)
{
	AjcAjrAppVersionDialogExW(hOwner, pVerStr, (UX)hBmp, SrtYY, pWndTtl, pSubTtl, pCpyRgt, AJCVER_BMAP);
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
AJCEXPORT	VO		WINAPI	AjcAjrAppVersionDialogExW(HWND hOwner, C_WCP pVerStr, UX hBmpOrIcon, int SrtYY, C_WCP pWndTtl, C_WCP pSubTtl, C_WCP pCpyRgt, AJCVER_RESKND knd)
{
	MYVERINFO	vi;

	memset(&vi, 0, sizeof vi);
	vi.knd			= knd;
	vi.hTradeMark	= hBmpOrIcon;
	vi.SrtYY		= SrtYY;

	if (pVerStr != NULL) AjcSnPrintF(vi.VerStr, AJCTSIZE(vi.VerStr), L"%s", pVerStr);
	else				 vi.VerStr[0] = 0;
	if (pWndTtl != NULL) AjcSnPrintF(vi.WndTtl, AJCTSIZE(vi.WndTtl), L"%s", pWndTtl);
	else				 vi.WndTtl[0] = 0;
	if (pSubTtl != NULL) AjcSnPrintF(vi.SubTtl, AJCTSIZE(vi.SubTtl), L"%s", pSubTtl);
	else				 vi.SubTtl[0] = 0;
	if (pCpyRgt != NULL) AjcSnPrintF(vi.CpyRgt, AJCTSIZE(vi.CpyRgt), L"%s", pCpyRgt);
	else				 vi.CpyRgt[0] = 0;

	DialogBoxParam(hDllInst, MAKEINTRESOURCE(IDD_AJRVERINFO), hOwner, AJC_DLGPROC_NAME(MyVerInfo), (LPARAM)&vi);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	バージョン情報ダイアログ・プロシージャ																		//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(MyVerInfo, WM_INITDIALOG )
{
	PMYVERINFO	pW = (PMYVERINFO)lParam;
	SYSTEMTIME	lt;
	WC			LibVer[256];

	//----- ダイアログ用ワークアドレス設定 ---------------------------------------------------------------------//
	SetProp(hDlg, L"AjcMyVerInfo", (HANDLE)lParam);

	//----- アイコン設定 ---------------------------------------------------------------------------------------//
	SendMessage(hDlg, WM_SETICON, ICON_SMALL, (LPARAM)hIcoApp);

	//----- 日英テキスト ---------------------------------------------------------------------------------------//
	AjcSetDlgItemStr(hDlg, IDC_LBL_VER, LNGSEL(L"バージョン" , L"Version"	 ));
	AjcSetDlgItemStr(hDlg, IDC_LBL_SUP, LNGSEL(L"サポートURL", L"Support URL"));
	AjcSetDlgItemStr(hDlg, IDOK 	  , LNGSEL(L"ＯＫ"		 , L"OK"		 ));

	//----- ライブラリバージョン -------------------------------------------------------------------------------//
	AjcSnPrintF(LibVer, AJCTSIZE(LibVer), LNGSEL(L"AjrCstXX ライブラリ バージョン : %s", L"AjrCstXX Library Version : %s"), VersionStrW);
	AjcSetDlgItemStr(hDlg, IDC_LBL_LIBVER, LibVer);

	//----- ＵＲＬビットマップ設定 -----------------------------------------------------------------------------//
	AjcChangeBitmapColor((pW->hBmpUrlA	= LoadBitmap(hDllInst, MAKEINTRESOURCE(IDB_AJRURL_A  ))), RGB(255, 255, 255), GetSysColor(COLOR_BTNFACE));
	AjcChangeBitmapColor((pW->hBmpUrlB	= LoadBitmap(hDllInst, MAKEINTRESOURCE(IDB_AJRURL_B  ))), RGB(255, 255, 255), GetSysColor(COLOR_BTNFACE));

	//----- トレードマーク（ビットマップ or アイコン）表示 -----------------------------------------------------//
	if (pW->knd == AJCVER_BMAP) {
		ShowWindow(GetDlgItem(hDlg, IDC_PIC_ICON), SW_HIDE);
		SendDlgItemMessage(hDlg, IDC_PIC_BMAP, STM_SETIMAGE, IMAGE_BITMAP, (LPARAM)pW->hTradeMark);
	}
	else {
		ShowWindow(GetDlgItem(hDlg, IDC_PIC_BMAP), SW_HIDE);
		SendDlgItemMessage(hDlg, IDC_PIC_ICON, STM_SETIMAGE, IMAGE_ICON  , (LPARAM)pW->hTradeMark);
	}
	//----- ＵＲＬビットマップ表示 -----------------------------------------------------------------------------//
	SendDlgItemMessage(hDlg, IDC_PIC_URL , STM_SETIMAGE, IMAGE_BITMAP, (LPARAM)(pW->hBmpUrl = pW->hBmpUrlB));

	//----- テキスト表示 ---------------------------------------------------------------------------------------//
	SetWindowText(hDlg, pW->WndTtl);
	SetDlgItemText(hDlg, IDC_LBL_TTL, pW->SubTtl);
	SetDlgItemText(hDlg, IDC_TXT_VER, pW->VerStr);

	//----- コピーライトの表示 ---------------------------------------------------------------------------------//
	{	WC	txt[128];
		GetLocalTime(&lt);
		AjcSnPrintF(txt, AJCTSIZE(txt), L"(C) %d - %d by %s", pW->SrtYY, lt.wYear, pW->CpyRgt);
		AjcSetDlgItemStr(hDlg, IDC_LBL_CPYRGT, txt);
	}
	//----- ピクチャ（ＵＲＬ）カーソル監視タイマ起動 -----------------------------------------------------------//
	SetTimer(hDlg, 1, 100, NULL);

//	AjcMoveWindowToCenter(hDlg);

	return TRUE;
}
//----- タイマ -------------------------------------------------------------------------------------------------//
AJC_DLGPROC(MyVerInfo, WM_TIMER )
{
	PMYVERINFO	pW = (PMYVERINFO)GetProp(hDlg, L"AjcMyVerInfo");
	RECT		r;
	POINT		pt;

	GetWindowRect(GetDlgItem(hDlg, IDC_PIC_URL), &r);
	GetCursorPos(&pt);
	if (pt.x >= r.left && pt.x <= r.right && pt.y >= r.top && pt.y <= r.bottom) {
		if (pW->hBmpUrl != pW->hBmpUrlB) {
			pW->hBmpUrl  = pW->hBmpUrlB;
			SendDlgItemMessage(hDlg, IDC_PIC_URL , STM_SETIMAGE, IMAGE_BITMAP, (LPARAM)pW->hBmpUrl);
		}
	}
	else {
		if (pW->hBmpUrl != pW->hBmpUrlA) {
			pW->hBmpUrl  = pW->hBmpUrlA;
			SendDlgItemMessage(hDlg, IDC_PIC_URL , STM_SETIMAGE, IMAGE_BITMAP, (LPARAM)pW->hBmpUrl);
		}
	}

	return TRUE;
}
//----- ピクチャ（ＵＲＬ）--------------------------------------------------------------------------------------//
AJC_DLGPROC(MyVerInfo, IDC_PIC_URL		)
{
	PMYVERINFO	pW = (PMYVERINFO)GetProp(hDlg, L"AjcMyVerInfo");

	if (HIWORD(wParam) == STN_CLICKED) {
		ShellExecute(NULL, L"open", L"http://www.ne.jp/asahi/ajara/kojara/", NULL, NULL, SW_SHOWNORMAL);
	}

	return TRUE;
}
//----- ＯＫ ---------------------------------------------------------------------------------------------------//
AJC_DLGPROC(MyVerInfo, IDOK			)
{
	PMYVERINFO	pW = (PMYVERINFO)GetProp(hDlg, L"AjcMyVerInfo");

	//----- ダイアログ終了 ----------------------------//
	EndDialog(hDlg, IDOK);
	//----- ビットマップ削除 --------------------------//
	if (pW->hBmpUrlA != NULL) DeleteObject(pW->hBmpUrlA);
	if (pW->hBmpUrlB != NULL) DeleteObject(pW->hBmpUrlB);
	//----- ピクチャ（ＵＲＬ）カーソル監視タイマ停止 --//
	KillTimer(hDlg, 1);

	return TRUE;
}
//----- キャンセル ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(MyVerInfo, IDCANCEL		)
{
	PMYVERINFO	pW = (PMYVERINFO)GetProp(hDlg, L"AjcMyVerInfo");

	//----- ダイアログ終了 ----------------------------//
	EndDialog(hDlg, IDCANCEL);
	//----- ビットマップ削除 --------------------------//
	if (pW->hBmpUrlA != NULL) DeleteObject(pW->hBmpUrlA);
	if (pW->hBmpUrlB != NULL) DeleteObject(pW->hBmpUrlB);
	//----- ピクチャ（ＵＲＬ）カーソル監視タイマ停止 --//
	KillTimer(hDlg, 1);

	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(MyVerInfo)
	AJC_DLGMAP_MSG(MyVerInfo, WM_INITDIALOG	)
	AJC_DLGMAP_MSG(MyVerInfo, WM_TIMER		)

	AJC_DLGMAP_CMD(MyVerInfo, IDC_PIC_URL	)
	AJC_DLGMAP_CMD(MyVerInfo, IDOK			)
	AJC_DLGMAP_CMD(MyVerInfo, IDCANCEL		)
AJC_DLGMAP_END



//==============================================================================================================//
//	VisualStudio下での実行中（IDEによるデバッグ中）かチェックする												//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	TRUE  - VisualStudio配下での実行中（ＩＤＥによる実行中）										//
//				FALSE - プログラム(*.exe)単独で実行中、あるいは、VisualStudio起動時やデザイン時					//
//==============================================================================================================//
static	BOOL CALLBACK cbEnumThreadWindows(HWND hwnd, LPARAM lParam)
{
	BOOL	rc = TRUE;
	HWND	*phWndVisualStudio = (HWND *)lParam;
	WC		ttl[256];

	GetWindowText(hwnd, ttl, AJCTSIZE(ttl));
	ttl[255] = 0;
	if (wcsistr(ttl, L"Microsoft Visual Studio") != NULL && wcsistr(ttl, L"devenv.com") == NULL) {
		*phWndVisualStudio = hwnd;
		rc = FALSE;	// FALSE:列挙終了
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL WINAPI AjcIsRunUnderTheVisualStudio(VO)
{
	BOOL	rc				 = FALSE;
	HWND	hWndVisualStudio = NULL;
	UL		tid				 = GetCurrentThreadId();
	UL		pid				 = GetCurrentProcessId();
	UL		parent			 = 0;
	WC		fname[MAX_PATH]  = {0};

	//	自スレッドにVisualStudioのウインドがあるかチェック（ある場合は、起動時／デザイン時を意味する）
	hWndVisualStudio = NULL;
	EnumThreadWindows(tid, (WNDENUMPROC)cbEnumThreadWindows, (LPARAM)&hWndVisualStudio);

	//	自スレッドにVisualStudioのウインドが無い
	if (hWndVisualStudio == NULL) {
		//	VisualStudioの配下で実行されているかチェック
		while (AjcGetParentProcess(pid, &parent, fname, MAX_PATH)) {
			if (wcsicmp(fname, L"devenv.exe") == 0 || wcsicmp(fname, L"msvsmon.exe") == 0) {
				rc = TRUE;	//	TRUE : VisualStudioの配下で実行中
				break;
			}
			pid = parent;	//	-> 上位プロセスチェック
		}
	}
	return rc;
}
//==============================================================================================================//
//	デバッガの出力ウインドへ書式文字列出力																		//
//																												//
//	引　数：	pFmt - 書式文字列																				//
//																												//
//	戻り値：	なし																							//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT VO	 WINAPI AjcTraceA(C_BCP pFmt, ...)
{
	va_list vls;
	BC		txt[1024];

	if (pFmt != NULL) {
		#if (_WIN32_WINNT >= 0x0400) || (_WIN32_WINDOWS > 0x0400)
		if (IsDebuggerPresent()) {
		#endif
			va_start(vls, pFmt);
			_vsnprintf(txt, 1024, pFmt, vls);
			txt[1023] = 0;
			va_end	(vls);
			OutputDebugStringA(txt);
		#if (_WIN32_WINNT >= 0x0400) || (_WIN32_WINDOWS > 0x0400)
		}
		#endif
	}
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT VO	 WINAPI AjcTraceW(C_WCP pFmt, ...)
{
	va_list vls;
	UW		txt[1024];

	if (pFmt != NULL) {
		#if (_WIN32_WINNT >= 0x0400) || (_WIN32_WINDOWS > 0x0400)
		if (IsDebuggerPresent()) {
		#endif
			va_start(vls, pFmt);
			_vsnwprintf(txt, 1024, pFmt, vls);
			txt[1023] = 0;
			va_end	(vls);
			OutputDebugStringW(txt);
		#if (_WIN32_WINNT >= 0x0400) || (_WIN32_WINDOWS > 0x0400)
		}
		#endif
	}
}

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	ＭＳＩＬ用サポートコード																					//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

//==============================================================================================================//
//	Ｃ＃書式の "{{" と "}}" を 0xFFFA と 0xFFFB に変換した文字列作成											//
//																												//
//	引　数	：	pFmt	- Ｃ＃書式文字列																		//
//				pBuf	- 変換した文字列を格納するバッファのアドレス											//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
AJCEXPORT	VO	WINAPI	AjcMsilEncDblBrktW(C_WCP pFmt, WCP pBuf)
{
	while (*pFmt != 0) {
		//	"{{" -> 0xFFFA 変換
		if		(*pFmt == L'{' && *(pFmt + 1) == L'{') {
			pFmt += 2;
			*pBuf++ = 0xFFFA;
		}
		//	"}}" -> 0xFFFB 変換
		else if	(*pFmt == L'}' && *(pFmt + 1) == L'}') {
			pFmt += 2;
			*pBuf++ = 0xFFFB;
		}
		//	"{" ならば、書式項目をバッファに設定
		else if (*pFmt == L'{') {
			//	"}" の直前までバッファに設定
			while (*pFmt != L'}' && *pFmt != 0) {
				*pBuf++ = *pFmt++;
			}
			//	終端("}")をバッファに設定
			if (*pFmt == L'}') {
				*pBuf++ = *pFmt++;
			}
		}
		//	その他ならば、当該文字をバッファに格納
		else {
			*pBuf++ = *pFmt++;
		}
	}
	//	文字列終端設定
	*pBuf = 0;
}
//==============================================================================================================//
//	Ｃ＃書式用置換文字列の "{" と "}" を 0xFFFA と 0xFFFB に変換した文字列作成									//
//																												//
//	引　数	：	pStr	- Ｃ＃書式文字列																		//
//				pBuf	- 変換した文字列を格納するバッファのアドレス											//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
AJCEXPORT	VO	WINAPI	AjcMsilEncBrktW(C_WCP pStr, WCP pBuf)
{
	while (*pStr != 0) {
		//	"{" -> 0xFFFA 変換
		if		(*pStr == L'{') {
			pStr++;
			*pBuf++ = 0xFFFA;
		}
		//	"}" -> 0xFFFB 変換
		else if	(*pStr == L'}') {
			pStr++;
			*pBuf++ = 0xFFFB;
		}
		//	その他ならば、当該文字をバッファに格納
		else {
			*pBuf++ = *pStr++;
		}
	}
	//	文字列終端設定
	*pBuf = 0;
}
//==============================================================================================================//
//	Ｃ＃書式結果文字列の "{" と "}" を 復元																		//
//																												//
//	引　数	：	pStr	- Ｃ＃書式変換結果文字列																//
//				pBuf	- 変換した文字列を格納するバッファのアドレス											//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
AJCEXPORT	VO	WINAPI	AjcMsilRcvBrktW(C_WCP pStr, WCP pBuf)
{
	while (*pStr != 0) {
		//	0xFFFA -> "{"
		if		(*pStr == 0xFFFA) {
			pStr++;
			*pBuf++ = L'{';
		}
		//	0xFFFB -> "}"
		else if (*pStr == 0xFFFB) {
			pStr++;
			*pBuf++ = L'}';
		}
		//	その他ならば、当該文字をバッファに格納
		else {
			*pBuf++ = *pStr++;
		}
	}
	//	文字列終端設定
	*pBuf = 0;
}
//==============================================================================================================//
//	Ｃ＃書式項目取得（文字列から "{n...}" 部分を取り出す）														//
//																												//
//	引　数	：	pFmt	- Ｃ＃書式文字列																		//
//				pBuf	- Ｃ＃書式項目文字列を格納するバッファのアドレス										//
//																												//
//	戻り値	：	≠-1 : 書式項目番号																				//
//				＝-1 : 書式項目なし																				//
//==============================================================================================================//
AJCEXPORT	int		WINAPI	AjcMsilGetFormatItemW(C_WCP pFmt, WCP pBuf)
{
	int		rc = -1;
	int		ix;

	while (*pFmt != 0) {
		//	"{" ならば、書式項目抽出
		if (*pFmt == L'{') {
			//	書式項目番号設定
			if (MAjcAscIsDigitW(*(pFmt + 1))) ix = _wtoi(pFmt + 1);
			else					   ix = 0;
			//	バッファに "}" の直前まで設定
			while (*pFmt != L'}' && *pFmt >= 0x20 && *pFmt <= 0x7E) {
				*pBuf++ = *pFmt++;
			}
			//	バッファに "}" を設定
			if (*pFmt == L'}') {
				*pBuf++ = *pFmt++;
			}
			rc = ix;
			break;
		}
		//	その他ならば、ポインタ更新
		else {
			pFmt++;
		}
	}
	//	文字列終端設定
	*pBuf = 0;

	return rc;
}
//==============================================================================================================//
//	Ｃ＃書式のインデクスを "0" にした文字列作成（ "{n:...}" --> "{0...}" ）										//
//																												//
//	引　数	：	pFmt	- Ｃ＃書式項目文字列("{n...")															//
//				pBuf	- Ｃ＃書式項目文字列を格納するバッファのアドレス										//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
AJCEXPORT	VO		WINAPI	AjcMsilFormatIxToZeroW(C_WCP pFmt, WCP pBuf)
{
	if (*pFmt == L'{' && MAjcAscIsDigitW(*(pFmt + 1))) {
		//	バッファに "{0" 設定
		*pBuf++ = L'{';
		*pBuf++ = L'0';
		//	"{" スキップ
		pFmt++;
		//	数字スキップ
		while (MAjcAscIsDigitW(*pFmt)) {
			pFmt++;
		}
		//	書式インデクスの次の部分を設定
		while (*pFmt != L'}' && *pFmt != 0) {
			*pBuf++ = *pFmt++;
		}
		//	終端("}")のチェックと設定
		if (*pFmt == L'}') {
			*pBuf++ = *pFmt++;
		}
	}
	//	文字列終端設定
	*pBuf = 0;
}
//==============================================================================================================//
//	ポインタが示す文字列をバッファに格納																		//
//																												//
//	引　数	：	pStr	- 文字列へのポインタ																	//
//				pBuf	- 格納するバッファのアドレス															//
//				len		- 格納するバッファの文字数（終端を含む）												//
//																												//
//	戻り値	：	文字列へのポインタ																				//
//==============================================================================================================//
AJCEXPORT	VO		WINAPI	AjcPtrToStringW(C_WCP pStr, WCP pBuf, UI len)
{
	if (pBuf != NULL && len > 0) {
		if (pStr != NULL) {
			wcsncpy(pBuf, pStr, len);
			pBuf[len -1] = 0;
		}
		else {
			*pBuf = 0;
		}
	}
}
//==============================================================================================================//
//	ポインタが示す文字列の長さを得る																			//
//																												//
//	引　数	：	pStr	- 文字列へのポインタ																	//
//																												//
//	戻り値	：	文字列へのポインタ																				//
//==============================================================================================================//
AJCEXPORT	int		WINAPI	AjcPtrToStrLenW(C_WCP pStr)
{
	int		rc = 0;

	if (pStr != NULL) {
		rc = (int)wcslen(pStr);
	}
	return rc;
}

