﻿#include	"AjcInternal.h"

#define	INST_ID			0xFED49C21
#define	IS_MY_INST(P)	(P != NULL && P->InstID == INST_ID)

//**************************************************************************************************************//
//																												//
//	スレッド間・固定長メールボックス通信																		//
//																												//
//**************************************************************************************************************//

//==============================================================================================================//
//	インスタンス生成																							//
//																												//
//	引　数	：	MailSize  - メールデータサイズ（バイト数）														//
//				cbp 	  - コールバックパラメタ																//
//				cbRemove  - メール消去通知用コールバック（不要時はＮＵＬＬ）									//
//																												//
//	戻り値	：	≠ＮＵＬＬ：ＯＫ（インスタンスハンドル（＝インスタンスワークアドレス））						//
//				＝ＮＵＬＬ：エラー																				//
//==============================================================================================================//
AJCEXPORT	HAJCFMBX	WINAPI	AjcFMbxCreate(UI MailSize, UX cbp, VO (CALLBACK *cbRemove)(VOP pDat, UX cbp))
{
	HAJCFMBX	pW;
	BOOL		fErr = TRUE;

	if ((pW = (HAJCFMBX)AJCMEM(sizeof(AJCFMBX))) != NULL) {
		memset(pW, 0, sizeof *pW);
		pW->InstID = INST_ID;
		do {
			if ((pW->hEvt  = CreateEvent(NULL, FALSE, FALSE, NULL))  == NULL) break;
			if ((pW->hFQue = AjcFQueCreate(MailSize, cbp, cbRemove)) == NULL) break;
			InitializeCriticalSection(&pW->cs);
			fErr = FALSE;
		} while (0);

		if (fErr) {
			if (pW->hEvt  != NULL) CloseHandle(pW->hEvt);
			if (pW->hFQue != NULL) AjcFQueDelete(pW->hFQue);
			free(pW);
			pW = NULL;
		}
	}
	return pW;
}
//==============================================================================================================//
//	インスタンス消去																							//
//																												//
//	引　数	：	pW 		  - インスタンスハンドル																//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
AJCEXPORT	VO			WINAPI	AjcFMbxDelete(HAJCFMBX pW)
{
	if (IS_MY_INST(pW)) {
		if (pW->hEvt  != NULL) CloseHandle(pW->hEvt);
		if (pW->hFQue != NULL) AjcFQueDelete(pW->hFQue);
		DeleteCriticalSection(&pW->cs);
		free(pW);
	}
}

//==============================================================================================================//
//	末尾へメールデータ追加																						//
//																												//
//	引　数	：	pW 	 - インスタンスハンドル																		//
//				pDat - 末尾へ挿入するメールデータのアドレス														//
//																												//
//	戻り値	：	ＴＲＵＥ　：ＯＫ																				//
//				ＦＡＬＳＥ：エラー																				//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcFMbxEnque	(HAJCFMBX pW, C_VOP pDat)
{
	BOOL		rc = FALSE;

	if (IS_MY_INST(pW)) {
		if (pDat != NULL) {
			EnterCriticalSection(&pW->cs);
			if (rc = AjcFQueEnque(pW->hFQue, pDat)) {
				rc = SetEvent(pW->hEvt);
			}
			LeaveCriticalSection(&pW->cs);
		}
	}
	return rc;
}
//==============================================================================================================//
//	先頭へメールデータ挿入																						//
//																												//
//	引　数	：	pW 	 - インスタンスハンドル																		//
//				pDat - 先頭へ挿入するノードデータのアドレス														//
//																												//
//	戻り値	：	ＴＲＵＥ　：ＯＫ																				//
//				ＦＡＬＳＥ：エラー																				//
//==============================================================================================================//
AJCEXPORT	BOOL 		WINAPI	AjcFMbxEnqTop	(HAJCFMBX pW, C_VOP pDat)
{
	BOOL		rc = FALSE;

	if (IS_MY_INST(pW)) {
		if (pDat != NULL) {
			EnterCriticalSection(&pW->cs);
			if (rc = AjcFQueEnqTop(pW->hFQue, pDat)) {
				rc = SetEvent(pW->hEvt);
			}
			LeaveCriticalSection(&pW->cs);
		}
	}
	return rc;
}
//==============================================================================================================//
//	先頭メールデータを取り出す																					//
//																												//
//	引　数	：	pW 	   - インスタンスハンドル																	//
//				pBuf   - 取り出したメールデータを格納するバッファのアドレス										//
//				msTime - 待ち時間[ms]（－１の場合は無限）														//
//																												//
//	戻り値	：	≠０：取り出したメールデータのバイト数															//
//				＝０：メールなし／エラー																		//
//==============================================================================================================//
AJCEXPORT	UI			WINAPI	AjcFMbxDeque	(HAJCFMBX pW, VOP pBuf, UI msTime)
{
	UI			rc = 0;

	if (IS_MY_INST(pW)) {
		if (pBuf != NULL) {
			EnterCriticalSection(&pW->cs);
			if (rc = AjcFQueDeque(pW->hFQue, pBuf)) {
				ResetEvent(pW->hEvt);
				LeaveCriticalSection(&pW->cs);
			}
			else {
				LeaveCriticalSection(&pW->cs);
				if (WaitForSingleObject(pW->hEvt, msTime == -1 ? INFINITE : msTime) == WAIT_OBJECT_0) {
					EnterCriticalSection(&pW->cs);
					rc = AjcFQueDeque(pW->hFQue, pBuf);
					LeaveCriticalSection(&pW->cs);
				}
				else {
					rc = 0;
				}
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	全メールデータを消去する																					//
//																												//
//	引　数	：	pW 		  - インスタンスハンドル																//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
AJCEXPORT	VO			WINAPI	AjcFMbxPurge	(HAJCFMBX pW)
{
	if (IS_MY_INST(pW)) {
		EnterCriticalSection(&pW->cs);
		AjcFQuePurge(pW->hFQue);
		LeaveCriticalSection(&pW->cs);
	}
}
//==============================================================================================================//
//	現在のメールデータ数を得る																					//
//																												//
//	引　数	：	pW 	 - インスタンスハンドル																		//
//																												//
//	戻り値	：	現在のノード数																					//
//==============================================================================================================//
AJCEXPORT	UI	  WINAPI	AjcFMbxGetCount	(HAJCFMBX pW)
{
	UI		rc = 0;

	if (IS_MY_INST(pW)) {
		EnterCriticalSection(&pW->cs);
		rc = AjcFQueGetCount(pW->hFQue);
		LeaveCriticalSection(&pW->cs);
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	UI	  WINAPI	AjcFMbxNumber	(HAJCFMBX pW)
{
	return AjcFMbxGetCount(pW);
}
