﻿#include	"AjcInternal.h"

#define	INST_ID			0x92134BE6
#define	IS_MY_INST(P)	(P != NULL && P->InstID == INST_ID)

//**************************************************************************************************************//
//																												//
//	スレッド間・可変長メールボックス通信																		//
//																												//
//**************************************************************************************************************//

//==============================================================================================================//
//	インスタンス生成																							//
//																												//
//	引　数	：	cbp 	  - コールバックパラメタ																//
//				cbRemove  - メール消去通知用コールバック（不要時はＮＵＬＬ）									//
//																												//
//	戻り値	：	≠ＮＵＬＬ：ＯＫ（インスタンスハンドル（＝インスタンスワークアドレス））						//
//				＝ＮＵＬＬ：エラー																				//
//==============================================================================================================//
AJCEXPORT	HAJCVMBX	WINAPI	AjcVMbxCreate(UX cbp, VO (CALLBACK *cbRemove)(VOP pDat, UI lDat, UX cbp))
{
	HAJCVMBX	pW;
	BOOL		fErr = TRUE;

	if ((pW = (HAJCVMBX)AJCMEM(sizeof(AJCVMBX))) != NULL) {
		memset(pW, 0, sizeof *pW);
		pW->InstID = INST_ID;
		do {
			if ((pW->hEvt  = CreateEvent(NULL, FALSE, FALSE, NULL))  == NULL) break;
			if ((pW->hVQue = AjcVQueCreate(cbp, cbRemove))			 == NULL) break;
			InitializeCriticalSection(&pW->cs);
			fErr = FALSE;
		} while (0);

		if (fErr) {
			if (pW->hEvt  != NULL) CloseHandle(pW->hEvt);
			if (pW->hVQue != NULL) AjcVQueDelete(pW->hVQue);
			free(pW);
			pW = NULL;
		}
	}
	return pW;
}
//==============================================================================================================//
//	インスタンス消去																							//
//																												//
//	引　数	：	pW 		  - インスタンスハンドル																//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
AJCEXPORT	VO			WINAPI	AjcVMbxDelete(HAJCVMBX pW)
{
	if (IS_MY_INST(pW)) {
		if (pW->hEvt  != NULL) CloseHandle(pW->hEvt);
		if (pW->hVQue != NULL) AjcVQueDelete(pW->hVQue);
		DeleteCriticalSection(&pW->cs);
		free(pW);
	}
}

//==============================================================================================================//
//	メールデータ通知																							//
//																												//
//	引　数	：	pW 	 - インスタンスハンドル																		//
//				pDat - 通知するメールデータのアドレス															//
//				lDat - 通知するメールデータのバイト数															//
//																												//
//	戻り値	：	ＴＲＵＥ　：ＯＫ																				//
//				ＦＡＬＳＥ：エラー																				//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcVMbxEnque	(HAJCVMBX pW, C_VOP pDat, UI lDat)
{
	BOOL		rc = FALSE;

	if (IS_MY_INST(pW)) {
		EnterCriticalSection(&pW->cs);
		if (rc = AjcVQueEnque(pW->hVQue, pDat, lDat)) {
			rc = SetEvent(pW->hEvt);
		}
		LeaveCriticalSection(&pW->cs);
	}
	return rc;
}
//==============================================================================================================//
//	優先メールデータ通知																						//
//																												//
//	引　数	：	pW 	 - インスタンスハンドル																		//
//				pDat - 先頭へ挿入するノードデータのアドレス														//
//				lDat - 通知するメールデータのバイト数															//
//																												//
//	戻り値	：	ＴＲＵＥ　：ＯＫ																				//
//				ＦＡＬＳＥ：エラー																				//
//==============================================================================================================//
AJCEXPORT	BOOL 		WINAPI	AjcVMbxEnqTop	(HAJCVMBX pW, C_VOP pDat, UI lDat)
{
	BOOL		rc = FALSE;

	if (IS_MY_INST(pW)) {
		EnterCriticalSection(&pW->cs);
		if (rc = AjcVQueEnqTop(pW->hVQue, pDat, lDat)) {
			rc = SetEvent(pW->hEvt);
		}
		LeaveCriticalSection(&pW->cs);
	}
	return rc;
}
//==============================================================================================================//
//	先頭メールデータを取り出す																					//
//																												//
//	引　数	：	pW 	   - インスタンスハンドル																	//
//				pBuf   - 取り出したメールデータを格納するバッファのアドレス										//
//				lBuf   - 取り出したメールデータを格納するバッファのバイト数										//
//				msTime - 待ち時間[ms]（－１の場合は無限）														//
//																												//
//	戻り値	：	≠０：取り出したメールデータのバイト数															//
//				＝０：メールなし／エラー																		//
//==============================================================================================================//
AJCEXPORT	UI			WINAPI	AjcVMbxDeque	(HAJCVMBX pW, VOP pBuf, UI lBuf, UI msTime)
{
	UI			rc = 0;

	if (IS_MY_INST(pW)) {
		EnterCriticalSection(&pW->cs);
		if (rc = AjcVQueDeque(pW->hVQue, pBuf, lBuf)) {
			ResetEvent(pW->hEvt);
			LeaveCriticalSection(&pW->cs);
		}
		else {
			LeaveCriticalSection(&pW->cs);
			if (WaitForSingleObject(pW->hEvt, msTime == -1 ? INFINITE : msTime) == WAIT_OBJECT_0) {
				EnterCriticalSection(&pW->cs);
				rc = AjcVQueDeque(pW->hVQue, pBuf, lBuf);
				LeaveCriticalSection(&pW->cs);
			}
			else {
				rc = 0;
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	先頭メールデータを取り出す（新）																			//
//																												//
//	引　数	：	pW 	   - インスタンスハンドル																	//
//				pBuf   - 取り出したメールデータを格納するバッファのアドレス										//
//				lBuf   - 取り出したメールデータを格納するバッファのバイト数										//
//				msTime - 待ち時間[ms]（－１の場合は無限）														//
//																												//
//	戻り値	：	≠０：取り出したメールデータのバイト数															//
//				＝-1：メールなし／エラー																		//
//==============================================================================================================//
AJCEXPORT	UI			WINAPI	AjcVMbxDequeEx	(HAJCVMBX pW, VOP pBuf, UI lBuf, UI msTime)
{
	UI			rc = -1;

	if (IS_MY_INST(pW)) {
		EnterCriticalSection(&pW->cs);
		if ((rc = AjcVQueDequeEx(pW->hVQue, pBuf, lBuf)) != -1) {
			ResetEvent(pW->hEvt);
			LeaveCriticalSection(&pW->cs);
		}
		else {
			LeaveCriticalSection(&pW->cs);
			if (WaitForSingleObject(pW->hEvt, msTime == -1 ? INFINITE : msTime) == WAIT_OBJECT_0) {
				EnterCriticalSection(&pW->cs);
				rc = AjcVQueDequeEx(pW->hVQue, pBuf, lBuf);
				LeaveCriticalSection(&pW->cs);
			}
			else {
				rc = -1;
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	全メールデータを消去する																					//
//																												//
//	引　数	：	pW 		  - インスタンスハンドル																//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
AJCEXPORT	VO			WINAPI	AjcVMbxPurge	(HAJCVMBX pW)
{
	if (IS_MY_INST(pW)) {
		EnterCriticalSection(&pW->cs);
		AjcVQuePurge(pW->hVQue);
		LeaveCriticalSection(&pW->cs);
	}
}
//==============================================================================================================//
//	現在のメールデータ数を得る																					//
//																												//
//	引　数	：	pW 	 - インスタンスハンドル																		//
//																												//
//	戻り値	：	現在のノード数																					//
//==============================================================================================================//
AJCEXPORT	UI	  WINAPI	AjcVMbxGetCount	(HAJCVMBX pW)
{
	UI		rc = 0;

	if (IS_MY_INST(pW)) {
		EnterCriticalSection(&pW->cs);
		rc = AjcVQueGetCount(pW->hVQue);
		LeaveCriticalSection(&pW->cs);
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	UI	  WINAPI	AjcVMbxNumber	(HAJCVMBX pW)
{
	return AjcVMbxGetCount(pW);
}
//==============================================================================================================//
//	現在のメールデータの総バイト数取得																			//
//																												//
//	引　数	：	pW 	 - インスタンスハンドル																		//
//																												//
//	戻り値	：	現在のメールデータの総バイト数																	//
//==============================================================================================================//
AJCEXPORT	ULL	  		WINAPI	AjcVMbxGetTotalBytes(HAJCVMBX pW)
{
	ULL			rc = 0;
	PAJCVQNODE	pNode;
	UI			bytes;

	if (IS_MY_INST(pW)) {
		EnterCriticalSection(&pW->cs);
		if (pNode = (PAJCVQNODE)AjcVQueTopNode(pW->hVQue, &bytes)) {
			do {
				rc += bytes;
			} while (pNode = AjcVQueNextNode(pW->hVQue, pNode, &bytes));
		}
		LeaveCriticalSection(&pW->cs);
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	ULL	  		WINAPI	AjcVMbxBytes	(HAJCVMBX pW)
{
	return AjcVMbxGetTotalBytes(pW);
}
