﻿#include	"AjcInternal.h"

//==============================================================================================================//
//	Function	:	マルチモニタ全体の矩形情報情報の取得														//
//																												//
//	Argument	:	pRect - マルチモニタ全体の矩形情報情報を格納するバッファのアドレス（不要時はNULL)			//
//																												//
//	Return		:	モニタ数																					//
//==============================================================================================================//
AJCEXPORT	UI		WINAPI	AjcGetMonitorsRect(LPRECT pRect)
{
	UI				rc = 0;
	int				i;
	RECT			r;
	AJCMONITORSINFO	MonInfo;

	AjcGetMonitorsInfo(&MonInfo);
	if (MonInfo.nMon != 0) {
		r.left	 = INT_MAX;
		r.right  = INT_MIN;
		r.top	  = INT_MAX;
		r.bottom = INT_MIN;
		for (i = 0; i < MonInfo.nMon ; i++) {
			r.left	 = __min(r.left   , MonInfo.rcMon[i].left  );
			r.right  = __max(r.right  , MonInfo.rcMon[i].right );
			r.top	 = __min(r.top	  , MonInfo.rcMon[i].top   );
			r.bottom = __max(r.bottom , MonInfo.rcMon[i].bottom);
		}
		rc = MonInfo.nMon;
	}
	if (pRect != NULL) {
		memcpy(pRect, &r, sizeof(RECT));
	}
	return rc;
}

//==============================================================================================================//
//	Function	:	各モニタ矩形情報情報の取得																	//
//																												//
//	Argument	:	pMonInfo - 各モニタ矩形情報を格納するバッファのアドレス										//
//																												//
//	Return		:	モニタ数																					//
//==============================================================================================================//
//	ディスプレィ情報通知
static	BOOL CALLBACK cbAgmiEnumDisplay(HMONITOR hMon, HDC hdcMon, LPRECT prcMon, LPARAM lParam)
{
	BOOL				rc = TRUE;
	PAJCMONITORSINFO	pMonInfo = (PAJCMONITORSINFO)lParam;
	HMONITOR			hMonitor = NULL;
	MONITORINFOEX		MonitorInfoEx;
	POINT				pt;

	if (pMonInfo->nMon < AJCMAX_MONITORS) {
		memcpy(&pMonInfo->rcMon[pMonInfo->nMon], prcMon, sizeof(RECT));
		pt.x = (prcMon->left + prcMon->right) / 2;
		pt.y = (prcMon->top + prcMon->bottom) / 2;
		hMonitor = MonitorFromPoint(pt, MONITOR_DEFAULTTONEAREST);
		memset(&MonitorInfoEx, 0, sizeof MonitorInfoEx);
		MonitorInfoEx.cbSize = sizeof(MonitorInfoEx);
		GetMonitorInfo(hMonitor, (LPMONITORINFO)&MonitorInfoEx);
		memcpy(&pMonInfo->rcWork[pMonInfo->nMon], &MonitorInfoEx.rcWork, sizeof(RECT));
		pMonInfo->nMon++;
		rc = TRUE;
	}
	else {
		rc = FALSE;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	UI		WINAPI	AjcGetMonitorsInfo(PAJCMONITORSINFO pMonInfo)
{
	int				nDisplay = 0;

	//----- モニタ数取得 ---------------------------------------------------------------//
	nDisplay = GetSystemMetrics(SM_CMONITORS);

	if (pMonInfo != NULL) {
		//----- ワーククリアー ---------------------------------------------------------//
		memset(pMonInfo, 0, sizeof(AJCMONITORSINFO));
		//----- 全ディスプレイの矩形情報を設定 -----------------------------------------//
		EnumDisplayMonitors(NULL, NULL, cbAgmiEnumDisplay, (LPARAM)pMonInfo);
	}
	return	nDisplay;
}
//==============================================================================================================//
//	Function	:	プライマリモニタ矩形情報情報の取得															//
//																												//
//	Argument	:	pMonInfo - プライマモニタ矩形情報を格納するバッファのアドレス			（不要時はNULL)		//
//					pRcWork  - プライマリモニタ作業領域矩形情報を格納するバッファのアドレス	（不要時はNULL)		//
//																												//
//	Return		:	モニタ数																					//
//==============================================================================================================//
//	コールバックパラメタ
typedef struct {
	BOOL	rc;
	LPRECT	pRcMon;
	LPRECT	pRcWork;
} CBAGPMI, *PCBAGPMI;
//	ディスプレィ情報通知
static	BOOL CALLBACK cbAgpmiEnumDisplay(HMONITOR hMon, HDC hdcMon, LPRECT prcMon, LPARAM lParam)
{
	BOOL				rc = TRUE;
	PCBAGPMI			pCbp = (PCBAGPMI)lParam;
	HMONITOR			hMonitor = NULL;
	MONITORINFOEX		MonitorInfoEx;
	POINT				pt;

	pt.x = (prcMon->left + prcMon->right) / 2;
	pt.y = (prcMon->top + prcMon->bottom) / 2;
	hMonitor = MonitorFromPoint(pt, MONITOR_DEFAULTTONEAREST);
	memset(&MonitorInfoEx, 0, sizeof MonitorInfoEx);
	MonitorInfoEx.cbSize = sizeof(MonitorInfoEx);
	GetMonitorInfo(hMonitor, (LPMONITORINFO)&MonitorInfoEx);
	if (MonitorInfoEx.dwFlags == MONITORINFOF_PRIMARY) {
		pCbp->rc = TRUE;
		if (pCbp->pRcMon  != NULL) memcpy(pCbp->pRcMon , &MonitorInfoEx.rcMonitor, sizeof(RECT));
		if (pCbp->pRcWork != NULL) memcpy(pCbp->pRcWork, &MonitorInfoEx.rcWork	 , sizeof(RECT));
		rc = FALSE;
	}
	else rc = TRUE;

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcGetPrimaryMonitorInfo(LPRECT pRcMon, LPRECT pRcWork)
{
	CBAGPMI	cbp;

	//	プライマリディスプレイの矩形情報を検索
	cbp.rc		= FALSE;
	cbp.pRcMon	= pRcMon;
	cbp.pRcWork = pRcWork;
	EnumDisplayMonitors(NULL, NULL, cbAgpmiEnumDisplay, (LPARAM)&cbp);

	return	cbp.rc;
}
//==============================================================================================================//
//	Function	:	ポイントが所属するモニタ矩形情報の取得														//
//																												//
//	Argument	:	x, y	- ポイント情報																		//
//					pRcMon	- モニタの矩形情報を格納するバッファのアドレス		（不要時はNULL）				//
//					prcWork - ワークアリアの矩形情報を格納するバッファのアドレス（不要時はNULL）				//
//																												//
//	Return		:	TRUE  - 正常																				//
//					FALSE - エラー／いずれのモニタにも所属していない											//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcGetMonitorInfoOfPoint(int x,int y,  LPRECT pRcMon, LPRECT pRcWork)
{
	BOOL			rc = FALSE;
	UI				i, nMon;
	AJCMONITORSINFO	ifMon;

	//	各モニタ矩形情報取得
	nMon = AjcGetMonitorsInfo(&ifMon);
	//	所属するモニタを検索
	for (i = 0; i < nMon; i++) {
		if (x >= ifMon.rcMon[i].left && x < ifMon.rcMon[i].right &&
			y >= ifMon.rcMon[i].top  && y < ifMon.rcMon[i].bottom) {
			if (pRcMon	!= NULL) memcpy(pRcMon , &ifMon.rcMon [i], sizeof(RECT));
			if (pRcWork != NULL) memcpy(pRcWork, &ifMon.rcWork[i], sizeof(RECT));
			rc = TRUE;
			break;
		}
	}
	//	どのモニタにも所属しない場合は、プライマリモニタの矩形情報を設定
	if (rc == FALSE) {
		AjcGetPrimaryMonitorInfo(pRcMon, pRcWork);
	}
	return rc;
}
//==============================================================================================================//
//	Function	:	ウインドが所属するモニタ矩形情報の取得														//
//																												//
//	Argument	:	hwnd	- ウインドハンドル																	//
//					pRcMon	- モニタの矩形情報を格納するバッファのアドレス										//
//					prcWork - ワークアリアの矩形情報を格納するバッファのアドレス								//
//																												//
//	Return		:	TRUE  - 正常																				//
//					FALSE - エラー／いずれのモニタにも所属していない											//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcGetMonitorInfoOfWindow(HWND hwnd, LPRECT pRcMon, LPRECT pRcWork)
{
	BOOL			rc = FALSE;
	UI				i, nMon;
	AJCMONITORSINFO	ifMon;
	RECT			rcWnd;
	UI				sq;
	UI				sqMax = 0;
	UI				ixMax = -1;

	if (IsWindow(hwnd)) {
		//	各モニタ矩形情報取得
		nMon = AjcGetMonitorsInfo(&ifMon);
		//	ウインド矩形情報取得
		AjcGetWindowNormalRect(hwnd, &rcWnd);
		//	所属するモニタを検索
		for (i = 0; i < nMon; i++) {
			sq = AjcGetDupRect(&rcWnd, &ifMon.rcMon[i], NULL);
			if (sqMax < sq) {
				sqMax = sq;
				ixMax = i;
			}
		}
		if (ixMax != -1) {
			if (pRcMon	!= NULL) memcpy(pRcMon , &ifMon.rcMon [ixMax], sizeof(RECT));
			if (pRcWork != NULL) memcpy(pRcWork, &ifMon.rcWork[ixMax], sizeof(RECT));
			rc = TRUE;
		}
	}
	//	どのモニタにも所属しない／エラーの場合は、プライマリモニタの矩形情報を設定
	if (rc == FALSE) {
		AjcGetPrimaryMonitorInfo(pRcMon, pRcWork);
	}

	return rc;
}
//==============================================================================================================//
//	Function	:	ウインドが属するモニタ内に収まるようなウインド情報取得										//
//																												//
//	Argument	:	hwnd	- ウインドハンドル																	//
//					pPoint	- ウインド移動先の位置を格納するバッファのアドレス（不要時はNULL)					//
//					pSize	- ウインドの変更サイズを格納するバッファのアドレス（不要時はNULL)					//
//					pFlag	- ウインド変更オプション（不要時はNULL)												//
//																												//
//	Return		:	TRUE  - ウインドがモニタを超えている														//
//					FALSE - ウインドはモニタ内に収まっている													//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcGetWndInfoToFitOnMonitor(HWND hwnd, LPPOINT pPoint, LPSIZE pSize, UIP pFlag)
{
	BOOL	rc = FALSE;
	RECT	rcM;
	int		cxM, cyM;
	RECT	r;
	int		x, y, cx, cy;
	int		op = (SWP_NOSIZE | SWP_NOMOVE);

	if (IsWindow(hwnd)) {
		//	モニタ矩形情報取得
		AjcGetMonitorInfoOfWindow(hwnd, NULL, &rcM);
		cxM = rcM.right - rcM.left;
		cyM = rcM.bottom - rcM.top;
		//	ウインド矩形情報取得
		GetWindowRect(hwnd, &r);
		x  = r.left;
		y  = r.top;
		cx = r.right - r.left;
		cy = r.bottom - r.top;
		//	ウインドサイズがモニタサイズより大きい場合は、ウインドサイズ変更
		if (cx > cxM || cy > cyM) {
			cx = __min(cx, cxM);
			cy = __min(cy, cyM);
			op &= ~SWP_NOSIZE;
		}
		//	ウインドの左右端／上下端がモニタを超える場合は、ウインド位置変更
		if (x < rcM.left || y < rcM.top || x + cx >= rcM.right || y + cy >= rcM.bottom) {
			if (x      <  rcM.left  ) x = rcM.left;
			if (y      <  rcM.top   ) x = rcM.top;
			if (x + cx >= rcM.right ) x = (rcM.right  - cx);
			if (y + cy >= rcM.bottom) y = (rcM.bottom - cy);
			op &= ~SWP_NOMOVE;
		}
		//	ウインド位置，サイズを返す
		if (op != (SWP_NOSIZE | SWP_NOMOVE)) {
			if (pPoint != NULL) {pPoint->x = x;  pPoint->y = y; }
			if (pSize  != NULL) {pSize->cx = cx; pSize->cy = cy;}
			if (pFlag  != NULL) {*pFlag = op;}
			rc = TRUE;
		}
	}
	return rc;
}
