﻿#include	"AjcInternal.h"

//**************************************************************************************************************//
//																												//
//	メッセージマップ（ウインド／ダイアログプロシージャの簡素化）												//
//																												//
//**************************************************************************************************************//

#define	AJCMMP_DEFWNDPROC_PROP	"AjcMmpSubClassProp"

static	VO			SubMmpInitTbl(PAJCMSGTBL pMsgTbl, PAJCMSGCHAINPTR pChain, BOOL fUnicode);
static	BOOL		SubSetProp	 (HWND hwnd, C_BCP pName, WNDPROC WndProc);
static	WNDPROC		SubGetProp	 (HWND hwnd, C_BCP pName);
static	BOOL		SubRemoveProp(HWND hwnd, C_BCP pName);

//==============================================================================================================//
//	メッセージマップテーブル初期化																				//
//																												//
//	引　数：	pMsgTbl	- メッセージマップテーブルのアドレス													//
//				pChain	- メッセージマップチェインポインタ群のアドレス											//
//																												//
//	戻り値：	なし																							//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	VO		CALLBACK	AjcMmpInitTblA	(PAJCMSGTBL pMsgTbl, PAJCMSGCHAINPTR pChain)
{
	SubMmpInitTbl(pMsgTbl, pChain, FALSE);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	VO		CALLBACK	AjcMmpInitTblW	(PAJCMSGTBL pMsgTbl, PAJCMSGCHAINPTR pChain)
{
	SubMmpInitTbl(pMsgTbl, pChain, TRUE);
}
//----- 共通サブ -----------------------------------------------------------------------------------------------//
static		VO					SubMmpInitTbl	(PAJCMSGTBL pMsgTbl, PAJCMSGCHAINPTR pChain, BOOL fUnicode)
{
	PAJCMSGTBL	*ppMsg = &pChain->pMsg;
	PAJCMSGTBL	*ppCmd = &pChain->pCmd;
	PAJCMSGTBL	*ppNtc = &pChain->pNtc;

	while (pMsgTbl->MsgType != AJCMSGTYPE_END) {
		switch (pMsgTbl->MsgType) {
			case AJCMSGTYPE_MSG:
				if		(pMsgTbl->msg == WM_COMMAND) pChain->pWmCmd = pMsgTbl;
				else if (pMsgTbl->msg == WM_NOTIFY ) pChain->pWmNtc = pMsgTbl;
				else {
					if (pMsgTbl->pRwm != NULL) {
						if (fUnicode) pMsgTbl->msg = RegisterWindowMessageW((WCP)pMsgTbl->pRwm);
						else		  pMsgTbl->msg = RegisterWindowMessageA((BCP)pMsgTbl->pRwm);
					}
					*ppMsg = pMsgTbl;
					 ppMsg = &pMsgTbl->pNxt;
				}
				break;

			case AJCMSGTYPE_CMD:
				*ppCmd = pMsgTbl;
				 ppCmd = &pMsgTbl->pNxt;
				break;

			case AJCMSGTYPE_NTC:
				*ppNtc = pMsgTbl;
				 ppNtc = &pMsgTbl->pNxt;
				break;
		}
		pMsgTbl++;
	}
}
//==============================================================================================================//
//	ウインドプロシージャ																						//
//																												//
//	引　数：	pChain	- メッセージマップチェインポインタ群のアドレス											//
//				hwnd	- ウインドハンドル																		//
//				msg 	- メッセージコード																		//
//				wParam	- パラメタ																				//
//				lParam	- パラメタ																				//
//				MyProc	- 自ウインドプロシージャ																//
//				pName	- プロシージャ名																		//
//																												//
//	戻り値：	メッセージハンドラの戻り値																		//
//==============================================================================================================//
AJCEXPORT	LRESULT	CALLBACK	AjcMmpWndMsgHandle(PAJCMSGCHAINPTR pChain, HWND hwnd, UI msg, WPARAM wParam, LPARAM lParam, WNDPROC MyProc, C_BCP pName)
{
	LRESULT		rc;
	WNDPROC		OldProc;	//	旧方式時のオリジナルウインドプロシージャ
	WNDPROC		OrgProc;	//	新方式時のオリジナルウインドプロシージャ

	//----- ● WM_COMMAND --------------------------------------------------------------------------------------//
	if		(msg == WM_COMMAND) {
		int			cmd = LOWORD(wParam);
		PAJCMSGTBL	pCmd;

		//	コマンド(LOWORD(wParam))検索
		for (pCmd = pChain->pCmd; pCmd != NULL && pCmd->cmd != cmd; pCmd = pCmd->pNxt);

		//	コマンド有ならば、当該コマンドアクション実行
		if (pCmd != NULL) {
			rc = pCmd->func(hwnd, msg, wParam, lParam);
		}
		//	WM_COMMAND有ならば、WM_COMMANDアクション実行
		else if (pChain->pWmCmd) {
			rc = pChain->pWmCmd->func(hwnd, msg, wParam, lParam);
		}
		//	その他・・
		else {
			//	サブクラス化による、元プロシージャなし？
			if ((OrgProc = SubGetProp(hwnd, pName)) == NULL) {
				//	デフォルトウインドプロシージャ実行
				if ((OldProc = (WNDPROC)GetPropA(hwnd, AJCMMP_DEFWNDPROC_PROP)) && OldProc != MyProc)
					rc = AjcCallWindowProc(OldProc, hwnd, msg, wParam, lParam);
				else
					rc = AjcDefWindowProc ( 		hwnd, msg, wParam, lParam);
			}
			//	サブクラス化による、元プロシージャあり？
			else {
				//	元プロシージャ実行
				rc = AjcCallWindowProc(OrgProc, hwnd, msg, wParam, lParam);
			}
		}
	}
	//----- ● WM_NOTIFY ---------------------------------------------------------------------------------------//
	else if (msg == WM_NOTIFY ) {
		HWND		hw = (HWND)wParam;
		LPNMHDR		pH = (LPNMHDR)lParam;
		int			cmd = (int)(IsWindow(hw) ? MAjcGetWindowLong(hw, GWL_ID) : pH->idFrom);
		PAJCMSGTBL	pNtc;

		//	通知コード検索
		for (pNtc = pChain->pNtc; pNtc != NULL && pNtc->cmd != cmd; pNtc = pNtc->pNxt);

		//	通知コード有ならば、当該通知アクション実行
		if (pNtc != NULL) {
			rc = pNtc->func(hwnd, msg, wParam, lParam);
		}
		//	WM_NOTIFY有ならば、WM_NOTIFYアクション実行
		else if (pChain->pWmNtc) {
			rc = pChain->pWmNtc->func(hwnd, msg, wParam, lParam);
		}
		//	その他・・
		else {
			//	サブクラス化による、元プロシージャなし？
			if ((OrgProc = SubGetProp(hwnd, pName)) == NULL) {
				//	デフォルトウインドプロシージャ実行
				if ((OldProc = (WNDPROC)GetPropA(hwnd, AJCMMP_DEFWNDPROC_PROP)) && OldProc != MyProc)
					rc = AjcCallWindowProc(OldProc, hwnd, msg, wParam, lParam);
				else
					rc = AjcDefWindowProc ( 		hwnd, msg, wParam, lParam);
			}
			//	サブクラス化による、元プロシージャあり？
			else {
				//	元プロシージャ実行
				rc = AjcCallWindowProc(OrgProc, hwnd, msg, wParam, lParam);
			}
		}
	}
	//----- ● その他のメッセージ ------------------------------------------------------------------------------//
	else {
		PAJCMSGTBL	pMsg;

		//	メッセージ検索
		for (pMsg = pChain->pMsg; pMsg != NULL && pMsg->msg != msg; pMsg = pMsg->pNxt);

		//	メッセージ有ならば、当該メッセージアクション実行
		if (pMsg != NULL) {
			rc = pMsg->func(hwnd, msg, wParam, lParam);
		}
		//	メッセージ無し・・・
		else {
			//	サブクラス化による、元プロシージャなし？
			if ((OrgProc = SubGetProp(hwnd, pName)) == NULL) {
				//	デフォルトウインドプロシージャ実行
				if ((OldProc = (WNDPROC)GetPropA(hwnd, AJCMMP_DEFWNDPROC_PROP)) && OldProc != MyProc)
					rc = AjcCallWindowProc(OldProc, hwnd, msg, wParam, lParam);
				else
					rc = AjcDefWindowProc ( 		hwnd, msg, wParam, lParam);
			}
			//	サブクラス化による、元プロシージャあり？
			else {
				//	元プロシージャ実行
				rc = AjcCallWindowProc(OrgProc, hwnd, msg, wParam, lParam);
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	ダイアログプロシージャ																						//
//																												//
//	引　数：	pChain	- メッセージマップチェインポインタ群のアドレス											//
//				hwnd	- ウインドハンドル																		//
//				msg 	- メッセージコード																		//
//				wParam	- パラメタ																				//
//				lParam	- パラメタ																				//
//																												//
//	戻り値：	メッセージハンドラの戻り値（無い場合はFALSE)													//
//==============================================================================================================//
AJCEXPORT	LRESULT	CALLBACK	AjcMmpDlgMsgHandle(PAJCMSGCHAINPTR pChain, HWND hDlg, UI msg, WPARAM wParam, LPARAM lParam)
{
	LRESULT	rc = FALSE;

	//----- ● WM_COMMAND --------------------------------------------------------------------------------------//
	if		(msg == WM_COMMAND) {
		int			cmd = LOWORD(wParam);
		PAJCMSGTBL	pCmd;

		//	コマンド(LOWORD(wParam))検索
		for (pCmd = pChain->pCmd; pCmd != NULL && pCmd->cmd != cmd; pCmd = pCmd->pNxt);

		//	コマンド有ならば、当該コマンドアクション実行
		if (pCmd != NULL) {
			rc = pCmd->func(hDlg, msg, wParam, lParam);
		}
		//	WM_COMMAND有ならば、WM_COMMANDアクション実行
		else if (pChain->pWmCmd) {
			rc = pChain->pWmCmd->func(hDlg, msg, wParam, lParam);
		}
	}
	//----- ● WM_NOTIFY ---------------------------------------------------------------------------------------//
	else if (msg == WM_NOTIFY ) {
		int			cmd;
		PAJCMSGTBL	pNtc;
		LPNMHDR		p = (LPNMHDR)lParam;

		//	子ウインドからの通知ならば、子ウインドのＩＤ設定
		if (IsWindow((HWND)p->idFrom) && (MAjcGetWindowLong((HWND)p->idFrom, GWL_STYLE) & WS_CHILD)) {
			cmd = (int)MAjcGetWindowLong((HWND)wParam, GWL_ID);
		}
		//	その他の場合、コントロールの識別子設定
		else {
			cmd = (int)p->idFrom;
		}

		//	識別子検索
		for (pNtc = pChain->pNtc; pNtc != NULL && pNtc->cmd != cmd; pNtc = pNtc->pNxt);

		//	識別子ありならば、当該アクション実行
		if (pNtc != NULL) {
			rc = pNtc->func(hDlg, msg, wParam, lParam);
		}
		//	WM_NOTIFYありならば、WM_NOTIFYアクション実行
		else if (pChain->pWmNtc) {
			rc = pChain->pWmNtc->func(hDlg, msg, wParam, lParam);
		}
	}
	//----- ● その他のメッセージ ------------------------------------------------------------------------------//
	else {
		PAJCMSGTBL	pMsg;

		//	メッセージ検索
		for (pMsg = pChain->pMsg; pMsg != NULL && pMsg->msg != msg; pMsg = pMsg->pNxt);

		//	メッセージ有ならば、当該メッセージアクション実行
		if (pMsg != NULL) {
			rc = pMsg->func(hDlg, msg, wParam, lParam);
		}
	}
	return rc;
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	サブクラス化に関するファンクション																			//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
#define	SBC_XQUE	L"AJCSBC_CALL_STACK"
typedef struct {
	C_BCP		pName;		//	プロシージャの名前
	WNDPROC		wpNew;		//	サブクラス化した新ウインドプロシージャ
	WNDPROC		wpOld;		//	元のウインドプロシージャ
} SBCNODE, *PSBCNODE;
typedef const SBCNODE *PCSBCNODE;
//==============================================================================================================//
//	ウインドプロシージャのサブクラス化（新方式）																//
//																												//
//	引　数：	hwnd	- ウインドハンドル																		//
//				pName	- プロシージャ名																		//
//				NewProc - 新ウインドプロシージャ																//
//																												//
//	戻り値：	≠ NULL - オリジナルウインドプロシージャのアドレス												//
//				＝ NULL - 失敗																					//
//==============================================================================================================//
AJCEXPORT	WNDPROC	CALLBACK AjcMmpSetSubclass	  (HWND hwnd, C_BCP pName, WNDPROC NewProc)
{
	WNDPROC		rc	  = NULL;
	HAJCXQUE	hXQue = NULL;
	SBCNODE		node  = {0};
	PSBCNODE	pNode = NULL;

	if (IsWindow(hwnd) && pName != NULL && *pName != 0) {
		//	プロシージャスタック用双方向キュー生成
		if ((hXQue = (HAJCXQUE)GetPropW(hwnd, SBC_XQUE)) == NULL) {
			if ((hXQue = AjcXQueCreate(0, NULL)) != NULL) {
				SetProp(hwnd, SBC_XQUE, (HANDLE)hXQue);
			}
		}
		if (hXQue != NULL) {
			//	自プロシージャエントリ検索
			if ((pNode = (PSBCNODE)AjcXQueTopNode(hXQue, NULL)) && strcmp(pNode->pName, pName) != 0) {
				while ((pNode = (PSBCNODE)AjcXQueNextNode(hXQue, pNode, NULL)) && strcmp(pNode->pName, pName) != 0);
			}
			//	同一名称無し？
			if (pNode == NULL) {
				//	新ノード追加
				if (pNode = (PSBCNODE)AjcXQueEnque(hXQue, &node, sizeof node)) {
					//	新ウインドプロシージャを設定
					if (rc = (WNDPROC)AjcSetWindowLongPtr(hwnd, GWLP_WNDPROC, (UX)NewProc)) {
						//	デフォルト・ウインドプロシージャをウインドに関連付ける
						SubSetProp(hwnd, pName, rc);
						//	プロシージャスタックへウインドプロシージャ設定
						pNode->pName = pName;
						pNode->wpNew = NewProc;
						pNode->wpOld = rc;
					}
					//	エラーならばノード破棄
					else {
						AjcXQueRemove(hXQue, (C_VOP)pNode);
					}
				}
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	ウインドプロシージャのサブクラス化解除（新方式）															//
//																												//
//	引　数：	hwnd	- ウインドハンドル																		//
//				pName	- プロシージャ名																		//
//																												//
//	戻り値：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//==============================================================================================================//
AJCEXPORT	BOOL CALLBACK AjcMmpClrSubclass    (HWND hwnd, C_BCP pName)
{
	BOOL		rc		= FALSE;
	HAJCXQUE	hXQue	= NULL;
	PSBCNODE	pNode	= NULL;
	PSBCNODE	pNext	= NULL;
	PSBCNODE	pPrev	= NULL;

	if (IsWindow(hwnd) && pName != NULL && *pName != 0) {
		//	プロシージャスタック・キューインスタンス有り？
		if (hXQue = (HAJCXQUE)GetPropW(hwnd, SBC_XQUE)) {
			//	自プロシージャエントリ検索
			if ((pNode = (PSBCNODE)AjcXQueTopNode(hXQue, NULL)) && strcmp(pNode->pName, pName) != 0) {
				do {
					pPrev = pNode;
				} while ((pNode = (PSBCNODE)AjcXQueNextNode(hXQue, pNode, NULL)) && strcmp(pNode->pName, pName) != 0);
			}
			//	自プロシージャエントリあり？
			if (pNode != NULL) {
				//	次エントリあり？
				if (pNext = (PSBCNODE)AjcXQueNextNode(hXQue, pNode, NULL)) {
					//	次ノードのデフォルト・プロシージャ関連付け変更
					if (pNext->wpOld == pNode->wpNew) {
						SubSetProp(hwnd, pNext->pName, pNode->wpOld);
					}
					//	次ノードのデフォルト・プロシージャ変更
					pNext->wpOld = pNode->wpOld;
					//	自ノードのデフォルトプロシージャ関連付け解除
					SubRemoveProp(hwnd, pNode->pName);
					//	自ノード削除
					AjcXQueRemove(hXQue, (C_VOP)pNode);
				}
				//	次エントリ無し（自身が最終エントリ）？
				else {
					//	１つ前のノード有り？
					if (pPrev != NULL) {
						//	1つ前のノードのプロシージャを有効化
						AjcSetWindowLongPtr(hwnd, GWLP_WNDPROC, (UX)pPrev->wpNew);
						//	自ノードのデフォルトプロシージャ関連付け解除
						SubRemoveProp(hwnd, pNode->pName);
						//	自ノード削除
						AjcXQueRemove(hXQue, (C_VOP)pNode);
					}
					//	１つ前のノード無し？（自身の１エントリのみ）
					else {
						//	デフォルトプロシージャ設定（元祖プロシージャ設定）
						AjcSetWindowLongPtr(hwnd, GWLP_WNDPROC, (UX)pNode->wpOld);
						//	自ノードのデフォルトプロシージャ関連付け解除
						SubRemoveProp(hwnd, pNode->pName);
						//	インスタンス消去
						AjcXQueDelete(hXQue);
						//	インスタンス関連付け解除
						RemoveProp(hwnd, SBC_XQUE);
					}
				}
				rc = TRUE;
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	サブクラス情報削除（新方式）																				//
//																												//
//	引　数：	hwnd	- ウインドハンドル																		//
//				pName	- プロシージャ名																		//
//																												//
//	戻り値：	TRUE  - 成功																					//
//				FALSE - 失敗（サブクラス情報エントリ無し）														//
//==============================================================================================================//
AJCEXPORT	BOOL CALLBACK AjcMmpDelSubclass    (HWND hwnd, C_BCP pName)
{
	BOOL		rc		= FALSE;
	HAJCXQUE	hXQue	= NULL;
	PSBCNODE	pNode	= NULL;

	if (hXQue = (HAJCXQUE)GetPropW(hwnd, SBC_XQUE)) {
		RemoveProp(hwnd, SBC_XQUE);
		rc = AjcXQueDelete(hXQue);
	}
	return rc;
}
//==============================================================================================================//
//	サブクラス化情報の取得（新方式）																			//
//																												//
//	引　数：	hwnd	- ウインドハンドル																		//
//				pBuf	- サブクラス化情報を格納するバッファのアドレス	（不要時はNULL）						//
//				nBuf	- サブクラス化情報を格納するバッファのエントリ数										//
//																												//
//	戻り値：	サブクラス化の個数																				//
//==============================================================================================================//
AJCEXPORT	UI	CALLBACK AjcMmpGetSubclassInfo (HWND hwnd, AJCSBCINFO buf[], UI nBuf)
{
	UI			rc	  = 0;
	HAJCXQUE	hXQue;
	PSBCNODE	pNode = NULL;

	if (IsWindow(hwnd)) {
		if (hXQue = (HAJCXQUE)GetPropW(hwnd, SBC_XQUE)) {
			//	プロシージャエントリ数ループ
			if (pNode = (PSBCNODE)AjcXQueTopNode(hXQue, NULL)) {
				do {
					rc++;
					if (buf != NULL && nBuf >= rc) {
						buf->pName = pNode->pName;
						buf->wpNew = pNode->wpNew;
						buf->wpOld = pNode->wpOld;
						buf->wpRet = SubGetProp(hwnd, pNode->pName);
						buf++;
					}
				} while (pNode = (PSBCNODE)AjcXQueNextNode(hXQue, pNode, NULL));
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	デフォルトウインドプロシージャの設定（新方式）																//
//																												//
//	引　数：	hwnd	- ウインドハンドル																		//
//				pName	- プロシージャ名																		//
//				WndProc - デフォルトウインドプロシージャ														//
//																												//
//	戻り値：	TRUE  - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT	BOOL	CALLBACK AjcMmpSetDefWndProcEx(HWND hwnd, C_BCP pName, WNDPROC DefWndProc)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		rc = SubSetProp(hwnd, pName, (HANDLE)DefWndProc);
	}
	return rc;
}
//==============================================================================================================//
//	デフォルトウインドプロシージャ取得（新方式）																//
//																												//
//	引　数：	hwnd	- ウインドハンドル																		//
//				pName	- プロシージャ名																		//
//																												//
//	戻り値：	≠ NULL - デフォルトウインドプロシージャのアドレス												//
//				＝ NULL - 失敗																					//
//==============================================================================================================//
AJCEXPORT	WNDPROC	CALLBACK AjcMmpGetDefWndProcEx (HWND hwnd, C_BCP pName)
{
	WNDPROC		rc = NULL;

	if (IsWindow(hwnd)) {
		rc = SubGetProp(hwnd, pName);
	}
	return rc;
}
//==============================================================================================================//
//	デフォルトウインドプロシージャの呼び出し（新方式）															//
//																												//
//	引　数：	hwnd	- ウインドハンドル																		//
//				pName	- プロシージャ名																		//
//				msg		- デフォルトウインドプロシージャへのパラメタ											//
//				wParam	-	〃																					//
//				lParam	-	〃																					//
//																												//
//	戻り値：	メッセージ処理の結果																			//
//==============================================================================================================//
AJCEXPORT	LRESULT	CALLBACK AjcMmpCallOrgWndProc(HWND hwnd, C_BCP pName, UI msg, WPARAM wParam, LPARAM lParam)
{
	LRESULT		rc = 0;
	WNDPROC		OrgWp;

	if (IsWindow(hwnd)) {
		if (OrgWp = SubGetProp(hwnd, pName)) rc = AjcCallWindowProc(OrgWp, hwnd, msg, wParam, lParam);
		else								 rc = AjcDefWindowProc (	   hwnd, msg, wParam, lParam);
	}
	return rc;
}
//==============================================================================================================//
//	デフォルトウインドプロシージャの設定（旧方式）																//
//																												//
//	引　数：	hwnd	- ウインドハンドル																		//
//				WndProc - デフォルトウインドプロシージャ														//
//																												//
//	戻り値：	TRUE  - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT	BOOL	CALLBACK AjcMmpSetDefWndProc(HWND hwnd, WNDPROC DefWndProc)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		rc = SetPropA(hwnd, AJCMMP_DEFWNDPROC_PROP, (HANDLE)DefWndProc);
	}
	return rc;
}
//==============================================================================================================//
//	デフォルトウインドプロシージャ取得（旧方式）																//
//																												//
//	引　数：	hwnd	- ウインドハンドル																		//
//																												//
//	戻り値：	≠ NULL - デフォルトウインドプロシージャのアドレス												//
//				＝ NULL - 失敗																					//
//==============================================================================================================//
AJCEXPORT	WNDPROC	CALLBACK AjcMmpGetDefWndProc (HWND hwnd)
{
	WNDPROC		rc = NULL;

	if (IsWindow(hwnd)) {
		rc = GetPropA(hwnd, AJCMMP_DEFWNDPROC_PROP);
	}
	return rc;
}
//==============================================================================================================//
//	デフォルトウインドプロシージャの呼び出し（旧方式）															//
//																												//
//	引　数：	hwnd	- ウインドハンドル																		//
//				msg		- デフォルトウインドプロシージャへのパラメタ											//
//				wParam	-	〃																					//
//				lParam	-	〃																					//
//																												//
//	戻り値：	メッセージ処理の結果																			//
//==============================================================================================================//
AJCEXPORT	LRESULT	CALLBACK AjcMmpCallDefWndProc(HWND hwnd, UI msg, WPARAM wParam, LPARAM lParam)
{
	LRESULT		rc = 0;
	WNDPROC		DefWp;

	if (IsWindow(hwnd)) {
		if (DefWp = GetPropA(hwnd, AJCMMP_DEFWNDPROC_PROP)) rc = AjcCallWindowProc(DefWp, hwnd, msg, wParam, lParam);
		else												rc = AjcDefWindowProc (		  hwnd, msg, wParam, lParam);
	}
	return rc;
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	内部サブ関数																								//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//--------------------------------------------------------------------------------------------------------------//
//	ウインドプロパティにプロシージャ登録																		//
//																												//
//	引　数：	hwnd	- ウインドハンドル																		//
//				pName	- プロシージャの名称																	//
//				WndProc	- プロシージャのアドレス																//
//																												//
//	戻り値：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	SubSetProp(HWND hwnd, C_BCP pName, WNDPROC WndProc)
{
	BOOL	rc = FALSE;
	BC		name[256];

	if (IsWindow(hwnd) && pName != NULL && *pName != 0) {
		AjcSnPrintFA(name, AJCTSIZE(name), "AjcMmpOrgProc_%s", pName);
		rc = SetPropA(hwnd, name, (HANDLE)WndProc);
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	ウインドプロパティからプロシージャ取得																		//
//																												//
//	引　数：	hwnd	- ウインドハンドル																		//
//				pName	- プロシージャの名称																	//
//																												//
//	戻り値：	≠ NULL - 取得したプロシージャのアドレス														//
//				＝ NULL - 失敗																					//
//--------------------------------------------------------------------------------------------------------------//
static	WNDPROC	SubGetProp(HWND hwnd, C_BCP pName)
{
	WNDPROC	rc = NULL;
	BC		name[256];

	if (IsWindow(hwnd) && pName != NULL && *pName != 0) {
		AjcSnPrintFA(name, AJCTSIZE(name), "AjcMmpOrgProc_%s", pName);
		rc = (WNDPROC)GetPropA(hwnd, name);
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	ウインドプロパティ消去																						//
//																												//
//	引　数：	hwnd	- ウインドハンドル																		//
//				pName	- プロシージャの名称																	//
//																												//
//	戻り値：	≠ NULL - 取得したプロシージャのsドレス															//
//				＝ NULL - 失敗																					//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	SubRemoveProp(HWND hwnd, C_BCP pName)
{
	BOOL	rc = FALSE;
	BC		name[256];

	if (IsWindow(hwnd) && pName != NULL && *pName != 0) {
		AjcSnPrintFA(name, AJCTSIZE(name), "AjcMmpOrgProc_%s", pName);
		rc = (RemovePropA(hwnd, name) != NULL);
	}
	return rc;
}
