﻿#include	"AjcInternal.h"
//**************************************************************************************************************//
//																												//
//	ポップアップメニュー表示ウインド																			//
//																												//
//**************************************************************************************************************//

#define		MY_CLASS		L"AjcMenu"

#define		MRG_W			30
#define		MRG_H			8

//--------------------------------------------------------------------------------------------------------------//
//	作業領域																									//
//--------------------------------------------------------------------------------------------------------------//
static	ATOM	ClassMenu	 = 0;
static	HFONT	hDefFont	 = NULL;
static	HWND	hWndMenu	 = NULL;
static	HBRUSH	hBruBtnFace	 = NULL;
static	HBRUSH	hBruSelect	 = NULL;
static	HPEN	hPenSeparate = NULL;
static	HPEN	hPenOutLine  = NULL;
static	HPEN	hPenShadow1  = NULL;
static	HPEN	hPenShadow2  = NULL;
static	HPEN	hPenShadow3  = NULL;

//--------------------------------------------------------------------------------------------------------------//
//	インスタンスワーク																							//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	HWND		hOwner;					//	オーナーウインドハンドル
	UI			msg;					//	項目選択通知メッセージコード
	LPARAM		lParam;					//	メッセージ通知時のlParam
	int			yTop;					//	描画開始Y位置
	RECT		rcWnd;					//	メニューウインドの矩形情報
	RECT		rcCli;					//	クライアント領域のスクリーン座標
	SIZE		szBox;					//	表示項目の幅，長さ
	int			ixTop;					//	表示先頭項目インデクス
	int			nShow;					//	表示可能項目数
	int			ixCur;					//	現在の項目インデクス
	int			nItems;					//	メニュー項目数
	AJCPPMTBLW	Tbl[1];					//	メニュー項目テキストへのポインタ配列
} MY_WORK, *PMY_WORK;
//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC_DEF(Menu);

static	HWND	SubPopupMenu(HWND hWndOwner, UI msg, int x, int y, PAJCPPMTBLW pTbl, LPARAM lParam, int nItems);


//==============================================================================================================//
//	起動時初期設定																								//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	AjcPopupMenuInit(VO)
{
	BOOL		rc = FALSE;
	WNDCLASS	wndclass;
	LOGFONT		lf;

	do {
		//----- ブラシ，ペン生成 ------------------------------//
		hBruBtnFace  = CreateSolidBrush(GetSysColor(COLOR_BTNFACE));
		hBruSelect	 = CreateSolidBrush(RGB(145, 201, 247));
		hPenSeparate = CreatePen(PS_SOLID, 1, RGB(192, 192, 192));
		hPenOutLine  = CreatePen(PS_SOLID, 1, RGB(215, 215, 215));
		hPenShadow1  = CreatePen(PS_SOLID, 1, RGB(142, 142, 142));
		hPenShadow2  = CreatePen(PS_SOLID, 1, RGB(171, 171, 171));
		hPenShadow3  = CreatePen(PS_SOLID, 1, RGB(212, 212, 212));

		//----- ウインドクラス --------------------------------//
		wndclass.style			= CS_GLOBALCLASS;
		wndclass.lpfnWndProc	= AJC_WNDPROC_NAME(Menu);
		wndclass.cbClsExtra		= 0;
		wndclass.cbWndExtra		= sizeof(UX);
		wndclass.hInstance		= hDllInst;
		wndclass.hIcon			= NULL;
		wndclass.hCursor		= LoadCursor(NULL, IDC_ARROW);
		wndclass.hbrBackground	= (HBRUSH)GetStockObject(WHITE_BRUSH);
		wndclass.lpszMenuName	= NULL;
		wndclass.lpszClassName	= MY_CLASS;
		if ((ClassMenu = RegisterClass(&wndclass)) == 0) break;

		//----- デフォルトフォント生成 ------------------------//
		lf.lfHeight		 = 16;			lf.lfStrikeOut		= 0;
		lf.lfWidth		 = 0;			lf.lfCharSet		= DEFAULT_CHARSET;
		lf.lfEscapement	 = 0;			lf.lfOutPrecision	= OUT_STROKE_PRECIS;
		lf.lfOrientation = 0;			lf.lfClipPrecision	= CLIP_STROKE_PRECIS;
		lf.lfWeight		 = FW_NORMAL;	lf.lfQuality		= DRAFT_QUALITY;
		lf.lfItalic		 = 0;			lf.lfPitchAndFamily	= FF_MODERN | VARIABLE_PITCH;
		lf.lfUnderline	 = 0;			wcscpy(lf.lfFaceName, L"Arial Unicode MS");
		hDefFont = CreateFontIndirect(&lf);

		rc = TRUE;
	} while(0);

	if (rc == FALSE) {
		AjcPopupMenuEnd();
	}

	return rc;
}
//==============================================================================================================//
//	終了時後処理																								//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - エラー																					//
//==============================================================================================================//
VO		AjcPopupMenuEnd (VO)
{
	if (hWndMenu 	 != NULL) {DestroyWindow(hWndMenu);						hWndMenu		= NULL;}
	if (hDefFont	 != NULL) {DeleteObject(hDefFont);						hDefFont		= NULL;}
	if (ClassMenu	 != 0	) {UnregisterClass((WCP)ClassMenu, hDllInst);	ClassMenu		= 0;   }
	if (hBruBtnFace	 != NULL) {DeleteObject(hBruBtnFace); 					hBruBtnFace		= NULL;}
	if (hBruSelect	 != NULL) {DeleteObject(hBruSelect); 					hBruSelect		= NULL;}
	if (hPenSeparate != NULL) {DeleteObject(hPenSeparate); 					hPenSeparate	= NULL;}
	if (hPenOutLine  != NULL) {DeleteObject(hPenOutLine); 					hPenOutLine		= NULL;}
	if (hPenShadow1  != NULL) {DeleteObject(hPenShadow1); 					hPenShadow1		= NULL;}
	if (hPenShadow2  != NULL) {DeleteObject(hPenShadow2); 					hPenShadow2		= NULL;}
	if (hPenShadow3  != NULL) {DeleteObject(hPenShadow3); 					hPenShadow3		= NULL;}
}
//==============================================================================================================//
//	ポップアップメニュー																						//
//																												//
//	引　数：	hWndOwner	- オーナーウインドハンドル															//
//				x, y 		- 表示位置（スクリーン座標）														//
//				pItems		- メニュー項目（文字列へのポインタの配列）											//
//				nItems		- メニュー項目数																	//
//																												//
//	戻り値：	≠NULL	- 成功（ウインドハンドル）																//
//				＝NULL	- 失敗																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT HWND	 WINAPI AjcPopupMenuA(HWND hWndOwner, UI msg, int x, int y, PAJCPPMTBLA pTbl, LPARAM lParam)
{
	HWND		rc		= NULL;
	int			i, len, nItems;
	PAJCPPMTBLW	pT		= NULL;

	do {
		//	引数チェック
		if (pTbl == NULL || (pTbl[0].flag & AJCPPMF_EOT)) break;
		//	テーブルエントリ数算出
		nItems = 0;
		for (i = 0; !(pTbl[i].flag & AJCPPMF_EOT); i++) {
			nItems++;
		}
		//	ワーク領域確保
		if ((pT = (PAJCPPMTBLW)AJCMEM(sizeof(AJCPPMTBLW) * nItems)) == NULL) break;
		memset(pT, 0, sizeof(AJCPPMTBLW) * nItems);
		//	ワード文字→バイト文字変換
		for (i = 0; i < nItems; i++) {
			WCP		p;
			if (pTbl[i].pText == NULL) break;
			len = MultiByteToWideChar(CP_ACP, 0, pTbl[i].pText, -1, NULL, 0);
			if (len != 0 && (p = AjcTAlloc(len))) {
				pT[i].flag = pTbl[i].flag;
				pT[i].id   = pTbl[i].id;
				pT[i].key  = pTbl[i].key;
				MultiByteToWideChar(CP_ACP, 0, pTbl[i].pText, -1, p, len);
				pT[i].pText = p;
			}
			else break;
		}
		if (i < nItems) break;
		//	ポップアップメニュー処理
		rc = SubPopupMenu(hWndOwner, msg, x, y, pT, lParam, nItems);
		//	リソース解放
		if (pT != NULL) {
			for (i = 0; i < nItems; i++) {
				if (pT[i].pText != NULL) {
					free((VOP)pT[i].pText);
				}
			}
			free(pT);
		}
	} while(0);

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT HWND	 WINAPI AjcPopupMenuW(HWND hWndOwner, UI msg, int x, int y, PAJCPPMTBLW pTbl, LPARAM lParam)
{
	HWND		rc = NULL;
	int			i, nItems;

	do {
		//	引数チェック
		if (pTbl == NULL || (pTbl[0].flag & AJCPPMF_EOT)) break;
		//	テーブルエントリ数算出
		nItems = 0;
		for (i = 0; !(pTbl[i].flag & AJCPPMF_EOT); i++) {
			nItems++;
		}
		//	ポップアップメニュー処理
		rc = SubPopupMenu(hWndOwner, msg, x, y, pTbl, lParam, nItems);
	} while(0);

	return rc;
}
//----- 共通処理 -----------------------------------------------------------------------------------------------//
static	HWND	SubPopupMenu(HWND hWndOwner, UI msg, int x, int y, PAJCPPMTBLW pTbl, LPARAM lParam, int nItems)
{
	PMY_WORK	pW	= NULL;
	int			i, stl, rem;
	HDC			hdc = NULL;
	HFONT		hF	= NULL;
	RECT		rcScr, rcWnd;
	SIZE		szScr, szWnd, szCli, szBox, sz;
	int			sty = WS_POPUP;
	int			exs = WS_EX_TOPMOST | WS_EX_TOOLWINDOW | WS_EX_STATICEDGE | WS_EX_LAYERED;

	do {
		//	オーナーウインドハンドルチェック
		if (!IsWindow(hWndOwner)) break;
		//	メニュー項目ポインタチェック
		if (pTbl == NULL) break;
		//	メニュー項目数チェック
		if (nItems <= 0) break;
		//	インスタンスワーク生成
		if ((pW = (PMY_WORK)AJCMEM(sizeof(MY_WORK) + sizeof(AJCPPMTBLA) * nItems)) == NULL) break;
		memset(pW, 0,			   sizeof(MY_WORK) + sizeof(AJCPPMTBLA) * nItems);
		//	既にウインドがあればクローズ
		if (hWndMenu != NULL) {
			DestroyWindow(hWndMenu);
			hWndMenu = NULL;
		}
		//	テーブルコピー，項目表示域のピクセル数設定
		szBox.cx = szBox.cy = 0;
		hdc = GetDC(hWndMenu);
		hF = (HFONT)SelectObject(hdc, hDefFont);
		for (i = 0; i < nItems; i++) {
			WCP		p;
			if (pTbl[i].pText == NULL) break;
			stl = (int)wcslen(pTbl[i].pText);
			if ((p = AjcTAlloc(stl + 1)) == NULL) break;
			pW->Tbl[i].flag	= pTbl[i].flag;
			pW->Tbl[i].id	= pTbl[i].id;
			wcscpy(p, pTbl[i].pText);
			pW->Tbl[i].pText = p;
			//	ショートカットキー(&?)設定
			pW->Tbl[i].key = -1;
			if (p = wcsstr(pW->Tbl[i].pText, L"&")) {
				pW->Tbl[i].key = towlower((*(p + 1)));
				stl = (int)wcslen(p);
				memmove(p, p + 1, stl * 2);
			}
			//	ボックスサイズ更新
			GetTextExtentPoint32W(hdc, pW->Tbl[i].pText, stl, &sz);
			szBox.cx = __max(szBox.cx, sz.cx + MRG_W);
			szBox.cy = __max(szBox.cy, sz.cy + MRG_H);
		}
		SelectObject(hdc, hF);
		ReleaseDC(hWndMenu, hdc);
		if (i < nItems) break;
		//	メニュー全体を表示するのに必要なクライアントサイズを設定
		szCli.cx = szBox.cx;
		szCli.cy = szBox.cy * nItems;
		//	メニューウインド矩形情報，サイズ設定
		rcWnd.left	 = x;
		rcWnd.right  = x + szCli.cx + 5;
		rcWnd.top	 = y;
		rcWnd.bottom = y + szCli.cy + 5;
		AdjustWindowRectEx(&rcWnd, sty, FALSE, exs);
		szWnd.cx	 = rcWnd.right - rcWnd.left;
		szWnd.cy	 = rcWnd.bottom - rcWnd.top;
		//	スクりーンサイズ取得
		if (AjcGetMonitorInfoOfPoint(x, y, NULL, &rcScr)) {
			szScr.cx = rcScr.right - rcScr.left;
			szScr.cy = rcScr.bottom - rcScr.top;
		}
		else {
			AjcGetPrimaryMonitorInfo(NULL, &rcScr);
			szScr.cx = rcScr.right - rcScr.left;
			szScr.cy = rcScr.bottom - rcScr.top;
			rcWnd.left = rcScr.left + (szScr.cx - szBox.cx) / 2;
		}
		//	メニューウインドサイズ(高さ)がスクリーンサイズを超える場合、サイズを縮小
		if (szWnd.cy > szScr.cy) {
			int		ovr;
			//	サイズ縮小（スクリーンに合わせたサイズ）
			ovr = (szWnd.cy - szScr.cy);
			szWnd.cy -= ovr;
			szCli.cy -= ovr;
			//	項目の高さの倍数にする
			rem = szCli.cy % szBox.cy;
			szWnd.cy -= rem;
			szCli.cy -= rem;
			//	クライアント領域を上下の余白分縮小
			szCli.cy -= (szBox.cy * 2);
			//	表示Ｙ位置設定
			rcWnd.top = 0;
			//	描画開始Ｙ位置設定
			pW->yTop = szBox.cy;
		}
		//	メニューウインドサイズ(高さ)がスクリーンサイズを超えない場合、Ｙ位置を調整
		else {
			//	ウインドが下端を出る場合、Ｙを上に移動
			if (rcWnd.top + szWnd.cy > rcScr.bottom) {
				rcWnd.top -= (rcWnd.top + szWnd.cy - rcScr.bottom);
			}
			//	ウインドが上端を出る場合、Ｙを下に移動
			if (rcWnd.top < rcScr.top) {
				rcWnd.top += (rcScr.top - rcWnd.top);
			}
			//	描画開始Ｙ位置設定
			pW->yTop = 0;
		}
		//	ウインドが右端を出る場合、Ｘを左に移動
		if (rcWnd.left + szWnd.cx > rcScr.right) {
			rcWnd.left -= (rcWnd.left + szWnd.cx - rcScr.right);
		}
		//	ウインドが左端を出る場合、Ｘを右に移動
		if (rcWnd.left < rcScr.left) {
			rcWnd.left += (rcScr.left - rcWnd.left);
		}
		//	ウインドサイズ再設定
		rcWnd.right  = rcWnd.left + szWnd.cx;
		rcWnd.bottom = rcWnd.top  + szWnd.cy;
		//	インスタンスワーク設定
		pW->hOwner	= hWndOwner;						//	オーナーウインドハンドル
		pW->msg		= msg;								//	通知メッセージコード
		pW->lParam	= lParam;							//	LPARAM
		memcpy(&pW->rcWnd, &rcWnd, sizeof pW->rcWnd);	//	メニューウインドの矩形情報
		pW->rcCli.left = 0;								//	描画領域の矩形情報
		pW->rcCli.top  = pW->yTop;
		pW->rcCli.right  = pW->rcCli.left + szCli.cx;
		pW->rcCli.bottom = pW->rcCli.top  + szCli.cy;
		memcpy(&pW->szBox, &szBox, sizeof pW->szBox);	//	表示項目の幅，長さ
		pW->ixTop  = 0;									//	表示先頭項目インデクス
		pW->nShow  = szCli.cy / szBox.cy;				//	表示可能項目数
		pW->ixCur  = 0;									//	現在の表示項目
		pW->nItems = nItems;							//	メニュー項目数
		//	ウインド生成
		hWndMenu = CreateWindowEx(exs,									// extended style
								  MY_CLASS,								// window class name
								  L"",									// window caption
								  sty,									// window style
								  rcWnd.left,							// initial x position
								  rcWnd.top,							// initial y position
								  szWnd.cx,								// initial x size
								  szWnd.cy,								// initial y size
								  hWndOwner,							// parent window handle
								  NULL,									// window menu handle
								  hDllInst,								// program instance handle
								  pW);									// creation parameters

		//	ウインド生成失敗ならば終了
		if (hWndMenu == NULL) break;
		//	メニューウインド表示
		ShowWindow(hWndMenu, SW_SHOW);
	} while(0);

	//	メニューウインド作成失敗ならば、リソース解放
	if (hWndMenu == NULL) {
		//	メニューテキスト解放
		for (i = 0; i < nItems; i++) {
			if (pW->Tbl[i].pText != NULL) {
				free((VOP)pW->Tbl[i].pText);
			}
		}
		//	インスタンスワーク解放
		free(pW);
	}

	return hWndMenu;
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	メニュー表示ウインドプロシージャ																			//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//----- ウインド生成 -------------------------------------------------------------------------------------------//
AJC_WNDPROC(Menu, WM_CREATE	)
{
	LPCREATESTRUCT	p = (LPCREATESTRUCT)lParam;
	PMY_WORK	pW = (PMY_WORK)p->lpCreateParams;
	int			w, h;

	hWndMenu = hwnd;

	//	黒部分を完全透明に設定
	SetLayeredWindowAttributes(hwnd, RGB(255, 255, 255), 0, LWA_COLORKEY);

	//	クライアント領域のスクリーン座標設定
	w = pW->rcCli.right - pW->rcCli.left;
	h = pW->rcCli.bottom - pW->rcCli.top;
	ClientToScreen(hWndMenu, (LPPOINT)&pW->rcCli);
	pW->rcCli.right  = pW->rcCli.left + w;
	pW->rcCli.bottom = pW->rcCli.top  + h;

	//	インスタンスワークポインタ設定
	MAjcSetWindowLong(hwnd, 0, (UX)pW);

	//	マウス監視タイマ起動
	SetTimer(hwnd, 1, 100, NULL);

	//	キャプチャ開始
	SetCapture(hwnd);

	return 0;
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_WNDPROC(Menu, WM_DESTROY	)
{
	PMY_WORK	pW = (PMY_WORK)MAjcGetWindowLong(hwnd, 0);
	int			i;

	//	タイマ停止
	KillTimer(hwnd, 1);

	//	キャプチャ終了
	ReleaseCapture();

	//	メニューテキスト解放
	for (i = 0; i < pW->nItems; i++) {
		if (pW->Tbl[i].pText != NULL) {
			free((BCP)pW->Tbl[i].pText);
		}
	}
	//	インスタンスワーク解放
	free(pW);

	return 0;
}
//----- 左ボタン押下 -------------------------------------------------------------------------------------------//
AJC_WNDPROC(Menu, WM_LBUTTONDOWN)
{
	PMY_WORK	pW = (PMY_WORK)MAjcGetWindowLong(hwnd, 0);
	POINT		pt;
	int			ix;

	pt.x = (SW)LOWORD(lParam);
	pt.y = (SW)HIWORD(lParam);
	ClientToScreen(hwnd, &pt);

	if (pt.x >= pW->rcCli.left && pt.x < pW->rcCli.right && pt.y >= pW->rcCli.top && pt.y < pW->rcCli.bottom) {
		ix = pW->ixTop + ((pt.y - pW->rcCli.top) / pW->szBox.cy);
		PostMessage(pW->hOwner, pW->msg, pW->Tbl[ix].id, pW->lParam);
	}
	DestroyWindow(hwnd);

	return 0;
}
//----- 左ボタンＵＰ -------------------------------------------------------------------------------------------//
AJC_WNDPROC(Menu, WM_LBUTTONUP	)
{
	PMY_WORK	pW = (PMY_WORK)MAjcGetWindowLong(hwnd, 0);
//	DestroyWindow(hwnd);
	return 0;
}
//----- 右ボタン押下 -------------------------------------------------------------------------------------------//
AJC_WNDPROC(Menu, WM_RBUTTONDOWN)
{
	PMY_WORK	pW = (PMY_WORK)MAjcGetWindowLong(hwnd, 0);
	POINT		pt;
	int			ix;

	pt.x = (SW)LOWORD(lParam);
	pt.y = (SW)HIWORD(lParam);
	ClientToScreen(hwnd, &pt);

	if (pt.x >= pW->rcCli.left && pt.x < pW->rcCli.right && pt.y >= pW->rcCli.top && pt.y < pW->rcCli.bottom) {
		ix = pW->ixTop + ((pt.y - pW->rcCli.top) / pW->szBox.cy);
		PostMessage(pW->hOwner, pW->msg, pW->Tbl[ix].id, pW->lParam);
	}
	DestroyWindow(hwnd);

	return 0;
}
//----- 右ボタンＵＰ -------------------------------------------------------------------------------------------//
AJC_WNDPROC(Menu, WM_RBUTTONUP	)
{
	PMY_WORK	pW = (PMY_WORK)MAjcGetWindowLong(hwnd, 0);
//	DestroyWindow(hwnd);
	return 0;
}
//----- キー入力 -----------------------------------------------------------------------------------------------//
AJC_WNDPROC(Menu, WM_CHAR		)
{
	PMY_WORK	pW = (PMY_WORK)MAjcGetWindowLong(hwnd, 0);
	int			key = tolower((UB)wParam);
	int			i;

	for (i = 0; i < pW->nItems; i++) {
		if (pW->Tbl[i].key == key) {
			PostMessage(pW->hOwner, pW->msg, pW->Tbl[i].id, pW->lParam);
			DestroyWindow(hwnd);
		}
	}

	return 0;
}
//----- マウス移動 ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(Menu, WM_MOUSEMOVE	)
{
	PMY_WORK	pW = (PMY_WORK)MAjcGetWindowLong(hwnd, 0);
	POINT		pt;
	int			ix1, ix2;

	pt.x = (SW)LOWORD(lParam);
	pt.y = (SW)HIWORD(lParam);
	ClientToScreen(hwnd, &pt);

	if (pt.x >= pW->rcCli.left && pt.x < pW->rcCli.right  &&  pt.y >= pW->rcCli.top && pt.y < pW->rcCli.bottom) {
		ix1 = pW->ixCur - pW->ixTop;
		ix2 = (pt.y - pW->rcCli.top) / pW->szBox.cy;
		if (ix1 != ix2	&&	pW->ixTop + ix2 < pW->nItems) {
			pW->ixCur = pW->ixTop + ix2;
			InvalidateRect(hwnd, NULL, FALSE);
		}
	}
	else {
		if (pW->ixCur != -1) {
			pW->ixCur = -1;
			InvalidateRect(hwnd, NULL, FALSE);
		}
	}

	return 0;
}
//----- タイマ -------------------------------------------------------------------------------------------------//
AJC_WNDPROC(Menu, WM_TIMER		)
{
	PMY_WORK	pW = (PMY_WORK)MAjcGetWindowLong(hwnd, 0);
	POINT	pt;

	GetCursorPos(&pt);

	if (pW->nItems > pW->nShow) {
		if (pt.x >= pW->rcCli.left && pt.x < pW->rcCli.right) {
			if		(pt.y <= pW->rcCli.top) {
				if (pW->ixTop > 0) {
					pW->ixTop--;
					pW->ixCur = -1;
					InvalidateRect(hwnd, NULL, FALSE);
				}
			}
			else if (pt.y >= pW->rcCli.bottom) {
				if (pW->ixTop + pW->nShow < pW->nItems) {
					pW->ixTop++;
					pW->ixCur =-1;
					InvalidateRect(hwnd, NULL, FALSE);
				}
			}
		}
	}
	return 0;
}
//----- ウインド描画 -------------------------------------------------------------------------------------------//
AJC_WNDPROC(Menu, WM_PAINT	)
{
	PMY_WORK	pW = (PMY_WORK)MAjcGetWindowLong(hwnd, 0);
	PAINTSTRUCT	ps;
	HDC			hdc;
	HDC			mdc  = NULL;
	HFONT		hF;
	HBITMAP		hBmp = NULL;
	HBITMAP		hB;
	HPEN		hP;
	int			i, ix, x, y, x1, x2, y1, y2;
	int			ww = pW->rcWnd.right - pW->rcWnd.left;
	int			wh = pW->rcWnd.bottom - pW->rcWnd.top;
	int			cw, ch;
	RECT		rcCli, rcBox, rcTmp;

	GetClientRect(hwnd, &rcCli);
	cw = rcCli.right - rcCli.left;
	ch = rcCli.bottom - rcCli.top;

	hdc	  	= BeginPaint(hwnd, &ps);
	mdc	  	= CreateCompatibleDC(hdc);
	hBmp	= CreateCompatibleBitmap(hdc, ww, wh);
	if (mdc != NULL && hBmp != NULL) {
		hF		= (HFONT  )SelectObject(mdc, hDefFont	 );
		hP		= (HPEN   )SelectObject(mdc, hPenSeparate);
		hB		= (HBITMAP)SelectObject(mdc, hBmp		 );
		//	全体をクリアー
		FillRect(mdc, &rcCli, (HBRUSH)GetStockObject(WHITE_BRUSH));
		memcpy(&rcTmp, &rcCli, sizeof rcTmp);
		rcTmp.right  -= 3;
		rcTmp.bottom -= 3;
		FillRect(mdc, &rcTmp, hBruBtnFace);
		//	メニュー項目表示
		SetBkMode(mdc, TRANSPARENT);
		x = 0;
		for (i = 0, ix = pW->ixTop, y = pW->yTop; i < pW->nShow; i++, ix++, y += pW->szBox.cy) {
			rcBox.left	 = x;
			rcBox.right  = x + pW->szBox.cx;
			rcBox.top	 = y + 2;
			rcBox.bottom = y + pW->szBox.cy - 2;
			if (ix != pW->ixCur) FillRect(mdc, &rcBox, hBruBtnFace);
			else				 FillRect(mdc, &rcBox, hBruSelect );
			TextOut(mdc, x + (MRG_W / 2), y + (MRG_H / 2), pW->Tbl[ix].pText, (int)wcslen(pW->Tbl[ix].pText));
			if (pW->Tbl[ix].flag & AJCPPMF_SEPARATE) {
				MoveToEx(mdc, 2 			 , y + pW->szBox.cy, NULL);
				LineTo	(mdc, rcBox.right - 2, y + pW->szBox.cy);
			}
		}
		//	ウインドの淵と影を表示
		//	外枠
		SelectObject(mdc, hPenOutLine);
		x1 = 0; x2 = cw - 4; y = 0; 	 MoveToEx(mdc, x1, y , NULL); LineTo(mdc, x2,  y);
							 y = ch - 4; MoveToEx(mdc, x1, y , NULL); LineTo(mdc, x2,  y);
		y1 = 0; y2 = ch - 3; x = 0; 	 MoveToEx(mdc, x , y1, NULL); LineTo(mdc, x , y2);
							 x = cw - 4; MoveToEx(mdc, x , y1, NULL); LineTo(mdc, x , y2);
		//	影１
		SelectObject(mdc, hPenShadow1);
		x1 = 5; x2 = cw - 2; y = ch - 3; MoveToEx(mdc, x1, y , NULL); LineTo(mdc, x2,  y);
		y1 = 5; y2 = ch - 2; x = cw - 3; MoveToEx(mdc, x , y1, NULL); LineTo(mdc, x , y2);
		//	影２
		SelectObject(mdc, hPenShadow2);
		x1 = 6; x2 = cw - 1; y = ch - 2; MoveToEx(mdc, x1, y , NULL); LineTo(mdc, x2,  y);
		y1 = 6; y2 = ch - 1; x = cw - 2; MoveToEx(mdc, x , y1, NULL); LineTo(mdc, x , y2);
		//	影３
		SelectObject(mdc, hPenShadow3);
		x1 = 7; x2 = cw - 0; y = ch - 1; MoveToEx(mdc, x1, y , NULL); LineTo(mdc, x2,  y);
		y1 = 7; y2 = ch - 0; x = cw - 1; MoveToEx(mdc, x , y1, NULL); LineTo(mdc, x , y2);

		//	スクロールを示す三角表示
		if (pW->yTop != 0) {
			SelectObject(mdc, hPenSeparate);
			x1 = x2 = ww / 2;
			y1 = 5;
			y2 = wh - 10;
			for (i = 0; i < 8; i++) {
				MoveToEx(mdc, x1, y1, NULL);
				LineTo	(mdc, x2, y1);
				MoveToEx(mdc, x1, y2, NULL);
				LineTo	(mdc, x2, y2);
				x1--; x2++;
				y1++; y2--;
			}
		}
		//	ディスプレィへ描画
		BitBlt(hdc, 0, 0, ww, wh, mdc, 0, 0, SRCCOPY);
		SelectObject(mdc, hF);
		SelectObject(mdc, hP);
		SelectObject(mdc, hB);
	}
	if (mdc  != NULL) DeleteDC(mdc);
	if (hBmp != NULL) DeleteObject(hBmp);

	EndPaint(hwnd, &ps);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(Menu)
	AJC_WNDMAP_MSG(Menu, WM_CREATE		)
	AJC_WNDMAP_MSG(Menu, WM_DESTROY		)
	AJC_WNDMAP_MSG(Menu, WM_LBUTTONDOWN	)
	AJC_WNDMAP_MSG(Menu, WM_LBUTTONUP	)
	AJC_WNDMAP_MSG(Menu, WM_RBUTTONDOWN	)
	AJC_WNDMAP_MSG(Menu, WM_RBUTTONUP	)
	AJC_WNDMAP_MSG(Menu, WM_CHAR		)
	AJC_WNDMAP_MSG(Menu, WM_MOUSEMOVE	)
	AJC_WNDMAP_MSG(Menu, WM_TIMER		)
	AJC_WNDMAP_MSG(Menu, WM_PAINT		)
AJC_WNDMAP_END
