﻿#ifndef		AJCPP_H_
#define		AJCPP_H_
/****************************************************************************************************************/

#define	INST_ID_PP		0xFFDC3287
#define	IS_PP_INST(P)	(P != NULL && P->InstID == INST_ID_PP)

//----- マクロ -------------------------------------------------------------------------------------------------//
#define		PPC_NTC(EVT, P1, P2, P3)	if (pW->cbNtc != NULL && !pW->fStop) {					\
											pW->cbNtc(AJCPPC_NTC_ANYEVT, EVT, 0, 0, pW->cbp);	\
											pW->cbNtc(EVT, (UX)P1, (UX)P2, (UX)P3 , pW->cbp);	\
										}

#define		PPC_ERR(ERR, P1, P2, P3)	if (pW->cbErr != NULL && !pW->fStop) {					\
											pW->cbErr(ERR, (UX)P1, (UX)P2, (UX)P3, pW->cbp);	\
										}

//----- AjcPpAvlIStr.c -----------------------------------------------------------------------------------------//
//	プロトタイプ
extern	HAJCAVL		PpcIStrInit 	(HAJCPPC pW);
extern	VO			PpcIStrEnd		(HAJCPPC pW);
extern	BCP			PpcIStrRegist	(HAJCPPC pW, C_BCP pStr);
extern	BOOL		PpcIStrIsRegist (HAJCPPC pW, C_BCP pStr);
extern	BOOL		PpcIStrUnRegist (HAJCPPC pW, C_BCP pStr);

//----- AjcPpAvlNStr.c -----------------------------------------------------------------------------------------//
//	プロトタイプ
extern	HAJCAVL		PpcNStrInit 	(HAJCPPC pW);
extern	VO			PpcNStrEnd		(HAJCPPC pW);
extern	BCP			PpcNStrRegist	(HAJCPPC pW, C_BCP pStr);
extern	BOOL		PpcNStrIsRegist (HAJCPPC pW, C_BCP pStr);
extern	BOOL		PpcNStrUnRegist (HAJCPPC pW, C_BCP pStr);

//----- AjcPpAvlInc.c ------------------------------------------------------------------------------------------//
//	プロトタイプ
extern	HAJCAVL		PpcIncInit		(HAJCPPC pW);
extern	VO			PpcIncEnd		(HAJCPPC pW);
extern	BCP			PpcIncRegist	(HAJCPPC pW, C_BCP pStr);
extern	BOOL		PpcIncIsRegist	(HAJCPPC pW, C_BCP pStr);


//----- AjcPpDefined.c -----------------------------------------------------------------------------------------//
//	プロトタイプ
extern	BOOL	PpcDefExp(HAJCPPC pW, PAJCPPCTKNNODE *ppBfr, PAJCPPCTKNNODE pTkn);

//----- AjcPpFormula.c -----------------------------------------------------------------------------------------//
//	プロトタイプ
extern	AJCPPCERROR PpcFormulaExpression(HAJCPPC pW, PAJCPPCTKNNODE pTkn, int *pResult);

//----- AjcPpGsr.c ---------------------------------------------------------------------------------------------//
//	プロトタイプ
extern	PAJCPPCTKNNODE	PpcAllocAndLinkNextToken(HAJCPPC pW, PAJCPPCTKNNODE pCur);
extern	PAJCPPCTKNNODE	PpcRelCurAndGetNextToken(HAJCPPC pW, PAJCPPCTKNNODE pCur);
extern	VO				PpcRelTokenStream		(HAJCPPC pW, PAJCPPCTKNNODE pTop);
extern	BOOL			PpcSetTokenNode 		(HAJCPPC pW, PAJCPPCTKNNODE pTkn, C_BCP pFile, HAJCTK hCtk, C_BCP pSyl);
extern	BOOL			PpcSetTokenNodeByInc	(HAJCPPC pW, PAJCPPCTKNNODE pTkn, C_BCP pFile, HAJCTK hCtk, C_BCP pSyl, UI nest, UI incf);
extern	BOOL			PpcCompTokenStream		(HAJCPPC pW, PAJCPPCTKNNODE p1, PAJCPPCTKNNODE p2);
extern	HAJCTK			PpcCtkCreate			(HAJCPPC pW, PCBAJCTKA pCallBack);

extern	VOP				PpcMemAlloc				(HAJCPPC pW, UI size);
extern	VO				PpcMemFree				(HAJCPPC pW, VOP pMem);
extern	PAJCPPCTKNNODE	PpcTknAlloc				(HAJCPPC pW);
extern	VO				PpcTknFree				(HAJCPPC pW, PAJCPPCTKNNODE pMem);
extern	BOOL			PpcNeedSpace			(PCAJCPPCTKNNODE pBfr);

//----- AjcPpMacro.c -------------------------------------------------------------------------------------------//
#define	PPCMAX_MEXP_NEST	32				//	マクロ展開最大ネスト数

//	マクロ情報（引数なし）
typedef struct {
	BOOL			fWithArg;				//	引数付マクロ・フラグ（＝FALSE）
	BCP				pMacName;				//	マクロ名のＡＶＬキー（マクロ名文字列へのポインタ）
	PAJCPPCTKNNODE	pTknName;				//	マクロ名・トークンノードへのポインタ
	PAJCPPCTKNNODE	pTknBody;				//	マクロボディ・トークンノードへのポインタ
	UI				pos;					//	先頭「#」の桁位置
} PPCMACNODE, *PPPCMACNODE;
typedef const PPCMACNODE *PCPPCMACNODE;

//	マクロ情報（引数付き）
typedef struct {
	BOOL			fWithArg;				//	引数付マクロ・フラグ（＝TRUE）
	BCP				pMacName;				//	マクロ名のＡＶＬキー（マクロ名文字列へのポインタ）
	PAJCPPCTKNNODE	pTknName;				//	マクロ名・トークンノードへのポインタ
	PAJCPPCTKNNODE	pTknBody;				//	マクロボディ・トークンノードへのポインタ
	UI				pos;					//	先頭「#」の桁位置
	BOOL			fVaArgs;				//	可変個引数マクロフラグ
	UI				nTmpArg;				//	仮引数の個数
	HAJCVQUE		hVQueArg;				//	マクロ仮引数名リスト
} PPCMACARGS, *PPPCMACARGS;
typedef const PPCMACARGS *PCPPCMACARGS;

//	プロトタイプ
extern	HAJCAVL		PpcMacInit		(HAJCPPC pW);
extern	VO			PpcMacEnd		(HAJCPPC pW);
extern	BOOL		PpcMacRegist  	(HAJCPPC pW, PAJCPPCTKNNODE pTkn, BOOL fWithArg, UI pos);
extern	BOOL		PpcMacUnRegist	(HAJCPPC pW, C_BCP pName);
extern	VOP			PpcMacGetNode	(HAJCPPC pW, C_BCP pName);
extern	BOOL		PpcMacExpand	(HAJCPPC pW, PAJCPPCTKNNODE *ppBfr);

/****************************************************************************************************************/
#endif
