﻿//
//	AcsAvlIStr.c - 大文字と小文字を区別しない文字列の蓄積
//
#include	"AjcInternal.h"
#include	"AjcPp.h"

//--------------------------------------------------------------------------------------------------------------//
//	キーの比較コールバック																						//
//--------------------------------------------------------------------------------------------------------------//
static int CALLBACK cbComp(UX key1, UX key2, UX cbp)
{
	return(mbsicmp((C_BCP)key1, (C_BCP)key2));
}

//==============================================================================================================//
//	初期設定																									//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	≠NULL：AVLハンドル																				//
//				＝NULL：エラー																					//
//==============================================================================================================//
HAJCAVL	PpcIStrInit(HAJCPPC pW)
{
	HAJCAVL		rc = NULL;

	PpcIStrEnd(pW);
	rc = pW->hAvlIStr = AjcAvlCreate(0, cbComp, NULL);

	if (rc == NULL) {
		pW->fMemErr = TRUE;
		PPC_ERR(AJCPPC_ERROR_MEMALLOC, 0, 0, 0);
	}

	return rc;
}
//==============================================================================================================//
//	終了処理																									//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	≠NULL：AVLハンドル																				//
//				＝NULL：エラー																					//
//==============================================================================================================//
VO		PpcIStrEnd(HAJCPPC pW)
{
	if (pW->hAvlIStr != NULL) {
		AjcAvlDelete(pW->hAvlIStr);
		pW->hAvlIStr = NULL;
	}
}
//==============================================================================================================//
//	文字列登録																									//
//																												//
//	引　数	：	pStr - 登録する文字列のアドレス																	//
//																												//
//	戻り値	：	≠NULL：登録した（あるいは登録済）文字列のアドレス												//
//				＝NULL：エラー																					//
//==============================================================================================================//
BCP		PpcIStrRegist(HAJCPPC pW, C_BCP pStr)
{
	BCP		rc;

	if ((rc = AjcAvlGetNodePtr(pW->hAvlIStr, (UX)pStr, NULL)) == NULL) {
		rc = (BCP)AjcAvlInsStrNodeA(pW->hAvlIStr, pStr);
		if (rc == NULL) {
			pW->fMemErr = TRUE;
			PPC_ERR(AJCPPC_ERROR_MEMALLOC, 0, 0, 0);
		}
	}
	return rc;
}
//==============================================================================================================//
//	文字列登録チェック																							//
//																												//
//	引　数	：	pStr - 登録チェックする文字列のアドレス															//
//																												//
//	戻り値	：	TRUE : 登録済																					//
//				FALSE: 未登録																					//
//==============================================================================================================//
BOOL		PpcIStrIsRegist(HAJCPPC pW, C_BCP pStr)
{
	BOOL	rc = FALSE;

	if (AjcAvlGetNodePtr(pW->hAvlIStr, (UX)pStr, NULL) != NULL) {
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	登録解除（削除）																							//
//																												//
//	引　数	：	pStr - 登録解除する文字列のアドレス																//
//																												//
//	戻り値	：	TRUE : 削除済																					//
//				FALSE: 未登録																					//
//==============================================================================================================//
BOOL		PpcIStrUnRegist(HAJCPPC pW, C_BCP pStr)
{
	BOOL	rc;

	rc = AjcAvlDelNode(pW->hAvlIStr, (UX)pStr);

	return rc;
}
