﻿//
//	AcsAvlInc.c - インクルードファイル名の蓄積／多重インクルードチェック
//
#include	"AjcInternal.h"
#include	"AjcPp.h"

//--------------------------------------------------------------------------------------------------------------//
//	多重インクルードチェック（キーの比較コールバック）															//
//--------------------------------------------------------------------------------------------------------------//
static int CALLBACK cbAvlIncComp(UX key1, UX key2, UX cbp)
{
	HAJCPPC pW = (HAJCPPC)cbp;

	return(mbsicmp((C_BCP)key1, (C_BCP)key2));
}
//==============================================================================================================//
//	多重インクルードチェック（初期化）																			//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	≠NULL：AVLハンドル																				//
//				＝NULL：エラー																					//
//==============================================================================================================//
HAJCAVL	PpcIncInit(HAJCPPC pW)
{
	PpcIncEnd(pW);
	pW->hAvlInc = AjcAvlCreate((UX)pW, cbAvlIncComp, NULL);

	if (pW->hAvlInc == NULL) {
		pW->fMemErr = TRUE;
		PPC_ERR(AJCPPC_ERROR_MEMALLOC, 0, 0, 0);
	}

	return pW->hAvlInc;
}
//==============================================================================================================//
//	多重インクルードチェック（終了処理）																		//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	≠NULL：AVLハンドル																				//
//				＝NULL：エラー																					//
//==============================================================================================================//
VO		PpcIncEnd(HAJCPPC pW)
{
	if (pW->hAvlInc != NULL) {
		AjcAvlDelete(pW->hAvlInc);
		pW->hAvlInc = NULL;
	}
}
//==============================================================================================================//
//	多重インクルードチェック（登録）																			//
//																												//
//	引　数	：	pStr - 登録する文字列のアドレス																	//
//																												//
//	戻り値	：	≠NULL：登録した（あるいは登録済）文字列のアドレス												//
//				＝NULL：エラー																					//
//==============================================================================================================//
BCP		PpcIncRegist(HAJCPPC pW, C_BCP pStr)
{
	BCP		rc;

	if ((rc = AjcAvlGetNodePtr(pW->hAvlInc, (UX)pStr, NULL)) == NULL) {
		rc = (BCP)AjcAvlInsStrNodeA(pW->hAvlInc, pStr);
		if (rc == NULL) {
			pW->fMemErr = TRUE;
			PPC_ERR(AJCPPC_ERROR_MEMALLOC, 0, 0, 0);
		}
	}
	return rc;
}
//==============================================================================================================//
//	多重インクルードチェック（登録チェック）																	//
//																												//
//	引　数	：	pStr - 登録チェックする文字列のアドレス															//
//																												//
//	戻り値	：	TRUE : 登録済																					//
//				FALSE: 未登録																					//
//==============================================================================================================//
BOOL		PpcIncIsRegist(HAJCPPC pW, C_BCP pStr)
{
	BOOL	rc = FALSE;

	if (AjcAvlGetNodePtr(pW->hAvlInc, (UX)pStr, NULL) != NULL) {
		rc = TRUE;
	}
	return rc;
}
