﻿//
//	AcsAvlNStr.c - 大文字と小文字を区別する文字列の蓄積
//
#include	"AjcInternal.h"
#include	"AjcPp.h"

//--------------------------------------------------------------------------------------------------------------//
//	キーの比較コールバック																						//
//--------------------------------------------------------------------------------------------------------------//
static int CALLBACK cbComp(UX key1, UX key2, UX cbp)
{
	return(mbscmp((C_BCP)key1, (C_BCP)key2));
}

//==============================================================================================================//
//	初期設定																									//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	≠NULL：AVLハンドル																				//
//				＝NULL：エラー																					//
//==============================================================================================================//
HAJCAVL	PpcNStrInit(HAJCPPC pW)
{
	HAJCAVL		rc = NULL;

	PpcNStrEnd(pW);
	rc = pW->hAvlNStr = AjcAvlCreate(0, cbComp, NULL);

	if (rc == NULL) {
		pW->fMemErr = TRUE;
		PPC_ERR(AJCPPC_ERROR_MEMALLOC, 0, 0, 0);
	}

	return rc;
}
//==============================================================================================================//
//	終了処理																									//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	≠NULL：AVLハンドル																				//
//				＝NULL：エラー																					//
//==============================================================================================================//
VO		PpcNStrEnd(HAJCPPC pW)
{
	if (pW->hAvlNStr != NULL) {
		AjcAvlDelete(pW->hAvlNStr);
		pW->hAvlNStr = NULL;
	}
}
//==============================================================================================================//
//	文字列登録																									//
//																												//
//	引　数	：	pStr - 登録する文字列のアドレス																	//
//																												//
//	戻り値	：	≠NULL：登録した文字列のアドレス																//
//				＝NULL：エラー																					//
//==============================================================================================================//
BCP		PpcNStrRegist(HAJCPPC pW, C_BCP pStr)
{
	BCP		rc;

	if ((rc = AjcAvlGetNodePtr(pW->hAvlNStr, (UX)pStr, NULL)) == NULL) {
		rc = (BCP)AjcAvlInsStrNodeA(pW->hAvlNStr, pStr);
		if (rc == NULL) {
			pW->fMemErr = TRUE;
			PPC_ERR(AJCPPC_ERROR_MEMALLOC, 0, 0, 0);
		}
	}
	return rc;
}
//==============================================================================================================//
//	文字列登録チェック																							//
//																												//
//	引　数	：	pStr - 登録チェックする文字列のアドレス															//
//																												//
//	戻り値	：	TRUE : 登録済																					//
//				FALSE: 未登録																					//
//==============================================================================================================//
BOOL		PpcNStrIsRegist(HAJCPPC pW, C_BCP pStr)
{
	BOOL	rc = FALSE;

	if (AjcAvlGetNodePtr(pW->hAvlNStr, (UX)pStr, NULL) != NULL) {
		rc = TRUE;
	}
	return rc;
}

//==============================================================================================================//
//	登録解除（削除）																							//
//																												//
//	引　数	：	pStr - 登録解除する文字列のアドレス																//
//																												//
//	戻り値	：	TRUE : 削除済																					//
//				FALSE: 未登録																					//
//==============================================================================================================//
BOOL		PpcNStrUnRegist(HAJCPPC pW, C_BCP pStr)
{
	BOOL	rc;

	rc = AjcAvlDelNode(pW->hAvlNStr, (UX)pStr);

	return rc;
}
