﻿//
//	AcsDefined.c - プリプロセス文中の「defined(ID)」の展開
//
#include	"AjcInternal.h"
#include	"AjcPp.h"

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
static PAJCPPCTKNNODE SubRemoveDefined(HAJCPPC pW, PAJCPPCTKNNODE *ppBfr, PAJCPPCTKNNODE pCur);

//==============================================================================================================//
//	プリプロセス文中の「defined(SYM)」の展開																	//
//																												//
//	トークンストリーム中の「defined SYM」や「defined(SYM)」を、数値（０／１）に変換します。						//
//																												//
//	引　数	：	ppBfr - 直前のトークンからトークンストリームへのポインタのアドレス								//
//				pTkn  - トークンストリームのアドレス															//
//																												//
//	戻り値	：	TRUE : 「defined SYM」や「defined(SYM)」を数値に展開した										//
//				FALSE: 「defined SYM」や「defined(SYM)」は無い、あるいは記述ミス								//
//==============================================================================================================//
BOOL	PpcDefExp(HAJCPPC pW, PAJCPPCTKNNODE *ppBfr, PAJCPPCTKNNODE pTkn)
{
	BOOL			rc	= FALSE;
	PAJCPPCTKNNODE	pCur, pNx1, pNx2, pNx3, pVal;

	pCur = pTkn;
	while (pCur != NULL) {
		if (pCur->tkn == EAJCTK_RSV_DEFINED) {							//	defined・・・？
			pNx1 = pCur->pNxt;
			pNx2 = (pNx1 != NULL) ? (pNx1->pNxt) : (NULL);
			pNx3 = (pNx2 != NULL) ? (pNx2->pNxt) : (NULL);
			if		(pNx1 != NULL && AJCTKIS_SYMBOL(pNx1->tkn)) {		//	defined SYMBOL
				//----- 'defined SYMBOL 'を数値で置き換える ----//
				//	'defined'を数値ノードに変更
				pCur->pNxt		= pNx1->pNxt;			//	次ノードポインタ（シンボルの直後のトークンへのポインタ）
			//	pCur->pFile		= pNx1->pFile;			//	ファイルパス名へのポインタ			（変更不要）
														//	語句文字列
				pCur->pSyl		= (PpcNStrRegist(pW, (PpcMacGetNode(pW, pNx1->pSyl) == NULL) ? "0" : "1"));
				if (pCur->pSyl == NULL) {pW->fStop = TRUE; break;}
				pCur->tkn		= EAJCTK_VAL_DECIMAL;	//	トークンコード
				pCur->kndPP		= AJCPPC_PPK_TOKEN;		//	通常のトークン
			//	pCur->lno		= pNx1->lno;			//	行番号								（変更不要）
			//	pCur->pos		= pNx1->pos;			//	トークンの位置（タブステップ＝４）	（変更不要）
			//	pCur->ppIf		= 0						//	条件コンパイル＝TRUEを示すフラグ	（変更不要）
				pCur->flg		= pNx1->flg;			//	フラグ情報
			//	pCur->inst		= pNx1->inst;			//	#includeネストレベル				（変更不要）
			//	pCur->incf		= pNx1->incf;			//	#include種別						（変更不要）
			//	pCur->mexp		= pNx1->mexp;			//	マクロ展開ネストレベル				（変更不要）
				//	'SYMBOL'ノード消去
				PpcTknFree(pW, pNx1);
				//	直前ポインタ更新
				ppBfr = &pCur->pNxt;
				pCur  =  pCur->pNxt;
				//	戻り値（「defined SYM」を数値に変換した）
				rc = TRUE;
			}
			else if (pNx1 != NULL && pNx2 != NULL && pNx3 != NULL) {	//	defined(SYMBOL)
				if	   (pNx1->tkn != EAJCTK_DLM_LSPART) {
					//----- エラー通知 --------------------------//
					PPC_ERR(AJCPPC_DEFERR_NEED_LP, pCur->pFile, pCur->lno, 0);
					//----- 'defined(...)'を消去 ----------------//
					pCur = SubRemoveDefined(pW, ppBfr, pCur);
					//----- エラーフラグ設定 --------------------//
					rc = FALSE;
				}
				else if (!AJCTKIS_SYMBOL(pNx2->tkn)) {
					//----- エラー通知 --------------------------//
					PPC_ERR(AJCPPC_DEFERR_NEED_SYMBOL, pCur->pFile, pCur->lno, 0);
					//----- 'defined(...)'を消去 ----------------//
					pCur = SubRemoveDefined(pW, ppBfr, pCur);
					//----- エラーフラグ設定 --------------------//
					rc = FALSE;
				}
				else if (pNx3->tkn != EAJCTK_DLM_RSPART) {
					//----- エラー通知 --------------------------//
					PPC_ERR(AJCPPC_DEFERR_NEED_RP, pCur->pFile, pCur->lno, pNx2->pSyl);
					//----- 'defined(...)'を消去 ----------------//
					pCur = SubRemoveDefined(pW, ppBfr, pCur);
					//----- エラーフラグ設定 --------------------//
					rc = FALSE;
				}
				else {	// 正常な 'define(Symbol)' ?
					//----- 'defined(...)'を数値で置き換える ----//
					//	数値ノード生成
					pVal = PpcTknAlloc(pW);
					if (pVal != NULL) {
						pVal->pNxt		= NULL;					//	次ノードポインタ
						pVal->pFile		= pCur->pFile;			//	ファイルパス名へのポインタ
						pVal->pSyl		= (PpcNStrRegist(pW, (PpcMacGetNode(pW, pNx2->pSyl) == NULL) ? "0" : "1")); //	語句文字列
						if (pVal->pSyl == NULL) {pW->fStop = TRUE; break;}
						pVal->tkn		= EAJCTK_VAL_DECIMAL;	//	トークンコード
						pVal->kndPP		= AJCPPC_PPK_TOKEN;		//	通常のトークン
						pVal->lno		= pCur->lno;			//	行番号
						pVal->pos		= pCur->pos;			//	トークンの位置（タブステップ＝４）
						pVal->ppIf		= 0;					//	条件コンパイル＝TRUEを示すフラグ
						pVal->flg		= pNx3->flg;			//	フラグ情報
						pVal->inst		= pCur->inst;			//	#includeネストレベル
						pVal->incf		= pCur->incf;			//	#include種別
						pVal->mexp		= pCur->mexp;			//	マクロ展開ネストレベル
						//	'defined(...)'を消去
						pCur = SubRemoveDefined(pW, ppBfr, pCur);
						//	数値ノード挿入
						pVal->pNxt =  pCur;
						*ppBfr	   =  pVal;
						 ppBfr	   = &pVal->pNxt;
						//	戻り値（「defined(SYM)」を数値に変換した）
						rc = TRUE;
					}
					else pW->fStop = TRUE;
				}
			}
			else {
					//----- エラー通知 --------------------------//
					PPC_ERR(AJCPPC_DEFERR_INVALID, pCur->pFile, pCur->lno, 0);
					//----- 'defined(...)' 消去 -----------------//
					pCur = SubRemoveDefined(pW, ppBfr, pCur);
			}
		}
		else {															//	defined以外？
			ppBfr = &(pCur->pNxt);
			pCur  =   pCur->pNxt;
		}
	}

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	'defined(...)'ノード消去																					//
//																												//
//	引　数	：	ppBfr - 直前のトークンから現トークンへのポインタのアドレス										//
//				pCur  - 現トークンのアドレス																	//
//																												//
//	戻り値	：	≠NULL : 'defined(...)'の次のトークンノードアドレス												//
//				＝NULL : トークン終端																			//
//--------------------------------------------------------------------------------------------------------------//
static PAJCPPCTKNNODE SubRemoveDefined(HAJCPPC pW, PAJCPPCTKNNODE *ppBfr, PAJCPPCTKNNODE pCur)
{
	UI				nest;
	PAJCPPCTKNNODE	svp;

	//----- 'defined' 消去 -------------------------------------//
	svp    = pCur;
	pCur   = pCur->pNxt;
	PpcTknFree(pW, svp);

	//----- '(...)' 消去 ---------------------------------------//
	if (pCur != NULL && pCur->tkn == EAJCTK_DLM_LSPART) {
		nest = 0;
		do {
			if		(pCur->tkn == EAJCTK_DLM_LSPART) nest++;	// '('
			else if (pCur->tkn == EAJCTK_DLM_RSPART) nest--;	// ')'
			svp    = pCur;
			pCur   = pCur->pNxt;
			PpcTknFree(pW, svp);
		} while (pCur != NULL && nest != 0);
	}
	//----- 直前のトークンと連結 -------------------------------//
	*ppBfr = pCur;

	return pCur;
}
