﻿//
//	AjcPpMain.c - エラーメッセージテキスト作成
//
#include	"AjcInternal.h"
#include	"AjcPp.h"

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
__declspec(thread) static BC ErrMsgText[1024];		//	エラーメッセージテキスト

//==============================================================================================================//
//	エラーメッセージテキスト取得																				//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//																												//
//	戻り値	：	エラーメッセージテキスト																		//
//==============================================================================================================//
#define	PS(FMTJ, FMTE, ...)	AjcSnPrintFA(ErrMsgText, AJCTSIZE(ErrMsgText), LNGSEL(FMTJ, FMTE), __VA_ARGS__)
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	C_BCP	WINAPI	AjcPpcGetErrMsgText(AJCPPCERROR err, UX p1, UX p2, UX p3)
{
	switch (err) {
		case AJCPPC_ERROR_SRC_OPEN:
			PS("ソースファイル(%s)をオープンできません" 						, "Source file(%s) open failure."									, (VOP)p1);
			break;
		case AJCPPC_ERROR_INC_OPEN:
			PS("\"%s\"<%d>: インクルードファイルをオープンできません(%s)"		, "\"%s\"<%d>: Include file open failure(%s)."						, (VOP)p1, (UI)p2, (VOP)p3);
			break;
		case AJCPPC_ERROR_NO_SYMBOL:
			PS("\"%s\"<%d>: #ifdef/#ifndefで、シンボル名が指定されていません"	, "\"%s\"<%d>: No symbol in #ifdef/#ifndef"							, (VOP)p1, (UI)p2);
			break;
		case AJCPPC_ERROR_COND_NOTCLS:
			PS("\"%s\"<1>: 条件(#if～#endif)がクローズされていません"			, "\"%s\"<1>: #if～#endif is not closed"							, (VOP)p1);
			break;
		case AJCPPC_ERROR_COND_DEEP:
			PS("\"%s\"<%d>: 条件(#if～#endif)のネストが深すぎます" 				, "\"%s\"<%d>: A nest of pre-process(#if～#endif) is too deep."		, (VOP)p1, (UI)p2);
			break;
		case AJCPPC_ERROR_NOT_IN_IF:
			PS("\"%s\"<%d>: 対応する「#if / #ifdef / #ifndef」がありません" 	, "\"%s\"<%d>: There is no '#if / #ifdef / #ifndef'."				, (VOP)p1, (UI)p2);
			break;
		case AJCPPC_ERROR_ELIF_IN_ELSE:
			PS("\"%s\"<%d>: 「#else」条件中に「#elif」は記述できません" 		, "\"%s\"<%d>: '#else or #elif' can't be described during the '#else' condition.", (VOP)p1, (UI)p2);
			break;
		case AJCPPC_ERROR_ELSE_IN_ELSE:
			PS("\"%s\"<%d>: 「#else」条件中に「#else」は記述できません" 		, "\"%s\"<%d>: '#else' can't be described during the '#else' condition.", (VOP)p1, (UI)p2);
			break;
		case AJCPPC_DEFERR_INVALID:
			PS("\"%s\"<%d>: 'defined'の構文誤り"								, "\"%s\"<%d>: 'defined' syntax error"								, (VOP)p1, (UI)p2);
			break;
		case AJCPPC_DEFERR_NEED_LP:
			PS("\"%s\"<%d>: 'defined'の後に左括弧 '(' が必要です"				, "\"%s\"<%d>: A left parenthesis is needed after 'defined'."		, (VOP)p1, (UI)p2);
			break;
		case AJCPPC_DEFERR_NEED_SYMBOL:
			PS("\"%s\"<%d>: 'defined'でシンボルが指定されていません" 			, "\"%s\"<%d>: No symbol in 'defined'."								, (VOP)p1, (UI)p2);
			break;
		case AJCPPC_DEFERR_NEED_RP:
			PS("\"%s\"<%d>: シンボル(%s)の後に右括弧 ')' が必要です"			, "\"%s\"<%d>: A right parenthesis is needed after '%s'."			, (VOP)p1, (UI)p2, (VOP)p3);
			break;
		case AJCPPC_MACERR_NEED_LP:
			PS("\"%s\"<%d>: マクロ名(%s)の後に左括弧が必要です" 				, "\"%s\"<%d>: A left parenthesis is needed after '%s'."			, (VOP)p1, (UI)p2, (VOP)p3);
			break;
		case AJCPPC_MACERR_NEED_RP:
			PS("\"%s\"<%d>: 仮引数(%s)の後に右括弧が必要です"					, "\"%s\"<%d>: A right parenthesis is needed after '%s'."			, (VOP)p1, (UI)p2, (VOP)p3);
			break;
		case AJCPPC_MACERR_NEED_RP_C:	
			PS("\"%s\"<%d>: 仮引数(%s)の後に右括弧かカンマが必要です"			, "\"%s\"<%d>: A comma or the right parenthesis is needed after '%s'.", (VOP)p1, (UI)p2, (VOP)p3);
			break;
		case AJCPPC_MACERR_MULTDEF:
			PS("\"%s\"<%d>: マクロ(%s)二重定義" 								, "\"%s\"<%d>: Multiply defined MACRO '%s'."						, (VOP)p1, (UI)p2, (VOP)p3);
			break;
		case AJCPPC_MACERR_INV_NAME:
			PS("\"%s\"<%d>: 不正なマクロ名です" 								, "\"%s\"<%d>: Invalid macro-name."									, (VOP)p1, (UI)p2);
			break;
		case AJCPPC_MACERR_NO_NAME:
			PS("\"%s\"<%d>: マクロ名がありません"								, "\"%s\"<%d>: No MACRO name." 										, (VOP)p1, (UI)p2);
			break;
		case AJCPPC_MACERR_NEST_OVER:
			PS("\"%s\"<%d>: マクロ展開ネストオーバー(%s)"						, "\"%s\"<%d>: Macro expression too deep(%s)."						, (VOP)p1, (UI)p2, (VOP)p3);
			break;
		case AJCPPC_MACERR_ARG_LACK:
			PS("\"%s\"<%d>: マクロ(%s)の引数が少なすぎます" 					, "\"%s\"<%d>: Too few arguments for macro(%s)."					, (VOP)p1, (UI)p2, (VOP)p3);
			break;
		case AJCPPC_MACERR_ARG_OVER:
			PS("\"%s\"<%d>: マクロ(%s)の引数が多すぎます"						, "\"%s\"<%d>: Too may arguments for macro(%s)."					, (VOP)p1, (UI)p2, (VOP)p3);
			break;
		case AJCPPC_INCERR_NO_FILE:
			PS("\"%s\"<%d>: Include ファイル名が指定されていません" 			, "\"%s\"<%d>: No Include file name."								, (VOP)p1, (UI)p2);
			break;
		case AJCPPC_INCERR_INV_FILE:
			PS("\"%s\"<%d>: Include ファイルの記述が不正です"					, "\"%s\"<%d>: Invalid include file name." 							, (VOP)p1, (UI)p2);
			break;
		case AJCPPC_INCERR_NOTCLS:
			PS("\"%s\"<%d>: Include ファイル名の後に '>' がありません"			, "\"%s\"<%d>: Need '>' after the file name."						, (VOP)p1, (UI)p2);
			break;
		case AJCPPC_INCERR_NEST_OVER:
			PS("\"%s\"<%d>: Include ファイルのネストオーバー"					, "\"%s\"<%d>: A nest of inclusion is too deep."					, (VOP)p1, (UI)p2);
			break;
		case AJCPPC_INCERR_NOT_FOUND:
			PS("\"%s\"<%d>: Include ファイルが見つかりません(%s)"				, "\"%s\"<%d>: Include file not found (%s)."						, (VOP)p1, (UI)p2, (VOP)p3);
			break;
		case AJCPPC_SCLERR_INVSYL:
			PS("\"%s\"<%d>: 式中に不当な語句があります(%s)" 					, "\"%s\"<%d>: Invalid Syllable(%s)."								, (VOP)p1, (UI)p2, (VOP)p3);
			break;
		case AJCPPC_SCLERR_DIVZERO:
			PS("\"%s\"<%d>: ゼロ除算エラー" 									, "\"%s\"<%d>: Devision by zero."									, (VOP)p1, (UI)p2);
			break;
		case AJCPPC_SCLERR_NOTCLS:
			PS("\"%s\"<%d>: 右括弧で閉じられていません" 						, "\"%s\"<%d>: It isn't closed by the right parenthesis."			, (VOP)p1, (UI)p2);
			break;
		case AJCPPC_SCLERR_EXPRESSION:
			PS("\"%s\"<%d>: 不当な数式表現です「%s」"							, "\"%s\"<%d>: Invalid formula expression. '%s'"					, (VOP)p1, (UI)p2, (VOP)p3);
			break;
		case AJCPPC_SCLERR_EOL:
			PS("\"%s\"<%d>: 数式表現が途中で終了しています" 					, "\"%s\"<%d>: Formula expression has not concluded."				, (VOP)p1, (UI)p2);
			break;
		case AJCPPC_SCLERR_OVERNEST:
			PS("\"%s\"<%d>: 数式表現のネストが深すぎます"						, "\"%s\"<%d>: Formula expression too deep."						, (VOP)p1, (UI)p2);
			break;
		case AJCPPC_ERROR_MEMALLOC:
			PS("\"%s\"<%d>: メモリ割り当て失敗" 								, "\"%s\"<%d>: Memory allocation failure.");
			break;
		default:
			PS("未定義エラーを検出しました" 									, "Undefined error detected.");
			break;
	}
	return ErrMsgText;
}
