﻿//
//	AcsFormula.c - プリプロセス文（#if / #elif）で指定された式の評価
//
#include	"AjcInternal.h"
#include	"AjcPp.h"

#define	MAX_NEST	32				//	最大ネスト数

#define	ISLV01(TKN)	((TKN) == EAJCTK_DLM_MULT || (TKN) == EAJCTK_DLM_DIV || (TKN) == EAJCTK_DLM_MOD)								/*	*	/	%		*/
#define	ISLV02(TKN)	((TKN) == EAJCTK_DLM_PLUS || (TKN) == EAJCTK_DLM_MINUS)															/*	+	-			*/
#define	ISLV03(TKN)	((TKN) == EAJCTK_DLM_SHL  || (TKN) == EAJCTK_DLM_SHR  )															/*	<<	>>			*/
#define	ISLV04(TKN)	((TKN) == EAJCTK_DLM_LO   || (TKN) == EAJCTK_DLM_HI || (TKN) == EAJCTK_DLM_LOEQ || (TKN) == EAJCTK_DLM_HIEQ)	/*	<	>	<=	>=	*/
#define	ISLV05(TKN)	((TKN) == EAJCTK_DLM_EQEQ || (TKN) == EAJCTK_DLM_NOTEQ)															/*	==	!=			*/
#define	ISLV06(TKN)	((TKN) == EAJCTK_DLM_AND )																						/*	&				*/
#define	ISLV07(TKN)	((TKN) == EAJCTK_DLM_XOR )																						/*	^				*/
#define	ISLV08(TKN)	((TKN) == EAJCTK_DLM_OR  )																						/*	|				*/
#define	ISLV09(TKN)	((TKN) == EAJCTK_DLM_LAND)																						/*	&&				*/
#define	ISLV10(TKN)	((TKN) == EAJCTK_DLM_LOR )																						/*	||				*/
#define	ISLV11(TKN)	((TKN) == EAJCTK_DLM_QUEST || (TKN) == EAJCTK_DLM_COLON)														/*	?  :			*/

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
static	int				express		(HAJCPPC pW);
static	int				expresses	(HAJCPPC pW, int n);
static	int				Lvl11		(HAJCPPC pW);
static	int				Lvl11s		(HAJCPPC pW, int n);
static	int				Lvl10		(HAJCPPC pW);
static	int				Lvl10s		(HAJCPPC pW, int n);
static	int				Lvl09		(HAJCPPC pW);
static	int				Lvl09s		(HAJCPPC pW, int n);
static	int				Lvl08		(HAJCPPC pW);
static	int				Lvl08s		(HAJCPPC pW, int n);
static	int				Lvl07		(HAJCPPC pW);
static	int				Lvl07s		(HAJCPPC pW, int n);
static	int				Lvl06		(HAJCPPC pW);
static	int				Lvl06s		(HAJCPPC pW, int n);
static	int				Lvl05		(HAJCPPC pW);
static	int				Lvl05s		(HAJCPPC pW, int n);
static	int				Lvl04		(HAJCPPC pW);
static	int				Lvl04s		(HAJCPPC pW, int n);
static	int				Lvl03		(HAJCPPC pW);
static	int				Lvl03s		(HAJCPPC pW, int n);
static	int				Lvl02		(HAJCPPC pW);
static	int				Lvl02s		(HAJCPPC pW, int n);
static	int				Lvl01		(HAJCPPC pW);
static	int				Lvl01s		(HAJCPPC pW, int n);
static	int				part		(HAJCPPC pW);

static	EAJCTKCODE		SkipSylAndChkEOL(HAJCPPC pW);
static	EAJCTKCODE		SkipSyl			(HAJCPPC pW);

//==============================================================================================================//
//	プリプロセス文（#if / #elif）で指定された式の評価															//
//																												//
//	引　数	：	pTkn	- 式の先頭トークン																		//
//				pResult	- 演算結果を格納するバッファのアドレス													//
//																												//
//	戻り値	：	＝０ - ＯＫ																						//
//				≠０ - エラーコード																				//
//==============================================================================================================//
AJCPPCERROR PpcFormulaExpression(HAJCPPC pW, PAJCPPCTKNNODE pTkn, int *pResult)
{
	int		n;

	//----- デバッグ情報（トークン列）表示 -------------//
	#ifdef _DEBUG
	{	PAJCPPCTKNNODE	p = pTkn;
		while ( p != NULL) {
			p = p->pNxt;
		}
	}
	#endif

	//----- 変数初期化 ---------------------------------//
	pW->pFmlCur		= pTkn;					//	現在の語句情報ポインタ
	pW->FmlNestCnt	= 0;					//	ネストカウンタ
	pW->FmlSclErr	= AJCPPC_ERROR_OK;		//	エラーコード
	pW->nstDmyRgtInLAndLOr = 0;				//	「&&」「||」の右側を評価しない旨のフラグ（ネスト値）

	//----- 演算実行 -----------------------------------//
	n = express(pW);

	//----- 演算式の終端チェック -----------------------//
	if (pW->FmlSclErr == AJCPPC_ERROR_OK) {
		if (!(pW->pFmlCur->pNxt == NULL || pW->pFmlCur->tkn == EAJCTK_EOF)) {
			pW->FmlSclErr = AJCPPC_SCLERR_EXPRESSION;
			PPC_ERR(pW->FmlSclErr, pW->pFmlCur->pFile, pW->pFmlCur->lno, pW->pFmlCur->pSyl);
		}
	}

	//----- 演算結果格納 -------------------------------//
	if (pResult != NULL) *pResult = n;

	return pW->FmlSclErr;
}

//--------------------------------------------------------------------------------------------------------------//
//	E X P R E S S																								//
//--------------------------------------------------------------------------------------------------------------//
static	int	express(HAJCPPC pW)
{
	int		n = 0;

	if (pW->FmlSclErr == AJCPPC_ERROR_OK) {
		if (pW->FmlNestCnt < MAX_NEST) {
			pW->FmlNestCnt++;
			n = expresses(pW, Lvl11(pW));
			pW->FmlNestCnt--;
		}
		else {
			pW->FmlSclErr = AJCPPC_SCLERR_OVERNEST;
			PPC_ERR(pW->FmlSclErr, pW->pFmlCur->pFile, pW->pFmlCur->lno, 0);
		}
	}
	return n;
}
//--------------------------------------------------------------------------------------------------------------//
//	E X P R E S S E S																							//
//--------------------------------------------------------------------------------------------------------------//
static	int	expresses(HAJCPPC pW, int n)
{
	while (pW->FmlSclErr == AJCPPC_ERROR_OK  &&  ISLV11(pW->pFmlCur->tkn)) {
		n = express(pW);
	}
	return n;
}

//--------------------------------------------------------------------------------------------------------------//
//	Lvl11																										//
//--------------------------------------------------------------------------------------------------------------//
static	int	Lvl11(HAJCPPC pW)
{
	int		n = 0;

	if (pW->FmlSclErr == AJCPPC_ERROR_OK) {
		n = Lvl11s(pW, Lvl10(pW));
	}
	return n;
}
//--------------------------------------------------------------------------------------------------------------//
//	Lvl11s																										//
//--------------------------------------------------------------------------------------------------------------//
static	int	Lvl11s(HAJCPPC pW, int n)
{
	while (pW->FmlSclErr == AJCPPC_ERROR_OK  &&  pW->pFmlCur->tkn == EAJCTK_DLM_QUEST) {	// 「 ? 」
		//	語句スキップ＆ＥＯＬチェック
		if (SkipSylAndChkEOL(pW) == EAJCTK_EOF) break;
		if (n) {
			n = Lvl10(pW);
			if (pW->FmlSclErr) break;
			if (pW->pFmlCur->tkn == EAJCTK_DLM_COLON) {		//	「 : 」
				if (SkipSylAndChkEOL(pW) == EAJCTK_EOF) break;
				Lvl10(pW);
			}
		}
		else {
			Lvl10(pW);
			if (pW->FmlSclErr) break;
			if (pW->pFmlCur->tkn == EAJCTK_DLM_COLON) {		//	「 : 」
				if (SkipSylAndChkEOL(pW) == EAJCTK_EOF) break;
				n = Lvl10(pW);
			}
		}
	}

	return n;
}
//--------------------------------------------------------------------------------------------------------------//
//	Lvl10																										//
//--------------------------------------------------------------------------------------------------------------//
static	int	Lvl10(HAJCPPC pW)
{
	int		n = 0;

	if (pW->FmlSclErr == AJCPPC_ERROR_OK) {
		n = Lvl10s(pW, Lvl09(pW));
	}
	return n;
}
//--------------------------------------------------------------------------------------------------------------//
//	Lvl10s																										//
//--------------------------------------------------------------------------------------------------------------//
static	int	Lvl10s(HAJCPPC pW, int n)
{
	EAJCTKCODE	s;
	int			x;

	while (pW->FmlSclErr == AJCPPC_ERROR_OK  &&  ISLV10(s = pW->pFmlCur->tkn)) {	//	「 || 」
		if (SkipSylAndChkEOL(pW) == EAJCTK_EOF) break;
		if (s == EAJCTK_DLM_LOR) {
			if (!n) {
				x = Lvl09(pW);
				n = (n || x);
			}
			else {
				pW->nstDmyRgtInLAndLOr++;		//	「||」の右側ダミー演算中 設定
				x = Lvl09(pW);
				pW->nstDmyRgtInLAndLOr--;		//	「||」の右側ダミー演算中 解除（ネスト減算）
			}
		}
	}
	return n;
}
//--------------------------------------------------------------------------------------------------------------//
//	Lvl09																										//
//--------------------------------------------------------------------------------------------------------------//
static	int	Lvl09(HAJCPPC pW)
{
	int		n = 0;

	if (pW->FmlSclErr == AJCPPC_ERROR_OK) {
		n = Lvl09s(pW, Lvl08(pW));
	}
	return n;
}
//--------------------------------------------------------------------------------------------------------------//
//	Lvl09s																										//
//--------------------------------------------------------------------------------------------------------------//
static	int	Lvl09s(HAJCPPC pW, int n)
{
	EAJCTKCODE	s;
	int			x;

	while (pW->FmlSclErr == AJCPPC_ERROR_OK  &&  ISLV09(s = pW->pFmlCur->tkn)) {	//	「 && 」
		if (SkipSylAndChkEOL(pW) == EAJCTK_EOF) break;
		switch (s) {
			case EAJCTK_DLM_LAND:
				if (n) {
					x = Lvl08(pW);
					n = (n && x);
				}
				else {
					pW->nstDmyRgtInLAndLOr++;		//	「&&」の右側ダミー演算中 設定
					Lvl08(pW);
					pW->nstDmyRgtInLAndLOr--;		//	「&&」の右側ダミー演算中 解除（ネスト減算）
				}
				break;
		}
	}
	return n;
}
//--------------------------------------------------------------------------------------------------------------//
//	Lvl08																										//
//--------------------------------------------------------------------------------------------------------------//
static	int	Lvl08(HAJCPPC pW)
{
	int		n = 0;

	if (pW->FmlSclErr == AJCPPC_ERROR_OK) {
		n = Lvl08s(pW, Lvl07(pW));
	}
	return n;
}
//--------------------------------------------------------------------------------------------------------------//
//	Lvl08s																										//
//--------------------------------------------------------------------------------------------------------------//
static	int	Lvl08s(HAJCPPC pW, int n)
{
	EAJCTKCODE	s;

	while (pW->FmlSclErr == AJCPPC_ERROR_OK  &&  ISLV08(s = pW->pFmlCur->tkn)) {	//	「 | 」
		if (SkipSylAndChkEOL(pW) == EAJCTK_EOF) break;
		switch (s) {
			case EAJCTK_DLM_OR:	n = (n | Lvl07(pW));	break;
		}
	}
	return n;
}
//--------------------------------------------------------------------------------------------------------------//
//	Lvl07																										//
//--------------------------------------------------------------------------------------------------------------//
static	int	Lvl07(HAJCPPC pW)
{
	int		n = 0;

	if (pW->FmlSclErr == AJCPPC_ERROR_OK) {
		n = Lvl07s(pW, Lvl06(pW));
	}
	return n;
}
//--------------------------------------------------------------------------------------------------------------//
//	Lvl07s																										//
//--------------------------------------------------------------------------------------------------------------//
static	int	Lvl07s(HAJCPPC pW, int n)
{
	EAJCTKCODE	s;

	while (pW->FmlSclErr == AJCPPC_ERROR_OK  &&  ISLV07(s = pW->pFmlCur->tkn)) {	//	「 ^ 」
		if (SkipSylAndChkEOL(pW) == EAJCTK_EOF) break;
		switch (s) {
			case EAJCTK_DLM_XOR:	n = (n ^ Lvl06(pW));	break;
		}
	}
	return n;
}
//--------------------------------------------------------------------------------------------------------------//
//	Lvl06																										//
//--------------------------------------------------------------------------------------------------------------//
static	int	Lvl06(HAJCPPC pW)
{
	int		n = 0;

	if (pW->FmlSclErr == AJCPPC_ERROR_OK) {
		n = Lvl06s(pW, Lvl05(pW));
	}
	return n;
}
//--------------------------------------------------------------------------------------------------------------//
//	Lvl06s																										//
//--------------------------------------------------------------------------------------------------------------//
static	int	Lvl06s(HAJCPPC pW, int n)
{
	EAJCTKCODE	s;

	while (pW->FmlSclErr == AJCPPC_ERROR_OK  &&  ISLV06(s = pW->pFmlCur->tkn)) {	//	「 & 」
		if (SkipSylAndChkEOL(pW) == EAJCTK_EOF) break;
		switch (s) {
			case EAJCTK_DLM_AND:	n = (n & Lvl05(pW));	break;
		}
	}
	return n;
}
//--------------------------------------------------------------------------------------------------------------//
//	Lvl05																										//
//--------------------------------------------------------------------------------------------------------------//
static	int	Lvl05(HAJCPPC pW)
{
	int		n = 0;

	if (pW->FmlSclErr == AJCPPC_ERROR_OK) {
		n = Lvl05s(pW, Lvl04(pW));
	}
	return n;
}
//--------------------------------------------------------------------------------------------------------------//
//	Lvl05s																										//
//--------------------------------------------------------------------------------------------------------------//
static	int	Lvl05s(HAJCPPC pW, int n)
{
	EAJCTKCODE	s;

	while (pW->FmlSclErr == AJCPPC_ERROR_OK  &&  ISLV05(s = pW->pFmlCur->tkn)) {	//	「 ==  != 」
		if (SkipSylAndChkEOL(pW) == EAJCTK_EOF) break;
		switch (s) {
			case EAJCTK_DLM_EQEQ:	n = (n == Lvl04(pW));	break;		//	「 == 」
			case EAJCTK_DLM_NOTEQ:	n = (n != Lvl04(pW));	break;		//	「 != 」
		}
	}
	return n;
}
//--------------------------------------------------------------------------------------------------------------//
//	Lvl04																										//
//--------------------------------------------------------------------------------------------------------------//
static	int	Lvl04(HAJCPPC pW)
{
	int		n = 0;

	if (pW->FmlSclErr == AJCPPC_ERROR_OK) {
		n = Lvl04s(pW, Lvl03(pW));
	}
	return n;
}
//--------------------------------------------------------------------------------------------------------------//
//	Lvl04s																										//
//--------------------------------------------------------------------------------------------------------------//
static	int	Lvl04s(HAJCPPC pW, int n)
{
	EAJCTKCODE	s;

	while (pW->FmlSclErr == AJCPPC_ERROR_OK  &&  ISLV04(s = pW->pFmlCur->tkn)) {	//	「 <   >   <=  >= 」
		if (SkipSylAndChkEOL(pW) == EAJCTK_EOF) break;
		switch (s) {
			case EAJCTK_DLM_LO:		n = (n <  Lvl03(pW));	break;	//	「 <  」
			case EAJCTK_DLM_HI:		n = (n >  Lvl03(pW));	break;	//	「 >  」
			case EAJCTK_DLM_LOEQ:	n = (n <= Lvl03(pW));	break;	//	「 <= 」
			case EAJCTK_DLM_HIEQ:	n = (n >= Lvl03(pW));	break;	//	「 >= 」
		}
	}
	return n;
}
//--------------------------------------------------------------------------------------------------------------//
//	Lvl03																										//
//--------------------------------------------------------------------------------------------------------------//
static	int	Lvl03(HAJCPPC pW)
{
	int		n = 0;

	if (pW->FmlSclErr == AJCPPC_ERROR_OK) {
		n = Lvl03s(pW, Lvl02(pW));
	}
	return n;
}
//--------------------------------------------------------------------------------------------------------------//
//	Lvl03s																										//
//--------------------------------------------------------------------------------------------------------------//
static	int	Lvl03s(HAJCPPC pW, int n)
{
	EAJCTKCODE	s;

	while (pW->FmlSclErr == AJCPPC_ERROR_OK  &&  ISLV03(s = pW->pFmlCur->tkn)) {	//	「 <<  >> 」
		if (SkipSylAndChkEOL(pW) == EAJCTK_EOF) break;
		switch (s) {
			case EAJCTK_DLM_SHL:	n = (n << Lvl02(pW));	break;	//	「 << 」
			case EAJCTK_DLM_SHR:	n = (n >> Lvl02(pW));	break;	//	「 >> 」
		}
	}
	return n;
}
//--------------------------------------------------------------------------------------------------------------//
//	Lvl02																										//
//--------------------------------------------------------------------------------------------------------------//
static	int	Lvl02(HAJCPPC pW)
{
	int		n = 0;

	if (pW->FmlSclErr == AJCPPC_ERROR_OK) {
		n = Lvl02s(pW, Lvl01(pW));
	}
	return n;
}
//--------------------------------------------------------------------------------------------------------------//
//	Lvl02s																										//
//--------------------------------------------------------------------------------------------------------------//
static	int	Lvl02s(HAJCPPC pW, int n)
{
	EAJCTKCODE	s;

	while (pW->FmlSclErr == AJCPPC_ERROR_OK  &&  ISLV02(s = pW->pFmlCur->tkn)) {	//	「 +   - 」
		if (SkipSylAndChkEOL(pW) == EAJCTK_EOF) break;
		switch (s) {
			case EAJCTK_DLM_PLUS:	n = (n + Lvl01(pW));	break;	//	「 + 」
			case EAJCTK_DLM_MINUS:	n = (n - Lvl01(pW));	break;	//	「 - 」
		}
	}
	return n;
}
//--------------------------------------------------------------------------------------------------------------//
//	Lvl01																										//
//--------------------------------------------------------------------------------------------------------------//
static	int	Lvl01(HAJCPPC pW)
{
	int	n = 0;

	if (pW->FmlSclErr == AJCPPC_ERROR_OK) {
		n = Lvl01s(pW, part(pW));
	}
	return n;
}
//--------------------------------------------------------------------------------------------------------------//
//	Lvl01s																										//
//--------------------------------------------------------------------------------------------------------------//
static	int	Lvl01s(HAJCPPC pW, int n)
{
	EAJCTKCODE	s;
	int			p;

	while (pW->FmlSclErr == AJCPPC_ERROR_OK  &&  ISLV01(s = pW->pFmlCur->tkn)) {	//	「 *   /   % 」
		if (SkipSylAndChkEOL(pW) == EAJCTK_EOF) break;
		p = part(pW);
		switch (s) {
			case EAJCTK_DLM_MULT:	n = (n * p);
									break;

			case EAJCTK_DLM_DIV:	if (p) n = (n / p);
									else if (!pW->nstDmyRgtInLAndLOr) {		//	「&&」の右側ダミー演算中はゼロ除算を無視する
										pW->FmlSclErr = AJCPPC_SCLERR_DIVZERO;
										PPC_ERR(pW->FmlSclErr, pW->pFmlCur->pFile, pW->pFmlCur->lno, 0);
									}
									break;

			case EAJCTK_DLM_MOD:	if (p) n = (n % p);
									else if (!pW->nstDmyRgtInLAndLOr) {		//	「&&」の右側ダミー演算中はゼロ除算を無視する
										pW->FmlSclErr = AJCPPC_SCLERR_DIVZERO;
										PPC_ERR(pW->FmlSclErr, pW->pFmlCur->pFile, pW->pFmlCur->lno, 0);
									}
									break;
		}
	}
	return n;
}
//--------------------------------------------------------------------------------------------------------------//
//	P A R T																										//
//--------------------------------------------------------------------------------------------------------------//
static	int	part(HAJCPPC pW)
{
	int		n = 0;

	do {
		if (pW->FmlSclErr) break;								//	エラーならば中止

		if		(pW->pFmlCur->tkn == EAJCTK_DLM_LSPART) {		//	●左カッコ
			if (SkipSylAndChkEOL(pW) == EAJCTK_EOF) break;		//		語句スキップ
			n = express(pW);									//		演算実行
			if (pW->FmlSclErr) break;							//		エラーならば中止
			if (pW->pFmlCur->tkn == EAJCTK_DLM_RSPART) {		//		右カッコ？
				if (SkipSyl(pW) == EAJCTK_EOF) break;			//			語句スキップ
			}
			else {												//		右カッコでない？
				pW->FmlSclErr = AJCPPC_SCLERR_NOTCLS;			//			エラー
				PPC_ERR(pW->FmlSclErr, pW->pFmlCur->pFile, pW->pFmlCur->lno, 0);
			}
		}
		else if (pW->pFmlCur->tkn == EAJCTK_DLM_PLUS	||		//	●単項演算子（+-~!）
				 pW->pFmlCur->tkn == EAJCTK_DLM_MINUS	||		//
				 pW->pFmlCur->tkn == EAJCTK_DLM_NOT	||			//
				 pW->pFmlCur->tkn == EAJCTK_DLM_LNOT) {			//

			EAJCTKCODE	s = pW->pFmlCur->tkn;					//		単項演算子退避

			if (SkipSylAndChkEOL(pW) == EAJCTK_EOF) break;		//		語句スキップ
			n = part(pW);										//		値を得る
			if (pW->FmlSclErr) break;							//		エラーならば中止
			switch (s) {										//		単項演算実行
				case EAJCTK_DLM_MINUS:	n = ~n + 1;	break;		//		・
				case EAJCTK_DLM_NOT:	n = ~n;		break;		//		・
				case EAJCTK_DLM_LNOT:	n = !n;		break;		//		・
			}
		}
		else if (pW->pFmlCur->tkn == EAJCTK_VAL_DECIMAL ||		//	●定数（１０進／１６進）
				 pW->pFmlCur->tkn == EAJCTK_VAL_HEXA) {			//		・
			n = (int)AjcAscToIntA(pW->pFmlCur->pSyl);			//		定数値設定
			if (SkipSyl(pW) == EAJCTK_EOF) break;				//		語句スキップ
		}
		else if (pW->pFmlCur->tkn == EAJCTK_VAL_OCTAL) {		//	●定数（８進）
			n = (int)AjcOctToUIA(pW->pFmlCur->pSyl);			//		定数値設定
			if (SkipSyl(pW) == EAJCTK_EOF) break;				//		語句スキップ
		}
		else if (pW->pFmlCur->tkn == EAJCTK_VAL_REAL) {			//	●定数（実数）
			n = (int)AjcAscToRealA(pW->pFmlCur->pSyl);			//		定数値設定
			if (SkipSyl(pW) == EAJCTK_EOF) break;				//		語句スキップ
		}
		else {													//	●その他
			if (pW->pFmlCur->tkn == EAJCTK_USR_NAME) {			//		シンボル？
				if (pW->nstDmyRgtInLAndLOr) {					//			「&&」の右側ダミー演算中？
					n = 1;										//				仮の値(1)を返す
					if (SkipSyl(pW) == EAJCTK_EOF) break;		//				語句スキップ
				}
				else {											//			通常の演算中？
					pW->FmlSclErr = AJCPPC_SCLERR_INVSYL;		//				エラー
					PPC_ERR(pW->FmlSclErr, pW->pFmlCur->pFile, pW->pFmlCur->lno, pW->pFmlCur->pSyl);
				}
			}
			else {												//		シンボル以外？
				pW->FmlSclErr = AJCPPC_SCLERR_INVSYL;			//			エラー
				PPC_ERR(pW->FmlSclErr, pW->pFmlCur->pFile, pW->pFmlCur->lno, pW->pFmlCur->pSyl);
			}
		}
	} while(0);
	return n;
}

/*--------------------------------------------------------------------------------------------------------------*/
/*	語句をスキップしＥＯＬチェック（ＥＯＬならばエラー）														*/
/*--------------------------------------------------------------------------------------------------------------*/
static	EAJCTKCODE	SkipSylAndChkEOL(HAJCPPC pW)
{
	EAJCTKCODE	rc;

	if ((rc = SkipSyl(pW)) == EAJCTK_EOF) {					//	スキップ後の語句はＥＯＬ？
		pW->FmlSclErr = AJCPPC_SCLERR_EOL;					//	エラー（数式が途中で終了）
		PPC_ERR(pW->FmlSclErr, pW->pFmlCur->pFile, pW->pFmlCur->lno, 0);
	}
	return rc;
}
/*--------------------------------------------------------------------------------------------------------------*/
/*	語句スキップ																								*/
/*--------------------------------------------------------------------------------------------------------------*/
static	EAJCTKCODE	SkipSyl(HAJCPPC pW)
{
	EAJCTKCODE	rc;

	//	次の語句があれば、次のノードアドレスを設定し、当該トークンコードを返す
	if (pW->pFmlCur->pNxt != NULL) {
		pW->pFmlCur = pW->pFmlCur->pNxt;
		rc = (EAJCTKCODE)pW->pFmlCur->tkn;
	}
	//	次の語句が無い場合、ダミーのトークンノード（行末）を作成し、「EAJCTK_EOF」を返す
	else {
		memcpy(&pW->FmlEolNode, pW->pFmlCur, sizeof(AJCPPCTKNNODE));
		pW->FmlEolNode.pNxt = &pW->FmlEolNode;
		pW->FmlEolNode.tkn	= (UW)EAJCTK_EOF;
		pW->FmlEolNode.pSyl = "<EOL>";
		pW->pFmlCur = &pW->FmlEolNode;
		rc = EAJCTK_EOF;
	}
	return rc;
}
