﻿//
//	AjcPpGsr.c
//
#include	"AjcInternal.h"
#include	"AjcPp.h"

//==============================================================================================================//
//	次のトークンスペースを割り当ててリンクする																	//
//																												//
//	引　数	：	pCur	- 現在のトークンノード																	//
//																												//
//	戻り値	：	次のトークンスペースのアドレス																	//
//==============================================================================================================//
PAJCPPCTKNNODE	PpcAllocAndLinkNextToken(HAJCPPC pW, PAJCPPCTKNNODE pCur)
{
	PAJCPPCTKNNODE	rc = NULL;

	if (pCur != NULL) {
		rc = pCur->pNxt = PpcTknAlloc(pW);
	}
	return rc;
}
//==============================================================================================================//
//	現在のトークンスペースを解放し、次のトークンノードアドレスを取得する										//
//																												//
//	引　数	：	pCur	- 現在のトークンノード																	//
//																												//
//	戻り値	：	次のトークン・ノードのアドレス																	//
//==============================================================================================================//
PAJCPPCTKNNODE	PpcRelCurAndGetNextToken(HAJCPPC pW, PAJCPPCTKNNODE pCur)
{
	PAJCPPCTKNNODE	rc = NULL;

	if (pCur != NULL) {
		rc = pCur->pNxt;
		PpcTknFree(pW, pCur);
	}
	return rc;
}
//==============================================================================================================//
//	トークン・ストリームの解放																					//
//																												//
//	引　数	：	pTop	- 先頭トークンノード																	//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
VO			PpcRelTokenStream(HAJCPPC pW, PAJCPPCTKNNODE pTop)
{
	PAJCPPCTKNNODE	pCur = pTop;

	while (pCur != NULL) {
		pCur = PpcRelCurAndGetNextToken(pW, pCur);
	}
}
//==============================================================================================================//
//	トークン情報の設定																							//
//																												//
//	引　数	：	pTkn	- トークンノードのアドレス																//
//				pFile	- ファイルパス名のアドレス																//
//				hCtk	- 字句分解インスタンスハンドル															//
//				pSyl	- 語句文字列のアドレス																	//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
BOOL		PpcSetTokenNode(HAJCPPC pW, PAJCPPCTKNNODE pTkn, C_BCP pFile, HAJCTK hCtk, C_BCP pSyl)
{
	BOOL	rc = FALSE;

	if (pTkn->pFile  = PpcIStrRegist(pW, pFile)) {
		if (pTkn->pSyl	 = PpcNStrRegist(pW, pSyl)) {
			pTkn->tkn	 = AJCTK_TOKEN(hCtk);
			pTkn->kndPP  = AJCPPC_PPK_TOKEN;
			pTkn->lno	 = AJCTK_LINE(hCtk);
			pTkn->pos	 = AJCTK_POS (hCtk, 4);
			pTkn->ppIf	 = 0;
			pTkn->flg	 = AJCTK_FLAG(hCtk);
			pTkn->inst	 = 0;
			pTkn->incf	 = AJCPPC_INCF_NO;
			pTkn->mexp	 = 0;
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	トークン情報の設定(#include内）																				//
//																												//
//	引　数	：	pTkn	- トークンノードのアドレス																//
//				pFile	- ファイルパス名のアドレス																//
//				hCtk	- 字句分解インスタンスハンドル															//
//				pSyl	- 語句文字列のアドレス																	//
//				nest	- #includeネストレベル																	//
//				incf	- #include種別																			//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
BOOL		PpcSetTokenNodeByInc(HAJCPPC pW, PAJCPPCTKNNODE pTkn, C_BCP pFile, HAJCTK hCtk, C_BCP pSyl, UI nest, UI incf)
{
	BOOL	rc = FALSE;

	if (pTkn->pFile  = PpcIStrRegist(pW, pFile)) {
		if (pTkn->pSyl	 = PpcNStrRegist(pW, pSyl)) {
			pTkn->tkn	 = AJCTK_TOKEN(hCtk);
			pTkn->kndPP  = AJCPPC_PPK_TOKEN;
			pTkn->lno	 = AJCTK_LINE(hCtk);
			pTkn->pos	 = AJCTK_POS (hCtk, 4);
			pTkn->ppIf	 = 0;
			pTkn->flg	 = AJCTK_FLAG(hCtk);
			pTkn->inst	 = (UB)nest;
			pTkn->incf	 = (UB)incf;
			pTkn->mexp	 = 0;
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	トークンストリームの比較																					//
//																												//
//	引　数	：	pTkn	- 先頭トークンノードのアドレス															//
//				pOut	- 出力ファイルパス																		//
//																												//
//	戻り値	：	TRUE  - 一致																					//
//				FALSE - 不一致																					//
//==============================================================================================================//
BOOL		PpcCompTokenStream(HAJCPPC pW, PAJCPPCTKNNODE p1, PAJCPPCTKNNODE p2)
{
	BOOL	rc = FALSE;

	while (p1 != NULL && p2 != NULL) {
		if (mbscmp(p1->pSyl, p2->pSyl) == 0) {
			p1 = p1->pNxt;
			p2 = p2->pNxt;
		}
		else {
			break;
		}
	}
	if (p1 == NULL && p2 == NULL) {
		rc = TRUE;
	}

	return rc;
}
//==============================================================================================================//
//	Ｃ言語字句分解インスタンス生成（割り当て失敗時は処理中止）													//
//																												//
//	引　数	：	pCallBack	- コールバック関数																	//
//																												//
//	戻り値	：	Ｃ言語字句分解インスタンス																		//
//==============================================================================================================//
HAJCTK	PpcCtkCreate(HAJCPPC pW, PCBAJCTKA pCallBack)
{
	HAJCTK	rc = NULL;

	if ((rc = AjcCtkCreateA(AJCTKFLG_INCSYM_DOLLAR, pCallBack, (UX)pW)) == NULL) {
		pW->fMemErr = TRUE;
		PPC_ERR(AJCPPC_ERROR_MEMALLOC, 0, 0, 0);
	}
	return rc;
}
//==============================================================================================================//
//	メモリ割り当て																								//
//																												//
//	引　数	：	size	- 割り当てるメモリのバイト数															//
//																												//
//	戻り値	：	割り当てたメモリのアドレス																		//
//==============================================================================================================//
VOP		PpcMemAlloc(HAJCPPC pW, UI size)
{
	VOP		rc = NULL;

	if ((rc = AJCMEM(size)) != NULL) {
		memset(rc, 0, size);
	}
	else {
		pW->fMemErr = TRUE;
		PPC_ERR(AJCPPC_ERROR_MEMALLOC, 0, 0, 0);
	}

	return rc;
}
//==============================================================================================================//
//	メモリ解放																									//
//																												//
//	引　数	：	pMem	- 解放するメモリブロックのアドレス														//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
VO		PpcMemFree(HAJCPPC pW, VOP pMem)
{
	if (pMem != NULL) {
		free(pMem);
	}
}
//==============================================================================================================//
//	トークンメモリ割り当て（割り当て失敗時は処理中止）															//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	割り当てたトークンメモリのアドレス																//
//==============================================================================================================//
PAJCPPCTKNNODE	PpcTknAlloc(HAJCPPC pW)
{
	VOP		rc = NULL;

	if ((rc = PpcMemAlloc(pW, sizeof(AJCPPCTKNNODE))) != NULL) {
		memset(rc, 0, sizeof(AJCPPCTKNNODE));
	}

	return rc;
}
//==============================================================================================================//
//	トークンメモリ解放																							//
//																												//
//	引　数	：	pMem	- 解放するメモリブロックのアドレス														//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
VO		PpcTknFree(HAJCPPC pW, PAJCPPCTKNNODE pTkn)
{
	if (pTkn != NULL) {
		free(pTkn);
	}
}
//==============================================================================================================//
//	語句間の空白挿入判定																						//
//																												//
//	引　数	：	pBfr	- １つ前のトークンノードポインタ														//
//																												//
//	戻り値	：	TRUE  - 空白挿入要																				//
//				FALSE - 空白挿入不要																			//
//==============================================================================================================//
BOOL		PpcNeedSpace(PCAJCPPCTKNNODE pBfr)
{
	BOOL			rc = FALSE;
	PCAJCPPCTKNNODE	pCur;

	if (pBfr != NULL) {
		pCur = pBfr->pNxt;
		//	直言と現在がシンボルか数値定数ならば無条件に空白を挿入
		if (AJCTKIS_VALSYM(pBfr->tkn) && AJCTKIS_VALSYM(pCur->tkn)) {
			rc = TRUE;
		}
		//	上記以外ならば、原文に準ずる
		else {
			rc = ((pBfr->flg & AJCTKF_NXTSPC) != 0);
		}
	}

	return rc;
}
