﻿//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	Ｃ言語プリコンパイル	ＭＳＩＬ用サポートコード															//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
#include	"AjcInternal.h"
#include	"AjcPp.h"

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
__declspec(thread) static AJCPPCERROR	TlsErr;
__declspec(thread) static UX			TlsP1;
__declspec(thread) static UX			TlsP2;
__declspec(thread) static UX			TlsP3;


//--------------------------------------------------------------------------------------------------------------//
//																												//
//	バイト文字→ワード文字に変換して文字列プールへ格納															//
//																												//
//--------------------------------------------------------------------------------------------------------------//
#define		WIDE(X)		ConvertToWideChar(pW, (UX)X)
//--------------------------------------------------------------------------------------------------------------//
static	C_WCP		ConvertToWideChar(HAJCPPC pW, UX prm)
{
	C_WCP	rc	 = L"";
	WCP		pTmp = NULL;
	BCP		pDat = (BCP)prm;

	if (pDat == NULL) {
		rc = AjcSplRegistW(pW->hSplMSIL, L"");
	}
	else {
		UI len;
		if (len = AjcByteCharToWideChar(pDat, NULL, 0)) {
			if (pTmp = (WCP)AJCMEM(len * 2)) {
				AjcByteCharToWideChar(pDat, pTmp, len);
				rc = AjcSplRegistW(pW->hSplMSIL, pTmp);
				free(pTmp);
			}
		}
	}
	return rc;
}

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	イベント通知																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	VO CALLBACK cbMyNtc(AJCPPCNOTIFY ntc, UX p1, UX p2, UX p3, UX cbp)
{
	HAJCPPC pW = (HAJCPPC)cbp;
	PAJCPPCTKNNODE pTkn;
	PAJCPPCMACINFO pMac;

	switch (ntc) {
		//	●いずれかのイベント発生通知
		case AJCPPC_NTC_ANYEVT:
			if (pW->cbNtcAnyEvt != NULL) {
				if (p1 != AJCPPC_NTC_TOKEN) {	//	MSILの場合、AJCPPC_NTC_TOKENは除外
					pW->cbNtcAnyEvt	(ntc);												//	通知コード（イベント識別）
				}
			}
			break;

			//	●現在処理中のファイル名，行番号通知
		case AJCPPC_NTC_FILE_LNO:
			if (pW->cbNtcFileLno != NULL) {
				pW->cbNtcFileLno	(WIDE(p1), (UI)p2, (UI)p3);							//	ファイル名，行番号，ネスト
			}
			break;

		//	●インクルードファイル検索開始通知
		case AJCPPC_NTC_SRH_START:
			AjcByteCharToWideChar((C_BCP)p1, pW->SvIncName, MAX_PATH);
			if (pW->cbNtcSrhStart != NULL) {
				pW->cbNtcSrhStart	(WIDE(p1), WIDE(p2));								//	ＩＮＣ名，検索開始フォルダパス
			}
			break;

		//	●インクルードファイル検索中のフォルダ通知
		case AJCPPC_NTC_SRH_DIR:
			if (pW->cbNtcSrhDir != NULL) {
				pW->cbNtcSrhDir		(pW->SvIncName, WIDE(p1));							//	ＩＮＣ名，検索フォルダパス
			}
			break;

		//	●インクルードファイル検索終了通知
		case AJCPPC_NTC_SRH_END:
			if (pW->cbNtcSrhEnd != NULL) {
				pW->cbNtcSrhEnd		(WIDE(p1), (BOOL)p2);								//	ＩＮＣ名，検索結果
			}
			break;

		case AJCPPC_NTC_OPTSYM:
			if (pW->cbNtcOptSym != NULL) {
				pTkn = (PAJCPPCTKNNODE)p1;
				pW->cbNtcOptSym		(WIDE(pTkn->pFile), pTkn->lno, WIDE(pTkn->pSyl));	//	ファイルパス，行番号，シンボル
			}
			break;

		//	●マクロ定義通知
		case AJCPPC_NTC_MACDEF:
			if (pW->cbNtcMacDef != NULL) {
				pTkn = (PAJCPPCTKNNODE)p1;
				pMac = (PAJCPPCMACINFO)p2;
				pW->cbNtcMacDef	(WIDE(pTkn->pFile), pTkn->lno, WIDE(pMac->pMacName));	//	ファイルパス，行番号，マクロ名
			}
			break;

		//	●マクロ参照通知
		case AJCPPC_NTC_MACREF:
			if (pW->cbNtcMacRef != NULL) {
				pTkn = (PAJCPPCTKNNODE)p1;
				pMac = (PAJCPPCMACINFO)p2;
				pW->cbNtcMacRef	(WIDE(pTkn->pFile), pTkn->lno, WIDE(pMac->pMacName));	//	ファイルパス，行番号，マクロ名
			}
			break;

		//	●ファイル出力中通知
		case AJCPPC_NTC_OUTLOOP:
			if (pW->cbNtcOutput != NULL) {
				pW->cbNtcOutput	();
			}
			break;

		//	●ソースファイルエンコード通知
		case AJCPPC_NTC_SRCTEC:
			if (pW->cbNtcSrcTec != NULL) {
				pW->cbNtcSrcTec(WIDE(p1), (EAJCTEC)p2, (BOOL)p3);
			}
			break;

		//	●ソースから読み出したトークン通知（未使用）
		case AJCPPC_NTC_TOKEN:
		//	if (pW->cbNtcToken != NULL) {
		//		pW->cbNtcToken		((UI)p1, WIDE(p2));									//	トークンコード，トークン名
		//	}
			break;

	}
}

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	エラー通知																									//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	VO CALLBACK cbMyErr(AJCPPCERROR  err, UX p1, UX p2, UX p3, UX cbp)
{
	HAJCPPC pW = (HAJCPPC)cbp;

	//	エラー情報退避
	TlsErr = err;
	TlsP1  = p1;
	TlsP2  = p2;
	TlsP3  = p3;

	if (pW->cbNtcError != NULL) {
		pW->cbNtcError(err, WIDE(p1), (UI)p2, WIDE(p3));
	}
}

//==============================================================================================================//
//	インスタンス生成																							//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	≠NULL : 正常（インスタンスハンドル）															//
//				＝NULL : エラー																					//
//==============================================================================================================//
AJCEXPORT	HAJCPPC		WINAPI	AjcPpcCreateForMSIL(VO)
{
	HAJCPPC		pW = NULL;
	if (pW = AjcPpcCreate(NULL, NULL, NULL, 0, cbMyNtc, cbMyErr)) {
		pW->hSplMSIL = AjcSplCreateW(AJCCMP_IGNORE_WIDTH);
		pW->cbp 	 = (UX)pW;
	}
	return pW;
}

//==============================================================================================================//
//	インスタンス消去																							//
//																												//
//	引　数	：	pW		  - インスタンスハンドル																//
//																												//
//	戻り値	：	TRUE  : 正常																					//
//				FALSE : エラー																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcPpcDeleteForMSIL(HAJCPPC pW)
{
	BOOL	rc = FALSE;
	if (IS_PP_INST(pW)) {
		if (pW->hSplMSIL != NULL) AjcSplDelete(pW->hSplMSIL);
		AjcPpcDelete(pW);
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	プリプロセス・コンパイル																					//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pSrcPath	- ソースプログラムパス																//
//																												//
//	戻り値	：	＝AJCPPCR_OK : ＯＫ																				//
//				≠AJCPPCR_OK : トークンが１つも無い／エラー														//
//==============================================================================================================//
AJCEXPORT	AJCPPCRESULT	WINAPI	AjcPpcCompileForMSIL(HAJCPPC pW, C_WCP pSrcPath)
{
	AJCPPCRESULT	rc;
	BC				SrcPath[MAX_PATH];

	AjcWideCharToByteChar(pSrcPath, SrcPath, MAX_PATH);
	rc = AjcPpcCompile(pW, SrcPath);
	return rc;
}
//==============================================================================================================//
//	トークンストリームのファイル出力																			//
//																												//
//	引　数	：	pOut	- 出力ファイルパス																		//
//				fExpInc	- TRUE : インクルードした内容を展開する													//
//						  FALSE: #include分をそのまま残す（インクルードした内容は展開しない）					//
//				CommOutOfkndPP - コメント出力するプリプロセス文を指定する（AJCPPC_PPK_XXXXX）					//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcPpcTokenStreamToFileForMSIL(HAJCPPC pW, C_WCP pOut, BOOL fExpInc, UI CommOutOfkndPP)
{
	BOOL	rc;
	BC		OutPath[MAX_PATH];

	AjcWideCharToByteChar(pOut, OutPath, MAX_PATH);
	rc = AjcPpcTokenStreamToFile(pW, OutPath, fExpInc, CommOutOfkndPP);
	return rc;

}
//==============================================================================================================//
//	ベースパス設定																								//
//																												//
//	引　数	：	pW		  - インスタンスハンドル																//
//				pBasePath - ベースパスへのポインタ																//
//																												//
//	戻り値	：	TRUE  : 正常																					//
//				FALSE : エラー																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcPpcSetBasePath(HAJCPPC pW, C_WCP pBasePath)
{
	BOOL	rc = FALSE;

	if (IS_PP_INST(pW)) {
		if (pBasePath != NULL) {
			WideCharToMultiByte(CP_ACP, 0, pBasePath, -1, pW->BasePath, MAX_PATH, NULL, NULL);
		}
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	インクルードパス リセット																					//
//																												//
//	引　数	：	pW		  - インスタンスハンドル																//
//																												//
//	戻り値	：	TRUE  : 正常																					//
//				FALSE : エラー																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcPpcIncPathReset(HAJCPPC pW)
{
	BOOL	rc = FALSE;

	if (IS_PP_INST(pW)) {
		//	インクルードパス群解放
		if (pW->pIncArr != NULL) {
			PAJCLBXITEMA	p = pW->pIncArr;
			while (p->pStr != NULL) {
				free(p->pStr);
				p++;
			}
			free(pW->pIncArr);
			pW->pIncArr = NULL;
		}
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	インクルードパス テーブル生成																				//
//																												//
//	引　数	：	pW		  - インスタンスハンドル																//
//				n		  - エントリ数																			//
//																												//
//	戻り値	：	TRUE  : 正常																					//
//				FALSE : エラー																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcPpcIncPathCreate(HAJCPPC pW, UI n)
{
	BOOL	rc = FALSE;

	if (IS_PP_INST(pW)) {
		if (pW->pIncArr = AJCMEM(sizeof(AJCLBXITEMA) * (n + 1))) {
			memset(pW->pIncArr, 0, sizeof(AJCLBXITEMA) * (n + 1));
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	インクルードパス テーブルエントリ設定																		//
//																												//
//	引　数	：	pW		  - インスタンスハンドル																//
//				ix		  - エントリインデクス																	//
//				pIncPath  - インクルードパスへのポインタ														//
//																												//
//	戻り値	：	TRUE  : 正常																					//
//				FALSE : エラー																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcPpcIncPathSet(HAJCPPC pW, UI ix, C_WCP pIncPath)
{
	BOOL	rc = FALSE;
	UI		len;

	if (IS_PP_INST(pW)) {
		if (pW->pIncArr != NULL) {
			if (pIncPath != NULL) {
				len = WideCharToMultiByte(CP_ACP, 0, pIncPath, -1, NULL, 0, NULL, NULL);
				if (len != 0 && (pW->pIncArr[ix].pStr = (BCP)AJCMEM(len))) {
					WideCharToMultiByte(CP_ACP, 0, pIncPath, -1, pW->pIncArr[ix].pStr, len, NULL, NULL);
					rc = TRUE;
				}
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	オプションシンボル リセット																					//
//																												//
//	引　数	：	pW		  - インスタンスハンドル																//
//																												//
//	戻り値	：	TRUE  : 正常																					//
//				FALSE : エラー																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcPpcOptSymReset(HAJCPPC pW)
{
	BOOL	rc = FALSE;

	if (IS_PP_INST(pW)) {
		//	オプションシンボル群解放
		if (pW->pOptArr != NULL) {
			PAJCLBXITEMA	p = pW->pOptArr;
			while (p->pStr != NULL) {
				free(p->pStr);
				p++;
			}
			free(pW->pOptArr);
			pW->pOptArr = NULL;
		}
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	オプションシンボル テーブル生成																				//
//																												//
//	引　数	：	pW		  - インスタンスハンドル																//
//				n		　- エントリ数																			//
//																												//
//	戻り値	：	TRUE  : 正常																					//
//				FALSE : エラー																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcPpcOptSymCreate(HAJCPPC pW, UI n)
{
	BOOL	rc = FALSE;

	if (IS_PP_INST(pW)) {
		if (pW->pOptArr = AJCMEM(sizeof(AJCLBXITEMA) * (n + 1))) {
			memset(pW->pOptArr, 0, sizeof(AJCLBXITEMA) * (n + 1));
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	オプションシンボル テーブルエントリ設定																		//
//																												//
//	引　数	：	pW		  - インスタンスハンドル																//
//				ix		  - エントリインデクス																	//
//				pOptSym  - オプションシンボルへのポインタ														//
//																												//
//	戻り値	：	TRUE  : 正常																					//
//				FALSE : エラー																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcPpcOptSymSet(HAJCPPC pW, UI ix, C_WCP pOptSym)
{
	BOOL	rc = FALSE;
	UI		len;

	if (IS_PP_INST(pW)) {
		if (pW->pOptArr != NULL) {
			if (pOptSym != NULL) {
				len = WideCharToMultiByte(CP_ACP, 0, pOptSym, -1, NULL, 0, NULL, NULL);
				if (len != 0 && (pW->pOptArr[ix].pStr = (BCP)AJCMEM(len))) {
					WideCharToMultiByte(CP_ACP, 0, pOptSym, -1, pW->pOptArr[ix].pStr, len, NULL, NULL);
					rc = TRUE;
				}
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	コールバック設定																							//
//																												//
//	引　数	：	pW		  - インスタンスハンドル																//
//				ix		  - エントリインデクス																	//
//				pOptSym  - オプションシンボルへのポインタ														//
//																												//
//	戻り値	：	TRUE  : 正常																					//
//				FALSE : エラー																					//
//==============================================================================================================//
AJCEXPORT	VO WINAPI	AjcPpcSetCbNtcAnyEvt	(HAJCPPC pW, VO (CALLBACK *cbNtcAnyEvt	)(AJCPPCNOTIFY ntc						 )) {pW->cbNtcAnyEvt   = cbNtcAnyEvt;  }
AJCEXPORT	VO WINAPI	AjcPpcSetCbNtcFileLno	(HAJCPPC pW, VO (CALLBACK *cbNtcFileLno	)(C_WCP pFileName, UI lno, UI nest		 )) {pW->cbNtcFileLno  = cbNtcFileLno; }
AJCEXPORT	VO WINAPI	AjcPpcSetCbNtcSrhStart	(HAJCPPC pW, VO (CALLBACK *cbNtcSrhStart)(C_WCP pIncName , C_WCP pSrhPath		 )) {pW->cbNtcSrhStart = cbNtcSrhStart;}
AJCEXPORT	VO WINAPI	AjcPpcSetCbNtcSrhDir	(HAJCPPC pW, VO (CALLBACK *cbNtcSrhDir	)(C_WCP pIncName , C_WCP pSrhDir		 )) {pW->cbNtcSrhDir   = cbNtcSrhDir;  }
AJCEXPORT	VO WINAPI	AjcPpcSetCbNtcSrhEnd	(HAJCPPC pW, VO (CALLBACK *cbNtcSrhEnd	)(C_WCP pIncName , BOOL  fFind			 )) {pW->cbNtcSrhEnd   = cbNtcSrhEnd;  }
AJCEXPORT	VO WINAPI	AjcPpcSetCbNtcOptSym	(HAJCPPC pW, VO (CALLBACK *cbNtcOptSym	)(C_WCP pFilePath, UI lno, C_WCP pSyl	 )) {pW->cbNtcOptSym   = cbNtcOptSym;  }
AJCEXPORT	VO WINAPI	AjcPpcSetCbNtcMacDef	(HAJCPPC pW, VO (CALLBACK *cbNtcMacDef	)(C_WCP pFilePath, UI lno, C_WCP pMac	 )) {pW->cbNtcMacDef   = cbNtcMacDef;  }
AJCEXPORT	VO WINAPI	AjcPpcSetCbNtcMacRef	(HAJCPPC pW, VO (CALLBACK *cbNtcMacRef	)(C_WCP pFilePath, UI lno, C_WCP pMac	 )) {pW->cbNtcMacRef   = cbNtcMacRef;  }
AJCEXPORT	VO WINAPI	AjcPpcSetCbNtcOutput	(HAJCPPC pW, VO (CALLBACK *cbNtcOutput	)(VO		 							 )) {pW->cbNtcOutput   = cbNtcOutput;  }
AJCEXPORT	VO WINAPI	AjcPpcSetCbNtcSrcTec	(HAJCPPC pW, VO (CALLBACK *cbNtcSrcTec	)(C_WCP pFilePath, EAJCTEC tec, BOOL fBOM)) {pW->cbNtcSrcTec   = cbNtcSrcTec;  }
AJCEXPORT	VO WINAPI	AjcPpcSetCbNtcError		(HAJCPPC pW, VO (CALLBACK *cbNtcError	)(AJCPPCERROR err, C_WCP p1, UI p2, C_WCP p3)){pW->cbNtcError  = cbNtcError;   }

//==============================================================================================================//
//	エラーメッセージテキスト取得																				//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//																												//
//	戻り値	：	エラーメッセージテキスト																		//
//==============================================================================================================//
AJCEXPORT	VO	WINAPI	AjcPpcGetErrMsgTextForMSIL(WCP pBuf, UI lBuf)
{
	if (pBuf != NULL && lBuf > 0) {
		MultiByteToWideChar(CP_ACP, 0, AjcPpcGetErrMsgText(TlsErr, TlsP1, TlsP2, TlsP3), -1, pBuf, lBuf);
		pBuf[lBuf - 1] = 0;
	}
}

