﻿#include	"AjcInternal.h"

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
static	VO			SubInitPrn		 (HAJCPRN pW);
static	BOOL		SubPrnSelect(HAJCPRN pW, PAJCPRN_INFO pInfo, PAJCPRN_OPT pOpt, HWND hWndOwner);

static	BOOL		CreDcAndSetPrinterInfo	(HAJCPRN pW, PAJCPRN_MARGIN pmmMrg);
static	BOOL		SubSetPrinterInfo		(HAJCPRN pW, PAJCPRN_MARGIN pmmMrg, HDC hdc, LPDEVMODE pDevMode);

//==============================================================================================================//
//	インスタンス生成																							//
//																												//
//	引　数	：	hWndOwner	- オーナーウインドハンドル															//
//				cbp			- コールバックパラメタ																//
//																												//
//	戻り値	：	≠ＮＵＬＬ：ＯＫ（インスタンスハンドル（＝インスタンスワークアドレス））						//
//				＝ＮＵＬＬ：エラー																				//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT HAJCPRN WINAPI AjcPrnCreateA(VO)
{
	HAJCPRN	pW;

	if ((pW = (HAJCPRN)AJCMEM(sizeof(AJCPRN))) != NULL) {
		memset(pW, 0, sizeof(AJCPRN));
		SubInitPrn(pW);
		pW->fUnicode = FALSE;
	}

	return pW;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT HAJCPRN WINAPI AjcPrnCreateW(VO)
{
	HAJCPRN	pW;

	if ((pW = (HAJCPRN)AJCMEM(sizeof(AJCPRN))) != NULL) {
		memset(pW, 0, sizeof(AJCPRN));
		SubInitPrn(pW);
		pW->fUnicode = TRUE;
	}

	return pW;
}
//--------------------------------------------------------------------------------------------------------------//
static	VO	SubInitPrn(HAJCPRN pW)
{
	AJCPRN_MARGIN	mrg;

	//----- デフォルトプリンタ設定 ---------------------------------------------------------//
	memset(&mrg, 0, sizeof mrg);
	SubPrnSelect(pW, NULL, NULL, NULL);

}
//==============================================================================================================//
//	コールバックパラメタ設定																					//
//																												//
//	引　数	：	pW					- インスタンスハンドル														//
//				cbp					- コールバックパラメタ														//
//																												//
//	戻り値	：	TRUE ：ＯＫ																						//
//				FALSE：エラー																					//
//==============================================================================================================//
AJCEXPORT	BOOL			WINAPI	AjcPrnSetCallbackParam(HAJCPRN pW, UX cbp)
{
	BOOL	rc = FALSE;

	if (pW != NULL) {
		pW->cbp = cbp;
	}
	return rc;
}

//==============================================================================================================//
//	ページ印刷開始コールバック設定																				//
//																												//
//	引　数	：	pW					- インスタンスハンドル														//
//				cbQueryPage			- ページ印刷開始を通知するコールバック関数									//
//																												//
//	戻り値	：	TRUE ：ＯＫ																						//
//				FALSE：エラー																					//
//==============================================================================================================//
AJCEXPORT	BOOL			WINAPI	AjcPrnSetCallbackQueryPage(HAJCPRN pW, 
								BOOL (CALLBACK *cbQueryPage)(PCAJCPRN_INFO pPrnInfo, PAJCPRN_PGINFO pPageInfo, UX cbp))
{
	BOOL	rc = FALSE;

	if (pW != NULL) {
		pW->cbQueryPage = cbQueryPage;
	}
	return rc;
}
//==============================================================================================================//
//	ＤＩＢセクション・ビットマップによる描画コールバック設定													//
//																												//
//	引　数	：	pW					- インスタンスハンドル														//
//				cbDrawByPrinterDC	- ＤＩＢセクション・ビットマップによる描画コールバック関数					//
//																												//
//	戻り値	：	TRUE ：ＯＫ																						//
//				FALSE：エラー																					//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcPrnSetCallbackByDibSect(HAJCPRN pW,
						 		BOOL (CALLBACK *cbDrawByDibSectDC)(HDC hdc, PCAJCPRN_INFO pPrnInfo, PCAJCDIBINFO pDibInfo, UX cbp))
{
	BOOL	rc = FALSE;

	if (pW != NULL) {
		pW->cbDrawPrn = NULL;
		pW->cbDrawDib = cbDrawByDibSectDC;
	}
	return rc;
}
//==============================================================================================================//
//	プリンタＤＣによる描画コールバック設定																		//
//																												//
//	引　数	：	pW					- インスタンスハンドル														//
//				cbDrawByPrinterDC	- プリンタＤＣによる描画コールバック関数									//
//																												//
//	戻り値	：	TRUE ：ＯＫ																						//
//				FALSE：エラー																					//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcPrnSetCallbackByPrinter(HAJCPRN pW,
								 BOOL (CALLBACK *cbDrawByPrinterDC)(HDC hdc, PCAJCPRN_INFO pPrnInfo, UX cbp))
{
	BOOL	rc = FALSE;

	if (pW != NULL) {
		pW->cbDrawPrn = cbDrawByPrinterDC;
		pW->cbDrawDib = NULL;
	}
	return rc;
}

//==============================================================================================================//
//	インスタンス消去																							//
//																												//
//	引　数	：	pW		 - インスタンスハンドル																	//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
AJCEXPORT	VO		WINAPI	AjcPrnDelete	(HAJCPRN pW)
{
	if (pW != NULL) {
		if (pW->pdg.hDevMode  != NULL) GlobalFree(pW->pdg.hDevMode);
		if (pW->pdg.hDevNames != NULL) GlobalFree(pW->pdg.hDevNames);
		free(pW);
	}
}

//==============================================================================================================//
//	プリンタの選択																								//
//																												//
//	引　数	：	pW		 			- インスタンスハンドル														//
//				pInfo				- プリンタ情報を格納するバッファのアドレス									//
//				Flag				- オプションフラグ															//
//				hWndOwner			- オーナーウインドハンドル													//
//																												//
//	戻り値	：	TRUE  - ＯＫ																					//
//				FALSE - 未選択／エラー																			//
//==============================================================================================================//
//	ウインド検索ワーク
typedef struct {
	ULL				Flags;								//	オプションフラグ
	RECT			rcCbo;								//	コンボボックス（プリンタ名）の矩形
	HWND			hGrpPageInfo;						//	ページ範囲グループボックス
	HWND			hGrpCopies;							//	部数グループボックス
} WKWNDSRH, *PWKWNDSRH;
//	印刷フック関数
static	UINT_PTR CALLBACK cbPrintHook(HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam);
//--------------------------------------------------------------------------------------------------------------//
//	プリンタの選択ダイアログ
AJCEXPORT	BOOL	WINAPI	AjcPrnSelectDlg(HAJCPRN pW, PAJCPRN_INFO pInfo, UI Flag, HWND hWndOwner)
{
	AJCPRN_OPT	opt;
	memset(&opt, 0, sizeof opt);
	opt.Flags = PD_PRINTSETUP | (Flag & PD_NONETWORKBUTTON);
	return SubPrnSelect(pW, pInfo, &opt, hWndOwner);
}
//--------------------------------------------------------------------------------------------------------------//
//	印刷ダイアログ
AJCEXPORT	BOOL	WINAPI	AjcPrnPrintDlg (HAJCPRN pW, PAJCPRN_INFO pInfo, PAJCPRN_OPT pOpt, HWND hWndOwner)
{
	return SubPrnSelect(pW, pInfo, pOpt, hWndOwner);
}
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	SubPrnSelect(HAJCPRN pW, PAJCPRN_INFO pInfo, PAJCPRN_OPT pOpt, HWND hWndOwner)
{
	BOOL			rc	= FALSE;
	AJCPRN_MARGIN	mrg;
	WKWNDSRH		wk;

	//----- 前回の情報を解放 -------------------------------------//
	//	解放は不要！
	//	PRINTDLG構造体は維持したままとする。
	//	hDevModeやhDevNamesの値は変化せず、メモリもシステム側で再割り当てする模様
//	if (pW->pdg.hDevMode  != NULL) GlobalFree(pW->pdg.hDevMode);
//	if (pW->pdg.hDevNames != NULL) GlobalFree(pW->pdg.hDevNames);
//	memset(&pW->pdg, 0, sizeof pW->pdg);

	//----- PRINTDLG初期化 ---------------------------------------//
	pW->pdg.lStructSize   = sizeof(PRINTDLG);
	pW->pdg.hwndOwner	  = hWndOwner;
	if (pOpt == NULL) {
		pW->pdg.Flags = PD_RETURNDEFAULT;
	}
	else {
		pW->pdg.Flags			= (UL)pOpt->Flags;
		pW->pdg.nCopies			= pOpt->nCopies;
		pW->pdg.nFromPage		= pOpt->nFromPage;
		pW->pdg.nToPage			= pOpt->nToPage;
		pW->pdg.nMinPage		= pOpt->nMinPage;
		pW->pdg.nMaxPage		= pOpt->nMaxPage;
		//	コールバック設定
		if (pOpt->Flags & (AJCPRNF_DISABLECOPIES | AJCPRNF_DISABLEPAGEINFO)) {
			memset(&wk, 0, sizeof wk);
			wk.Flags = pOpt->Flags;
			pW->pdg.Flags |= PD_ENABLEPRINTHOOK;
			pW->pdg.lCustData = (UX)&wk;
			pW->pdg.lpfnPrintHook = cbPrintHook;
		}
	}

	if (PrintDlg(&pW->pdg)) {
		//	設定されたオプション値を返す
		if (pOpt != NULL) {
			pOpt->Flags			= (pOpt->Flags & 0xFFFFFFFF00000000ULL) | ((ULL)pW->pdg.Flags & 0x00000000FFFFFFFFULL);
			pOpt->nCopies		= pW->pdg.nCopies;
			pOpt->nFromPage		= pW->pdg.nFromPage;
			pOpt->nToPage		= pW->pdg.nToPage;
			pOpt->nMinPage		= pW->pdg.nMinPage;
			pOpt->nMaxPage		= pW->pdg.nMaxPage;
		}
		//	プリンタ名，ファイル出力指定フラグ設定
		if (pW->pdg.hDevNames != NULL) {
			LPDEVNAMES pdn = (LPDEVNAMES)GlobalLock(pW->pdg.hDevNames);
			WCP		   pName = (WCP)pdn;
			//	プリンタ名設定
			pName += pdn->wDeviceOffset;
			AjcSnPrintF(pW->NameW, AJCPRN_MAX_PRNNAME, L"%s", pName);
			WideCharToMultiByte(CP_ACP, 0, pW->NameW, -1, pW->NameA, AJCPRN_MAX_PRNNAME, NULL, NULL);
			//	ファイル出力フラグ設定
			if (pOpt != NULL) {
				pName = (WCP)pdn;
				pName += pdn->wOutputOffset;
				if (wcsicmp(pName, L"FILE:") == 0) pOpt->Flags |=  AJCPRNF_OUTPUTTOFILE;
				else							   pOpt->Flags &= ~AJCPRNF_OUTPUTTOFILE;
			}
			GlobalUnlock(pW->pdg.hDevNames);
		}
		else if (pW->pdg.hDevMode != NULL) {
			LPDEVMODE pdm = (LPDEVMODE)GlobalLock(pW->pdg.hDevMode);
			AjcSnPrintF(pW->NameW, AJCPRN_MAX_PRNNAME, L"%s", pdm->dmDeviceName);
			WideCharToMultiByte(CP_ACP, 0, pW->NameW, -1, pW->NameA, AJCPRN_MAX_PRNNAME, NULL, NULL);
			GlobalUnlock(pW->pdg.hDevMode);
		}
		//---- プリンタ情報算出 -----------------------------------------//
		memcpy(&mrg, &pW->pi.MrgIf.mm, sizeof(AJCPRN_MARGIN));
		CreDcAndSetPrinterInfo(pW, &mrg);
		//----- プリンタ情報格納 ----------------------------------------//
		if (pInfo != NULL) {
			memcpy(pInfo, &pW->pi, sizeof(AJCPRN_INFO));
		}
		rc = TRUE;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	コンボボックス（プリンタ名）検索
static	BOOL CALLBACK cbEnumChildSrhCbo(HWND hw, LPARAM lParam)
{
	BOOL		rc	= TRUE;
	PWKWNDSRH	pWk = (PWKWNDSRH)lParam;
	WC			txt[256];

	GetClassName(hw, txt, AJCTSIZE(txt));
	if (wcsicmp(txt, L"ComboBox") == 0 || wcsicmp(txt, L"SysListView32") == 0) {
		GetWindowRect(hw, &pWk->rcCbo);
		rc = FALSE;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	印刷範囲，印刷部数グループ検索
static	BOOL CALLBACK cbEnumChildSrhGrp(HWND hw, LPARAM lParam)
{
	BOOL		rc	= TRUE;
	PWKWNDSRH	pWk = (PWKWNDSRH)lParam;
	int			sty;
	RECT		rect;
	WC			txt[256];

	GetClassName(hw, txt, AJCTSIZE(txt));
	if (wcsicmp(txt, L"Button") == 0) {
		GetWindowRect(hw, &rect);
		sty = (int)MAjcGetWindowLong(hw, GWL_STYLE);
		if ((sty & WS_GROUP) && ((sty & BS_TYPEMASK) == BS_GROUPBOX) && rect.top > pWk->rcCbo.top) {
			GetWindowText(hw, txt, AJCTSIZE(txt));
			if (rect.left <= pWk->rcCbo.left) pWk->hGrpPageInfo = hw;
			else							  pWk->hGrpCopies	= hw;
		}
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
static	UINT_PTR CALLBACK cbPrintHook(HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam)
{
	PWKWNDSRH		pWk;

	if (msg == WM_INITDIALOG) {
		LPPRINTDLG	p = (LPPRINTDLG)lParam;
		pWk = (PWKWNDSRH)p->lCustData;
		//	コンボボックス（プリンタ）検索
		EnumChildWindows(hDlg, cbEnumChildSrhCbo, (UX)pWk);
		//	印刷範囲グループ，印刷部数グループの検索
		EnumChildWindows(hDlg, cbEnumChildSrhGrp, (UX)pWk);
		//	印刷範囲グループ無効化
		if ((pWk->Flags & AJCPRNF_DISABLEPAGEINFO) && (pWk->hGrpPageInfo != NULL)) {
			AjcEnableGroup(pWk->hGrpPageInfo, FALSE, FALSE);
		}
		//	印刷部数グループ無効化
		if ((pWk->Flags & AJCPRNF_DISABLECOPIES  ) && (pWk->hGrpCopies	 != NULL)) {
			AjcEnableGroup(pWk->hGrpCopies	, FALSE, FALSE);
		}
	}
	return 0;
}
//==============================================================================================================//
//	印刷開始																									//
//																												//
//	引　数	：	pW		 			- インスタンスハンドル														//
//				fOutputToFile		- ファイル出力フラグ														//
//																												//
//	戻り値	：	＝０ - ＯＫ																						//
//				≠０ - エラー																					//
//==============================================================================================================//
AJCEXPORT	int		WINAPI	AjcPrnStart	(HAJCPRN pW, BOOL fOutputToFile)
{
	int					rc	 = 0;				//	戻り値
	HDC					hdcPrn = NULL;			//	プリンタＤＣ
	HDC					hdcMem = NULL;			//	ＤＩＢセクション用メモリＤＣ
	LPDEVMODE			pDevMode = NULL;		//	プリンタデバイス情報
	BOOL				fExit = FALSE;			//	印刷終了フラグ
	BOOL				fStartDoc = FALSE;		//	StartDoc()実行済フラグ
	BOOL				fOriChanged = FALSE;	//	印刷の向き変更フラグ
	BOOL				fMrgChanged = FALSE;	//	余白サイズ変更フラグ
	DOCINFO				di;						//	ＤＯＣＩＮＦＯ
	HBITMAP				hBmp = NULL;			//	ＤＩＢセクションビットマップハンドル
	HBITMAP				hBmpSv = NULL;
	AJCPRN_PGINFO 		DefPg;					//	デフォルトのページ情報
	AJCPRN_PGINFO 		NtcPg;					//	通知するページ情報
	RECT				r;
	WC					path [MAX_PATH];		//	プログラムパス
	WC					fname[MAX_PATH];		//	プログラム名（ドキュメント名）

	//----- 印刷中フラグ設定 -----------------------//
	pW->fPrintBusy = TRUE;

	//----- ドキュメント名設定 ---------------------//
	GetModuleFileName(NULL, path, MAX_PATH);
	_wsplitpath(path, NULL, NULL, fname, NULL);
	//----- DOCINFO設定 ----------------------------//
	memset(&di, 0, sizeof di);
	di.cbSize	   = sizeof(DOCINFO);
	di.lpszDocName = fname;
	if (fOutputToFile) di.lpszOutput = L"FILE:";
	else			   di.lpszOutput = NULL;

	do {
		//----- DEVMODE構造体取得 -------------------------//
		if (pW->pdg.hDevMode != NULL) pDevMode = (LPDEVMODE)GlobalLock(pW->pdg.hDevMode);
		else						  pDevMode = NULL;
		//----- プリンタＤＣ生成 --------------------------//
		if ((hdcPrn = CreateDC(NULL, pW->NameW, NULL, pDevMode)) == NULL) {
			rc = GetLastError();
			break;
		}
		//----- ページ情報初期化 --------------------------//
		memcpy(&DefPg.mmMrg, &pW->pi.MrgIf.mm, sizeof DefPg.mmMrg);
		DefPg.orientation = pW->pi.Orientation;
		//----- プリンタ情報設定 --------------------------//
		SubSetPrinterInfo(pW, &DefPg.mmMrg, hdcPrn, pDevMode);
		//----- ＤＩＢ用ＤＣ生成 --------------------------//
		if (pW->cbDrawDib != NULL) {
			if ((hdcMem = CreateCompatibleDC(NULL)			   ) == NULL) {
				rc = GetLastError();
				break;
			}
		}
		//----- 印刷開始 ----------------------------------//
		if (StartDoc(hdcPrn, &di) <= 0)   {
			rc = GetLastError();
			break;
		}
		//	StartDoc()実行済フラグ
		fStartDoc = TRUE;

		fExit = FALSE;
		while (!fExit) {
			fMrgChanged = FALSE;
			fOriChanged = FALSE;
			//----- ページ印刷開始通知 ----------------//
			memcpy(&NtcPg, &DefPg, sizeof NtcPg);
			if (pW->cbQueryPage != NULL) {
				if (pW->cbQueryPage(&pW->pi, &NtcPg, pW->cbp) == FALSE) {
					break;
				}
			}
			//---- 余白サイズ変更フラグ設定 -----------//
			if (memcmp(&DefPg.mmMrg, &NtcPg.mmMrg, sizeof DefPg.mmMrg) != 0) {
				fMrgChanged = TRUE;
			}
			//---- 用紙の向き変更フラグ設定 -----------//
			if ((DefPg.orientation == AJCPRN_ORIENT_PORTRAIT  && NtcPg.orientation == AJCPRN_ORIENT_LANDSCAPE) ||
				(DefPg.orientation == AJCPRN_ORIENT_LANDSCAPE && NtcPg.orientation == AJCPRN_ORIENT_PORTRAIT )) {
				fOriChanged = TRUE;
			}
			//----- 余白，印刷の向き設定 --------------//
			if (fMrgChanged || fOriChanged) {
				if (fOriChanged) {
					if (pDevMode != NULL && (pDevMode->dmFields & DM_ORIENTATION)) {
						//	一旦、印刷終了
						EndDoc(hdcPrn);
						fStartDoc = FALSE;
						//	プリンタＤＣ解放
						DeleteDC(hdcPrn);
						//	縦横モード設定
						pDevMode->dmOrientation = NtcPg.orientation;
						//	プリンタＤＣ生成
						if ((hdcPrn = CreateDC(NULL, pW->NameW, NULL, pDevMode)) == NULL) {
							rc = GetLastError();
							break;
						}
						//	印刷再開
						if (StartDoc(hdcPrn, &di) <= 0)   {
							rc = GetLastError();
							break;
						}
						//	StartDoc()実行済フラグ
						fStartDoc = TRUE;
					}
				}
				//----- プリンタ情報設定 --------------//
				SubSetPrinterInfo(pW, &NtcPg.mmMrg, hdcPrn, pDevMode);
				//---- ページ情報デフォルト変更 -------//
				memcpy(&DefPg, &NtcPg, sizeof DefPg);
			}
			//----- プリンタ描画域クリアー --------------------//
			r.left = r.top = 0; r.right = pW->pi.cxPage, r.bottom = pW->pi.cyPage;
			FillRect(hdcPrn, &r, (HBRUSH)GetStockObject(WHITE_BRUSH));
			//----- ＤＩＢセクション生成 --------------//
			if (pW->cbDrawDib != NULL) {
				if (hBmp == NULL || fMrgChanged || fOriChanged) {
					if (hBmp != NULL) DeleteObject(SelectObject(hdcMem, hBmpSv));
					if ((hBmp = AjcDibCreate(pW->pi.cx, pW->pi.cy, 32, &pW->dib)) == NULL) {
						rc = GetLastError();
						break;
					}
					hBmpSv = (HBITMAP)SelectObject(hdcMem, hBmp);
				}
				//--- ＤＩＢセクションクリアー --------//
				r.left = r.top = 0; r.right = pW->pi.cx, r.bottom = pW->pi.cy;
				FillRect(hdcMem, &r, (HBRUSH)GetStockObject(WHITE_BRUSH));
			}
			//----- ページ印刷開始 --------------------//
			if (StartPage(hdcPrn) <= 0) {
				rc = GetLastError();
				break;
			}
			do {
				//----- プリンタＤＣによるページ印刷通知 --//
				if (pW->cbDrawPrn) {
					BOOL	rsu;
					//	コールバック
					rsu = pW->cbDrawPrn(hdcPrn, &pW->pi, pW->cbp);
					if (rsu == FALSE) {
						fExit = TRUE;
						break;
					}
				}
				//----- ＤＩＢ－ＤＣによるページ印刷通知 --//
				else if (pW->cbDrawDib) {
					BOOL	rsu;
					//	コールバック
					rsu = pW->cbDrawDib(hdcMem, &pW->pi, &pW->dib, pW->cbp);
					//	ＤＩＢ→プリンタへイメージ転送
					BitBlt(hdcPrn, pW->pi.x, pW->pi.y, pW->pi.cx, pW->pi.cy, hdcMem, 0, 0, SRCCOPY);
					if (rsu == FALSE) {
						fExit = TRUE;
						break;
					}
				}
				//----- コールバック無しならば、終了 -----//
				else break;
			} while(0);
			//----- ページ印刷終了 -------------------//
			if (EndPage(hdcPrn) <= 0) {
				rc = GetLastError();
				break;
			}
		}
		//	印刷終了
		if (fStartDoc) EndDoc(hdcPrn);
	} while(0);

	//	リソース解放
	if (hdcPrn 	 != NULL) {DeleteDC(hdcPrn);		hdcPrn	 = NULL;}
	if (hdcMem	 != NULL) {DeleteDC(hdcMem);		hdcMem	 = NULL;}
	if (hBmp	 != NULL) {DeleteObject(hBmp);		hBmp	 = NULL;}
	if (pDevMode != NULL) {GlobalUnlock(pDevMode);	pDevMode = NULL;}

	//----- 印刷中フラグ解除 -----------------------//
	pW->fPrintBusy = FALSE;

	#ifdef _DEBUG
		if (rc != 0) {
			WC		ErrTxt[256];
			AjcGetLastErrorText(rc, ErrTxt, AJCTSIZE(ErrTxt));
			MessageBox(NULL, ErrTxt, L"印刷失敗", MB_ICONERROR);
		}
	#endif

	return rc;
}

//==============================================================================================================//
//	余白サイズ設定																								//
//																												//
//	引　数	：	pW		 			- インスタンスハンドル														//
//				pmmMargin			- 余白サイズ[mm]情報へのポインタ											//
//																												//
//	戻り値	：	TRUE  - ＯＫ																					//
//				FALSE - エラー																					//
//==============================================================================================================//
AJCEXPORT	BOOL			WINAPI	AjcPrnSetMargin	(HAJCPRN pW, PAJCPRN_MARGIN pmmMargin)
{
	BOOL	rc = FALSE;

	if (pW != NULL && !pW->fPrintBusy) {
		rc = CreDcAndSetPrinterInfo(pW, pmmMargin);
	}
	return rc;
}
//==============================================================================================================//
//	プリンタ情報取得																							//
//																												//
//	引　数	：	pW		 			- インスタンスハンドル														//
//				pBuf				- プリンタ情報を格納するバッファのアドレス									//
//																												//
//	戻り値	：	≠ＮＵＬＬ - ＯＫ（プリンタ名へのポインタ）														//
//				＝ＮＵＬＬ - エラー																				//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	C_BCP				WINAPI	AjcPrnGetInfoA	(HAJCPRN pW, PAJCPRN_INFO pBuf)
{
	C_BCP		rc = NULL;

	if (pW != NULL) {
		if (pBuf != NULL) {
			memcpy(pBuf, &pW->pi, sizeof(AJCPRN_INFO));
		}
		rc = pW->NameA;
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	C_WCP				WINAPI	AjcPrnGetInfoW	(HAJCPRN pW, PAJCPRN_INFO pBuf)
{
	C_WCP		rc = NULL;

	if (pW != NULL) {
		if (pBuf != NULL) {
			memcpy(pBuf, &pW->pi, sizeof(AJCPRN_INFO));
		}
		rc = pW->NameW;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	プリンタＤＣ作成とプリンタ情報設定																			//
//																												//
//	引　数	：	pW		 	- インスタンスハンドル																//
//				pName		- プリンタデバイス名																//
//				pmmMrg		- 上下左右の余白長[mm]（範囲外の場合はこのバッファの値を訂正，NULL時は最低余白長）	//
//				hdc			- プリンタＤＣ																		//
//				pDevMode	- デバイス情報																		//
//																												//
//	戻り値	：	TRUE  - ＯＫ																					//
//				FALSE - エラー																					//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	CreDcAndSetPrinterInfo(HAJCPRN pW, PAJCPRN_MARGIN pmmMrg)
{
	BOOL		rc = FALSE;
	HDC			hdc = NULL;
	LPDEVMODE	pDevMode;

	//----- DEVMODE構造体取得 -------------------------//
	if (pW->pdg.hDevMode != NULL) pDevMode = (LPDEVMODE)GlobalLock(pW->pdg.hDevMode);
	else						  pDevMode = NULL;

	//----- プリンタＤＣ生成 --------------------------//
	hdc = CreateDC(NULL, pW->NameW, NULL, pDevMode);

	//----- プリンタ情報設定 --------------------------//
	if (hdc != NULL) {
		rc = SubSetPrinterInfo(pW, pmmMrg, hdc, pDevMode);
	}

	//----- リソース解放 ------------------------------//
	if (hdc 		 	 != NULL) {DeleteDC(hdc);}
	if (pW->pdg.hDevMode != NULL) {GlobalUnlock(pW->pdg.hDevMode);}

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	プリンタ情報設定																							//
//																												//
//	引　数	：	pW		 	- インスタンスハンドル																//
//				pName		- プリンタデバイス名																//
//				pmmMrg		- 上下左右の余白長[mm]（範囲外の場合はこのバッファの値を訂正，NULL時は最低余白長）	//
//				hdc			- プリンタＤＣ																		//
//				pDevMode	- デバイス情報																		//
//																												//
//	戻り値	：	TRUE  - ＯＫ																					//
//				FALSE - エラー																					//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	SubSetPrinterInfo(HAJCPRN pW, PAJCPRN_MARGIN pmmMrg, HDC hdc, LPDEVMODE pDevMode)
{
	BOOL			rc = FALSE;
	int				mmMinX, mmMaxX;
	int				mmMinY, mmMaxY;

	if (hdc != NULL) {
		//----- プリンタ諸元 --------------------//
		pW->pi.cxFull		= GetDeviceCaps(hdc, PHYSICALWIDTH	);			//	余白を含めた描画ピクセル数
		pW->pi.cyFull		= GetDeviceCaps(hdc, PHYSICALHEIGHT );			//	・
		pW->pi.OffsetX		= GetDeviceCaps(hdc, PHYSICALOFFSETX);			//	左右印刷不能域のピクセル数
		pW->pi.OffsetY		= GetDeviceCaps(hdc, PHYSICALOFFSETY);			//	上下印刷不能域のピクセル数
		pW->pi.FactorX		= GetDeviceCaps(hdc, SCALINGFACTORX );			//	プリンタの水平軸の倍率
		pW->pi.FactorY		= GetDeviceCaps(hdc, SCALINGFACTORY );			//	プリンタの垂直軸の倍率
		pW->pi.LogPixelsX	= GetDeviceCaps(hdc, LOGPIXELSX 	);			//	１インチ当たりの横ピクセル数
		pW->pi.LogPixelsY	= GetDeviceCaps(hdc, LOGPIXELSY 	);			//	１インチ当たりの縦ピクセル数
		if (pDevMode != NULL) pW->pi.Orientation = pDevMode->dmOrientation;	//	縦置き／横置き
		else				  pW->pi.Orientation = AJCPRN_ORIENT_UNKOWN;
		//	印字可能領域サイズ設定
		pW->pi.cxPage = pW->pi.cxFull - (pW->pi.OffsetX * 2);				//	印字可能なピクセル数
		pW->pi.cyPage = pW->pi.cyFull - (pW->pi.OffsetY * 2);				//	・

		//----- 最小余白長[pixels] --------------//
		pW->pi.MrgIf.pxMin.l = 0;
		pW->pi.MrgIf.pxMin.r = 0;
		pW->pi.MrgIf.pxMin.u = 0;
		pW->pi.MrgIf.pxMin.d = 0;

		//----- 最小余白長[mm] ------------------//
		mmMinX		  = (int)ceil((double)pW->pi.OffsetX * 25.4 / (double)pW->pi.LogPixelsX);
		mmMinY		  = (int)ceil((double)pW->pi.OffsetX * 25.4 / (double)pW->pi.LogPixelsX);
		pW->pi.MrgIf.mmMin.l = mmMinX;
		pW->pi.MrgIf.mmMin.r = mmMinX;
		pW->pi.MrgIf.mmMin.u = mmMinY;
		pW->pi.MrgIf.mmMin.d = mmMinY;

		//----- 最大余白長[pixels] --------------//
		pW->pi.MrgIf.pxMax.l = pW->pi.cxPage * 40 / 100;
		pW->pi.MrgIf.pxMax.r = pW->pi.cxPage * 40 / 100;
		pW->pi.MrgIf.pxMax.u = pW->pi.cyPage * 40 / 100;
		pW->pi.MrgIf.pxMax.d = pW->pi.cyPage * 40 / 100;

		//----- 最大余白長[mm] ------------------//
		mmMaxX		  = (int)((double)(pW->pi.cxPage * 40 / 100) * 25.4 / (double)pW->pi.LogPixelsX);
		mmMaxY		  = (int)((double)(pW->pi.cyPage * 40 / 100) * 25.4 / (double)pW->pi.LogPixelsX);
		pW->pi.MrgIf.mmMax.l = mmMaxX;
		pW->pi.MrgIf.mmMax.r = mmMaxX;
		pW->pi.MrgIf.mmMax.u = mmMaxY;
		pW->pi.MrgIf.mmMax.d = mmMaxY;

		//----- 指定余白長[mm]を範囲内に訂正 ----//
		if (pmmMrg != NULL) {
			memcpy(&pW->pi.MrgIf.mm, pmmMrg, sizeof(AJCPRN_MARGIN));
			pW->pi.MrgIf.mm.l	 = __max(pW->pi.MrgIf.mm.l, mmMinX);	  pW->pi.MrgIf.mm.l = __min(pW->pi.MrgIf.mm.l, mmMaxX);
			pW->pi.MrgIf.mm.r	 = __max(pW->pi.MrgIf.mm.r, mmMinX);	  pW->pi.MrgIf.mm.r = __min(pW->pi.MrgIf.mm.r, mmMaxX);
			pW->pi.MrgIf.mm.u	 = __max(pW->pi.MrgIf.mm.u, mmMinY);	  pW->pi.MrgIf.mm.u = __min(pW->pi.MrgIf.mm.u, mmMaxY);
			pW->pi.MrgIf.mm.d	 = __max(pW->pi.MrgIf.mm.d, mmMinY);	  pW->pi.MrgIf.mm.d = __min(pW->pi.MrgIf.mm.d, mmMaxY);
			memcpy(pmmMrg, &pW->pi.MrgIf.mm, sizeof(AJCPRN_MARGIN));
		}
		//----- 余白指定無し時は最低値を仮定 ----//
		else {
			pW->pi.MrgIf.mm.l	 = mmMinX;
			pW->pi.MrgIf.mm.r	 = mmMinX;
			pW->pi.MrgIf.mm.u	 = mmMinY;
			pW->pi.MrgIf.mm.d	 = mmMinY;
		}

		//----- 余白ピクセル数 ------------------//
		memset(&pW->pi.MrgIf.px, 0, sizeof pW->pi.MrgIf.px);
		if (pmmMrg != NULL) {
			pW->pi.MrgIf.px.l = (int)((double)pmmMrg->l * ((double)pW->pi.LogPixelsX / 25.4));
			pW->pi.MrgIf.px.r = (int)((double)pmmMrg->r * ((double)pW->pi.LogPixelsX / 25.4));
			pW->pi.MrgIf.px.u = (int)((double)pmmMrg->u * ((double)pW->pi.LogPixelsY / 25.4));
			pW->pi.MrgIf.px.d = (int)((double)pmmMrg->d * ((double)pW->pi.LogPixelsY / 25.4));
		}
		//	最小値以下カット
		pW->pi.MrgIf.px.l = __max(pW->pi.MrgIf.px.l, pW->pi.MrgIf.pxMin.l);
		pW->pi.MrgIf.px.r = __max(pW->pi.MrgIf.px.r, pW->pi.MrgIf.pxMin.r);
		pW->pi.MrgIf.px.u = __max(pW->pi.MrgIf.px.u, pW->pi.MrgIf.pxMin.u);
		pW->pi.MrgIf.px.d = __max(pW->pi.MrgIf.px.d, pW->pi.MrgIf.pxMin.d);
		//	最大値以上カット
		pW->pi.MrgIf.px.l = __min(pW->pi.MrgIf.px.l, pW->pi.MrgIf.pxMax.l);
		pW->pi.MrgIf.px.r = __min(pW->pi.MrgIf.px.r, pW->pi.MrgIf.pxMax.r);
		pW->pi.MrgIf.px.u = __min(pW->pi.MrgIf.px.u, pW->pi.MrgIf.pxMax.u);
		pW->pi.MrgIf.px.d = __min(pW->pi.MrgIf.px.d, pW->pi.MrgIf.pxMax.d);
		//	オフセット分を減算
		pW->pi.MrgIf.px.l = (pW->pi.MrgIf.px.l > pW->pi.OffsetX ? pW->pi.MrgIf.px.l - pW->pi.OffsetX : 0);
		pW->pi.MrgIf.px.r = (pW->pi.MrgIf.px.r > pW->pi.OffsetX ? pW->pi.MrgIf.px.r - pW->pi.OffsetX : 0);
		pW->pi.MrgIf.px.u = (pW->pi.MrgIf.px.u > pW->pi.OffsetY ? pW->pi.MrgIf.px.u - pW->pi.OffsetY : 0);
		pW->pi.MrgIf.px.d = (pW->pi.MrgIf.px.d > pW->pi.OffsetY ? pW->pi.MrgIf.px.d - pW->pi.OffsetY : 0);

		//----- 余白を除いた描画位置，長さ ------//
		pW->pi.x	= pW->pi.MrgIf.px.l;
		pW->pi.y	= pW->pi.MrgIf.px.u;
		pW->pi.cx	= pW->pi.cxPage - (pW->pi.MrgIf.px.l + pW->pi.MrgIf.px.r);
		pW->pi.cy	= pW->pi.cyPage - (pW->pi.MrgIf.px.u + pW->pi.MrgIf.px.d);

		//----- プリンタ情報設定済みフラグ ------//
		pW->fpi = TRUE;

		rc = TRUE;
	}
	return rc;
}
