﻿#include	"AjcInternal.h"

//**************************************************************************************************************//
//																												//
//	他プロセス内メモリ操作																						//
//																												//
//**************************************************************************************************************//


#define	INST_ID			0x625DEABC
#define	IS_MY_INST(P)	(P != NULL && P->InstID == INST_ID)



//==============================================================================================================//
//	他プロセスにメモリ確保（ウインド指定）																		//
//																												//
//	引　数	：	hwnd		 - 他プロセスのウインドハンドル														//
//				size		 - メモリサイズ（バイト数）															//
//																												//
//	戻り値	：	≠NULL : インスタンスハンドル																	//
//				＝NULL : エラー																					//
//==============================================================================================================//
AJCEXPORT	HAJCPM	WINAPI	AjcPmCreateByWnd(HWND hwnd, UX size)
{
	HAJCPM	pW = NULL;

	if (pW = (HAJCPM)AJCMEM(sizeof(AJCPM))) {
		memset(pW, 0, sizeof(AJCPM));
		pW->InstID = INST_ID;
		pW->ThreadID = GetWindowThreadProcessId(hwnd, &pW->ProcessID);
		if(pW->ThreadID && pW->ProcessID) {
			if (pW->hProcess = OpenProcess(PROCESS_ALL_ACCESS, FALSE, pW->ProcessID)) {
				pW->u.pVoid = VirtualAllocEx(pW->hProcess, NULL, size, MEM_COMMIT, PAGE_READWRITE);
				if (pW->u.pVoid == NULL) {
					FREE(pW); pW = NULL;
				}
			}
			else {FREE(pW); pW = NULL;}
		}
		else {FREE(pW); pW = NULL;}
	}
	return pW;
}
//==============================================================================================================//
//	他プロセスにメモリ確保（プロセスＩＤ指定）																	//
//																												//
//	引　数	：	pid			 - プロセスＩＤ																		//
//				size		 - メモリサイズ（バイト数）															//
//																												//
//	戻り値	：	≠NULL : インスタンスハンドル																	//
//				＝NULL : エラー																					//
//==============================================================================================================//
AJCEXPORT	HAJCPM	WINAPI	AjcPmCreateByPid(UL pid, UX size)
{
	HAJCPM	pW = NULL;

	if (pW = (HAJCPM)AJCMEM(sizeof(AJCPM))) {
		memset(pW, 0, sizeof(AJCPM));
		pW->InstID	  = INST_ID;
		pW->ProcessID = pid;
		if (pW->hProcess = OpenProcess(PROCESS_VM_READ | PROCESS_VM_WRITE, FALSE, pW->ProcessID)) {
			pW->u.pVoid = VirtualAllocEx(pW->hProcess, NULL, size, MEM_COMMIT, PAGE_READWRITE);
			if (pW->u.pVoid == NULL) {
				FREE(pW); pW = NULL;
			}
		}
		else {FREE(pW); pW = NULL;}
	}
	return pW;
}
//==============================================================================================================//
//	他プロセスに確保したメモリを破棄																			//
//																												//
//	引　数	：	pW			 - インスタンスハンドル																//
//																												//
//	戻り値	：	TRUE  : 成功																					//
//				FALSE : エラー																					//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcPmDelete(HAJCPM pW)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		VirtualFreeEx(pW->hProcess, pW->u.pVoid, 0, MEM_RELEASE);
		CloseHandle(pW->hProcess);
		free(pW);
		rc = TRUE;
	}
	return TRUE;
}

//==============================================================================================================//
//	他プロセスに確保したメモリへ書き込み																		//
//																												//
//	引　数	：	pW		- インスタンスハンドル																	//
//				loc		- メモリ位置（バイトロケーション（０～）												//
//				pSrc	- ソースデータのアドレス																//
//				len		- 書き込むバイト数																		//
//																												//
//	戻り値	：	TRUE  : 成功																					//
//				FALSE : エラー																					//
//																												//
//	備　考	：	「loc + len」確保したメモリサイズ以下であること													//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcPmWrite(HAJCPM pW, UX loc, C_VOP pSrc, UX len)
{
	BOOL	rc = FALSE;
	SIZE_T	bytes = -1;

	if (IS_MY_INST(pW)) {
		WriteProcessMemory(pW->hProcess, pW->u.pByte + loc, pSrc, len, &bytes);
		if (len == bytes) {
			rc = TRUE;
		}
	}
	return rc;
}

//==============================================================================================================//
//	他プロセスに確保したメモリの読み出し																		//
//																												//
//	引　数	：	pW		- インスタンスハンドル																	//
//				loc		- メモリ位置（バイトロケーション（０～）												//
//				pBuf	- 読み出したで0田を格納するバッファのアドレス											//
//				len		- 読み出すバイト数																		//
//																												//
//	戻り値	：	TRUE  : 成功																					//
//				FALSE : エラー																					//
//																												//
//	備　考	：	「loc + len」が確保したメモリサイズ以下であること												//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcPmRead(HAJCPM pW, UX loc, VOP pBuf, UX len)
{
	BOOL	rc = FALSE;
	SIZE_T	bytes = -1;

	if (IS_MY_INST(pW)) {
		ReadProcessMemory(pW->hProcess, pW->u.pByte + loc, pBuf, len, &bytes);
		if (len == bytes) {
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	他プロセスのメモリアドレス取得																				//
//																												//
//	引　数	：	pW		- インスタンスハンドル																	//
//				loc		- メモリ位置（バイトロケーション（０～）												//
//																												//
//	戻り値	：	バイトロケーションのメモリアドレス（エラーの場合は０を返す）									//
//==============================================================================================================//
AJCEXPORT	UX		WINAPI	AjcPmGetAddr(HAJCPM pW, UX loc)
{
	UX		rc = 0;

	if (IS_MY_INST(pW)) {
		rc = (UX)(pW->u.pByte + loc);
	}
	return rc;
}

//==============================================================================================================//
//	他プロセスのウインドへメッセージ送信																		//
//																												//
//	引　数	：	pW		- インスタンスハンドル																	//
//				hwnd	- 送信先ウインド																		//
//				msg		- 送信メッセージコード																	//
//				lParam	- 読み出したデータを格納するバッファのアドレス											//
//				wParam	- 読み出すバイト数																		//
//																												//
//	戻り値	：	メッセージの戻り値																				//
//																												//
//	備　考	：	「loc + len」が確保したメモリサイズ以下であること												//
//==============================================================================================================//
static	VO	SubWriteParam(HAJCPM pW)
{
	//	他プロセスへのデータ書き込みデータ／読み出しバッファイメージコピー(wParam)
	if (pW->wp.flg != AJCPMRW_NONE) {
		AjcPmWrite(pW, pW->wp.loc, pW->wp.pMem, pW->wp.len);
	}

	//	他プロセスへのデータ書き込みデータ／読み出しバッファイメージコピー(lParam)
	if (pW->lp.flg != AJCPMRW_NONE) {
		AjcPmWrite(pW, pW->lp.loc, pW->lp.pMem, pW->lp.len);
	}
}
//--------------------------------------------------------------------------------------------------------------//
static	VO	SubReadParam(HAJCPM pW)
{
	//	他プロセスからデータ読み出し(wParam)
	if (pW->wp.flg == AJCPMRW_R) {
		AjcPmRead(pW, pW->wp.loc, pW->wp.pMem, pW->wp.len);
	}

	//	他プロセスからデータ読み出し(lParam)
	if (pW->lp.flg == AJCPMRW_R) {
		AjcPmRead(pW, pW->lp.loc, pW->lp.pMem, pW->lp.len);
	}
}
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	LRESULT	WINAPI	AjcPmSendMessageA(HAJCPM pW, HWND hwnd, UI msg, WPARAM wParam, LPARAM lParam)
{
	LRESULT		rc = 999;

	//	他プロセスのメモリへデータコピー
	SubWriteParam(pW);

	//	メッセージ送信
	rc = SendMessageA(hwnd, msg, wParam, lParam);

	//	他プロセスのメモリからデータコピー
	SubReadParam(pW);

	//	データ読み書き情報クリアー
	memset(&pW->wp, 0, sizeof pW->wp);
	memset(&pW->lp, 0, sizeof pW->lp);

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	LRESULT	WINAPI	AjcPmSendMessageW(HAJCPM pW, HWND hwnd, UI msg, WPARAM wParam, LPARAM lParam)
{
	LRESULT		rc = 999;

	//	他プロセスのメモリへデータコピー
	SubWriteParam(pW);

	//	メッセージ送信
	rc = SendMessageW(hwnd, msg, wParam, lParam);

	//	他プロセスのメモリからデータコピー
	SubReadParam(pW);

	//	データ読み書き情報クリアー
	memset(&pW->wp, 0, sizeof pW->wp);
	memset(&pW->lp, 0, sizeof pW->lp);

	return rc;
}
//==============================================================================================================//
//	他プロセスのウインドへメッセージをポスト																	//
//																												//
//	引　数	：	pW		- インスタンスハンドル																	//
//				hwnd	- 送信先ウインド																		//
//				msg		- メモリ位置（バイトロケーション（０～）												//
//				lParam	- 読み出したで0田を格納するバッファのアドレス											//
//				wParam	- 読み出すバイト数																		//
//																												//
//	戻り値	：	メッセージの戻り値																				//
//																												//
//	備　考	：	「loc + len」が確保したメモリサイズ以下であること												//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	LRESULT	WINAPI	AjcPmPostMessageA(HAJCPM pW, HWND hwnd, UI msg, WPARAM wParam, LPARAM lParam)
{
	LRESULT		rc = 0;

	//	他プロセスのメモリへデータコピー
	SubWriteParam(pW);

	//	メッセージ ポスト
	rc = PostMessageA(hwnd, msg, wParam, lParam);

	//	データ読み書き情報クリアー
	memset(&pW->wp, 0, sizeof pW->wp);
	memset(&pW->lp, 0, sizeof pW->lp);

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	LRESULT	WINAPI	AjcPmPostMessageW(HAJCPM pW, HWND hwnd, UI msg, WPARAM wParam, LPARAM lParam)
{
	LRESULT		rc = 0;

	//	他プロセスのメモリへデータコピー
	SubWriteParam(pW);

	//	メッセージ ポスト
	rc = PostMessageW(hwnd, msg, wParam, lParam);

	//	データ読み書き情報クリアー
	memset(&pW->wp, 0, sizeof pW->wp);
	memset(&pW->lp, 0, sizeof pW->lp);

	return rc;
}
//==============================================================================================================//
//	wParam 書き込み設定																							//
//																												//
//	引　数	：	pW		- インスタンスハンドル																	//
//				len		- バイト数																				//
//				pMem	- データアドレス																		//
//																												//
//	戻り値	：	他プロセス内のメモリロケーション																//
//																												//
//	備　考	：	「loc + len」が確保したメモリサイズ以下であること												//
//==============================================================================================================//
AJCEXPORT	WPARAM	WINAPI	AjcPmSetWpForWrite(HAJCPM pW, UX len, VOP pMem)
{
	pW->wp.flg	= AJCPMRW_W;
	pW->wp.loc	= 0;
	pW->wp.len	= len;
	pW->wp.pMem = pMem;

	return (WPARAM)( pW->u.pByte + pW->wp.loc);
}

//==============================================================================================================//
//	lParam 書き込み設定																							//
//																												//
//	引　数	：	pW		- インスタンスハンドル																	//
//				len		- バイト数																				//
//				pMem	- データアドレス																		//
//																												//
//	戻り値	：	他プロセス内のメモリロケーション																//
//																												//
//	備　考	：	「loc + len」確保したメモリサイズ以下であること													//
//==============================================================================================================//
AJCEXPORT	LPARAM	WINAPI	AjcPmSetLpForWrite(HAJCPM pW, UX len, VOP pMem)
{
	pW->lp.flg	= AJCPMRW_W;
	pW->lp.loc	= (pW->wp.flg != AJCPMRW_NONE) ? pW->wp.len : 0;
	pW->lp.len	= len;
	pW->lp.pMem = pMem;

	return (LPARAM)(pW->u.pByte + pW->lp.loc);
}
//==============================================================================================================//
//	wParam 読み出し設定																							//
//																												//
//	引　数	：	pW		- インスタンスハンドル																	//
//				len		- バイト数																				//
//				pMem	- バッファアドレス																		//
//																												//
//	戻り値	：	他プロセス内のメモリロケーション																//
//																												//
//	備　考	：	「loc + len」確保したメモリサイズ以下であること													//
//==============================================================================================================//
AJCEXPORT	WPARAM	WINAPI	AjcPmSetWpForRead(HAJCPM pW, UX len, VOP pMem)
{
	pW->wp.flg	= AJCPMRW_R;
	pW->wp.loc	= 0;
	pW->wp.len	= len;
	pW->wp.pMem = pMem;

	return (WPARAM)(pW->u.pByte + pW->wp.loc);
}

//==============================================================================================================//
//	lParam 読み出し設定																							//
//																												//
//	引　数	：	pW		- インスタンスハンドル																	//
//				len		- バイト数																				//
//				pMem	- バッファアドレス																		//
//																												//
//	戻り値	：	他プロセス内のメモリロケーション																//
//																												//
//	備　考	：	「loc + len」確保したメモリサイズ以下であること													//
//==============================================================================================================//
AJCEXPORT	LPARAM	WINAPI	AjcPmSetLpForRead(HAJCPM pW, UX len, VOP pMem)
{
	pW->lp.flg	= AJCPMRW_R;
	pW->lp.loc	= (pW->wp.flg != AJCPMRW_NONE) ? pW->wp.len : 0;
	pW->lp.len	= len;
	pW->lp.pMem = pMem;

	return (LPARAM)(pW->u.pByte + pW->lp.loc);
}


