﻿#include	"AjcInternal.h"

//**************************************************************************************************************//
//																												//
//	プロファイルアクセス（スタティック）																		//
//																												//
//**************************************************************************************************************//
//--------------------------------------------------------------------------------------------------------------//
//	作業領域																									//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL		fToRegistory  = TRUE;									//	プロファイル記録先（FALSE : INIﾌｧｲﾙ,  TRUE : ﾚｼﾞｽﾄﾘ）
static	UI			fVolatile	  = FALSE;									//	一時記録フラグ（FALSE:恒久記録，TRUE:一時記録）

static	BC			IniFilePathA[MAX_PATH	   ] = {0};						//	プロファイルパス（INIファイル用）
static	WC			IniFilePathW[MAX_PATH	   ] = {0};						//	・

static	BC			RegFilePathA[AJCMAX_REGPATH] = {0};						//	プロファイルパス（レジストリ用）
static	WC			RegFilePathW[AJCMAX_REGPATH] = {0};						//	・

static	BC			RegRootPathA[AJCMAX_REGPATH] =	"Software\\AjrCstXX";	//	レジストリ・ルートパス
static	WC			RegRootPathW[AJCMAX_REGPATH] = L"Software\\AjrCstXX";	//	・

static	BC			RegMidPathA[AJCMAX_REGPATH];							//	レジストリ・ミドルパス
static	WC			RegMidPathW[AJCMAX_REGPATH];							//	・

static	BC			BinDataDirA[MAX_PATH] = {0};							//	バイナリデータ格納ディレクトリ
static	WC			BinDataDirW[MAX_PATH] = {0};							//	・

static	HAJCVQUE	hVQueStack = NULL;		//	プロファイル記録先情報退避／回復用スタック

//--------------------------------------------------------------------------------------------------------------//
//	プロファイル記録先退避情報																					//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	BOOL	fReg;						//	プロファイル記録先
	BOOL	fVol;						//	一時記録フラグ
	WCP		pIniPathW;					//	INIファイルパス
	WCP		pRegPathW;					//	レジストリパス
	WCP		pRootPathW;					//	レジストリ・ルートパス
	WCP		pMidPathW;					//	レジストリ・ミドルパス
	WCP		pBinDirW;					//	バイナリデータ格納ディレクトリ
} PRFINFO, *PPRFINFO;
typedef const PRFINFO *PCPRFINFO;

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
static	VO		SetDefaultIniFilePath(VO);
static	VO		SetDefaultRegMidPath(VO);

//==============================================================================================================//
//	起動時初期設定																								//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	AjcProfileInit(VO)
{
	BOOL	rc = FALSE;

	//----- INIファイルパス初期設定 ------------------------------------------------------//
	SetDefaultIniFilePath();
	//----- レジストリパス初期設定 -------------------------------------------------------//
	strcpy(RegRootPathA,  "Software\\AjrCstXX");
	wcscpy(RegRootPathW, L"Software\\AjrCstXX");
	SetDefaultRegMidPath();
	//----- バイナリデータ格納フォルダ初期化 ---------------------------------------------//
	AjcGetAppPathW(BinDataDirW, MAX_PATH);
	WideCharToMultiByte(CP_ACP, 0, BinDataDirW, -1, BinDataDirA, MAX_PATH, NULL, NULL);
	//	INI,REGアクセス用も初期化
	AjcSetIniBinDirW(BinDataDirW);
	AjcSetRegBinDirW(BinDataDirW);
	//----- プロファイル記録先情報退避／回復用スタックキュー生成 -------------------------//
	if ((hVQueStack = AjcVQueCreate(0, NULL)) != NULL) {
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	終了時後処理																								//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - エラー																					//
//==============================================================================================================//
VO		AjcProfileEnd (VO)
{
	//----- プロファイル記録先情報退避／回復用スタックキュー破棄 -------------------------//
	if (hVQueStack != NULL) {
		AjcVQueDelete(hVQueStack);
		hVQueStack = NULL;
	}
}


//==============================================================================================================//
//	プロファイルアクセス先設定																					//
//																												//
//	引　数	：	fRegistory	- 保存先の種別（FALSE : INIﾌｧｲﾙ，TRUE : ﾚｼﾞｽﾄﾘ）									//
//																												//
//	戻り値	：	保存先の種別（FALSE : INIﾌｧｲﾙ，TRUE : ﾚｼﾞｽﾄﾘ）													//
//				＝０：エラー																					//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcSetProfileIsRegistory(BOOL fRegistory)
{
	BOOL	rc = fToRegistory;

	AjcCloseRegFile();
	fToRegistory = (fRegistory != FALSE);
	return rc;
}
//==============================================================================================================//
//	プロファイルアクセス先取得																					//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	前回設定値																						//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcGetProfileIsRegistory(VO)
{
	BOOL	rc = fToRegistory;

	return rc;
}
//==============================================================================================================//
//	レジストリオプション設定																					//
//																												//
//	引　数：	fVolatileFlag	- レジストリキーを一時的なものにするか、恒久的に保存するかの指定				//
//									FALSE - レジストリキーを恒久的に保存する									//
//									TRUE  - レジストリキーを一時的に保存する（システム・シャットダウン時に消滅）//
//																												//
//	戻り値：	前回設定値																						//
//==============================================================================================================//
AJCEXPORT BOOL WINAPI	AjcSetRegOptionVolatile(BOOL fVolatileFlag)
{
	BOOL	rc = fVolatile;
	if (fVolatileFlag) fVolatile = TRUE;
	else			   fVolatile = FALSE;
	return rc;
}

//==============================================================================================================//
//	レジストリオプション取得																					//
//																												//
//	引　数：	なし																							//
//																												//
//	戻り値：	レジストリキーを一時的なものにするか、恒久的に保存するかの設定値								//
//					FALSE - レジストリキーを恒久的に保存する													//
//					TRUE  - レジストリキーを一時的に保存する（システム・シャットダウン時に消滅）				//
//==============================================================================================================//
AJCEXPORT BOOL WINAPI	AjcGetRegOptionVolatile(VO)
{
	return fVolatile;
}

//==============================================================================================================//
//	プロファイル・INIファイルパス設定																			//
//																												//
//	引　数	：	pPath	   - INIファイルパス名（NULLの場合は、デフォルト名設定）								//
//																												//
//	戻り値	：	≠０：生成された保存先パスの文字長																//
//				＝０：エラー																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	int		WINAPI	AjcSetIniFilePathA(C_BCP pPath)
{
	int		rc = 0;

	if (pPath != NULL) {
		AjcSnPrintFA(IniFilePathA, AJCMAX_REGPATH, "%s", pPath);
		MultiByteToWideChar(CP_ACP, 0, IniFilePathA, -1, IniFilePathW, MAX_PATH);
		rc = (int)strlen(IniFilePathA);
	}
	else {
		SetDefaultIniFilePath();
		rc = (int)strlen(IniFilePathA);
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	int		WINAPI	AjcSetIniFilePathW(C_WCP pPath)
{
	int		rc = 0;

	if (pPath != NULL) {
		AjcSnPrintFW(IniFilePathW, AJCMAX_REGPATH, L"%s", pPath);
		WideCharToMultiByte(CP_ACP, 0, IniFilePathW, -1, IniFilePathA, MAX_PATH, NULL, NULL);
		rc = (int)wcslen(IniFilePathW);
	}
	else {
		SetDefaultIniFilePath();
		rc = (int)wcslen(IniFilePathW);
	}
	return rc;
}
//==============================================================================================================//
//	プロファイル（INIファイルパス）取得																			//
//																												//
//	引　数	：	pBuf	- INIファイルパスパス名を格納するバッファのアドレス										//
//				lBuf	- INIファイルパスパス名を格納するバッファの文字数										//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	int		WINAPI	AjcGetIniFilePathA(BCP pBuf, int lBuf)
{
	if (pBuf != NULL  &&  lBuf > 0) {
		strncpy(pBuf, IniFilePathA, lBuf - 1);
		pBuf[lBuf - 1] = 0;
	}
	return (int)strlen(IniFilePathA);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	int		WINAPI	AjcGetIniFilePathW(WCP pBuf, int lBuf)
{
	if (pBuf != NULL  &&  lBuf > 0) {
		wcsncpy(pBuf, IniFilePathW, lBuf - 1);
		pBuf[lBuf - 1] = 0;
	}
	return (int)wcslen(IniFilePathW);
}
//==============================================================================================================//
//	レジストリ・ルートパス名設定																				//
//																												//
//	引　数：	pRootPath	- レジストリ・ルートパス名文字列のアドレス（現文字長を取得する場合はNULL)			//
//																												//
//	戻り値：	ルートパス名の文字長																			//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	int	WINAPI	AjcSetRegRootPathA	   (C_BCP pRootPath)
{
	if (pRootPath != NULL) {
		//	ルートパス設定
		AjcSnPrintFA(RegRootPathA, AJCTSIZE(RegRootPathA), "%s", pRootPath);
		MultiByteToWideChar(CP_ACP, 0, RegRootPathA, -1, RegRootPathW, AJCMAX_REGPATH);
		//	レジストリパス設定
		AjcSnPrintFA(RegFilePathA, AJCMAX_REGPATH, "%s", RegRootPathA);
		AjcPathCatA(RegFilePathA, RegMidPathA, AJCMAX_REGPATH);
		MultiByteToWideChar(CP_ACP, 0, RegFilePathA, -1, RegFilePathW, AJCMAX_REGPATH);
	}
	return (int)strlen(RegRootPathA);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	int	WINAPI	AjcSetRegRootPathW	   (C_WCP pRootPath)
{
	if (pRootPath != NULL) {
		//	ルートパス設定
		AjcSnPrintFW(RegRootPathW, AJCTSIZE(RegRootPathW), L"%s", pRootPath);
		WideCharToMultiByte(CP_ACP, 0, RegRootPathW, -1, RegRootPathA, AJCMAX_REGPATH, NULL, NULL);
		//	レジストリパス設定
		AjcSnPrintFW(RegFilePathW, AJCMAX_REGPATH, L"%s", RegRootPathW);
		AjcPathCatW(RegFilePathW, RegMidPathW, AJCMAX_REGPATH);
		WideCharToMultiByte(CP_ACP, 0, RegFilePathW, -1, RegFilePathA, AJCMAX_REGPATH, NULL, NULL);
	}
	return (int)wcslen(RegRootPathW);
}
//==============================================================================================================//
//	レジストリ・ルートパス名取得																				//
//																												//
//	引　数：	pRootPath	- レジストリ・ルートパス名文字列のアドレス											//
//																												//
//	戻り値：	ルートパス名の文字長																			//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	int		WINAPI	AjcGetRegRootPathA(BCP pBuf, UI lBuf)
{
	if (pBuf != NULL) {
		AjcSnPrintFA(pBuf, lBuf, "%s", RegRootPathA);
	}
	return (int)strlen(RegRootPathA);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	int		WINAPI	AjcGetRegRootPathW(WCP pBuf, UI lBuf)
{
	if (pBuf != NULL) {
		AjcSnPrintFW(pBuf, lBuf, L"%s", RegRootPathW);
	}
	return (int)wcslen(RegRootPathW);
}
//==============================================================================================================//
//	レジストリ・ミドルパス設定																					//
//																												//
//	引　数	：	pPath	   - ミドルパス名（NULLの場合は、デフォルト名設定）										//
//																												//
//	戻り値	：	ミドルパス名の文字長																			//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	int		WINAPI	AjcSetRegMidPathA(C_BCP pPath)
{
	int		rc = 0;

	if (pPath != NULL) {
		//	ミドルパス設定
		strncpy(RegMidPathA, pPath, AJCMAX_REGPATH - 1);
		RegMidPathA[AJCMAX_REGPATH - 1] = 0;
		MultiByteToWideChar(CP_ACP, 0, RegMidPathA, -1, RegMidPathW, AJCMAX_REGPATH);
		//	レジストリパス設定
		AjcSnPrintFA(RegFilePathA, AJCMAX_REGPATH, "%s\\%s", RegRootPathA, pPath);
		MultiByteToWideChar(CP_ACP, 0, RegFilePathA, -1, RegFilePathW, AJCMAX_REGPATH);
		rc = (int)strlen(RegMidPathA);
	}
	else {
		SetDefaultRegMidPath();
		AjcCloseRegFile();
		rc = (int)strlen(RegMidPathA);
	}

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	int		WINAPI	AjcSetRegMidPathW(C_WCP pPath)
{
	int		rc = 0;

	if (pPath != NULL) {
		//	ミドルパス設定
		wcsncpy(RegMidPathW, pPath, AJCMAX_REGPATH - 1);
		WideCharToMultiByte(CP_ACP, 0, RegMidPathW, -1, RegMidPathA, AJCMAX_REGPATH, NULL, NULL);
		RegMidPathW[AJCMAX_REGPATH - 1] = 0;
		//	レジストリパス設定
		AjcSnPrintFW(RegFilePathW, AJCMAX_REGPATH, L"%s\\%s", RegRootPathW, pPath);
		WideCharToMultiByte(CP_ACP, 0, RegFilePathW, -1, RegFilePathA, AJCMAX_REGPATH, NULL, NULL);
		rc = (int)wcslen(RegMidPathW);
	}
	else {
		SetDefaultRegMidPath();
		AjcCloseRegFile();
		rc = (int)wcslen(RegMidPathW);
	}

	return rc;
}
//==============================================================================================================//
//	レジストリ・ミドルパス取得																					//
//																												//
//	引　数	：	pBuf	- ミドルパス名を格納するバッファのアドレス												//
//				lBuf	- ミドルパス名を格納するバッファの文字数												//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	int		WINAPI	AjcGetRegMidPathA(BCP pBuf, int lBuf)
{
	if (pBuf != NULL  &&  lBuf > 0) {
		strncpy(pBuf, RegMidPathA, lBuf - 1);
		pBuf[lBuf - 1] = 0;
	}
	return (int)strlen(RegMidPathA);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	int		WINAPI	AjcGetRegMidPathW(WCP pBuf, int lBuf)
{
	if (pBuf != NULL  &&  lBuf > 0) {
		wcsncpy(pBuf, RegMidPathW, lBuf - 1);
		pBuf[lBuf - 1] = 0;
	}
	return (int)wcslen(RegMidPathW);
}
//==============================================================================================================//
//	プロファイルパス（INIファイルパス／ミドルパス）設定															//
//																												//
//	引　数	：	pPath	   - プロファイル保存先のパス名（NULLの場合は、デフォルト名設定）						//
//																												//
//	戻り値	：	≠０：生成された保存先パスの文字長																//
//				＝０：エラー																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	int		WINAPI	AjcSetProfilePathA(C_BCP pPath)
{
	int		rc = 0;

	if (fToRegistory) rc = AjcSetRegMidPathA (pPath);
	else			  rc = AjcSetIniFilePathA(pPath);

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	int		WINAPI	AjcSetProfilePathW(C_WCP pPath)
{
	int		rc = 0;

	if (fToRegistory) rc = AjcSetRegMidPathW (pPath);
	else			  rc = AjcSetIniFilePathW(pPath);

	return rc;
}
//==============================================================================================================//
//	プロファイルアクセス先とパス名取得																			//
//																												//
//	引　数	：	pBuf	- プロファイル保存先のパス名を格納するバッファのアドレス								//
//				lBuf	- プロファイル保存先のパス名を格納するバッファの文字数									//
//																												//
//	戻り値	：	プロファイル保存先情報		TRUE  - レジストリ													//
//											FALSE - ＩＮＩファイル												//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcGetProfilePathA(BCP pBuf, int lBuf)
{
	if (pBuf != NULL  &&  lBuf > 0) {
		if (fToRegistory) strncpy(pBuf, RegFilePathA, lBuf - 1);
		else			  strncpy(pBuf, IniFilePathA, lBuf - 1);
		pBuf[lBuf - 1] = 0;
	}
	return fToRegistory;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcGetProfilePathW(WCP pBuf, int lBuf)
{
	if (pBuf != NULL  &&  lBuf > 0) {
		if (fToRegistory) wcsncpy(pBuf, RegFilePathW, lBuf - 1);
		else			  wcsncpy(pBuf, IniFilePathW, lBuf - 1);
		pBuf[lBuf - 1] = 0;
	}
	return fToRegistory;
}

//==============================================================================================================//
//	バイナリデータ格納ディレクトリパス設定																		//
//																												//
//	引　数	：	pBinDir	   - バイナリデータ格納ディレクトリパス（NULLの場合は、保存先解除）						//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	VO		WINAPI	AjcSetBinDataDirA(C_BCP pBinDir)
{
	if (pBinDir != NULL && *pBinDir != 0) {
		AjcSnPrintFA(BinDataDirA, MAX_PATH, "%s", pBinDir);
		AjcPathCatA(BinDataDirA, "", MAX_PATH);
		BinDataDirA[MAX_PATH - 1] = 0;
	}
	else {
		AjcGetAppPathA(BinDataDirA, MAX_PATH);
	}
	MultiByteToWideChar(CP_ACP, 0, BinDataDirA, -1, BinDataDirW, MAX_PATH);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	VO		WINAPI	AjcSetBinDataDirW(C_WCP pBinDir)
{
	if (pBinDir != NULL && *pBinDir != 0) {
		AjcSnPrintFW(BinDataDirW, MAX_PATH, L"%s", pBinDir);
		AjcPathCatW(BinDataDirW, L"", MAX_PATH);
		BinDataDirW[MAX_PATH - 1] = 0;
	}
	else {
		AjcGetAppPathW(BinDataDirW, MAX_PATH);
	}
	WideCharToMultiByte(CP_ACP, 0, BinDataDirW, -1, BinDataDirA, MAX_PATH, NULL, NULL);
}
//==============================================================================================================//
//	バイナリデータ格納ディレクトリパス取得																		//
//																												//
//	引　数	：	pBuf	- バイナリデータ格納ディレクトリパスを格納するバッファのアドレス						//
//				lBuf	- バイナリデータ格納ディレクトリパスを格納するバッファの文字数							//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	VO		WINAPI	AjcGetBinDataDirA(BCP pBuf, UI lBuf)
{
	if (pBuf != NULL  &&  lBuf > 0) {
		AjcSnPrintFA(pBuf, lBuf, "%s", BinDataDirA);
	}
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	VO		WINAPI	AjcGetBinDataDirW(WCP pBuf, UI lBuf)
{
	if (pBuf != NULL  &&  lBuf > 0) {
		AjcSnPrintFW(pBuf, lBuf, L"%s", BinDataDirW);
	}
}
/****************************************************************************************************************/
/*																												*/
/*	プロファイル記録先の退避																					*/
/*																												*/
/****************************************************************************************************************/
//==============================================================================================================//
//	プロファイル記録先情報の退避																				//
//																												//
//	引　数	：	pBuf	- バイナリデータ格納ディレクトリパスを格納するバッファのアドレス						//
//				lBuf	- バイナリデータ格納ディレクトリパスを格納するバッファの文字数							//
//																												//
//	戻り値	：	プロファイル記録先の退避数																		//
//==============================================================================================================//
AJCEXPORT	UI		WINAPI	AjcPushProfileStack(VO)
{
	UI		rc = 0;
	WC		txt[MAX_PATH * 2 + AJCMAX_REGPATH * 3];

	AjcSnPrintFW(txt, AJCTSIZE(txt), L"%d;%d;%s;%s;%s;%s;%s;", (fToRegistory != 0), (fVolatile != 0),
					 IniFilePathW, RegFilePathW, RegRootPathW, RegMidPathW, BinDataDirW);
	if (AjcVQueEnque(hVQueStack, (C_VOP)txt, (UI)wcslen(txt) * 2 + 1)) {
		rc = AjcVQueGetCount(hVQueStack);
	}

	return rc;
}
//==============================================================================================================//
//	プロファイル記録先情報の回復																				//
//																												//
//	引　数	：	pBuf	- バイナリデータ格納ディレクトリパスを格納するバッファのアドレス						//
//				lBuf	- バイナリデータ格納ディレクトリパスを格納するバッファの文字数							//
//																												//
//	戻り値	：	プロファイル記録先の退避数																		//
//==============================================================================================================//
AJCEXPORT	UI		WINAPI	AjcPopProfileStack(VO)
{
	UI		rc = 0;
	WCP		p;
	WC		txt[MAX_PATH * 2 + AJCMAX_REGPATH * 3];

	if (AjcVQueDequeEx(hVQueStack, (VOP)txt, AJCTSIZE(txt) * 2) != -1) {
		if (p = MAjcStrTok(txt , L";")) fToRegistory	= _wtoi(p);
		if (p = MAjcStrTok(NULL, L";")) fVolatile		= _wtoi(p);
		if (p = MAjcStrTok(NULL, L";")) AjcSnPrintFW(IniFilePathW, MAX_PATH 	 , L"%s", p);
		if (p = MAjcStrTok(NULL, L";")) AjcSnPrintFW(RegFilePathW, AJCMAX_REGPATH, L"%s", p);
		if (p = MAjcStrTok(NULL, L";")) AjcSnPrintFW(RegRootPathW, AJCMAX_REGPATH, L"%s", p);
		if (p = MAjcStrTok(NULL, L";")) AjcSnPrintFW(RegMidPathW , AJCMAX_REGPATH, L"%s", p);
		if (p = MAjcStrTok(NULL, L";")) AjcSnPrintFW(BinDataDirW , MAX_PATH 	 , L"%s", p);
		WideCharToMultiByte(CP_ACP, 0, IniFilePathW, -1, IniFilePathA, MAX_PATH 	 , NULL, NULL);
		WideCharToMultiByte(CP_ACP, 0, RegFilePathW, -1, RegFilePathA, AJCMAX_REGPATH, NULL, NULL);
		WideCharToMultiByte(CP_ACP, 0, RegRootPathW, -1, RegRootPathA, AJCMAX_REGPATH, NULL, NULL);
		WideCharToMultiByte(CP_ACP, 0, RegMidPathW , -1, RegMidPathA , AJCMAX_REGPATH, NULL, NULL);
		WideCharToMultiByte(CP_ACP, 0, BinDataDirW , -1, BinDataDirA , MAX_PATH 	 , NULL, NULL);
		rc = AjcVQueGetCount(hVQueStack);
	}

	return rc;
}
//==============================================================================================================//
//	プロファイル記録先情報のリセット																			//
//																												//
//	引　数	：	pBuf	- バイナリデータ格納ディレクトリパスを格納するバッファのアドレス						//
//				lBuf	- バイナリデータ格納ディレクトリパスを格納するバッファの文字数							//
//																												//
//	戻り値	：	プロファイル記録先の退避数																		//
//==============================================================================================================//
AJCEXPORT	UI		WINAPI	AjcResetProfileStack(VO)
{
	UI		rc = 0;

	AjcVQuePurge(hVQueStack);
	rc = AjcVQueGetCount(hVQueStack);

	return rc;
}
/****************************************************************************************************************/
/*																												*/
/*	プロファイル読み出し																						*/
/*																												*/
/****************************************************************************************************************/
//==============================================================================================================//
//	プロファイル読み出し（数値）																				//
//																												//
//	引　数：	pSecName	- セクション名のアドレス															//
//				pKeyName	- キー名のアドレス																	//
//				defValue	- デフォルト値																		//
//																												//
//	戻り値：	プロファイルから読み出した当該キー値／デフォルト値												//
//==============================================================================================================//
#define	M_GSGETPROFILENUM(_AW_, _PT_, _T1_, _T2_)																\
AJCEXPORT _T1_	WINAPI AjcGetProfile##_T2_##_AW_(C_##_PT_ pSecName, C_##_PT_ pKeyName, _T1_ defValue)			\
{	_T1_	rc = defValue;																						\
	if (pSecName != NULL && pKeyName != NULL) {																	\
		if (fToRegistory && RegFilePath##_AW_[0] != 0 || !fToRegistory && IniFilePath##_AW_[0] != 0) {			\
			if (fToRegistory) rc = AjcGetRegFile##_T2_##_AW_(RegFilePath##_AW_, pSecName, pKeyName, defValue);	\
			else			  rc = AjcGetIniFile##_T2_##_AW_(IniFilePath##_AW_, pSecName, pKeyName, defValue);	\
		}																										\
		else rc = defValue;																						\
	}																											\
	return rc;																									\
}
M_GSGETPROFILENUM(A, BCP, UI	, UInt)
M_GSGETPROFILENUM(A, BCP, SI	, SInt)
M_GSGETPROFILENUM(A, BCP, UI	, Hex )
M_GSGETPROFILENUM(A, BCP, double, Real)
M_GSGETPROFILENUM(A, BCP, ULL	, UI64)
M_GSGETPROFILENUM(A, BCP, SLL	, SI64)
M_GSGETPROFILENUM(A, BCP, ULL	, H64 )

M_GSGETPROFILENUM(W, WCP, UI	, UInt)
M_GSGETPROFILENUM(W, WCP, SI	, SInt)
M_GSGETPROFILENUM(W, WCP, UI	, Hex )
M_GSGETPROFILENUM(W, WCP, double, Real)
M_GSGETPROFILENUM(W, WCP, ULL	, UI64)
M_GSGETPROFILENUM(W, WCP, SLL	, SI64)
M_GSGETPROFILENUM(W, WCP, ULL	, H64 )

//==============================================================================================================//
//	プロファイル読み出し（配列）																				//
//																												//
//	引　数：	pSecName	- セクション名のアドレス															//
//				pKeyName	- キー名のアドレス																	//
//				pArray		- 読み出した値を格納する整数配列のアドレス											//
//				lArray		- 整数配列の要素サイズ（１，２，４ or ８）											//
//				nArray		- 整数配列の要素数																	//
//																												//
//	戻り値：	プロファイルから読み出した整数値の個数															//
//==============================================================================================================//
#define	M_GSGETPROFILEARR(_AW_, _PT_)																			\
AJCEXPORT UI	WINAPI AjcGetProfileArr##_AW_(C_##_PT_ pSec, C_##_PT_ pKey, VOP pArr, UI lArr, UI nArr)			\
{	UI		rc = 0;																								\
	if (pSec != NULL && pKey != NULL && pArr != NULL) {															\
		if (fToRegistory && RegFilePath##_AW_[0] != 0 || !fToRegistory && IniFilePath##_AW_[0] != 0) {			\
			if (fToRegistory) rc = AjcGetRegFileArr##_AW_(RegFilePath##_AW_, pSec, pKey, pArr, lArr, nArr);		\
			else			  rc = AjcGetIniFileArr##_AW_(IniFilePath##_AW_, pSec, pKey, pArr, lArr, nArr);		\
		}																										\
	}																											\
	return rc;																									\
}
M_GSGETPROFILEARR(A, BCP)
M_GSGETPROFILEARR(W, WCP)


//==============================================================================================================//
//	プロファイル読み出し（文字列）																				//
//																												//
//	引　数：	pSecName	- セクション名のアドレス															//
//				pKeyName	- キー名のアドレス																	//
//				pDefStr		- デフォルト値																		//
//				pBuf		- 読み出した文字列を格納するバッファのアドレス										//
//				lBuf		- 読み出した文字列を格納するバッファのバイト数／文字数								//
//																												//
//	戻り値：	プロファイルから読み出した文字列の文字数														//
//==============================================================================================================//
#define	M_GSGETPROFILESTR(_AW_, _PT_)																			\
AJCEXPORT UI	WINAPI AjcGetProfileStr##_AW_(C_##_PT_ pSec, C_##_PT_ pKey, C_##_PT_ pDef, _PT_ pBuf, UI lBuf)	\
{	UI		rc = 0;																								\
	if (pSec != NULL && pKey != NULL) {																			\
		if (fToRegistory && RegFilePath##_AW_[0] != 0 || !fToRegistory && IniFilePath##_AW_[0] != 0) {			\
			if (fToRegistory) rc = AjcGetRegFileStr##_AW_(RegFilePath##_AW_, pSec, pKey, pDef, pBuf, lBuf);		\
			else			  rc = AjcGetIniFileStr##_AW_(IniFilePath##_AW_, pSec, pKey, pDef, pBuf, lBuf);		\
		}																										\
	}																											\
	return rc;																									\
}
M_GSGETPROFILESTR(A, BCP)
M_GSGETPROFILESTR(W, WCP)

//==============================================================================================================//
//	プロファイル読み出し（バイナリデータ）																		//
//																												//
//	引　数：	pSecName	- セクション名のアドレス															//
//				pKeyName	- キー名のアドレス																	//
//				pBuf		- 読み出したバイナリデータを格納するバッファのアドレス								//
//				lBuf		- 読み出したバイナリデータを格納するバッファのバイト数								//
//																												//
//	戻り値：	プロファイルから読み出したバイナリデータのバイト数												//
//==============================================================================================================//
#define	M_GSGETPROFILEBIN(_AW_, _PT_)																						\
AJCEXPORT UI	WINAPI AjcGetProfileBin##_AW_(C_##_PT_ pSec, C_##_PT_ pKey, VOP pBuf, UI lBuf)								\
{	UI		rc = 0;																											\
	if (pSec != NULL && pKey != NULL && pBuf != NULL && lBuf > 0) {															\
		if (fToRegistory && RegFilePath##_AW_[0] != 0 || !fToRegistory && IniFilePath##_AW_[0] != 0) {						\
			if (fToRegistory) rc = AjcGetRegFileBinEx##_AW_(RegFilePath##_AW_, pSec, pKey, pBuf, lBuf, BinDataDir##_AW_);	\
			else			  rc = AjcGetIniFileBinEx##_AW_(IniFilePath##_AW_, pSec, pKey, pBuf, lBuf, BinDataDir##_AW_);	\
		}																													\
	}																														\
	return rc;																												\
}
M_GSGETPROFILEBIN(A, BCP)
M_GSGETPROFILEBIN(W, WCP)

//==============================================================================================================//
//	プロファイル読み出し（フォント情報）																		//
//																												//
//	引　数：	pSecName	- セクション名のアドレス															//
//				pKeyName	- キー名のアドレス																	//
//				pBuf		- 読み出したフォント情報を格納するバッファのアドレス								//
//																												//
//	戻り値：													//
//==============================================================================================================//
//----- キー名生成 ---------------------------------------------------------------------------------------------//
#define			MKKEY(TAIL)		MkKey(szKey, TAIL, pKeyPrefix, AJCTSIZE(szKey))
static	C_WCP	MkKey(WCP pKeyBuf, C_WCP pTail, C_WCP pKeyPrefix, UI lKeyBuf)
{
	AjcSnPrintF(pKeyBuf, lKeyBuf, L"%s%s", pKeyPrefix, pTail);
	return	pKeyBuf;
}
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	WINAPI AjcGetProfileLogFontA(C_BCP pSecName, C_BCP pKeyPrefix, LPLOGFONTA pBuf)
{
	BOOL		rc = FALSE;
	WCP			pSecNameW	= NULL;
	WCP			pKeyPrefixW	= NULL;	
	LPLOGFONTW	pBufW		= NULL;	
	UI			lSecNameW, lKeyPrefixW;

	if (pSecName != NULL && pKeyPrefix != NULL && pBuf != NULL) {
		do {
			//	セクション名をワイド文字化
			if (pSecNameW		= AjcTAllocW(lSecNameW	 = MultiByteToWideChar(CP_ACP, 0, pSecName	, -1, NULL, 0))) {
				MultiByteToWideChar(CP_ACP, 0, pSecName  , -1, pSecNameW , lSecNameW);
			}
			else break;
			//	キープリフィックスをワイド文字化
			if (pKeyPrefixW 	= AjcTAllocW(lKeyPrefixW = MultiByteToWideChar(CP_ACP, 0, pKeyPrefix, -1, NULL, 0))) {
				MultiByteToWideChar(CP_ACP, 0, pKeyPrefix, -1, pKeyPrefixW, lKeyPrefixW);
			}
			else break;
			//	フォント名をワイド文字化
			if (pBufW = (LPLOGFONTW)malloc(sizeof(LOGFONTW))) {
				memcpy(pBufW, pBuf, sizeof(LOGFONTA));
				MultiByteToWideChar(CP_ACP, 0, pBuf->lfFaceName, -1, pBufW->lfFaceName, AJCTSIZE(pBufW->lfFaceName));
			}
			else break;
			//	プロファイルから読み出し
			if (rc = AjcGetProfileLogFontW(pSecNameW, pKeyPrefixW, pBufW)) {
				if (pBuf != NULL) {
					memcpy(pBuf, pBufW, sizeof(LOGFONTA));
					WideCharToMultiByte(CP_ACP, 0, pBufW->lfFaceName, -1, pBuf->lfFaceName, AJCTSIZE(pBuf->lfFaceName), NULL, NULL);
				}
			}
		} while(0);
	}
	//	メモリ開放
	if (pSecNameW	!= NULL) free(pSecNameW	 );
	if (pKeyPrefixW != NULL) free(pKeyPrefixW);
	if (pBufW		!= NULL) free(pBufW		 );

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	WINAPI AjcGetProfileLogFontW(C_WCP pSecName, C_WCP pKeyPrefix, LPLOGFONTW pBuf)
{
	BOOL	rc = FALSE;
	WC		szKey[256];

	if (pSecName != NULL && pKeyPrefix != NULL && pBuf != NULL) {
		if (fToRegistory && RegFilePathA[0] != 0 || !fToRegistory && IniFilePathA != 0) {
			if (fToRegistory) {
				pBuf->lfHeight			= AjcGetRegFileSIntW(RegFilePathW, pSecName, MKKEY(L"lfHeight"		  ), pBuf->lfHeight		   );
				pBuf->lfWidth			= AjcGetRegFileUIntW(RegFilePathW, pSecName, MKKEY(L"lfWidth" 		  ), pBuf->lfWidth		   );
				pBuf->lfEscapement		= AjcGetRegFileUIntW(RegFilePathW, pSecName, MKKEY(L"lfEscapement"	  ), pBuf->lfEscapement	   );
				pBuf->lfOrientation		= AjcGetRegFileUIntW(RegFilePathW, pSecName, MKKEY(L"lfOrientation"	  ), pBuf->lfOrientation   );
				pBuf->lfWeight			= AjcGetRegFileUIntW(RegFilePathW, pSecName, MKKEY(L"lfWeight"		  ), pBuf->lfWeight		   );
				pBuf->lfItalic			= AjcGetRegFileUIntW(RegFilePathW, pSecName, MKKEY(L"lfItalic"		  ), pBuf->lfItalic		   );
				pBuf->lfUnderline		= AjcGetRegFileUIntW(RegFilePathW, pSecName, MKKEY(L"lfUnderline" 	  ), pBuf->lfUnderline	   );
				pBuf->lfStrikeOut		= AjcGetRegFileUIntW(RegFilePathW, pSecName, MKKEY(L"lfStrikeOut" 	  ), pBuf->lfStrikeOut	   );
				pBuf->lfCharSet			= AjcGetRegFileUIntW(RegFilePathW, pSecName, MKKEY(L"lfCharSet"		  ), pBuf->lfCharSet	   );
				pBuf->lfOutPrecision	= AjcGetRegFileUIntW(RegFilePathW, pSecName, MKKEY(L"lfOutPrecision"  ), pBuf->lfOutPrecision  );
				pBuf->lfClipPrecision	= AjcGetRegFileUIntW(RegFilePathW, pSecName, MKKEY(L"lfClipPrecision" ), pBuf->lfClipPrecision );
				pBuf->lfQuality			= AjcGetRegFileUIntW(RegFilePathW, pSecName, MKKEY(L"lfQuality"		  ), pBuf->lfQuality	   );
				pBuf->lfPitchAndFamily	= AjcGetRegFileUIntW(RegFilePathW, pSecName, MKKEY(L"lfPitchAndFamily"), pBuf->lfPitchAndFamily);
				AjcGetRegFileStrW(RegFilePathW, pSecName, MKKEY(L"lfFaceName"), pBuf->lfFaceName, pBuf->lfFaceName, AJCTSIZE(pBuf->lfFaceName));
			}
			else {
				pBuf->lfHeight			= AjcGetIniFileSIntW(IniFilePathW, pSecName, MKKEY(L"lfHeight"		  ), pBuf->lfHeight		   );
				pBuf->lfWidth			= AjcGetIniFileUIntW(IniFilePathW, pSecName, MKKEY(L"lfWidth" 		  ), pBuf->lfWidth		   );
				pBuf->lfEscapement		= AjcGetIniFileUIntW(IniFilePathW, pSecName, MKKEY(L"lfEscapement"	  ), pBuf->lfEscapement	   );
				pBuf->lfOrientation		= AjcGetIniFileUIntW(IniFilePathW, pSecName, MKKEY(L"lfOrientation"	  ), pBuf->lfOrientation   );
				pBuf->lfWeight			= AjcGetIniFileUIntW(IniFilePathW, pSecName, MKKEY(L"lfWeight"		  ), pBuf->lfWeight		   );
				pBuf->lfItalic			= AjcGetIniFileUIntW(IniFilePathW, pSecName, MKKEY(L"lfItalic"		  ), pBuf->lfItalic		   );
				pBuf->lfUnderline		= AjcGetIniFileUIntW(IniFilePathW, pSecName, MKKEY(L"lfUnderline" 	  ), pBuf->lfUnderline	   );
				pBuf->lfStrikeOut		= AjcGetIniFileUIntW(IniFilePathW, pSecName, MKKEY(L"lfStrikeOut" 	  ), pBuf->lfStrikeOut	   );
				pBuf->lfCharSet			= AjcGetIniFileUIntW(IniFilePathW, pSecName, MKKEY(L"lfCharSet"		  ), pBuf->lfCharSet	   );
				pBuf->lfOutPrecision	= AjcGetIniFileUIntW(IniFilePathW, pSecName, MKKEY(L"lfOutPrecision"  ), pBuf->lfOutPrecision  );
				pBuf->lfClipPrecision	= AjcGetIniFileUIntW(IniFilePathW, pSecName, MKKEY(L"lfClipPrecision" ), pBuf->lfClipPrecision );
				pBuf->lfQuality			= AjcGetIniFileUIntW(IniFilePathW, pSecName, MKKEY(L"lfQuality"		  ), pBuf->lfQuality	   );
				pBuf->lfPitchAndFamily	= AjcGetIniFileUIntW(IniFilePathW, pSecName, MKKEY(L"lfPitchAndFamily"), pBuf->lfPitchAndFamily);
				AjcGetIniFileStrW(IniFilePathW, pSecName, MKKEY(L"lfFaceName"), pBuf->lfFaceName, pBuf->lfFaceName, AJCTSIZE(pBuf->lfFaceName));
			}
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	プロファイル読み出し（フォントオブジェクト）																//
//																												//
//	引　数：	pSecName	- セクション名のアドレス															//
//				pKeyName	- キー名のアドレス																	//
//				hFont		- 書き込むフォントのハンドル														//
//																												//
//	戻り値：	≠NULL : フォントハンドル																		//
//				＝NULL : エラー																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	HFONT		WINAPI	AjcGetProfileFontObjA(C_BCP pSecName, C_BCP pKeyPrefix)
{
	HFONT		rc = NULL;
	LOGFONTA	lf;

	if (AjcGetProfileLogFontA(pSecName, pKeyPrefix, &lf)) {
		rc = CreateFontIndirectA(&lf);
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	HFONT		WINAPI	AjcGetProfileFontObjW(C_WCP pSecName, C_WCP pKeyPrefix)
{
	HFONT		rc = NULL;
	LOGFONTW	lf;

	if (AjcGetProfileLogFontW(pSecName, pKeyPrefix, &lf)) {
		rc = CreateFontIndirectW(&lf);
	}
	return rc;
}

/****************************************************************************************************************/
/*																												*/
/*	プロファイル書き込み																						*/
/*																												*/
/****************************************************************************************************************/
//==============================================================================================================//
//	プロファイル書き込み（数値，文字列）																		//
//																												//
//	引　数：	pSecName	- セクション名のアドレス															//
//				pKeyName	- キー名のアドレス																	//
//				Value		- 書き込み値																		//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - エラー																					//
//==============================================================================================================//
#define	M_GSPUTPROFILENUM(_AW_, _PT_, _T1_, _T2_)																		\
AJCEXPORT BOOL	WINAPI AjcPutProfile##_T2_##_AW_(C_##_PT_ pSecName, C_##_PT_ pKeyName, _T1_ Value)						\
{	BOOL	rc = 0;																										\
	if (pSecName != NULL && pKeyName != NULL) {																			\
		if (fToRegistory && RegFilePath##_AW_[0] != 0 || !fToRegistory && IniFilePath##_AW_[0] != 0) {					\
			if (fToRegistory) rc = AjcPutRegFile##_T2_##_AW_(RegFilePath##_AW_, pSecName, pKeyName, fVolatile, Value);	\
			else			  rc = AjcPutIniFile##_T2_##_AW_(IniFilePath##_AW_, pSecName, pKeyName, Value);				\
		}																												\
	};																													\
	return rc;																											\
}
M_GSPUTPROFILENUM(A, BCP, UI	, UInt)
M_GSPUTPROFILENUM(A, BCP, SI	, SInt)
M_GSPUTPROFILENUM(A, BCP, UI	, Hex )
M_GSPUTPROFILENUM(A, BCP, double, Real)
M_GSPUTPROFILENUM(A, BCP, ULL	, UI64)
M_GSPUTPROFILENUM(A, BCP, SLL	, SI64)
M_GSPUTPROFILENUM(A, BCP, ULL	, H64 )
M_GSPUTPROFILENUM(A, BCP, C_BCP , Str )

M_GSPUTPROFILENUM(W, WCP, UI	, UInt)
M_GSPUTPROFILENUM(W, WCP, SI	, SInt)
M_GSPUTPROFILENUM(W, WCP, UI	, Hex )
M_GSPUTPROFILENUM(W, WCP, double, Real)
M_GSPUTPROFILENUM(W, WCP, ULL	, UI64)
M_GSPUTPROFILENUM(W, WCP, SLL	, SI64)
M_GSPUTPROFILENUM(W, WCP, ULL	, H64 )
M_GSPUTPROFILENUM(W, WCP, C_WCP , Str )


//==============================================================================================================//
//	プロファイル書き込み（配列）																				//
//																												//
//	引　数：	pSecName	- セクション名のアドレス															//
//				pKeyName	- キー名のアドレス																	//
//				pArray		- 書き込み値が格納された整数配列のアドレス											//
//				lArray		- 整数配列の要素サイズ（１，２ or ４）												//
//				nArray		- 整数配列の要素数																	//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - エラー																					//
//==============================================================================================================//
#define	M_GSPUTPROFILEARR(_AW_, _PT_)																					\
AJCEXPORT BOOL	WINAPI AjcPutProfileArr##_AW_(C_##_PT_ pSec, C_##_PT_ pKey, VOP pArr, UI lArr, UI nArr)					\
{	BOOL	rc = FALSE;																									\
	if (pSec != NULL && pKey != NULL && pArr != NULL) {																	\
		if (fToRegistory && RegFilePath##_AW_[0] != 0 || !fToRegistory && IniFilePath##_AW_[0] != 0) {					\
			if (fToRegistory) rc = AjcPutRegFileArr##_AW_(RegFilePath##_AW_, pSec, pKey, fVolatile, pArr, lArr, nArr);	\
			else			  rc = AjcPutIniFileArr##_AW_(IniFilePath##_AW_, pSec, pKey, pArr, lArr, nArr);				\
		}																												\
	}																													\
	return rc;																											\
}

M_GSPUTPROFILEARR(A, BCP)
M_GSPUTPROFILEARR(W, WCP)

//==============================================================================================================//
//	プロファイル書き込み（バイナリデータ）																		//
//																												//
//	引　数：	pSecName	- セクション名のアドレス															//
//				pKeyName	- キー名のアドレス																	//
//				pDat		- 書き込むバイナリデータのアドレス													//
//				lDat		- 書き込むバイナリデータのバイト数													//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - エラー																					//
//==============================================================================================================//
#define	M_GSPUTPROFILEBIN(_AW_, _PT_)																									\
AJCEXPORT BOOL	WINAPI AjcPutProfileBin##_AW_(C_##_PT_ pSec, C_##_PT_ pKey, C_VOP pDat, UI lDat)										\
{	BOOL	rc = FALSE;																													\
	if (pSec != NULL && pKey != NULL && pDat != NULL) {																					\
		if (fToRegistory && RegFilePath##_AW_[0] != 0 || !fToRegistory && IniFilePath##_AW_[0] != 0) {									\
			if (fToRegistory) rc = AjcPutRegFileBinEx##_AW_(RegFilePath##_AW_, pSec, pKey, fVolatile, pDat, lDat, BinDataDir##_AW_);	\
			else			  rc = AjcPutIniFileBinEx##_AW_(IniFilePath##_AW_, pSec, pKey, pDat, lDat			, BinDataDir##_AW_);	\
		}																																\
	}																																	\
	return rc;																															\
}
M_GSPUTPROFILEBIN(A, BCP)
M_GSPUTPROFILEBIN(W, WCP)
//==============================================================================================================//
//	プロファイル書き込み（フォント情報）																		//
//																												//
//	引　数：	pSecName	- セクション名のアドレス															//
//				pKeyName	- キー名のアドレス																	//
//				pLf			- 書き込むフォント情報のアドレス													//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - エラー																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcPutProfileLogFontA(C_BCP pSecName, C_BCP pKeyPrefix, const LOGFONTA *pLf)
{
	BOOL		rc = FALSE;
	WCP			pSecNameW	= NULL;
	WCP			pKeyPrefixW	= NULL;	
	LPLOGFONTW	pLfW		= NULL;	
	UI			lSecNameW, lKeyPrefixW;

	if (pSecName != NULL && pKeyPrefix != NULL && pLf != NULL) {
		do {
			//	セクション名をワイド文字化
			if (pSecNameW		= AjcTAllocW(lSecNameW	 = MultiByteToWideChar(CP_ACP, 0, pSecName	, -1, NULL, 0))) {
				MultiByteToWideChar(CP_ACP, 0, pSecName  , -1, pSecNameW , lSecNameW);
			}
			else break;
			//	キープリフィックスをワイド文字化
			if (pKeyPrefixW 	= AjcTAllocW(lKeyPrefixW = MultiByteToWideChar(CP_ACP, 0, pKeyPrefix, -1, NULL, 0))) {
				MultiByteToWideChar(CP_ACP, 0, pKeyPrefix, -1, pKeyPrefixW, lKeyPrefixW);
			}
			else break;
			//	フォント名をワイド文字化
			if (pLfW = (LPLOGFONTW)malloc(sizeof(LOGFONTW))) {
				memcpy(pLfW, pLf, sizeof(LOGFONTA));
				MultiByteToWideChar(CP_ACP, 0, pLf->lfFaceName, -1, pLfW->lfFaceName, AJCTSIZE(pLfW->lfFaceName));
			}
			else break;
			//	プロファイルへ書き込み
			rc = AjcPutProfileLogFontW(pSecNameW, pKeyPrefixW, pLfW);
		} while(0);
	}
	//	メモリ開放
	if (pSecNameW	!= NULL) free(pSecNameW	 );
	if (pKeyPrefixW != NULL) free(pKeyPrefixW);
	if (pLfW		!= NULL) free(pLfW		 );

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcPutProfileLogFontW(C_WCP pSecName, C_WCP pKeyPrefix, const LOGFONTW *pLf)
{
	BOOL		rc = FALSE;
	WC			szKey[256];

	if (pSecName != NULL && pKeyPrefix != NULL && pLf != NULL) {
		if (fToRegistory && RegFilePathA[0] != 0 || !fToRegistory && IniFilePathA != 0) {
			if (fToRegistory) {
				AjcPutRegFileSIntW(RegFilePathW, pSecName, MKKEY(L"lfHeight"		), fVolatile, pLf->lfHeight		   );
				AjcPutRegFileUIntW(RegFilePathW, pSecName, MKKEY(L"lfWidth" 		), fVolatile, pLf->lfWidth		   );
				AjcPutRegFileUIntW(RegFilePathW, pSecName, MKKEY(L"lfEscapement"	), fVolatile, pLf->lfEscapement	   );
				AjcPutRegFileUIntW(RegFilePathW, pSecName, MKKEY(L"lfOrientation"	), fVolatile, pLf->lfOrientation   );
				AjcPutRegFileUIntW(RegFilePathW, pSecName, MKKEY(L"lfWeight"		), fVolatile, pLf->lfWeight		   );
				AjcPutRegFileUIntW(RegFilePathW, pSecName, MKKEY(L"lfItalic"		), fVolatile, pLf->lfItalic		   );
				AjcPutRegFileUIntW(RegFilePathW, pSecName, MKKEY(L"lfUnderline" 	), fVolatile, pLf->lfUnderline	   );
				AjcPutRegFileUIntW(RegFilePathW, pSecName, MKKEY(L"lfStrikeOut" 	), fVolatile, pLf->lfStrikeOut	   );
				AjcPutRegFileUIntW(RegFilePathW, pSecName, MKKEY(L"lfCharSet"		), fVolatile, pLf->lfCharSet	   );
				AjcPutRegFileUIntW(RegFilePathW, pSecName, MKKEY(L"lfOutPrecision"	), fVolatile, pLf->lfOutPrecision  );
				AjcPutRegFileUIntW(RegFilePathW, pSecName, MKKEY(L"lfClipPrecision" ), fVolatile, pLf->lfClipPrecision );
				AjcPutRegFileUIntW(RegFilePathW, pSecName, MKKEY(L"lfQuality"		), fVolatile, pLf->lfQuality	   );
				AjcPutRegFileUIntW(RegFilePathW, pSecName, MKKEY(L"lfPitchAndFamily"), fVolatile, pLf->lfPitchAndFamily);
				AjcPutRegFileStrW (RegFilePathW, pSecName, MKKEY(L"lfFaceName"		), fVolatile, pLf->lfFaceName);
			}
			else {
				AjcPutIniFileSIntW(IniFilePathW, pSecName, MKKEY(L"lfHeight"		), pLf->lfHeight		);
				AjcPutIniFileUIntW(IniFilePathW, pSecName, MKKEY(L"lfWidth" 		), pLf->lfWidth			);
				AjcPutIniFileUIntW(IniFilePathW, pSecName, MKKEY(L"lfEscapement"	), pLf->lfEscapement	);
				AjcPutIniFileUIntW(IniFilePathW, pSecName, MKKEY(L"lfOrientation"	), pLf->lfOrientation 	);
				AjcPutIniFileUIntW(IniFilePathW, pSecName, MKKEY(L"lfWeight"		), pLf->lfWeight		);
				AjcPutIniFileUIntW(IniFilePathW, pSecName, MKKEY(L"lfItalic"		), pLf->lfItalic		);
				AjcPutIniFileUIntW(IniFilePathW, pSecName, MKKEY(L"lfUnderline" 	), pLf->lfUnderline		);
				AjcPutIniFileUIntW(IniFilePathW, pSecName, MKKEY(L"lfStrikeOut" 	), pLf->lfStrikeOut		);
				AjcPutIniFileUIntW(IniFilePathW, pSecName, MKKEY(L"lfCharSet"		), pLf->lfCharSet		);
				AjcPutIniFileUIntW(IniFilePathW, pSecName, MKKEY(L"lfOutPrecision"	), pLf->lfOutPrecision	);
				AjcPutIniFileUIntW(IniFilePathW, pSecName, MKKEY(L"lfClipPrecision" ), pLf->lfClipPrecision );
				AjcPutIniFileUIntW(IniFilePathW, pSecName, MKKEY(L"lfQuality"		), pLf->lfQuality		);
				AjcPutIniFileUIntW(IniFilePathW, pSecName, MKKEY(L"lfPitchAndFamily"), pLf->lfPitchAndFamily);
				AjcPutIniFileStrW (IniFilePathW, pSecName, MKKEY(L"lfFaceName"		), pLf->lfFaceName);
			}
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	プロファイル書き込み（フォントオブジェクト）																//
//																												//
//	引　数：	pSecName	- セクション名のアドレス															//
//				pKeyName	- キー名のアドレス																	//
//				hFont		- 書き込むフォントのハンドル														//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - エラー																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcPutProfileFontObjA(C_BCP pSecName, C_BCP pKeyPrefix, HFONT hFont)
{
	BOOL		rc = FALSE;
	LOGFONTA	lf;

	if (GetObjectA(hFont, sizeof(lf), &lf) == sizeof(lf)) {
		rc = AjcPutProfileLogFontA(pSecName, pKeyPrefix, &lf);
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcPutProfileFontObjW(C_WCP pSecName, C_WCP pKeyPrefix, HFONT hFont)
{
	BOOL		rc = FALSE;
	LOGFONTW	lf;

	if (GetObjectW(hFont, sizeof(lf), &lf) == sizeof(lf)) {
		rc = AjcPutProfileLogFontW(pSecName, pKeyPrefix, &lf);
	}
	return rc;
}
//==============================================================================================================//
//	プロファイルセクション削除																					//
//																												//
//	引　数：	pSecName	- セクション名のアドレス															//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - エラー																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcDelProfileSectA(C_BCP pSecName)
{
	BOOL	rc;

	if (fToRegistory) rc = AjcDelRegSectExA(RegFilePathA, pSecName, BinDataDirA);
	else			  rc = AjcDelIniSectExA(IniFilePathA, pSecName, BinDataDirA);

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcDelProfileSectW(C_WCP pSecName)
{
	BOOL	rc;

	if (fToRegistory) rc = AjcDelRegSectExW(RegFilePathW, pSecName, BinDataDirW);
	else			  rc = AjcDelIniSectExW(IniFilePathW, pSecName, BinDataDirW);

	return rc;
}

//==============================================================================================================//
//	プロファイルキー削除																						//
//																												//
//	引　数：	pSecName	- セクション名のアドレス															//
//				pKeyName	- キー名のアドレス																	//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - エラー																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcDelProfileKeyA (C_BCP pSecName, C_BCP pKeyName)
{
	BOOL	rc;

	if (fToRegistory) rc = AjcDelRegKeyExA(RegFilePathA, pSecName, pKeyName, BinDataDirA);
	else			  rc = AjcDelIniKeyExA(IniFilePathA, pSecName, pKeyName, BinDataDirA);

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcDelProfileKeyW (C_WCP pSecName, C_WCP pKeyName)
{
	BOOL	rc;

	if (fToRegistory) rc = AjcDelRegKeyExW(RegFilePathW, pSecName, pKeyName, BinDataDirW);
	else			  rc = AjcDelIniKeyExW(IniFilePathW, pSecName, pKeyName, BinDataDirW);

	return rc;
}
//==============================================================================================================//
//	プロファイル・セクション消去																				//
//																												//
//	引　数：	pSecName	- セクション名のアドレス															//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - エラー																					//
//==============================================================================================================//
//----- バイト文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcRemoveProfileSectA	  (C_BCP pSecName)
{
	BOOL	rc = FALSE;

	if (fToRegistory) rc = AjcRemoveRegSectA(RegFilePathA, pSecName);
	else			  rc = AjcDelIniSectA	(IniFilePathA, pSecName);

	return rc;
}
//----- ワイド文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcRemoveProfileSectW	  (C_WCP pSecName)
{
	BOOL	rc = FALSE;

	if (fToRegistory) rc = AjcRemoveRegSectW(RegFilePathW, pSecName);
	else			  rc = AjcDelIniSectW	(IniFilePathW, pSecName);

	return rc;
}
//==============================================================================================================//
//	プロファイル・セクションクリーンアップ																		//
//																												//
//	引　数：	pSecName	- セクション名のアドレス															//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - エラー																					//
//==============================================================================================================//
//----- バイト文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcCleanupProfileSectA	  (C_BCP pSecName)
{
	BOOL	rc = FALSE;

	if (fToRegistory) rc = AjcCleanupRegSectA(RegFilePathA, pSecName);
	else			  rc = AjcCleanupIniSectA(IniFilePathA, pSecName);

	return rc;
}
//----- ワイド文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcCleanupProfileSectW	  (C_WCP pSecName)
{
	BOOL	rc = FALSE;

	if (fToRegistory) rc = AjcCleanupRegSectW(RegFilePathW, pSecName);
	else			  rc = AjcCleanupIniSectW(IniFilePathW, pSecName);

	return rc;
}
//==============================================================================================================//
//	プロファイル・クローズ																						//
//																												//
//	引　数：	なし																							//
//																												//
//	戻り値：	なし																							//
//==============================================================================================================//
AJCEXPORT	VO		WINAPI	AjcCloseProfile (VO)
{
	if (fToRegistory) {
		AjcCloseRegFile();
	}
}
//==============================================================================================================//
//	プロファイル・セクション名収集																				//
//																												//
//	引　数：	pPath		- パス名のアドレス																	//
//																												//
//	戻り値：	収集したセクション名の個数																		//
//==============================================================================================================//
//----- バイト文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT	int		WINAPI	AjcEnumProfileSectA (UX cbp, BOOL (CALLBACK *cbEnumSect)(C_BCP pSect, UX cbp))
{
	int		rc = 0;

	if (cbEnumSect != NULL) {
		if (fToRegistory) rc = AjcEnumRegSectA(RegFilePathA, cbp, cbEnumSect);
		else			  rc = AjcEnumIniSectA(IniFilePathA, cbp, cbEnumSect);
	}
	return rc;
}
//----- ワイド文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT	int		WINAPI	AjcEnumProfileSectW (UX cbp, BOOL (CALLBACK *cbEnumSect)(C_WCP pSect, UX cbp))
{
	int		rc = 0;

	if (cbEnumSect != NULL) {
		if (fToRegistory) rc = AjcEnumRegSectW(RegFilePathW, cbp, cbEnumSect);
		else			  rc = AjcEnumIniSectW(IniFilePathW, cbp, cbEnumSect);
	}
	return rc;
}
//==============================================================================================================//
//	プロファイル・セクション名収集（上位セクション指定，レジストリ専用）										//
//																												//
//	引　数：	pSect		- 上位セクション名のアドレス														//
//				cbp			- コールバックパラメタ																//
//				cbEnumSect	- セクション名通知要コールバック													//
//																												//
//	戻り値：	収集したセクション名の個数																		//
//==============================================================================================================//
//----- バイト文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT	int		WINAPI	AjcEnumProfileRegSectA (C_BCP pSect, UX cbp, BOOL (CALLBACK *cbEnumSect)(C_BCP pSect, UX cbp))
{
	int		rc = 0;
	BC		path[MAX_PATH];

	if (cbEnumSect != NULL) {
		if (fToRegistory) {
			MAjcStrCpyA(path, MAX_PATH, RegFilePathA);
			if (pSect != NULL) {
				AjcPathCatA(path, pSect, MAX_PATH);
			}
			rc = AjcEnumRegSectA(path, cbp, cbEnumSect);
		}
	}
	return rc;
}
//----- ワイド文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT	int		WINAPI	AjcEnumProfileRegSectW (C_WCP pSect, UX cbp, BOOL (CALLBACK *cbEnumSect)(C_WCP pSect, UX cbp))
{
	int		rc = 0;
	WC		path[MAX_PATH];

	if (cbEnumSect != NULL) {
		if (fToRegistory) {
			MAjcStrCpyW(path, MAX_PATH, RegFilePathW);
			if (pSect != NULL) {
				AjcPathCatW(path, pSect, MAX_PATH);
			}
			rc = AjcEnumRegSectW(path, cbp, cbEnumSect);
		}
	}
	return rc;
}
//==============================================================================================================//
//	プロファイル・キー名収集																					//
//																												//
//	引　数：	pPath		- パス名のアドレス																	//
//																												//
//	戻り値：	収集したセクション名の個数																		//
//==============================================================================================================//
typedef struct {
	UX		cbp;
	union {
		BOOL (CALLBACK *cbEnumKeyA)(C_BCP pKey, UX cbp);
		BOOL (CALLBACK *cbEnumKeyW)(C_WCP pKey, UX cbp);
	} u;
} EPKPRM, *PEPKPRM;
//----- バイト文字用 -------------------------------------------------------------------------------------------//
//- - - コールバック（REGファイル）- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -//
static	BOOL CALLBACK cbMyEnumRegKeyA(C_BCP pKey, AJCREGTYPE type, UX cbp)
{
	PEPKPRM	p = (PEPKPRM)cbp;
	return p->u.cbEnumKeyA(pKey, p->cbp);
}
//- - - コールバック（INIファイル）- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -//
static	BOOL CALLBACK cbMyEnumIniKeyA(C_BCP pKey, C_BCP pVal, UX cbp)
{
	PEPKPRM	p = (PEPKPRM)cbp;
	return p->u.cbEnumKeyA(pKey, p->cbp);
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
AJCEXPORT	int		WINAPI	AjcEnumProfileKeyA (C_BCP pSecName, UX cbp, BOOL (CALLBACK *cbEnumKey)(C_BCP pKey, UX cbp))
{
	int		rc = 0;
	EPKPRM	prm;

	if (pSecName != NULL && cbEnumKey != NULL) {
		prm.cbp 		 = cbp;
		prm.u.cbEnumKeyA = cbEnumKey;
		if (fToRegistory) rc = AjcEnumRegKeyA(RegFilePathA, pSecName, (UX)&prm, cbMyEnumRegKeyA);
		else			  rc = AjcEnumIniKeyA(IniFilePathA, pSecName, (UX)&prm, cbMyEnumIniKeyA);
	}
	return rc;
}
//----- ワイド文字用 -------------------------------------------------------------------------------------------//
//- - - コールバック（REGファイル）- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -//
static	BOOL CALLBACK cbMyEnumRegKeyW(C_WCP pKey, AJCREGTYPE type, UX cbp)
{
	PEPKPRM	p = (PEPKPRM)cbp;
	return p->u.cbEnumKeyW(pKey, p->cbp);
}
//- - - コールバック（INIファイル）- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -//
static	BOOL CALLBACK cbMyEnumIniKeyW(C_WCP pKey, C_WCP pVal, UX cbp)
{
	PEPKPRM	p = (PEPKPRM)cbp;
	return p->u.cbEnumKeyW(pKey, p->cbp);
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
AJCEXPORT	int		WINAPI	AjcEnumProfileKeyW (C_WCP pSecName, UX cbp, BOOL (CALLBACK *cbEnumKey)(C_WCP pKey, UX cbp))
{
	int		rc;
	EPKPRM	prm;

	if (pSecName != NULL && cbEnumKey != NULL) {
		prm.cbp 		 = cbp;
		prm.u.cbEnumKeyW = cbEnumKey;
		if (fToRegistory) rc = AjcEnumRegKeyW(RegFilePathW, pSecName, (UX)&prm, cbMyEnumRegKeyW);
		else			  rc = AjcEnumIniKeyW(IniFilePathW, pSecName, (UX)&prm, cbMyEnumIniKeyW);
	}
	return rc;
}

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	デフォルトのINIファイルパス設定																				//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	VO	SetDefaultIniFilePath(VO)
{
	WC			mod[MAX_PATH], buf[AJCMAX_REGPATH];
	WC			drv[_MAX_DRIVE], dir[_MAX_DIR], fname[_MAX_FNAME], ext[_MAX_EXT];

	IniFilePathW[0] = 0;
	if (GetModuleFileNameW(NULL, mod, MAX_PATH)) {
		if (GetFullPathNameW(mod, MAX_PATH, buf, NULL) == 0) {
			AjcSnPrintFW(buf, MAX_PATH, L"%s", mod);
		}
		_wsplitpath(buf 			, drv, dir, fname, ext);
		_wmakepath (IniFilePathW, drv, dir, fname, L".ini");
		WideCharToMultiByte(CP_ACP, 0, IniFilePathW, -1, IniFilePathA, MAX_PATH, NULL, NULL);
	}
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	デフォルトのレジストリ・ミドルパス設定																		//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	VO	SetDefaultRegMidPath(VO)
{
	WC			buf[AJCMAX_REGPATH];

	RegFilePathA[0] = 0;
	if (GetModuleFileNameW(NULL, buf, AJCMAX_REGPATH)) {
		//	ミドルパス(自ファイル名)設定
		_wsplitpath(buf, NULL, NULL, RegMidPathW, NULL);
		WideCharToMultiByte(CP_ACP, 0, RegMidPathW, -1, RegMidPathA, AJCMAX_REGPATH, NULL, NULL);
		//	レジストリパス設定
		AjcSnPrintFW(RegFilePathW, AJCMAX_REGPATH, L"%s", RegRootPathW);
		AjcPathCatW(RegFilePathW, RegMidPathW, AJCMAX_REGPATH);
		WideCharToMultiByte(CP_ACP, 0, RegFilePathW, -1, RegFilePathA, AJCMAX_REGPATH, NULL, NULL);
	}
}

