﻿#include	"AjcInternal.h"

//**************************************************************************************************************//
//																												//
//	固定長キュー（線形リスト）																					//
//																												//
//**************************************************************************************************************//


#define	INST_ID			0x92654196
#define	IS_MY_INST(P)	(P != NULL && P->InstID == INST_ID)


//==============================================================================================================//
//	線形リスト制御（固定長データ）																				//
//==============================================================================================================//
//--------------------------------------------------------------------------------------------------------------//
//	内部マクロ																									//
//--------------------------------------------------------------------------------------------------------------//
#define		AJCFQUE_ENTER		if (pW->fMultiThread) EnterCriticalSection(&pW->cs);
#define		AJCFQUE_LEAVE		if (pW->fMultiThread) LeaveCriticalSection(&pW->cs);

//==============================================================================================================//
//	インスタンス生成																							//
//																												//
//	引　数	：	DatSize  - ノードデータサイズ（バイト数）														//
//				cbp 	 - コールバックパラメタ																	//
//				cbRemove - ノード消去通知用コールバック（不要時はＮＵＬＬ）										//
//																												//
//	戻り値	：	≠ＮＵＬＬ：ＯＫ（インスタンスハンドル（＝インスタンスワークアドレス））						//
//				＝ＮＵＬＬ：エラー																				//
//==============================================================================================================//
AJCEXPORT HAJCFQUE	WINAPI	AjcFQueCreate(UI DatSize, UX cbp, VO (CALLBACK *cbRemove)(VOP pDat, UX cbp))
{
	HAJCFQUE  pW;

	if ((pW = (HAJCFQUE)AJCMEM(sizeof(AJCFQUE))) != NULL) {
		memset(pW, 0, sizeof *pW);
		pW->InstID	= INST_ID;
		pW->pTop	= NULL;
		pW->pLas	= NULL;
		pW->num		= 0;
		pW->len 	= DatSize;
		pW->cbp 	= cbp;
		pW->cbRemove= cbRemove;
	}

	return pW;
}
//==============================================================================================================//
//	インスタンス消去																							//
//																												//
//	引　数	：	pW 		  - インスタンスハンドル																//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
AJCEXPORT BOOL	WINAPI	AjcFQueDelete(HAJCFQUE pW)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		AjcFQuePurge(pW);
		if (pW->fMultiThread) {
			DeleteCriticalSection(&pW->cs);
		}
		free(pW);
		rc = TRUE;
	}
	return rc;
}

//==============================================================================================================//
//	マルチスレッドの許可／禁止																					//
//																												//
//	引　数	：	pW		- インスタンスワークのアドレス															//
//				fEnable - FALSE : マルチスレッド禁止															//
//						  TRUE	: マルチスレッド許可															//
//																												//
//	戻り値	：	前回の許可／禁止状態																			//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcFQueEnableMultiThread(HAJCFQUE pW, BOOL fEnable)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		rc = pW->fMultiThread;
		if (fEnable) {
			if (!pW->fMultiThread) {
				InitializeCriticalSection(&pW->cs);
				pW->fMultiThread = TRUE;
			}
		}
		else {
			if (pW->fMultiThread) {
				pW->fMultiThread = FALSE;
				DeleteCriticalSection(&pW->cs);
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	末尾へノード追加																							//
//																												//
//	引　数	：	pW 	 - インスタンスハンドル																		//
//				pDat - 末尾へ挿入するノードデータのアドレス														//
//																												//
//	戻り値	：	TRUE  / ≠NULL - 追加したノードのアドレス														//
//				FALSE / ＝NULL - エラー																			//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcFQueEnque	(HAJCFQUE pW, C_VOP pDat)
{
	return (AjcFQueEnqueEx(pW, pDat) != NULL);
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
AJCEXPORT	VOP		WINAPI	AjcFQueEnqueEx	(HAJCFQUE pW, C_VOP pDat)
{
	VOP			rc = NULL;
	PAJCFQNODE	pNew;

	if (IS_MY_INST(pW) && pDat != NULL) {
		AJCFQUE_ENTER
		if ((pNew = (PAJCFQNODE)AJCMEM(sizeof(AJCFQNODE) + pW->len)) != NULL) {	//	メモリブロック割り当て，成功？
			pNew->pNxt = 0;														//		新ＢＬＫ初期化
			memcpy(pNew + 1, pDat, pW->len);									//		・
			if (pW->pLas == NULL) {												//		初回キューイング？
				pW->pTop = pW->pLas = pNew;										//			新ＢＬＫを初キューイング
			}
			else {																//		追加キューイング？
				pW->pLas->pNxt = pNew;											//			新ＢＬＫを末尾へキューイング
				pW->pLas	   = pNew;											//			・
			}
			pW->num++;															//		ノード数更新
			rc = pNew + 1;														//		戻り値＝ＯＫ
		}
		else {																	//	メモリブロック割り当て，失敗？
			rc = NULL;															//		戻り値＝エラー
		}
		AJCFQUE_LEAVE
	}
	return rc;
}
//==============================================================================================================//
//	先頭へノード挿入																							//
//																												//
//	引　数	：	pW 	 - インスタンスハンドル																		//
//				pDat - 先頭へ挿入するノードデータのアドレス														//
//																												//
//	戻り値	：	TRUE  / ≠NULL - 追加したノードのアドレス														//
//				FALSE / ＝NULL - エラー																			//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcFQueEnqTop	(HAJCFQUE pW, C_VOP pDat)
{
	return (AjcFQueEnqTopEx(pW, pDat) != NULL);
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
AJCEXPORT	VOP		WINAPI	AjcFQueEnqTopEx	(HAJCFQUE pW, C_VOP pDat)
{
	VOP			rc = NULL;
	PAJCFQNODE	pNew;

	if (IS_MY_INST(pW) && pDat != NULL) {
		AJCFQUE_ENTER
		if ((pNew = (PAJCFQNODE)AJCMEM(sizeof(AJCFQNODE) + pW->len)) != NULL) {		//	メモリブロック割り当て，成功？
			memcpy(pNew + 1, pDat, pW->len);									//		・
			if (pW->pTop == NULL) {												//		初回キューイング？
				pNew->pNxt = NULL;												//			新ＢＬＫを初キューイング
				pW->pTop = pW->pLas = pNew;										//			・
			}
			else {																//		追加キューイング？
				pNew->pNxt = pW->pTop;											//			新ＢＬＫを先頭へキューイング
				pW->pTop   = pNew;												//			・
			}
			pW->num++;															//		ノード数更新
			rc = pNew + 1;														//		戻り値＝ＯＫ
		}
		else {																	//	メモリブロック割り当て，失敗？
			rc = NULL;															//		戻り値＝エラー
		}
		AJCFQUE_LEAVE
	}
	return rc;
}
//==============================================================================================================//
//	先頭ノードを取り出す																						//
//																												//
//	引　数	：	pW 	 - インスタンスハンドル																		//
//				pBuf - 取り出したノードのデータを格納するバッファのアドレス（不要時はＮＵＬＬ）					//
//																												//
//	戻り値	：	≠０：取り出したノードデータのバイト数															//
//				＝０：ノードなし																				//
//==============================================================================================================//
AJCEXPORT	UI	WINAPI	AjcFQueDeque	(HAJCFQUE pW, VOP pBuf)
{
	UI			rc = 0;
	PAJCFQNODE	pCur;

	if (IS_MY_INST(pW)) {
		AJCFQUE_ENTER
		if ((pCur = pW->pTop) != NULL) {							//	ノードあり？
			if ((pW->pTop = pCur->pNxt) == NULL) {					//		先頭ノード取り外し，次のノードなし？
				pW->pLas = NULL;									//			ラストポインタ＝ＮＵＬＬ
			}
			if (pBuf != NULL) memcpy(pBuf, (pCur + 1), pW->len);	//		バッファへノードデータコピー
			rc = pW->len;											//		戻り値＝ノードデータサイズ
			free(pCur);												//		取り外したノードを開放
			pW->num--;												//		ノード数減算
		}
		else {														//	ノードなし？
			rc = 0;													//		戻り値＝ノードなし
		}
		AJCFQUE_LEAVE
	}
	return rc;
}
//==============================================================================================================//
//	全ノードを消去する																							//
//																												//
//	引　数	：	pW 		  - インスタンスハンドル																//
//				xp		  - コールバックパラメタ																//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
AJCEXPORT	BOOL	  WINAPI	AjcFQuePurge(HAJCFQUE pW)
{
	BOOL		rc = FALSE;
	PAJCFQNODE	pCur, svp;

	if (IS_MY_INST(pW)) {
		AJCFQUE_ENTER
		pCur = pW->pTop;									//	先頭ＢＬＫアドレス設定
		while (pCur) {										//	全ＢＬＫループ
			if (pW->cbRemove) {								//		消去通知コールバックあり？
				pW->cbRemove(pCur + 1, pW->cbp);			//			コールバック
			}
			svp = pCur;										//		ＢＬＫアドレス退避
			pCur = pCur->pNxt;								//		次のＢＬＫアドレス設定
			free(svp);										//		ＢＬＫ開放
		}
		pW->pTop = pW->pLas = NULL;							//	キューチェインポインタ初期化
		pW->num = 0;										//	ノード数＝０
		AJCFQUE_LEAVE
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	現在のノード数を得る																						//
//																												//
//	引　数	：	pW 	 - インスタンスハンドル																		//
//																												//
//	戻り値	：	現在のノード数																					//
//==============================================================================================================//
AJCEXPORT	UI	  WINAPI	AjcFQueGetCount	(HAJCFQUE pW)
{
	UI		rc = 0;

	if (IS_MY_INST(pW)) {
		AJCFQUE_ENTER
		rc = pW->num;
		AJCFQUE_LEAVE
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	UI	  WINAPI	AjcFQueNumber	(HAJCFQUE pW)
{
	return AjcFQueGetCount(pW);
}

//==============================================================================================================//
//	２つのＬＳＴ構造を連結する																					//
//																												//
//	引　数	：	pW 	 - インスタンスハンドル																		//
//				pSrc - 連結するＬＳＴのハンドル（このＬＳＴは空になります）										//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcFQueMerge	(HAJCFQUE pW, HAJCFQUE pSrc)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW) && IS_MY_INST(pSrc)) {
		AJCFQUE_ENTER
		if (pSrc->fMultiThread) EnterCriticalSection(&pSrc->cs);
		if (pW->pLas == 0) {				//	被連結側にノードなし？
			pW->pTop = pSrc->pTop;			//		連結するチェイン情報を、被連結側へコピー
			pW->pLas = pSrc->pLas;			//		・
			pW->num  = pSrc->num;			//		・
		}
		else if (pSrc->num) {				//	被連結側にノードあり & 連結するノードあり？
			pW->pLas->pNxt = pSrc->pTop;	//		連結するチェイン情報を、被連結側の末尾へ追加
			pW->pLas	   = pSrc->pLas;	//		・
			pW->num += pSrc->num;			//		・
		}
		pSrc->pTop = NULL;					//	連結したチェイン情報をリセット
		pSrc->pLas = NULL;					//	・
		pSrc->num  = 0;						//	・
		if (pSrc->fMultiThread) LeaveCriticalSection(&pSrc->cs);
		AJCFQUE_LEAVE
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	先頭ノードデータのアドレスを得る																			//
//																												//
//	引　数	：	pW 	   - インスタンスハンドル																	//
//																												//
//	戻り値	：	≠ＮＵＬＬ：先頭ノードデータのアドレス															//
//				＝ＮＵＬＬ：ノードなし																			//
//==============================================================================================================//
AJCEXPORT	VOP   WINAPI	AjcFQueTopNode	(HAJCFQUE pW)
{
	VOP		rc = NULL;

	if (IS_MY_INST(pW)) {
		AJCFQUE_ENTER
		if (pW->pTop != NULL) {				//	先頭ノードあり？
			rc = pW->pTop + 1;				//		戻り値＝先頭ノードのデータアドレス
		}
		else {								//	先頭ノードなし（空リスト）
			rc = NULL;						//		戻り値＝ＮＵＬＬ
		}
		AJCFQUE_LEAVE
	}
	return rc;
}
//==============================================================================================================//
//	次のノードデータのアドレスを得る																			//
//																												//
//	引　数	：	pW 	   - インスタンスハンドル																	//
//																												//
//	戻り値	：	≠ＮＵＬＬ：次のノードデータのアドレス															//
//				＝ＮＵＬＬ：ノードなし																			//
//==============================================================================================================//
AJCEXPORT	VOP   WINAPI	AjcFQueNextNode	(HAJCFQUE pW, C_VOP pCurrentNode)
{
	VOP			rc = NULL;
	PAJCFQNODE	pNode;

	if (IS_MY_INST(pW)) {
		AJCFQUE_ENTER
		if (pCurrentNode) {						//	現ノードあり？
			pNode = (PAJCFQNODE)pCurrentNode;	//		現ノードのノード先頭アドレス設定
			pNode--;							//		・
			if (pNode = pNode->pNxt) {			//		次ノードあり？
				rc = pNode + 1;					//			戻り値＝次ノードのデータアドレス
			}
			else {								//		次ノードなし？
				rc = NULL;						//			戻り値＝ＮＵＬＬ
			}
		}
		else {									//	現ノードなし？
			rc = NULL;							//		戻り値＝ＮＵＬＬ
		}
		AJCFQUE_LEAVE
	}
	return rc;
}
//==============================================================================================================//
//	全ノードへのポインタ配列生成																				//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pNum		- 配列要素数を格納するバッファのアドレス											//
//																												//
//	戻り値	：	≠NULL : 全ノードへのポインタ配列の先頭アドレス													//
//				＝NULL : エラー																					//
//==============================================================================================================//
AJCEXPORT PCAJCFQUEPTR WINAPI AjcFQueCreatePtrArr (HAJCFQUE pW, UIP pNum)
{
	PAJCFQUEPTR	rc	  = NULL;
	PAJCFQUEPTR pArr  = NULL;
	VOP			pNode = NULL;
	UI			ix	  = 0;

	if (IS_MY_INST(pW)) {
		AJCFQUE_ENTER
		if (pArr  =  (PAJCFQUEPTR)AJCMEM(sizeof(AJCFQUEPTR) * (pW->num + 1))) {
			memset(pArr, 0, sizeof(AJCFQUEPTR) * (pW->num + 1));
			if (pNode = AjcFQueTopNode(pW)) {
				do {
					pArr[ix].pNode = pNode;
					ix++;
				} while (pNode = AjcFQueNextNode(pW, pNode));
			}
			if (pNum != NULL) *pNum = ix;
			rc = pArr;
		}
		AJCFQUE_LEAVE
	}
	return rc;
}
//==============================================================================================================//
//	全ノードへのポインタ配列解放																				//
//																												//
//	引　数	：	pW			 - インスタンスハンドル																//
//				pArr		 - 全ノードへのポインタ配列の先頭アドレス											//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
AJCEXPORT	VO	 		 WINAPI AjcFQueReleasePtrArr(HAJCFQUE pW, PCAJCFQUEPTR pArr)
{
	if (IS_MY_INST(pW)) {
		AJCFQUE_ENTER
		if (pArr != NULL) free((VOP)pArr);
		AJCFQUE_LEAVE
	}
}
