﻿#include	"AjcInternal.h"

//**************************************************************************************************************//
//																												//
//	レジストリアクセス																							//
//																												//
//**************************************************************************************************************//
extern	BCP		SubProfileGenerateBinFileA(BOOL fVolatile, C_BCP pTail, BC full[MAX_PATH], C_BCP pBinDir);
extern	WCP		SubProfileGenerateBinFileW(BOOL fVolatile, C_WCP pTail, WC full[MAX_PATH], C_WCP pBinDir);

extern	BOOL	SubProfileDeleteBinFileA(C_BCP pTail, C_BCP pBinDir);
extern	BOOL	SubProfileDeleteBinFileW(C_WCP pTail, C_WCP pBinDir);

//--------------------------------------------------------------------------------------------------------------//
//	作業領域																									//
//--------------------------------------------------------------------------------------------------------------//
//	バイナリデータ格納ディレクトリパス
static	BC		BinDataDirA[MAX_PATH] = {0};
static	WC		BinDataDirW[MAX_PATH] = {0};

static	WC		SvPath[AJCMAX_REGPATH] = {0};
static	REGSAM	SvAccess = 0;
static	HKEY	hKeyTop  = HKEY_CURRENT_USER;
static	HKEY	hRegKey  = NULL;

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
static	HKEY	SubOpenKeyA  (C_BCP pPath, C_BCP pSec, REGSAM acc);
static	HKEY	SubOpenKeyW  (C_WCP pPath, C_WCP pSec, REGSAM acc);

static	HKEY	SubOpenTempKeyA(C_BCP pPath, C_BCP pSec, REGSAM acc);
static	HKEY	SubOpenTempKeyW(C_WCP pPath, C_WCP pSec, REGSAM acc);

static	HKEY	SubCreateKeyA(C_BCP pPath, C_BCP pSec, REGSAM acc, BOOL fVolatile);
static	HKEY	SubCreateKeyW(C_WCP pPath, C_WCP pSec, REGSAM acc, BOOL fVolatile);

static	BCP		SearchPathItemA(BCP pStr, C_BCP path);
static	WCP		SearchPathItemW(WCP pStr, C_WCP path);

static	VO		AdjustSemiCollonA(BCP pStr);
static	VO		AdjustSemiCollonW(WCP pStr);

static	VO		ValidateToEnvironment(VO);

//==============================================================================================================//
//	レジストリ・トップキー設定																					//
//																												//
//	引　数：	hKey		- ルート・レジストリ・キーハンドル													//
//																												//
//	戻り値：	前回設定値																						//
//==============================================================================================================//
AJCEXPORT	HKEY	WINAPI	AjcSetRegTopKey(HKEY hKey)
{
	HKEY	rc = hKeyTop;

	AjcCloseRegFile();
	hKeyTop = hKey;

	return rc;
}
//==============================================================================================================//
//	レジストリ・トップキー取得																					//
//																												//
//	引　数：	なし																							//
//																												//
//	戻り値：	ルート・レジストリ・キーハンドル																//
//==============================================================================================================//
AJCEXPORT HKEY	 WINAPI	AjcGetRegTopKey(VO)
{
	return hKeyTop;
}
//==============================================================================================================//
//	バイナリデータ格納ディレクトリパス設定																		//
//																												//
//	引　数	：	pBinDir	   - バイナリデータ格納ディレクトリパス（NULLの場合は、保存先解除）						//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	VO		WINAPI	AjcSetRegBinDirA(C_BCP pBinDir)
{
	if (pBinDir != NULL && *pBinDir != 0) {
		AjcSnPrintFA(BinDataDirA, MAX_PATH, "%s", pBinDir);
		AjcPathCatA(BinDataDirA, "", MAX_PATH);
		BinDataDirA[MAX_PATH - 1] = 0;
	}
	else {
		AjcGetAppPathA(BinDataDirA, MAX_PATH);
	}
	MultiByteToWideChar(CP_ACP, 0, BinDataDirA, -1, BinDataDirW, MAX_PATH);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	VO		WINAPI	AjcSetRegBinDirW(C_WCP pBinDir)
{
	if (pBinDir != NULL && *pBinDir != 0) {
		AjcSnPrintFW(BinDataDirW, MAX_PATH, L"%s", pBinDir);
		AjcPathCatW(BinDataDirW, L"", MAX_PATH);
		BinDataDirW[MAX_PATH - 1] = 0;
		
	}
	else {
		AjcGetAppPathW(BinDataDirW, MAX_PATH);
	}
	WideCharToMultiByte(CP_ACP, 0, BinDataDirW, -1, BinDataDirA, MAX_PATH, NULL, NULL);
}
//==============================================================================================================//
//	バイナリデータ格納ディレクトリパス取得																		//
//																												//
//	引　数	：	pBuf	- バイナリデータ格納ディレクトリパスを格納するバッファのアドレス						//
//				lBuf	- バイナリデータ格納ディレクトリパスを格納するバッファの文字数							//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	VO		WINAPI	AjcGetRegBinDirA(BCP pBuf, UI lBuf)
{
	if (pBuf != NULL  &&  lBuf > 0) {
		AjcSnPrintFA(pBuf, lBuf, "%s", BinDataDirA);
	}
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	VO		WINAPI	AjcGetRegBinDirW(WCP pBuf, UI lBuf)
{
	if (pBuf != NULL  &&  lBuf > 0) {
		AjcSnPrintFW(pBuf, lBuf, L"%s", BinDataDirW);
	}
}

//==============================================================================================================//
//	レジストリファイル読み出し（数値）																			//
//																												//
//	引　数：	pPath		- パス名のアドレス																	//
//				pSecName	- セクション名のアドレス															//
//				pKeyName	- キー名のアドレス（規定項目の場合はNULL)											//
//				defValue	- デフォルト値																		//
//																												//
//	戻り値：	レジストリファイルから読み出した当該キー値／デフォルト値										//
//==============================================================================================================//
//----- バイト文字用 -------------------------------------------------------------------------------------------//
#define	M_GSGETPROFILEN_A(_T1_, _T2_, _CV_)																		\
AJCEXPORT _T1_ 	WINAPI AjcGetRegFile##_T2_##A(C_BCP pPath, C_BCP pSecName, C_BCP pKeyName, _T1_ defValue)		\
{	_T1_	rc = defValue;																						\
	HKEY	hKey;																								\
	UL		bytes = sizeof(_T1_);																				\
	UL		type  = _CV_;																						\
	hKey = SubOpenKeyA(pPath, pSecName, KEY_READ);																\
	if (hKey != NULL) {																							\
		_T1_	n;																								\
		if (RegQueryValueExA(hKey, pKeyName, NULL, &type, (LPBYTE)&n, &bytes) == ERROR_SUCCESS) {				\
			rc = n;																								\
		}																										\
	}																											\
	return rc;																									\
}
M_GSGETPROFILEN_A(UI	, UInt, REG_DWORD)
M_GSGETPROFILEN_A(SI	, SInt, REG_DWORD)
M_GSGETPROFILEN_A(UI	, Hex , REG_DWORD)
M_GSGETPROFILEN_A(double, Real, REG_BINARY)
M_GSGETPROFILEN_A(ULL	, UI64, REG_BINARY)
M_GSGETPROFILEN_A(SLL	, SI64, REG_BINARY)
M_GSGETPROFILEN_A(ULL	, H64 , REG_BINARY)

//----- ワイド文字用 -------------------------------------------------------------------------------------------//
#define	M_GSGETPROFILEN_W(_T1_, _T2_, _CV_)																		\
AJCEXPORT _T1_ 	WINAPI AjcGetRegFile##_T2_##W(C_WCP pPath, C_WCP pSecName, C_WCP pKeyName, _T1_ defValue)		\
{	_T1_	rc = defValue;																						\
	HKEY	hKey;																								\
	UL		bytes = sizeof(_T1_);																				\
	UL		type  = _CV_;																						\
	hKey = SubOpenKeyW(pPath, pSecName, KEY_READ);																\
	if (hKey != NULL) {																							\
		_T1_	n;																								\
		if (RegQueryValueExW(hKey, pKeyName, NULL, &type, (LPBYTE)&n, &bytes) == ERROR_SUCCESS) {				\
			rc = n;																								\
		}																										\
	}																											\
	return rc;																									\
}
M_GSGETPROFILEN_W(UI	, UInt, REG_DWORD)
M_GSGETPROFILEN_W(SI	, SInt, REG_DWORD)
M_GSGETPROFILEN_W(UI	, Hex , REG_DWORD)
M_GSGETPROFILEN_W(double, Real, REG_BINARY)
M_GSGETPROFILEN_W(ULL	, UI64, REG_BINARY)
M_GSGETPROFILEN_W(SLL	, SI64, REG_BINARY)
M_GSGETPROFILEN_W(ULL	, H64 , REG_BINARY)

//==============================================================================================================//
//	レジストリファイル読み出し（整数配列）																		//
//																												//
//	引　数：	pPath		- パス名のアドレス																	//
//				pSecName	- セクション名のアドレス															//
//				pKeyName	- キー名のアドレス（規定項目の場合はNULL)											//
//				pArray		- 読み出した値を格納する整数配列のアドレス											//
//				lArray		- 整数配列の要素サイズ（１，２，４ or ８）											//
//				nArray		- 整数配列の要素数																	//
//																												//
//	戻り値：	レジストリファイルから読み出した整数値の個数													//
//==============================================================================================================//
//----- バイト文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT	UI		WINAPI	AjcGetRegFileArrA(C_BCP pPath, C_BCP pSecName, C_BCP pKeyName, VOP pArray, UI lArray, UI nArray)
{
	UI		rc = 0;
	HKEY	hKey;
	UL		bytes = lArray * nArray;
	UL		type  = REG_BINARY;

	if (pArray != NULL) {
		hKey = SubOpenKeyA(pPath, pSecName, KEY_READ);
		if (hKey != NULL && RegQueryValueExA(hKey, pKeyName, NULL, &type, pArray, &bytes) == ERROR_SUCCESS &&
			type == REG_BINARY) {
			rc = bytes / lArray;
		}
	}
	return rc;
}
//----- ワイド文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT	UI		WINAPI	AjcGetRegFileArrW(C_WCP pPath, C_WCP pSecName, C_WCP pKeyName, VOP pArray, UI lArray, UI nArray)
{
	UI		rc = 0;
	HKEY	hKey;
	UL		bytes = lArray * nArray;
	UL		type  = REG_BINARY;

	if (pArray != NULL) {
		hKey = SubOpenKeyW(pPath, pSecName, KEY_READ);
		if (hKey != NULL && RegQueryValueExW(hKey, pKeyName, NULL, &type, pArray, &bytes) == ERROR_SUCCESS &&
			type == REG_BINARY) {
			rc = bytes / lArray;
		}
	}
	return rc;
}
//==============================================================================================================//
//	レジストリファイル読み出し（文字列）																		//
//																												//
//	引　数：	pPath		- パス名のアドレス																	//
//				pSecName	- セクション名のアドレス															//
//				pKeyName	- キー名のアドレス（規定項目の場合はNULL)											//
//				pDefStr		- デフォルト値（不要時はNULL）														//
//				pBuf		- 読み出した文字列を格納するバッファのアドレス			（長さ取得時はNULL）		//
//				lBuf		- 読み出した文字列を格納するバッファのバイト数／文字数	（長さ取得時は０）			//
//																												//
//	戻り値：	読み出したキー値の文字長（バイト数／文字数）／データの文字長（バイト数／文字数）				//
//==============================================================================================================//
static	UI	SetDefStrA(C_BCP pDefStr, BCP pBuf, UI lBuf);
static	UI	SetDefStrW(C_WCP pDefStr, WCP pBuf, UI lBuf);
static	UI	GetRegFileStrA(C_BCP pPath, C_BCP pSecName, C_BCP pKeyName, C_BCP pDefStr, BCP pBuf, UI lBuf, UL type);
static	UI	GetRegFileStrW(C_WCP pPath, C_WCP pSecName, C_WCP pKeyName, C_WCP pDefStr, WCP pBuf, UI lBuf, UL type);

//----- レジストリ文字列読み出し（バイト文字用） ---------------------------------------------------------------//
AJCEXPORT	UI		WINAPI	AjcGetRegFileStrA(C_BCP pPath, C_BCP pSecName, C_BCP pKeyName, C_BCP pDefStr, BCP pBuf, UI lBuf)
{
	return GetRegFileStrA(pPath, pSecName, pKeyName, pDefStr, pBuf, lBuf, REG_SZ);
}
//----- レジストリ文字列読み出し（ワイド文字用） ---------------------------------------------------------------//
AJCEXPORT	UI		WINAPI	AjcGetRegFileStrW(C_WCP pPath, C_WCP pSecName, C_WCP pKeyName, C_WCP pDefStr, WCP pBuf, UI lBuf)
{
	return GetRegFileStrW(pPath, pSecName, pKeyName, pDefStr, pBuf, lBuf, REG_SZ);
}

//==============================================================================================================//
//	レジストリファイル読み出し（展開文字列）																	//
//																												//
//	引　数：	pPath		- パス名のアドレス																	//
//				pSecName	- セクション名のアドレス															//
//				pKeyName	- キー名のアドレス（規定項目の場合はNULL)											//
//				pDefStr		- デフォルト値	（不要時はNULL）													//
//				pBuf		- 読み出した文字列を格納するバッファのアドレス			（長さ取得時はNULL）		//
//				lBuf		- 読み出した文字列を格納するバッファのバイト数／文字数	（長さ取得時は０）			//
//																												//
//	戻り値：	読み出したキー値の文字長（バイト数／文字数）／データの文字長（バイト数／文字数）				//
//==============================================================================================================//
//----- バイト文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT	UI		WINAPI	AjcGetRegFileExpA(C_BCP pPath, C_BCP pSecName, C_BCP pKeyName, C_BCP pDefStr, BCP pBuf, UI lBuf)
{
	return GetRegFileStrA(pPath, pSecName, pKeyName, pDefStr, pBuf, lBuf, REG_EXPAND_SZ);
}
//----- ワイド文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT	UI		WINAPI	AjcGetRegFileExpW(C_WCP pPath, C_WCP pSecName, C_WCP pKeyName, C_WCP pDefStr, WCP pBuf, UI lBuf)
{
	return GetRegFileStrW(pPath, pSecName, pKeyName, pDefStr, pBuf, lBuf, REG_EXPAND_SZ);
}
//----- レジストリから文字列読み出し（バイト文字用） -----------------------------------------------------------//
static	UI	GetRegFileStrA(C_BCP pPath, C_BCP pSecName, C_BCP pKeyName, C_BCP pDefStr, BCP pBuf, UI lBuf, UL type)
{
	UI		rc	= 0;
	UI		rsu = 0;
	UL		typbuf = type;
	HKEY	hKey;
	UL		bytes = lBuf;

	hKey = SubOpenKeyA(pPath, pSecName, KEY_READ);
	rsu = RegQueryValueExA(hKey, pKeyName, NULL, &typbuf, (UBP)pBuf, &bytes);
	if (typbuf == type) {
		switch (rsu) {
			case ERROR_SUCCESS:
			case ERROR_MORE_DATA:
				if (pBuf != NULL && lBuf != 0) {pBuf[lBuf - 1] = 0; rc = (UI)strlen(pBuf);}
				else												rc = bytes - 1;
				break;
			default:
				rc = SetDefStrA(pDefStr, pBuf, lBuf);
				break;
		}
	}
	else {
		rc = SetDefStrA(pDefStr, pBuf, lBuf);
	}
	return rc;
}
//----- レジストリから文字列読み出し（ワイド文字用） -----------------------------------------------------------//
static	UI	GetRegFileStrW(C_WCP pPath, C_WCP pSecName, C_WCP pKeyName, C_WCP pDefStr, WCP pBuf, UI lBuf, UL type)

{	UI		rc	= 0;
	UI		rsu = 0;
	UL		typbuf = type;
	HKEY	hKey;
	UL		bytes = lBuf * 2;

	hKey = SubOpenKeyW(pPath, pSecName, KEY_READ);
	rsu = RegQueryValueExW(hKey, pKeyName, NULL, &typbuf, (UBP)pBuf, &bytes);
	if (typbuf == type) {
		switch (rsu) {
			case ERROR_SUCCESS:
			case ERROR_MORE_DATA:
				if (pBuf != NULL && lBuf != 0) {pBuf[lBuf - 1] = 0; rc = (UI)wcslen(pBuf);}
				else												rc = bytes / 2 - 1;
				break;
			default:
				rc = SetDefStrW(pDefStr, pBuf, lBuf);
				break;
		}
	}
	else {
		rc = SetDefStrW(pDefStr, pBuf, lBuf);
	}
	return rc;
}
//----- デフォルト文字列設定（バイト文字用）--------------------------------------------------------------------//
static	UI	SetDefStrA(C_BCP pDefStr, BCP pBuf, UI lBuf)
{
	UI	rc = 0;

	if (pBuf != NULL && lBuf != 0) {
		if (pDefStr != NULL) strncpy(pBuf, pDefStr, lBuf);
		else				 *pBuf = 0;
		pBuf[lBuf - 1] = 0;
		rc = (UI)strlen(pBuf);
	}
	return rc;
}
//----- デフォルト文字列設定（ワイド文字用）--------------------------------------------------------------------//
static	UI	SetDefStrW(C_WCP pDefStr, WCP pBuf, UI lBuf)
{
	UI	rc = 0;

	if (pBuf != NULL && lBuf != 0) {
		if (pDefStr != NULL) wcsncpy(pBuf, pDefStr, lBuf);
		else				 *pBuf = 0;
		pBuf[lBuf - 1] = 0;
		rc = (UI)wcslen(pBuf);
	}
	return rc;
}
//==============================================================================================================//
//	レジストリファイル読み出し（バイナリデータ）																//
//																												//
//	引　数：	pPath		- パス名のアドレス																	//
//				pSecName	- セクション名のアドレス															//
//				pKeyName	- キー名のアドレス（規定項目の場合はNULL)											//
//				pBuf		- 読み出したバイナリデータを格納するバッファのアドレス（バイト数だけ取得時はNULL)	//
//				lBuf		- 読み出したバイナリデータを格納するバッファのバイト数								//
//																												//
//	戻り値：	読み出したデータのバイト数（エラー時は０）														//
//==============================================================================================================//
//----- バイト文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT	UI		WINAPI	AjcGetRegFileBinA(C_BCP pPath, C_BCP pSecName, C_BCP pKeyName, VOP pBuf, UI lBuf)
{
	return AjcGetRegFileBinExA(pPath, pSecName, pKeyName, pBuf, lBuf, BinDataDirA);
}
//----- ワイド文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT	UI		WINAPI	AjcGetRegFileBinW(C_WCP pPath, C_WCP pSecName, C_WCP pKeyName, VOP pBuf, UI lBuf)
{
	return AjcGetRegFileBinExW(pPath, pSecName, pKeyName, pBuf, lBuf, BinDataDirW);
}
//==============================================================================================================//
//	レジストリファイル読み出し（バイナリデータ，バイナリデータフォルダ指定）									//
//																												//
//	引　数：	pPath		- パス名のアドレス																	//
//				pSecName	- セクション名のアドレス															//
//				pKeyName	- キー名のアドレス（規定項目の場合はNULL)											//
//				pBuf		- 読み出したバイナリデータを格納するバッファのアドレス（バイト数だけ取得時はNULL)	//
//				lBuf		- 読み出したバイナリデータを格納するバッファのバイト数								//
//				pBinDir		- バイナリデータフォルダ															//
//																												//
//	戻り値：	読み出したデータのバイト数（エラー時は０）														//
//==============================================================================================================//
//----- バイト文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT	UI		WINAPI	AjcGetRegFileBinExA(C_BCP pPath, C_BCP pSecName, C_BCP pKeyName, VOP pBuf, UI lBuf, C_BCP pBinDir)
{
	UI		rc = 0;
	UI		len;
	HANDLE	hFile;
	BC		tail[MAX_PATH];
	BC		path[MAX_PATH];

	if (AjcGetRegFileStrA(pPath, pSecName, pKeyName, "", tail, MAX_PATH) != 0) {
		if (SubProfileGenerateBinFileA(0, tail, path, pBinDir) != NULL) {
			if ((hFile = CreateFileA(path, GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL)) != INVALID_HANDLE_VALUE) {
				if (pBuf != NULL) {
					ReadFile(hFile, pBuf, lBuf, &rc, NULL);
				}
				else {
					if ((len = GetFileSize(hFile, NULL)) != 0xFFFFFFFF) {
						rc = len;
					}
				}
				CloseHandle(hFile);
			}
		}
	}
	return rc;
}
//----- ワイド文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT	UI		WINAPI	AjcGetRegFileBinExW(C_WCP pPath, C_WCP pSecName, C_WCP pKeyName, VOP pBuf, UI lBuf, C_WCP pBinDir)
{
	UI		rc = 0;
	UI		len;
	HANDLE	hFile;
	WC		tail[MAX_PATH];
	WC		path[MAX_PATH];

	if (AjcGetRegFileStrW(pPath, pSecName, pKeyName, L"", tail, MAX_PATH) != 0) {
		if (SubProfileGenerateBinFileW(0, tail, path, pBinDir) != NULL) {
			if ((hFile = CreateFileW(path, GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL)) != INVALID_HANDLE_VALUE) {
				if (pBuf != NULL) {
					ReadFile(hFile, pBuf, lBuf, &rc, NULL);
				}
				else {
					if ((len = GetFileSize(hFile, NULL)) != 0xFFFFFFFF) {
						rc = len;
					}
				}
				CloseHandle(hFile);
			}
		}
	}
	return rc;
}


//==============================================================================================================//
//	レジストリファイル書き込み（数値）																			//
//																												//
//	引　数：	pPath		- パス名のアドレス																	//
//				pSecName	- セクション名のアドレス															//
//				pKeyName	- キー名のアドレス（規定項目の場合はNULL)											//
//				fVolatile	- FALSE:恒久記録，TRUE:一時記録														//
//				Value		- 書き込み値																		//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - エラー																					//
//==============================================================================================================//
//----- バイト文字用 -------------------------------------------------------------------------------------------//
#define	M_GSPUTPROFILEN_A(_T1_, _T2_, _CV_)																				\
AJCEXPORT BOOL WINAPI AjcPutRegFile##_T2_##A(C_BCP pPath, C_BCP pSecName, C_BCP pKeyName, BOOL fVolatile, _T1_ Value)	\
{																														\
	BOOL	rc = FALSE;																									\
	HKEY	hKey;																										\
	if (hKey = SubCreateKeyA(pPath, pSecName, KEY_ALL_ACCESS, fVolatile)) {												\
		rc = (RegSetValueExA(hKey, pKeyName, 0, _CV_, (LPBYTE)&Value, sizeof(_T1_)) == ERROR_SUCCESS);					\
	}																													\
	return rc;																											\
}
M_GSPUTPROFILEN_A(UI	, UInt, REG_DWORD )
M_GSPUTPROFILEN_A(SI	, SInt, REG_DWORD )
M_GSPUTPROFILEN_A(UI	, Hex , REG_DWORD )
M_GSPUTPROFILEN_A(double, Real, REG_BINARY)
M_GSPUTPROFILEN_A(ULL	, UI64, REG_BINARY)
M_GSPUTPROFILEN_A(SLL	, SI64, REG_BINARY)
M_GSPUTPROFILEN_A(ULL	, H64 , REG_BINARY)

//----- ワイド文字用 -------------------------------------------------------------------------------------------//
#define	M_GSPUTPROFILEN_W(_T1_, _T2_, _CV_)																				\
AJCEXPORT BOOL WINAPI AjcPutRegFile##_T2_##W(C_WCP pPath, C_WCP pSecName, C_WCP pKeyName, BOOL fVolatile, _T1_ Value)	\
{																														\
	BOOL	rc = FALSE;																									\
	HKEY	hKey;																										\
	if (hKey = SubCreateKeyW(pPath, pSecName, KEY_ALL_ACCESS, fVolatile)) {												\
		rc = (RegSetValueExW(hKey, pKeyName, 0, _CV_, (LPBYTE)&Value, sizeof(_T1_)) == ERROR_SUCCESS);					\
	}																													\
	return rc;																											\
}
M_GSPUTPROFILEN_W(UI	, UInt, REG_DWORD )
M_GSPUTPROFILEN_W(SI	, SInt, REG_DWORD )
M_GSPUTPROFILEN_W(UI	, Hex , REG_DWORD )
M_GSPUTPROFILEN_W(double, Real, REG_BINARY)
M_GSPUTPROFILEN_W(ULL	, UI64, REG_BINARY)
M_GSPUTPROFILEN_W(SLL	, SI64, REG_BINARY)
M_GSPUTPROFILEN_W(ULL	, H64 , REG_BINARY)

//==============================================================================================================//
//	レジストリファイル書き込み（整数配列）																		//
//																												//
//	引　数：	pPath		- パス名のアドレス																	//
//				pSecName	- セクション名のアドレス															//
//				pKeyName	- キー名のアドレス（規定項目の場合はNULL)											//
//				fVolatile	- FALSE:恒久記録，TRUE:一時記録														//
//				pArray		- 書き込み値が格納された整数配列のアドレス											//
//				lArray		- 整数配列の要素サイズ（１，２ or ４）												//
//				nArray		- 整数配列の要素数																	//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - エラー																					//
//==============================================================================================================//
//----- バイト文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcPutRegFileArrA(C_BCP pPath, C_BCP pSecName, C_BCP pKeyName, BOOL fVolatile, VOP pArray, UI lArray, UI nArray)
{
	BOOL	rc = FALSE;
	HKEY	hKey;

	if (pArray != NULL) {
		if (hKey = SubCreateKeyA(pPath, pSecName, KEY_ALL_ACCESS, fVolatile)) {
			rc = (RegSetValueExA(hKey, pKeyName, 0, REG_BINARY, pArray, lArray * nArray) == ERROR_SUCCESS);
		}
	}
	return rc;
}
//----- ワイド文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcPutRegFileArrW(C_WCP pPath, C_WCP pSecName, C_WCP pKeyName, BOOL fVolatile, VOP pArray, UI lArray, UI nArray)
{
	BOOL	rc = FALSE;
	HKEY	hKey;

	if (pArray != NULL) {
		if (hKey = SubCreateKeyW(pPath, pSecName, KEY_ALL_ACCESS, fVolatile)) {
			rc = (RegSetValueExW(hKey, pKeyName, 0, REG_BINARY, pArray, lArray * nArray) == ERROR_SUCCESS);
		}
	}
	return rc;
}

//==============================================================================================================//
//	レジストリファイル書き込み（文字列）																		//
//																												//
//	引　数：	pPath		- パス名のアドレス																	//
//				pSecName	- セクション名のアドレス															//
//				pKeyName	- キー名のアドレス（規定項目の場合はNULL)											//
//				fVolatile	- FALSE:恒久記録，TRUE:一時記録														//
//				pStr		- 書き込む文字列のアドレス															//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - エラー																					//
//==============================================================================================================//
//----- バイト文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcPutRegFileStrA(C_BCP pPath, C_BCP pSecName, C_BCP pKeyName, BOOL fVolatile, C_BCP pStr)
{
	BOOL	rc = FALSE;
	HKEY	hKey;

	if (pStr != NULL) {
		if (hKey = SubCreateKeyA(pPath, pSecName, KEY_ALL_ACCESS, fVolatile)) {
			rc = (RegSetValueExA(hKey, pKeyName, 0, REG_SZ, pStr, (DWORD)(strlen(pStr) + 1)) == ERROR_SUCCESS);
		}
	}
	return rc;
}
//----- ワイド文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcPutRegFileStrW(C_WCP pPath, C_WCP pSecName, C_WCP pKeyName, BOOL fVolatile, C_WCP pStr)
{
	BOOL	rc = FALSE;
	HKEY	hKey;

	if (pStr != NULL) {
		if (hKey = SubCreateKeyW(pPath, pSecName, KEY_ALL_ACCESS, fVolatile)) {
			rc = (RegSetValueExW(hKey, pKeyName, 0, REG_SZ, (C_BCP)pStr, (DWORD)(wcslen(pStr) + 1) * 2) == ERROR_SUCCESS);
		}
	}
	return rc;
}
//==============================================================================================================//
//	レジストリファイル書き込み（展開文字列）																	//
//																												//
//	引　数：	pPath		- パス名のアドレス																	//
//				pSecName	- セクション名のアドレス															//
//				pKeyName	- キー名のアドレス（規定項目の場合はNULL)											//
//				fVolatile	- FALSE:恒久記録，TRUE:一時記録														//
//				pStr		- 書き込む文字列のアドレス															//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - エラー																					//
//==============================================================================================================//
//----- バイト文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcPutRegFileExpA(C_BCP pPath, C_BCP pSecName, C_BCP pKeyName, BOOL fVolatile, C_BCP pStr)
{
	BOOL	rc = FALSE;
	HKEY	hKey;

	if (pStr != NULL) {
		if (hKey = SubCreateKeyA(pPath, pSecName, KEY_ALL_ACCESS, fVolatile)) {
			rc = (RegSetValueExA(hKey, pKeyName, 0, REG_EXPAND_SZ, pStr, (DWORD)(strlen(pStr) + 1)) == ERROR_SUCCESS);
		}
	}
	return rc;
}
//----- ワイド文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcPutRegFileExpW(C_WCP pPath, C_WCP pSecName, C_WCP pKeyName, BOOL fVolatile, C_WCP pStr)
{
	BOOL	rc = FALSE;
	HKEY	hKey;

	if (pStr != NULL) {
		if (hKey = SubCreateKeyW(pPath, pSecName, KEY_ALL_ACCESS, fVolatile)) {
			rc = (RegSetValueExW(hKey, pKeyName, 0, REG_EXPAND_SZ, (C_BCP)pStr, (DWORD)(wcslen(pStr) + 1) * 2) == ERROR_SUCCESS);
		}
	}
	return rc;
}
//==============================================================================================================//
//	レジストリファイル書き込み（バイナリデータ）																//
//																												//
//	引　数：	pPath		- パス名のアドレス																	//
//				pSecName	- セクション名のアドレス															//
//				pKeyName	- キー名のアドレス（規定項目の場合はNULL)											//
//				fVolatile	- FALSE:恒久記録，TRUE:一時記録														//
//				pDat		- 書き込むバイナリデータのアドレス													//
//				lDat		- 書き込むバイナリデータのバイト数													//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - エラー																					//
//==============================================================================================================//
//----- バイト文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcPutRegFileBinA(C_BCP pPath, C_BCP pSecName, C_BCP pKeyName, BOOL fVolatile, C_VOP pDat, UI lDat)
{
	return AjcPutRegFileBinExA(pPath, pSecName, pKeyName, fVolatile, pDat, lDat, BinDataDirA);
}
//----- ワイド文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcPutRegFileBinW(C_WCP pPath, C_WCP pSecName, C_WCP pKeyName, BOOL fVolatile, C_VOP pDat, UI lDat)
{
	return AjcPutRegFileBinExW(pPath, pSecName, pKeyName, fVolatile, pDat, lDat, BinDataDirW);
}
//==============================================================================================================//
//	レジストリファイル書き込み（バイナリデータ，バイナリデータフォルダ指定）									//
//																												//
//	引　数：	pPath		- パス名のアドレス																	//
//				pSecName	- セクション名のアドレス															//
//				pKeyName	- キー名のアドレス（規定項目の場合はNULL)											//
//				fVolatile	- FALSE:恒久記録，TRUE:一時記録														//
//				pDat		- 書き込むバイナリデータのアドレス													//
//				lDat		- 書き込むバイナリデータのバイト数													//
//				pBinDir		- バイナリデータフォルダ															//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - エラー																					//
//==============================================================================================================//
//----- バイト文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcPutRegFileBinExA(C_BCP pPath, C_BCP pSecName, C_BCP pKeyName, BOOL fVolatile, C_VOP pDat, UI lDat, C_BCP pBinDir)
{
	BOOL	rc = FALSE;
	HANDLE	hFile;
	UL		bytes;
	BCP		pTail;
	BC		tail[MAX_PATH];
	BC		path[MAX_PATH];

	do {
		//----- NULLチェック -----------------------------------------------------------------------------------//
		if (pDat	 == NULL) break;
		//----- バイナリファイル名設定 -------------------------------------------------------------------------//
		if (AjcGetRegFileStrA(pPath, pSecName, pKeyName, "", tail, MAX_PATH) != 0) {
			if ((pTail = SubProfileGenerateBinFileA(fVolatile, tail, path, pBinDir)) == NULL) break;
		}
		else {
			if ((pTail = SubProfileGenerateBinFileA(fVolatile, NULL, path, pBinDir)) == NULL) break;
			if (!AjcPutRegFileStrA(pPath, pSecName, pKeyName, fVolatile, pTail)) {
				DeleteFileA(path);
				break;
			}
		}
		//----- バイナリファイル書き込み -----------------------------------------------------------------------//
		hFile = CreateFileA(path, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
		if (hFile != INVALID_HANDLE_VALUE) {
			WriteFile(hFile, pDat, lDat, &bytes, NULL);
			CloseHandle(hFile);
			if (bytes == lDat) {
				rc = TRUE;
			}
			else {
				DeleteFileA(path);
			}
		}
		if (rc == FALSE) {
			AjcDelRegKeyA(pPath, pSecName, pKeyName);
		}
	} while(0);

	return rc;
}
//----- ワイド文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcPutRegFileBinExW(C_WCP pPath, C_WCP pSecName, C_WCP pKeyName, BOOL fVolatile, C_VOP pDat, UI lDat, C_WCP pBinDir)
{
	BOOL	rc = FALSE;
	HANDLE	hFile;
	UL		bytes;
	WCP		pTail;
	WC		tail[MAX_PATH];
	WC		path[MAX_PATH];

	do {
		//----- NULLチェック -----------------------------------------------------------------------------------//
		if (pDat	 == NULL) break;
		//----- バイナリファイル名設定 -------------------------------------------------------------------------//
		if (AjcGetRegFileStrW(pPath, pSecName, pKeyName, L"", tail, MAX_PATH) != 0) {
			if ((pTail = SubProfileGenerateBinFileW(fVolatile, tail, path, pBinDir)) == NULL) break;
		}
		else {
			if ((pTail = SubProfileGenerateBinFileW(fVolatile, NULL, path, pBinDir)) == NULL) break;
			if (!AjcPutRegFileStrW(pPath, pSecName, pKeyName, fVolatile, pTail)) {
				DeleteFileW(path);
				break;
			}
		}
		//----- バイナリファイル書き込み -----------------------------------------------------------------------//
		hFile = CreateFileW(path, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
		if (hFile != INVALID_HANDLE_VALUE) {
			WriteFile(hFile, pDat, lDat, &bytes, NULL);
			CloseHandle(hFile);
			if (bytes == lDat) {
				rc = TRUE;
			}
			else {
				DeleteFileW(path);
			}
		}
		if (rc == FALSE) {
			AjcDelRegKeyW(pPath, pSecName, pKeyName);
		}
	} while(0);

	return rc;
}

//==============================================================================================================//
//	レジストリセクション削除																					//
//																												//
//	引　数：	pPath		- パス名のアドレス																	//
//				pSecName	- セクション名のアドレス															//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - エラー																					//
//==============================================================================================================//
//----- バイト文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcDelRegSectA	  (C_BCP pPath, C_BCP pSecName)
{
	return AjcDelRegSectExA(pPath, pSecName, BinDataDirA);
}
//----- ワイド文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcDelRegSectW	  (C_WCP pPath, C_WCP pSecName)
{
	return AjcDelRegSectExW(pPath, pSecName, BinDataDirW);
}
//==============================================================================================================//
//	レジストリセクション削除（バイナリデータフォルダ指定）														//
//																												//
//	引　数：	pPath		- パス名のアドレス																	//
//				pSecName	- セクション名のアドレス															//
//				pBinDir		- バイナリデータフォルダ															//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - エラー																					//
//==============================================================================================================//
//----- バイト文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcDelRegSectExA	  (C_BCP pPath, C_BCP pSecName, C_BCP pBinDir)
{
	BOOL	rc = FALSE;
	HKEY	hKey;
	UI		ix;
	UL		lName, lTail;
	BC		name[AJCMAX_REGPATH];
	BC		tail[MAX_PATH];

	//----- キー内の全ての値とバイナリファイル削除 ---------------------------------------------------------//
	if (hKey = SubOpenKeyA(pPath, pSecName, KEY_ALL_ACCESS)) {
		ix = 0;
		lName = AJCMAX_REGPATH; lTail = MAX_PATH;
		while(RegEnumValueA(hKey, ix, name, &lName, NULL, NULL, tail, &lTail) == ERROR_SUCCESS) {
			if (RegDeleteValueA(hKey, name) == ERROR_SUCCESS) {
				if (mbsstr(tail, "\\Ajr")) {
					SubProfileDeleteBinFileA(tail, pBinDir);
				}
			}
			else ix++;
			lName = AJCMAX_REGPATH; lTail = MAX_PATH;
		}
		AjcCloseRegFile();
	}
	//----- キー削除 ---------------------------------------------------------------------------------------//
	if (RegOpenKeyExA(hKeyTop, pPath, 0, KEY_ALL_ACCESS, &hKey) == ERROR_SUCCESS) {
		rc = (RegDeleteKeyA(hKey, pSecName) != ERROR_SUCCESS);
		RegCloseKey(hKey);
	}
	return rc;
}
//----- ワイド文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcDelRegSectExW	  (C_WCP pPath, C_WCP pSecName, C_WCP pBinDir)
{
	BOOL	rc = FALSE;
	HKEY	hKey;
	UI		ix;
	UL		lName, lTail;
	UW		name[AJCMAX_REGPATH];
	UW		tail[MAX_PATH];

	//----- キー内の全ての値とバイナリファイル削除 ---------------------------------------------------------//
	if (hKey = SubOpenKeyW(pPath, pSecName, KEY_ALL_ACCESS)) {
		ix = 0;
		lName = AJCMAX_REGPATH; lTail = MAX_PATH;
		while(RegEnumValueW(hKey, ix, name, &lName, NULL, NULL, (VOP)tail, &lTail) == ERROR_SUCCESS) {
			if (RegDeleteValueW(hKey, name) == ERROR_SUCCESS) {
				if (wcsstr(tail, L"\\Ajr")) {
					SubProfileDeleteBinFileW(tail, pBinDir);
				}
			}
			else ix++;
			lName = AJCMAX_REGPATH; lTail = MAX_PATH;
		}
		AjcCloseRegFile();
	}
	//----- キー削除 ---------------------------------------------------------------------------------------//
	if (RegOpenKeyExW(hKeyTop, pPath, 0, KEY_ALL_ACCESS, &hKey) == ERROR_SUCCESS) {
		rc = (RegDeleteKeyW(hKey, pSecName) != ERROR_SUCCESS);
		RegCloseKey(hKey);
	}
	return rc;
}

//==============================================================================================================//
//	レジストリキー削除																							//
//																												//
//	引　数：	pPath		- パス名のアドレス																	//
//				pSecName	- セクション名のアドレス															//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - エラー																					//
//==============================================================================================================//
//----- バイト文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcDelRegKeyA	  (C_BCP pPath, C_BCP pSecName, C_BCP pKeyName)
{
	return AjcDelRegKeyExA(pPath, pSecName, pKeyName, BinDataDirA);
}
//----- ワイド文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcDelRegKeyW	  (C_WCP pPath, C_WCP pSecName, C_WCP pKeyName)
{
	return AjcDelRegKeyExW(pPath, pSecName, pKeyName, BinDataDirW);
}
//==============================================================================================================//
//	レジストリキー削除（バイナリデータフォルダ指定）															//
//																												//
//	引　数：	pPath		- パス名のアドレス																	//
//				pSecName	- セクション名のアドレス															//
//				pBinDir		- バイナリデータフォルダ															//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - エラー																					//
//==============================================================================================================//
//----- バイト文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcDelRegKeyExA	  (C_BCP pPath, C_BCP pSecName, C_BCP pKeyName, C_BCP pBinDir)
{
	BOOL	rc = FALSE;
	HKEY	hKey;
	BC		tail[MAX_PATH];

	if (pKeyName != NULL) {
		//----- バイナリファイル削除 -----//
		if (AjcGetRegFileStrA(pPath, pSecName, pKeyName, "", tail, MAX_PATH) != 0) {
			SubProfileDeleteBinFileA(tail, pBinDir);
		}
		//----- キー削除 -----------------//
		if ((hKey = SubOpenKeyA(pPath, pSecName, KEY_ALL_ACCESS)) != NULL) {
			rc = (RegDeleteValueA(hKey, pKeyName) == ERROR_SUCCESS);
		}
	}
	return rc;
}
//----- ワイド文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcDelRegKeyExW	  (C_WCP pPath, C_WCP pSecName, C_WCP pKeyName, C_WCP pBinDir)
{
	BOOL	rc = FALSE;
	HKEY	hKey;
	UW		tail[MAX_PATH];

	if (pKeyName != NULL) {
		//----- バイナリファイル削除 -----//
		if (AjcGetRegFileStrW(pPath, pSecName, pKeyName, L"", tail, MAX_PATH) != 0) {
			SubProfileDeleteBinFileW(tail, pBinDir);
		}
		//----- キー削除 -----------------//
		if ((hKey = SubOpenKeyW(pPath, pSecName, KEY_ALL_ACCESS)) != NULL) {
			rc = (RegDeleteValueW(hKey, pKeyName) == ERROR_SUCCESS);
		}
	}
	return rc;
}
//==============================================================================================================//
//	レジストリセクション消去																					//
//																												//
//	引　数：	pPath		- パス名のアドレス																	//
//				pSecName	- セクション名のアドレス															//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - エラー																					//
//==============================================================================================================//
//----- バイト文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcRemoveRegSectA	  (C_BCP pPath, C_BCP pSecName)
{
	BOOL	rc = FALSE;

	if (rc = AjcCleanupRegSectA(pPath, pSecName)) {
		rc = AjcDelRegSectA(pPath, pSecName);
	}
	return rc;
}
//----- バイト文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcRemoveRegSectW	  (C_WCP pPath, C_WCP pSecName)
{
	BOOL	rc = FALSE;

	if (rc = AjcCleanupRegSectW(pPath, pSecName)) {
		rc = AjcDelRegSectW(pPath, pSecName);
	}
	return rc;
}
//==============================================================================================================//
//	レジストリセクションクリーンアップ																			//
//																												//
//	引　数：	pPath		- パス名のアドレス																	//
//				pSecName	- セクション名のアドレス															//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - エラー																					//
//==============================================================================================================//
//----- バイト文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcCleanupRegSectA	  (C_BCP pPath, C_BCP pSecName)
{
	BOOL	rc = FALSE;
	WCP		pPathW = NULL;
	WCP		pSecW  = NULL;
	UI		lPathW, lSecW;

	if (pPath != NULL && pSecName != NULL) {
		if (pPathW = AjcTAllocW(lPathW = MultiByteToWideChar(CP_ACP, 0, pPath, -1, NULL, 0))) {
			MultiByteToWideChar(CP_ACP, 0, pPath, -1, pPathW, lPathW);
			if (pSecW = AjcTAllocW(lSecW = MultiByteToWideChar(CP_ACP, 0, pSecName, -1, NULL, 0))) {
				MultiByteToWideChar(CP_ACP, 0, pSecName, -1, pSecW, lSecW);
				rc = AjcCleanupRegSectW(pPathW, pSecW);
				free(pSecW);
			}
			free(pPathW);
		}
	}
	return rc;
}
//----- ワイド文字用 -------------------------------------------------------------------------------------------//
__declspec(thread) static HAJCSPL hSplCleanupW = NULL;
static	VO				CorrectUnderSectPathW(C_WCP pPath, C_WCP pSecName);
static	BOOL CALLBACK	cbEnumCleanupSectW(C_UTP pSect, UX cbp);
 static BOOL CALLBACK	cbEnumCleanupPathW(C_UTP pPath, UX cbp);

AJCEXPORT BOOL	 WINAPI AjcCleanupRegSectW	  (C_WCP pPath, C_WCP pSecName)
{
	BOOL	rc = FALSE;
	HAJCSPL	hSpl = NULL;

	//	文字列プール生成
	if (hSplCleanupW = AjcSplCreateW(AJCCMP_IGNORE_WIDTH)) {
		//	下位セクション名収集
		CorrectUnderSectPathW(pPath, pSecName);
		//	セクションクリーンアップ（降順列挙）
		AjcSplEnumStrW(hSplCleanupW, 0, cbEnumCleanupPathW, TRUE);
		//	文字列プール破棄
		AjcSplDelete(hSplCleanupW);
		rc = TRUE;
	}
	return rc;
}
//----- レジストリセクション名配列作成 -------------------------------------------------------------------------//
static	VO		CorrectUnderSectPathW(C_WCP pPath, C_WCP pSecName)
{
	WC	path[AJCMAX_REGPATH];

	//	下位のセクション名収集
	MAjcStrCpyW(path, AJCTSIZE(path), pPath);
	AjcPathCatW(path, pSecName, AJCTSIZE(path));
	AjcEnumRegSectW(path, (UX)path, cbEnumCleanupSectW);
}
//----- セクション名収集コールバック ---------------------------------------------------------------------------//
static	BOOL CALLBACK cbEnumCleanupSectW(C_UTP pSect, UX cbp)
{
	WCP		pUpper = (WCP)cbp;
	WC		path[AJCMAX_REGPATH];

	//	パス名を文字列プールへ登録
	AjcSnPrintF(path, AJCTSIZE(path), TEXT("%s\t%s"), pUpper, pSect);
	AjcSplRegistW(hSplCleanupW, path);
	//	下位のセクション名収集
	CorrectUnderSectPathW(pUpper, pSect);

	return TRUE;
}
//----- 文字列プールの列挙コールバック -------------------------------------------------------------------------//
static BOOL CALLBACK cbEnumCleanupPathW(C_UTP pPath, UX cbp)
 {
	UTP		pUpper = NULL;
	UTP		pSect  = NULL;
	WC		path[AJCMAX_REGPATH];

	do {
		MAjcStrCpy(path, AJCTSIZE(path), pPath);
		if ((pUpper = MAjcStrTok(path, TEXT("\t"))) == NULL) break;
		if ((pSect	= MAjcStrTok(NULL, TEXT("\0"))) == NULL) break;
		AjcDelRegSect(pUpper, pSect);
	} while(0);

	return TRUE;	//	列挙継続
 }
//==============================================================================================================//
//	レジストリファイル情報取得																					//
//																												//
//	引　数：	pBuf		- 現在オープン中のレジストリパス名を格納するバッファのアドレス						//
//				lBuf		- 現在オープン中のレジストリパス名を格納するバッファのバイト数／文字数				//
//																												//
//	戻り値：	≠NULL：　レジストリキーハンドル																//
//				＝NULL：　レジストリキーは未オープン															//
//==============================================================================================================//
//----- バイト文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT HKEY	 WINAPI AjcGetRegFileInfoA(BCP pBuf, int lBuf)
{
	HKEY	hKey = NULL;

	if (hRegKey) {
		hKey = hRegKey;
		if (pBuf != NULL && lBuf != 0) {
			WideCharToMultiByte(CP_ACP, 0, SvPath, -1, pBuf, lBuf, NULL, NULL);
		}
	}
	else {
		hKey = NULL;
		if (pBuf != NULL && lBuf != 0) {
			*pBuf = 0;
		}
	}
	return hKey;
}

//----- ワイド文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT HKEY	 WINAPI AjcGetRegFileInfoW(WCP pBuf, int lBuf)
{
	HKEY	hKey = NULL;

	if (hRegKey) {
		hKey = hRegKey;
		if (pBuf != NULL && lBuf != 0) {
			wcsncpy(pBuf, SvPath, lBuf - 1);
			pBuf[lBuf - 1] = 0;
		}
	}
	else {
		hKey = NULL;
		if (pBuf != NULL && lBuf != 0) {
			*pBuf = 0;
		}
	}
	return hKey;
}
//==============================================================================================================//
//	レジストリファイルクローズ																					//
//																												//
//	引　数：	なし																							//
//																												//
//	戻り値：	なし																							//
//==============================================================================================================//
AJCEXPORT VO	 WINAPI AjcCloseRegFile(VO)
{
	if (hRegKey) {
		//	レジストリキークローズ
		RegCloseKey(hRegKey);
		hRegKey  = NULL;
		SvAccess = 0;
		memset(SvPath, 0, sizeof SvPath);
	}
}
//==============================================================================================================//
//	レジストリセクション名収集																					//
//																												//
//	引　数：	pPath		- パス名のアドレス																	//
//				cbp			- コールバックパラメタ																//
//				cb			- セクション名を通知するコールバック関数（不要時はNULL)								//
//																												//
//	戻り値：	収集したセクション名の個数																		//
//==============================================================================================================//
//----- バイト文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT int	 WINAPI AjcEnumRegSectA 	(C_BCP pPath, UX cbp, BOOL (CALLBACK *cb)(C_BCP pSect, UX cbp))
{
	int			rc = 0;
	HKEY		hKey;
	UI			ix, lSubKeyBuf;
	FILETIME	ft;
	BC			SubKeyName[512];
	LSTATUS		rsu;

	if ((hKey = SubOpenTempKeyA(pPath, NULL, KEY_READ)) != NULL) {
		ix = 0;
		lSubKeyBuf = AJCTSIZE(SubKeyName);
		while ((rsu = RegEnumKeyExA(hKey, ix, SubKeyName, &lSubKeyBuf, NULL, NULL, NULL, &ft)) != ERROR_NO_MORE_ITEMS) {
			if (rsu == ERROR_SUCCESS) {
				rc++;
				if (cb != NULL) {
					if (!cb(SubKeyName, cbp)) {
						break;
					}
				}
				ix++;
			}
			lSubKeyBuf = AJCTSIZE(SubKeyName);
		}
		RegCloseKey(hKey);
	}
	return rc;
}
//----- ワイド文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT int	 WINAPI AjcEnumRegSectW 	(C_WCP pPath, UX cbp, BOOL (CALLBACK *cb)(C_WCP pSect, UX cbp))
{
	int			rc = 0;
	HKEY		hKey;
	UI			ix, lSubKeyBuf;
	FILETIME	ft;
	UW			SubKeyName[512];
	LSTATUS		rsu;

	if ((hKey = SubOpenTempKeyW(pPath, NULL, KEY_READ)) != NULL) {
		ix = 0;
		lSubKeyBuf = AJCTSIZE(SubKeyName);
		while ((rsu = RegEnumKeyExW(hKey, ix, SubKeyName, &lSubKeyBuf, NULL, NULL, NULL, &ft)) != ERROR_NO_MORE_ITEMS) {
			if (rsu == ERROR_SUCCESS) {
				rc++;
				if (cb != NULL) {
					if (!cb(SubKeyName, cbp)) {
						break;
					}
				}
				ix++;
			}
			lSubKeyBuf = AJCTSIZE(SubKeyName);
		}
		RegCloseKey(hKey);
	}
	return rc;
}
//==============================================================================================================//
//	レジストリキー収集																							//
//																												//
//	引　数：	pPath		- パス名のアドレス																	//
//				pSecName	- セクション名のアドレス															//
//				cbp			- コールバックパラメタ																//
//				cb			- キーを通知するコールバック関数（不要時はNULL)										//
//																												//
//	戻り値：	収集したレジストリキーの個数																	//
//==============================================================================================================//
//----- バイト文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT int	 WINAPI AjcEnumRegKeyA	   (C_BCP pPath, C_BCP pSecName, UX cbp, BOOL (CALLBACK *cb)(C_BCP pKey, AJCREGTYPE type, UX cbp))
{
	int		rc = 0;
	HKEY	hKey;
	UI		ix, lKeyBuf, type;
	BC		KeyName[512];
	LSTATUS	rsu;

	if ((hKey = SubOpenTempKeyA(pPath, pSecName, KEY_READ)) != NULL) {
		ix = 0;
		lKeyBuf = AJCTSIZE(KeyName);
		while ((rsu = RegEnumValueA(hKey, ix, KeyName, &lKeyBuf, NULL, &type, NULL, NULL)) != ERROR_NO_MORE_ITEMS) {
			if (rsu == ERROR_SUCCESS) {
				rc++;
				if (cb != NULL) {
					if (!cb(KeyName, type, cbp)) {
						break;
					}
				}
				ix++;
			}
			lKeyBuf = AJCTSIZE(KeyName);
		}
		RegCloseKey(hKey);
	}
	return rc;
}
//----- ワイド文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT int	 WINAPI AjcEnumRegKeyW	   (C_WCP pPath, C_WCP pSecName, UX cbp, BOOL (CALLBACK *cb)(C_WCP pKey, AJCREGTYPE type, UX cbp))
{
	int		rc = 0;
	HKEY	hKey;
	UI		ix, lKeyBuf, type;
	WC		KeyName[512];
	LSTATUS	rsu;

	if ((hKey = SubOpenTempKeyW(pPath, pSecName, KEY_READ)) != NULL) {
		ix = 0;
		lKeyBuf = AJCTSIZE(KeyName);
		while ((rsu = RegEnumValueW(hKey, ix, KeyName, &lKeyBuf, NULL, &type, NULL, NULL)) != ERROR_NO_MORE_ITEMS) {
			if (rsu == ERROR_SUCCESS) {
				rc++;
				if (cb != NULL) {
					if (!cb(KeyName, type, cbp)) {
						break;
					}
				}
				ix++;
			}
			lKeyBuf = AJCTSIZE(KeyName);
		}
		RegCloseKey(hKey);
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	既存レジストリキーのオープン（レジストリキーを一元的に共用）												//
//																												//
//	引　数：	pPath		- パス名のアドレス																	//
//				pSec		- セクション名のアドレス															//
//				acc			- アクセス権(REG_ALL_ACCESS / REG_READ)												//
//																												//
//	戻り値：	≠NULL - レジストリキーのハンドル																//
//				＝NULL - エラー																					//
//																												//
//	備　考：	常に１つのレジストリキーがオープン状態となる。													//
//				この１つのレジストリキーをクローズするには、AjcCloseRegFile()を実行します。						//
//--------------------------------------------------------------------------------------------------------------//
//----- バイト文字用 -------------------------------------------------------------------------------------------//
static	HKEY	SubOpenKeyA(C_BCP pPath, C_BCP pSec, REGSAM acc)
{
	HKEY	hKey = NULL;
	int		lPathW, lSecW;
	WCP		pPathW = NULL;
	WCP		pSecW  = NULL;

	if (pPath != NULL) {
		if (pPathW = AjcTAllocW(lPathW = MultiByteToWideChar(CP_ACP, 0, pPath, -1, NULL, 0))) {
			MultiByteToWideChar(CP_ACP, 0, pPath, -1, pPathW, lPathW);
		}
	}
	else pPathW = NULL;

	if (pSec != NULL) {
		if (pSecW = AjcTAllocW(lSecW  = MultiByteToWideChar(CP_ACP, 0, pSec , -1, NULL, 0))) {
			MultiByteToWideChar(CP_ACP, 0, pSec , -1, pSecW , lSecW);
		}
	}
	else pSecW = NULL;

	hKey = SubOpenKeyW(pPathW, pSecW, acc);

	if (pPathW) AjcTFree(pPathW);
	if (pSecW ) AjcTFree(pSecW );

	return hKey;
}
//----- ワイド文字用 -------------------------------------------------------------------------------------------//
static	HKEY	SubOpenKeyW(C_WCP pPath, C_WCP pSec, REGSAM acc)
{
	HKEY	hKey = NULL;
	WC		path[AJCMAX_REGPATH];

	//----- パス名設定（パスとセクションを合成） ---//
	path[0] = 0;
	if (pPath != NULL) {
		AjcSnPrintFW(path, AJCMAX_REGPATH, L"%s", pPath);
	}
	if (pSec  != NULL) {
		if (path[0] != 0) AjcPathCatW (path, pSec, AJCMAX_REGPATH);
		else			  AjcSnPrintFW(path, AJCMAX_REGPATH, L"%s", pSec);
	}

	//----- レジストリキー・オープン ---------------//
	if (hRegKey != NULL  &&  wcsicmp(path, SvPath) == 0 && SvAccess == acc) {	//	キー生成済み, 同一キーパス and 同一アクセス権？
		hKey = hRegKey;															//		戻り値＝既存キーハンドル
	}
	else {																		//	キー未生成 or 異なるキーパス？
		if (hRegKey != NULL) {													//		キー生成済み？
			RegCloseKey(hRegKey);												//			キークローズ
			hRegKey = NULL;														//			・
		}
		if (RegOpenKeyExW(hKeyTop,												//		キー・オープン，成功？
							path,												//		・	（サブキー）
							0,													//		・	（常に０）
							acc,												//		・	（キークラス名，既存サブキーの場合は不要）
							&hKey) == ERROR_SUCCESS && hKey != NULL) {			//		・	（ハンドルを格納するバッファのアドレス）
			wcscpy(SvPath, path);												//			キーパス名退避
			SvAccess = acc;														//			アクセス権退避
			hRegKey  = hKey;													//			戻り値＝新キーハンドル
		}
		else {																	//		キー・オープン失敗？
			memset(SvPath, 0, sizeof SvPath);									//			キーパス名クリアー
			SvAccess = 0;														//			アクセス権クリアー
			hKey	 = NULL;													//			戻り値＝失敗
		}
	}
	return hKey;
}
//--------------------------------------------------------------------------------------------------------------//
//	既存レジストリキーのオープン（レジストリキーを共用しない）													//
//																												//
//	引　数：	pPath		- パス名のアドレス																	//
//				pSec		- セクション名のアドレス															//
//				acc			- アクセス権(REG_ALL_ACCESS / REG_READ)												//
//																												//
//	戻り値：	≠NULL - レジストリキーのハンドル																//
//				＝NULL - エラー																					//
//																												//
//	備　考：	戻り値（レジストリキーのハンドル）は、呼び出し元で RegCloseKey() によりクローズする必要がある。	//
//--------------------------------------------------------------------------------------------------------------//
//----- バイト文字用 -------------------------------------------------------------------------------------------//
static	HKEY	SubOpenTempKeyA(C_BCP pPath, C_BCP pSec, REGSAM acc)
{
	HKEY	hKey = NULL;
	int		lPathW, lSecW;
	WCP		pPathW = NULL;
	WCP		pSecW  = NULL;

	if (pPath != NULL) {
		if (pPathW = AjcTAllocW(lPathW = MultiByteToWideChar(CP_ACP, 0, pPath, -1, NULL, 0))) {
			MultiByteToWideChar(CP_ACP, 0, pPath, -1, pPathW, lPathW);
		}
	}
	else pPathW = NULL;

	if (pSec != NULL) {
		if (pSecW = AjcTAllocW(lSecW  = MultiByteToWideChar(CP_ACP, 0, pSec , -1, NULL, 0))) {
			MultiByteToWideChar(CP_ACP, 0, pSec , -1, pSecW , lSecW);
		}
	}
	else pSecW = NULL;

	hKey = SubOpenTempKeyW(pPathW, pSecW, acc);

	if (pPathW) AjcTFree(pPathW);
	if (pSecW ) AjcTFree(pSecW );

	return hKey;
}
//----- ワイド文字用 -------------------------------------------------------------------------------------------//
static	HKEY	SubOpenTempKeyW(C_WCP pPath, C_WCP pSec, REGSAM acc)
{
	HKEY	hKey = NULL;
	WC		path[AJCMAX_REGPATH];

	//----- パス名設定（パスとセクションを合成） ---//
	path[0] = 0;
	if (pPath != NULL) {
		AjcSnPrintFW(path, AJCMAX_REGPATH, L"%s", pPath);
	}
	if (pSec  != NULL) {
		if (path[0] != 0) AjcPathCatW (path, pSec, AJCMAX_REGPATH);
		else			  AjcSnPrintFW(path, AJCMAX_REGPATH, L"%s", pSec);
	}

	//----- レジストリキー・オープン ---------------//
	if (RegOpenKeyExW(hKeyTop,												//		キー・オープン，成功？
						path,												//		・	（サブキー）
						0,													//		・	（常に０）
						acc,												//		・	（キークラス名，既存サブキーの場合は不要）
						&hKey) == ERROR_SUCCESS && hKey != NULL) {			//		・	（ハンドルを格納するバッファのアドレス）
	}
	else {																	//		キー・オープン失敗？
		hKey	 = NULL;													//			戻り値＝失敗
	}
	return hKey;
}

//--------------------------------------------------------------------------------------------------------------//
//	レジストリキーの生成（レジストリキーを一元的に共用）														//
//																												//
//	引　数：	pPath		- パス名のアドレス																	//
//				pSec		- セクション名のアドレス															//
//				acc			- アクセス権(REG_ALL_ACCESS / REG_READ)												//
//				fVolatile	- レジストリキーを一時的なものにするか、恒久的に保存するかの指定					//
//								FALSE - レジストリキーを恒久的に保存する										//
//								TRUE  - レジストリキーを一時的に保存する（システム・シャットダウン時に消滅）	//
//																												//
//	戻り値：	≠NULL - レジストリキーのハンドル																//
//				＝NULL - エラー																					//
//																												//
//	備　考：	常に１つのレジストリキーがオープン状態となる。													//
//				この１つのレジストリキーをクローズするには、AjcCloseRegFile()を実行します。						//
//--------------------------------------------------------------------------------------------------------------//
//----- バイト文字用 -------------------------------------------------------------------------------------------//
static	HKEY	SubCreateKeyA(C_BCP pPath, C_BCP pSec, REGSAM acc, BOOL fVolatile)
{
	HKEY	hKey = NULL;
	int		lPathW, lSecW;
	WCP		pPathW = NULL;
	WCP		pSecW  = NULL;

	if (pPath != NULL) {
		if (pPathW = AjcTAllocW(lPathW = MultiByteToWideChar(CP_ACP, 0, pPath, -1, NULL, 0))) {
			MultiByteToWideChar(CP_ACP, 0, pPath, -1, pPathW, lPathW);
		}
	}
	else pPathW = NULL;

	if (pSec != NULL) {
		if (pSecW = AjcTAllocW(lSecW  = MultiByteToWideChar(CP_ACP, 0, pSec , -1, NULL, 0))) {
			MultiByteToWideChar(CP_ACP, 0, pSec , -1, pSecW , lSecW);
		}
	}
	else pSecW = NULL;

	hKey = SubCreateKeyW(pPathW, pSecW, acc, fVolatile);

	if (pPathW) AjcTFree(pPathW);
	if (pSecW ) AjcTFree(pSecW );

	return hKey;

}
//----- ワイド文字用 -------------------------------------------------------------------------------------------//
static	HKEY	SubCreateKeyW(C_WCP pPath, C_WCP pSec, REGSAM acc, BOOL fVolatile)
{
	HKEY	hKey = NULL;
	UL		dmy;
	WC		path[AJCMAX_REGPATH];

	//----- パス名設定（パスとセクションを合成） ---//
	path[0] = 0;
	if (pPath != NULL) {
		AjcSnPrintFW(path, AJCMAX_REGPATH, L"%s", pPath);
	}
	if (pSec  != NULL) {
		if (path[0] != 0) AjcPathCatW (path, pSec, AJCMAX_REGPATH);
		else			  AjcSnPrintFW(path, AJCMAX_REGPATH, L"%s", pSec);
	}

	//----- レジストリキー生成 ---------------------//
	if (hRegKey != NULL  &&  wcsicmp(path, SvPath) == 0 && SvAccess == acc) {	//	キー生成済み, 同一キーパス and 同一アクセス権？
		hKey = hRegKey;															//		戻り値＝既存キーハンドル
	}
	else {																		//	キー未生成 or 異なるキーパス？
		//	レジストリキー生成済ならば、一旦クローズする
		if (hRegKey != NULL) {													//		キー生成済み？
			RegCloseKey(hRegKey);												//			キークローズ
			hRegKey = NULL;														//			・
		}
		//	レジストリキー生成
		if (RegCreateKeyExW(hKeyTop,											//		キー生成，成功？
				path,															//		・	（サブキー）
				0,																//		・	（常に０）
				NULL,															//		・	（キークラス名，既存サブキーの場合は不要）
				(fVolatile ? REG_OPTION_VOLATILE : REG_OPTION_NON_VOLATILE),	//		・	（VOLATILE指定）
				acc,															//		・	（キーアクセスオプション）
				NULL,															//		・	（キーのセキュリティ属性）
				&hKey,															//		・	（ハンドルを格納するバッファのアドレス）
				&dmy) == ERROR_SUCCESS && hKey != NULL) {						//		・	（処理コードを格納するバッファのポインタ）
			wcscpy(SvPath, path);												//			キーパス名退避
			SvAccess = acc;														//			アクセス権退避
			hRegKey  = hKey;													//			戻り値＝新キーハンドル
		}
		else {																	//		キー生成失敗？
			memset(SvPath, 0, sizeof SvPath);									//			キーパス名クリアー
			SvAccess = 0;														//			アクセス権クリアー
			hKey	 = NULL;													//			戻り値＝失敗
		}
	}
	return hKey;
}
//==============================================================================================================//
//	バイナリファイル格納用パス名生成																			//
//																												//
//	引　数：	fVolatile	- レジストリキーを一時的なものにするか、恒久的に保存するかの指定					//
//								FALSE - レジストリキーを恒久的に保存する										//
//								TRUE  - レジストリキーを一時的に保存する（システム・シャットダウン時に消滅）	//
//				pTail		- パスの末尾部分文字列のアドレス（NULLの場合は自動生成）							//
//				full		- 生成したファイルパス名を格納するバッファのアドレス								//
//				pBinDir		- バイナリファイル格納フォルダパス													//
//																												//
//	戻り値：	≠NULL - 生成したパス中の末尾部分を示すポインタ													//
//				＝NULL - エラー																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
BCP		SubProfileGenerateBinFileA(BOOL fVolatile, C_BCP pTail, BC full[MAX_PATH], C_BCP pBinDir)
{
	BCP		rc = NULL;
	BOOL	rsu;
	int		lTop;
	BC		mod[MAX_PATH], temp[MAX_PATH];
	BC		drv[_MAX_DRIVE], dir[_MAX_DIR], fname[_MAX_FNAME];

	do {
		//----- パスの先頭部分生成 -------------------------//
		GetModuleFileNameA(NULL, temp, MAX_PATH);
		GetFullPathNameA(mod, MAX_PATH, temp, NULL);
		_splitpath(temp, drv, dir, fname, NULL);
		if (pBinDir != NULL && *pBinDir != 0) AjcSnPrintFA(temp, MAX_PATH, "%s", pBinDir);
		else								  _makepath	  (temp, drv, dir, NULL , NULL);
		//----- 先頭部分の長さ設定 -------------------------//
		lTop = (int)strlen(temp);
		//----- 末尾部分生成 -------------------------------//
		if (pTail == NULL) {
			if (fVolatile) strncat(fname, "_TMP", _MAX_FNAME - 1);
			else		   strncat(fname, "_BIN", _MAX_FNAME - 1);
			fname[_MAX_FNAME - 1] = 0;
			if (!AjcPathCatA(temp, fname, MAX_PATH)) break;
			if (AjcPathExistsA(temp)) rsu = TRUE;
			else					  rsu = CreateDirectoryA(temp, NULL);
			//	フルパス作成
			if (rsu) {
				if (GetTempFileNameA(temp, "Ajr", 0, full) == 0) break;
			}
		}
		else {
			BC	subd[MAX_PATH];
			if (!AjcPathCatA(temp, pTail, MAX_PATH)) break;
			//	末尾フォルダ作成
			_splitpath(temp, drv, dir, fname, NULL);
			_makepath (subd, drv, dir, NULL , NULL);
			if (AjcPathExistsA(subd)) rsu = TRUE;
			else					  rsu = CreateDirectoryA(subd, NULL);
			//	フルパスを返す
			if (rsu) {
				strcpy(full, temp);
			}
		}
		//----- 戻り値設定 ---------------------------------//
		rc = &full[lTop];
		if (*rc == '\\') rc++;
	} while(0);

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
WCP		SubProfileGenerateBinFileW(BOOL fVolatile, C_WCP pTail, WC full[MAX_PATH], C_WCP pBinDir)
{
	WCP		rc = NULL;
	BOOL	rsu;
	int		lTop;
	WC		mod[MAX_PATH], temp[MAX_PATH];
	WC		drv[_MAX_DRIVE], dir[_MAX_DIR], fname[_MAX_FNAME];

	do {
		//----- パスの先頭部分生成 -------------------------//
		GetModuleFileNameW(NULL, mod, MAX_PATH);
		GetFullPathNameW(mod, MAX_PATH, temp, NULL);
		_wsplitpath(temp, drv, dir, fname, NULL);
		if (pBinDir != NULL && *pBinDir != 0) AjcSnPrintFW(temp, MAX_PATH, L"%s", pBinDir);
		else								  _wmakepath  (temp, drv, dir, NULL , NULL);
		//----- 先頭部分の長さ設定 -------------------------//
		lTop = (int)wcslen(temp);
		//----- 末尾部分生成 -------------------------------//
		if (pTail == NULL) {
			if (fVolatile) wcsncat(fname, L"_TMP", _MAX_FNAME - 1);
			else		   wcsncat(fname, L"_BIN", _MAX_FNAME - 1);
			fname[_MAX_FNAME - 1] = 0;
			if (!AjcPathCatW(temp, fname, MAX_PATH)) break;
			if (AjcPathExistsW(temp)) rsu = TRUE;
			else					  rsu = CreateDirectoryW(temp, NULL);
			//	フルパス作成
			if (rsu) {
				if (GetTempFileNameW(temp, L"Ajr", 0, full) == 0) break;
			}
		}
		else {
			WC subd[MAX_PATH];
			if (!AjcPathCatW(temp, pTail, MAX_PATH)) break;
			//	末尾フォルダ作成
			_wsplitpath(temp, drv, dir, fname, NULL);
			_wmakepath (subd, drv, dir, NULL , NULL);
			if (AjcPathExistsW(subd)) rsu = TRUE;
			else					  rsu = CreateDirectoryW(subd, NULL);
			//	フルパスを返す
			if (rsu) {
				wcscpy(full, temp);
			}
		}
		//----- 戻り値設定 ---------------------------------//
		rc = &full[lTop];
		if (*rc == '\\') rc++;
	} while(0);

	return rc;
}
//==============================================================================================================//
//	バイナリファイル削除（SubProfileGenerateBinFile()で生成したファイルのみ削除）								//
//																												//
//	引　数：	pTail	- 削除するバイナリファイルの（自プログラムパス下の）パス名								//
//				pBinDir	- バイナリファイル格納フォルダパス														//
//																												//
//	戻り値：	TRUE  - バイナリファイルを削除した																//
//				NULL  - SubProfileGenerateBinFile()で生成したファイルでない、あるいは、削除失敗					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
BOOL	SubProfileDeleteBinFileA(C_BCP pTail, C_BCP pBinDir)
{
	BOOL	rc = FALSE;
	int		i, len1, len2;
	BC		temp[MAX_PATH], fname1[_MAX_FNAME];
	BC		drv2[_MAX_DRIVE], dir2[_MAX_DIR], fname2[_MAX_FNAME], ext2[_MAX_EXT];

	//----- ファイル名取得 ---------------------------------------//
	GetModuleFileNameA(NULL, temp, MAX_PATH);
	_splitpath(temp, NULL, NULL, fname1, NULL);
	len1 = (int)strlen(fname1);

	//----- 指定された末尾パスを分解 ------------------------------//
	_splitpath(pTail, NULL, dir2, fname2, ext2);
	PathRemoveBackslashA(dir2);
	len2 = (int)strlen(dir2);

	//----- 末尾パス名のチェックとファイル／フォルダ削除 ----------//
	if (len1 + 4 == len2 &&																// 末尾パス長さ
		strnicmp(fname1, dir2, len1) == 0 &&											// パスの前半はプログラム名
		(mbsicmp(&dir2[len1], "_BIN") == 0 || mbsicmp(&dir2[len1], "_TMP") == 0) &&		// パスの後半は"_BIN"/"_TMP"
		strlen(fname2) > 3 && strnicmp(fname2, "Ajr", 3) == 0 &&						// ファイル名の頭は"Ajr"
		mbsicmp(ext2, ".tmp") == 0) {													// 拡張子は".tmp"

		for (i=3; MAjcIsXDigitA(fname2[i]); i++);
		if (fname2[i] == 0) {
			SubProfileGenerateBinFileA(0, pTail, temp, pBinDir);
			if (rc = DeleteFileA(temp)) {
				_splitpath(temp, drv2, dir2, NULL, NULL);
				_makepath (temp, drv2, dir2, NULL, NULL);
				PathRemoveBackslashA(temp);
				RemoveDirectoryA(temp);
			}
		}
	}
	return rc;
}

//----- ワイド文字 ---------------------------------------------------------------------------------------------//
BOOL	SubProfileDeleteBinFileW(C_WCP pTail, C_WCP pBinDir)
{
	BOOL	rc = FALSE;
	int		i, len1, len2;
	WC		temp[MAX_PATH], fname1[_MAX_FNAME];
	WC		drv2[_MAX_DRIVE], dir2[_MAX_DIR], fname2[_MAX_FNAME], ext2[_MAX_EXT];

	//----- ファイル名取得 ---------------------------------------//
	GetModuleFileNameW(NULL, temp, MAX_PATH);
	_wsplitpath(temp, NULL, NULL, fname1, NULL);
	len1 = (int)wcslen(fname1);

	//----- 指定された末尾パスを分解 ------------------------------//
	_wsplitpath(pTail, NULL, dir2, fname2, ext2);
	PathRemoveBackslashW(dir2);
	len2 = (int)wcslen(dir2);

	//----- 末尾パス名のチェックとファイル／フォルダ削除 ----------//
	if (len1 + 4 == len2 &&																// 末尾パス長さ
		wcsnicmp(fname1, dir2, len1) == 0 &&											// パスの前半はプログラム名
		(wcsicmp(&dir2[len1], L"_BIN") == 0 || wcsicmp(&dir2[len1], L"_TMP") == 0) &&	// パスの後半は"_BIN"/"_TMP"
		wcslen(fname2) > 3 && wcsnicmp(fname2, L"Ajr", 3) == 0 &&						// ファイル名の頭は"Ajr"
		wcsicmp(ext2, L".tmp") == 0) {													// 拡張子は".tmp"

		for (i=3; MAjcIsXDigitW(fname2[i]); i++);
		if (fname2[i] == 0) {
			SubProfileGenerateBinFileW(0, pTail, temp, pBinDir);
			if (rc = DeleteFileW(temp)) {
				_wsplitpath(temp, drv2, dir2, NULL, NULL);
				_wmakepath (temp, drv2, dir2, NULL, NULL);
				PathRemoveBackslashW(temp);
				RemoveDirectoryW(temp);
			}
		}
	}
	return rc;
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	レジストリ 直接アクセス																						//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
static	BOOL	SubEnvAddItemA	  (C_BCP pName, C_BCP pPath, BC Dlm, BOOL fFront, AJCREGTYPE type,
									UI (CALLBACK *cbEnvGet)(C_BCP pName, PAJCREGTYPE pType, BCP pBuf, UI lBuf), BOOL (CALLBACK *cbEnvPut)(C_BCP pName, AJCREGTYPE type, C_BCP pTxt));

static	BOOL	SubEnvAddItemW	  (C_WCP pName, C_WCP pPath, WC Dlm, BOOL fFront, AJCREGTYPE type,
									UI (CALLBACK *cbEnvGet)(C_WCP pName, PAJCREGTYPE pType, WCP pBuf, UI lBuf), BOOL (CALLBACK *cbEnvPut)(C_WCP pName, AJCREGTYPE type, C_WCP pTxt));

static	BOOL	SubEnvDelItemA	  (C_BCP pName, C_BCP pPath, BC Dlm, BOOL fErase,
									UI (CALLBACK *cbEnvGet)(C_BCP pName, PAJCREGTYPE pType, BCP pBuf, UI lBuf), BOOL (CALLBACK *cbEnvPut)(C_BCP pName, AJCREGTYPE type, C_BCP pTxt), BOOL (CALLBACK *cbEnvDel)(C_BCP pName));

static	BOOL	SubEnvDelItemW	  (C_WCP pName, C_WCP pPath, WC Dlm, BOOL fErase,
									UI (CALLBACK *cbEnvGet)(C_WCP pName, PAJCREGTYPE pType, WCP pBuf, UI lBuf), BOOL (CALLBACK *cbEnvPut)(C_WCP pName, AJCREGTYPE type, C_WCP pTxt), BOOL (CALLBACK *cbEnvDel)(C_WCP pName));

static	BCP		SearchItemInEnvA  (BCP pStr, C_BCP pPath, BC Dlm);
static	WCP		SearchItemInEnvW  (WCP pStr, C_WCP pPath, WC Dlm);
static	VO		AdjustSemiCollonA (BCP pStr);
static	VO		AdjustSemiCollonW (WCP pStr);

//==============================================================================================================//
//	レジストリに記録されている値の読み出し																		//
//																												//
//	引　数：	hTop	- トップキー																			//
//				pPath	- レジストリパス名のアドレス															//
//				pKey	- キー名称のアドレス（規定項目の場合はNULL)												//
//				pType	- 読み出したタイプを格納するバッファのアドレス（不要時はNULL)							//
//				pBuf	- 読み出した内容を格納するバッファのアドレス(NULL時は必要なバッファサイズ取得)			//
//				lBuf	- 読み出した内容を格納するバッファのバイト数(UNICODEの場合は文字数の２倍の値を指定する)	//
//																												//
//	戻り値：	≠０ - 成功（読み出したバイト数／読み出しに必要なバイト数）										//
//				＝０ - エラー																					//
//==============================================================================================================//
//----- バイト文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT	UI		WINAPI	AjcRegGetA(HKEY hTop, C_BCP pPath, C_BCP pKey, PAJCREGTYPE pType, VOP pBuf, UI lBuf)
{
	UI		rc	  = 0;
	HKEY	hKey  = NULL;
	UL		bytes = (pBuf != NULL ? lBuf : 0);

	if (RegOpenKeyExA(	hTop,										//	キー・オープン，成功？
						pPath,										//	・	（サブキー）
						0,											//	・	（常に０）
						KEY_READ,									//	・	（アクセス権，既存サブキーの場合は不要）
						&hKey) == ERROR_SUCCESS && hKey != NULL) {	//	・	（ハンドルを格納するバッファのアドレス）

		if (RegQueryValueExA(hKey, pKey, NULL, (LPDWORD)pType, (LPBYTE)pBuf, &bytes) == ERROR_SUCCESS) {
			rc = bytes;
		}
		RegCloseKey(hKey);
	}
	return rc;
}
//----- ワイド文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT	UI		WINAPI	AjcRegGetW(HKEY hTop, C_WCP pPath, C_WCP pKey, PAJCREGTYPE pType, VOP pBuf, UI lBuf)
{
	UI		rc	  = 0;
	HKEY	hKey  = NULL;
	UL		bytes = (pBuf != NULL ? lBuf : 0);

	if (RegOpenKeyExW(	hTop,										//	キー・オープン，成功？
						pPath,										//	・	（サブキー）
						0,											//	・	（常に０）
						KEY_READ,									//	・	（アクセス権，既存サブキーの場合は不要）
						&hKey) == ERROR_SUCCESS && hKey != NULL) {	//	・	（ハンドルを格納するバッファのアドレス）

		if (RegQueryValueExW(hKey, pKey, NULL, (LPDWORD)pType, (LPBYTE)pBuf, &bytes) == ERROR_SUCCESS) {
			rc = bytes;
		}
		RegCloseKey(hKey);
	}
	return rc;
}
//==============================================================================================================//
//	レジストリへ値を設定する																					//
//																												//
//	引　数：	hTop		- トップキー																		//
//				pPath		- レジストリパス名のアドレス														//
//				pKey		- キー名称のアドレス（規定項目の場合はNULL)											//
//				type		- 環境変数のタイプ																	//
//				pDat		- 設定するデータのアドレス（NULLの場合は、当該変数を削除）							//
//				lDat		- 設定するデータのバイト数（UNICODEの場合は、文字数の２倍の値を指定する）			//
//																												//
//	戻り値	：	TRUE  - 正常																					//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcRegPutA		  (HKEY hTop, C_BCP pPath, C_BCP pKey, AJCREGTYPE type, C_VOP pDat, UI lDat)
{
	BOOL	rc	 = FALSE;
	HKEY	hKey = NULL;
	UL		Disposition;

	if (pPath != NULL && pDat != NULL && lDat != 0) {
		//	レジストリキー生成
		if (RegCreateKeyExA(hTop,												//	キー生成，成功？
							pPath,												//	・	（サブキー）
							0,													//	・	（常に０）
							NULL,												//	・	（キークラス名，既存サブキーの場合は不要）
							REG_OPTION_NON_VOLATILE,							//	・	（VOLATILE指定）
							KEY_ALL_ACCESS,										//	・	（キーアクセスオプション）
							NULL,												//	・	（キーのセキュリティ属性）
							&hKey,												//	・	（ハンドルを格納するバッファのアドレス）
							&Disposition) == ERROR_SUCCESS && hKey != NULL) {	//	・	（処理コードを格納するバッファのポインタ）
			//	レジストリ書き込み
			rc = (RegSetValueExA(hKey, pKey, 0, type, (const BYTE *)pDat, lDat) == ERROR_SUCCESS);
			//	クローズ
			RegCloseKey(hKey);
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcRegPutW		  (HKEY hTop, C_WCP pPath, C_WCP pKey, AJCREGTYPE type, C_VOP pDat, UI lDat)
{
	BOOL	rc	 = FALSE;
	HKEY	hKey = NULL;
	UL		Disposition;

	if (pPath != NULL && pDat != NULL && lDat != 0) {
		//	レジストリキー生成
		if (RegCreateKeyExW(hTop,												//	キー生成，成功？
							pPath,												//	・	（サブキー）
							0,													//	・	（常に０）
							NULL,												//	・	（キークラス名，既存サブキーの場合は不要）
							REG_OPTION_NON_VOLATILE,							//	・	（VOLATILE指定）
							KEY_ALL_ACCESS,										//	・	（キーアクセスオプション）
							NULL,												//	・	（キーのセキュリティ属性）
							&hKey,												//	・	（ハンドルを格納するバッファのアドレス）
							&Disposition) == ERROR_SUCCESS && hKey != NULL) {	//	・	（処理コードを格納するバッファのポインタ）
			//	レジストリ書き込み
			rc = (RegSetValueExW(hKey, pKey, 0, type, (const BYTE *)pDat, lDat) == ERROR_SUCCESS);
			//	クローズ
			RegCloseKey(hKey);
		}
	}
	return rc;
}
//==============================================================================================================//
//	レジストリ サブキー削除																						//
//																												//
//	引　数：	hTop		- トップキー																		//
//				pPath		- レジストリパス名のアドレス														//
//				pSubKey		- サブキー																			//
//																												//
//	戻り値	：	TRUE  - 正常																					//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcRegDelSubKeyA	  (HKEY hTop, C_BCP pPath, C_BCP pSubKey)
{
	BOOL	rc = FALSE;
	HKEY	hKey;

	//----- サブキー削除 ---------------------------------------------------------------------------------------//
	if (RegOpenKeyExA(hTop, pPath, 0, KEY_ALL_ACCESS, &hKey) == ERROR_SUCCESS) {
		rc = (RegDeleteKeyA(hKey, pSubKey) == ERROR_SUCCESS);
		RegCloseKey(hKey);
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcRegDelSubKeyW	  (HKEY hTop, C_WCP pPath, C_WCP pSubKey)
{
	BOOL	rc = FALSE;
	HKEY	hKey;

	//----- サブキー削除 ---------------------------------------------------------------------------------------//
	if (RegOpenKeyExW(hTop, pPath, 0, KEY_ALL_ACCESS, &hKey) == ERROR_SUCCESS) {
		rc = (RegDeleteKeyW(hKey, pSubKey) == ERROR_SUCCESS);
		RegCloseKey(hKey);
	}
	return rc;
}
//==============================================================================================================//
//	レジストリキー削除																							//
//																												//
//	引　数：	hTop		- トップキー																		//
//				pPath		- レジストリパス名のアドレス														//
//				pKey		- キー名称（値の名称）のアドレス													//
//																												//
//	戻り値	：	TRUE  - 正常																					//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcRegDelValueA	  (HKEY hTop, C_BCP pPath, C_BCP pKey)
{
	BOOL	rc = FALSE;
	UI		err;
	HKEY	hKey;

	if ((err = RegOpenKeyExA(hTop, pPath, 0, KEY_ALL_ACCESS, &hKey)) == ERROR_SUCCESS) {
		rc = (RegDeleteValueA(hKey, pKey) == ERROR_SUCCESS);
		RegCloseKey(hKey);
	}
	else if (err == ERROR_FILE_NOT_FOUND) {
		rc = TRUE;
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcRegDelValueW	  (HKEY hTop, C_WCP pPath, C_WCP pKey)
{
	BOOL	rc = FALSE;
	UI		err;
	HKEY	hKey;

	if ((err = RegOpenKeyExW(hTop, pPath, 0, KEY_ALL_ACCESS, &hKey)) == ERROR_SUCCESS) {
		rc = (RegDeleteValueW(hKey, pKey) == ERROR_SUCCESS);
		RegCloseKey(hKey);
	}
	else if (err == ERROR_FILE_NOT_FOUND) {
		rc = TRUE;
	}
	return rc;
}

//==============================================================================================================//
//	カレントユーザ・レジストリに記録されている環境変数取得														//
//																												//
//	引　数：	pName		- 環境変数名のアドレス																//
//				pBuf		- 環境変数の内容を格納するバッファのアドレス（NULL時は必要なバッファサイズ取得）	//
//				lBuf		- 環境変数の内容を格納するバッファの文字数											//
//																												//
//	戻り値：	≠０ - 成功（読み出した環境変数の文字数／読み出しに必要な文字数（末尾のNULLを含む））			//
//				＝０ - エラー																					//
//==============================================================================================================//
//----- バイト文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT	UI		WINAPI	AjcRegEnvGetA(C_BCP pName, BCP pBuf, UI lBuf)
{
	AJCREGTYPE	type;
	return AjcRegGetA(HKEY_CURRENT_USER, AJC_REGPATH_USRENVA, pName, &type, pBuf, lBuf);
}
//----- ワイド文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT	UI		WINAPI	AjcRegEnvGetW(C_WCP pName, WCP pBuf, UI lBuf)
{
	AJCREGTYPE	type;
	return AjcRegGetW(HKEY_CURRENT_USER, AJC_REGPATH_USRENVW, pName, &type, pBuf, lBuf * 2) / 2;
}
//==============================================================================================================//
//	カレントユーザ・レジストリに記録されている環境変数とタイプ取得												//
//																												//
//	引　数：	pName		- 環境変数名のアドレス																//
//				pType		- 環境変数のタイプを格納するバッファのアドレス（不要時はNULL)						//
//				pBuf		- 環境変数の内容を格納するバッファのアドレス（NULL時は必要なバッファサイズ取得）	//
//				lBuf		- 環境変数の内容を格納するバッファの文字数											//
//																												//
//	戻り値：	≠０ - 成功（読み出した環境変数の文字数／読み出しに必要な文字数（末尾のNULLを含む））			//
//				＝０ - エラー																					//
//==============================================================================================================//
//----- バイト文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT	UI		WINAPI	AjcRegHkCuEnvGetA(C_BCP pName, PAJCREGTYPE pType, BCP pBuf, UI lBuf)
{
	return AjcRegGetA(HKEY_CURRENT_USER, AJC_REGPATH_USRENVA, pName, pType, pBuf, lBuf);
}
//----- ワイド文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT	UI		WINAPI	AjcRegHkCuEnvGetW(C_WCP pName, PAJCREGTYPE pType, WCP pBuf, UI lBuf)
{
	return AjcRegGetW(HKEY_CURRENT_USER, AJC_REGPATH_USRENVW, pName, pType, pBuf, lBuf * 2) / 2;
}
//==============================================================================================================//
//	ローカルマシン・レジストリに記録されている環境変数とタイプ取得												//
//																												//
//	引　数：	pName		- 環境変数名のアドレス																//
//				pType		- 環境変数のタイプを格納するバッファのアドレス（不要時はNULL)						//
//				pBuf		- 環境変数の内容を格納するバッファのアドレス（NULL時は必要なバッファサイズ取得）	//
//				lBuf		- 環境変数の内容を格納するバッファの文字数											//
//																												//
//	戻り値：	≠０ - 成功（読み出した環境変数の文字数／読み出しに必要な文字数（末尾のNULLを含む））			//
//				＝０ - エラー																					//
//==============================================================================================================//
//----- バイト文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT	UI		WINAPI	AjcRegHkLmEnvGetA(C_BCP pName, PAJCREGTYPE pType, BCP pBuf, UI lBuf)
{
	return AjcRegGetA(HKEY_LOCAL_MACHINE, AJC_REGPATH_SYSENVA, pName, pType, pBuf, lBuf);
}
//----- ワイド文字用 -------------------------------------------------------------------------------------------//
AJCEXPORT	UI		WINAPI	AjcRegHkLmEnvGetW(C_WCP pName, PAJCREGTYPE pType, WCP pBuf, UI lBuf)
{
	return AjcRegGetW(HKEY_LOCAL_MACHINE, AJC_REGPATH_SYSENVW, pName, pType, pBuf, lBuf * 2) / 2;
}
//==============================================================================================================//
//	カレントユーザ・レジストリへ環境変数と、その内容を設定する（REG_SZタイプ固定）								//
//																												//
//	引　数：	pName		- 環境変数名のアドレス																//
//				pTxt		- 環境変数へ設定する文字列のアドレス（NULLの場合は、当該環境変数を削除）			//
//																												//
//	戻り値	：	TRUE  - 正常																					//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcRegEnvPutA		  (C_BCP pName, C_BCP pTxt)
{
	BOOL	rc = FALSE;

	rc = AjcRegPutA(HKEY_CURRENT_USER, AJC_REGPATH_USRENVA, pName, AJCREG_SZ, (C_UBP)pTxt, (UI)strlen(pTxt) + 1);

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcRegEnvPutW		  (C_WCP pName, C_WCP pTxt)
{
	BOOL	rc = FALSE;

	rc = AjcRegPutW(HKEY_CURRENT_USER, AJC_REGPATH_USRENVW, pName, AJCREG_SZ, (C_UBP)pTxt, ((UI)wcslen(pTxt) + 1) * 2);

	return rc;
}
//==============================================================================================================//
//	カレントユーザ・レジストリへ環境変数と、その内容を設定する（タイプ指定）									//
//																												//
//	引　数：	pName		- 環境変数名のアドレス																//
//				type		- 環境変数のタイプ(REG_SZ / REG_EXPAND_SZ)											//
//				pTxt		- 環境変数へ設定する文字列のアドレス（NULLの場合は、当該環境変数を削除）			//
//																												//
//	戻り値	：	TRUE  - 正常																					//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcRegHkCuEnvPutA		  (C_BCP pName, AJCREGTYPE type, C_BCP pTxt)
{
	BOOL	rc = FALSE;

	if (type == REG_SZ || type == REG_EXPAND_SZ) {
		rc = AjcRegPutA(HKEY_CURRENT_USER, AJC_REGPATH_USRENVA, pName, type, (C_UBP)pTxt, (UI)strlen(pTxt) + 1);
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcRegHkCuEnvPutW		  (C_WCP pName, AJCREGTYPE type, C_WCP pTxt)
{
	BOOL	rc = FALSE;

	if (type == REG_SZ || type == REG_EXPAND_SZ) {
		rc = AjcRegPutW(HKEY_CURRENT_USER, AJC_REGPATH_USRENVW, pName, type, (C_UBP)pTxt, ((UI)wcslen(pTxt) + 1) * 2);
	}
	return rc;
}
//==============================================================================================================//
//	ローカルマシン・レジストリへ環境変数と、その内容を設定する													//
//																												//
//	引　数：	pName		- 環境変数名のアドレス																//
//				type		- 環境変数のタイプ(REG_SZ / REG_EXPAND_SZ)											//
//				pTxt		- 環境変数へ設定する文字列のアドレス（NULLの場合は、当該環境変数を削除）			//
//																												//
//	戻り値	：	TRUE  - 正常																					//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcRegHkLmEnvPutA		  (C_BCP pName, AJCREGTYPE type, C_BCP pTxt)
{
	BOOL	rc = FALSE;

	if (type == REG_SZ || type == REG_EXPAND_SZ) {
		rc = AjcRegPutA(HKEY_LOCAL_MACHINE, AJC_REGPATH_SYSENVA, pName, type, (C_UBP)pTxt, (UI)strlen(pTxt) + 1);
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcRegHkLmEnvPutW		  (C_WCP pName, AJCREGTYPE type, C_WCP pTxt)
{
	BOOL	rc = FALSE;

	if (type == REG_SZ || type == REG_EXPAND_SZ) {
		rc = AjcRegPutW(HKEY_LOCAL_MACHINE, AJC_REGPATH_SYSENVW, pName, type, (C_UBP)pTxt, ((UI)wcslen(pTxt) + 1) * 2);
	}
	return rc;
}
//==============================================================================================================//
//	カレントユーザ・レジストリのユーザ環境変数を削除する														//
//																												//
//	引　数	：	pName	- 環境変数名																			//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcRegHkCuEnvDelA		  (C_BCP pName)
{
	BOOL	rc = FALSE;

	rc = AjcRegDelValueA(HKEY_CURRENT_USER, AJC_REGPATH_USRENVA, pName);

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcRegHkCuEnvDelW		  (C_WCP pName)
{
	BOOL	rc = FALSE;

	rc = AjcRegDelValueW(HKEY_CURRENT_USER, AJC_REGPATH_USRENVW, pName);

	return rc;
}
//==============================================================================================================//
//	ローカルマシン・レジストリのシステム環境変数を削除する														//
//																												//
//	引　数	：	pName	- 環境変数名																			//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcRegHkLmEnvDelA		  (C_BCP pName)
{
	BOOL	rc = FALSE;

	rc = AjcRegDelValueA(HKEY_LOCAL_MACHINE, AJC_REGPATH_SYSENVA, pName);

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcRegHkLmEnvDelW		  (C_WCP pName)
{
	BOOL	rc = FALSE;

	rc = AjcRegDelValueW(HKEY_LOCAL_MACHINE, AJC_REGPATH_SYSENVW, pName);

	return rc;
}
//==============================================================================================================//
//	カレントユーザ・レジストリの環境変数中に指定項目が存在するかチェック										//
//																												//
//	引　数	：	pName	- 環境変数名																			//
//				pItem	- 追加する項目文字列																	//
//				Dlm		- 区切り文字																			//
//																												//
//	戻り値	：	TRUE  - 項目有り																				//
//				FALSE - 項目無し／エラー																		//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcRegHkCuEnvSrhItemA(C_BCP pName, C_BCP pItem, BC Dlm)
{
	BOOL		rc = FALSE;
	BCP			pBuf;
	AJCREGTYPE	r_type;
	int			len;
	BC			szDlm[2];

	if (pName != NULL && *pName != 0 && pItem != NULL  &&  *pItem != 0) {
		szDlm[0] = Dlm;
		szDlm[1] = 0;
		if (len = AjcRegHkCuEnvGetA(pName, &r_type, NULL, 0)) {
			if (pBuf = AjcTAllocA(len)) {
				AjcRegHkCuEnvGetA(pName, &r_type, pBuf, len);
				rc = (SearchItemInEnvA(pBuf, pItem, Dlm) != NULL);
			}
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcRegHkCuEnvSrhItemW(C_WCP pName, C_WCP pItem, WC Dlm)
{
	BOOL		rc = FALSE;
	WCP			pBuf;
	AJCREGTYPE	r_type;
	int			len;
	WC			szDlm[2];

	if (pName != NULL && *pName != 0 && pItem != NULL  &&  *pItem != 0) {
		szDlm[0] = Dlm;
		szDlm[1] = 0;
		if (len = AjcRegHkCuEnvGetW(pName, &r_type, NULL, 0)) {
			if (pBuf = AjcTAllocW(len)) {
				AjcRegHkCuEnvGetW(pName, &r_type, pBuf, len);
				rc = (SearchItemInEnvW(pBuf, pItem, Dlm) != NULL);
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	カレントユーザ・レジストリの環境変数へ項目を追加する														//
//																												//
//	引　数	：	pName	- 環境変数名																			//
//				pItem	- 追加する項目文字列																	//
//				Dlm		- 区切り文字																			//
//				fFront	- TRUE	: 先頭へ追加																	//
//						  FALSE : 末尾へ追加																	//
//				type	- 環境変数を新規作成する場合のレジストリタイプ											//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcRegHkCuEnvAddItemA(C_BCP pName, C_BCP pItem, BC Dlm, BOOL fFront, AJCREGTYPE type)
{
	BOOL	rc = FALSE;

	rc = SubEnvAddItemA(pName, pItem, Dlm, fFront, type, AjcRegHkCuEnvGetA, AjcRegHkCuEnvPutA);

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcRegHkCuEnvAddItemW(C_WCP pName, C_WCP pItem, WC Dlm, BOOL fFront, AJCREGTYPE type)
{
	BOOL	rc = FALSE;

	rc = SubEnvAddItemW(pName, pItem, Dlm, fFront, type, AjcRegHkCuEnvGetW, AjcRegHkCuEnvPutW);

	return rc;
}
//==============================================================================================================//
//	ローカルマシン・レジストリの環境変数中に指定項目が存在するかチェック										//
//																												//
//	引　数	：	pName	- 環境変数名																			//
//				pItem	- 追加する項目文字列																	//
//				Dlm		- 区切り文字																			//
//																												//
//	戻り値	：	TRUE  - 項目有り																				//
//				FALSE - 項目無し／エラー																		//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcRegHkLmEnvSrhItemA(C_BCP pName, C_BCP pItem, BC Dlm)
{
	BOOL		rc = FALSE;
	BCP			pBuf;
	AJCREGTYPE	r_type;
	int			len;
	BC			szDlm[2];

	if (pName != NULL && *pName != 0 && pItem != NULL  &&  *pItem != 0) {
		szDlm[0] = Dlm;
		szDlm[1] = 0;
		if (len = AjcRegHkLmEnvGetA(pName, &r_type, NULL, 0)) {
			if (pBuf = AjcTAllocA(len)) {
				AjcRegHkLmEnvGetA(pName, &r_type, pBuf, len);
				rc = (SearchItemInEnvA(pBuf, pItem, Dlm) != NULL);
			}
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcRegHkLmEnvSrhItemW(C_WCP pName, C_WCP pItem, WC Dlm)
{
	BOOL		rc = FALSE;
	WCP			pBuf;
	AJCREGTYPE	r_type;
	int			len;
	WC			szDlm[2];

	if (pName != NULL && *pName != 0 && pItem != NULL  &&  *pItem != 0) {
		szDlm[0] = Dlm;
		szDlm[1] = 0;
		if (len = AjcRegHkLmEnvGetW(pName, &r_type, NULL, 0)) {
			if (pBuf = AjcTAllocW(len)) {
				AjcRegHkLmEnvGetW(pName, &r_type, pBuf, len);
				rc = (SearchItemInEnvW(pBuf, pItem, Dlm) != NULL);
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	ローカルマシン・レジストリの環境変数へ項目を追加する														//
//																												//
//	引　数	：	pName	- 環境変数名																			//
//				pItem	- 追加する項目文字列																	//
//				Dlm		- 区切り文字																			//
//				fFront	- TRUE	: 先頭へ追加																	//
//						  FALSE : 末尾へ追加																	//
//				type	- 環境変数を新規作成する場合のレジストリタイプ											//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcRegHkLmEnvAddItemA(C_BCP pName, C_BCP pItem, BC Dlm, BOOL fFront, AJCREGTYPE type)
{
	BOOL	rc = FALSE;

	rc = SubEnvAddItemA(pName, pItem, Dlm, fFront, type, AjcRegHkLmEnvGetA, AjcRegHkLmEnvPutA);

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcRegHkLmEnvAddItemW(C_WCP pName, C_WCP pItem, WC Dlm, BOOL fFront, AJCREGTYPE type)
{
	BOOL	rc = FALSE;

	rc = SubEnvAddItemW(pName, pItem, Dlm, fFront, type, AjcRegHkLmEnvGetW, AjcRegHkLmEnvPutW);

	return rc;
}
//==============================================================================================================//
//	カレントユーザ・レジストリのPATH環境変数中に指定項目が存在するかチェック									//
//																												//
//	引　数	：	path	- 検索するパス文字列																	//
//																												//
//	戻り値	：	TRUE  - 指定項目有り																			//
//				FALSE - 指定項目無し／エラー																	//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcRegHkCuEnvSrhPathItemA(C_BCP pPath)
{
	BOOL	rc = FALSE;

	rc = AjcRegHkCuEnvSrhItemA("PATH" , pPath, ';');

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcRegHkCuEnvSrhPathItemW(C_WCP pPath)
{
	BOOL	rc = FALSE;

	rc = AjcRegHkCuEnvSrhItemW(L"PATH" , pPath, L';');

	return rc;
}
//==============================================================================================================//
//	カレントユーザ・レジストリのPATH環境変数へパス項目を追加する												//
//																												//
//	引　数	：	path	- 追加するパス文字列																	//
//				fFront	- TRUE	: 先頭へ追加																	//
//						  FALSE : 末尾へ追加																	//
///				type	- 環境変数を新規作成する場合のレジストリタイプ											//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcRegHkCuEnvAddPathItemA(C_BCP pPath, BOOL fFront, AJCREGTYPE type)
{
	BOOL	rc = FALSE;

	rc = SubEnvAddItemA("PATH" , pPath, ';' , fFront, type, AjcRegHkCuEnvGetA, AjcRegHkCuEnvPutA);

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcRegHkCuEnvAddPathItemW(C_WCP pPath, BOOL fFront, AJCREGTYPE type)
{
	BOOL	rc = FALSE;

	rc = SubEnvAddItemW(L"PATH", pPath, L';', fFront, type, AjcRegHkCuEnvGetW, AjcRegHkCuEnvPutW);

	return rc;
}
//==============================================================================================================//
//	ローカルマシン・レジストリのPATH環境変数中に指定項目が存在するかチェック									//
//																												//
//	引　数	：	path	- 検索するパス文字列																	//
//																												//
//	戻り値	：	TRUE  - 指定項目有り																			//
//				FALSE - 指定項目無し／エラー																	//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcRegHkLmEnvSrhPathItemA(C_BCP pPath)
{
	BOOL	rc = FALSE;

	rc = AjcRegHkLmEnvSrhItemA("PATH" , pPath, ';');

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcRegHkLmEnvSrhPathItemW(C_WCP pPath)
{
	BOOL	rc = FALSE;

	rc = AjcRegHkLmEnvSrhItemW(L"PATH" , pPath, L';');

	return rc;
}
//==============================================================================================================//
//	ローカルマシン・レジストリのPATH環境変数へパス項目を追加する												//
//																												//
//	引　数	：	path	- 追加するパス文字列																	//
//				fFront	- TRUE	: 先頭へ追加																	//
//						  FALSE : 末尾へ追加																	//
///				type	- 環境変数を新規作成する場合のレジストリタイプ											//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcRegHkLmEnvAddPathItemA(C_BCP pPath, BOOL fFront, AJCREGTYPE type)
{
	BOOL	rc = FALSE;

	rc = SubEnvAddItemA("PATH" , pPath, ';' , fFront, type, AjcRegHkLmEnvGetA, AjcRegHkLmEnvPutA);

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcRegHkLmEnvAddPathItemW(C_WCP pPath, BOOL fFront, AJCREGTYPE type)
{
	BOOL	rc = FALSE;

	rc = SubEnvAddItemW(L"PATH", pPath, L';', fFront, type, AjcRegHkLmEnvGetW, AjcRegHkLmEnvPutW);

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	レジストリの環境変数へ項目を追加する																		//
//																												//
//	引　数	：	pName	 - 環境変数名																			//
//				pItem	 - 追加する項目（文字列）																//
//				Dlm		 - 区切り文字																			//
//				fFront	 - TRUE	: 先頭へ追加，FALSE : 末尾へ追加												//
//				type	 - 環境変数を新規作成する場合のレジストリタイプ											//
//				cbEnvGet - 環境変数読み出し関数																	//
//				cbEnvPut - 環境変数書き込み関数																	//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//--------------------------------------------------------------------------------------------------------------//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
static	BOOL	SubEnvAddItemA(C_BCP pName, C_BCP pItem, BC Dlm, BOOL fFront, AJCREGTYPE type,
										UI	 (CALLBACK *cbEnvGet)(C_BCP pName, PAJCREGTYPE pType, BCP pBuf, UI lBuf),
										BOOL (CALLBACK *cbEnvPut)(C_BCP pName, AJCREGTYPE type, C_BCP pTxt))
{
	BOOL		rc = FALSE;
	BCP			pBuf;
	AJCREGTYPE	r_type;
	int			stl, len;
	BC			szDlm[2];

	if (pName != NULL && *pName != 0 && pItem != NULL  &&  *pItem != 0) {
		szDlm[0] = Dlm;
		szDlm[1] = 0;
		if (stl = (int)cbEnvGet(pName, &r_type, NULL, 0)) {
			stl--;	// 文字列終端分を減算
			len = (stl + 1) + ((int)strlen(pItem) + 1);
			if (pBuf = AjcTAllocA(len)) {
				BCP		p;
				cbEnvGet(pName, &type, pBuf, len);
				//	先頭へ追加する場合、あらかじめ同一項目を削除する
				if (fFront) {
					while ((p = SearchItemInEnvA(pBuf, pItem, Dlm)) != NULL) {
						AjcRepPartStrA(pBuf, len, (UI)((UX)p - (UX)pBuf), (UI)strlen(pItem), "", -1);
					}
				}
				//	指定項目が無ければ、項目追加
				if (SearchItemInEnvA(pBuf, pItem, Dlm) == NULL) {
					do {
						//	先頭へ追加
						if (fFront) {
							if (stl > 0 && pBuf[0] != Dlm) {
								if (AjcRepPartStrA(pBuf, len, 0				   , 0, pItem, -1) == NULL) break;
								if (AjcRepPartStrA(pBuf, len, (UI)strlen(pItem), 0, szDlm, -1) == NULL) break;
							}
							else {
								if (AjcRepPartStrA(pBuf, len, 0				   , 0, pItem, -1) == NULL) break;
							}
						}
						//	末尾へ追加
						else {
							if (stl > 0 && pBuf[stl - 1] != Dlm) {
								if (AjcRepPartStrA(pBuf, len, stl	 , 0, szDlm , -1) == NULL) break;
								if (AjcRepPartStrA(pBuf, len, stl + 1, 0, pItem , -1) == NULL) break;
							}
							else {
								if (AjcRepPartStrA(pBuf, len, stl	 , 0, pItem , -1) == NULL) break;
							}
						}
						AdjustSemiCollonA(pBuf);
						rc = cbEnvPut(pName, type, pBuf);
					} while (0);
				}
				//	既に指定項目が存在する場合はＯＫとする
				else rc = TRUE;
				free(pBuf);
			}
		}
		else {
			rc = cbEnvPut(pName, type, pItem);
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
static	BOOL	SubEnvAddItemW(C_WCP pName, C_WCP pItem, WC Dlm, BOOL fFront, AJCREGTYPE type,
											UI	 (CALLBACK *cbEnvGet)(C_WCP pName, PAJCREGTYPE pType, WCP pBuf, UI lBuf),
											BOOL (CALLBACK *cbEnvPut)(C_WCP pName, AJCREGTYPE type, C_WCP pTxt))
{
	BOOL		rc = FALSE;
	WCP			pBuf;
	AJCREGTYPE	r_type;
	int			stl, len;
	WC			szDlm[2];

	if (pName != NULL && *pName != 0 && pItem != NULL  &&  *pItem != 0) {
		szDlm[0] = Dlm;
		szDlm[1] = 0;
		if (stl = (int)cbEnvGet(pName, &r_type, NULL, 0)) {
			stl--;	// 文字列終端分を減算
			len = (stl + 1) + ((int)wcslen(pItem) + 1);
			if (pBuf = AjcTAllocW(len)) {
				WCP		p;
				cbEnvGet(pName, &type, pBuf, len);
				//	先頭へ追加する場合、あらかじめ同一項目を削除する
				if (fFront) {
					while ((p = SearchItemInEnvW(pBuf, pItem, Dlm)) != NULL) {
						AjcRepPartStrW(pBuf, len, (UI)(((UX)p - (UX)pBuf) / 2), (UI)wcslen(pItem), L"", -1);
					}
				}
				//	指定項目が無ければ、項目追加
				if (SearchItemInEnvW(pBuf, pItem, Dlm) == NULL) {
					do {
						//	先頭へ追加
						if (fFront) {
							if (stl > 0 && pBuf[0] != Dlm) {
								if (AjcRepPartStrW(pBuf, len, 0				   , 0, pItem, -1) == NULL) break;
								if (AjcRepPartStrW(pBuf, len, (UI)wcslen(pItem), 0, szDlm, -1) == NULL) break;
							}
							else {
								if (AjcRepPartStrW(pBuf, len, 0				   , 0, pItem, -1) == NULL) break;
							}
						}
						//	末尾へ追加
						else {
							if (stl > 0 && pBuf[stl - 1] != Dlm) {
								if (AjcRepPartStrW(pBuf, len, stl	 , 0, szDlm , -1) == NULL) break;
								if (AjcRepPartStrW(pBuf, len, stl + 1, 0, pItem , -1) == NULL) break;
							}
							else {
								if (AjcRepPartStrW(pBuf, len, stl	 , 0, pItem , -1) == NULL) break;
							}
						}
						AdjustSemiCollonW(pBuf);
						rc = cbEnvPut(pName, type, pBuf);
					} while (0);
				}
				//	既に指定項目が存在する場合はＯＫとする
				else rc = TRUE;
				free(pBuf);
			}
		}
		else {
			rc = cbEnvPut(pName, type, pItem);
		}
	}
	return rc;
}
//==============================================================================================================//
//	カレントユーザ・レジストリの環境変数から項目を削除する														//
//																												//
//	引　数	：	pName	- 環境変数名																			//
//				pItem	- 削除する項目文字列																	//
//				Dlm		- 区切り文字																			//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcRegHkCuEnvDelItemA(C_BCP pName, C_BCP pItem, BC Dlm, BOOL fErase)
{
	BOOL	rc = FALSE;

	rc = SubEnvDelItemA(pName, pItem, Dlm, fErase, AjcRegHkCuEnvGetA, AjcRegHkCuEnvPutA, AjcRegHkCuEnvDelA);

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcRegHkCuEnvDelItemW(C_WCP pName, C_WCP pItem, WC Dlm, BOOL fErase)
{
	BOOL	rc = FALSE;

	rc = SubEnvDelItemW(pName, pItem, Dlm, fErase, AjcRegHkCuEnvGetW, AjcRegHkCuEnvPutW, AjcRegHkCuEnvDelW);

	return rc;
}
//==============================================================================================================//
//	ローカルマシン・レジストリの環境変数から項目を削除する														//
//																												//
//	引　数	：	pName	- 環境変数名																			//
//				pItem	- 追加する項目文字列																	//
//				Dlm		- 区切り文字																			//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcRegHkLmEnvDelItemA(C_BCP pName, C_BCP pItem, BC Dlm, BOOL fErase)
{
	BOOL	rc = FALSE;

	rc = SubEnvDelItemA(pName, pItem, Dlm, fErase, AjcRegHkLmEnvGetA, AjcRegHkLmEnvPutA, AjcRegHkLmEnvDelA);

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcRegHkLmEnvDelItemW(C_WCP pName, C_WCP pItem, WC Dlm, BOOL fErase)
{
	BOOL	rc = FALSE;

	rc = SubEnvDelItemW(pName, pItem, Dlm, fErase, AjcRegHkLmEnvGetW, AjcRegHkLmEnvPutW, AjcRegHkLmEnvDelW);

	return rc;
}

//==============================================================================================================//
//	カレントユーザ・レジストリのPATH環境変数からパス項目を削除する												//
//																												//
//	引　数	：	pPath	 - 削除するパス文字列																	//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcRegHkCuEnvDelPathItemA(C_BCP pPath, BOOL fErase)
{
	BOOL	rc = FALSE;

	rc = SubEnvDelItemA("PATH" , pPath, ';' , fErase, AjcRegHkCuEnvGetA, AjcRegHkCuEnvPutA, AjcRegHkCuEnvDelA);

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcRegHkCuEnvDelPathItemW(C_WCP pPath, BOOL fErase)
{
	BOOL	rc = FALSE;

	rc = SubEnvDelItemW(L"PATH", pPath, L';', fErase, AjcRegHkCuEnvGetW, AjcRegHkCuEnvPutW, AjcRegHkCuEnvDelW);

	return rc;
}
//==============================================================================================================//
//	ローカルマシン・レジストリのPATH環境変数からパス項目を削除する												//
//																												//
//	引　数	：	pPath	 - 削除するパス文字列																	//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcRegHkLmEnvDelPathItemA(C_BCP pPath, BOOL fErase)
{
	BOOL	rc = FALSE;

	rc = SubEnvDelItemA("PATH" , pPath, ';' , fErase, AjcRegHkLmEnvGetA, AjcRegHkLmEnvPutA, AjcRegHkLmEnvDelA);

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcRegHkLmEnvDelPathItemW(C_WCP pPath, BOOL fErase)
{
	BOOL	rc = FALSE;

	rc = SubEnvDelItemW(L"PATH", pPath, L';', fErase, AjcRegHkLmEnvGetW, AjcRegHkLmEnvPutW, AjcRegHkLmEnvDelW);

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	レジストリの環境変数から項目を削除する																		//
//																												//
//	引　数	：	pName	 - 環境変数名																			//
//				pItem	 - 削除する項目文字列																	//
//				Dlm		 - 区切り文字																			//
//				fErase	 - 項目がなくなった場合の環境変数消去指定												//
//				cbEnvGet - 環境変数読み出し関数																	//
//				cbEnvPut - 環境変数書き込み関数																	//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//--------------------------------------------------------------------------------------------------------------//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
static	BOOL	SubEnvDelItemA(C_BCP pName, C_BCP pItem, BC Dlm, BOOL fErase,
											UI	 (CALLBACK *cbEnvGet)(C_BCP pName, PAJCREGTYPE pType, BCP pBuf, UI lBuf),
											BOOL (CALLBACK *cbEnvPut)(C_BCP pName, AJCREGTYPE type, C_BCP pTxt),
											BOOL (CALLBACK *cbEnvDel)(C_BCP pName))
{
	BOOL		rc = FALSE;
	AJCREGTYPE	type;
	int			stl, len;
	BCP			pBuf, pTop, pEnd;

	if (pItem != NULL && *pItem != 0) {								//	有効なパス名？
		if (stl = (int)cbEnvGet(pName, &type, NULL, 0)) {			//		テキストの長さ(終端を含む)取得，ＯＫ？
			len = stl + (int)strlen(pItem) + 1;						//			全体のテキストの長さ設定
			if (pBuf = AjcTAllocA(len)) {							//			テキストバッファ確保，成功？
				memset(pBuf, 0, len);
				cbEnvGet(pName, &type, pBuf, len);					//				テキスト読み出し
				if (pTop = SearchItemInEnvA(pBuf, pItem, Dlm)) {	//				削除する項目検索，あり？
					pEnd = pTop + strlen(pItem);					//					削除するパス名の次の位置設定
					memmove(pTop, pEnd, strlen(pEnd) + 1);			//					削除するパス名消去
					AdjustSemiCollonA(pBuf);						//					連続するセミコロンを１つにする
					//	環境変数消去指定あり and 項目無し？
					if (fErase && (pBuf[0] == 0 || AjcStrSameAsAllCharA(pBuf, ' '))) {
						rc = cbEnvDel(pName);						//						環境変数削除
					}
					//	環境変数消去指定なし or 項目あり？
					else {											//					空文字列以外（項目有り）｜環境変数保存指定？
						rc = cbEnvPut(pName, type, pBuf);			//						テキスト書き込み
					}
				}
				else rc = TRUE;										//				削除する項目が無い場合はＯＫとする
				free(pBuf);											//				テキストバッファ解放
			}
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
static	BOOL	SubEnvDelItemW(C_WCP pName, C_WCP pItem, WC Dlm, BOOL fErase,
											UI	 (CALLBACK *cbEnvGet)(C_WCP pName, PAJCREGTYPE pType, WCP pBuf, UI lBuf),
											BOOL (CALLBACK *cbEnvPut)(C_WCP pName, AJCREGTYPE type, C_WCP pTxt),
											BOOL (CALLBACK *cbEnvDel)(C_WCP pName))
{
	BOOL		rc = FALSE;
	AJCREGTYPE	type;
	int			stl, len;
	WCP			pBuf, pTop, pEnd;

	if (pItem != NULL && *pItem != 0) {								//	有効なパス名？
		if (stl = (int)cbEnvGet(pName, &type, NULL, 0)) {			//		テキストの長さ(終端を含む)取得，ＯＫ？
			len = stl + (int)wcslen(pItem) + 1;						//			全体のテキストの長さ設定
			if (pBuf = AjcTAllocW(len)) {							//			テキストバッファ確保，成功？
				memset(pBuf, 0, len * 2);
				cbEnvGet(pName, &type, pBuf, len);					//				テキスト読み出し
				if (pTop = SearchItemInEnvW(pBuf, pItem, Dlm)) {	//				削除する項目検索，あり？
					pEnd = pTop + wcslen(pItem);					//					削除するパス名の次の位置設定
					memmove(pTop, pEnd, (wcslen(pEnd) + 1) * 2);	//					削除するパス名消去
					AdjustSemiCollonW(pBuf);						//					連続するセミコロンを１つにする
					//	環境変数消去指定あり and 項目無し？
					if (fErase && (pBuf[0] == 0 || AjcStrSameAsAllCharW(pBuf, L' '))) {
						rc = cbEnvDel(pName);						//						環境変数削除
					}
					//	環境変数消去指定なし or 項目あり？
					else {											//					空文字列以外（項目有り）｜環境変数保存指定？
						rc = cbEnvPut(pName, type, pBuf);			//						テキスト書き込み
					}
				}
				else rc = TRUE;										//				削除する項目が無い場合はＯＫとする
				free(pBuf);											//				テキストバッファ解放
			}
		}
	}
	return rc;
}

//--------------------------------------------------------------------------------------------------------------//
//	レジストリの環境変数から区切り文字で区切られた項目を検索する												//
//																												//
//	引　数	：	pStr	- 環境変数の内容																		//
//				pItem	- 検索する文字列																		//
//				Dlm		- 区切り文字																			//
//																												//
//	戻り値	：	≠NULL：当該項目のアドレス																		//
//				＝NULL：項目は存在しない																		//
//--------------------------------------------------------------------------------------------------------------//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
static	BCP		SearchItemInEnvA(BCP pStr, C_BCP pPath, BC Dlm)
{
	BCP		rc	= NULL;
	BCP		p, pBuf;
	BC		szDlm[2];

	if (pBuf = AjcTAllocA((UI)strlen(pStr) + 1)) {
		szDlm[0] = Dlm;
		szDlm[1] = 0;
		strcpy(pBuf, pStr);
		if (p = AjcStrTokExA(pBuf, szDlm, "\"")) {
			do {
				if (mbsicmp(p, pPath) == 0) {
					rc = pStr + ((UX)p - (UX)pBuf);
					break;
				}
			} while (p = AjcStrTokExA(NULL, szDlm, "\""));
		}
		free(pBuf);
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
static	WCP		SearchItemInEnvW(WCP pStr, C_WCP pPath, WC Dlm)
{
	WCP		rc	= NULL;
	WCP		p, pBuf;
	WC		szDlm[2];

	if (pBuf = AjcTAllocW((UI)wcslen(pStr) + 1)) {
		szDlm[0] = Dlm;
		szDlm[1] = 0;
		wcscpy(pBuf, pStr);
		if (p =  AjcStrTokExW(pBuf, szDlm, L"\"")) {
			do {
				if (wcsicmp(p, pPath) == 0) {
					rc = pStr + (((UX)p - (UX)pBuf) / 2);
					break;
				}
			} while (p = AjcStrTokExW(NULL, szDlm, L"\""));
		}
		free(pBuf);
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	先頭と末尾のセミコロンを削除し、中間の連続したセミコロンを１つにまとめる									//
//																												//
//	引　数	：	pStr	- PATH環境変数の内容																	//
//																												//
//	戻り値	：	≠NULL：当該パス項目のアドレス																	//
//				＝NULL：パス項目は存在しない																	//
//--------------------------------------------------------------------------------------------------------------//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
static	VO		AdjustSemiCollonA(BCP pStr)
{
	int		len;
	BCP		p;

	do {
		//----- 先頭のセミコロン削除 -------------------------------------//
		for (p = pStr, len = 0; *p == ';'; p++, len++);
		if (len != 0) {
			memmove(pStr, p, strlen(p) + 1);
		}
		//----- 末尾のセミコロン削除 -------------------------------------//
		len = (int)strlen(pStr);
		for (p = pStr + (len - 1); len > 0 && *p == ';'; p--, len--);
		if (*p != ';') {
			p++;
		}
		*p = 0;
		//----- 連続したセミコロンを１つにまとめる -----------------------//
		while (p = mbsstr(pStr, ";;")) {
			len = 2;
			while (*(p + len) == ';') {len++;}
			memmove(p + 1, p + len, strlen(p + len) + 1);
		}
	} while(0);
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
static	VO		AdjustSemiCollonW(WCP pStr)
{
	int		len;
	WCP		p;

	do {
		//----- 先頭のセミコロン削除 -------------------------------------//
		for (p = pStr, len = 0; *p == L';'; p++, len++);
		if (len != 0) {
			memmove(pStr, p, (wcslen(p) + 1) * 2);
		}
		//----- 末尾のセミコロン削除 -------------------------------------//
		len = (int)wcslen(pStr);
		for (p = pStr + (len - 1); len > 0 && *p == L';'; p--, len--);
		if (*p != L';') {
			p++;
		}
		*p = 0;
		//----- 連続したセミコロンを１つにまとめる -----------------------//
		while (p = wcsstr(pStr, L";;")) {
			len = 2;
			while (*(p + len) == L';') {len++;}
			memmove(p + 1, p + len, (wcslen(p + len) + 1) * 2);
		}
	} while(0);
}
//==============================================================================================================//
//	環境変数の有効化																							//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
AJCEXPORT	VO	WINAPI AjcRegEnableEnvironment(VO)
{
	UX	ReturnValue = 0;
	SendMessageTimeout(HWND_BROADCAST, WM_SETTINGCHANGE, 0, (LPARAM)"Environment", SMTO_ABORTIFHUNG, 5000, &ReturnValue);
}

//==============================================================================================================//
//	レジストリパスの存在チェック																				//
//																												//
//	引　数：	hTop		- トップキー																		//
//				pPath		- レジストリパス名のアドレス														//
//				pErr		- エラーコードを格納するバッファのアドレス（不要時はNULL)							//
//																												//
//	戻り値	：	TRUE  - 当該パス有り																			//
//				FALSE - 当該パス無し／アクセスエラー															//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcRegIsPathExistA	  (HKEY hTop, C_BCP pPath, UIP pErr)
{
	BOOL	rc	  = FALSE;
	int		err;
	HKEY	hKey  = NULL;

	//	レジストリパス オープンチェック
	if ((err = RegOpenKeyExA(hTop,											//	キー・オープン，成功？
							 pPath,											//	・	（サブキー）
							 0,												//	・	（常に０）
							 KEY_READ,										//	・	（アクセス権，既存サブキーの場合は不要）
							 &hKey)) == ERROR_SUCCESS && hKey != NULL) {	//	・	（ハンドルを格納するバッファのアドレス）
		rc = TRUE;
		RegCloseKey(hKey);
	}
	//	エラーコード格納
	if (pErr != NULL) *pErr = err;

	return rc;
}

//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcRegIsPathExistW	  (HKEY hTop, C_WCP pPath, UIP pErr)
{
	BOOL	rc	  = FALSE;
	int		err;
	HKEY	hKey  = NULL;

	//	レジストリパス オープンチェック
	if ((err = RegOpenKeyExW(hTop,											//	キー・オープン，成功？
							 pPath,											//	・	（サブキー）
							 0,												//	・	（常に０）
							 KEY_READ,										//	・	（アクセス権，既存サブキーの場合は不要）
							 &hKey)) == ERROR_SUCCESS && hKey != NULL) {	//	・	（ハンドルを格納するバッファのアドレス）
		rc = TRUE;
		RegCloseKey(hKey);
	}
	//	エラーコード格納
	if (pErr != NULL) *pErr = err;

	return rc;
}
//==============================================================================================================//
//	レジストリキーの存在チェック																				//
//																												//
//	引　数：	hTop		- トップキー																		//
//				pPath		- レジストリパス名のアドレス														//
//				pErr		- エラーコードを格納するバッファのアドレス（不要時はNULL)							//
//																												//
//	戻り値	：	TRUE  - 当該パス有り																			//
//				FALSE - 当該パス無し／アクセスエラー															//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcRegIsKeyExistA	  (HKEY hTop, C_BCP pPath, C_BCP pKey, UIP pErr)
{
	BOOL	rc	  = FALSE;
	int		err;
	HKEY	hKey  = NULL;

	//	レジストリパス オープンチェック
	if ((err = RegOpenKeyExA(hTop,											//	キー・オープン，成功？
							 pPath,											//	・	（サブキー）
							 0,												//	・	（常に０）
							 KEY_READ,										//	・	（アクセス権，既存サブキーの場合は不要）
							 &hKey)) == ERROR_SUCCESS && hKey != NULL) {	//	・	（ハンドルを格納するバッファのアドレス）
		if ((err = RegQueryValueExA(hKey, pKey, NULL, NULL, NULL, NULL)) == ERROR_SUCCESS) {
			rc = TRUE;
		}
		RegCloseKey(hKey);
	}
	//	エラーコード格納
	if (pErr != NULL) *pErr = err;

	return rc;
}

//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcRegIsKeyExistW	  (HKEY hTop, C_WCP pPath, C_WCP pKey, UIP pErr)
{
	BOOL	rc	  = FALSE;
	int		err;
	HKEY	hKey  = NULL;

	//	レジストリパス オープンチェック
	if ((err = RegOpenKeyExW(hTop,											//	キー・オープン，成功？
							 pPath,											//	・	（サブキー）
							 0,												//	・	（常に０）
							 KEY_READ,										//	・	（アクセス権，既存サブキーの場合は不要）
							 &hKey)) == ERROR_SUCCESS && hKey != NULL) {	//	・	（ハンドルを格納するバッファのアドレス）
		if ((err = RegQueryValueExW(hKey, pKey, NULL, NULL, NULL, NULL)) == ERROR_SUCCESS) {
			rc = TRUE;
		}
		RegCloseKey(hKey);
	}
	//	エラーコード格納
	if (pErr != NULL) *pErr = err;

	return rc;
}


//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	ＭＳＩＬ用サポートコード																					//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

//==============================================================================================================//
//	カレントユーザ・レジストリのPATH環境変数へパス項目を追加する												//
//																												//
//	引　数	：	path	- 追加するパス文字列																	//
//				fFront	- TRUE	: 先頭へ追加																	//
//						  FALSE : 末尾へ追加																	//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcEnvAddPathItemW(C_WCP pPath, BOOL fFront)
{
	return SubEnvAddItemW(L"PATH", pPath, L';', fFront, AJCREG_EXPAND_SZ, AjcRegHkCuEnvGetW, AjcRegHkCuEnvPutW);
}
//==============================================================================================================//
//	カレントユーザ・レジストリのPATH環境変数からパス項目を削除する												//
//																												//
//	引　数	：	pPath	 - 削除するパス文字列																	//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcEnvDelPathItemW(C_WCP pPath)
{
	return SubEnvDelItemW(L"PATH", pPath, L';', FALSE, AjcRegHkCuEnvGetW, AjcRegHkCuEnvPutW, AjcRegHkCuEnvDelW);
}

