﻿#include	"AjcInternal.h"

//**************************************************************************************************************//
//																												//
//	項目数制限付きコンボボックス																				//
//																												//
//**************************************************************************************************************//

#define		WM_SETMOSTNEW	(WM_APP + 100)

//--------------------------------------------------------------------------------------------------------------//
//	インスタンスワーク																							//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	HWND		hwnd;					//	コンボボックスのウインドハンドル
	BOOL		fUniCode;				//	ワイド文字モードフラグ（現状は設定のみで、未使用）
	UI			flag;					//	フラグ（AJCSBCF_XXXXX）
	UI			MaxItem;				//	最大リストボックス項目数
	UI			LimitText;				//	テキストの最大長
	UI			CurSeq;					//	作成順シーケンス＃
	BOOL		fSort;					//	ソートフラグ
	BOOL		fShowFirstLine;			//	チップテキストにファイルの１行目を表示するフラグ
	WCP			pCharExclude;			//	ファイルの１行目表示時の除外文字配列
	int			ixCur;					//	リストが開かれた時の選択項目
	int			ixLast;					//	直前の選択項目
	BOOL		fSel;					//	項目選択中フラグ
	WC			TipTxt[AJCSBC_MAXSTL];	//	ツールチップテキスト
	HAJCRNG		hRngDel;				//	削除項目一時保留リングバッファハンドル
	UB			StaRngDel[1024];		//	削除項目一時保留スタティックリングバッファ
	UI			NtcDelItems;			//	通知情報（削除した項目数）
	EAJCTEC		InpTec;					//	入力テキストファイルエンコード
	EAJCTEC		OutTec;					//	出力テキストファイルエンコード
	BOOL		fBOM;					//	BOM出力フラグ
} WKSBCCBO,	 *PWKSBCCBO;

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC_DEF(SbcCbo);
AJC_WNDPROC_DEF(SbcEdt);
static	BOOL	SubSbcComboBox(HWND hwnd, UI MaxItem, UI LimitText, UI flag, BOOL fUniCode);

static	C_WCP CALLBACK cbGetTipText(HWND hCtrl, WCP pBuf, UI lBuf, UX cbp);

static	VO		SubShowTipText		(PWKSBCCBO pW, int tm);
static	VO		SubGetPointAndSize	(PWKSBCCBO pW, LPPOINT pPt, LPSIZE pSz);
static	VO		SubGetTextSize		(PWKSBCCBO pW, C_WCP pTxt, LPSIZE pSz);

static	VO		SubDeleteMostOldItem(PWKSBCCBO pW);
static	int		SubFindString		(PWKSBCCBO pW, WCP pStr);
static	int		SubFindFront		(PWKSBCCBO pW, WCP pStr);
static	BOOL	SubSetFirstLineToTipTxt(PWKSBCCBO pW);

static	int		CboLbGetText		(HWND hwnd, UI ix, WCP pStr, UI lStr);
static	int		CboAddString		(HWND hwnd, C_WCP pStr);
static	int		CboInsertString		(HWND hwnd, UI ix, C_WCP pStr);

static LRESULT CALLBACK DlgSbcComboProc(HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam);

//==============================================================================================================//
//	コンボボックスのサブクラス化																				//
//																												//
//	引　数：	hwnd		- コンボボックスのウインドハンドル													//
//				MaxItem		- 保持する項目の最大数																//
//				LimitText	- 項目の最大文字列長																//
//																												//
//	戻り値：	TRUE  - OK, FALSE - Error																		//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI	AjcSbcComboBoxA	  (HWND hwnd, UI MaxItem, UI LimitText)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		if (LimitText > 0 && LimitText <= AJCSBC_MAXSTL) {
			rc = SubSbcComboBox(hwnd, MaxItem, LimitText, 0, FALSE);
		}
	}
	return rc;
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
AJCEXPORT BOOL	 WINAPI	AjcSbcComboBoxExA  (HWND hwnd, UI MaxItem, UI LimitText, UI flag)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		if (LimitText > 0 && LimitText <= AJCSBC_MAXSTL) {
			rc = SubSbcComboBox(hwnd, MaxItem, LimitText, flag, FALSE);
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI	AjcSbcComboBoxW	  (HWND hwnd, UI MaxItem, UI LimitText)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		if (LimitText > 0 && LimitText <= AJCSBC_MAXSTL) {
			rc = SubSbcComboBox(hwnd, MaxItem, LimitText, 0, TRUE);
		}
	}
	return rc;
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
AJCEXPORT BOOL	 WINAPI	AjcSbcComboBoxExW  (HWND hwnd, UI MaxItem, UI LimitText, UI flag)
{
	BOOL	rc = FALSE;

	if (IsWindow(hwnd)) {
		if (LimitText > 0 && LimitText <= AJCSBC_MAXSTL) {
			rc = SubSbcComboBox(hwnd, MaxItem, LimitText, flag, TRUE);
		}
	}
	return rc;
}
//----- 共通サブ -----------------------------------------------------------------------------------------------//
static BOOL	 SubSbcComboBox(HWND hwnd, UI MaxItem, UI LimitText, UI flag, BOOL fUniCode)
{
	BOOL		rc = FALSE;
	PWKSBCCBO	pW = NULL;
	BOOL		RsuSetProp = FALSE;
	UI			sty, exs;
	HWND		hEdt;
	WC			str[AJCSBC_MAXSTL];

	do {
		//----- ウインドハンドルチェック -----------------------------------------------------------------------//
		if (!IsWindow(hwnd)) break;
		//----- ウインドスタイル取得 ---------------------------------------------------------------------------//
		sty = (UI)MAjcGetWindowLong(hwnd, GWL_STYLE);
		//----- スタイルチェック -------------------------------------------------------------------------------//
		if ((sty & CBS_SIMPLE) == CBS_DROPDOWN) break;
		//----- チップウインド生成 -----------------------------------------------------------------------------//
		AjcTipTextCreate();		
		//----- ウインドクラスチェック -------------------------------------------------------------------------//
		GetClassName(hwnd, str, AJCTSIZE(str));
		if (wcsicmp(str, L"ComboBox") != 0) break;
		//----- インスタンスワーク確保 -------------------------------------------------------------------------//
		pW = (PWKSBCCBO)AJCMEM(sizeof(WKSBCCBO));
		if (pW == NULL) break;
		memset(pW, 0, sizeof(WKSBCCBO));
		//----- インスタンスワーク初期化 -----------------------------------------------------------------------//
		pW->hwnd	  = hwnd;
		pW->fUniCode  = fUniCode;
		pW->flag	  = flag;
		pW->MaxItem   = MaxItem;
		pW->LimitText = LimitText;
		pW->fSort = ((sty & CBS_SORT) != 0);
		pW->CurSeq = 0;
		pW->InpTec = AJCTEC_AUTO;
		pW->OutTec = AJCTEC_AUTO;
		pW->fBOM   = FALSE;
		//----- インスタンスワークをコンボボックスに関連付け ---------------------------------------------------//
		RsuSetProp = SetProp(hwnd, PN_SBCCBO, (HANDLE)pW);
		if (RsuSetProp != TRUE) break;
		//----- コンボボックス項目の最大文字列長設定 -----------------------------------------------------------//
		AjcSetCtrlCboLimit(hwnd, LimitText);
		//----- コンボボックス項目クリアー ---------------------------------------------------------------------//
		AjcSetCtrlCboReset(hwnd);
		//----- 削除項目一時保留バッファ生成 -------------------------------------------------------------------//
		pW->hRngDel	 = AjcRngCreate(&pW->StaRngDel , sizeof pW->StaRngDel , 4096);
		if (pW->hRngDel	 == NULL) break;
		//----- コンボボックスのサブクラス化 -------------------------------------------------------------------//
		if (MAjcMmpSetSubclass(SbcCbo, hwnd) == NULL) break;
		//----- エディットコントロールがある場合は、エディットコントロールでもツールチップを有効化 -------------//
		if (hEdt = AjcSbcGetEditCtrlInComboBox(hwnd)) {
			AJCTIP_SETFRIEND(hEdt);
		}
		//----- ドロップ可能ならば、兄弟ウインド中で最前面に設定する -------------------------------------------//
		if (pW->flag & AJCSBCF_DROPBOTH) {
			exs = (UI)MAjcGetWindowLong(hwnd, GWL_EXSTYLE);
			MAjcSetWindowLong(hwnd, GWL_EXSTYLE, exs | WS_EX_ACCEPTFILES);
			AjcSetCtrlTopMostInSiblings(hwnd);
		}
		//----- リスト選択時のチップ表示制御タイマ起動 ---------------------------------------------------------//
		if (pW->flag & AJCSBCF_TIPINSEL) {
			SetTimer (hwnd, 1, 100, NULL);
		}
		//----- ユーザ独自のツールチップが設定されていない場合、長テキストのチップ表示を許可する ---------------//
		if ((pW->flag & AJCSBCF_LONGTIP) || AjcTipTextGetInfo(hwnd, NULL, NULL, 0) == -1) {
			AjcTipTextAdd(hwnd, L"");
			AjcTipTextSetCallBack(hwnd, (UX)pW, NULL, cbGetTipText);
		}
		//----- 戻り値（正常）設定 -----------------------------------------------------------------------------//
		rc = TRUE;
	} while(0);

	if (!rc) {
		if (pW != NULL) free(pW);
		if (RsuSetProp) RemoveProp(hwnd, PN_SBCCBO);
	}

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	サブクラス・コンボボックス・ウインドプロシージャ															//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//----- 項目追加 -----------------------------------------------------------------------------------------------//
AJC_WNDPROC(SbcCbo, CB_ADDSTRING	)
{
	PWKSBCCBO	pW = (PWKSBCCBO)GetProp(hwnd, PN_SBCCBO);
	LRESULT		rc = CB_ERR;
	UI			n, ix;
	WC			str[AJCSBC_MAXSTL];	//	追加文字列

	if (pW != NULL && lParam != 0) {
		//	追加文字列コピー
		if (IsWindowUnicode(hwnd)) wcsncpy(str, (C_WCP)lParam, AJCSBC_MAXSTL);
		else					   MultiByteToWideChar(CP_ACP, 0, (C_BCP)lParam, -1, str,AJCSBC_MAXSTL);
		str[AJCSBC_MAXSTL - 1] = 0;

		if ((ix = SubFindString(pW, str)) == CB_ERR) {
			//----- 最大項目数ならば、最古の項目を削除 --------------------//
			n  = (UI)MAjcMmpCallOrgWndProcEx(SbcCbo, hwnd, CB_GETCOUNT, 0, 0);
			if (n != CB_ERR	 &&	 n >= pW->MaxItem) {
				SubDeleteMostOldItem(pW);
			}
			//----- 項目追加 ----------------------------------------------//
			ix = CboAddString(hwnd, str);
			if (ix != CB_ERR  &&  ix != CB_ERRSPACE) {
				pW->CurSeq++;
				MAjcMmpCallOrgWndProcEx(SbcCbo, hwnd, CB_SETITEMDATA, ix, pW->CurSeq);
				MAjcMmpCallOrgWndProcEx(SbcCbo, hwnd, CB_SETCURSEL	, ix, 0);
				rc = ix;
			}
		}
	}
	return rc;		//	インターセプト
}
//----- 項目挿入 -----------------------------------------------------------------------------------------------//
AJC_WNDPROC(SbcCbo, CB_INSERTSTRING	)
{
	PWKSBCCBO	pW = (PWKSBCCBO)GetProp(hwnd, PN_SBCCBO);
	LRESULT		rc = CB_ERR;
	UI			n, ix;
	WC			str[AJCSBC_MAXSTL];	//	挿入文字列

	if (pW != NULL && lParam != 0) {
		//	挿入文字列コピー(UNICODE時も、ASCII文字となる）
		if (IsWindowUnicode(hwnd)) wcsncpy(str, (C_WCP)lParam, AJCSBC_MAXSTL);
		else					   MultiByteToWideChar(CP_ACP, 0, (C_BCP)lParam, -1, str,AJCSBC_MAXSTL);
		str[AJCSBC_MAXSTL - 1] = 0;

		if ((ix = SubFindString(pW, str)) == CB_ERR) {
			//----- 最大項目数ならば、最古の項目を削除 --------------------//
			n  = (UI)MAjcMmpCallOrgWndProcEx(SbcCbo, hwnd, CB_GETCOUNT, 0, 0);
			if (n != CB_ERR	 &&	 n >= pW->MaxItem) {
				SubDeleteMostOldItem(pW);
			}
			//----- 項目挿入 ----------------------------------------------//
			ix = CboInsertString(hwnd, (UI)wParam, str);
			if (ix != CB_ERR  &&  ix != CB_ERRSPACE) {
				pW->CurSeq++;
				MAjcMmpCallOrgWndProcEx(SbcCbo, hwnd, CB_SETITEMDATA, ix, pW->CurSeq);
				MAjcMmpCallOrgWndProcEx(SbcCbo, hwnd, CB_SETCURSEL	, ix, 0);
				rc = ix;
			}
		}
	}
	return rc;		//	インターセプト
}
//----- 項目削除 -----------------------------------------------------------------------------------------------//
AJC_WNDPROC(SbcCbo, CB_DELETESTRING	)
{
	PWKSBCCBO	pW = (PWKSBCCBO)GetProp(hwnd, PN_SBCCBO);
	int			ix, n;
	LRESULT		rc = CB_ERR;
	WC			txt[AJCSBC_MAXSTL];	//	リスト項目

	if (pW != NULL) {
		//	現在選択されている文字列取得
		if ((ix = (int)MAjcMmpCallOrgWndProcEx(SbcCbo, hwnd, CB_GETCURSEL, 0, 0)) != CB_ERR) {
			CboLbGetText(hwnd, ix, txt, AJCSBC_MAXSTL);
		}
		//	項目削除(ｎ＝残項目数）
		n = (int)MAjcMmpCallOrgWndProcEx(SbcCbo, hwnd, CB_DELETESTRING, wParam, lParam);
		if (n != CB_ERR) {
			//	残項目ありならば、選択されていた項目を復元
			if (n >= 1) {
				if (ix != CB_ERR && (ix = SubFindString(pW, txt)) != CB_ERR) {
					MAjcMmpCallOrgWndProcEx(SbcCbo, hwnd, CB_SETCURSEL, ix, 0);
				}
				else {
					if ((MAjcMmpCallOrgWndProcEx(SbcCbo, hwnd, CB_SETCURSEL, wParam, 0)) == CB_ERR) {
						 MAjcMmpCallOrgWndProcEx(SbcCbo, hwnd, CB_SETCURSEL, 0, 0);
					}
				}
			}
			//	残項目無しならば、リセット
			else {
				MAjcMmpCallOrgWndProcEx(SbcCbo, hwnd, CB_RESETCONTENT, 0, 0);
			}
		}
	}
	return rc;		//	インターセプト
}
//----- リセット -----------------------------------------------------------------------------------------------//
AJC_WNDPROC(SbcCbo, CB_RESETCONTENT	)
{
	PWKSBCCBO	pW = (PWKSBCCBO)GetProp(hwnd, PN_SBCCBO);
	LRESULT		rc = CB_ERR;

	if (pW != NULL) {
		rc = MAjcMmpCallOrgWndProcEx(SbcCbo, hwnd, CB_RESETCONTENT, wParam, lParam);
		if (rc != CB_ERR) {
			pW->CurSeq = 0;
		}
	}
	return rc;		//	インターセプト
}
//----- 項目に関連付ける値設定 ---------------------------------------------------------------------------------//
AJC_WNDPROC(SbcCbo, CB_SETITEMDATA	)
{
	return CB_ERR;	//	インターセプト
}
//----- ファイル名リスト追加 -----------------------------------------------------------------------------------//
AJC_WNDPROC(SbcCbo, CB_DIR			)
{
	return CB_ERR;	//	インターセプト
}
//----- 文字列比較（先頭部分） ---------------------------------------------------------------------------------//
AJC_WNDPROC(SbcCbo, CB_FINDSTRING	)
{
	PWKSBCCBO	pW = (PWKSBCCBO)GetProp(hwnd, PN_SBCCBO);
	LRESULT		rc = CB_ERR;
	int			i, j, n, ix;
	int			rsu;
	UI			stl;
	WC			str[AJCSBC_MAXSTL];	//	比較文字列
	WC			txt[AJCSBC_MAXSTL];	//	リスト項目

	if (pW != NULL && lParam != 0) {
		//	検索文字列コピー
		if (IsWindowUnicode(hwnd)) wcsncpy(str, (C_WCP)lParam, AJCSBC_MAXSTL);
		else					   MultiByteToWideChar(CP_ACP, 0, (C_BCP)lParam, -1, str,AJCSBC_MAXSTL);
		str[AJCSBC_MAXSTL - 1] = 0;

		//	検索
		n = (int)MAjcMmpCallOrgWndProcEx(SbcCbo, hwnd, CB_GETCOUNT, wParam, lParam);
		if (n > 0) {
			stl = (int)wcslen(str);
			ix = (wParam == -1) ? 0 : ((wParam + 1) % n);
			for (i = ix, j = 0; j < n; ix = ((ix + 1) % n), j++) {
				if (CboLbGetText(hwnd, ix, txt, AJCSBC_MAXSTL) != CB_ERR) {
					if (wcslen(txt) >= stl) {
						if (pW->flag & AJCSBCF_IGNORWIDTH) rsu = wcsnicmp(str, txt, stl);
						else							   rsu = wcsncmp (str, txt, stl);
						if (rsu == 0) {
							rc = ix;
							break;
						}
					}
				}
			}
		}
	}
	return rc;	//	インターセプト
}
//----- 文字列比較（全体） -------------------------------------------------------------------------------------//
AJC_WNDPROC(SbcCbo, CB_FINDSTRINGEXACT)
{
	PWKSBCCBO	pW = (PWKSBCCBO)GetProp(hwnd, PN_SBCCBO);
	LRESULT		rc = CB_ERR;
	int			i, j, n, ix;
	int			rsu;
	WC			str[AJCSBC_MAXSTL];	//	比較文字列
	WC			txt[AJCSBC_MAXSTL];	//	リスト項目

	if (pW != NULL && lParam != 0) {
		//	検索文字列コピー
		if (IsWindowUnicode(hwnd)) wcsncpy(str, (C_WCP)lParam, AJCSBC_MAXSTL);
		else					   MultiByteToWideChar(CP_ACP, 0, (C_BCP)lParam, -1, str,AJCSBC_MAXSTL);
		str[AJCSBC_MAXSTL - 1] = 0;

		//	検索
		n = (int)MAjcMmpCallOrgWndProcEx(SbcCbo, hwnd, CB_GETCOUNT, wParam, lParam);
		if (n > 0) {
			ix = (wParam == -1) ? 0 : ((wParam + 1) % n);
			for (i = ix, j = 0; j < n; ix = ((ix + 1) % n), j++) {
				if (CboLbGetText(hwnd, ix, txt, AJCSBC_MAXSTL) != CB_ERR) {
					if (pW->flag & AJCSBCF_IGNORWIDTH) rsu = wcsicmp(txt, str);
					else							   rsu = wcscmp (txt, str);
					if (rsu == 0) {
						rc = ix;
						break;
					}
				}
			}
		}
	}
	return rc;	//	インターセプト
}
//----- 現項目を最新項目に設定 	--------------------------------------------------------------------------------//
AJC_WNDPROC(SbcCbo, WM_SETMOSTNEW	)
{
	PWKSBCCBO	pW = (PWKSBCCBO)GetProp(hwnd, PN_SBCCBO);
	int			ix;
	WC			txt[AJCSBC_MAXSTL];

	//	表示項目取得
	AjcGetCtrlStr(hwnd, txt, AJCTSIZE(txt));
	//	表示項目検索
	ix = SubFindString(pW, txt);
	//	項目が見つかったら、先頭へ移動（SORT以外のみ）
	if (ix >= 0) {
		if (!pW->fSort) {
			MAjcMmpCallOrgWndProcEx(SbcCbo, hwnd, CB_DELETESTRING, ix, 0);
			ix = CboInsertString(hwnd, 0, txt);
		}
	}
	//	項目が見つからなければ登録する
	else {
		if (pW->fSort) ix = CboAddString   (hwnd,	 txt);
		else		   ix = CboInsertString(hwnd, 0, txt);
	}
	//	最新項目に設定
	if (ix >= 0) {
		pW->CurSeq++;
		MAjcMmpCallOrgWndProcEx(SbcCbo, hwnd, CB_SETITEMDATA, ix, pW->CurSeq);
		MAjcMmpCallOrgWndProcEx(SbcCbo, hwnd, CB_SETCURSEL	, ix, 0);
	}
	return 0;
}
//----- スタイル変更 -------------------------------------------------------------------------------------------//
AJC_WNDPROC(SbcCbo, WM_STYLECHANGED	)
{
	PWKSBCCBO		pW = (PWKSBCCBO)GetProp(hwnd, PN_SBCCBO);
	LPSTYLESTRUCT	pSty = (LPSTYLESTRUCT)lParam;

	if (wParam == GWL_STYLE) {
		pW->fSort = ((pSty->styleNew & CBS_SORT) != 0);
	}

	return MAjcMmpCallOrgWndProc(SUB);
}
//----- 右クリック ---------------------------------------------------------------------------------------------//
#define		IDM_RMV_CUR		6001
#define		IDM_RMV_ALL		6002
#define		IDM_LST_COPY	6010
#define		IDM_LST_PASTE	6011

AJC_WNDPROC(SbcCbo, WM_RBUTTONDOWN	)
{
	PWKSBCCBO	pW = (PWKSBCCBO)GetProp(hwnd, PN_SBCCBO);
	HMENU		hM = CreatePopupMenu();
	int			n  = (int)MAjcMmpCallOrgWndProcEx(SbcCbo, hwnd, CB_GETCOUNT, 0, 0);
	int			id = 0;
	int			ix;
	POINT		pt;

	if (hM != NULL) {
		if (n > 0) {
			AppendMenu(hM, MFT_STRING, IDM_RMV_CUR	, LNGSEL(L"現選択項目を削除(&S)", L"Remove Current &Selected Item"));
			AppendMenu(hM, MFT_SEPARATOR, 0, NULL);
			AppendMenu(hM, MFT_STRING, IDM_RMV_ALL	, LNGSEL(L"全て削除(&A)"		, L"Remove &All Items"));
			AppendMenu(hM, MFT_SEPARATOR, 0, NULL);
			AppendMenu(hM, MFT_STRING, IDM_LST_COPY , LNGSEL(L"リストをコピー(&C)"	, L"&Copy list items"));
		}
		AppendMenu(hM, MFT_STRING, IDM_LST_PASTE	, LNGSEL(L"リストを貼り付け(&V)", L"&Paste list items"));

		GetCursorPos(&pt);
		id = AjcDgcTrackPopupMenuEx(hM, TPM_RETURNCMD | TPM_TOPALIGN, pt.x, pt.y, hwnd, NULL);
		DestroyMenu(hM);
		switch (id) {
			//	●現選択項目を削除
			case IDM_RMV_CUR:
			{	int		cid = (int)MAjcGetWindowLong(hwnd, GWL_ID);
				HWND	hParent = GetParent(hwnd);
				UI		bytes  = 0;
				WC		txt[AJCSBC_MAXSTL];
				WC		msg[AJCSBC_MAXSTL + 64];

				//	前回の通知データ破棄
				AjcRngPurge(pW->hRngDel);
				//	カウンタ設定（＝１）
				pW->NtcDelItems = 1;

				if (n == 1) {
					//	削除する項目の文字列取得とリングバッファへ退避
					CboLbGetText(hwnd, 0, txt, AJCSBC_MAXSTL);
					//	確認メッセージ
					AjcSnPrintF(msg, AJCTSIZE(msg), LNGSEL(L"項目 ( %s ) を削除しますか？", L"Delete item ( %s )?"), txt);
					if (MessageBox(hwnd, msg, AppName, MB_YESNO) == IDYES) {
						bytes = (UI)wcslen(txt) * 2 + 2;
						AjcRngPutData(pW->hRngDel, (VOP)&bytes, sizeof bytes);
						AjcRngPutData(pW->hRngDel, (VOP)txt, bytes);
						//	コンボボックスクリアー
						MAjcMmpCallOrgWndProcEx(SbcCbo, hwnd, CB_RESETCONTENT, 0, 0);
						//	削除通知
						if (hParent != NULL) {
							SendMessage(hParent, WM_COMMAND, (WPARAM)MAKELONG(cid, AJCCBN_REMOVED),
															 fCmdWithHdl ? (LPARAM)hwnd : (LPARAM)1);
						}
					}
				}
				else if (n > 0) {
					ix = (int)MAjcMmpCallOrgWndProcEx(SbcCbo, hwnd, CB_GETCURSEL, 0, 0);
					if (ix != CB_ERR) {
						//	削除する項目の文字列取得とリングバッファへ退避
						CboLbGetText(hwnd, ix, txt, AJCSBC_MAXSTL);
						//	確認メッセージ
						AjcSnPrintF(msg, AJCTSIZE(msg), LNGSEL(L"項目(%s)を削除しますか？", L"Delete item (%s)?"), txt);
						if (MessageBox(hwnd, msg, AppName, MB_YESNO) == IDYES) {
							bytes = (UI)wcslen(txt) * 2 + 2;
							AjcRngPutData(pW->hRngDel, (VOP)&bytes, sizeof bytes);
							AjcRngPutData(pW->hRngDel, (VOP)txt, bytes);
							//	n = 最大インデクス
							n--;
							//	選択項目削除
							MAjcMmpCallOrgWndProcEx(SbcCbo, hwnd, CB_DELETESTRING, ix, 0);
							//	削除項目の次（末尾項目削除時は先頭）を選択状態にする
							if (n > ix) MAjcMmpCallOrgWndProcEx(SbcCbo, hwnd, CB_SETCURSEL, ix, 0);
							else		MAjcMmpCallOrgWndProcEx(SbcCbo, hwnd, CB_SETCURSEL,  0, 0);
							//	削除通知
							if (hParent != NULL) {
								SendMessage(hParent, WM_COMMAND, (WPARAM)MAKELONG(cid, AJCCBN_REMOVED),
																 fCmdWithHdl ? (LPARAM)hwnd : (LPARAM)1);
							}
						}
					}
				}
				break;
			}
			//	●全て削除
			case IDM_RMV_ALL:
				if (MessageBox(hwnd, LNGSEL(L"全ての項目を削除しますか？",
											L"Do you remove all items?"), AppName, MB_YESNO) == IDYES) {
					int		cid		= (int)MAjcGetWindowLong(hwnd, GWL_ID);
					int		i;
					HWND	hParent = GetParent(hwnd);
					UI		bytes  = 0;
					WC		txt[AJCSBC_MAXSTL];

					//	前回の通知データ破棄
					AjcRngPurge(pW->hRngDel);
					//	カウンタクリアー
					pW->NtcDelItems = 0;
					//	削除項目文字列設定
					for (i = n - 1; i >= 0; i--) {
						//	削除する項目の文字列取得とリングバッファへ退避
						CboLbGetText(hwnd, i, txt, AJCSBC_MAXSTL);
						bytes = (UI)wcslen(txt) * 2 + 2;
						AjcRngPutData(pW->hRngDel, (VOP)&bytes, sizeof bytes);
						AjcRngPutData(pW->hRngDel, (VOP)txt, bytes);
						//	削除項目数更新
						pW->NtcDelItems++;
					}
					//	コンボボックスから全項目削除
					MAjcMmpCallOrgWndProcEx(SbcCbo, hwnd, CB_RESETCONTENT, 0, 0);
					//	削除通知
					if (hParent != NULL) {
						SendMessage(hParent, WM_COMMAND, (WPARAM)MAKELONG(cid, AJCCBN_REMOVED),
														 fCmdWithHdl ? (LPARAM)hwnd : (LPARAM)pW->NtcDelItems);
					}
				}
				break;
			//	●リストをコピー
			case IDM_LST_COPY:
			{
				HGLOBAL	hGlobal;
				int		lBuf, tl;
				//	ワイド文字
				if (IsWindowUnicode(hwnd)) {
					WCP		pBuf;
					//	バッファサイズ算出
					lBuf = 0;
					for (ix = 0; ix < n; ix++) {
						if ((tl = (UI)MAjcMmpCallOrgWndProcEx(SbcCbo, hwnd, CB_GETLBTEXTLEN, ix, 0)) > 0) {
							lBuf += (tl + 2);
						}
					}
					if (lBuf > 0) {
						if (hGlobal = GlobalAlloc(GHND | GMEM_SHARE, lBuf * 2 + 2)) {
							//	バッファへリスト読み出し＆クリップボードへコピー
							pBuf = (WCP)GlobalLock(hGlobal);
							for (ix = 0; ix < n; ix++) {
								if ((tl = (UI)MAjcMmpCallOrgWndProcEx(SbcCbo, hwnd, CB_GETLBTEXT, ix, (LPARAM)pBuf)) > 0) {
									pBuf += tl;
									*pBuf++ = L'\r';
									*pBuf++ = L'\n';
								}
							}
							*pBuf = 0;
							GlobalUnlock(hGlobal);
							OpenClipboard(hwnd);
							EmptyClipboard();
							SetClipboardData(CF_UNICODETEXT, hGlobal);
							CloseClipboard();
						}
					}
				}
				//	バイト文字
				else {
					BCP		pBuf;
					//	バッファサイズ算出
					lBuf = 0;
					for (ix = 0; ix < n; ix++) {
						if ((tl = (UI)MAjcMmpCallOrgWndProcEx(SbcCbo, hwnd, CB_GETLBTEXTLEN, ix, 0)) > 0) {
							lBuf += (tl + 2);
						}
					}
					if (lBuf > 0) {
						if (hGlobal = GlobalAlloc(GHND | GMEM_SHARE, lBuf + 1)) {
							//	バッファへリスト読み出し＆クリップボードへコピー
							pBuf = (BCP)GlobalLock(hGlobal);
							for (ix = 0; ix < n; ix++) {
								if ((tl = (UI)MAjcMmpCallOrgWndProcEx(SbcCbo, hwnd, CB_GETLBTEXT, ix, (LPARAM)pBuf)) > 0) {
									pBuf += tl;
									*pBuf++ = '\r';
									*pBuf++ = '\n';
								}
							}
							*pBuf = 0;
							GlobalUnlock(hGlobal);
							OpenClipboard(hwnd);
							EmptyClipboard();
							SetClipboardData(CF_TEXT, hGlobal);
							CloseClipboard();
						}
					}
				}
				break;
			}
			//	●リストを貼り付け
			case IDM_LST_PASTE:
			{
				if (IsClipboardFormatAvailable(CF_UNICODETEXT)) {
					HGLOBAL	hGlobal;
					WCP		pBlk, pMem, pTop, pNxt;
					if (OpenClipboard(hwnd)) {
						if (hGlobal = GetClipboardData(CF_UNICODETEXT)) {
							if (pBlk = (WCP)GlobalLock(hGlobal)) {
								if (pMem = AjcTAlloc((UI)wcslen(pBlk) + 1)) {
									wcscpy(pMem, pBlk);
									for (pNxt = pMem; *pNxt != 0; pNxt++) {
										if (*pNxt == L'\t') *pNxt = L' ';
									}
									pTop = pNxt = pMem;
									while (*pTop != 0) {
										while (*pNxt >= 0x20) pNxt++;
										if (*pNxt != 0) {
											*pNxt = 0; pNxt++;
										}
										SendMessage(hwnd, CB_ADDSTRING, 0, (LPARAM)pTop);
										while (*pNxt < 0x20  &&  *pNxt != 0) pNxt++;
										pTop = pNxt;
									}
									free(pMem);
								}
								GlobalUnlock(hGlobal);
							}
						}
						CloseClipboard();
					}
				}
				break;
			}
		}
	}
	return 0;		//	インターセプト
}
//----- ファイル／ディレクトリ ドロップ ------------------------------------------------------------------------//
AJC_WNDPROC(SbcCbo, WM_DROPFILES	)
{
	PWKSBCCBO	pW = (PWKSBCCBO)GetProp(hwnd, PN_SBCCBO);
	HDROP	hDrop;
	UI		i, n, ix = -1;
	UI		cnt = 0;
	int		cid;
	HWND	hParent;
	WC		path[MAX_PATH];

	//----- ドロップしたディレクトリ名／ファイル名追加 -----//
	hDrop = (HDROP)wParam;														//	ドロップハンドル設定
	n	  = DragQueryFile(hDrop, 0xFFFFFFFF, NULL, 0);							//	ドロップファイル数取得
	for (i = 0; i < n; i++) {													//	ドロップパス数ループ
		DragQueryFile(hDrop, i, path, MAX_PATH);								//		ドロップパス名取得
		path[MAX_PATH - 1] = 0;
		if (((pW->flag & AJCSBCF_DROPFILE) &&  AjcPathIsFile	 (path)) || 	//		ドロップ許可？
			((pW->flag & AJCSBCF_DROPDIR ) &&  AjcPathIsDirectory(path))) {
			//	ディレクトリ末尾へ「￥」付加
			if ((pW->flag & AJCSBCF_DIRTAIL) && AjcPathIsDirectory(path)) {
				AjcPathCat(path, L"", MAX_PATH);
			}
			SendMessage(hwnd, CB_ADDSTRING, 0, (LPARAM)path);					//			項目追加
			ix = (UI)SendMessage(hwnd, CB_FINDSTRINGEXACT, -1, (LPARAM)path);	//			項目検索
			cnt++;																//			追加項目数カウント
		}
	}
	DragFinish(hDrop);															//	ドロップ終了
	//	ドロップした項目を選択し、最新項目として設定
	if (ix != -1) {
		MAjcMmpCallOrgWndProcEx(SbcCbo, hwnd, CB_SETCURSEL, ix, 0);
		AjcSbcSetMostNew(hwnd);
	}
	//	親ウインドへドロップ通知
	if (cnt != 0) {
		cid = (int)MAjcGetWindowLong(hwnd, GWL_ID);
		if ((hParent = GetParent(hwnd)) != NULL) {	
			SendMessage(hParent, WM_COMMAND, (WPARAM)MAKELONG(cid, AJCCBN_DROPPED),
											 fCmdWithHdl ? (LPARAM)hwnd : (LPARAM)cnt);
		}
	}

	return 0;	//	インターセプト
}
//----- タイマ -------------------------------------------------------------------------------------------------//
AJC_WNDPROC(SbcCbo, WM_TIMER		)
{
	PWKSBCCBO	pW = (PWKSBCCBO)GetProp(hwnd, PN_SBCCBO);
	BOOL		fSelCur;
	int			ix;

	//	ドロップダウンリストの状態取得
	fSelCur = (BOOL)MAjcMmpCallOrgWndProcEx(SbcCbo, hwnd, CB_GETDROPPEDSTATE, 0, 0);

	//	リストが開かれたら、リスト選択中フラグ設定
	if		(!pW->fSel &&  fSelCur) {
		pW->ixCur  = (int)MAjcMmpCallOrgWndProcEx(SbcCbo, hwnd, CB_GETCURSEL, 0, 0);
		pW->ixLast = -1;
		pW->fSel   = TRUE;
	}
	//	リストが閉じられたら、ツールチップを消してリスト選択中フラグ解除
	else if ( pW->fSel && !fSelCur) {
		AjcTipTextHide();
		pW->fSel = FALSE;
	}
	//	リスト選択中ならば、チップ表示
	if (pW->fSel) {																				//	選択操作中？
		if ((ix  = (int)MAjcMmpCallOrgWndProcEx(SbcCbo, hwnd, CB_GETCURSEL, 0, 0)) != CB_ERR) {	//	  選択項目あり？
			if (ix != pW->ixLast) {																//		直前の選択項目と異なる？
				pW->ixLast = ix;																//		  選択項目IX退避
				SubShowTipText(pW, 9999999);													//		  チップテキスト表示
			}
		}
	}
	return 0;	//	インターセプト
}
//----- ウインド破棄 -------------------------------------------------------------------------------------------//
AJC_WNDPROC(SbcCbo, WM_DESTROY		)
{
	PWKSBCCBO	pW = (PWKSBCCBO)GetProp(hwnd, PN_SBCCBO);
	LRESULT		rc = 0;

	if (pW != NULL) {
		//	リングバッファ解放
		if (pW->hRngDel	   != NULL) {
			AjcRngDelete(pW->hRngDel );
			pW->hRngDel = NULL;
		}
		//	ファイル1行目表示時の除外文字解放
		if (pW->pCharExclude != NULL) {
			free(pW->pCharExclude);
			pW->pCharExclude = NULL;
		}
		//	リソース開放
		free(pW);
		RemoveProp(hwnd, PN_SBCCBO);
	}
	return MAjcMmpCallOrgWndProc(SbcCbo);
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(SbcCbo)
	AJC_WNDMAP_MSG(SbcCbo, CB_ADDSTRING			)
	AJC_WNDMAP_MSG(SbcCbo, CB_INSERTSTRING		)
	AJC_WNDMAP_MSG(SbcCbo, CB_DELETESTRING		)
	AJC_WNDMAP_MSG(SbcCbo, CB_RESETCONTENT		)
	AJC_WNDMAP_MSG(SbcCbo, CB_SETITEMDATA		)
	AJC_WNDMAP_MSG(SbcCbo, CB_DIR				)
	AJC_WNDMAP_MSG(SbcCbo, CB_FINDSTRING		)
	AJC_WNDMAP_MSG(SbcCbo, CB_FINDSTRINGEXACT	)
	AJC_WNDMAP_MSG(SbcCbo, WM_SETMOSTNEW		)
	AJC_WNDMAP_MSG(SbcCbo, WM_STYLECHANGED		)
	AJC_WNDMAP_MSG(SbcCbo, WM_RBUTTONDOWN		)
	AJC_WNDMAP_MSG(SbcCbo, WM_DROPFILES			)
	AJC_WNDMAP_MSG(SbcCbo, WM_TIMER				)
	AJC_WNDMAP_MSG(SbcCbo, WM_DESTROY			)
AJC_WNDMAP_END
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	サブクラス・エディットコントロール・ウインドプロシージャ（チップコントロール用に親へ通知）					//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//----- WM_LBUTTONDOWN -----------------------------------------------------------------------------------------//
AJC_WNDPROC(SbcEdt, WM_LBUTTONDOWN		)
{
	SendMessage(GetParent(hwnd), msg, wParam, lParam);
	return MAjcMmpCallOrgWndProc(SbcEdt);
}
//----- WM_RBUTTONDOWN -----------------------------------------------------------------------------------------//
AJC_WNDPROC(SbcEdt, WM_RBUTTONDOWN		)
{
	SendMessage(GetParent(hwnd), msg, wParam, lParam);
	return MAjcMmpCallOrgWndProc(SbcEdt);
}
//----- WM_MBUTTONDOWN -----------------------------------------------------------------------------------------//
AJC_WNDPROC(SbcEdt, WM_MBUTTONDOWN		)
{
	SendMessage(GetParent(hwnd), msg, wParam, lParam);
	return MAjcMmpCallOrgWndProc(SbcEdt);
}
//----- WM_MOUSEMOVE -------------------------------------------------------------------------------------------//
AJC_WNDPROC(SbcEdt, WM_MOUSEMOVE		)
{
	SendMessage(GetParent(hwnd), msg, wParam, lParam);
	return MAjcMmpCallOrgWndProc(SbcEdt);
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(SbcEdt)
	AJC_WNDMAP_MSG(SbcEdt, WM_LBUTTONDOWN	)
	AJC_WNDMAP_MSG(SbcEdt, WM_RBUTTONDOWN	)
	AJC_WNDMAP_MSG(SbcEdt, WM_MBUTTONDOWN	)
	AJC_WNDMAP_MSG(SbcEdt, WM_MOUSEMOVE	)
AJC_WNDMAP_END

//--------------------------------------------------------------------------------------------------------------//
//	ツールチップテキスト取得・コールバック																		//
//																												//
//	引　数：	hwnd	 - コンボボックスハンドル																//
//				pBuf	 - チップテキスト設定用バッファ															//
//				lBuf	 - チップテキスト設定用バッファのバイト数／文字数（５１２固定）							//
//				cbp 	 - コールバックパラメタ																	//
//																												//
//	戻り値：	チップテキスト																					//
//--------------------------------------------------------------------------------------------------------------//
static C_WCP CALLBACK cbGetTipText(HWND hwnd, WCP pBuf, UI lBuf, UX cbp)
{
	PWKSBCCBO		pW	= (PWKSBCCBO)cbp;
	C_WCP			rc	= L"";
	SIZE			rsz, tsz;
	int				ix;
	HWND			hEdt;

	//	ファイル１行目テキスト設定
	if (pW->fShowFirstLine) {
		if (SubSetFirstLineToTipTxt(pW)) {				//	ファイル１行目読み出し成功？
			rc = pW->TipTxt;							//		チップテキスト＝１行目テキスト
		}
	}
	//	テキストボックスのテキスト設定
	else if (hEdt = AjcSbcGetEditCtrlInComboBox(hwnd)) {
		AjcGetCtrlStr(hEdt, pW->TipTxt, AJCTSIZE(pW->TipTxt));
		//	表示位置＆チップサイズ設定
		SubGetPointAndSize(pW, NULL, &rsz);				//	表示域の位置とサイズ設定
		SubGetTextSize(pW, pW->TipTxt, &tsz);			//	テキストのサイズ設定
		//	チップテキストを返す
		if (rsz.cx < tsz.cx) {							//	チップテキストは表示域に収まらない？
			rc = pW->TipTxt;							//		チップテキスト表示
		}
	}
	//	選択されているテキスト設定
	else if ((ix = (int)MAjcMmpCallOrgWndProcEx(SbcCbo, hwnd, CB_GETCURSEL, 0, 0)) != CB_ERR) {
		CboLbGetText(hwnd, ix, pW->TipTxt, AJCTSIZE(pW->TipTxt));
		//	表示位置＆チップサイズ設定
		SubGetPointAndSize(pW, NULL, &rsz);				//	表示域の位置とサイズ設定
		SubGetTextSize(pW, pW->TipTxt, &tsz);			//	テキストのサイズ設定
		//	チップテキストを返す
		if (rsz.cx < tsz.cx) {							//	チップテキストは表示域に収まらない？
			rc = pW->TipTxt;							//		チップテキスト表示
		}
	}

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	ドロップダウンリストのツールチップ表示																		//
//																												//
//	引　数：	pW		- インスタンスワークアドレス															//
//				tm		- 表示時間（秒）																		//
//																												//
//	戻り値：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO		SubShowTipText(PWKSBCCBO pW, int tm)
{
	POINT		pt;
	SIZE		sz;
	int			ix;

	if ((ix  = (int)MAjcMmpCallOrgWndProcEx(SbcCbo, pW->hwnd, CB_GETCURSEL, 0, 0)) != CB_ERR) {
		CboLbGetText(pW->hwnd, ix, pW->TipTxt, AJCTSIZE(pW->TipTxt));
		SubGetPointAndSize(pW, &pt, &sz);
		if (pW->fShowFirstLine) {
			SubSetFirstLineToTipTxt(pW);
			AjcTipTextShowEx(pt.x, pt.y, sz.cx, sz.cy + 2, pW->TipTxt, tm, (HFONT)SendMessage(pW->hwnd, WM_GETFONT, 0, 0), -1, -1, -1);
		}
		else {
			WC		txt[AJCSBC_MAXSTL + 32];
			if (ix == pW->ixCur) AjcSnPrintF(txt, AJCTSIZE(txt), L"\x1B[240;255;240B%s",  pW->TipTxt);
			else				 AjcSnPrintF(txt, AJCTSIZE(txt), L"%s"				   ,  pW->TipTxt);
			AjcTipTextShowEx(pt.x, pt.y, sz.cx, sz.cy + 2, txt, tm, (HFONT)SendMessage(pW->hwnd, WM_GETFONT, 0, 0), -1, -1, -1);
		}
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	コンボボックスのテキスト表示域の位置とサイズ取得															//
//																												//
//	引　数：	pW		- インスタンスワークアドレス															//
//				pPt		- テキスト表示域の位置を格納するバッファのアドレス										//
//				pSz		- テキスト表示域のサイズを格納するバッファのアドレス									//
//																												//
//	戻り値：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO		SubGetPointAndSize(PWKSBCCBO pW, LPPOINT pPt, LPSIZE pSz)
{
	int			sty;
	HWND		hBox;
	RECT		r;
	int			x, y, cx, cy;

	sty = (int)MAjcGetWindowLong(pW->hwnd, GWL_STYLE);

	//	矩形ウインドハンドル設定
	if ((sty & CBS_DROPDOWNLIST) == CBS_DROPDOWNLIST) hBox = pW->hwnd;
	else											  hBox = AjcSbcGetEditCtrlInComboBox(pW->hwnd);

	//	念のため、矩形情報が得られない場合は、コンボボックス全体とする。
	if (hBox == NULL) hBox = AjcSbcGetEditCtrlInComboBox(pW->hwnd);

	//	テキスト表示域の位置とサイズ設定
	GetWindowRect(hBox, &r);
	x = r.left; y = r.top; cx = r.right - r.left; cy = r.bottom - r.top;
	if ((sty & CBS_DROPDOWNLIST) == CBS_DROPDOWNLIST) {
		int ch = (int)MAjcMmpCallOrgWndProcEx(SbcCbo, pW->hwnd, CB_GETITEMHEIGHT, 0, 0);
		int mg = (cy - ch) / 2;
		if (mg > 2) mg = 2;
		y  += mg;
		cy -= (mg * 2);
		x  += 2;
		cx -= 22;
	}
	if (pPt != NULL) pPt->x  = x;
	if (pPt != NULL) pPt->y  = y;
	if (pSz != NULL) pSz->cx = cx;
	if (pSz != NULL) pSz->cy = cy;
}
//--------------------------------------------------------------------------------------------------------------//
//	テキストの表示サイズ取得																					//
//																												//
//	引　数：	pW		- インスタンスワークアドレス															//
//				pTxt	- テキストのアドレス																	//
//				pSz		- テキスト表示サイズを格納するバッファのアドレス										//
//																												//
//	戻り値：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO		SubGetTextSize(PWKSBCCBO pW, C_WCP pTxt, LPSIZE pSz)
{
	HDC		hdc;
	HFONT	hF;

	hdc = GetDC(pW->hwnd);
	hF = (HFONT)SelectObject(hdc, (HFONT)SendMessage(pW->hwnd, WM_GETFONT, 0, 0));

	pSz->cx = 0;
	GetTextExtentPoint32(hdc, pTxt, (int)wcslen(pTxt), pSz);

	SelectObject(hdc, hF);
	ReleaseDC(pW->hwnd, hdc);
}

//--------------------------------------------------------------------------------------------------------------//
//	コンボボックスから最古の項目削除																			//
//																												//
//	引　数：	pW		- インスタンスワークアドレス															//
//																												//
//	戻り値：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO		SubDeleteMostOldItem(PWKSBCCBO pW)
{
	int		n, ix, dix;
	UI		min, seq;
	WC		str[AJCSBC_MAXSTL];

	n = (UI)MAjcMmpCallOrgWndProcEx(SbcCbo, pW->hwnd, CB_GETCOUNT, 0, 0);
	if (n != 0	&& n != CB_ERR) {
		//	削除する（最古の）項目検索
		min = UINT_MAX;
		for (ix = 0; ix < n; ix++) {
			seq = (UI)MAjcMmpCallOrgWndProcEx(SbcCbo, pW->hwnd, CB_GETITEMDATA, ix, 0);
			if (seq < min && seq != CB_ERR) {
				dix = ix;
				min = seq;
			}
		}
		//	現在選択されている文字列取得
		if ((ix = (int)MAjcMmpCallOrgWndProcEx(SbcCbo, pW->hwnd, CB_GETCURSEL, 0, 0)) != CB_ERR) {
			CboLbGetText(pW->hwnd, ix, str, AJCSBC_MAXSTL);
		}
		//	項目削除(ｎ＝残項目数）
		n = (int)MAjcMmpCallOrgWndProcEx(SbcCbo, pW->hwnd, CB_DELETESTRING, dix, 0);
		//	残項目ありならば、選択されていた項目を復元
		if (n >= 1) {
			if (ix != CB_ERR && (ix = SubFindString(pW, str)) != CB_ERR) {
				MAjcMmpCallOrgWndProcEx(SbcCbo, pW->hwnd, CB_SETCURSEL, ix, 0);
			}
			else {
				if ((MAjcMmpCallOrgWndProcEx(SbcCbo, pW->hwnd, CB_SETCURSEL, dix, 0)) == CB_ERR) {
					 MAjcMmpCallOrgWndProcEx(SbcCbo, pW->hwnd, CB_SETCURSEL, 0, 0);
				}
			}
		}
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	コンボボックスの文字列検索																					//
//																												//
//	引　数：	pW		- インスタンスワークアドレス															//
//				pStr	- 検索する文字列																		//
//																												//
//	戻り値：	≠CB_ERR - 見つかった項目のインデクス															//
//				＝CB_ERR - 文字列が見つからない																	//
//--------------------------------------------------------------------------------------------------------------//
static	int	SubFindString(PWKSBCCBO pW, WCP pStr)
{
	UI		rc = CB_ERR;
	UI		n, ix;
	int		rsu;
	WC		txt[AJCSBC_MAXSTL];		//	リスト項目

	n = (UI)MAjcMmpCallOrgWndProcEx(SbcCbo, pW->hwnd, CB_GETCOUNT, 0, 0);
	if (n != 0	&& n != CB_ERR) {
		for (ix=0; ix<n; ix++) {
			if (CboLbGetText(pW->hwnd, ix, txt, AJCSBC_MAXSTL) != CB_ERR) {
				if (pW->flag & AJCSBCF_IGNORWIDTH) rsu = wcsicmp(txt, pStr);
				else							   rsu = wcscmp (txt, pStr);
				if (rsu == 0) {
					rc = ix;
					break;
				}
			}
		}
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	コンボボックスの先頭部分文字列検索																			//
//																												//
//	引　数：	pW		- インスタンスワークアドレス															//
//				pStr	- 検索する文字列																		//
//																												//
//	戻り値：	≠CB_ERR - 見つかった項目のインデクス															//
//				＝CB_ERR - 文字列が見つからない																	//
//--------------------------------------------------------------------------------------------------------------//
static	int	SubFindFront(PWKSBCCBO pW, WCP pStr)
{
	UI		rc = CB_ERR;
	UI		n, ix;
	int		rsu;
	UI		stl;
	WC		txt[AJCSBC_MAXSTL];		//	リスト項目

	n = (UI)MAjcMmpCallOrgWndProcEx(SbcCbo, pW->hwnd, CB_GETCOUNT, 0, 0);
	if (n != 0	&& n != CB_ERR) {
		stl = (int)wcslen(pStr);
		for (ix=0; ix<n; ix++) {
			if (CboLbGetText(pW->hwnd, ix, txt, AJCSBC_MAXSTL) != CB_ERR) {
				if (wcslen(txt) >= stl) {
					if (pW->flag & AJCSBCF_IGNORWIDTH) rsu = wcsnicmp(txt, pStr, stl);
					else							   rsu = wcsncmp (txt, pStr, stl);
					if (rsu == 0) {
						rc = ix;
						break;
					}
				}
			}
		}
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	ツールチップテキストをファイルの１行目で置き換える															//
//																												//
//	引　数：	pW		- インスタンスワークアドレス															//
//				pStr	- 検索する文字列																		//
//																												//
//	戻り値：	TRUE  - ファイルの１行目を設定した																//
//				FALSE - ファイルをオープンできない／空のファイル												//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	SubSetFirstLineToTipTxt(PWKSBCCBO pW)
{
	BOOL		rc = FALSE;
	int			i;
	HAJCFILE	fh = NULL;
	WC			buf[AJCSBC_MAXSTL] = {0};

	if (fh = AjcFOpen(pW->TipTxt, pW->InpTec)) {
		while (buf[0] == 0 && AjcFGetS(fh, buf, AJCTSIZE(buf))) {
			buf[AJCSBC_MAXSTL - 1] = 0;
			//	改行文字消去
			if (buf[0] == '\n') buf[0] = 0;
			else				AjcStrTokW(buf, L"\n");
			//	前後文字除去
			AjcStrTrimEx(buf, buf, AJCTSIZE(buf), pW->pCharExclude);
			//	ＴＡＢ→空白変換
			for (i = 0; buf[i] != 0; i++) {
				if (buf[i] == 0x09) buf[i] = ' ';
			}
		}
		if (buf[0] != 0) {
			AjcSnPrintF(pW->TipTxt, AJCTSIZE(pW->TipTxt), L"%s", buf);
			rc = TRUE;
		}
		AjcFClose(fh);
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	オリジナル・コンボボックスへメッセージ送信（CB_GETLBTEXT)													//
//--------------------------------------------------------------------------------------------------------------//
static	int		CboLbGetText(HWND hwnd, UI ix, WCP pStr, UI lStr)
{
	int		rc = CB_ERR;

	if (IsWindowUnicode(hwnd)) {
		rc = (int)MAjcMmpCallOrgWndProcEx(SbcCbo, hwnd, CB_GETLBTEXT, ix, (LPARAM)pStr);
	}
	else {
		BC	str[AJCSBC_MAXSTL];
		rc = (int)MAjcMmpCallOrgWndProcEx(SbcCbo, hwnd, CB_GETLBTEXT, ix, (LPARAM)str);
		MultiByteToWideChar(CP_ACP, 0, str, -1, pStr, lStr);
		pStr[lStr - 1] = 0;
	}
	return rc;
}


//--------------------------------------------------------------------------------------------------------------//
//	オリジナル・コンボボックスへメッセージ送信（CB_ADDSTRING)													//
//--------------------------------------------------------------------------------------------------------------//
static	int		CboAddString(HWND hwnd, C_WCP pStr)
{
	int		rc = CB_ERR;

	if (IsWindowUnicode(hwnd)) {
		rc = (int)MAjcMmpCallOrgWndProcEx(SbcCbo, hwnd, CB_ADDSTRING, 0, (LPARAM)pStr);
	}
	else {
		BC	str[AJCSBC_MAXSTL];
		WideCharToMultiByte(CP_ACP, 0, pStr, -1, str, AJCSBC_MAXSTL, NULL, NULL);
		str[AJCSBC_MAXSTL - 1] = 0;
		rc = (int)MAjcMmpCallOrgWndProcEx(SbcCbo, hwnd, CB_ADDSTRING, 0, (LPARAM)str);
	}
	return rc;
}

//--------------------------------------------------------------------------------------------------------------//
//	オリジナル・コンボボックスへメッセージ送信（CB_INSERTSTRING)												//
//--------------------------------------------------------------------------------------------------------------//
static	int		CboInsertString(HWND hwnd, UI ix, C_WCP pStr)
{
	int		rc = CB_ERR;

	if (IsWindowUnicode(hwnd)) {
		rc = (int)MAjcMmpCallOrgWndProcEx(SbcCbo, hwnd, CB_INSERTSTRING, ix, (LPARAM)pStr);
	}
	else {
		BC	str[AJCSBC_MAXSTL];
		WideCharToMultiByte(CP_ACP, 0, pStr, -1, str, AJCSBC_MAXSTL, NULL, NULL);
		str[AJCSBC_MAXSTL - 1] = 0;
		rc = (int)MAjcMmpCallOrgWndProcEx(SbcCbo, hwnd, CB_INSERTSTRING, ix, (LPARAM)str);
	}
	return rc;
}

//==============================================================================================================//
//	コンボボックス項目のテキスト比較方法設定																	//
//																												//
//	引　数：	hwnd		- コンボボックスのウインドハンドル													//
//				fExact		- TRUE	: 大文字と小文字を区別して比較												//
//							  FALSE : 大文字／小文字を区別しないで比較											//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI	AjcSbcSetCompExact(HWND hwnd, BOOL fExact)
{
	PWKSBCCBO	pW = NULL;
	BOOL		rc = FALSE;

	if (IsWindow(hwnd) && (pW = (PWKSBCCBO)GetProp(hwnd, PN_SBCCBO))) {
		if (fExact) pW->flag &= ~AJCSBCF_IGNORWIDTH;
		else		pW->flag |=  AJCSBCF_IGNORWIDTH;
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	コンボボックス項目群をプロファイルから読み出し																//
//																												//
//	引　数：	hwnd		- コンボボックスのウインドハンドル													//
//				pSect		- プロファイルセクション名															//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI	AjcSbcLoadItemsA  (HWND hwnd, C_BCP pSect)
{
	PWKSBCCBO	pW = NULL;
	BOOL		rc = FALSE;

	if (IsWindow(hwnd) && pSect != NULL && (pW = (PWKSBCCBO)GetProp(hwnd, PN_SBCCBO))) {
		//	プロファイルからコンボボックスデータ読み出し
		rc = AjcCtrlLoadComboBoxA(hwnd, pSect, AJCCTL_PSEL_INCDATA | AJCCTL_PSEL_INCLIST, FALSE);
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI	AjcSbcLoadItemsW  (HWND hwnd, C_WCP pSect)
{
	PWKSBCCBO	pW = NULL;
	BOOL		rc = FALSE;

	if (IsWindow(hwnd) && pSect != NULL && (pW = (PWKSBCCBO)GetProp(hwnd, PN_SBCCBO))) {
		//	プロファイルからコンボボックスデータ読み出し
		rc = AjcCtrlLoadComboBoxW(hwnd, pSect, AJCCTL_PSEL_INCDATA | AJCCTL_PSEL_INCLIST, FALSE);
	}
	return rc;
}

//==============================================================================================================//
//	コンボボックス項目群をプロファイルへ書き込み																//
//																												//
//	引　数：	hwnd		- コンボボックスのウインドハンドル													//
//				pSect		- プロファイルセクション名															//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI	AjcSbcSaveItemsA  (HWND hwnd, C_BCP pSect)
{
	PWKSBCCBO	pW = NULL;
	BOOL		rc = FALSE;

	if (IsWindow(hwnd) && pSect != NULL && (pW = (PWKSBCCBO)GetProp(hwnd, PN_SBCCBO))) {
		//	プロファイルへコンボボックスデータ書き込み
		rc = AjcCtrlSaveComboBoxA(hwnd, pSect, AJCCTL_PSEL_INCDATA | AJCCTL_PSEL_INCLIST);
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI	AjcSbcSaveItemsW  (HWND hwnd, C_WCP pSect)
{
	PWKSBCCBO	pW = NULL;
	BOOL		rc = FALSE;

	if (IsWindow(hwnd) && pSect != NULL && (pW = (PWKSBCCBO)GetProp(hwnd, PN_SBCCBO))) {
		//	プロファイルへコンボボックスデータ書き込み
		rc = AjcCtrlSaveComboBoxW(hwnd, pSect, AJCCTL_PSEL_INCDATA | AJCCTL_PSEL_INCLIST);
	}
	return rc;
}

//==============================================================================================================//
//	コンボボックス下のエディットコントロールのハンドルを取得する												//
//																												//
//	引　数：	hwnd		- コンボボックスのウインドハンドル													//
//																												//
//	戻り値：	≠NULL - OK（エディットコントロールのハンドル）													//
//				＝NULL - エディットコントロールなし／エラー														//
//==============================================================================================================//
static	BOOL	CALLBACK	SubEnumGetEditCtrlInComboBox(HWND hwnd, LPARAM lParam)
{
	BOOL	rc = TRUE;
	WC		cls[32];

	if (GetClassName(hwnd, cls, AJCTSIZE(cls)) != 0) {
		if (wcsicmp(cls, L"EDIT") == 0) {
			*((HWND*)lParam) = hwnd;
			rc = FALSE;
		}
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT HWND	 WINAPI	AjcSbcGetEditCtrlInComboBox(HWND hwnd)
{
	HWND	rc = NULL;

	if (IsWindow(hwnd)) {
		EnumChildWindows(hwnd, SubEnumGetEditCtrlInComboBox, (LPARAM)&rc);
	}
	return rc;
}
//==============================================================================================================//
//	コンボボックス現表示項目を最新項目に設定																	//
//																												//
//	引　数：	hwnd		- コンボボックスのウインドハンドル													//
//																												//
//	戻り値：	TRUE  - 正常																					//
//				FALSE - エラー																					//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI	AjcSbcSetMostNew			(HWND hwnd)
{
	PWKSBCCBO	pW = NULL;

	if (IsWindow(hwnd) && (pW = (PWKSBCCBO)GetProp(hwnd, PN_SBCCBO))) {
		SendMessage(hwnd, WM_SETMOSTNEW, 0, 0);
	}
	return TRUE;
}
//==============================================================================================================//
//	コンボボックス選択項目のツールチップに、ファイルの１行目を表示する											//
//																												//
//	引　数：	hwnd		- コンボボックスのウインドハンドル													//
//				pCharExclude- 除外する文字の配列																//
//																												//
//	戻り値：	≠NULL - OK（エディットコントロールのハンドル）													//
//				＝NULL - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI	AjcSbcShowFirstLineA(HWND hwnd, C_BCP pCharExclude)
{
	BOOL	rc = FALSE;
	UI		len;
	WCP		pTmp = NULL;

	if (pCharExclude != NULL) {
		len = MultiByteToWideChar(CP_ACP, 0, pCharExclude, -1, NULL, 0);
		if (len != 0 && (pTmp = AjcTAlloc(len))) {
			MultiByteToWideChar(CP_ACP, 0, pCharExclude, -1, pTmp, len);
			rc = AjcSbcShowFirstLineW(hwnd, pTmp);
		}
		if (pTmp != NULL) free(pTmp);
	}
	else {
		rc = AjcSbcShowFirstLineW(hwnd, NULL);
	}

	return rc;
}

//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI	AjcSbcShowFirstLineW(HWND hwnd, C_WCP pCharExclude)
{
	PWKSBCCBO	pW = NULL;
	BOOL		rc = FALSE;
	UI			stl;

	if (IsWindow(hwnd) && (pW = (PWKSBCCBO)GetProp(hwnd, PN_SBCCBO))) {
		//	前の除外文字配列解放
		if (pW->pCharExclude != NULL) {
			free(pW->pCharExclude);
			pW->pCharExclude = NULL;
		}
		//	除外文字が指定されていれば、1行目表示モード設定
		if (pCharExclude != NULL) {
			pW->fShowFirstLine = TRUE;
			stl = (UI)wcslen(pCharExclude);
			if (pW->pCharExclude = AjcTAlloc(stl * 2 + 2)) {
				wcscpy(pW->pCharExclude, pCharExclude);
				rc = TRUE;
			}
		}
		//	除外文字が指定されていなければ、1行目表示モード解除
		else {
			pW->fShowFirstLine = FALSE;
			rc = TRUE;
		}
	}
	return rc;
}

//==============================================================================================================//
//	コンボボックス選択項目のツールチップ制御																	//
//																												//
//	引　数：	hwnd		- コンボボックスのウインドハンドル													//
//				fTipCtrl	- ドロップダウンリストのツールチップ表示制御の指定									//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//																												//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI	AjcSbcTipCtrl(HWND hwnd, BOOL fTipCtrl)
{
	PWKSBCCBO	pW = NULL;
	int			sty;
	BOOL		rc = FALSE;

	//----- ドロップダウンリストのツールチップ表示タイマ起動／停止 ---------------------------------------------//
	if (IsWindow(hwnd) && (pW = (PWKSBCCBO)GetProp(hwnd, PN_SBCCBO))) {
		sty = (UI)MAjcGetWindowLong(hwnd, GWL_STYLE);
		if ((sty & CBS_DROPDOWNLIST) == CBS_DROPDOWN || (sty & CBS_DROPDOWNLIST) == CBS_DROPDOWNLIST) {
			if (fTipCtrl) SetTimer (hwnd, 1, 100, NULL);
			else		  KillTimer(hwnd, 1);
			rc = TRUE;
		}
	}

	return rc;
}
//==============================================================================================================//
//	長テキスト・ツールチップ表示の許可／禁止																	//
//																												//
//	引　数：	hwnd		- コンボボックスのウインドハンドル													//
//				fEnabke		- TRUE:許可，FALSE:禁止																//
//																												//
//	戻り値：	TRUE  - OK																						//
//				FALSE - Error																					//
//																												//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI	AjcSbcEnableLongTip(HWND hwnd, BOOL fEnable)
{
	PWKSBCCBO	pW = NULL;
	BOOL		rc = FALSE;

	if (IsWindow(hwnd) && (pW = (PWKSBCCBO)GetProp(hwnd, PN_SBCCBO))) {
		//	長テキストツールチップの許可
		if (fEnable) {
			if (AjcTipTextGetInfo(hwnd, NULL, NULL, 0) == -1) {
				AjcTipTextAdd(hwnd, L"");
			}
			AjcTipTextSetCallBack(hwnd, (UX)pW, NULL, cbGetTipText);
		}
		//	長テキストツールチップの禁止
		else {
			AjcTipTextSetCallBack(hwnd, (UX)pW, NULL, NULL);
		}
	}
	return rc;
}
//==============================================================================================================//
//	削除した項目の文字列取得																					//
//																												//
//	引　数：	hwnd	- コンボボックスのウインドハンドル														//
//				pBuf  	- 																						//
//				lBuf	- 																						//
//																												//
//	戻り値	：	TRUE:削除項目あり，FALSE:削除項目名なし（終端）													//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSbcGetRemovedItemA  (HWND hwnd, BCP pBuf, UI lBuf)
{
	PWKSBCCBO	pW = NULL;
	BOOL		rc	  = FALSE;
	UI			bytes = 0;
	WC			txt[AJCSBC_MAXSTL];

	if (IsWindow(hwnd) && (pW = (PWKSBCCBO)GetProp(hwnd, PN_SBCCBO)) && pBuf != NULL && lBuf != 0) {
		if (AjcRngGetData(pW->hRngDel, (VOP)&bytes, sizeof bytes) == sizeof bytes) {
			if (rc = (AjcRngGetData(pW->hRngDel, (VOP)txt, bytes) == bytes)) {
				WideCharToMultiByte(CP_ACP, 0, txt, -1, pBuf, lBuf, NULL, NULL);
				pBuf[lBuf - 1] = 0;
			}
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcSbcGetRemovedItemW  (HWND hwnd, WCP pBuf, UI lBuf)
{
	PWKSBCCBO	pW = NULL;
	BOOL		rc	 = FALSE;
	UI			bytes  = 0;
	WC			txt[AJCSBC_MAXSTL];

	if (IsWindow(hwnd) && (pW = (PWKSBCCBO)GetProp(hwnd, PN_SBCCBO)) && pBuf != NULL && lBuf != 0) {
		if (AjcRngGetData(pW->hRngDel, (VOP)&bytes, sizeof bytes) == sizeof bytes) {
			if (rc = (AjcRngGetData(pW->hRngDel, (VOP)txt, bytes) == bytes)) {
				wcsncpy(pBuf, txt, lBuf);
				pBuf[lBuf - 1] = 0;
			}
		}
	}
	return rc;
}


//==============================================================================================================//
//	サブクラス化したコンボボックスだけのダイアログ生成															//
//																												//
//	引　数：	hwnd		- オーナーウインドハンドル															//
//				id			- コントロールの識別ＩＤ															//
//				style		- 0:ﾄﾞﾛｯﾌﾟﾀﾞｳﾝ，1:標準，2:ﾄﾞﾛｯﾌﾟﾀﾞｳﾝﾘｽﾄ												//
//				fSort		- ソートオプション																	//
//				MaxItem		- 保持する項目の最大数																//
//				LimitText	- 項目の最大文字列長																//
//																												//
//	戻り値：	≠NULL - OK（ダイアログハンドル）																//
//				＝NULL - Error																					//
//==============================================================================================================//
AJCEXPORT HWND	 WINAPI	AjcSbcComboBoxCreateDlg(HWND hwnd, UI id, UI style, BOOL fSort, UI MaxItem, UI LimitText)
{
	HWND	hDlg = NULL;

	switch (style) {
		default:
		case 0:
			if (fSort) hDlg = CreateDialog(hDllInst, MAKEINTRESOURCE(IDD_SBCCOMBO_DD_S ), hwnd, (DLGPROC)DlgSbcComboProc);
			else	   hDlg = CreateDialog(hDllInst, MAKEINTRESOURCE(IDD_SBCCOMBO_DD   ), hwnd, (DLGPROC)DlgSbcComboProc);
			break;

		case 1:
			if (fSort) hDlg = CreateDialog(hDllInst, MAKEINTRESOURCE(IDD_SBCCOMBO_STD_S), hwnd, (DLGPROC)DlgSbcComboProc);
			else	   hDlg = CreateDialog(hDllInst, MAKEINTRESOURCE(IDD_SBCCOMBO_STD  ), hwnd, (DLGPROC)DlgSbcComboProc);
			break;

		case 2:
			if (fSort) hDlg = CreateDialog(hDllInst, MAKEINTRESOURCE(IDD_SBCCOMBO_DDL_S), hwnd, (DLGPROC)DlgSbcComboProc);
			else	   hDlg = CreateDialog(hDllInst, MAKEINTRESOURCE(IDD_SBCCOMBO_DDL  ), hwnd, (DLGPROC)DlgSbcComboProc);
			break;
	}

	if (hDlg != NULL) {
		SetProp(hDlg, L"IdOfSbcComboBoxCreateDlg", (HANDLE)((UX)id));
		AjcSbcComboBox(GetDlgItem(hDlg, IDC_SBCCOMBO), MaxItem, LimitText);
		ShowWindow(hDlg, SW_SHOW);
	}

	return hDlg;
}
//==============================================================================================================//
//	ダイアログ下のコンボボックスのウインドハンドル取得															//
//																												//
//	引　数：	hDlg		- ダイアログハンドル																//
//																												//
//	戻り値：	≠NULL - OK（ウインドハンドル）																	//
//				＝NULL - Error																					//
//==============================================================================================================//
AJCEXPORT HWND	 WINAPI	AjcSbcComboBoxGetCtrl(HWND hDlg)
{
	HWND	hwnd;

	hwnd = GetDlgItem(hDlg, IDC_SBCCOMBO);

	return hwnd;
}
//--------------------------------------------------------------------------------------------------------------//
//	ダイアログプロシージャ																						//
//--------------------------------------------------------------------------------------------------------------//
static LRESULT CALLBACK DlgSbcComboProc(HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam)
{
	LRESULT	rc = FALSE;

	switch (msg) {
		case WM_INITDIALOG:
			rc = TRUE; break;

		case WM_SIZE:
		{	int		w = LOWORD(lParam);
			int		h = HIWORD(lParam);
			MoveWindow(GetDlgItem(hDlg, IDC_SBCCOMBO), 0, 0, w, h, TRUE);
			rc = TRUE; break;
		}
		case WM_COMMAND:
		{	UW	id	= LOWORD(wParam);
			UW	cmd = HIWORD(wParam);
			//----- コンボボックスからの通知は、全て親ウインドへパスする -------//
			if (id == IDC_SBCCOMBO) {
				id = (UW)((UX)GetProp(hDlg, L"IdOfSbcComboBoxCreateDlg"));
				rc = SendMessage(GetParent(hDlg), msg, MAKELONG(id, cmd), lParam);
			}
			break;
		}
	}

	return rc;
}
//==============================================================================================================//
//	テキストファイルエンコード設定																				//
//																												//
//	引　数：	hwnd	- コンボボックスのウインドハンドル														//
//				iTec	- 入力テキストエンコード（－１指定時は未設定）											//
//				oTec	- 出力テキストエンコード（－１指定時は未設定）											//
//				fBOM	- BOM出力フラグ			（－１指定時は未設定）											//
//																												//
//	戻り値：	TRUE  - 正常																					//
//				FALSE - エラー																					//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI	AjcSbcSetTextEncode(HWND hwnd, EAJCTEC iTec, EAJCTEC oTec, BOOL fBOM)
{
	PWKSBCCBO	pW = (PWKSBCCBO)GetProp(hwnd, PN_SBCCBO);
	BOOL		rc = FALSE;

	if (pW != NULL) {
		if (MAJCTEC_VALID(iTec)) {
			pW->InpTec = iTec;
		}
		if (MAJCTEC_VALID(oTec)) {
			pW->OutTec = oTec;
		}
		if (fBOM == TRUE || fBOM == FALSE) {
			pW->fBOM   = fBOM;
		}
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	テキストファイルエンコード取得																				//
//																												//
//	引　数：	hwnd	- コンボボックスのウインドハンドル														//
//				piTec	- 入力テキストエンコードを格納するバッファのアドレス（不要時はNULL）					//
//				poTec	- 出力テキストエンコードを格納するバッファのアドレス（不要時はNULL）					//
//				pfBOM	- BOM出力フラグを格納するバッファのアドレス			（不要時はNULL）					//
//																												//
//	戻り値：	TRUE  - 正常																					//
//				FALSE - エラー																					//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI	AjcSbcGetTextEncode(HWND hwnd, PEAJCTEC piTec, PEAJCTEC poTec, BOOL *pfBOM)
{
	PWKSBCCBO	pW = (PWKSBCCBO)GetProp(hwnd, PN_SBCCBO);
	BOOL		rc = FALSE;

	if (pW != NULL) {
		if (piTec != NULL) *piTec = pW->InpTec;
		if (poTec != NULL) *poTec = pW->OutTec;
		if (pfBOM != NULL) *pfBOM = pW->fBOM;
		rc = TRUE;
	}
	return rc;
}
