﻿#include	"AjcInternal.h"

//**************************************************************************************************************//
//																												//
//	ラジオボタン群の統合化																						//
//																												//
//**************************************************************************************************************//

#define	PARENTPROPNAME	L"AJCSBCRBTPARENTPROP"
#define	RBTPROPNAME		L"AJCSBCRBTRBTPROP"

//--------------------------------------------------------------------------------------------------------------//
//	インスタンスワーク																							//
//--------------------------------------------------------------------------------------------------------------//
#define	MAX_RBT		128

typedef struct {
	HWND	hGrpBox;
	UI		idGrpBox;
	RECT	rcGrpBox;
	UI		nRbt;
	HWND	hRbt[MAX_RBT];
} WKSBCRBT, *PWKSBCRBT;
typedef const WKSBCRBT *PCWKSBCRBT;
//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC_DEF(Parent);

static	BOOL	CALLBACK	SubEnumCorrectRbt(HWND hChild, LPARAM lParam);
static	VO		SubRbtSort(PWKSBCRBT pW);
static	VO		CALLBACK cbRemoveAvl(UX key, VOP pNode, UI len, UI nest, UX cbp);

//==============================================================================================================//
//	ラジオボタン群統合化																						//
//																												//
//	引　数：	hGrpBox		- グループボックスのウインドハンドル												//
//																												//
//	戻り値：	ラジオボタンの個数																				//
//==============================================================================================================//
AJCEXPORT UI	 WINAPI	AjcSbcRadioBtns(HWND hGrpBox)
{
	UI			rc		 = 0;
	HAJCAVL		hAvl	 = NULL;
	PWKSBCRBT	pW		 = NULL;
	HWND		hParent	 = NULL;
	WNDPROC		WpParent = NULL;
	BOOL		fErr	 = TRUE;
	WKSBCRBT	buf;

	do {
		//----- ウインドハンドルチェック -----------------------------------------------------------------------//
		if (!IsWindow(hGrpBox)) break;
		//----- 親ウインドハンドル設定 -------------------------------------------------------------------------//
		if (!(hParent = GetParent(hGrpBox))) break;
		//----- インスタンスワーククリアー ---------------------------------------------------------------------//
		pW = &buf;
		memset(pW, 0, sizeof(WKSBCRBT));
		//----- インスタンスワーク初期化 -----------------------------------------------------------------------//
		pW->hGrpBox	 = hGrpBox;
		pW->idGrpBox = (UI)MAjcGetWindowLong(hGrpBox, GWL_ID);
		GetWindowRect(hGrpBox, &pW->rcGrpBox);
		pW->nRbt	 = 0;
		//----- グループボックス内のラジオボタンハンドル収集 ---------------------------------------------------//
		EnumChildWindows(hParent, SubEnumCorrectRbt, (LPARAM)pW);
		SubRbtSort(pW);
		if (pW->nRbt == 0) break;
		//----- ＡＶＬ木を親ウインドに関連付け -----------------------------------------------------------------//
		if (hAvl = (HANDLE)GetProp(hParent, PARENTPROPNAME)) {	// ＡＶＬ木登録済
			//----- ＡＶＬ木へインスタンス登録 -----//
			if (!AjcAvlInsNode(hAvl, (UX)hGrpBox, pW, sizeof(WKSBCRBT))) break;
		}
		else {	// ＡＶＬ木未登録
			//----- ＡＶＬ木生成 ---------------------//
			hAvl = AjcAvlCreate(0, NULL, cbRemoveAvl);
			if (hAvl == NULL) break;
			//----- ＡＶＬ木を親ウインドに関連付け -- //
			if (!SetProp(hParent, PARENTPROPNAME, (HANDLE)hAvl)) break;
			//----- ＡＶＬ木へインスタンス登録 -------//
			if (!AjcAvlInsNode(hAvl, (UX)hGrpBox, pW, sizeof(WKSBCRBT))) break;
			//----- 親ウインドのサブクラス化 ---------//
			if (MAjcMmpSetSubclass(Parent, hParent) == NULL) break;
		}
		//----- ラジオボタン統合化グループの旨、プロパティ設定 -------------------------------------------------//
		if (!SetProp(hGrpBox, SBCRADIOBTNS_GROUP_PROPNAME, (HANDLE)TRUE)) break;
		//----- エラーフラグ解除と戻り値設定 -------------------------------------------------------------------//
		fErr = FALSE;
		rc	 = pW->nRbt;
	} while(0);

	//----- エラーならば リソース解放 -----//
	if (fErr) {
		free(pW);
		if (WpParent) MAjcSetWindowLong(hParent, GWLP_WNDPROC, (UX)WpParent);
	}

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	ラジオボタンハンドル収集（コールバック）																	//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	CALLBACK	SubEnumCorrectRbt(HWND hChild, LPARAM lParam)
{
	PWKSBCRBT	pW = (PWKSBCRBT)lParam;
	BOOL		rc = TRUE;
	UI			sty;
	RECT		rct;
	WC			cls[32];

	do {
		//----- クラス名取得 -------------------------//
		if (GetClassName(hChild, cls, AJCTSIZE(cls)) == 0) {
			break;
		}
		//----- クラス名チェック ---------------------//
		if (wcsicmp(cls, L"BUTTON") != 0) {
			break;
		}
		//----- スタイルチェック ---------------------//
		sty = (UW)(MAjcGetWindowLong(hChild, GWL_STYLE) & BS_TYPEMASK);
		if (sty != BS_RADIOBUTTON  &&  sty != BS_AUTORADIOBUTTON) {
			break;
		}
		//----- 位置がグループボックス内かチェック ---//
		GetWindowRect(hChild, &rct);
		if (!(rct.left	 >= pW->rcGrpBox.left	&&
			  rct.top	 >= pW->rcGrpBox.top	&&
			  rct.right	 <= pW->rcGrpBox.right	&&
			  rct.bottom <= pW->rcGrpBox.bottom)) {
			break;
		}
		//----- ラジオボタンハンドル登録 -------------//
		if (pW->nRbt < MAX_RBT) {
			pW->hRbt[pW->nRbt] = hChild;
			SetProp(hChild, RBTPROPNAME, pW->hGrpBox); // 所属ｸﾞﾙｰﾌﾟﾎﾞｯｸｽのハンドルを登録
			pW->nRbt++;
		}
		else {
			rc = FALSE;
		}
	} while(0);

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	ラジオボタンハンドルを並び順にソート																		//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	int		x;
	int		y;
} SRSTBL, *PSRSTBL;
//--------------------------------------------------------------------------------------------------------------//
static	VO		SubRbtSort(PWKSBCRBT pW)
{
	UI		i, j;
	int		mrg, xMin, xMax, yMin, yMax;
	HWND	hwnd;
	RECT	r;
	SRSTBL	svTbl;
	SRSTBL	tbl[MAX_RBT];

	if (pW->nRbt >= 2) {
		//----- ラジオボタンの位置をテーブルに設定 ---------------------------------------------//
		for (i=0; i<pW->nRbt; i++) {
			GetWindowRect(pW->hRbt[i], &r);
			tbl[i].x = r.left;
			tbl[i].y = r.top;
		}
		//----- 位置のマージン設定 -------------------------------------------------------------//
		GetWindowRect(pW->hRbt[0], &r);
		mrg = (r.bottom - r.top) / 2;
		//----- マージン内の位置を同一位置に設定しなおす ---------------------------------------//
		for (i=0; i<pW->nRbt; i++) {
			xMin = tbl[i].x - mrg;	xMax = tbl[i].x + mrg;
			yMin = tbl[i].y - mrg;	yMax = tbl[i].y + mrg;
			for (j=0; j<pW->nRbt; j++) {
				if (tbl[j].x >= xMin  &&  tbl[j].x <= xMax) {
					tbl[j].x = tbl[i].x;
				}
				if (tbl[j].y >= yMin  &&  tbl[j].y <= yMax) {
					tbl[j].y = tbl[i].y;
				}
			}
		}
		//----- ソート -------------------------------------------------------------------------//
		for (i=0; i<pW->nRbt - 1; i++) {
			for (j=i+1; j<pW->nRbt; j++) {
				if ((tbl[i].y > tbl[j].y) || (tbl[i].y == tbl[j].y && tbl[i].x > tbl[j].x)) {
					//--- テーブル入れ替え ---//
					memcpy(&svTbl , &tbl[j], sizeof(SRSTBL));
					memcpy(&tbl[j], &tbl[i], sizeof(SRSTBL));
					memcpy(&tbl[i], &svTbl , sizeof(SRSTBL));
					//--- ハンドル入れ替え ---//
					hwnd		= pW->hRbt[j];
					pW->hRbt[j] = pW->hRbt[i];
					pW->hRbt[i] = hwnd;
				}
			}
		}
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	ＡＶＬ木ノード削除通知																						//
//--------------------------------------------------------------------------------------------------------------//
static	VO	CALLBACK	cbRemoveAvl(UX key, C_VOP pNode, UI len, UI nest, UX cbp)
{
	PCWKSBCRBT	pW = pNode;
	UI			i;

	//----- グループボックスのPROP解放 --//
	RemoveProp(pW->hGrpBox, SBCRADIOBTNS_GROUP_PROPNAME);

	//----- ラジオボタンのPROP開放 ------//
	for (i=0; i<pW->nRbt; i++) {
		RemoveProp(pW->hRbt[i], RBTPROPNAME);
	}
}

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	親ウインドプロシージャ（サブクラス）																		//
//																												//
//--------------------------------------------------------------------------------------------------------------//
//----- WM_COMMAND ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(Parent, WM_COMMAND	)
{
	HAJCAVL		hAvl	= (HAJCAVL)GetProp(hwnd, PARENTPROPNAME);
	PWKSBCRBT	pW		= NULL;
	HWND		hGrpBox = NULL;
	LRESULT		rc = 0;
	UI			i;
	BOOL		fFind = FALSE;
	WKSBCRBT	buf;

	if (hAvl != NULL) {
		//----- ボタンハンドル検索 -----------------------------//
		if (HIWORD(wParam) == BN_CLICKED) {
			if (hGrpBox = GetProp((HWND)lParam, RBTPROPNAME)) {
				if (AjcAvlGetNodeByKey(hAvl, (UX)hGrpBox, &buf, sizeof buf) != -1) {
					pW = &buf;
					if (pW->hGrpBox != NULL) {
						for (i=0; i<pW->nRbt; i++) {
							if (pW->hRbt[i] == (HWND)lParam) {
								fFind = TRUE;
								break;
							}
						}
					}
				}
			}
		}
		//----- オリジナル・ウインドプロシージャ呼び出し -------//
		if (fFind) {
			UI id = (UI)MAjcGetWindowLong(pW->hGrpBox, GWL_ID);
			rc = MAjcMmpCallOrgWndProcEx(Parent, hwnd, WM_COMMAND, MAKELONG(id, AJCRBTN_SELECT),
														fCmdWithHdl ? (LPARAM)pW->hGrpBox : i);
		}
		else {
			rc = MAjcMmpCallOrgWndProcEx(Parent, hwnd, WM_COMMAND, wParam, lParam);
		}
	}
	return rc;
}
//----- WM_DESTROY ---------------------------------------------------------------------------------------------//
AJC_WNDPROC(Parent, WM_DESTROY	)
{
	HAJCAVL		hAvl = (HAJCAVL)GetProp(hwnd, PARENTPROPNAME);
	LRESULT		rc = 0;

	//----- オリジナルプロシージャコール ------------------------//
	rc = MAjcMmpCallOrgWndProc(Parent);

	//----- リソース開放 ----------------------------------------//
	if (hAvl != NULL) {
		AjcAvlDelete(hAvl);
		RemoveProp(hwnd, PARENTPROPNAME);
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(Parent)
	AJC_WNDMAP_MSG(Parent, WM_COMMAND)
	AJC_WNDMAP_MSG(Parent, WM_DESTROY)
AJC_WNDMAP_END

//==============================================================================================================//
//	チェックされているラジオボタン取得																			//
//																												//
//	引　数：	hGrpBox		- グループボックスのウインドハンドル												//
//																												//
//	戻り値：	≠-1 : チェックされいているラジオボタンのインデクス（０～）										//
//				＝-1 : エラー																					//
//==============================================================================================================//
AJCEXPORT UI	WINAPI	AjcSbcGetRbt   (HWND hGrpBox)
{
	UI			rc = -1;
	HAJCAVL		hAvl = (HAJCAVL)GetProp(GetParent(hGrpBox), PARENTPROPNAME);
	PWKSBCRBT	pW = NULL;
	UI			i;
	WKSBCRBT	buf;

	if (hAvl != NULL  &&  AjcAvlGetNodeByKey(hAvl, (UX)hGrpBox, &buf, sizeof buf) != -1) {
		pW = &buf;
		for (i = 0; i < pW->nRbt; i++) {
			if (AjcGetCtrlChk(pW->hRbt[i])) {
				rc = i;
				break;
			}
		}
	}

	return rc;
}
//==============================================================================================================//
//	ラジオボタンをチェックする																					//
//																												//
//	引　数：	hGrpBox		- グループボックスのウインドハンドル												//
//																												//
//	戻り値：	TRUE - OK, FALSE - Error																		//
//==============================================================================================================//
AJCEXPORT BOOL	WINAPI	AjcSbcSetRbt   (HWND hGrpBox, UI ix)
{
	BOOL		rc = FALSE;
	HAJCAVL		hAvl = (HAJCAVL)GetProp(GetParent(hGrpBox), PARENTPROPNAME);
	PWKSBCRBT	pW = NULL;
	UI			i;
	WKSBCRBT	buf;

	if (hAvl != NULL  &&  AjcAvlGetNodeByKey(hAvl, (UX)hGrpBox, &buf, sizeof buf) != -1) {
		pW = &buf;
		for (i = 0; i < pW->nRbt; i++) {
			if (i == ix) AjcSetCtrlChk(pW->hRbt[i], TRUE);
			else		 AjcSetCtrlChk(pW->hRbt[i], FALSE);
		}
		rc = TRUE;
	}

	return rc;
}
//==============================================================================================================//
//	ラジオボタンのハンドル取得																					//
//																												//
//	引　数：	hGrpBox		- グループボックスのウインドハンドル												//
//				ix			- ラジオボタンのインデクス（０～）													//
//																												//
//	戻り値：	≠NULL : チェックされいているラジオボタンのインデクス（０～）									//
//				＝NULL : エラー																					//
//==============================================================================================================//
AJCEXPORT HWND	WINAPI	AjcSbcGetRbtHandle(HWND hGrpBox, UI ix)
{
	HWND		rc = NULL;
	HAJCAVL		hAvl = (HAJCAVL)GetProp(GetParent(hGrpBox), PARENTPROPNAME);
	PWKSBCRBT	pW = NULL;
	UI			i;
	WKSBCRBT	buf;

	if (hAvl != NULL  &&  AjcAvlGetNodeByKey(hAvl, (UX)hGrpBox, &buf, sizeof buf) != -1) {
		pW = &buf;
		if (ix < pW->nRbt) {
			for (i = 0; i < pW->nRbt; i++) {
				if (i == ix) {
					rc = pW->hRbt[i];
					break;
				}
			}
		}
	}

	return rc;
}

