﻿#include	"AjcInternal.h"
#include	"AjcSerialComPortDef.h"
//**************************************************************************************************************//
//																												//
//	ＣＯＭポート入出力								ＡＰＩ														//
//																												//
//**************************************************************************************************************//

#define	IS_MY_INST(P)	(P != NULL && P->InstID == SCP_INST_ID)

//--------------------------------------------------------------------------------------------------------------//
//	グローバルワーク																							//
//--------------------------------------------------------------------------------------------------------------//
ATOM	ScpClassForMSIL	= 0;

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
static	VO		SubDeleteResource(HAJCSCP pW);
static	VO		LoadProfile(HAJCSCP pW, C_WCP pSect);
static	VO		SaveProfile(HAJCSCP pW, C_WCP pSect);
static	UI		SubDlgParamEasy	 (HAJCSCP pW, HWND hWndOwner, LPPOINT pPt);
static	UI		SubDlgParamDetail(HAJCSCP pW, HWND hWndOwner, LPPOINT pPt);

//==============================================================================================================//
//	起動時初期設定																								//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	AjcCtrlSerialComPInit(VO)
{
	BOOL		rc = FALSE;
	WNDCLASS	wndclass;

	do {
		//----- ＭＳＩＬコードサポート用 ---------------------//
		wndclass.style			= 0;
		wndclass.lpfnWndProc	= ScpWndProcMSIL();
		wndclass.cbClsExtra		= 0;
		wndclass.cbWndExtra		= sizeof(VOP);
		wndclass.hInstance		= hDllInst;
		wndclass.hIcon			= NULL;
		wndclass.hCursor		= LoadCursor(NULL, IDC_ARROW);
		wndclass.hbrBackground	= (HBRUSH)GetStockObject(WHITE_BRUSH);
		wndclass.lpszMenuName	= NULL;
		wndclass.lpszClassName	= L"AjcScpForMSIL";
		if ((ScpClassForMSIL = RegisterClass(&wndclass)) == 0) break;

		rc = TRUE;
	} while(0);

	if (rc == FALSE) {
		AjcCtrlSerialComPEnd();
	}

	return rc;
}
//==============================================================================================================//
//	終了時後処理																								//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - エラー																					//
//==============================================================================================================//
VO		AjcCtrlSerialComPEnd (VO)
{
	if (ScpClassForMSIL != 0 ) {UnregisterClass((WCP)ScpClassForMSIL, hDllInst); ScpClassForMSIL = 0;}
}
//--------------------------------------------------------------------------------------------------------------//
//	インスタンス生成（共通サブ関数）																			//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	≠ＮＵＬＬ：ＯＫ（インスタンスハンドル（＝インスタンスワークアドレス））						//
//				＝ＮＵＬＬ：エラー																				//
//--------------------------------------------------------------------------------------------------------------//
//----- イベント通知キュー消去時コールバック -------------------------------------------------------------------//
static	VO	CALLBACK cbFQueRemove(VOP pvEvtInf, UX cbp)
{
	PSCP_EVTINF	*pEvtInf = (PSCP_EVTINF *)pvEvtInf;

	if ((*pEvtInf)->pDat != NULL) {
		free((*pEvtInf)->pDat);
		(*pEvtInf)->pDat = NULL;
	}
}
//----- 共通サブ -----------------------------------------------------------------------------------------------//
static	HAJCSCP		SubScpCreate(BOOL fUnicode, C_WCP pSect, BOOL fCreateMySlot,
												C_WCP pMySlot, C_WCP pRmtHost, C_WCP pRmtSlot, UI nMaxMessageSize, UI lReadTimeout, LPSECURITY_ATTRIBUTES lpSecurityAttributes)
{
	HAJCSCP	pW	 = NULL;
	BOOL	fErr = TRUE;
	int		len;

	do {
		//----- インスタンスワーク確保 -------------------------------------------------------------------------//
		if ((pW = (HAJCSCP)AJCMEM(sizeof(AJCSCP))) == NULL) break;
		memset(pW, 0, sizeof(AJCSCP));
		//----- プロファイルセクション設定 ---------------------------------------------------------------------//
		if (pSect != NULL && *pSect != 0) {
			AjcSnPrintF(pW->ProfileSect, AJCTSIZE(pW->ProfileSect), L"%s", pSect);
		}
		else {
			memset(pW->ProfileSect, 0, sizeof pW->ProfileSect);
		}
		//----- インスタンスワーク初期化 -----------------------------------------------------------------------//
		pW->InstID			= SCP_INST_ID;
		pW->PortNo			= 1;
		pW->fUnicode		= fUnicode;
		pW->ChunkMode		= AJCSCP_CM_BIN;
		pW->RxTxtCode		= AJCSCP_TXT_SJIS;
		pW->TxTxtCode		= AJCSCP_TXT_SJIS;
		pW->EvtMask			= AJCSCP_EV_DEFAULT_EVT;
		pW->hWndNtc			= NULL;
		pW->MsgNtc			= 0;
		//----- 通信パラメタのデフォルト設定 -------------------------------------------------------------------//
		//	デフォルト値設定（ＤＣＢ，タイムアウト）
		AjcScpGetDefaultParam(&pW->CommDcb, &pW->CommTmo);
		//	デフォルト設定（送受信停止認識時間）----------------------------------------------------------------//
		pW->MesTxTime = 300;		//	送信停止認識時間
		pW->MesRxTime = 300;		//	受信停止認識時間
		//	デフォルト値設定（メールスロット）
		wcscpy(pW->SlotInfo.MySlotName , L"MySlot");
		wcscpy(pW->SlotInfo.RmtHostName, L"");
		wcscpy(pW->SlotInfo.RmtSlotName, L"RmtSlot");
		pW->SlotInfo.fTxDelay	= FALSE;
		pW->SlotInfo.TxDelayBPS	= 100;
		//	デフォルト値設定（ソケット）
		wcscpy(pW->SockInfo.ServName, L"127.0.0.1");
		pW->SockInfo.PortNo = 14238;
		//----- メールスロット情報設定 -------------------------------------------------------------------------//
		if (pMySlot  != NULL) AjcSnPrintF(pW->SlotInfo.MySlotName , AJCTSIZE(pW->SlotInfo.MySlotName) , L"%s", pMySlot );
		if (pRmtHost != NULL) AjcSnPrintF(pW->SlotInfo.RmtHostName, AJCTSIZE(pW->SlotInfo.RmtHostName), L"%s", pRmtHost);
		if (pRmtSlot != NULL) AjcSnPrintF(pW->SlotInfo.RmtSlotName, AJCTSIZE(pW->SlotInfo.RmtSlotName), L"%s", pRmtSlot);
		//----- プロファイルセクションから通信パラメタ読み出し -------------------------------------------------//
		if (pW->ProfileSect[0] != 0) {
			LoadProfile(pW, NULL);
		}
		//----- メールボックスハンドル生成 ---------------------------------------------------------------------//
		if (!(pW->hVMbxTxD	  = AjcVMbxCreate( 				   0, NULL 			  ))) break;	//	送信データ
		if (!(pW->hFMbxNtc	  = AjcFMbxCreate(sizeof(PSCP_EVTINF), 0, cbFQueRemove))) break;	//	ユーザＡＰへのイベント通知用
		//----- クリティカルセクションオブジェクト初期化 -------------------------------------------------------//
		InitializeCriticalSection(&pW->CsCommApi);
		InitializeCriticalSection(&pW->CsTxDelay);
		//----- 計測タイマ生成 ---------------------------------------------------------------------------------//
		if ((pW->hMesTxDelay = AjcMesTimeCreate(NULL)) == NULL) break;	//	送信速度制限用
		//----- メールスロット送信速度制限情報初期化 -----------------------------------------------------------//
		pW->fTxDelay			 = pW->SlotInfo.fTxDelay;				//	送信速度制限フラグ
		pW->TxDelayBPS			 = pW->SlotInfo.TxDelayBPS * 1024;		//	送信制限速度[Bytes / sec]
		pW->TxDelayBytesCount	 = 0;									//	送信遅延用バイトカウンタ
		pW->TxDelayTickCount	 = 0;									//	送信遅延用・経過時間[us]
		//----- バイトペア受信制御情報 -------------------------------------------------------------------------//
		pW->fBpLBFirst	= TRUE;											//	Low Byte First
		pW->BpSeq		= 0;											//	受信バイトカウンタ（０～１）
		//----- スレッド終了指示フラグクリアー -----------------------------------------------------------------//
		pW->fThreadEnd = FALSE;
		//----- データ送信スレッド生成 -------------------------------------------------------------------------//
		if (!ScpStartThreadTx(pW)) break;
		//----- データ受信スレッド生成 -------------------------------------------------------------------------//
		if (!ScpStartThreadRx(pW)) break;
		//----- 信号監視スレッド生成 ---------------------------------------------------------------------------//
		if (!ScpStartThreadObs(pW)) break;
		//----- 自ホスト名設定 ---------------------------------------------------------------------------------//
		len = AJCTSIZE(pW->SlotInfo.MyHostName);
		GetComputerName(pW->SlotInfo.MyHostName, &len);
		//----- CreateMailSlot()の引数退避 ---------------------------------------------------------------------//
		pW->MaxMsgSize	= nMaxMessageSize;
		pW->ReadTimeout = lReadTimeout;
		//----- セキュリティ情報退避 ---------------------------------------------------------------------------//
		//	セキュリティ属性退避
		pW->pSecAttr = NULL;
		ScpSaveSlot(pW, lpSecurityAttributes);
		//----- 自メールスロット生成 ---------------------------------------------------------------------------//
		if (fCreateMySlot) {
			ScpCreateMySlot(pW);
		}
		//----- ソケットイベント通知用イベントオブジェクト生成 -------------------------------------------------//
		if ((pW->hEvtSock = WSACreateEvent()) == NULL) {
			break;
		}
		//----- エラーフラグクリアー ---------------------------------------------------------------------------//
		fErr = FALSE;
	} while(0);

	//----- エラー発生ならば、全リソース消去 -------------------------------------------------------------------//
	if (fErr) {
		SubDeleteResource(pW);
		pW = NULL;
	}

	return pW;
}
//==============================================================================================================//
//	インスタンス生成																							//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	≠ＮＵＬＬ：ＯＫ（インスタンスハンドル（＝インスタンスワークアドレス））						//
//				＝ＮＵＬＬ：エラー																				//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	HAJCSCP		WINAPI	AjcScpCreateA(VO)
{
	return AjcScpCreateExA("SerialComPort" , FALSE,	"MySlot",	"",  "RmtSlot");
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	HAJCSCP		WINAPI	AjcScpCreateW(VO)
{
	return AjcScpCreateExW(L"SerialComPort", FALSE, L"MySlot",	L"", L"RmtSlot");
}
//==============================================================================================================//
//	インスタンス生成（プロファイル・セクション指定）															//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	≠ＮＵＬＬ：ＯＫ（インスタンスハンドル（＝インスタンスワークアドレス））						//
//				＝ＮＵＬＬ：エラー																				//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	HAJCSCP		WINAPI	AjcScpCreatePfA(C_BCP pSect)
{
	return AjcScpCreateExA(pSect, FALSE,  "MySlot",  "",  "RmtSlot");
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	HAJCSCP		WINAPI	AjcScpCreatePfW(C_WCP pSect)
{
	return AjcScpCreateExW(pSect, FALSE, L"MySlot", L"", L"RmtSlot");
}
//==============================================================================================================//
//	インスタンス生成（メールスロット用）																		//
//																												//
//	引　数	：	pSect			- プロファイルセクション名（NULL指定時は、プロファイルへ記録しない）			//
//				fCreateMySlot	- 自メールスロット生成フラグ													//
//				pMySlot			- 自スロット名		（NULL指定時はプロファイル読み出し値が有効)					//
//				pRmtHost		- リモートホスト名	（NULL指定時はプロファイル読み出し値が有効)					//
//				pRmtSlot		- リモートスロット名（NULL指定時はプロファイル読み出し値が有効)					//
//																												//
//	戻り値	：	≠ＮＵＬＬ：ＯＫ（インスタンスハンドル（＝インスタンスワークアドレス））						//
//				＝ＮＵＬＬ：エラー																				//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	HAJCSCP		WINAPI	AjcScpCreateSlotA(C_BCP pSect, BOOL fCreateMySlot, C_BCP pMySlot, C_BCP pRmtHost, C_BCP pRmtSlot)
{
	return AjcScpCreateSlotExA(pSect, fCreateMySlot, pMySlot, pRmtHost, pRmtSlot, 0, 0, NULL);
}
//----- ワイド文字	--------------------------------------------------------------------------------------------//
AJCEXPORT	HAJCSCP		WINAPI	AjcScpCreateSlotW(C_WCP pSect, BOOL fCreateMySlot, C_WCP pMySlot, C_WCP pRmtHost, C_WCP pRmtSlot)
{
	return AjcScpCreateSlotExW(pSect, fCreateMySlot, pMySlot, pRmtHost, pRmtSlot, 0, 0, NULL);
}
//--------------------------------------------------------------------------------------------------------------//
//----- バイト文字（非推奨）------------------------------------------------------------------------------------//
AJCEXPORT	HAJCSCP		WINAPI	AjcScpCreateExA(C_BCP pSect, BOOL fCreateMySlot, C_BCP pMySlot, C_BCP pRmtHost, C_BCP pRmtSlot)
{
	return AjcScpCreateSlotExA(pSect, fCreateMySlot, pMySlot, pRmtHost, pRmtSlot, 0, 0, NULL);
}
//----- ワイド文字（非推奨） -----------------------------------------------------------------------------------//
AJCEXPORT	HAJCSCP		WINAPI	AjcScpCreateExW(C_WCP pSect, BOOL fCreateMySlot, C_WCP pMySlot, C_WCP pRmtHost, C_WCP pRmtSlot)
{
	return AjcScpCreateSlotExW(pSect, fCreateMySlot, pMySlot, pRmtHost, pRmtSlot, 0, 0, NULL);
}
//==============================================================================================================//
//	インスタンス生成（メールスロット用．プロファイルセクション，メールスロットオプション指定）					//
//																												//
//	引　数	：	pSect			- プロファイルセクション名（NULL指定時は、プロファイルへ記録しない）			//
//				fCreateMySlot	- 自メールスロット生成フラグ													//
//				pMySlot			- 自スロット名		（NULL指定時はプロファイル読み出し値が有効)					//
//				pRmtHost		- リモートホスト名	（NULL指定時はプロファイル読み出し値が有効)					//
//				pRmtSlot		- リモートスロット名（NULL指定時はプロファイル読み出し値が有効)					//
//																												//
//	戻り値	：	≠ＮＵＬＬ：ＯＫ（インスタンスハンドル（＝インスタンスワークアドレス））						//
//				＝ＮＵＬＬ：エラー																				//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	HAJCSCP		WINAPI	AjcScpCreateSlotExA(C_BCP pSect, BOOL fCreateMySlot, C_BCP pMySlot, C_BCP pRmtHost, C_BCP pRmtSlot, UI nMaxMessageSize, UI lReadTimeout, LPSECURITY_ATTRIBUTES lpSecurityAttributes)
{
	HAJCSCP	pW		  = NULL;
	WCP		pSectW	  = NULL;
	WCP		pMySlotW  = NULL;
	WCP		pRmtHostW = NULL;
	WCP		pRmtSlotW = NULL;

	do {
		BCF_ALLOC(pSect		);
		BCF_ALLOC(pMySlot	);
		BCF_ALLOC(pRmtHost	);
		BCF_ALLOC(pRmtSlot	);
		//	ＳＣＰインスタンス生成
		pW = SubScpCreate(FALSE, pSectW, fCreateMySlot, pMySlotW, pRmtHostW, pRmtSlotW, nMaxMessageSize, lReadTimeout, lpSecurityAttributes);

	} while(0);

	if (pSectW	  != NULL) AjcTFree(pSectW	 );
	if (pMySlotW  != NULL) AjcTFree(pMySlotW );
	if (pRmtHostW != NULL) AjcTFree(pRmtHostW);
	if (pRmtSlotW != NULL) AjcTFree(pRmtSlotW);

	return pW;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	HAJCSCP		WINAPI	AjcScpCreateSlotExW(C_WCP pSect, BOOL fCreateMySlot, C_WCP pMySlot, C_WCP pRmtHost, C_WCP pRmtSlot, UI nMaxMessageSize, UI lReadTimeout, LPSECURITY_ATTRIBUTES lpSecurityAttributes)
{
	HAJCSCP	pW = NULL;

	pW = SubScpCreate(TRUE, pSect, fCreateMySlot, pMySlot, pRmtHost, pRmtSlot, nMaxMessageSize, lReadTimeout, lpSecurityAttributes);

	return pW;
}
//==============================================================================================================//
//	インスタンス消去																							//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
AJCEXPORT	BOOL			WINAPI	AjcScpDelete		(HAJCSCP pW)
{
	BOOL	rc = FALSE;
	UI		Count = 0;

	if (IS_MY_INST(pW)) {
		//----- プロファイルセクションへ通信パラメタセーブ ---------------------//
		SaveProfile(pW, NULL);
		//----- 全リソース解放 -------------------------------------------------//
		SubDeleteResource(pW);

		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	モード設定																									//
//																												//
//	引　数	：	pW				- インスタンスハンドル															//
//				hWndNtc			- ユーザＡＰへのイベント通知用ウインドハンドル									//
//				WndMsgNtc		- ユーザＡＰへのイベント通知用ウインドメッセージ								//
//				ChunkMode		- チャンクデータ通知モード														//
//																												//
//	戻り値	：	TRUE ：ＯＫ																						//
//				FALSE：エラー																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcScpSetMode		(HAJCSCP pW, HWND hWndNtc, UI WndMsgNtc, AJCSCP_CHUNKMODE ChunkMode)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		if (hWndNtc == NULL	 ||	 IsWindow(hWndNtc)) {
			pW->hWndNtc	   = hWndNtc;
			pW->MsgNtc	   = WndMsgNtc;
			pW->ChunkMode  = ChunkMode;
			if (hWndNtc != NULL) pW->EvtMask = AjcScpSetEvtMask(pW, AJCSCP_EV_DEFAULT_POST);
			else				 pW->EvtMask = AjcScpSetEvtMask(pW, AJCSCP_EV_DEFAULT_EVT);
			rc = TRUE;
		}
	}
	return rc;
}
//==============================================================================================================//
//	ポートオープン（ＣＯＭポート，通信パラメタ指定）															//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				Port		- ポート番号																		//
//				Rate		- 通信レート[bps]																	//
//				DataBits	- データビット長（７～８）															//
//				Parity		- パリティビット仕様（'N', 'O', 'E'）												//
//				StpBit		- ストップビット長（１～２）														//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcScpOpen(HAJCSCP pW, UI Port, UI Rate, UI DataBits, UI Parity, UI StopBit)
{
	BOOL			rc = FALSE;
	DCB				dcb;

	if (IS_MY_INST(pW)) {
		//----- 文字コード判定バッファリセット --------------//
		AjcSsepMbcReset(pW->hSsep);
		//----- 通信リソースオープン中ならば、クローズする --//
		if (pW->hPort != NULL) {
			AjcScpClose(pW);
			pW->hPort = NULL;
		}
		//----- ＣＯＭポートモード設定 ----------------------//
		pW->PortSel = AJCSCP_SEL_COMPORT;
		//----- ポート番号設定，変更通知 --------------------//
		if (Port != pW->PortNo) {
			pW->PortNo = Port;
			ScpNtcPortStateToUser(pW, AJCSCP_PORTNO);
		}
		//----- デフォルトＤＣＢコピー ----------------------//
		memcpy(&dcb, &pW->CommDcb, sizeof dcb);
		//----- レート値設定 --------------------------------//
		if (Rate != 0) {
			dcb.BaudRate = Rate;
		}
		//----- データ長設定 --------------------------------//
		switch (DataBits) {
			case 7:	dcb.ByteSize = 7; break;
			case 8:	dcb.ByteSize = 8; break;
		}
		//----- パリティ設定 --------------------------------//
		switch (Parity) {
			case 'N':	dcb.fParity = 0; dcb.Parity = 0; break;
			case 'O':	dcb.fParity = 1; dcb.Parity = 1; break;
			case 'E':	dcb.fParity = 1; dcb.Parity = 2; break;
		}
		//----- ストップビット長設定 ------------------------//
		switch (StopBit) {
			case 1:	dcb.StopBits = 0; break;
			case 2:	dcb.StopBits = 2; break;
		}
		//----- ＣＯＭポートオープン ------------------------//
		rc = AjcScpOpenEx(pW, Port, &dcb, NULL);
	}
	return rc;
}
//==============================================================================================================//
//	ポートオープン（ＣＯＭポート，ＤＣＢ指定）																	//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				Port		- ポート番号																		//
//				pDcb		- ＤＣＢ情報のアドレス																//
//				pTmo		- タイムアウト情報のアドレス														//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcScpOpenEx		(HAJCSCP pW, UI Port, LPDCB pDcb, LPCOMMTIMEOUTS pTmo)
{
	BOOL	rc = FALSE;
	UI		CommErr;

	if (IS_MY_INST(pW)) {
		do {
			//----- 文字コード判定バッファリセット -------------------------------------------------------------//
			AjcSsepMbcReset(pW->hSsep);
			//----- 送信テキスト半端バイト／ワードリセット -----------------------------------------------------//
			pW->SvSndA = 0;
			pW->SvSndW = 0;
			//----- ポート番号チェック -------------------------------------------------------------------------//
			if (Port == 0 || Port > 255) break;
			//----- 通信リソースオープン中ならば、クローズする -------------------------------------------------//
			if (pW->hPort != NULL) {
				AjcScpClose(pW);
				pW->hPort = NULL;
			}
			//----- ポートモード設定 ---------------------------------------------------------------------------//
			pW->PortSel = AJCSCP_SEL_COMPORT;
			//----- ポート番号，ＤＣＢ，ＴＭＯ設定 -------------------------------------------------------------//
			if (Port != 0  &&  Port != pW->PortNo) {
				pW->PortNo = Port;
				ScpNtcPortStateToUser(pW, AJCSCP_PORTNO);
			}
			if (pDcb != NULL) memcpy(&pW->CommDcb, pDcb, sizeof pW->CommDcb);
			if (pTmo != NULL) memcpy(&pW->CommTmo, pTmo, sizeof pW->CommTmo);
			//----- ポートオープン -----------------------------------------------------------------------------//
			if ((pW->hPort = ScpOpenFile(pW)) == NULL) break;

			//----- システム送受信バッファサイズ設定 -----------------------------------------------------------//
			ScpClearCommError(pW, &CommErr, NULL);
			if (!ScpSetupComm(pW, SCP_SYSRXBUFSIZE, SCP_SYSTXBUFSIZE))	break;

			//----- ＤＣＢ設定 ---------------------------------------------------------------------------------//
			ScpClearCommError(pW, &CommErr, NULL);
			if (!ScpSetCommState(pW, &pW->CommDcb)) break;

			//----- タイムアウト値設定 -------------------------------------------------------------------------//
			ScpClearCommError(pW, &CommErr, NULL);
			if (!ScpSetCommTimeouts(pW, &pW->CommTmo))	break;

			//----- ＤＴＲ，ＲＴＳセット -----------------------------------------------------------------------//
			ScpEscapeCommFunction(pW, SETDTR);
			ScpEscapeCommFunction(pW, SETRTS);

			//----- エラーリセット -----------------------------------------------------------------------------//
			ScpClearCommError(pW, &CommErr, NULL);

			//----- 信号通知初回フラグセット -------------------------------------------------------------------//
			pW->GpiState = AJCSCP_FIRST;

			//----- 受信バッファクリアー -----------------------------------------------------------------------//
			pW->ixRxb = pW->ixNpk = 0;
			memset(pW->RxBuf, 0, sizeof pW->RxBuf);
			memset(pW->NpBuf, 0, sizeof pW->NpBuf);

			//----- バイトペア受信カウンタクリアー -------------------------------------------------------------//
			pW->BpSeq = 0;

			//----- エラーフラグ解除 ---------------------------------------------------------------------------//
			rc = TRUE;
		} while(0);

		//----- 成功ならばオープン通知 -------------------------------------------------------------------------//
		if (rc) {
			ScpNtcPortStateToUser(pW, AJCSCP_OPENED);
		}
		//----- エラーならば、ＣＯＭポートクローズし、エラー通知 -----------------------------------------------//
		else {
		//	AjcScpClose(pW);
			ScpNtcPortStateToUser(pW, AJCSCP_OPENFAIL);
		}
	}
	return rc;
}
//==============================================================================================================//
//	ポートオープン（メールスロット）																			//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pRmtHost	- リモートホスト名	（ダイアログでの設定済名称を使用する場合はNULL)					//
//				pRmtSlot	- リモートスロット名（ダイアログでの設定済名称を使用する場合はNULL)					//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcScpOpenSlotA		(HAJCSCP pW, C_BCP pRmtHost, C_BCP pRmtSlot)
{
	BOOL	rc = FALSE;
	WCP		pRmtHostW = NULL;
	WCP		pRmtSlotW = NULL;

	do {
		BCF_ALLOC(pRmtHost);
		BCF_ALLOC(pRmtSlot);
		rc = AjcScpOpenSlotW(pW, pRmtHostW, pRmtSlotW);
	} while(0);

	if (pRmtHostW != NULL) AjcTFree(pRmtHostW);
	if (pRmtSlotW != NULL) AjcTFree(pRmtSlotW);

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcScpOpenSlotW		(HAJCSCP pW, C_WCP pRmtHost, C_WCP pRmtSlot)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		//----- 文字コード判定バッファリセット -----------------------------------------------------------------//
		AjcSsepMbcReset(pW->hSsep);
		//----- 送信テキスト半端バイト／ワードリセット ---------------------------------------------------------//
		pW->SvSndA = 0;
		pW->SvSndW = 0;
		//----- 通信リソースオープン中ならば、クローズする -----------------------------------------------------//
		if (pW->hPort != NULL) {
			AjcScpClose(pW);
			pW->fTxSlotOpened = FALSE;
			pW->hPort		  = NULL;
		}
		//----- スロットモード設定 -----------------------------------------------------------------------------//
		pW->PortSel = AJCSCP_SEL_MAILSLOT;

		//----- 自スロット未生成ならば、生成する ---------------------------------------------------------------//
		if (pW->hSlot == NULL && pW->SlotInfo.MySlotName[0] != 0) {
			ScpCreateMySlotAndNtcErr(pW);
		}

		//----- リモートホスト名設定 -----------------------------------------------------------------------//
		if (pRmtHost != NULL) {
			AjcSnPrintF(pW->SlotInfo.RmtHostName, AJCTSIZE(pW->SlotInfo.RmtHostName), L"%s", pRmtHost);
		}
		//----- リモートスロット名設定 ---------------------------------------------------------------------//
		if (pRmtSlot != NULL) {
			AjcSnPrintF(pW->SlotInfo.RmtSlotName, AJCTSIZE(pW->SlotInfo.RmtSlotName), L"%s", pRmtSlot);
		}
		//----- 送信ポートオープン -------------------------------------------------------------------------//
		//	送信ポートが指定されている場合は、実際にオープンする
		if (pW->SlotInfo.RmtSlotName[0] != 0) {
			if ((pW->hPort = ScpOpenFile(pW)) != NULL) {
				pW->fTxSlotOpened = TRUE;
				rc				  = TRUE;
			}
			else {
				pW->fTxSlotOpened = FALSE;
				rc				  = FALSE;
			}
		}
		//	送信ポートが指定されていない場合は、実際にはオープンせずに、オープン操作が行われた旨、フラグ設定
		else {
			pW->fTxSlotOpened = TRUE;	//	オープン操作を行った旨、フラグ設定
			rc = TRUE;					//（リモートスロット名未指定の場合は、実際には送信ポートをオープンしない）
		}
		//----- 送信速度制限情報初期化 ---------------------------------------------------------------------//
		pW->TxDelayBytesCount	= 0;							//	送信遅延用バイトカウンタ
		pW->TxDelayTickCount	= 0;							//	送信遅延用計測時間[us]
		AjcMesTimeInterval(pW->hMesTxDelay);					//	時間計測リセット

		//----- 受信バッファクリアー -----------------------------------------------------------------------//
		pW->ixRxb = pW->ixNpk = 0;
		memset(pW->RxBuf, 0, sizeof pW->RxBuf);
		memset(pW->NpBuf, 0, sizeof pW->NpBuf);

		//----- バイトペア受信カウンタクリアー -------------------------------------------------------------//
		pW->BpSeq = 0;

		//----- 成功ならばオープン通知 ---------------------------------------------------------------------//
		if (rc) {
			ScpNtcPortStateToUser(pW, AJCSCP_OPENED);
		}
		//----- エラーならば、エラー通知 -------------------------------------------------------------------//
		else {
		//	AjcScpClose(pW);
			ScpNtcPortStateToUser(pW, AJCSCP_OPENFAIL);
		}
	}
	return rc;
}
//==============================================================================================================//
//	ポートオープン（ソケット）																					//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pServ		- サーバホスト名	（ダイアログでの設定済名称を使用する場合はNULL)					//
//				PortNo		- ポート番号		（ダイアログでの設定済ポート番号を使用する場合は０)				//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcScpOpenSockA		(HAJCSCP pW, C_BCP pServ, UI PortNo)
{
	BOOL	rc = TRUE;
	UI		len;
	WCP		pServW = NULL;

	if (pServ != NULL) {
		len = AjcByteCharToWideChar(pServ, NULL, 0);
		if (pServW = AjcTAlloc(len)) {
			AjcByteCharToWideChar(pServ, pServW, len);
		}
		else rc = FALSE;
	}

	if (rc) {
		rc = AjcScpOpenSockW(pW, pServW, PortNo);
	}

	if (pServW != NULL) free(pServW);

	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcScpOpenSockW		(HAJCSCP pW, C_WCP pServ, UI PortNo)
{
	BOOL		rc = FALSE;
	ADDRINFO	*pAI = NULL;

	if (IS_MY_INST(pW)) {
		//----- 文字コード判定バッファリセット -----------------------------------------------------------------//
		AjcSsepMbcReset(pW->hSsep);
		//----- 送信テキスト半端バイト／ワードリセット ---------------------------------------------------------//
		pW->SvSndA = 0;
		pW->SvSndW = 0;
		//----- 通信リソースオープン中ならば、クローズする -----------------------------------------------------//
		if (pW->hPort != NULL) {
			AjcScpClose(pW);
			pW->hPort = NULL;
		}
		//----- ソケットモード設定 -----------------------------------------------------------------------------//
		pW->PortSel = AJCSCP_SEL_SOCKET;

		//----- サーバ名，ポート番号設定 -----------------------------------------------------------------------//
		if (pServ  != NULL) {AjcSnPrintF(pW->SockInfo.ServName, AJCTSIZE(pW->SockInfo.ServName), L"%s", pServ);}
		if (PortNo != 0   ) {pW->SockInfo.PortNo = PortNo;}

		//----- ソケットオープン（ソケット接続） ---------------------------------------------------------------//
		if ((pW->hPort = ScpOpenFile(pW)) != NULL) {
			rc = TRUE;
		}
		//----- 受信バッファクリアー ---------------------------------------------------------------------------//
		pW->ixRxb = pW->ixNpk = 0;
		memset(pW->RxBuf, 0, sizeof pW->RxBuf);
		memset(pW->NpBuf, 0, sizeof pW->NpBuf);

		//----- バイトペア受信カウンタクリアー -----------------------------------------------------------------//
		pW->BpSeq = 0;

		//----- エラーならば、ソケットクローズし、エラー通知 ---------------------------------------------------//
		if (!rc) {
		//	AjcScpClose(pW);
			ScpNtcPortStateToUser(pW, AJCSCP_OPENFAIL);
		}
	}
	return rc;
}
//==============================================================================================================//
//	ポートオープン（選択済ポート）																				//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcScpOpenDefault	(HAJCSCP pW)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		switch (pW->PortSel) {
			case AJCSCP_SEL_COMPORT:	rc = AjcScpOpenEx(pW, pW->PortNo, NULL, NULL);	break;
			case AJCSCP_SEL_MAILSLOT:	rc = AjcScpOpenSlot(pW, NULL, NULL);			break;
			case AJCSCP_SEL_SOCKET:		rc = AjcScpOpenSock(pW, NULL, 0   );			break;
		}
	}
	return rc;
}
//==============================================================================================================//
//	ポートオープン（リソース選択）																				//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				sel 		- 最初にオープンするリソース(AJCSCP_SEL_COMPORT / ・・_MAILSLOT / ・・_SOCKET)		//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI		AjcScpOpenSelect (HAJCSCP pW, AJCSCP_PORTSEL sel)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		if (sel == AJCSCP_SEL_COMPORT || sel == AJCSCP_SEL_MAILSLOT || sel == AJCSCP_SEL_SOCKET) {
			//	指定リソースをオープン
			switch (sel) {
				case AJCSCP_SEL_COMPORT:	rc = AjcScpOpenEx(pW, pW->PortNo, NULL, NULL);	break;
				case AJCSCP_SEL_MAILSLOT:	rc = AjcScpOpenSlot(pW, NULL, NULL);			break;
				case AJCSCP_SEL_SOCKET:		rc = AjcScpOpenSock(pW, NULL, 0   );			break;
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	ポートクローズ																								//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcScpClose			(HAJCSCP pW)
{
	BOOL	rc = TRUE;
	UI		Count = 0;

	if (IS_MY_INST(pW)) {
		//	通信ポートクローズ
		switch (pW->PortSel) {
			case AJCSCP_SEL_COMPORT:			//	●ＣＯＭポート
				if (pW->hPort != NULL) {
					ScpPurgeComm(pW, PURGE_TXABORT | PURGE_RXABORT | PURGE_TXCLEAR | PURGE_RXCLEAR);
					rc = ScpCloseFile(pW);
				}
				break;

			case AJCSCP_SEL_MAILSLOT:			//	●メールスロット
				if (pW->fTxSlotOpened) {
					rc = ScpCloseFile(pW);
				}
				break;

			case AJCSCP_SEL_SOCKET:				//	●ソケット
				if (pW->hPort != NULL) {
					rc = ScpCloseFile(pW);
				}
				break;
		}
		//	ポートクローズ通知
		ScpNtcPortStateToUser(pW, AJCSCP_CLOSED);
		//	自メールスロット破棄
		if (pW->PortSel == AJCSCP_SEL_MAILSLOT) {
			//	受信用 自メールスロットクローズ
			if (pW->hSlot != NULL) {						//	自メールスロット生成済？
				if (pW->SlotInfo.RmtHostName[0] != 0) {		//		リモートホスト名有効？
					CloseHandle(pW->hSlot);					//			自メールスロットクローズ
					pW->hSlot = NULL;
				}
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	設定されている通信ポート種別取得																			//
//																												//
//	引　数	：	pW				- インスタンスハンドル															//
//																												//
//	戻り値	：	≠0: 設定されているポート番号（1～256：ＣＯＭポート，256：メールスロット）						//
//				＝0: エラー																						//
//==============================================================================================================//
AJCEXPORT	UI		WINAPI	AjcScpGetSelectedPort(HAJCSCP pW)
{
	UI		rc = 0;

	if (IS_MY_INST(pW)) {
		switch (pW->PortSel) {
			case AJCSCP_SEL_COMPORT:	rc = pW->PortNo;	break;
			case AJCSCP_SEL_MAILSLOT:	rc = 256;			break;
			case AJCSCP_SEL_SOCKET:		rc = 257;			break;
		}
	}
	return rc;
}

//==============================================================================================================//
//	ポートオープン状態取得																						//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//																												//
//	戻り値	：	≠０  - オープン状態（1～255 : ＣＯＭポート番号，256 : メールスロット, 257 : ソケット）			//
//				＝０  - クローズ状態																			//
//==============================================================================================================//
AJCEXPORT	UI			WINAPI	AjcScpIsOpened		(HAJCSCP pW)
{
	UI		rc = 0;

	if (IS_MY_INST(pW)) {
		switch (pW->PortSel) {
			case AJCSCP_SEL_COMPORT:
				if (pW->hPort != NULL) {
					rc = pW->PortNo;
				}
				break;

			case AJCSCP_SEL_MAILSLOT:
				if (pW->fTxSlotOpened) {
					rc = 256;
				}
				break;

			case AJCSCP_SEL_SOCKET:
				if (pW->hPort != NULL && pW->fConnect) {
					rc = 257;
				}
				break;
		}
	}
	return rc;
}
//==============================================================================================================//
//	送信ポートオープン状態取得																					//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//																												//
//	戻り値	：	TRUE  - オープン状態																			//
//				FALSE - クローズ状態																			//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcScpIsTxOpened	(HAJCSCP pW)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		switch (pW->PortSel) {
			case AJCSCP_SEL_COMPORT:
				if (pW->hPort != NULL) {
					rc = TRUE;
				}
				break;

			case AJCSCP_SEL_MAILSLOT:
				if (pW->hPort != NULL) {
					rc = TRUE;
				}
				break;

			case AJCSCP_SEL_SOCKET:
				if (pW->hPort != NULL && pW->fConnect) {
					rc = TRUE;
				}
				break;
		}
	}
	return rc;
}
//==============================================================================================================//
//	受信ポートオープン状態取得																					//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//																												//
//	戻り値	：	TRUE  - オープン状態																			//
//				FALSE - クローズ状態																			//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcScpIsRxOpened	(HAJCSCP pW)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		switch (pW->PortSel) {
			case AJCSCP_SEL_COMPORT:
				if (pW->hPort != NULL) {
					rc = TRUE;
				}
				break;

			case AJCSCP_SEL_MAILSLOT:
				if (pW->hSlot != NULL) {
					rc = TRUE;
				}
				break;

			case AJCSCP_SEL_SOCKET:
				if (pW->hPort != NULL && pW->fConnect) {
					rc = TRUE;
				}
				break;
		}
	}
	return rc;
}
//==============================================================================================================//
//	１文字送信																									//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				code		- 送信する文字の文字コード															//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//																												//
//	備考	：	マルチバイト文字を送信する場合は、この関数を２度コールしてください								//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcScpSendCharA		(HAJCSCP pW, BC code)
{
	BOOL	rc = FALSE;
	BC		txt[4];

	if (IS_MY_INST(pW) && AjcScpIsTxOpened(pW)) {
		//	全角１バイト目退避なし？
		if (pW->SvSndA == 0) {
			if (MAjcIsLeadA(code)) {
				pW->SvSndA = code;
				rc = TRUE;
			}
			else {
				txt[0] = code;
				txt[1] = 0;
				rc = AjcScpSendTextA(pW, txt, 1);
			}
		}
		//	全角１バイト目退避あり？
		else {
			//	２バイト作成し送信
			txt[0] = pW->SvSndA;
			txt[1] = code;
			txt[2] = 0;
			rc = AjcScpSendTextA(pW, txt, 2);
			//	全角１バイト目退避クリアー
			pW->SvSndA = 0;
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcScpSendCharW		(HAJCSCP pW, WC code)
{
	BOOL	rc = FALSE;
	WC		txt[2];

	if (IS_MY_INST(pW) && AjcScpIsTxOpened(pW)) {
		//	サロゲート１ワード目退避なし？
		if (pW->SvSndA == 0) {
			if (MAjcIsLeadW(code)) {
				pW->SvSndW = code;
				rc = TRUE;
			}
			else {
				txt[0] = code;
				txt[1] = 0;
				rc = AjcScpSendTextW(pW, txt, 1);
			}
		}
		//	サロゲート１ワード目退避あり？
		else {
			//	２ワード作成し送信
			txt[0] = pW->SvSndW;
			txt[1] = code;
			txt[2] = 0;
			rc = AjcScpSendTextW(pW, txt, 2);
			//	サロゲート１ワード目退避クリアー
			pW->SvSndW = 0;
		}
	}
	return rc;
}
//==============================================================================================================//
//	１４ビットワードデータ（バイトペア）送信 - Low byte first													//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				data		- 送信する１４ビットデータ															//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI		AjcScpSendWord14LF	(HAJCSCP pW, UI data)
{
	BOOL	rc = FALSE;
	UB		sd[2];

	if (IS_MY_INST(pW) && AjcScpIsTxOpened(pW)) {
		sd[0] = (UB)(0x80 | (data & 0x7F));
		sd[1] = (UB)((data >> 7) & 0x7F);
		rc = AjcVMbxEnque(pW->hVMbxTxD, sd, sizeof sd);
	}
	return rc;
}
//==============================================================================================================//
//	１４ビットワードデータ（バイトペア）送信 - High byte first													//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				code		- 送信する１４ビットデータ															//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI		AjcScpSendWord14HF	(HAJCSCP pW, UI data)
{
	BOOL	rc = FALSE;
	UB		sd[2];

	if (IS_MY_INST(pW) && AjcScpIsTxOpened(pW)) {
		sd[0] = (UB)(0x80 | ((data >> 7) & 0x7F));
		sd[1] = (UB)((data & 0x7F));
		rc = AjcVMbxEnque(pW->hVMbxTxD, sd, sizeof sd);
	}
	return rc;
}
//==============================================================================================================//
//	１４ビットワードデータ（バイトペア）受信時のバイト順設定													//
//																												//
//	引　数	：	pW				- インスタンスハンドル															//
//				fLowByteFirst	- TRUE	: 下位バイト，上位バイトの順で受信										//
//								  FALSE : 上位バイト，下位バイトの順で受信										//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI		AjcScpSetByteSeqRxWord14	(HAJCSCP pW, BOOL fLowByteFirst)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		pW->fBpLBFirst = (fLowByteFirst != 0);
		rc = TRUE;
	}
	return rc;
}

//==============================================================================================================//
//	１４ビットワードデータ（バイトペア）受信時のバイト順取得													//
//																												//
//	引　数	：	pW				- インスタンスハンドル															//
//				fLowByteFirst	- TRUE	: 下位バイト，上位バイトの順で受信										//
//								  FALSE : 上位バイト，下位バイトの順で受信										//
//																												//
//	戻り値	：	TRUE  - 下位バイト，上位バイトの順で受信														//
//				FALSE - 上位バイト，下位バイトの順で受信														//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI		AjcScpGetByteSeqRxWord14	(HAJCSCP pW)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		rc = pW->fBpLBFirst;
	}
	return rc;
}

//==============================================================================================================//
//	テキストデータ送信																							//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pTxt		- 送信するテキストデータのアドレス（シフトＪＩＳ／ＵＮＩＣＯＤＥテキスト）			//
//				lTxt		- 送信するテキストデータの文字数（－１の場合は自動算出）							//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcScpSendTextA		(HAJCSCP pW, C_BCP pTxt, UI lTxt)
{
	BOOL		rc	= FALSE;
	AJCMBCKIND	mbk = AJCMBC_SJIS;
	BCP			pAlt = NULL;

	if (IS_MY_INST(pW) && pTxt != NULL && AjcScpIsTxOpened(pW)) {
		rc = TRUE;
		do {
			//	ソーステキスト長設定
			lTxt = AjcStrAdjustLenA(pTxt, lTxt);
			if (lTxt == 0) break;
			//	前回の半端バイトとテキストを動的バッファに格納
			if (pW->SvSndA != 0) {
				if (pAlt = AjcTAllocA(1 + lTxt + 1)) {
					*pAlt = pW->SvSndA;
					strncpy(pAlt + 1, pTxt, lTxt);
					*(pAlt + (1 + lTxt)) = 0;
					//	テキストポインタ切り替え
					pTxt = pAlt;
					lTxt++;
				}
				else {
					rc = FALSE;
				}
				pW->SvSndA = 0;
			}
			if (!rc) break;
			//	テキストの末尾が全角１バイト目ならば、退避して末尾を除外
			if (mbsbtype(pTxt, lTxt - 1) == _MBC_LEAD) {
				pW->SvSndA = pTxt[lTxt - 1];
				lTxt--;
			}
			if (lTxt == 0) break;
			//	送信テキストコード設定
			switch (pW->TxTxtCode) {
				default:
				case AJCSCP_TXT_SJIS:	mbk = AJCMBC_SJIS;						break;	//	シフトＪＩＳ
				case AJCSCP_TXT_EUC:	mbk = AJCMBC_EUC;						break;	//	ＥＵＣ　　　
				case AJCSCP_TXT_UTF8:	mbk = AJCMBC_UTF8;						break;	//	ＵＴＦ－８　
				case AJCSCP_TXT_AUTO:													//	自動判別
										switch (pW->RxTxtCode) {
											case AJCSCP_TXT_SJIS:	mbk = AJCMBC_SJIS;						break;
											case AJCSCP_TXT_EUC:	mbk = AJCMBC_EUC;						break;
											case AJCSCP_TXT_UTF8:	mbk = AJCMBC_UTF8;						break;
											case AJCSCP_TXT_AUTO:	mbk = AjcSsepGetLastMbcKind(pW->hSsep);	break;
										}
										break;
			}
			//	送信コード＝シフトＪＩＳ
			if (mbk == AJCMBC_SJIS) {
				C_BCP	p = pTxt;
				UI		len;
				//	送信テキストエンキュー
				while (lTxt > 0) {
					switch (pW->PortSel) {
						case AJCSCP_SEL_COMPORT:	len = __min(lTxt, AJCSCPMAX_TXSIZE_COMPORT );	break;
						case AJCSCP_SEL_MAILSLOT:	len = __min(lTxt, AJCSCPMAX_TXSIZE_MAILSLOT);	break;
						case AJCSCP_SEL_SOCKET:		len = __min(lTxt, AJCSCPMAX_TXSIZE_SOCKET  );	break;
					}
					if (!(rc = AjcVMbxEnque(pW->hVMbxTxD, p, len))) break;
					p	 += len;
					lTxt -= len;
				}
			}
			//	送信コード＝ＥＵＣ／ＵＴＦ８
			else {
				BCP			pTop = NULL;
				BCP			pTmp = NULL;
				UI			lTmp = 0;
				UI			len;
				do {
					//	文字コード変換(SJIS -> EUC)
					if (mbk == AJCMBC_EUC) {
						lTmp = AjcSJisToEucEx(pTxt, lTxt, NULL, 0);
						if ((pTop = AJCMEM(lTmp)) == NULL) break;
						AjcSJisToEucEx(pTxt, lTxt, pTop, lTmp);
					}
					//	文字コード変換(SJIS -> UTF-8)
					else {
						lTmp = AjcMbcToUtf8Ex(pTxt, lTxt, NULL, 0);
						if ((pTop = AJCMEM(lTmp)) == NULL) break;
						AjcMbcToUtf8Ex(pTxt, lTxt, pTop, lTmp);
					}
					//	送信テキストエンキュー
					pTmp = pTop;
					while (lTmp > 0) {
						switch (pW->PortSel) {
							case AJCSCP_SEL_COMPORT:	len = __min(lTmp, AJCSCPMAX_TXSIZE_COMPORT );	break;
							case AJCSCP_SEL_MAILSLOT:	len = __min(lTmp, AJCSCPMAX_TXSIZE_MAILSLOT);	break;
							case AJCSCP_SEL_SOCKET:		len = __min(lTmp, AJCSCPMAX_TXSIZE_SOCKET  );	break;
						}
						if (!(rc = AjcVMbxEnque(pW->hVMbxTxD, pTmp, len))) break;
						pTmp += len;
						lTmp -= len;
					}
				} while (0);
				//	変換バッファ解放
				if (pTop != NULL) free(pTop);
			}
		} while(0);
		//	切り替えバッファ解放
		if (pAlt != NULL) free(pAlt);
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcScpSendTextW		(HAJCSCP pW, C_WCP pTxt, UI lTxt)
{
	BOOL		rc	= FALSE;
	AJCMBCKIND	mbk = AJCMBC_SJIS;
	WCP			pAlt = NULL;

	if (IS_MY_INST(pW) && pTxt != NULL && AjcScpIsTxOpened(pW)) {
		rc = TRUE;
		do {
			//	ソーステキスト長設定
			lTxt = AjcStrAdjustLenW(pTxt, lTxt);
			if (lTxt == 0) break;
			//	前回の半端ワードとテキストを動的バッファに格納
			if (pW->SvSndW != 0) {
				if (pAlt = AjcTAllocW(1 + lTxt + 1)) {
					*pAlt = pW->SvSndW;
					wcsncpy(pAlt + 1, pTxt, lTxt);
					*(pAlt + (1 + lTxt)) = 0;
					//	テキストポインタ切り替え
					pTxt = pAlt;
					lTxt++;
				}
				else {
					rc = FALSE;
				}
				pW->SvSndW = 0;
			}
			if (!rc) break;
			//	テキストの末尾がサロゲート１ワード目ならば、退避して末尾を除外
			if (MAjcIsLeadW(pTxt[lTxt - 1])) {
				pW->SvSndW = pTxt[lTxt - 1];
				lTxt--;
			}
			if (lTxt == 0) break;
			//	送信テキストコード設定
			switch (pW->TxTxtCode) {
				default:
				case AJCSCP_TXT_SJIS:	mbk = AJCMBC_SJIS;						break;	//	シフトＪＩＳ
				case AJCSCP_TXT_EUC:	mbk = AJCMBC_EUC;						break;	//	ＥＵＣ
				case AJCSCP_TXT_UTF8:	mbk = AJCMBC_UTF8;						break;	//	ＵＴＦ－８
				case AJCSCP_TXT_AUTO:													//	自動判別
										switch (pW->RxTxtCode) {
											case AJCSCP_TXT_SJIS:	mbk = AJCMBC_SJIS;						break;
											case AJCSCP_TXT_EUC:	mbk = AJCMBC_EUC;						break;
											case AJCSCP_TXT_UTF8:	mbk = AJCMBC_UTF8;						break;
											case AJCSCP_TXT_AUTO:	mbk = AjcSsepGetLastMbcKind(pW->hSsep);	break;
										}
										break;
			}
			//	送信コード＝シフトＪＩＳ
			if (mbk == AJCMBC_SJIS) {
				BCP		pTxd;
				UI		lTxd;
				C_BCP	p;
				UI		len;
				lTxd = WideCharToMultiByte(CP_ACP, 0, pTxt, lTxt, NULL, 0, NULL, NULL);
				if (pTxd = AjcTAllocA(lTxd)) {
					WideCharToMultiByte(CP_ACP, 0, pTxt, lTxt, pTxd, lTxd, NULL, NULL);
					//	送信テキストエンキュー
					p = pTxd;
					while (lTxd > 0) {
						switch (pW->PortSel) {
							case AJCSCP_SEL_COMPORT:	len = __min(lTxd, AJCSCPMAX_TXSIZE_COMPORT );	break;
							case AJCSCP_SEL_MAILSLOT:	len = __min(lTxd, AJCSCPMAX_TXSIZE_MAILSLOT);	break;
							case AJCSCP_SEL_SOCKET:		len = __min(lTxd, AJCSCPMAX_TXSIZE_SOCKET  );	break;
						}
						if (!(rc = AjcVMbxEnque(pW->hVMbxTxD, p, len))) break;
						p	 += len;
						lTxd -= len;
					}
					free(pTxd);
				}
			}
			//	送信コード＝ＥＵＣ／ＵＴＦ８
			else {
				BCP			pTop = NULL;
				BCP			pTmp = NULL;
				UI			lTmp = 0;
				UI			len;
				do {
					//	文字コード変換(UNICODE -> EUC)
					if (mbk == AJCMBC_EUC) {
						BCP		pSJis;
						UI		lSJis;
						lSJis = WideCharToMultiByte(CP_ACP, 0, pTxt, lTxt, NULL, 0, NULL, NULL);
						if ((pSJis = AjcTAllocA(lSJis)) == NULL) break;
						WideCharToMultiByte(CP_ACP, 0, pTxt, lTxt, pSJis, lSJis, NULL, NULL);
						lTmp = AjcSJisToEucEx(pSJis, lSJis, NULL, 0);
						if ((pTop = AjcTAllocA(lTmp)) == NULL) {free(pSJis); break;}
						AjcSJisToEucEx(pSJis, lSJis, pTop, lTmp);
					}
					//	文字コード変換(UNICODE -> UTF-8)
					else {
						lTmp = WideCharToMultiByte(CP_UTF8, 0, pTxt, lTxt, NULL, 0, NULL, NULL);
						if ((pTop = AjcTAllocA(lTmp)) == NULL) break;
						WideCharToMultiByte(CP_UTF8, 0, pTxt, lTxt, pTop, lTmp, NULL, NULL);
					}
					//	送信テキストエンキュー
					pTmp = pTop;
					while (lTmp > 0) {
						switch (pW->PortSel) {
							case AJCSCP_SEL_COMPORT:	len = __min(lTmp, AJCSCPMAX_TXSIZE_COMPORT );	break;
							case AJCSCP_SEL_MAILSLOT:	len = __min(lTmp, AJCSCPMAX_TXSIZE_MAILSLOT);	break;
							case AJCSCP_SEL_SOCKET:		len = __min(lTmp, AJCSCPMAX_TXSIZE_SOCKET  );	break;
						}
						if (!(rc = AjcVMbxEnque(pW->hVMbxTxD, pTmp, len))) break;
						pTmp += len;
						lTmp -= len;
					}
					//	変換バッファ解放
					free(pTop);
				} while (0);
			}
		} while(0);
		//	切り替えバッファ解放
		if (pAlt != NULL) free(pAlt);
	}
	return rc;
}
//==============================================================================================================//
//	書式テキストデータ送信																						//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pFmt		- 書式テキスト																		//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI		AjcScpSendTextFA	(HAJCSCP pW, C_BCP pFmt, ...)
{
	BOOL	rc = FALSE;
	va_list vls;
	BC		txt[2048];

	if (IS_MY_INST(pW) && pFmt != NULL && AjcScpIsTxOpened(pW)) {
		va_start(vls, pFmt);
		_vsnprintf(txt, 2048, pFmt, vls);
		txt[2047] = 0;
		va_end	(vls);
		rc = AjcScpSendTextA(pW, txt, -1);
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI		AjcScpSendTextFW	(HAJCSCP pW, C_WCP pFmt, ...)
{
	BOOL	rc = FALSE;
	va_list vls;
	WC		txt[2048];

	if (IS_MY_INST(pW) && pFmt != NULL && AjcScpIsTxOpened(pW)) {
		va_start(vls, pFmt);
		_vsnwprintf(txt, 2048, pFmt, vls);
		txt[2047] = 0;
		va_end	(vls);
		rc = AjcScpSendTextW(pW, txt, -1);
	}
	return rc;
}
//==============================================================================================================//
//	バイナリデータ送信																							//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pDat		- 送信するバイナリデータのアドレス													//
//				lDat		- 送信するバイナリデータのバイト数													//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcScpSendBinData	(HAJCSCP pW, C_VOP pDat, UI lDat)
{
	BOOL	rc = FALSE;
	C_UBP	p = (C_UBP)pDat;
	UI		len;

	if (IS_MY_INST(pW) && pDat != NULL && AjcScpIsTxOpened(pW)) {
		while (lDat > 0) {
			switch (pW->PortSel) {
				case AJCSCP_SEL_COMPORT:	len = __min(lDat, AJCSCPMAX_TXSIZE_COMPORT );	break;
				case AJCSCP_SEL_MAILSLOT:	len = __min(lDat, AJCSCPMAX_TXSIZE_MAILSLOT);	break;
				case AJCSCP_SEL_SOCKET:		len = __min(lDat, AJCSCPMAX_TXSIZE_SOCKET  );	break;
			}

			if (!(rc = AjcVMbxEnque(pW->hVMbxTxD, p, len))) break;

			p	 += len;
			lDat -= len;
		}
	}
	return rc;
}
//==============================================================================================================//
//	パケットデータ送信																							//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pPkt		- 送信するパケットデータのアドレス（空パケット送信時はNUULでもOK)					//
//				lPkt		- 送信するパケットデータのバイト数（空パケット送信時は０)							//
//																												//
//	戻り値	：	４以上	- OK（実際の送信バイト数）																//
//				０		- Error																					//
//==============================================================================================================//
AJCEXPORT	UI		WINAPI	AjcScpSendPacket	(HAJCSCP pW, C_VOP pPkt, UI lPkt)
{
	UI			rc = 0;
	UBP			pImg;
	UI			lImg, len;
	UBP			p;

	if (IS_MY_INST(pW) && (pPkt != NULL || lPkt == 0) && AjcScpIsTxOpened(pW)) {
		if (pImg = (UBP)AjcSsepMakePacket(pW->hSsep, pPkt, lPkt, &lImg)) {
			rc = lImg;
			p = pImg;
			while (lImg > 0) {
				switch (pW->PortSel) {
					case AJCSCP_SEL_COMPORT:	len = __min(lImg, AJCSCPMAX_TXSIZE_COMPORT );	break;
					case AJCSCP_SEL_MAILSLOT:	len = __min(lImg, AJCSCPMAX_TXSIZE_MAILSLOT);	break;
					case AJCSCP_SEL_SOCKET:		len = __min(lImg, AJCSCPMAX_TXSIZE_SOCKET  );	break;
				}
				if (!AjcVMbxEnque(pW->hVMbxTxD, p, len)) {rc = 0; break;}
				p	 += len;
				lImg -= len;
			}
			AjcSsepRelease(pImg);
		}
	}
	return rc;
}
//==============================================================================================================//
//	ブレーク信号送出／停止																						//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				fBreak		- TRUE - 送出，FALSE - 停止															//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcScpSendBreak		(HAJCSCP pW, BOOL fBreak)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		if (pW->PortSel == AJCSCP_SEL_COMPORT) {
			if (fBreak) rc = ScpSetCommBreak(pW);
			else		rc = ScpClearCommBreak(pW);
		}
	}
	return rc;
}
//==============================================================================================================//
//	イベントマスク設定																							//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				Mask		- イベントマスク																	//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcScpSetEvtMask	(HAJCSCP pW, UI Mask)
{
	UI		evt;

	if (IS_MY_INST(pW)) {
		pW->EvtMask = Mask;
		//----- ストリーム分離イベント設定 -------------------//
		evt = ScpEvtToSsepEvt(pW->EvtMask);
		AjcSsepSetEvent(pW->hSsep, evt);
	}
	return TRUE;
}
//==============================================================================================================//
//	イベントマスク取得																							//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//																												//
//	戻り値	：	イベントマスク																					//
//==============================================================================================================//
AJCEXPORT	UI			WINAPI	AjcScpGetEvtMask	(HAJCSCP pW)
{
	UI		rc =  0;

	if (IS_MY_INST(pW)) {
		rc = pW->EvtMask;
	}
	return rc;
}

//==============================================================================================================//
//	ＤＴＲ信号設定																								//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				fActive		- TRUE - DTR ON, FALSE - DTR OFF													//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcScpSetDTR		(HAJCSCP pW, BOOL fActive)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		if (pW->PortSel == AJCSCP_SEL_COMPORT) {
			if (fActive) rc = ScpEscapeCommFunction(pW, SETDTR);
			else		 rc = ScpEscapeCommFunction(pW, CLRDTR);
		}
	}
	return rc;
}
//==============================================================================================================//
//	ＲＴＳ信号設定																								//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				fActive		- TRUE - DTR ON, FALSE - DTR OFF													//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcScpSetRTS		(HAJCSCP pW, BOOL fActive)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		if (pW->PortSel == AJCSCP_SEL_COMPORT) {
			if (fActive) rc = ScpEscapeCommFunction(pW, SETRTS);
			else		 rc = ScpEscapeCommFunction(pW, CLRRTS);
		}
	}
	return rc;
}
//==============================================================================================================//
//	信号状態取得																								//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//																												//
//	戻り値	：	信号状態																						//
//==============================================================================================================//
AJCEXPORT	UI			WINAPI	AjcScpGetSigState	(HAJCSCP pW)
{
	UI		rc = 0;
	DWORD	mst;

	if (IS_MY_INST(pW)) {
		if (pW->PortSel == AJCSCP_SEL_COMPORT) {
			if (ScpGetCommModemStatus(pW, &mst)) {
				if (mst & MS_CTS_ON ) rc |= AJCSCP_CTS;
				if (mst & MS_DSR_ON ) rc |= AJCSCP_DSR;
				if (mst & MS_RING_ON) rc |= AJCSCP_RING;
				if (mst & MS_RLSD_ON) rc |= AJCSCP_RLSD;
			}
			else rc = 0;
		}
	}
	return rc;
}
//==============================================================================================================//
//	送信待ちデータバイト数取得																					//
//																												//
//	引　数	：	pW				- インスタンスハンドル															//
//																												//
//	戻り値	：	送信待ちデータバイト数																			//
//==============================================================================================================//
AJCEXPORT	ULL		WINAPI	AjcScpGetTxBytes		(HAJCSCP pW)
{
	ULL		rc = 0;

	if (IS_MY_INST(pW)) {
		rc = AjcVMbxGetTotalBytes(pW->hVMbxTxD);
	}
	return rc;
}

//==============================================================================================================//
//	全受信済データ破棄																							//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcScpPurgeRecvData	(HAJCSCP pW)
{
	BOOL	rc = TRUE;

	if (IS_MY_INST(pW)) {
		if (pW->PortSel == AJCSCP_SEL_COMPORT) {
			rc = ScpPurgeComm(pW, PURGE_RXABORT | PURGE_RXCLEAR);
		}
		AjcFMbxPurge(pW->hFMbxNtc);
		pW->BpSeq = 0;
	}
	else rc = FALSE;

	return rc;
}
//==============================================================================================================//
//	全送信待ちデータ破棄																						//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcScpPurgeSendData	(HAJCSCP pW)
{
	BOOL	rc = TRUE;

	if (IS_MY_INST(pW)) {
		if (pW->PortSel == AJCSCP_SEL_COMPORT) {
			rc = ScpPurgeComm(pW, PURGE_TXABORT | PURGE_TXCLEAR);
		}
		AjcVMbxPurge(pW->hVMbxTxD);
	}
	else rc = FALSE;

	return rc;
}
//==============================================================================================================//
//	全送受信データ破棄																							//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcScpPurgeAllData	(HAJCSCP pW)
{
	BOOL	rc = TRUE;

	if (IS_MY_INST(pW)) {
		if (pW->PortSel == AJCSCP_SEL_COMPORT) {
			rc = ScpPurgeComm(pW, PURGE_TXABORT | PURGE_RXABORT | PURGE_TXCLEAR | PURGE_RXCLEAR);
		}
		AjcVMbxPurge(pW->hVMbxTxD);
		AjcFMbxPurge(pW->hFMbxNtc);
		pW->BpSeq = 0;
	}
	else rc = FALSE;

	return rc;
}

//==============================================================================================================//
//	ＤＣＢ情報とタイムアウト情報設定																			//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pDcb		- 設定するＤＣＢ情報のアドレス														//
//				pTmo		- 設定するタイムアウト情報のアドレス												//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcScpSetParam(HAJCSCP pW, const DCB *pDcb, const COMMTIMEOUTS *pTmo)
{
	BOOL	rc = TRUE;

	if (IS_MY_INST(pW)) {
		if (pDcb != NULL) {
			memcpy(&pW->CommDcb, pDcb, sizeof(DCB));
			rc &= ScpSetCommState	(pW, &pW->CommDcb);
		}
		if (pTmo != NULL) {
			memcpy(&pW->CommTmo, pTmo, sizeof(COMMTIMEOUTS));
			rc &= ScpSetCommTimeouts(pW, &pW->CommTmo);
		}
	}
	else rc = FALSE;

	return rc;
}
//==============================================================================================================//
//	ＤＣＢ情報とタイムアウト情報取得																			//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pDcb		- 取得したＤＣＢ情報を格納するバッファのアドレス		（不要時はＮＵＬＬ）		//
//				pTmo		- 取得したタイムアウト情報を格納するバッファのアドレス	（不要時はＮＵＬＬ）		//
//																												//
//	戻り値	：	ポート番号																						//
//==============================================================================================================//
AJCEXPORT	UI			WINAPI	AjcScpGetParam(HAJCSCP pW, LPDCB pDcb, LPCOMMTIMEOUTS pTmo)
{
	UI		rc = 0;

	if (IS_MY_INST(pW)) {
		if (pDcb != NULL) memcpy(pDcb, &pW->CommDcb, sizeof(DCB));
		if (pTmo != NULL) memcpy(pTmo, &pW->CommTmo, sizeof(COMMTIMEOUTS));
		switch (pW->PortSel) {
			case AJCSCP_SEL_COMPORT:	pW->PortNo;	break;
			case AJCSCP_SEL_MAILSLOT:	rc = 256;	break;
			case AJCSCP_SEL_SOCKET:		rc = 257;	break;
		}
	}
	return rc;
}

//==============================================================================================================//
//	イベント発生待ち																							//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pwParam		- イベントコードを格納するバッファのアドレス										//
//				plParam		- イベントデータ情報を格納するバッファのアドレス									//
//				msTime		- イベント発生待ち時間[ms]															//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - タイムアウト																			//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcScpWaitEvent		(HAJCSCP pW, WPARAM *pwParam, LPARAM *plParam, UI msTime)
{
	BOOL		rc = FALSE;
	PSCP_EVTINF		pEvtInf;

	if (IS_MY_INST(pW) && pwParam != NULL && plParam != NULL) {
		if (AjcFMbxDeque(pW->hFMbxNtc, &pEvtInf, msTime)) {
			if (pEvtInf != NULL) {
				*pwParam = pEvtInf->Evt;
				*plParam = (LPARAM)pEvtInf;
				rc = TRUE;
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	イベントデータ取得																							//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				lParam		- イベントデータ情報																//
//				ppDat		- 受信データのアドレスを格納するバッファのアドレス									//
//				plDat		- 受信データのバイト数を格納するバッファのアドレス									//
//				pParam		- パラメタ情報を格納するバッファのアドレス											//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - イベントデータなし																		//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcScpGetEventData	(HAJCSCP pW, LPARAM lParam, VOP *ppDat, UIP plDat, UIP pParam)
{
	BOOL		rc = FALSE;
	PSCP_EVTINF		pEvtInf;

	if (IS_MY_INST(pW) && lParam != 0) {
		pEvtInf = (PSCP_EVTINF)lParam;
		if (ppDat  != NULL) *ppDat	= pEvtInf->pDat;
		if (plDat  != NULL) *plDat	= pEvtInf->lDat;
		if (pParam != NULL) *pParam = pEvtInf->param;
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	イベントデータ開放																							//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				lParam		- イベントデータ情報																//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcScpRelEventData	(HAJCSCP pW, LPARAM lParam)
{
	BOOL		rc = FALSE;
	PSCP_EVTINF		pEvtInf;

	if (IS_MY_INST(pW) && lParam != 0) {
		pEvtInf = (PSCP_EVTINF)lParam;
		//	イベント情報解放（イベントデータ(pDat)は AjcMain::AjcReleaseInstance() -> AjcSerialComPortSubFunc::cbReleaseEvtInf()経由で解放）
		AjcReleaseInstance(pEvtInf);
		rc = TRUE;
	}
	return rc;
}

//==============================================================================================================//
//	パケットフレームを認識する為の制御コード設定																//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				stx			- ＳＴＸコード値																	//
//				etx			- ＥＴＸコード値																	//
//				dle			- ＤＬＥコード値																	//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcScpSetPktCtrlCode(HAJCSCP pW, UI stx, UI etx, UI dle)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		if (stx != 0) AjcSsepSetStx(pW->hSsep, stx);
		if (etx != 0) AjcSsepSetEtx(pW->hSsep, etx);
		if (dle != 0) AjcSsepSetDle(pW->hSsep, dle);
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	パケットフレームを認識する為の制御コード取得																//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pStx		- ＳＴＸコード値を格納するバッファのアドレス（不要時はＮＵＬＬ）					//
//				pEtx		- ＥＴＸコード値を格納するバッファのアドレス（不要時はＮＵＬＬ）					//
//				pDle		- ＤＬＥコード値を格納するバッファのアドレス（不要時はＮＵＬＬ）					//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcScpGetPktCtrlCode(HAJCSCP pW, UIP pStx, UIP pEtx, UIP pDle)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		if (pStx != NULL) *pStx= AjcSsepGetStx(pW->hSsep);
		if (pEtx != NULL) *pEtx= AjcSsepGetEtx(pW->hSsep);
		if (pDle != NULL) *pDle= AjcSsepGetDle(pW->hSsep);
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	パケットフレーム受信タイムアウト値設定																		//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				msTime		- タイムアウト時間[ms]																//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcScpSetPktTimeout (HAJCSCP pW, UI msTime)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		AjcSsepSetPktTimeOut(pW->hSsep, msTime);
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	パケットフレーム受信タイムアウト値取得																		//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pMsTime		- タイムアウト時間[ms]を格納するバッファのアドレス（不要時はＮＵＬＬ）				//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcScpGetPktTimeout (HAJCSCP pW, UIP pMsTime)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		if (pMsTime != NULL) {
			*pMsTime = AjcSsepGetPktTimeOut(pW->hSsep);
		}
		rc = TRUE;
	}
	return rc;
}

//==============================================================================================================//
//	通信パラメタ設定ダイアログによるＣＯＭポートの選択許可／禁止												//
//																												//
//	引　数	：	pW				- インスタンスハンドル															//
//				fEnableComPort	- TRUE	: 通信パラメタ設定ダイアログによるＣＯＭポートの選択許可				//
//								  FALSE : 　　〃　　　　　　　　　　　〃　　　　　　　　選択禁止				//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
static VO	SubSetPortSel(HAJCSCP pW)
{
	if ((pW->mskRbt & AJCSCPRBT_ComPort ) && pW->PortSel == AJCSCP_SEL_COMPORT ) pW->PortSel = AJCSCP_SEL_MAILSLOT;
	if ((pW->mskRbt & AJCSCPRBT_MailSlot) && pW->PortSel == AJCSCP_SEL_MAILSLOT) pW->PortSel = AJCSCP_SEL_SOCKET;
	if ((pW->mskRbt & AJCSCPRBT_Socket	) && pW->PortSel == AJCSCP_SEL_SOCKET  ) pW->PortSel = AJCSCP_SEL_COMPORT;
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcScpEnableComPortSelection	(HAJCSCP pW, BOOL fEnableComPort)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		if (fEnableComPort) pW->mskRbt &= ~AJCSCPRBT_ComPort;
		else				pW->mskRbt |=  AJCSCPRBT_ComPort;
		SubSetPortSel(pW);
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	通信パラメタ設定ダイアログによるメールスロットの選択許可／禁止												//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				fEnable		- TRUE	: 通信パラメタ設定ダイアログによるメールスロットの選択許可					//
//							  FALSE : 　　〃　　　　　　　　　　　〃　　　　　　　　　選択禁止					//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcScpEnableMailslotSelection	(HAJCSCP pW, BOOL fEnableMailSlot)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		if (fEnableMailSlot) pW->mskRbt &= ~AJCSCPRBT_MailSlot;
		else				 pW->mskRbt |=	AJCSCPRBT_MailSlot;
		SubSetPortSel(pW);
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	通信パラメタ設定ダイアログによるソケット通信の選択許可／禁止												//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				fEnable		- TRUE	: 通信パラメタ設定ダイアログによるソケット通信の選択許可					//
//							  FALSE : 　　〃　　　　　　　　　　　〃　　　　　　　　選択禁止					//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcScpEnableSocketSelection	(HAJCSCP pW, BOOL fEnableSocket)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		if (fEnableSocket) pW->mskRbt &= ~AJCSCPRBT_Socket;
		else			   pW->mskRbt |=  AJCSCPRBT_Socket;
		SubSetPortSel(pW);
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	通信パラメタ設定ダイアログによるＣＯＭポート，メールスロットの選択許可／禁止								//
//																												//
//	引　数	：	pW				- インスタンスハンドル															//
//				fEnableComPort	- TRUE	: 通信パラメタ設定ダイアログによるＣＯＭポートの　選択許可				//
//							  	  FALSE : 　　〃　　　　　　　　　　　〃　　　　　　　　　選択禁止				//
//				fEnableMailSlot	- TRUE	: 通信パラメタ設定ダイアログによるメールスロットの選択許可				//
//							  	  FALSE : 　　〃　　　　　　　　　　　〃　　　　　　　　　選択禁止				//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcScpEnablePortSelection	(HAJCSCP pW, BOOL fEnableComPort, BOOL fEnableMailSlot)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		AjcScpEnableComPortSelection (pW, fEnableComPort );
		AjcScpEnableMailslotSelection(pW, fEnableMailSlot);
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	通信パラメタ設定ダイアログによるＣＯＭポート，メールスロット，ソケット通信の選択許可／禁止					//
//																												//
//	引　数	：	pW				- インスタンスハンドル															//
//				fEnableComPort	- TRUE	: 通信パラメタ設定ダイアログによるＣＯＭポートの　選択許可				//
//							  	  FALSE : 　　〃　　　　　　　　　　　〃　　　　　　　　　選択禁止				//
//				fEnableMailSlot	- TRUE	: 通信パラメタ設定ダイアログによるメールスロットの選択許可				//
//							  	  FALSE : 　　〃　　　　　　　　　　　〃　　　　　　　　　選択禁止				//
//				fEnableSocket	- TRUE	: 通信パラメタ設定ダイアログによるソケット通信　の選択許可				//
//							  	  FALSE : 　　〃　　　　　　　　　　　〃　　　　　　　　　選択禁止				//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcScpEnablePortSelectionEx	(HAJCSCP pW, BOOL fEnableComPort, BOOL fEnableMailSlot, BOOL fEnableSocket)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		AjcScpEnableComPortSelection (pW, fEnableComPort );
		AjcScpEnableMailslotSelection(pW, fEnableMailSlot);
		AjcScpEnableSocketSelection  (pW, fEnableSocket  );
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	ダイアログによる通信パラメタ設定																			//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				hWndOwner	- オーナーウインドのハンドル														//
//				x, y		- ダイアログ表示位置（スクリーン座標）												//
//																												//
//	戻り値	：	以下のビットの組み合わせ																		//
//					AJCSCPDGR_PORTCHANGED	- ポート変更														//
//					AJCSCPDGR_DCBCHANGED	- ＤＣＢ変更														//
//					AJCSCPDGR_TMOCHANGED	- タイマ変更														//
//					AJCSCPDGR_SELCHANGED	- ＣＯＭポート／メールスロットの選択変更							//
//					AJCSCPDGR_SLOTCHANGED	- メールスロット情報変更											//
//					AJCSCPDGR_OKBUTTON		- ＯＫボタンによる終了												//
//==============================================================================================================//
AJCEXPORT	UI		WINAPI	AjcScpDlgParamEasy	(HAJCSCP pW, HWND hWndOwner)
{
	UI	rc = 0;

	if (IS_MY_INST(pW)) {
		if (!(pW->mskRbt & AJCSCPRBT_ComPort) || !(pW->mskRbt & AJCSCPRBT_MailSlot) || !(pW->mskRbt & AJCSCPRBT_Socket)) {
			rc = SubDlgParamEasy(pW, hWndOwner, NULL);
		}
	}
	return rc;
}
//----- 表示位置指定 -------------------------------------------------------------------------------------------//
AJCEXPORT	UI		WINAPI	AjcScpDlgParamEasyEx(HAJCSCP pW, HWND hWndOwner, int x, int y)
{
	UI		rc = 0;
	POINT	pt;

	if (IS_MY_INST(pW)) {
		if (!(pW->mskRbt & AJCSCPRBT_ComPort) || !(pW->mskRbt & AJCSCPRBT_MailSlot) || !(pW->mskRbt & AJCSCPRBT_Socket)) {
			pt.x = x;
			pt.y = y;
			rc = SubDlgParamEasy(pW, hWndOwner, &pt);
		}
	}
	return rc;
}
//==============================================================================================================//
//	ダイアログによるＣＯＭポート通信パラメタ詳細設定															//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				hWndOwner	- オーナーウインドのハンドル														//
//				x, y		- ダイアログ表示位置（スクリーン座標）												//
//																												//
//	戻り値	：	以下のビットの組み合わせ																		//
//					AJCSCPDGR_PORTCHANGED	- ポート変更														//
//					AJCSCPDGR_DCBCHANGED	- ＤＣＢ変更														//
//					AJCSCPDGR_TMOCHANGED	- タイマ変更														//
//					AJCSCPDGR_OKBUTTON		- ＯＫボタンによる終了												//
//==============================================================================================================//
AJCEXPORT	UI		WINAPI	AjcScpDlgParamDetail(HAJCSCP pW, HWND hWndOwner)
{
	UI	rc = 0;

	if (IS_MY_INST(pW)) {
		rc = SubDlgParamDetail(pW, hWndOwner, NULL);
	}
	return rc;
}
//----- 表示位置指定 -------------------------------------------------------------------------------------------//
AJCEXPORT	UI		WINAPI	AjcScpDlgParamDetailEx(HAJCSCP pW, HWND hWndOwner, int x, int y)
{
	UI		rc = 0;
	POINT	pt;

	if (IS_MY_INST(pW)) {
		pt.x = x;
		pt.y = y;
		rc = SubDlgParamDetail(pW, hWndOwner, &pt);
	}
	return rc;
}
//==============================================================================================================//
//	ダイアログのグレー化項目設定																				//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				mskGray		- グレー化項目マスク																//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcScpSetDialogGrayMask(HAJCSCP pW, UI mskGray)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		pW->mskGray = mskGray;
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	デフォルトパラメタ（ＤＣＢとタイムアウト情報）取得															//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pDcb		- デフォルトＤＣＢ値を格納するバッファのアドレス									//
//				pTmo		- デフォルトタイムアウト情報を格納するバッファのアドレス							//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
AJCEXPORT	VO			WINAPI	AjcScpGetDefaultParam(LPDCB pDcb, LPCOMMTIMEOUTS pTmo)
{
	if (pDcb != NULL) {
		pDcb->DCBlength			= sizeof(DCB);
		pDcb->BaudRate			= 9600;
		pDcb->fBinary			= 1;
		pDcb->fParity			= 0;
		pDcb->fOutxCtsFlow		= 0;
		pDcb->fOutxDsrFlow		= 0;
		pDcb->fDtrControl		= 0;
		pDcb->fDsrSensitivity	= 0;
		pDcb->fTXContinueOnXoff = 0;
		pDcb->fOutX				= 0;
		pDcb->fInX				= 0;
		pDcb->fErrorChar		= 0;
		pDcb->fNull				= 0;
		pDcb->fRtsControl		= 0;
		pDcb->fAbortOnError		= 0;
		pDcb->XonLim			= 512;
		pDcb->XoffLim			= 1536;
		pDcb->ByteSize			= 8;
		pDcb->Parity			= 0;
		pDcb->StopBits			= 0;
		pDcb->XonChar			= 0x11;
		pDcb->XoffChar			= 0x13;
		pDcb->ErrorChar			= '?';
		pDcb->EofChar			= 0x1A;
		pDcb->EvtChar			= 0x03;
	}
	if (pTmo != NULL) {
		pTmo->ReadIntervalTimeout			= 0;
		pTmo->ReadTotalTimeoutMultiplier	= 0;
		pTmo->ReadTotalTimeoutConstant		= 30;
		pTmo->WriteTotalTimeoutMultiplier	= 0;
		pTmo->WriteTotalTimeoutConstant		= 0;
	}
}
//==============================================================================================================//
//	Function	:	ＳＳＥＰハンドル取得																		//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//																												//
//	Return		:	ＳＳＥＰハンドル																			//
//==============================================================================================================//
AJCEXPORT	HAJCSSEP	WINAPI	AjcScpGetSsepHandle(HAJCSCP pW)
{
	HAJCSSEP	rc = NULL;

	if (IS_MY_INST(pW)) {
		rc = pW->hSsep;
	}
	return rc;
}
//==============================================================================================================//
//	Function	:	ＣＯＭポートの列挙																			//
//																												//
//	Argument	:	pMap		- 列挙結果を格納するバッファのアドレス											//
//					lMap		- 列挙結果を格納するバッファのバイト数（最大列挙数）							//
//					CurrentPort - 無条件に列挙するポート番号（０の場合は無効）									//
//																												//
//	Return		:	列挙したシリアルポートの個数																//
//==============================================================================================================//
AJCEXPORT	UI		WINAPI	AjcScpEnumSerialPorts(UBP pMap, UI lMap, UI CurrentPort)
{
	UI		rc = 0;
	HANDLE	hFile;
	HKEY	hKey;
	UI		ix, pno;
	UL		type, valsize, namesize, dmy;
	BCP		p;
	BC		name[256];
	BC		val [256];
	UB		map [256];

	if (pMap != NULL) {
		//----- 検索マップァクリアー -------------------------------------------------------------------------------//
		memset(map, FALSE, sizeof map);
		//----- 無条件に列挙するポート番号設定 ---------------------------------------------------------------------//
		pno = (CurrentPort & 255);
		if (pno != 0) {
			map[pno] = TRUE;
		}
		//----- レジストリから列挙 ---------------------------------------------------------------------------------//
		if (RegCreateKeyExA(HKEY_LOCAL_MACHINE,					//		キー生成，成功？
							"HARDWARE\\DEVICEMAP\\SERIALCOMM",	//		・	（サブキー）
							0,									//		・	（常に０）
							NULL,								//		・	（キークラス名，既存サブキーの場合は不要）
							REG_OPTION_VOLATILE,				//		・	（VOLATILE指定）
							KEY_READ,							//		・	（キーアクセスオプション）
							NULL,								//		・	（キーのセキュリティ属性）
							&hKey,								//		・	（ハンドルを格納するバッファのアドレス）
							&dmy) == ERROR_SUCCESS) {			//		・	（処理コードを格納するバッファのポインタ）

			ix=0;
			valsize = sizeof val; namesize = sizeof name;
			while (RegEnumValueA(hKey, ix, name, &namesize, NULL, &type, (UBP)val, &valsize) == ERROR_SUCCESS) {
				if (type == REG_SZ) {
					if ((p = mbsistr(val, "COM")) != NULL) {
						pno = atoi(p + 3);
						if (pno >= 1 && pno <= 255) {
							map[pno] = TRUE;
						}
					}
				}
				ix++;
				valsize = sizeof val; namesize = sizeof name;
			}
			RegCloseKey(hKey);
		}
		//----- ポートオープンによる追加列挙 -----------------------------------------------------------------------//
		for (pno=1,ix=0; pno<=255; pno++) {
			if (!map[pno]) {
				sprintf(name, "\\\\.\\COM%u", pno);
				if ((hFile = CreateFileA(name,
							GENERIC_WRITE | GENERIC_READ, 0, NULL, OPEN_EXISTING, 0, NULL)) != INVALID_HANDLE_VALUE) {
					CloseHandle(hFile);
					map[pno] = TRUE;
				}
			}
		}
		//----- 列挙結果設定 ---------------------------------------------------------------------------------------//
		for (pno = 1, ix = 0; pno <= 255 && ix < lMap; pno++) {
			if (map[pno]) {
				pMap[ix++] = (UB)pno;
				rc++;
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	Function	:	ポートパス名称取得																			//
//																												//
//	引　数		：	pW			- インスタンスハンドル															//
//																												//
//	Return		:	ポートパス名文字列へのポインタ																//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BCP		WINAPI	AjcScpGetPortPathNameA(HAJCSCP pW)
{
	BCP		rc = NULL;

	if (IS_MY_INST(pW)) {
		switch (pW->PortSel) {
			case AJCSCP_SEL_COMPORT:		//	●ＣＯＭポート
				if (pW->PortNo <= 9) AjcSnPrintFA(pW->PortName.BStr, AJCTSIZE(pW->PortName.BStr), "COM%u"		, pW->PortNo);
				else				 AjcSnPrintFA(pW->PortName.BStr, AJCTSIZE(pW->PortName.BStr), "\\\\.\\COM%u", pW->PortNo);
				break;

			case AJCSCP_SEL_MAILSLOT:		//	●メールスロット
				if (pW->SlotInfo.RmtHostName[0] == 0 || AjcStrSameAsAllChar(pW->SlotInfo.RmtHostName, ' ')) {
					AjcSnPrintFA(pW->PortName.BStr, AJCTSIZE(pW->PortName.BStr), "\\\\.\\mailslot\\%S", pW->SlotInfo.RmtSlotName);
				}
				else {
					AjcSnPrintFA(pW->PortName.BStr, AJCTSIZE(pW->PortName.BStr), "\\\\%S\\mailslot\\%S", pW->SlotInfo.RmtHostName,
																								 		 pW->SlotInfo.RmtSlotName);
				}
				break;

			case AJCSCP_SEL_SOCKET:			//	●ソケット
				AjcSnPrintFA(pW->PortName.BStr, AJCTSIZE(pW->PortName.BStr), "%S:%u", pW->SockInfo.ServName, pW->SockInfo.PortNo);
				break;
		}
		rc = pW->PortName.BStr;
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	WCP		WINAPI	AjcScpGetPortPathNameW(HAJCSCP pW)
{
	WCP		rc = NULL;

	if (IS_MY_INST(pW)) {
		switch (pW->PortSel) {
			case AJCSCP_SEL_COMPORT:		//	●ＣＯＭポート
				if (pW->PortNo <= 9) AjcSnPrintFW(pW->PortName.WStr, AJCTSIZE(pW->PortName.WStr), L"COM%u"		  , pW->PortNo);
				else				 AjcSnPrintFW(pW->PortName.WStr, AJCTSIZE(pW->PortName.WStr), L"\\\\.\\COM%u", pW->PortNo);
				break;

			case AJCSCP_SEL_MAILSLOT:		//	●メールスロット
				if (pW->SlotInfo.RmtHostName[0] == 0 || AjcStrSameAsAllChar(pW->SlotInfo.RmtHostName, ' ')) {
					AjcSnPrintFW(pW->PortName.WStr,  AJCTSIZE(pW->PortName.WStr), L"\\\\.\\mailslot\\%s", pW->SlotInfo.RmtSlotName);
				}
				else {
					AjcSnPrintFW(pW->PortName.WStr, AJCTSIZE(pW->PortName.WStr), L"\\\\%s\\mailslot\\%s", pW->SlotInfo.RmtHostName,
																								 	   pW->SlotInfo.RmtSlotName);
				}
				break;

			case AJCSCP_SEL_SOCKET:			//	●ソケット
				AjcSnPrintFW(pW->PortName.WStr, AJCTSIZE(pW->PortName.WStr), L"%s:%u", pW->SockInfo.ServName, pW->SockInfo.PortNo);
				break;
		}
		rc = pW->PortName.WStr;
	}
	return rc;
}

//==============================================================================================================//
//	Function	:	ポート名称取得																				//
//																												//
//	引　数		：	pW			- インスタンスハンドル															//
//																												//
//	Return		:	ポート名文字列へのポインタ																	//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BCP		WINAPI	AjcScpGetPortNameA(HAJCSCP pW)
{
	BCP		rc = NULL;

	if (IS_MY_INST(pW)) {
		pW->PortName.BStr[0] = 0;
		switch (pW->PortSel) {
			case AJCSCP_SEL_COMPORT:		//	●ＣＯＭポート
				AjcSnPrintFA(pW->PortName.BStr, AJCTSIZE(pW->PortName.BStr), "COM%u", pW->PortNo);
				break;

			case AJCSCP_SEL_MAILSLOT:		//	●メールスロット
				AjcSnPrintFA(pW->PortName.BStr, AJCTSIZE(pW->PortName.BStr), "mailslot\\%S", pW->SlotInfo.RmtSlotName);
				break;

			case AJCSCP_SEL_SOCKET:			//	●ソケット
				AjcSnPrintFA(pW->PortName.BStr, AJCTSIZE(pW->PortName.BStr), "%S:%u", pW->SockInfo.ServName, pW->SockInfo.PortNo);
				break;
		}
		rc = pW->PortName.BStr;
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	WCP		WINAPI	AjcScpGetPortNameW(HAJCSCP pW)
{
	WCP		rc = NULL;

	if (IS_MY_INST(pW)) {
		pW->PortName.WStr[0] = 0;
		switch (pW->PortSel) {
			case AJCSCP_SEL_COMPORT:		//	●ＣＯＭポート
				AjcSnPrintFW(pW->PortName.WStr, AJCTSIZE(pW->PortName.WStr), L"COM%u", pW->PortNo);
				break;

			case AJCSCP_SEL_MAILSLOT:		//	●メールスロット
				AjcSnPrintFW(pW->PortName.WStr, AJCTSIZE(pW->PortName.WStr), L"mailslot\\%s"	, pW->SlotInfo.RmtSlotName);
				break;

			case AJCSCP_SEL_SOCKET:			//	●ソケット
				AjcSnPrintFW(pW->PortName.WStr, AJCTSIZE(pW->PortName.WStr), L"%s:%u", pW->SockInfo.ServName, pW->SockInfo.PortNo);
				break;
		}
		rc = pW->PortName.WStr;
	}
	return rc;
}
//==============================================================================================================//
//	Function	:	ポートのデバイス名称取得																	//
//																												//
//	引　数		：	pPortName	- ＣＯＭポート名("COM1" ～ "COM255")											//
//					pBuf		- デバイス名を格納するバッファのアドレス										//
//					lBuf		- デバイス名を格納するバッファの文字数											//
//																												//
//	Return		:	pBuf != NULL && lBuf != 0 : 格納したデバイス名の文字数										//
//					pBuf == NULL || lBuf == 0 : デバイス名を格納するのに必要なバッファの文字数（終端文字を含む）//
//					0						  : Error															//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	int		WINAPI	AjcScpGetPortDevNameA(C_BCP pPortName, BCP pBuf, UI lBuf)
{
	int				rc		 = 0;
	int				i;
	HDEVINFO		hDevInfo = NULL;
	SP_DEVINFO_DATA	DeviceInfoData = {sizeof(SP_DEVINFO_DATA)};
	BCP				pTmp	= NULL;
	UL				lTmp	= 0;
	HKEY			hKey	= (HKEY)INVALID_HANDLE_VALUE;
	UL				nlen;
	BC				name[32] = {0};

	if (pPortName != NULL) {
		do {
			if (!(hDevInfo = SetupDiGetClassDevs(&GUID_DEVINTERFACE_COMPORT, NULL, NULL, (DIGCF_PRESENT | DIGCF_DEVICEINTERFACE)))) break;

			if (pBuf != NULL && lBuf != 0) {
				for(i = 0; SetupDiEnumDeviceInfo(hDevInfo, i, &DeviceInfoData) && mbsicmp(pPortName, name) != 0; i++) {
					do {
						//	デバイス名のバッファサイズ取得
						lTmp = 0;
						SetupDiGetDeviceRegistryPropertyA(hDevInfo, &DeviceInfoData, SPDRP_DEVICEDESC, NULL, NULL, 0, &lTmp);
						if (lTmp != 0) {
							//	デバイス名バッファ割り当て
							if (pTmp = (BCP)AJCMEM(lTmp)) {
								BOOL			success;
								LONG			rsu;
								UL				typ = 0;
								//	デバイス名取得
								success = SetupDiGetDeviceRegistryPropertyA(hDevInfo, &DeviceInfoData, SPDRP_DEVICEDESC, NULL, (PBYTE)pTmp, lTmp, &lTmp);
								if (success != TRUE) break;
								//	レジストリキーハンドル オープン
								hKey = SetupDiOpenDevRegKey(hDevInfo, &DeviceInfoData, DICS_FLAG_GLOBAL, 0, DIREG_DEV, KEY_QUERY_VALUE);
								if (hKey == INVALID_HANDLE_VALUE) break;
								//	レジストリ値（ポート名）取得
								nlen = sizeof(name);
								rsu = RegQueryValueExA(hKey,  "PortName", NULL, &typ, (LPBYTE)name, &nlen);
								if (rsu != ERROR_SUCCESS ) break;
								//	ポート名一致ならばデバイス名，戻り値設定
								if (mbsicmp(pPortName, name) == 0) {
									AjcSnPrintFA(pBuf, lBuf, "%s", pTmp);
									rc = (int)strlen(pBuf);
								}
							}
						}
					} while (0);

					if (pTmp != NULL				) {free(pTmp);			pTmp = NULL;				}
					if (hKey != INVALID_HANDLE_VALUE) {RegCloseKey(hKey);	hKey = INVALID_HANDLE_VALUE;}
				}
			}
			else {
				for(i = 0; SetupDiEnumDeviceInfo(hDevInfo, i, &DeviceInfoData) && mbsicmp(pPortName, name) != 0; i++) {
					do {
						LONG			rsu;
						DWORD			typ = 0;
						//	デバイス名のバッファサイズ取得
						rc = 0;
						SetupDiGetDeviceRegistryPropertyA(hDevInfo, &DeviceInfoData, SPDRP_DEVICEDESC, NULL, NULL, 0, (PDWORD)&rc);
						if (rc == 0) break;
						//	レジストリキーハンドル オープン
						hKey = SetupDiOpenDevRegKey(hDevInfo, &DeviceInfoData, DICS_FLAG_GLOBAL, 0, DIREG_DEV, KEY_QUERY_VALUE);
						if (hKey == INVALID_HANDLE_VALUE) break;
						//	レジストリ値（ポート名）取得
						nlen = sizeof(name);
						rsu = RegQueryValueExA(hKey,  "PortName", NULL, &typ, (LPBYTE)name, &nlen);
						if (rsu != ERROR_SUCCESS ) break;
					} while (0);

					if (hKey != INVALID_HANDLE_VALUE) {RegCloseKey(hKey);	hKey = (HKEY)INVALID_HANDLE_VALUE;}
				}
			}
		} while(0);
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	int		WINAPI	AjcScpGetPortDevNameW(C_WCP pPortName, WCP pBuf, UI lBuf)
{
	int				rc		 = 0;
	int				i;
	HDEVINFO		hDevInfo = NULL;
	SP_DEVINFO_DATA	DeviceInfoData = {sizeof(SP_DEVINFO_DATA)};
	WCP				pTmp	= NULL;
	UL				lTmp	= 0;
	HKEY			hKey	= (HKEY)INVALID_HANDLE_VALUE;
	UL				nlen;
	WC				name[32] = {0};

	if (pPortName != NULL) {
		do {
			if (!(hDevInfo = SetupDiGetClassDevs(&GUID_DEVINTERFACE_COMPORT, NULL, NULL, (DIGCF_PRESENT | DIGCF_DEVICEINTERFACE)))) break;

			if (pBuf != NULL && lBuf != 0) {
				for(i = 0; SetupDiEnumDeviceInfo(hDevInfo, i, &DeviceInfoData) && wcsicmp(pPortName, name) != 0; i++) {
					do {
						//	デバイス名のバッファサイズ取得
						lTmp = 0;
						SetupDiGetDeviceRegistryPropertyW(hDevInfo, &DeviceInfoData, SPDRP_DEVICEDESC, NULL, NULL, 0, &lTmp);
						if (lTmp != 0) {
							//	デバイス名バッファ割り当て
							if (pTmp = (WCP)AJCMEM(lTmp * 2)) {
								BOOL			success;
								LONG			rsu;
								DWORD			typ = 0;
								//	デバイス名取得
								success = SetupDiGetDeviceRegistryPropertyW(hDevInfo, &DeviceInfoData, SPDRP_DEVICEDESC, NULL, (PBYTE)pTmp, lTmp, &lTmp);
								if (success != TRUE) break;
								//	レジストリキーハンドル オープン
								hKey = SetupDiOpenDevRegKey(hDevInfo, &DeviceInfoData, DICS_FLAG_GLOBAL, 0, DIREG_DEV, KEY_QUERY_VALUE);
								if (hKey == INVALID_HANDLE_VALUE) break;
								//	レジストリ値（ポート名）取得
								nlen = AJCTSIZE(name);
								rsu = RegQueryValueExW(hKey,  L"PortName", NULL, &typ, (PBYTE)name, (PDWORD)&nlen);
								if (rsu != ERROR_SUCCESS ) break;
								//	ポート名一致ならばデバイス名，戻り値設定
								if (wcsicmp(pPortName, name) == 0) {
									AjcSnPrintFW(pBuf, lBuf, L"%s", pTmp);
									rc = (int)wcslen(pBuf);
								}
							}
						}
					} while (0);

					if (pTmp != NULL				) {free(pTmp);			pTmp = NULL;				}
					if (hKey != INVALID_HANDLE_VALUE) {RegCloseKey(hKey);	hKey = INVALID_HANDLE_VALUE;}
				}
			}
			else {
				for(i = 0; SetupDiEnumDeviceInfo(hDevInfo, i, &DeviceInfoData) && wcsicmp(pPortName, name) != 0; i++) {
					do {
						LONG			rsu;
						DWORD			typ = 0;
						//	デバイス名のバッファサイズ取得
						rc = 0;
						SetupDiGetDeviceRegistryPropertyW(hDevInfo, &DeviceInfoData, SPDRP_DEVICEDESC, NULL, NULL, 0, (PDWORD)&rc);
						if (rc == 0) break;
						// バイト数→文字数に訂正
						rc /= 2;
						//	レジストリキーハンドル オープン
						hKey = SetupDiOpenDevRegKey(hDevInfo, &DeviceInfoData, DICS_FLAG_GLOBAL, 0, DIREG_DEV, KEY_QUERY_VALUE);
						if (hKey == INVALID_HANDLE_VALUE) break;
						//	レジストリ値（ポート名）取得
						nlen = AJCTSIZE(name);
						rsu = RegQueryValueExW(hKey,  L"PortName", NULL, &typ, (LPBYTE)name, &nlen);
						if (rsu != ERROR_SUCCESS ) break;
					} while (0);

					if (hKey != INVALID_HANDLE_VALUE) {RegCloseKey(hKey);	hKey = (HKEY)INVALID_HANDLE_VALUE;}
				}
			}
		} while(0);
	}
	return rc;
}
//==============================================================================================================//
//	チャンクデータの受信モード（テキスト／バイナリ）設定														//
//																												//
//	引　数	：	pW				- インスタンスハンドル															//
//				ChunkMode		- チャンクデータ通知モード														//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcScpSetChunkMode		(HAJCSCP pW, AJCSCP_CHUNKMODE ChunkMode)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		pW->ChunkMode = ChunkMode;
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	チャンクデータの受信モード（テキスト／バイナリ）取得														//
//																												//
//	引　数	：	pW				- インスタンスハンドル															//
//																												//
//	戻り値	：	チャンクデータ通知モード																		//
//==============================================================================================================//
AJCEXPORT	AJCSCP_CHUNKMODE WINAPI	AjcScpGetChunkMode		(HAJCSCP pW)
{
	AJCSCP_CHUNKMODE	rc = 0;

	if (IS_MY_INST(pW)) {
		rc = pW->ChunkMode;
	}
	return rc;
}
//==============================================================================================================//
//	受信文字エンコード種別設定																					//
//																												//
//	引　数		：	pW				- インスタンスハンドル														//
//					code			- 文字コード種別															//
//																												//
//	戻り値		：	TRUE  - OK																					//
//					FALSE - Error																				//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcScpSetRxTextCode(HAJCSCP pW, AJCSCP_TEXTCODE code)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		switch (code) {
			case AJCSCP_TXT_SJIS:				//	シフトＪＩＳ
			case AJCSCP_TXT_EUC:				//	ＥＵＣ　　　
			case AJCSCP_TXT_UTF8:				//	ＵＴＦ－８　
			case AJCSCP_TXT_AUTO:				//	自動判別　　
				//	文字コード判定バッファリセット
				AjcMbcReset(pW->hSsep->hMbc);
				//	文字コード種別設定
				pW->RxTxtCode = code;
				rc = TRUE;
				break;

			default:
				rc = FALSE;
				break;
		}
	}
	return rc;
}
//==============================================================================================================//
//	受信文字エンコード種別取得																					//
//																												//
//	引　数		：	pW				- インスタンスハンドル														//
//																												//
//	戻り値		：	文字コード種別（AJCSCP_TXT_SJIS / EUC / UTF8 / AUTO）										//
//==============================================================================================================//
AJCEXPORT	AJCSCP_TEXTCODE	WINAPI	AjcScpGetRxTextCode(HAJCSCP pW)
{
	AJCSCP_TEXTCODE	rc = (AJCSCP_TEXTCODE)0;

	if (IS_MY_INST(pW)) {
		rc = pW->RxTxtCode;
	}
	return rc;
}
//==============================================================================================================//
//	実際の受信文字エンコード種別取得																			//
//																												//
//	引　数		：	pW				- インスタンスハンドル														//
//																												//
//	戻り値		：	文字コード種別（AJCSCP_TXT_SJIS / EUC / UTF8）												//
//==============================================================================================================//
AJCEXPORT	AJCSCP_TEXTCODE	WINAPI	AjcScpGetActualRxTextCode(HAJCSCP pW)
{
	AJCSCP_TEXTCODE	rc = (AJCSCP_TEXTCODE)0;
	AJCMBCKIND		mbk;

	if (IS_MY_INST(pW)) {
		if ((rc = pW->RxTxtCode) == AJCSCP_TXT_AUTO) {
			mbk = AjcSsepGetMbcKind(pW->hSsep);
			switch (mbk) {
				case AJCMBC_SJIS:	rc = AJCSCP_TXT_SJIS;	break;
				case AJCMBC_EUC:	rc = AJCSCP_TXT_EUC	;	break;
				case AJCMBC_UTF8:	rc = AJCSCP_TXT_UTF8;	break;
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	送信文字エンコード種別設定																					//
//																												//
//	引　数		：	pW				- インスタンスハンドル														//
//					code			- 文字コード種別															//
//																												//
//	戻り値		：	TRUE  - OK																					//
//					FALSE - Error																				//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcScpSetTxTextCode(HAJCSCP pW, AJCSCP_TEXTCODE code)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		switch (code) {
			case AJCSCP_TXT_SJIS:				//	シフトＪＩＳ
			case AJCSCP_TXT_EUC:				//	ＥＵＣ　　　
			case AJCSCP_TXT_UTF8:				//	ＵＴＦ－８　
			case AJCSCP_TXT_AUTO:				//	自動判別
				pW->TxTxtCode = code;
				rc = TRUE;
				break;

			default:
				rc = FALSE;
				break;
		}
	}
	return rc;
}
//==============================================================================================================//
//	送信文字エンコード種別取得																					//
//																												//
//	引　数		：	pW				- インスタンスハンドル														//
//																												//
//	戻り値		：	文字コード種別（AJCSCP_TXT_SJIS / EUC / UTF8 / AUTO）										//
//==============================================================================================================//
AJCEXPORT	AJCSCP_TEXTCODE	WINAPI	AjcScpGetTxTextCode(HAJCSCP pW)
{
	AJCSCP_TEXTCODE	rc = (AJCSCP_TEXTCODE)0;

	if (IS_MY_INST(pW)) {
		rc = pW->TxTxtCode;
	}
	return rc;
}
//==============================================================================================================//
//	実際の送信文字エンコード種別取得																			//
//																												//
//	引　数		：	pW				- インスタンスハンドル														//
//																												//
//	戻り値		：	文字コード種別（AJCSCP_TXT_SJIS / EUC / UTF8）												//
//==============================================================================================================//
AJCEXPORT	AJCSCP_TEXTCODE	WINAPI	AjcScpGetActualTxTextCode(HAJCSCP pW)
{
	AJCSCP_TEXTCODE	rc = (AJCSCP_TEXTCODE)0;

	if (IS_MY_INST(pW)) {
		if ((rc = pW->TxTxtCode) == AJCSCP_TXT_AUTO) {
			rc = AjcScpGetActualRxTextCode(pW);
		}
	}
	return rc;
}
//==============================================================================================================//
//	自メールスロット生成																						//
//																												//
//	引　数	：	pW				- インスタンスハンドル															//
//																												//
//	戻り値	：	TRUE ：ＯＫ																						//
//				FALSE：エラー																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcScpCreateMySlot(HAJCSCP pW)
{
	BOOL	rc = FALSE;

	rc = AjcScpCreateMySlotEx(pW, 0, 0, NULL);

	return rc;
}
//==============================================================================================================//
//	自メールスロット生成（メールスロットオプション指定）														//
//																												//
//	引　数	：	pW						- インスタンスハンドル													//
//				nMaxMessageSize			- 最大メッセ０時サイズ													//
//				lReadTimeout			- 読み出しタイムアウト[ms]												//
//				lpSecurityAttributes	- セキュリティ属性へのポインタ											//
//																												//
//	戻り値	：	TRUE ：ＯＫ																						//
//				FALSE：エラー																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcScpCreateMySlotEx(HAJCSCP pW, UI nMaxMessageSize, UI lReadTimeout, LPSECURITY_ATTRIBUTES lpSecurityAttributes)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		//	既存のメールスロット破棄
		if (pW->hSlot != NULL) {
			CloseHandle(pW->hSlot);
			pW->hSlot = NULL;
		}
		//	CreateMailSlot()の引数退避
		pW->MaxMsgSize	= nMaxMessageSize;
		pW->ReadTimeout = lReadTimeout;
		//	セキュリティ属性退避
		ScpSaveSlot(pW, lpSecurityAttributes);
		//	メールスロット生成
		rc = ScpCreateMySlotAndNtcErr(pW);
	}
	return rc;
}
//==============================================================================================================//
//	自メールスロット消去																						//
//																												//
//	引　数	：	pW				- インスタンスハンドル															//
//																												//
//	戻り値	：	TRUE ：ＯＫ																						//
//				FALSE：エラー																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcScpDeleteMySlot(HAJCSCP pW)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		if (pW->hSlot != NULL) {
			CloseHandle(pW->hSlot);
			pW->hSlot = NULL;
		}
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	自メールスロット生成状態取得																				//
//																												//
//	引　数	：	pW				- インスタンスハンドル															//
//																												//
//	戻り値	：	TRUE ：自メールスロット生成済																	//
//				FALSE：自メールスロット未生成																	//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcScpMySlotIsCreated(HAJCSCP pW)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		rc = (pW->hSlot != NULL);
	}
	return rc;
}
//==============================================================================================================//
//	自メールスロットのパス名取得																				//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pBuf		- 自スロットパス名を格納するバッファのアドレス										//
//				lBuf		- 自スロットパス名を格納するバッファの文字数										//
//																												//
//	戻り値	：	自スロットパス名文字列へのポインタ																//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BCP		WINAPI	AjcScpGetMySlotPathNameA(HAJCSCP pW)
{
	BCP		rc = NULL;

	if (IS_MY_INST(pW)) {
		AjcSnPrintFA(pW->PortName.BStr, AJCTSIZE(pW->PortName.BStr), "\\\\%S\\mailslot\\%S" , pW->SlotInfo.MyHostName, pW->SlotInfo.MySlotName);
		rc = pW->PortName.BStr;
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	WCP		WINAPI	AjcScpGetMySlotPathNameW(HAJCSCP pW)
{
	WCP		rc = NULL;

	if (IS_MY_INST(pW)) {
		AjcSnPrintFW(pW->PortName.WStr, AJCTSIZE(pW->PortName.WStr), L"\\\\%s\\mailslot\\%s", pW->SlotInfo.MyHostName, pW->SlotInfo.MySlotName);
		rc = pW->PortName.WStr;
	}
	return rc;
}
//==============================================================================================================//
//	自コンピュータ名取得																						//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pBuf		- 自コンピュータ名を格納するバッファのアドレス										//
//																												//
//	戻り値	：	TRUE ：ＯＫ																						//
//				FALSE：エラー																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcScpGetMyComputerNameA(HAJCSCP pW, BC pBuf[AJCMAX_HOSTNAME_LENGTH])
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW) && pBuf != NULL) {
		AjcWideCharToByteChar(pW->SlotInfo.MyHostName, pBuf, AJCMAX_HOSTNAME_LENGTH);
		rc = TRUE;
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcScpGetMyComputerNameW(HAJCSCP pW, WC pBuf[AJCMAX_HOSTNAME_LENGTH])
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW) && pBuf != NULL) {
		AjcSnPrintF(pBuf, AJCMAX_HOSTNAME_LENGTH, L"%s", pW->SlotInfo.MyHostName);
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	メールスロット名情報設定																					//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pMySlot		- 自スロット名をのアドレス			（未設定時はNULL）								//
//				pRmtHost	- リモートコンピュータ名のアドレス	（未設定時はNULL）								//
//				pRmtSlot	- リモートスロット名のアドレス		（未設定時はNULL）								//
//																												//
//	戻り値	：	TRUE ：ＯＫ																						//
//				FALSE：エラー																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcScpSetMailSlotNamesA(HAJCSCP pW, C_BCP pMySlot, C_BCP pRmtHost, C_BCP pRmtSlot)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		if (pMySlot  != NULL) AjcByteCharToWideChar(pMySlot , pW->SlotInfo.MySlotName , AJCTSIZE(pW->SlotInfo.MySlotName ));
		if (pRmtHost != NULL) AjcByteCharToWideChar(pRmtHost, pW->SlotInfo.RmtHostName, AJCTSIZE(pW->SlotInfo.RmtHostName));
		if (pRmtSlot != NULL) AjcByteCharToWideChar(pRmtSlot, pW->SlotInfo.RmtSlotName, AJCTSIZE(pW->SlotInfo.RmtSlotName));
		rc = TRUE;
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcScpSetMailSlotNamesW(HAJCSCP pW, C_WCP pMySlot, C_WCP pRmtHost, C_WCP pRmtSlot)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		if (pMySlot  != NULL) AjcSnPrintF(pW->SlotInfo.MySlotName , AJCTSIZE(pW->SlotInfo.MySlotName ), pMySlot );
		if (pRmtHost != NULL) AjcSnPrintF(pW->SlotInfo.RmtHostName, AJCTSIZE(pW->SlotInfo.RmtHostName), pRmtHost);
		if (pRmtSlot != NULL) AjcSnPrintF(pW->SlotInfo.RmtSlotName, AJCTSIZE(pW->SlotInfo.RmtSlotName), pRmtSlot);
		rc = TRUE;
	}
	return rc;
}

//==============================================================================================================//
//	メールスロット名情報取得																					//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pMySlot		- 自スロット名をのアドレス			（不要時はNULL）								//
//				pRmtHost	- リモートコンピュータ名のアドレス	（不要時はNULL）								//
//				pRmtSlot	- リモートスロット名のアドレス		（不要時はNULL）								//
//																												//
//	戻り値	：	TRUE ：ＯＫ																						//
//				FALSE：エラー																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcScpGetMailSlotNamesA(HAJCSCP pW, BC pMySlot[AJCMAX_SLOTNAME_LENGTH], BC pRmtHost[AJCMAX_HOSTNAME_LENGTH], BC pRmtSlot[AJCMAX_SLOTNAME_LENGTH])
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		if (pMySlot  != NULL) AjcWideCharToByteChar(pW->SlotInfo.MySlotName , pMySlot , AJCMAX_SLOTNAME_LENGTH);
		if (pRmtHost != NULL) AjcWideCharToByteChar(pW->SlotInfo.RmtHostName, pRmtHost, AJCMAX_HOSTNAME_LENGTH);
		if (pRmtSlot != NULL) AjcWideCharToByteChar(pW->SlotInfo.RmtSlotName, pRmtSlot, AJCMAX_SLOTNAME_LENGTH);
		rc = TRUE;
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcScpGetMailSlotNamesW(HAJCSCP pW, WC pMySlot[AJCMAX_SLOTNAME_LENGTH], WC pRmtHost[AJCMAX_HOSTNAME_LENGTH], WC pRmtSlot[AJCMAX_SLOTNAME_LENGTH])
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		if (pMySlot  != NULL) AjcSnPrintF(pMySlot , AJCMAX_SLOTNAME_LENGTH, L"%s", pW->SlotInfo.MySlotName );
		if (pRmtHost != NULL) AjcSnPrintF(pRmtHost, AJCMAX_HOSTNAME_LENGTH, L"%s", pW->SlotInfo.RmtHostName);
		if (pRmtSlot != NULL) AjcSnPrintF(pRmtSlot, AJCMAX_SLOTNAME_LENGTH, L"%s", pW->SlotInfo.RmtSlotName);
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	メールスロット送信制限速度の設定																			//
//																												//
//	引　数	：	pW		- インスタンスハンドル																	//
//				flag	- 送信速度制限フラグ（TRUE:制限する，FALSE:制限しない）									//
//				bps		- 送信制限速度[Kbytes / sec]															//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcScpSetTxSpeedLimit(HAJCSCP pW, BOOL flag, UI bps)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		pW->fTxDelay	= flag;
		pW->TxDelayBPS	= bps * 1024;

		pW->SlotInfo.fTxDelay  = flag;
		pW->SlotInfo.TxDelayBPS= bps;

		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	メールスロット送信制限速度の取得																			//
//																												//
//	引　数	：	pW		- インスタンスハンドル																	//
//				pBps	- 送信制限速度[Kbytes / sec] を格納するバッファのアドレス								//
//																												//
//	戻り値	：	送信速度制限フラグ（TRUE:制限する，FALSE:制限しない）											//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcScpGetTxSpeedLimit(HAJCSCP pW, UIP pBps)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		if (pBps != NULL) {
			*pBps = pW->TxDelayBPS / 1024;
		}
		rc = pW->fTxDelay;
	}
	return rc;
}
//==============================================================================================================//
//	送信停止の認識時間設定																						//
//																												//
//	引　数	：	pW		- インスタンスハンドル																	//
//				msTime	- 送信停止の認識時間[ms]	（－１：未設定）											//
//																												//
//	戻り値	：	前回の送信停止の認識時間[us]																	//
//==============================================================================================================//
AJCEXPORT	ULL			WINAPI		AjcScpSetRecognizeTxStopTime(HAJCSCP pW, UI msTime)
{
	ULL		rc = -1;

	if (IS_MY_INST(pW)) {
		rc = pW->MesTxTime;
		if (msTime != -1) {
			pW->MesTxTime = msTime;
		}
	}
	return rc;
}
//==============================================================================================================//
//	受信停止の認識時間設定																						//
//																												//
//	引　数	：	pW		- インスタンスハンドル																	//
//				msTime	- 受信停止の認識時間[ms]	（－１：未設定）											//
//																												//
//	戻り値	：	前回の受信停止の認識時間[us]																	//
//==============================================================================================================//
AJCEXPORT	ULL			WINAPI		AjcScpSetRecognizeRxStopTime(HAJCSCP pW, UI msTime)
{
	ULL		rc = -1;

	if (IS_MY_INST(pW)) {
		rc = pW->MesRxTime;
		if (msTime != -1) {
			pW->MesRxTime = msTime;
		}
	}
	return rc;
}
//==============================================================================================================//
//	プロファイルからポートパラメタを読み出す（非公開）															//
//																												//
//	引　数	：	pW		- インスタンスハンドル																	//
//				pSect	- プロファイルセクション名（NULLの場合は、pW->ProfileSect)								//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcScpLoadParamFromProfileA(HAJCSCP pW, C_BCP pSect)
{
	BOOL	rc = FALSE;
	int		len;
	WCP		pTmp;

	if (IS_MY_INST(pW)) {
		if (pSect != NULL) {
			len = MultiByteToWideChar(CP_ACP, 0, pSect, -1, NULL, 0);
			if (len != 0 && (pTmp = AjcTAlloc(len))) {
				MultiByteToWideChar(CP_ACP, 0, pSect, -1, pTmp, len);
				LoadProfile(pW, pTmp);
				free(pTmp);
			}
		}
		else {
			LoadProfile(pW, NULL);
		}
		rc = TRUE;
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcScpLoadParamFromProfileW(HAJCSCP pW, C_WCP pSect)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		LoadProfile(pW, pSect);
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	ポートパラメタをプロファイルにセーブ（非公開）																//
//																												//
//	引　数	：	pW		- インスタンスハンドル																	//
//				pSect	- プロファイルセクション名（NULLの場合は、pW->ProfileSect)								//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcScpSaveParamToProfileA(HAJCSCP pW, C_BCP pSect)
{
	BOOL	rc = FALSE;
	int		len;
	WCP		pTmp;

	if (IS_MY_INST(pW)) {
		if (pSect != NULL) {
			len = MultiByteToWideChar(CP_ACP, 0, pSect, -1, NULL, 0);
			if (len != 0 && (pTmp = AjcTAlloc(len))) {
				MultiByteToWideChar(CP_ACP, 0, pSect, -1, pTmp, len);
				SaveProfile(pW, pTmp);
				free(pTmp);
			}
		}
		else {
			SaveProfile(pW, NULL);
		}
		rc = TRUE;
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcScpSaveParamToProfileW(HAJCSCP pW, C_WCP pSect)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		SaveProfile(pW, pSect);
		rc = TRUE;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	全リソース解放																								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	VO	SubDeleteResource(HAJCSCP pW)
{
	UI		ix;
	HANDLE	hdls[3] = {NULL};

	if (pW != NULL) {
		//----- ソケットイベント通知用イベントオブジェクト破棄 -------------------------------------------------//
		if (pW->hEvtSock != NULL) {
			CloseHandle(pW->hEvtSock);
		}
		//----- 自メールスロットクローズ ------------------------------------------------------------------------//
		if (pW->hSlot != NULL) {
			CloseHandle(pW->hSlot);
			pW->hSlot = NULL;
		}
		//----- セキュリティ情報解放 ---------------------------------------------------------------------------//
		if (pW->pSecAttr != NULL) {
			AJCFREE(pW->pSecAttr);
			pW->pSecAttr = NULL;
		}
		//----- ポートクローズ ---------------------------------------------------------------------------------//
		AjcScpClose(pW);
		//----- サブスレッド停止 -------------------------------------------------------------------------------//
		ix = 0;
		if (pW->hThreadTx  != NULL) hdls[ix++] = pW->hThreadTx;
		if (pW->hThreadRx  != NULL) hdls[ix++] = pW->hThreadRx;
		if (pW->hThreadObs != NULL) hdls[ix++] = pW->hThreadObs;
		pW->fThreadEnd = TRUE;
		if (ix != 0) WaitForMultipleObjects( ix, hdls, TRUE, 3000);
		//----- サブスレッド破棄 -------------------------------------------------------------------------------//
		if (pW->hThreadTx  != NULL) {CloseHandle(pW->hThreadTx ); pW->hThreadTx  = NULL;}
		if (pW->hThreadRx  != NULL) {CloseHandle(pW->hThreadRx ); pW->hThreadRx  = NULL;}
		if (pW->hThreadObs != NULL) {CloseHandle(pW->hThreadObs); pW->hThreadObs = NULL;}
		//----- バイトストリーム分離オブジェクト消去 -----------------------------------------------------------//
		if (pW->hSsep	 != NULL) {AjcSsepDelete(pW->hSsep);	pW->hSsep	 = NULL;}
		//----- メールボックスハンドル消去 ---------------------------------------------------------------------//
		if (pW->hVMbxTxD != NULL) {AjcVMbxDelete(pW->hVMbxTxD); pW->hVMbxTxD = NULL;}
		if (pW->hFMbxNtc != NULL) {AjcFMbxDelete(pW->hFMbxNtc); pW->hFMbxNtc = NULL;}
		//----- クリティカルセクションオブジェクト消去 ---------------------------------------------------------//
		DeleteCriticalSection(&pW->CsCommApi);
		DeleteCriticalSection(&pW->CsTxDelay);
		//----- 計測タイマ消去 ---------------------------------------------------------------------------------//
		if (pW->hMesTxDelay	 != NULL) {AjcMesTimeDelete(pW->hMesTxDelay);	pW->hMesTxDelay  = NULL;}
		//----- インスタンスワーク開放 -------------------------------------------------------------------------//
		AJCFREE(pW);
	}
}

//--------------------------------------------------------------------------------------------------------------//
//	プロファイル読み出し																						//
//																												//
//	引　数	：	pW				- インスタンスハンドル															//
//				pSect			- プロファイルセクション名														//
//																												//
//	戻り値	：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static VO	LoadProfile(HAJCSCP pW, C_WCP pSect)
{
	//	NULLの場合、デフォルトセクション設定
	if (pSect == NULL || *pSect == 0) {
		pSect = pW->ProfileSect;
	}

	if (pSect != NULL && *pSect != 0) {
		//----- ＣＯＭ／スロット選択情報 -----------------------------------------------------------------------//
		pW->PortSel						= AjcGetProfileUInt(pSect, L"PortSel" , AJCSCP_SEL_COMPORT);
		//----- ポート番号 -------------------------------------------------------------------------------------//
		pW->PortNo						= AjcGetProfileUInt(pSect, L"PortNo" , 1);
		//----- ＤＣＢ -----------------------------------------------------------------------------------------//
		pW->CommDcb.DCBlength			= sizeof(DCB);
		pW->CommDcb.BaudRate			= AjcGetProfileUInt(pSect, L"BaudRate"			, pW->CommDcb.BaudRate			);
		pW->CommDcb.fBinary				= AjcGetProfileUInt(pSect, L"fBinary"			, pW->CommDcb.fBinary			);
		pW->CommDcb.fParity				= AjcGetProfileUInt(pSect, L"fParity"		   	, pW->CommDcb.fParity			);
		pW->CommDcb.fOutxCtsFlow		= AjcGetProfileUInt(pSect, L"fOutxCtsFlow"		, pW->CommDcb.fOutxCtsFlow		);
		pW->CommDcb.fOutxDsrFlow		= AjcGetProfileUInt(pSect, L"fOutxDsrFlow"		, pW->CommDcb.fOutxDsrFlow		);
		pW->CommDcb.fDtrControl			= AjcGetProfileUInt(pSect, L"fDtrControl"	   	, pW->CommDcb.fDtrControl		);
		pW->CommDcb.fDsrSensitivity		= AjcGetProfileUInt(pSect, L"fDsrSensitivity"	, pW->CommDcb.fDsrSensitivity	);
		pW->CommDcb.fTXContinueOnXoff	= AjcGetProfileUInt(pSect, L"fTXContinueOnXoff"	, pW->CommDcb.fTXContinueOnXoff	);
		pW->CommDcb.fOutX				= AjcGetProfileUInt(pSect, L"fOutX"				, pW->CommDcb.fOutX				);
		pW->CommDcb.fInX				= AjcGetProfileUInt(pSect, L"fInX"				, pW->CommDcb.fInX				);
		pW->CommDcb.fErrorChar			= AjcGetProfileUInt(pSect, L"fErrorChar"		, pW->CommDcb.fErrorChar		);
		pW->CommDcb.fNull			  	= AjcGetProfileUInt(pSect, L"fNull"				, pW->CommDcb.fNull			  	);
		pW->CommDcb.fRtsControl			= AjcGetProfileUInt(pSect, L"fRtsControl"		, pW->CommDcb.fRtsControl		);
		pW->CommDcb.fAbortOnError		= AjcGetProfileUInt(pSect, L"fAbortOnError"		, pW->CommDcb.fAbortOnError		);
		pW->CommDcb.XonLim				= AjcGetProfileUInt(pSect, L"XonLim"			, pW->CommDcb.XonLim			);
		pW->CommDcb.XoffLim				= AjcGetProfileUInt(pSect, L"XoffLim"			, pW->CommDcb.XoffLim			);
		pW->CommDcb.ByteSize			= AjcGetProfileUInt(pSect, L"ByteSize"			, pW->CommDcb.ByteSize			);
		pW->CommDcb.Parity				= AjcGetProfileUInt(pSect, L"Parity"			, pW->CommDcb.Parity			);
		pW->CommDcb.StopBits			= AjcGetProfileUInt(pSect, L"StopBits"			, pW->CommDcb.StopBits			);
		pW->CommDcb.XonChar				= AjcGetProfileUInt(pSect, L"XonChar"			, pW->CommDcb.XonChar			);
		pW->CommDcb.XoffChar			= AjcGetProfileUInt(pSect, L"XoffChar"			, pW->CommDcb.XoffChar			);
		pW->CommDcb.ErrorChar			= AjcGetProfileUInt(pSect, L"ErrorChar"			, pW->CommDcb.ErrorChar			);
		pW->CommDcb.EofChar				= AjcGetProfileUInt(pSect, L"EofChar"			, pW->CommDcb.EofChar			);
		pW->CommDcb.EvtChar				= AjcGetProfileUInt(pSect, L"EvtChar"			, pW->CommDcb.EvtChar			);
		//----- タイマ情報 -------------------------------------------------------------------------------------//
		pW->CommTmo.ReadIntervalTimeout			= AjcGetProfileUInt(pSect, L"ReadIntervalTimeout"		 , pW->CommTmo.ReadIntervalTimeout		  );
		pW->CommTmo.ReadTotalTimeoutMultiplier	= AjcGetProfileUInt(pSect, L"ReadTotalTimeoutMultiplier" , pW->CommTmo.ReadTotalTimeoutMultiplier );
		pW->CommTmo.ReadTotalTimeoutConstant	= AjcGetProfileUInt(pSect, L"ReadTotalTimeoutConstant"	 , pW->CommTmo.ReadTotalTimeoutConstant	  );
		pW->CommTmo.WriteTotalTimeoutMultiplier	= AjcGetProfileUInt(pSect, L"WriteTotalTimeoutMultiplier", pW->CommTmo.WriteTotalTimeoutMultiplier);
		pW->CommTmo.WriteTotalTimeoutConstant	= AjcGetProfileUInt(pSect, L"WriteTotalTimeoutConstant"	 , pW->CommTmo.WriteTotalTimeoutConstant  );
		//----- メールスロット情報 -----------------------------------------------------------------------------//
		AjcGetProfileStr (pSect, L"MySlotName" , pW->SlotInfo.MySlotName , pW->SlotInfo.MySlotName , AJCTSIZE(pW->SlotInfo.MySlotName ));
		AjcGetProfileStr (pSect, L"RmtHostName", pW->SlotInfo.RmtHostName, pW->SlotInfo.RmtHostName, AJCTSIZE(pW->SlotInfo.RmtHostName));
		AjcGetProfileStr (pSect, L"RmtSlotName", pW->SlotInfo.RmtSlotName, pW->SlotInfo.RmtSlotName, AJCTSIZE(pW->SlotInfo.RmtSlotName));
	//	if (pW->SlotInfo.MySlotName [0] == 0) strcpy(pW->SlotInfo.MySlotName , "MySlot");
	//	if (pW->SlotInfo.RmtSlotName[0] == 0) strcpy(pW->SlotInfo.RmtSlotName, "RmtSlot");
		pW->SlotInfo.fTxDelay			= AjcGetProfileUInt(pSect, L"fTxDelay"	, pW->SlotInfo.fTxDelay		);
		pW->SlotInfo.TxDelayBPS			= AjcGetProfileUInt(pSect, L"TxDelayBPS", pW->SlotInfo.TxDelayBPS	);
		//----- メールスロット送信速度制限情報初期化 -----------------------------------------------------------//
		pW->fTxDelay			 = pW->SlotInfo.fTxDelay;				//	送信速度制限フラグ
		pW->TxDelayBPS			 = pW->SlotInfo.TxDelayBPS * 1024;		//	送信制限速度[Bytes / sec]
		pW->TxDelayBytesCount	 = 0;									//	送信遅延用バイトカウンタ
		pW->TxDelayTickCount	 = 0;									//	送信遅延用・経過時間[us]
		//----- ソケット情報 -----------------------------------------------------------------------------------//
		AjcGetProfileStr (pSect, L"SockServName" , pW->SockInfo.ServName, pW->SockInfo.ServName , AJCTSIZE(pW->SockInfo.ServName));
		pW->SockInfo.PortNo = (UW)AjcGetProfileUInt(pSect, L"SockPortNo", pW->SockInfo.PortNo);
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	プロファイル書き込み																						//
//																												//
//	引　数	：	pW				- インスタンスハンドル															//
//				pSect			- プロファイルセクション名														//
//																												//
//	戻り値	：	なし																							//
//--------------------------------------------------------------------------------------------------------------//
static VO	SaveProfile(HAJCSCP pW, C_WCP pSect)
{
	//	NULLの場合、デフォルトセクション設定
	if (pSect == NULL || *pSect == 0) {
		pSect = pW->ProfileSect;
	}

	//	書き込み
	if (pSect != NULL && *pSect != 0) {
		//----- ＣＯＭ／スロット選択情報 -----------------------------------------------------------------------//
		AjcPutProfileUInt(pSect, L"PortSel"			, pW->PortSel					);
		//----- ポート番号 -------------------------------------------------------------------------------------//
		AjcPutProfileUInt(pSect, L"PortNo"			, pW->PortNo					);
		//----- ＤＣＢ -----------------------------------------------------------------------------------------//
		AjcPutProfileUInt(pSect, L"BaudRate"		 , pW->CommDcb.BaudRate			);
		AjcPutProfileUInt(pSect, L"fBinary"		   	 , pW->CommDcb.fBinary			);
		AjcPutProfileUInt(pSect, L"fParity"		   	 , pW->CommDcb.fParity			);
		AjcPutProfileUInt(pSect, L"fOutxCtsFlow"	 , pW->CommDcb.fOutxCtsFlow		);
		AjcPutProfileUInt(pSect, L"fOutxDsrFlow"	 , pW->CommDcb.fOutxDsrFlow		);
		AjcPutProfileUInt(pSect, L"fDtrControl"	   	 , pW->CommDcb.fDtrControl		);
		AjcPutProfileUInt(pSect, L"fDsrSensitivity"	 , pW->CommDcb.fDsrSensitivity	);
		AjcPutProfileUInt(pSect, L"fTXContinueOnXoff", pW->CommDcb.fTXContinueOnXoff);
		AjcPutProfileUInt(pSect, L"fOutX"			 , pW->CommDcb.fOutX			);
		AjcPutProfileUInt(pSect, L"fInX"			 , pW->CommDcb.fInX				);
		AjcPutProfileUInt(pSect, L"fErrorChar"	   	 , pW->CommDcb.fErrorChar		);
		AjcPutProfileUInt(pSect, L"fNull"			 , pW->CommDcb.fNull			);
		AjcPutProfileUInt(pSect, L"fRtsControl"	   	 , pW->CommDcb.fRtsControl		);
		AjcPutProfileUInt(pSect, L"fAbortOnError"	 , pW->CommDcb.fAbortOnError	);
		AjcPutProfileUInt(pSect, L"XonLim"			 , pW->CommDcb.XonLim			);
		AjcPutProfileUInt(pSect, L"XoffLim"		   	 , pW->CommDcb.XoffLim			);
		AjcPutProfileUInt(pSect, L"ByteSize"		 , pW->CommDcb.ByteSize			);
		AjcPutProfileUInt(pSect, L"Parity"		   	 , pW->CommDcb.Parity			);
		AjcPutProfileUInt(pSect, L"StopBits"		 , pW->CommDcb.StopBits			);
		AjcPutProfileUInt(pSect, L"XonChar"		   	 , pW->CommDcb.XonChar			);
		AjcPutProfileUInt(pSect, L"XoffChar"		 , pW->CommDcb.XoffChar			);
		AjcPutProfileUInt(pSect, L"ErrorChar"		 , pW->CommDcb.ErrorChar		);
		AjcPutProfileUInt(pSect, L"EofChar"		   	 , pW->CommDcb.EofChar			);
		AjcPutProfileUInt(pSect, L"EvtChar"		   	 , pW->CommDcb.EvtChar			);
		//----- タイマ情報 -------------------------------------------------------------------------------------//
		AjcPutProfileUInt(pSect, L"ReadIntervalTimeout"		 	, pW->CommTmo.ReadIntervalTimeout			);
		AjcPutProfileUInt(pSect, L"ReadTotalTimeoutMultiplier"	, pW->CommTmo.ReadTotalTimeoutMultiplier	);
		AjcPutProfileUInt(pSect, L"ReadTotalTimeoutConstant"	, pW->CommTmo.ReadTotalTimeoutConstant		);
		AjcPutProfileUInt(pSect, L"WriteTotalTimeoutMultiplier"	, pW->CommTmo.WriteTotalTimeoutMultiplier	);
		AjcPutProfileUInt(pSect, L"WriteTotalTimeoutConstant"	, pW->CommTmo.WriteTotalTimeoutConstant		);
		//----- メールスロット情報 -----------------------------------------------------------------------------//
		AjcPutProfileStr (pSect, L"MySlotName" 		, pW->SlotInfo.MySlotName	);
		AjcPutProfileStr (pSect, L"RmtHostName"		, pW->SlotInfo.RmtHostName	);
		AjcPutProfileStr (pSect, L"RmtSlotName"		, pW->SlotInfo.RmtSlotName	);
		AjcPutProfileUInt(pSect, L"fTxDelay"		, pW->SlotInfo.fTxDelay		);
		AjcPutProfileUInt(pSect, L"TxDelayBPS"		, pW->SlotInfo.TxDelayBPS	);
		//----- ソケット情報 -----------------------------------------------------------------------------------//
		AjcPutProfileStr (pSect, L"SockServName", pW->SockInfo.ServName);
		AjcPutProfileUInt(pSect, L"SockPortNo"	, pW->SockInfo.PortNo  );
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	ダイアログによる通信パラメタ設定（簡易）																	//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				hWndOwner	- オーナーウインドのハンドル														//
//				pPt			- 表示位置情報（スクリーン座標）													//
//																												//
//	戻り値	：	以下のビットの組み合わせ																		//
//					AJCSCPDGR_SELCHANGED	- リソース選択変更													//
//					AJCSCPDGR_PORTCHANGED	- ＣＯＭポート変更													//
//					AJCSCPDGR_DCBCHANGED	- ＤＣＢ変更														//
//					AJCSCPDGR_TMOCHANGED	- タイマ変更														//
//					AJCSCPDGR_SELCHANGED	- ＣＯＭポート／メールスロットの選択変更							//
//					AJCSCPDGR_SLOTCHANGED	- メールスロット情報変更											//
//					AJCSCPDGR_SOCKCHANGED	- ソケット情報変更													//
//					AJCSCPDGR_OKBUTTON		- ＯＫボタンによる終了												//
//--------------------------------------------------------------------------------------------------------------//
static	UI		SubDlgParamEasy	(HAJCSCP pW, HWND hWndOwner, LPPOINT pPt)
{
	UI				rc = 0;
	AJCSCP_PORTSEL	sel;
	UI				port;
	DCB				dcb;
	BOOL			fToDetail	= FALSE;
	BOOL			fNeedReOpen = FALSE;
	AJCSCP_SLOTINFO	slot;
	AJCSCP_SOCKINFO	sock;

	//	リソース選択情報設定（ダイアログ設定用）
	sel = pW->PortSel;

	//	ＣＯＭポート情報設定（ダイアログ設定用）
	port = pW->PortNo;
	memcpy(&dcb, &pW->CommDcb, sizeof(DCB));

	//	メールスロット,ソケット情報設定（ダイアログ処理用）
	memcpy(&slot, &pW->SlotInfo, sizeof pW->SlotInfo);
	memcpy(&sock, &pW->SockInfo, sizeof pW->SockInfo);

	//	ダイアログによるポート情報設定
	rc = AjcScpDlgSetParamEasy(hWndOwner, pW, &sel, &port, &dcb, &fToDetail, &slot, &sock, pW->ProfileSect, pW->mskRbt, pW->mskGray, pPt);

	//	ＯＫボタン押下時の処理
	if (rc & AJCSCPDGR_OKBUTTON) {													//	ＯＫボタン押下？
		//	ポートがオープン状態の場合、「再オープン要」フラグ設定
		if (pW->PortSel != AJCSCP_SEL_MAILSLOT) {
			if (pW->hPort != NULL ) fNeedReOpen = TRUE;
		}
		else {
			if (pW->fTxSlotOpened ) fNeedReOpen = TRUE;
		}

		//	通信リソースが変更された場合、リソースの選択が変更された旨、フラグ設定
		if (sel != pW->PortSel) rc |= AJCSCPDGR_SELCHANGED;

		//	新たに選択されたリソースにより、各リソース設定処理
		switch (sel) {
			//	●ＣＯＭポートを選択
			case AJCSCP_SEL_COMPORT:
				//	リソース選択変更／ポート番号変更？
				if		(rc & (AJCSCPDGR_SELCHANGED | AJCSCPDGR_PORTCHANGED)) {
					//	リソース選択前のポートクローズ
					if (fNeedReOpen) AjcScpClose(pW);
					//	ＣＯＭポート設定値更新
					pW->PortNo = port;
					memcpy(&pW->CommDcb, &dcb, sizeof(DCB));
					//	リソース選択情報更新
					pW->PortSel = sel;
					//	ＣＯＭポート再オープン
					if (fNeedReOpen) AjcScpOpenDefault(pW);
				}
				//	ＤＣＢ情報変更？
				else if (rc & AJCSCPDGR_DCBCHANGED ) {
					//	リソース選択前のポートクローズ
					if (fNeedReOpen) AjcScpClose(pW);
					//	ＤＣＢ情報更新
					memcpy(&pW->CommDcb, &dcb, sizeof(DCB));
					//	ＣＯＭポート再オープン
					if (fNeedReOpen) AjcScpOpenDefault(pW);
				}
				break;

			//	●メールスロットを選択
			case AJCSCP_SEL_MAILSLOT:
				//	リソース選択変更／メールスロット設定内容変更？
				if ((rc & AJCSCPDGR_SELCHANGED) || memcmp(&slot, &pW->SlotInfo, sizeof pW->SlotInfo) != 0) {
					//	リソース選択前のポートクローズ
					if (fNeedReOpen) AjcScpClose(pW);
					//	メールスロット情報更新
					memcpy(&pW->SlotInfo, &slot, sizeof pW->SlotInfo);
					pW->fTxDelay	= pW->SlotInfo.fTxDelay;
					pW->TxDelayBPS	= pW->SlotInfo.TxDelayBPS * 1024;
					//	通信リソース選択情報更新
					pW->PortSel = sel;
					//	自メールスロット再生成
					if (pW->hSlot != NULL) ScpCreateMySlotAndNtcErr(pW);
					//	メールスロット再オープン
					if (fNeedReOpen) AjcScpOpenDefault(pW);
				}
				break;

			//	●ソケットを選択
			case AJCSCP_SEL_SOCKET:
				//	リソース選択変更／ソケット設定内容変更？
				if ((rc & AJCSCPDGR_SELCHANGED) || memcmp(&sock, &pW->SockInfo, sizeof pW->SockInfo) != 0) {
					//	リソース選択前のポートクローズ
					if (fNeedReOpen) AjcScpClose(pW);
					//	通信リソース選択情報更新
					pW->PortSel = sel;
					//	ソケット情報更新
					memcpy(&pW->SockInfo, &sock, sizeof pW->SockInfo);
					//	ソケット再オープン
					if (fNeedReOpen) AjcScpOpenDefault(pW);	
				}
				break;
		}
		//	リソース選択情報設定
		pW->PortSel = sel;

		//	リソース変更通知
		if (rc & (AJCSCPDGR_SELCHANGED | AJCSCPDGR_PORTCHANGED | AJCSCPDGR_SLOTCHANGED | AJCSCPDGR_SOCKCHANGED)) {
			ScpNtcPortStateToUser(pW, AJCSCP_PORTNO);
		}
	}
	//	キャンセル／詳細設定ボタン押下時の処理
	else {																			//	キャンセル／詳細設定ボタン押下？
		if (fToDetail) {															//		詳細設定ボタン押下
			rc = SubDlgParamDetail(pW, hWndOwner, pPt);								//			詳細設定ダイアログ
		}
	}

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	ダイアログによる通信パラメタ設定（詳細）																	//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				hWndOwner	- オーナーウインドのハンドル														//
//				pPt			- 表示位置情報（スクリーン座標）													//
//																												//
//	戻り値	：	以下のビットの組み合わせ																		//
//					AJCSCPDGR_SELCHANGED	- リソース選択変更													//
//					AJCSCPDGR_PORTCHANGED	- ポート変更														//
//					AJCSCPDGR_DCBCHANGED	- ＤＣＢ変更														//
//					AJCSCPDGR_TMOCHANGED	- タイマ変更														//
//					AJCSCPDGR_OKBUTTON		- ＯＫボタンによる終了												//
//--------------------------------------------------------------------------------------------------------------//
static	UI	SubDlgParamDetail(HAJCSCP pW, HWND hWndOwner, LPPOINT pPt)
{
	BOOL			rc = 0;
	AJCSCP_PORTSEL	sel;
	UI				port;
	DCB				dcb;
	COMMTIMEOUTS	tmo;
	BOOL			fNeedReOpen = FALSE;

	//	リソース選択情報退避
	sel = pW->PortSel;

	//	ＣＯＭポート情報設定（ダイアログ設定用）
	port = pW->PortNo;
	memcpy(&dcb, &pW->CommDcb, sizeof(DCB));
	memcpy(&tmo, &pW->CommTmo, sizeof(COMMTIMEOUTS));

	//	ダイアログによるポート情報設定
	rc = AjcScpDlgSetParamDetail(hWndOwner, &port, &dcb, &tmo, SCP_SYSRXBUFSIZE, pW->mskGray, pPt);

	//	ＯＫボタン押下？
	if (rc & AJCSCPDGR_OKBUTTON) {

		//	ポートがオープン状態の場合、「再オープン要」フラグ設定
		if (pW->PortSel != AJCSCP_SEL_MAILSLOT) {
			if (pW->hPort != NULL ) fNeedReOpen = TRUE;
		}
		else {
			if (pW->fTxSlotOpened ) fNeedReOpen = TRUE;
		}

		//	通信リソースが変更された場合、リソースの選択が変更された旨、フラグ設定
		if (sel != AJCSCP_SEL_COMPORT) rc |= AJCSCPDGR_SELCHANGED;

		//	リソース選択変更／ポート番号変更？
		if (rc & (AJCSCPDGR_SELCHANGED | AJCSCPDGR_PORTCHANGED)) {
			//	リソース選択前のポートクローズ
			if (fNeedReOpen) AjcScpClose(pW);
			//	ＣＯＭポート情報設定
			pW->PortNo = port;
			memcpy(&pW->CommDcb, &dcb, sizeof(DCB));
			memcpy(&pW->CommTmo, &tmo, sizeof(COMMTIMEOUTS));
			//	リソース選択情報 = ＣＯＭポート
			pW->PortSel = AJCSCP_SEL_COMPORT;
			//	ＣＯＭポート再オープン
			if (fNeedReOpen) AjcScpOpenDefault(pW);
			//	ポート番号変化通知
			ScpNtcPortStateToUser(pW, AJCSCP_PORTNO);
		}
		//	ＤＣＢ／ＴＭＯ変更？
		else if (rc & (AJCSCPDGR_DCBCHANGED | AJCSCPDGR_TMOCHANGED)) {
			//	リソース選択前のポートクローズ
			if (fNeedReOpen) AjcScpClose(pW);
			//	ＤＣＢ／ＴＭＯ情報更新
			memcpy(&pW->CommDcb, &dcb, sizeof(DCB));
			memcpy(&pW->CommTmo, &tmo, sizeof(COMMTIMEOUTS));
			//	リソース選択情報 = ＣＯＭポート
			pW->PortSel = AJCSCP_SEL_COMPORT;
			//	ＣＯＭポート再オープン
			if (fNeedReOpen) AjcScpOpenDefault(pW);
		}
	}

	return rc;
}
