﻿//**************************************************************************************************************//
//																												//
//	シリアル通信									共通定義													//
//																												//
//**************************************************************************************************************//

#define	SCP_INST_ID			0xB98C23D1

//--------------------------------------------------------------------------------------------------------------//
//	ソケットエラー(WSAEWOULDBLOCK)時のリトライ定数	（リソースが一時的に利用できなくなっている場合のリトライ）	//
//--------------------------------------------------------------------------------------------------------------//
#define		SCP_RTY_WSAEWOULDBLOCK		100		//	ソケットエラー時のリトライ回数
#define		SCP_TIM_WSAEWOULDBLOCK		50		//	ソケットエラー時のリトライ周期

//--------------------------------------------------------------------------------------------------------------//
//	内部ウインドメッセージ																						//
//--------------------------------------------------------------------------------------------------------------//
#define		WM_SCP_FORMSIL		(WM_APP + 100)

//--------------------------------------------------------------------------------------------------------------//
//	システムバッファサイズ																						//
//--------------------------------------------------------------------------------------------------------------//
#define	SCP_SYSRXBUFSIZE	2048
#define	SCP_SYSTXBUFSIZE	2048

//--------------------------------------------------------------------------------------------------------------//
//	イベント通知キューエントリ																					//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	UI		Evt;
	UBP		pDat;
	UI		lDat;
	UI		param;
} SCP_EVTINF, *PSCP_EVTINF;

//--------------------------------------------------------------------------------------------------------------//
//	グローバルワーク																							//
//--------------------------------------------------------------------------------------------------------------//
extern	ATOM	ScpClassForMSIL;

//--------------------------------------------------------------------------------------------------------------//
//	外部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
extern	UI	AjcScpDlgSetParamEasy(HWND hWnd, HAJCSCP pW, PAJCSCP_PORTSEL pSel, UIP pPort, LPDCB pDCB, BOOL *pfToDetail, PAJCSCP_SLOTINFO pSlot, PAJCSCP_SOCKINFO pSock, C_WCP pSect, UI mskRbt, UI mskGray, LPPOINT pPt);
extern	UI	AjcScpDlgSetParamDetail(HWND hWnd, UIP pPort, LPDCB pDCB, LPCOMMTIMEOUTS pTMO, UI SysRxBufSize, UI mskGray, LPPOINT pPt);

extern	WNDPROC	ScpWndProcMSIL();

extern	BOOL	ScpStartThreadTx (HAJCSCP pW);
extern	BOOL	ScpStartThreadRx (HAJCSCP pW);
extern	BOOL	ScpStartThreadObs(HAJCSCP pW);

//----- ユーザＡＰへイベント通知 -------------------------------------------------------------------------------//
extern	VO		ScpNtcPortStateToUser(HAJCSCP pW,								 UI param);
extern	VO		ScpNtcEvtToUser	 	 (HAJCSCP pW, UI EvtMask, VOP pDat, UI lDat, UI param);

//----- イベントコード変換 -------------------------------------------------------------------------------------//
extern	UI		CommEvtToScpEvt(UI CommEvt);
extern	UI		ScpEvtToCommEvt(UI ScpEvt);
extern	UI		SsepEvtToScpEvt(UI SsepEvt);
extern	UI		ScpEvtToSsepEvt(UI ScpEvt);

//----- メールスロット -----------------------------------------------------------------------------------------//
extern	BOOL	ScpCreateMySlotAndNtcErr(HAJCSCP pW);
extern	BOOL	ScpCreateMySlot(HAJCSCP pW);
extern	BOOL	ScpSaveSlot(HAJCSCP pW, LPSECURITY_ATTRIBUTES lpSecurityAttributes);

//----- ＣＯＭポート入出力ＡＰＩのラッパー ---------------------------------------------------------------------//
extern	BOOL	ScpGetMailslotInfo		(HAJCSCP pW, LPDWORD lpMaxMessageSize, LPDWORD lpNextSize, LPDWORD lpMessageCount, LPDWORD lpReadTimeout);
extern	BOOL	ScpClearCommBreak		(HAJCSCP pW);
extern	BOOL	ScpClearCommError		(HAJCSCP pW, LPDWORD lpErrors, LPCOMSTAT lpStat);
extern	BOOL	ScpEscapeCommFunction	(HAJCSCP pW, DWORD dwFunc);
extern	BOOL	ScpGetCommModemStatus	(HAJCSCP pW, LPDWORD lpModemStat);
extern	BOOL	ScpGetCommState			(HAJCSCP pW, LPDCB lpDCB);
extern	BOOL	ScpGetCommTimeouts		(HAJCSCP pW, LPCOMMTIMEOUTS lpCommTimeouts);
extern	BOOL	ScpPurgeComm			(HAJCSCP pW, DWORD dwFlags);
extern	BOOL	ScpSetCommBreak			(HAJCSCP pW);
extern	BOOL	ScpSetCommMask			(HAJCSCP pW, DWORD dwMask);
extern	BOOL	ScpSetCommState			(HAJCSCP pW, LPDCB lpDCB);
extern	BOOL	ScpSetCommTimeouts		(HAJCSCP pW, LPCOMMTIMEOUTS lpCommTimeouts);
extern	BOOL	ScpSetupComm			(HAJCSCP pW, DWORD dwInQUeue, DWORD dwOutQueue);
extern	BOOL	ScpWaitCommEvent		(HAJCSCP pW, LPDWORD lpEvtMask, LPOVERLAPPED lpOverlapped);
extern	HANDLE	ScpOpenFile				(HAJCSCP pW);
extern	BOOL	ScpCloseFile			(HAJCSCP pW);

extern	BOOL	ScpReadFile (HAJCSCP pW, LPVOID lpBuffer, DWORD dwNumberOfBytesToRead,
									 LPDWORD lpdwNumberOfBytesRead, LPOVERLAPPED lpOverLapped);

extern	BOOL	ScpWriteFile(HAJCSCP pW, LPVOID lpBuffer, DWORD dwNumberOfBytesToWrite,
									 LPDWORD lpdwNumberOfBytesWrite, LPOVERLAPPED lpOverLapped);

