﻿#include	"AjcInternal.h"
#include	"AjcSerialComPortDef.h"
//**************************************************************************************************************//
//																												//
//	ＣＯＭポート入出力								ポート設定ダイアログ（簡易）								//
//																												//
//**************************************************************************************************************//
//==============================================================================================================//
//	日英テキスト																								//
//==============================================================================================================//
#define	TTL_HEADER		LNGSEL(L" ポートパラメタ"			 , 	L" Port Parameter"					)
#define	TTL_PORT		LNGSEL(L" ポート"					 , 	L" Port"							)
#define	TTL_RATE		LNGSEL(L" 伝送レート"				 , 	L" Rate"							)
#define	TTL_DATSIZ		LNGSEL(L" データ長"					 , 	L" Data Size"						)
#define	TTL_PARITY		LNGSEL(L" パリティ"					 , 	L" Parity"							)
#define	TTL_STPBIT		LNGSEL(L" ストップビット"			 , 	L" Stop Bit"						)

#define	TTL_FLOWCTRL	LNGSEL(L"送信時フロー制御"			 , 	L"TX FLOW CONTROL"					)
#define	TTL_NOFLOW		LNGSEL(L"なし"						 , 	L"None"								)
#define	TTL_TXFLOW		LNGSEL(L"ソフトウェア ( XON / XOFF )", 	L"Software ( XON / XOFF )"			)
#define	TTL_CTSFLOW		LNGSEL(L"ハードウェア ( CTS )"		 , 	L"Hardware ( CTS )"					)
#define	TTL_DSRFLOW		LNGSEL(L"ハードウェア ( DSR )"		 , 	L"Hardware ( DSR )"					)

#define	PTY_NONE		LNGSEL(L" なし"						 , 	L" None"							)
#define	PTY_ODD			LNGSEL(L" 奇数"						 , 	L" Odd"								)
#define	PTY_EVEN		LNGSEL(L" 偶数"						 , 	L" Even"							)
#define	PTY_MARK		LNGSEL(L" マーク"					 , 	L" Mark"							)
#define	PTY_SPACE		LNGSEL(L" スペース"					 , 	L" Space"							)

#define	TTL_DETAIL		LNGSEL(L"詳細設定"					 , 	L"Detail"							)

#define	TTL_MYHOST		LNGSEL(L"自コンピュータ"			 ,	L"My Computer"						)
#define	TTL_RMTHOST		LNGSEL(L"相手コンピュータ"			 ,	L"Remote Computer"					)
#define	TTL_NAME		LNGSEL(L"名称"						 ,	L"Name"								)
#define	TTL_SLOT		LNGSEL(L"スロット"					 ,	L"Slot"								)

#define	TTL_GRP_TXDELAY	LNGSEL(L"送信速度の制限"			 ,	L"Limitation of transmission speed"	)
#define	TTL_CHK_TXDELAY	LNGSEL(L"送信速度を制限する"		 ,	L"Limitation of speed"				)
#define	TTL_LBL_TXDELAY	LNGSEL(L"送信速度"					 ,	L"Speed"							)

#define	TTL_SERVER		LNGSEL(L"相手コンピュータ （サーバ）",	L"Remote computer ( Server )"		)
#define	TTL_SERVNAME	LNGSEL(L"ホスト名 /"				 ,	L"Name /"							)
#define	TTL_IPADDR		LNGSEL(L"IPアドレス"				 ,	L"IP-Addr"							)
#define	TTL_PORTNO		LNGSEL(L"ポート番号"				 ,	L"PortNo."							)


#define	TTL_OK			LNGSEL(L"ＯＫ"						 , 	L"OK"								)
#define	TTL_CANCEL		LNGSEL(L"キャンセル"				 , 	L"Cancel"							)

//==============================================================================================================//
//	ダイアログプロシジャワーク																					//
//==============================================================================================================//
typedef struct {
	HAJCSCP			pW;					//	ＳＣＰインスタンスハンドル
	AJCSCP_PORTSEL	sel;				//	ＣＯＭポート／メールスロット選択情報
	UI				port;				//	ポート番号
	DCB				dcb;				//	ＤＣＢ
	BOOL			fChangeToDetail;	//	詳細設定へ移行
	AJCSCP_SLOTINFO	slot;				//	メールスロット情報
	AJCSCP_SOCKINFO	sock;				//	ソケット情報
	WC				sect[64];			//	プロファイルセクション
	UI				mskRbt;				//	グレー化ラジオボタンのマスク
	UI				mskGray;			//	グレー化項目のマスク

	//---- ウインド位置情報 -----//
	BOOL			fWndPos;			//	ウインド位置情報有無フラグ
	POINT			ptWnd;				//	Ｘ，Ｙ位置（スクリーン座標）

	//---- ワーク ---------------//
	POINT			ptGrp;				//	グループ項目の左上座標
	UI				SvPortNo;			//	ポート選択中のポート番号退避
} DLGPROP, *LPDLGPROP;

//==============================================================================================================//
//	スタティック領域																							//
//==============================================================================================================//
static	const	WC	WndProp[] = L"KWLSCP_PROP";
static			UI	lang=0;

//==============================================================================================================//
//	内部サブ関数																								//
//==============================================================================================================//
AJC_DLGPROC_DEF(Easy);
static	VO		DispCaption			(HWND hDlg, LPDLGPROP pdp);
static	VO		SetGray				(HWND hDlg, UI id, BOOL fGray);
static	VO		SetPortListToCBO	(HWND hDlg, UI CurrentPort);
static	VO		SetDcbToDialog		(HWND hDlg, LPDLGPROP pdp);
static	BOOL	SetDialogToDcb		(HWND hDlg, LPDLGPROP pdp);
static	VO		SetSlotToDialog		(HWND hDlg, LPDLGPROP pdp);
static	BOOL	SetDialogToSlot		(HWND hDlg, LPDLGPROP pdp);
static	VO		SetSocketToDialog	(HWND hDlg, LPDLGPROP pdp);
static	BOOL	SetDialogToSocket	(HWND hDlg, LPDLGPROP pdp);
static	VO		ShowDevName			(HWND hDlg, UI pno);

extern	BOOL	ScpCreateMySlot(HAJCSCP pW);

//==============================================================================================================//
//	ダイアログボックスによる、通信パラメタ編集																	//
//																												//
//	引数	：	hWnd		- オーナーウインドのウインドハンドル												//
//				pSel		- ＣＯＭポート／メールスロット／ソケット選択情報									//
//				pPort		- 初期ポート番号／選択されたポート番号(1～255)を格納するバッファのアドレス			//
//				pDCB		- 初期ＤＣＢ値　／設定したＤＣＢ値を格納するバッファのアドレス						//
//				pfToDetail	- 詳細設定への移行フラグを格納するバッファポインタ（不要時はNULL)					//
//				pSlot		- メールスロット情報																//
//				pSock		- ソケット情報																		//
//				pSect		- プロファイルセクション															//
//				mskRbt		- ＣＯＭポート／メールスロット選択ボタンのマスク									//
//				mskGray		- グレー（入力を受け付けない）項目指定												//
//				pPt			- ダイアログ表示位置（ＮＵＬＬ時は無効）											//
//																												//
//	戻り値	：	≠０：ＯＫボタンで終了	Bit7 ( AJCSCPDGR_OKBUTTON	  ) - ＯＫボタンで終了						//
//										Bit6 ( AJCSCPDGR_PORTCHANGED  ) - ポート番号変更						//
//										Bit5 ( AJCSCPDGR_DCBCHANGED   ) - ＤＣＢ情報変更						//
//																												//
//				＝０：CANCELボタンで終了																		//
//==============================================================================================================//
UI	AjcScpDlgSetParamEasy(HWND hWnd, HAJCSCP pW, PAJCSCP_PORTSEL pSel,
												UIP pPort, LPDCB pDCB, BOOL *pfToDetail,
												PAJCSCP_SLOTINFO pSlot,
												PAJCSCP_SOCKINFO pSock,
												C_WCP pSect, UI mskRbt, UI mskGray, LPPOINT pPt)
{
	UI			rc = 0;
	DLGPROP		dp;

	memset(&dp, 0, sizeof dp);										//	ダイアログプロシジャ用ワーク設定
	dp.pW		= pW;												//		SCPインスタンスハンドル
	dp.sel		= *pSel;											//		COM-Port / MailSlot Selection
	dp.port		= *pPort;											//		編集用ポート番号
	memcpy(&dp.dcb, pDCB, sizeof dp.dcb);							//		編集用ＤＣＢ情報
	dp.fChangeToDetail = FALSE;										//		詳細設定へ移行しない
	memcpy(&dp.slot, pSlot, sizeof(AJCSCP_SLOTINFO));				//		メールスロット情報
	memcpy(&dp.sock, pSock, sizeof(AJCSCP_SOCKINFO));				//		ソケット情報
	if (pPt != NULL) {
		dp.fWndPos = TRUE;
		dp.ptWnd.x = pPt->x;
		dp.ptWnd.y = pPt->y;
	}
	if (pSect != NULL) {											//		プロファイルセクション
		AjcSnPrintF(dp.sect, AJCTSIZE(dp.sect), L"%s", pSect);
	}
	dp.mskRbt  = mskRbt;											//		グレー化ラジオボタンマスク
	dp.mskGray = mskGray;											//		グレー化項目マスク

	if (DialogBoxParam(hDllInst, MAKEINTRESOURCE(IDD_SCP_PORTPARAM),//	ダイアログボックス実行，ＯＫボタン押下？
			hWnd, (DLGPROC)AJC_DLGPROC_NAME(Easy), (LPARAM)&dp) == IDOK) {
		rc |= AJCSCPDGR_OKBUTTON;									//		戻り値：ＯＫボタンによる終了
		switch (dp.sel) {
		  case AJCSCP_SEL_COMPORT:									//		ＣＯＭポートの設定
			*pSel = AJCSCP_SEL_COMPORT;								//			ＣＯＭポート設定の旨、設定
			if (dp.port != *pPort) {								//			ポート番号変更？
				rc |= AJCSCPDGR_PORTCHANGED;						//				戻り値（ポート変更インジケータ）設定
			}
			if (memcmp(&dp.dcb, pDCB, sizeof dp.dcb) != 0) {		//			ＤＣＢ変更？
				rc |= AJCSCPDGR_DCBCHANGED;							//				戻り値（ＤＣＢ変更インジケータ）設定
			}
			*pPort = dp.port;										//			設定ポート番号設定
			memcpy(pDCB, &dp.dcb, sizeof *pDCB);					//			設定ＤＣＢ値コピー
			if (pfToDetail != NULL) *pfToDetail = FALSE;			//			詳細設定への移行しない旨、フラグを返す
			break;

		  case AJCSCP_SEL_MAILSLOT:									//		メールスロットの設定
			if (memcmp(&dp.slot, pSlot, sizeof(AJCSCP_SLOTINFO)) != 0) {	//	メールスロット情報変更？
				rc |= AJCSCPDGR_SLOTCHANGED;						//				戻り値（メールスロット情報変更インジケータ）設定
			}
			*pSel = AJCSCP_SEL_MAILSLOT;							//			メールスロット設定の旨、設定
			memcpy(pSlot, &dp.slot, sizeof(AJCSCP_SLOTINFO));		//			メールスロット情報コピー
			break;

		  case AJCSCP_SEL_SOCKET:									//		ソケットの設定
			if (wcsicmp(dp.sock.ServName, pSock->ServName) != 0 ||	//			ソケット情報変更？
				dp.sock.PortNo != pSock->PortNo) {
				rc |= AJCSCPDGR_SOCKCHANGED;						//				戻り値（ソケット情報変更インジケータ）設定
			}
			*pSel = AJCSCP_SEL_SOCKET;								//			ソケット設定の旨、設定
			memcpy(pSock, &dp.sock, sizeof(AJCSCP_SOCKINFO));		//			ソケット情報コピー
			break;
		}
	}
	else {															//	キャンセルボタン押下／ウインドクローズ？
		if (pfToDetail != NULL) *pfToDetail = dp.fChangeToDetail;	//		詳細設定への移行フラグを返す
		rc = 0;														//		戻り値：キャンセル終了
	}

	return rc;
}
//==============================================================================================================//
//																												//
//	ダイアログ・プロシージャ																					//
//																												//
//==============================================================================================================//
//----- 自コンピュータスロットのオープン状態表示 ---------------------------------------------------------------//
static	VO		ShowMySlotState(HWND hDlg)
{
	LPDLGPROP	pdp = (LPDLGPROP)GetProp(hDlg, WndProp);

	if (pdp->pW->hSlot != NULL) {
		AjcSetDlgItemStr(hDlg, IDC_TXT_MYSLOT_STATE, LNGSEL(L"自コンピュータ・スロットはオープン状態", L"My computer slot is opened."));
		AjcSetDlgItemStr(hDlg, IDC_CMD_MYSLOT_OPEN , LNGSEL(L"自コンピュータスロットをクローズする"	 , L"Close my computer slot."	 ));
	}
	else {
		AjcSetDlgItemStr(hDlg, IDC_TXT_MYSLOT_STATE, LNGSEL(L"自コンピュータ・スロットはクローズ状態", L"My computer slot is closed."));
		AjcSetDlgItemStr(hDlg, IDC_CMD_MYSLOT_OPEN , LNGSEL(L"自コンピュータスロットをオープンする"  , L"Open my computer slot."	  ));
	}
}
//----- ダイアログ初期化 ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Easy, WM_INITDIALOG			)
{
	LPDLGPROP	pdp;
	RECT		rcDlg, rcGrp;
	HWND		hEdit;

	pdp = (LPDLGPROP)lParam;
	SetProp(hDlg, WndProp, (HANDLE)pdp);

	//	アイコン設定
	SendMessage(hDlg, WM_SETICON, ICON_SMALL, (LPARAM)hIcoApp);

	//	ダイアログボックスのサイズ設定
	GetWindowRect(hDlg, &rcDlg);
	GetWindowRect(GetDlgItem(hDlg, IDC_GRP_MAILSLOT), &rcGrp);
	if (pdp->fWndPos)
		SetWindowPos(hDlg, NULL, pdp->ptWnd.x, pdp->ptWnd.y, rcGrp.left - rcDlg.left, rcDlg.bottom - rcDlg.top, 0		  );
	else
		SetWindowPos(hDlg, NULL, 0			 , 0		   , rcGrp.left - rcDlg.left, rcDlg.bottom - rcDlg.top, SWP_NOMOVE);

	//	ソケットのポート番号コンボボックスで、数字のみ入力可能とする
	if (hEdit = AjcSbcGetEditCtrlInComboBox(GetDlgItem(hDlg, IDC_CBO_PORTNO))) {
		MAjcSetWindowLong(hEdit, GWL_STYLE, (int)MAjcGetWindowLong(hEdit, GWL_STYLE) | ES_NUMBER);
	}

	//	グループ項目の左上座標設定
	GetClientRect(hDlg, &rcDlg);
	GetWindowRect(GetDlgItem(hDlg, IDC_GRP_COMPORT), &rcGrp);
	pdp->ptGrp.x = rcGrp.left; pdp->ptGrp.y = rcGrp.top;
	ScreenToClient(hDlg, &pdp->ptGrp);

	//	日英キャプション設定
	DispCaption(hDlg, pdp);

	//	ツールボックス
	AjcTipTextAdd(GetDlgItem(hDlg, IDC_CBO_RMTHOST), 
			LNGSEL(TEXT("\x1B[31m空白を設定してください（リモート Mailslot プロトコル はWindows 11 バージョン 24H2 以降では既定で使用不可となりました）"),
			TEXT("\x1B[31mPlease set blank(The Remote Mailslot Protocol is disabled by default in Windows 11 version 24H2 and later.)")));

	//	ＣＯＭポート／メールスロット／ソケット選択ラジオボタンの全てがグレー化の場合ＣＯＭポートを仮定
	if (pdp->mskRbt == (AJCSCPRBT_ComPort | AJCSCPRBT_MailSlot | AJCSCPRBT_Socket)) {
		pdp->mskRbt = AJCSCPRBT_ComPort;
	}
	//	選択項目がグレーの場合、非グレー項目に変更
	if (((pdp->mskRbt & AJCSCPRBT_ComPort ) && pdp->sel == AJCSCP_SEL_COMPORT ) ||
		((pdp->mskRbt & AJCSCPRBT_MailSlot) && pdp->sel == AJCSCP_SEL_MAILSLOT) ||
		((pdp->mskRbt & AJCSCPRBT_Socket  ) && pdp->sel == AJCSCP_SEL_SOCKET  )) {
		if		(!(pdp->mskRbt & AJCSCPRBT_ComPort )) pdp->sel = AJCSCP_SEL_COMPORT;
		else if (!(pdp->mskRbt & AJCSCPRBT_MailSlot)) pdp->sel = AJCSCP_SEL_MAILSLOT;
		else										  pdp->sel = AJCSCP_SEL_SOCKET;
	}
	//	ＣＯＭポート／メールスロット／ソケット選択ラジオボタングレー化
	AjcEnableDlgItem(hDlg, IDC_RBT_COMPORT , (pdp->mskRbt & AJCSCPRBT_ComPort ) == 0);
	AjcEnableDlgItem(hDlg, IDC_RBT_MAILSLOT, (pdp->mskRbt & AJCSCPRBT_MailSlot) == 0);
	AjcEnableDlgItem(hDlg, IDC_RBT_SOCKET  , (pdp->mskRbt & AJCSCPRBT_Socket  ) == 0);

	//	ＣＯＭポート／メールスロット選択ラジオボタン設定
	AjcSetDlgItemChk(hDlg, IDC_RBT_COMPORT , pdp->sel == AJCSCP_SEL_COMPORT );
	AjcSetDlgItemChk(hDlg, IDC_RBT_MAILSLOT, pdp->sel == AJCSCP_SEL_MAILSLOT);
	AjcSetDlgItemChk(hDlg, IDC_RBT_SOCKET  , pdp->sel == AJCSCP_SEL_SOCKET	);

	//	コンボボックスへＣＯＭポートリストを設定
	SetPortListToCBO(hDlg, pdp->port);

	//	グレー化項目設定
	SetGray(hDlg, IDC_CBO_PORT		, pdp->mskGray & AJCSCPGRY_Port);
	SetGray(hDlg, IDC_CBO_RATE		, pdp->mskGray & AJCSCPGRY_BaudRate);
	SetGray(hDlg, IDC_CBO_DATSIZ	, pdp->mskGray & AJCSCPGRY_ByteSize);
	SetGray(hDlg, IDC_CBO_PARI		, pdp->mskGray & AJCSCPGRY_Parity);
	SetGray(hDlg, IDC_CBO_STPBIT	, pdp->mskGray & AJCSCPGRY_StopBits);
	SetGray(hDlg, IDC_RBT_NOFLOW	, (pdp->mskGray & AJCSCPGRY_TxFlowControl) == AJCSCPGRY_TxFlowControl);
	SetGray(hDlg, IDC_RBT_TXFLOW	, pdp->mskGray & AJCSCPGRY_fOutX);
	SetGray(hDlg, IDC_RBT_CTSFLOW	, pdp->mskGray & AJCSCPGRY_fOutxCtsFlow);
	SetGray(hDlg, IDC_RBT_DSRFLOW	, pdp->mskGray & AJCSCPGRY_fOutxDsrFlow);
	SetGray(hDlg, IDC_CMD_DETAIL	, pdp->mskGray & AJCSCPGRY_SetDetail);

	//	標準ボーレートリスト
	SendDlgItemMessage(hDlg, IDC_CBO_RATE, CB_INSERTSTRING, 0, (LPARAM)L"    300");
	SendDlgItemMessage(hDlg, IDC_CBO_RATE, CB_INSERTSTRING, 1, (LPARAM)L"    600");
	SendDlgItemMessage(hDlg, IDC_CBO_RATE, CB_INSERTSTRING, 2, (LPARAM)L"   1200");
	SendDlgItemMessage(hDlg, IDC_CBO_RATE, CB_INSERTSTRING, 3, (LPARAM)L"   2400");
	SendDlgItemMessage(hDlg, IDC_CBO_RATE, CB_INSERTSTRING, 4, (LPARAM)L"   4800");
	SendDlgItemMessage(hDlg, IDC_CBO_RATE, CB_INSERTSTRING, 5, (LPARAM)L"   9600");
	SendDlgItemMessage(hDlg, IDC_CBO_RATE, CB_INSERTSTRING, 6, (LPARAM)L"  14400");
	SendDlgItemMessage(hDlg, IDC_CBO_RATE, CB_INSERTSTRING, 7, (LPARAM)L"  19200");
	SendDlgItemMessage(hDlg, IDC_CBO_RATE, CB_INSERTSTRING, 8, (LPARAM)L"  38400");
	SendDlgItemMessage(hDlg, IDC_CBO_RATE, CB_INSERTSTRING, 9, (LPARAM)L"  57600");
	SendDlgItemMessage(hDlg, IDC_CBO_RATE, CB_INSERTSTRING,10, (LPARAM)L" 115200");

	//	パリティ種別リスト
	SendDlgItemMessage(hDlg, IDC_CBO_PARI  , CB_INSERTSTRING, 0, (LPARAM)PTY_NONE);
	SendDlgItemMessage(hDlg, IDC_CBO_PARI  , CB_INSERTSTRING, 1, (LPARAM)PTY_ODD);
	SendDlgItemMessage(hDlg, IDC_CBO_PARI  , CB_INSERTSTRING, 2, (LPARAM)PTY_EVEN);
	SendDlgItemMessage(hDlg, IDC_CBO_PARI  , CB_INSERTSTRING, 3, (LPARAM)PTY_MARK);
	SendDlgItemMessage(hDlg, IDC_CBO_PARI  , CB_INSERTSTRING, 4, (LPARAM)PTY_SPACE);

	//	データビット数リスト
	SendDlgItemMessage(hDlg, IDC_CBO_DATSIZ, CB_INSERTSTRING, 0, (LPARAM)L" 5 bits");
	SendDlgItemMessage(hDlg, IDC_CBO_DATSIZ, CB_INSERTSTRING, 1, (LPARAM)L" 6 bits");
	SendDlgItemMessage(hDlg, IDC_CBO_DATSIZ, CB_INSERTSTRING, 2, (LPARAM)L" 7 bits");
	SendDlgItemMessage(hDlg, IDC_CBO_DATSIZ, CB_INSERTSTRING, 3, (LPARAM)L" 8 bits");

	//	ストップビット数リスト
	SendDlgItemMessage(hDlg, IDC_CBO_STPBIT, CB_INSERTSTRING, 0, (LPARAM)L" 1 bit");
	SendDlgItemMessage(hDlg, IDC_CBO_STPBIT, CB_INSERTSTRING, 1, (LPARAM)L" 2 bits");

	//	ＤＣＢ情報をダイアログへ反映
	SetDcbToDialog(hDlg, pdp);

	//	メールスロット，ソケット情報の項目数制限付きコンボボックス設定
	AjcSbcComboBox(GetDlgItem(hDlg, IDC_CBO_MYSLOT	), 20, AJCTSIZE(pdp->slot.MySlotName ) - 1);
	AjcSbcComboBox(GetDlgItem(hDlg, IDC_CBO_RMTHOST ), 20, AJCTSIZE(pdp->slot.RmtHostName) - 1);
	AjcSbcComboBox(GetDlgItem(hDlg, IDC_CBO_RMTSLOT ), 20, AJCTSIZE(pdp->slot.RmtSlotName) - 1);
	AjcSbcComboBox(GetDlgItem(hDlg, IDC_CBO_SERVNAME), 20, AJCTSIZE(pdp->sock.ServName	 ) - 1);
	AjcSbcComboBox(GetDlgItem(hDlg, IDC_CBO_PORTNO	), 20, AJCMAX_PORTNAME_LENGTH		   - 1);

	//	メールスロット，自コンピュータ・スロット オープン状態設定
	ShowMySlotState(hDlg);

	//	メールスロット，ソケット情報の項目数制限付きコンボボックスのテキスト比較方法設定
	AjcSbcSetCompExact(GetDlgItem(hDlg, IDC_CBO_MYSLOT	), FALSE);
	AjcSbcSetCompExact(GetDlgItem(hDlg, IDC_CBO_RMTHOST ), FALSE);
	AjcSbcSetCompExact(GetDlgItem(hDlg, IDC_CBO_RMTSLOT ), FALSE);
	AjcSbcSetCompExact(GetDlgItem(hDlg, IDC_CBO_SERVNAME), FALSE);
	AjcSbcSetCompExact(GetDlgItem(hDlg, IDC_CBO_PORTNO	), FALSE);

	//	メールスロット,ソケット情報のコンボボックス項目ロード
	if (pdp->sect[0]) {
		AjcSbcLoadItems(GetDlgItem(hDlg, IDC_CBO_MYSLOT  ), pdp->sect);
		AjcSbcLoadItems(GetDlgItem(hDlg, IDC_CBO_RMTHOST ), pdp->sect);
		AjcSbcLoadItems(GetDlgItem(hDlg, IDC_CBO_RMTSLOT ), pdp->sect);
		AjcSbcLoadItems(GetDlgItem(hDlg, IDC_CBO_SERVNAME), pdp->sect);
		AjcSbcLoadItems(GetDlgItem(hDlg, IDC_CBO_PORTNO  ), pdp->sect);
	}

	//	メールスロット,ソケット情報をダイアログへ反映
	SetSlotToDialog  (hDlg, pdp);
	SetSocketToDialog(hDlg, pdp);

	//	ＣＯＭポート／メールスロット選択ラジオボタンクリック
	SendMessage(hDlg, WM_COMMAND, MAKELONG(IDC_RBT_COMPORT, BN_CLICKED), 0);

	return TRUE;
}
//----- ＣＯＭポート番号・ラジオボタン -------------------------------------------------------------------------//
AJC_DLGPROC(Easy, IDC_RBT_COMPORT		)
{
	LPDLGPROP	pdp = (LPDLGPROP)GetProp(hDlg, WndProp);

	if (HIWORD(wParam) == BN_CLICKED) {
		if		(AjcGetDlgItemChk(hDlg, IDC_RBT_COMPORT)) {
			pdp->sel = AJCSCP_SEL_COMPORT;
			AjcMoveDlgGroupToLoc(hDlg, IDC_GRP_MAILSLOT, 1000		 , 1000 	   );
			AjcMoveDlgGroupToLoc(hDlg, IDC_GRP_SOCKET  , 2000		 , 2000 	   );
			AjcMoveDlgGroupToLoc(hDlg, IDC_GRP_COMPORT , pdp->ptGrp.x, pdp->ptGrp.y);
			ShowDevName(hDlg, pdp->port);
		}
		else if (AjcGetDlgItemChk(hDlg, IDC_RBT_MAILSLOT)) {
			pdp->sel = AJCSCP_SEL_MAILSLOT;
			AjcMoveDlgGroupToLoc(hDlg, IDC_GRP_COMPORT , 3000		 , 3000 	   );
			AjcMoveDlgGroupToLoc(hDlg, IDC_GRP_SOCKET  , 4000		 , 4000 	   );
			AjcMoveDlgGroupToLoc(hDlg, IDC_GRP_MAILSLOT, pdp->ptGrp.x, pdp->ptGrp.y);
		}
		else if (AjcGetDlgItemChk(hDlg, IDC_RBT_SOCKET)) {
			pdp->sel = AJCSCP_SEL_SOCKET;
			AjcMoveDlgGroupToLoc(hDlg, IDC_GRP_COMPORT , 5000		 , 5000 	   );
			AjcMoveDlgGroupToLoc(hDlg, IDC_GRP_MAILSLOT, 6000		 , 6000 	   );
			AjcMoveDlgGroupToLoc(hDlg, IDC_GRP_SOCKET  , pdp->ptGrp.x, pdp->ptGrp.y);
		}
	}
	return TRUE;
}
//----- メールスロット・ラジオボタン ---------------------------------------------------------------------------//
AJC_DLGPROC(Easy, IDC_RBT_MAILSLOT		)
{
	LPDLGPROP	pdp = (LPDLGPROP)GetProp(hDlg, WndProp);

	if (HIWORD(wParam) == BN_CLICKED) {
		SendMessage(hDlg, WM_COMMAND, MAKELONG(IDC_RBT_COMPORT, BN_CLICKED), 0);
	}
	return TRUE;
}
//----- ソケット・ラジオボタン ---------------------------------------------------------------------------------//
AJC_DLGPROC(Easy, IDC_RBT_SOCKET		)
{
	LPDLGPROP	pdp = (LPDLGPROP)GetProp(hDlg, WndProp);

	if (HIWORD(wParam) == BN_CLICKED) {
		SendMessage(hDlg, WM_COMMAND, MAKELONG(IDC_RBT_COMPORT, BN_CLICKED), 0);
	}
	return TRUE;
}
//----- ポート番号・コンボボックス -----------------------------------------------------------------------------//
AJC_DLGPROC(Easy, IDC_CBO_PORT			)
{
	LPDLGPROP	pdp = (LPDLGPROP)GetProp(hDlg, WndProp);
	UI			NewPort;
	WC			ComPortName[16];

	if (pdp != NULL) {
		switch (HIWORD(wParam)) {
			case CBN_DROPDOWN:									//	●リストボックス表示開始
				//	直前の選択ポート番号初期化
				pdp->SvPortNo = -1;
				//	監視タイマ起動
				SetTimer(hDlg, 1, 100, NULL);
				break;
			case CBN_SELCHANGE:									//	●選択変更
			{	WCP		p;
				//	選択ポート設定
				memset(ComPortName, 0, sizeof ComPortName);
				GetDlgItemText(hDlg, IDC_CBO_PORT, ComPortName, AJCTSIZE(ComPortName));	//		新ポート番号取得
				p = ComPortName;														//		・
				while (!_ismbcdigit(*p) && *p != 0) p++;								//		・
				NewPort = (_wtoi(p) & 255);												//		・
				if (NewPort != pdp->port) {												//		ポート変更？
					SetDialogToDcb(hDlg, pdp);											//			ﾀﾞｲｱﾛｸﾞ編集値をDCBﾊﾞｯﾌｧへｾｯﾄ
					pdp->port = NewPort;												//			新ポート番号設定
					ShowDevName(hDlg, NewPort);											//				デバイス名表示
				}
				break;
			}
			case CBN_CLOSEUP:									//	●リストボックスが閉じられた
			case CBN_SELENDCANCEL:								//	●選択中止
			case CBN_KILLFOCUS:									//	●フォーカス喪失
			case CBN_SELENDOK:									//	●選択完了
				//	監視タイマ停止
				KillTimer(hDlg, 1);
				break;
		}
	}
	return TRUE;
}
//----- タイマ -------------------------------------------------------------------------------------------------//
AJC_DLGPROC(Easy, WM_TIMER		)
{
	LPDLGPROP	pdp = (LPDLGPROP)GetProp(hDlg, WndProp);
	WCP			p;
	UI			ix, NewPort;
	WC			ComPortName[16];

	if (pdp != NULL) {
		//	ポート選択中、リアルタイムにデバイス名表示
		if ((ix  = (int)SendMessage(GetDlgItem(hDlg, IDC_CBO_PORT), CB_GETCURSEL, 0, 0)) != CB_ERR) {
			memset(ComPortName, 0, sizeof ComPortName);
			GetDlgItemText(hDlg, IDC_CBO_PORT, ComPortName, AJCTSIZE(ComPortName));		//	ポート番号設定
			p = ComPortName;															//	・
			while (!_ismbcdigit(*p) && *p != 0) p++;									//	・
			NewPort = (_wtoi(p) & 255);													//	・
			if (NewPort != pdp->SvPortNo) {												//	直前のポート番号と異なる？
				pdp->SvPortNo = NewPort;												//		選択ポート番号退避
				ShowDevName(hDlg, NewPort);												//		デバイス名表示		
			}
		}
	}
	return TRUE;
}
//----- 詳細設定ボタン -----------------------------------------------------------------------------------------//
AJC_DLGPROC(Easy, IDC_CMD_DETAIL		)
{
	LPDLGPROP	pdp = (LPDLGPROP)GetProp(hDlg, WndProp);

	if (HIWORD(wParam) == BN_CLICKED) {
		//	詳細設定への移行フラグ設定
		pdp->fChangeToDetail = TRUE;
		//	ダイアログ終了
		RemoveProp(hDlg, WndProp);
		EndDialog(hDlg, IDCANCEL);
	}
	return TRUE;
}
//----- 自メールスロットオープン／クローズ ボタン --------------------------------------------------------------//
AJC_DLGPROC(Easy, IDC_CMD_MYSLOT_OPEN	)
{
	LPDLGPROP	pdp = (LPDLGPROP)GetProp(hDlg, WndProp);

	if (HIWORD(wParam) == BN_CLICKED) {
		//	自スロット オープン／クローズ
		if (pdp->pW->hSlot != NULL) {
			AjcScpDeleteMySlot(pdp->pW);
		}
		else {
			if (!ScpCreateMySlot(pdp->pW)) {
				WC		txt[512];
				AjcSnPrintF(txt, AJCTSIZE(txt),
					LNGSEL(L"\x1B[31m メールスロット(%s)を生成できません。\x1B[0m\n\n"
						   L"※ 同じコンピュータ上で通信する場合は、スロット名を交差設定してください\n\n"
						   L"　 例：　　　　　　　　　自プログラム側の設定     相手側の設定\n"
						   L"　 　　　自スロット名　：　　SLOT_A　　　　　　　　　SLOT_B\n"
						   L"　 　　　相手スロット名：　　SLOT_B　　　　　　　　　SLOT_A\n\n"
						   L"　このチップ表示を消すには、チップ上をクリックするか、\n"
						   L"　カーソルを外に移動して１０秒待ちます。"
						   ,
						   L"\x1B[31m Unable to generate mailslot '%s'.\x1B[0m\n\n"
						   L"* When communicating on the same computer, cross the slot names. \n\n"
						   L"  Ex.                  My-Setting          Remote-Setting\n"
						   L"    My Slot Name     -   SLOT_A              SLOT_B\n" 
						   L"    Remote Slot Name -   SLOT_B              SLOT_A\n\n"
						   L"　To turn off this chip display, click on the chip or \n"
						   L"  move the cursor out and wait 10 seconds."), pdp->pW->SlotInfo.MySlotName);
				AjcTipTextShowCenterEx(hDlg, 0, 0, txt, 10000, hDefFontFix, -1, -1, -1);
			}
		}
		//	自スロット状態表示
		ShowMySlotState(hDlg);
	}

	return TRUE;
}
//----- キャンセルボタン ---------------------------------------------------------------------------------------//
AJC_DLGPROC(Easy, IDCANCEL				)
{
	LPDLGPROP	pdp = (LPDLGPROP)GetProp(hDlg, WndProp);

	if (HIWORD(wParam) == BN_CLICKED) {
		//	ダイアログ終了
		RemoveProp(hDlg, WndProp);
		EndDialog(hDlg, IDCANCEL);
	}
	return TRUE;
}
//----- ＯＫボタン ---------------------------------------------------------------------------------------------//
AJC_DLGPROC(Easy, IDOK					)
{
	LPDLGPROP	pdp = (LPDLGPROP)GetProp(hDlg, WndProp);
	BOOL		rsu = TRUE;

	if (HIWORD(wParam) == BN_CLICKED) {
		switch (pdp->sel) {
			case AJCSCP_SEL_COMPORT:
			//	pdp->port = AjcGetDlgItemCboData(hDlg, IDC_CBO_PORT, AjcGetDlgItemCboIx(hDlg, IDC_CBO_PORT));
				//	ダイアログ設定値をＣＯＭポート情報へ反映
				rsu = SetDialogToDcb(hDlg, pdp);
				break;

			case AJCSCP_SEL_MAILSLOT:
				//	ダイアログ設定値を（ＣＢＯへ登録し）メールスロット情報へ反映
				rsu = SetDialogToSlot(hDlg, pdp);
				//	メールスロットのコンボボックス項目セーブ
				if (pdp->sect[0]) {
					AjcSbcSaveItems (GetDlgItem(hDlg, IDC_CBO_MYSLOT ), pdp->sect);
					AjcSbcSaveItems (GetDlgItem(hDlg, IDC_CBO_RMTHOST), pdp->sect);
					AjcSbcSaveItems (GetDlgItem(hDlg, IDC_CBO_RMTSLOT), pdp->sect);
				}
				break;

			case AJCSCP_SEL_SOCKET:
				//	ダイアログ設定値を（ＣＢＯへ登録し）ソケット情報へ反映
				rsu = SetDialogToSocket(hDlg, pdp);
				//	ソケットのコンボボックス項目セーブ
				if (pdp->sect[0]) {
					AjcSbcSaveItems (GetDlgItem(hDlg, IDC_CBO_SERVNAME ), pdp->sect);
					AjcSbcSaveItems (GetDlgItem(hDlg, IDC_CBO_PORTNO   ), pdp->sect);
				}
				break;
		}
		//	ダイアログ終了
		if (rsu) {
			RemoveProp(hDlg, WndProp);
			EndDialog(hDlg, IDOK);
		}
	}
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(Easy)
	AJC_DLGMAP_MSG(Easy, WM_INITDIALOG		)
	AJC_DLGMAP_MSG(Easy, WM_TIMER			)

	AJC_DLGMAP_CMD(Easy, IDC_RBT_COMPORT	)
	AJC_DLGMAP_CMD(Easy, IDC_RBT_MAILSLOT	)
	AJC_DLGMAP_CMD(Easy, IDC_RBT_SOCKET		)
	AJC_DLGMAP_CMD(Easy, IDC_CBO_PORT		)
	AJC_DLGMAP_CMD(Easy, IDC_CMD_DETAIL		)
	AJC_DLGMAP_CMD(Easy, IDC_CMD_MYSLOT_OPEN)
	AJC_DLGMAP_CMD(Easy, IDCANCEL			)
	AJC_DLGMAP_CMD(Easy, IDOK				)
AJC_DLGMAP_END


//--------------------------------------------------------------------------------------------------------------//
//	各項目のタイトル表示																						//
//--------------------------------------------------------------------------------------------------------------//
static	VO	DispCaption(HWND hDlg, LPDLGPROP pdp)
{
	SetWindowText (hDlg, TTL_HEADER);
	SetDlgItemText(hDlg, IDC_LBL_PORT	 	, TTL_PORT	  );
	SetDlgItemText(hDlg, IDC_LBL_RATE	 	, TTL_RATE	  );
	SetDlgItemText(hDlg, IDC_LBL_DATSIZ  	, TTL_DATSIZ  );
	SetDlgItemText(hDlg, IDC_LBL_PARI	 	, TTL_PARITY  );
	SetDlgItemText(hDlg, IDC_LBL_STPBIT  	, TTL_STPBIT  );
	SetDlgItemText(hDlg, IDC_GRP_FLOWCTRL	, TTL_FLOWCTRL);
	SetDlgItemText(hDlg, IDC_RBT_NOFLOW 	, TTL_NOFLOW  );
	SetDlgItemText(hDlg, IDC_RBT_TXFLOW 	, TTL_TXFLOW  );
	SetDlgItemText(hDlg, IDC_RBT_CTSFLOW	, TTL_CTSFLOW );
	SetDlgItemText(hDlg, IDC_RBT_DSRFLOW	, TTL_DSRFLOW );
	SetDlgItemText(hDlg, IDC_CMD_DETAIL		, TTL_DETAIL  );

	SetDlgItemText(hDlg, IDC_GRP_MYCOMP  	, TTL_MYHOST  );
	SetDlgItemText(hDlg, IDC_LBL_MYHOST  	, TTL_NAME	  );
	SetDlgItemText(hDlg, IDC_LBL_MYSLOT  	, TTL_SLOT	  );
	SetDlgItemText(hDlg, IDC_GRP_RMTCOMP 	, TTL_RMTHOST );
	SetDlgItemText(hDlg, IDC_LBL_RMTHOST 	, TTL_NAME	  );
	SetDlgItemText(hDlg, IDC_LBL_RMTSLOT 	, TTL_SLOT	  );
	SetDlgItemText(hDlg, IDC_CHK_TXDELAY 	, TTL_CHK_TXDELAY);
	SetDlgItemText(hDlg, IDC_LBL_TXDELAY 	, TTL_LBL_TXDELAY);

	SetDlgItemText(hDlg, IDC_GRP_MYCOMP_SOCK, TTL_MYHOST  );
	SetDlgItemText(hDlg, IDC_LBL_MYHOST_SOCK, TTL_NAME	  );
	SetDlgItemText(hDlg, IDC_LBL_SERVNAME	, TTL_SERVNAME);
	SetDlgItemText(hDlg, IDC_LBL_IPADDR		, TTL_IPADDR  );
	SetDlgItemText(hDlg, IDC_GRP_SERVER  	, TTL_SERVER  );
	SetDlgItemText(hDlg, IDC_LBL_PORTNO 	, TTL_PORTNO  );

	SetDlgItemText(hDlg, IDOK			 	, TTL_OK	  );
	SetDlgItemText(hDlg, IDCANCEL		 	, TTL_CANCEL  );
}
//--------------------------------------------------------------------------------------------------------------//
//	指定ダイアログ項目のグレー化																				//
//--------------------------------------------------------------------------------------------------------------//
static	VO	SetGray(HWND hDlg, UI id, BOOL fGray)
{
	UL	style;
	HWND	hWnd = GetDlgItem(hDlg, id);

	style = GetWindowLong(hWnd, GWL_STYLE);
	if (fGray) style |=  WS_DISABLED;
	else	   style &= ~WS_DISABLED;
	SetWindowLong(hWnd, GWL_STYLE, style);
	InvalidateRect(hWnd, NULL, FALSE);
}
//--------------------------------------------------------------------------------------------------------------//
//	コンボボックスへポートリストを設定																			//
//--------------------------------------------------------------------------------------------------------------//
static	VO	SetPortListToCBO(HWND hDlg, UI CurrentPort)
{
	UI		i, n, ix, pno;
	UB		PortMap[256];
	WC		ComPortName[64];

	n = AjcScpEnumSerialPorts(PortMap, 256, CurrentPort);
	ix = 0;
	pno = 0;
	for (i=0; i<n; i++) {
		pno = PortMap[i];
		AjcSnPrintF(ComPortName, AJCTSIZE(ComPortName), L" COM %u", pno);
		SendDlgItemMessage(hDlg, IDC_CBO_PORT, CB_INSERTSTRING, ix, (LPARAM)ComPortName);
		SendDlgItemMessage(hDlg, IDC_CBO_PORT, CB_SETITEMDATA , ix, (LPARAM)pno);
		ix++;
	}

	AjcSnPrintF(ComPortName, AJCTSIZE(ComPortName), L" COM %u", CurrentPort);
	SendDlgItemMessage(hDlg, IDC_CBO_PORT, CB_SELECTSTRING, -1, (WPARAM)ComPortName);
}

//--------------------------------------------------------------------------------------------------------------//
//	ＤＣＢ値を、ダイアログへ反映																				//
//--------------------------------------------------------------------------------------------------------------//
static	VO	SetDcbToDialog(HWND hDlg, LPDLGPROP pdp)
{
	WC	txt[32];

	if (pdp->dcb.Parity > 4) pdp->dcb.Parity = 0;
	if (pdp->dcb.ByteSize < 5 || pdp->dcb.ByteSize > 8) pdp->dcb.ByteSize = 8; 
	if (pdp->dcb.StopBits > 3) pdp->dcb.StopBits = 0;

	if		(pdp->dcb.BaudRate ==	300) SendDlgItemMessage(hDlg, IDC_CBO_RATE, CB_SETCURSEL,  0, 0);
	else if (pdp->dcb.BaudRate ==	600) SendDlgItemMessage(hDlg, IDC_CBO_RATE, CB_SETCURSEL,  1, 0);
	else if (pdp->dcb.BaudRate ==  1200) SendDlgItemMessage(hDlg, IDC_CBO_RATE, CB_SETCURSEL,  2, 0);
	else if (pdp->dcb.BaudRate ==  2400) SendDlgItemMessage(hDlg, IDC_CBO_RATE, CB_SETCURSEL,  3, 0);
	else if (pdp->dcb.BaudRate ==  4800) SendDlgItemMessage(hDlg, IDC_CBO_RATE, CB_SETCURSEL,  4, 0);
	else if (pdp->dcb.BaudRate ==  9600) SendDlgItemMessage(hDlg, IDC_CBO_RATE, CB_SETCURSEL,  5, 0);
	else if (pdp->dcb.BaudRate == 14400) SendDlgItemMessage(hDlg, IDC_CBO_RATE, CB_SETCURSEL,  6, 0);
	else if (pdp->dcb.BaudRate == 19200) SendDlgItemMessage(hDlg, IDC_CBO_RATE, CB_SETCURSEL,  7, 0);
	else if (pdp->dcb.BaudRate == 38400) SendDlgItemMessage(hDlg, IDC_CBO_RATE, CB_SETCURSEL,  8, 0);
	else if (pdp->dcb.BaudRate == 57600) SendDlgItemMessage(hDlg, IDC_CBO_RATE, CB_SETCURSEL,  9, 0);
	else if (pdp->dcb.BaudRate ==115200) SendDlgItemMessage(hDlg, IDC_CBO_RATE, CB_SETCURSEL, 10, 0);
	else  {_itow(pdp->dcb.BaudRate, txt, 10); SetDlgItemText(hDlg, IDC_CBO_RATE, txt);}
	SendMessage(hDlg, WM_COMMAND, (CBN_EDITCHANGE << 16) | IDC_CBO_RATE, 0);

	SendDlgItemMessage(hDlg, IDC_CBO_PARI  , CB_SETCURSEL, (pdp->dcb.Parity) * pdp->dcb.fParity, 0);
	SendDlgItemMessage(hDlg, IDC_CBO_DATSIZ, CB_SETCURSEL, pdp->dcb.ByteSize - 5, 0);
	SendDlgItemMessage(hDlg, IDC_CBO_STPBIT, CB_SETCURSEL, pdp->dcb.StopBits!=0, 0);

	if (pdp->dcb.fOutX == 0 && pdp->dcb.fOutxCtsFlow == 0 && pdp->dcb.fOutxDsrFlow == 0) {
		SendDlgItemMessage(hDlg, IDC_RBT_NOFLOW  , BM_SETCHECK, TRUE , 0);
	}
	else {
		SendDlgItemMessage(hDlg, IDC_RBT_NOFLOW  , BM_SETCHECK, FALSE, 0);
	}
	SendDlgItemMessage(hDlg, IDC_RBT_TXFLOW  , BM_SETCHECK, pdp->dcb.fOutX			   != 0, 0);
	SendDlgItemMessage(hDlg, IDC_RBT_CTSFLOW , BM_SETCHECK, pdp->dcb.fOutxCtsFlow	   != 0, 0);
	SendDlgItemMessage(hDlg, IDC_RBT_DSRFLOW , BM_SETCHECK, pdp->dcb.fOutxDsrFlow	   != 0, 0);

}
//--------------------------------------------------------------------------------------------------------------//
//	ダイアログで編集した値をＤＣＢバッファへ設定																//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	SetDialogToDcb(HWND hDlg, LPDLGPROP pdp)
{
	BOOL	rc = TRUE;
	WC		buf[16];

	GetDlgItemText(hDlg, IDC_CBO_RATE, buf, AJCTSIZE(buf));
	pdp->dcb.BaudRate = _wtoi(buf);

	switch (SendDlgItemMessage(hDlg, IDC_CBO_DATSIZ, CB_GETCURSEL, 0, 0)) {
		case 0:		pdp->dcb.ByteSize =    5;	break;
		case 1:		pdp->dcb.ByteSize =    6;	break;
		case 2:		pdp->dcb.ByteSize =    7;	break;
		default:	pdp->dcb.ByteSize =    8;	break;
	}
	switch (SendDlgItemMessage(hDlg, IDC_CBO_PARI, CB_GETCURSEL, 0, 0)) {
		case 0:		pdp->dcb.fParity = 0; pdp->dcb.Parity = 0;	break;
		case 1:		pdp->dcb.fParity = 1; pdp->dcb.Parity = 1;	break;
		case 2:		pdp->dcb.fParity = 1; pdp->dcb.Parity = 2;	break;
		case 3:		pdp->dcb.fParity = 1; pdp->dcb.Parity = 3;	break;
		default:	pdp->dcb.fParity = 1; pdp->dcb.Parity = 4;	break;
	}
	switch (SendDlgItemMessage(hDlg, IDC_CBO_STPBIT, CB_GETCURSEL, 0, 0)) {
		case 0:		pdp->dcb.StopBits = 0;	break;
		default:	pdp->dcb.StopBits = 2;	break;
	}
	pdp->dcb.fOutX		  = (SendDlgItemMessage(hDlg, IDC_RBT_TXFLOW   , BM_GETCHECK, 0, 0) != 0);
	pdp->dcb.fOutxCtsFlow = (SendDlgItemMessage(hDlg, IDC_RBT_CTSFLOW  , BM_GETCHECK, 0, 0) != 0);
	pdp->dcb.fOutxDsrFlow = (SendDlgItemMessage(hDlg, IDC_RBT_DSRFLOW  , BM_GETCHECK, 0, 0) != 0);

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	メールスロット情報を、ダイアログへ反映																		//
//--------------------------------------------------------------------------------------------------------------//
static	VO	SetSlotToDialog(HWND hDlg, LPDLGPROP pdp)
{
	UI			len;
	int			ix;

	//	自ホスト名設定
	len = (AJCTSIZE(pdp->slot.MyHostName));
	GetComputerName(pdp->slot.MyHostName, &len);
	AjcSetDlgItemStr(hDlg, IDC_TXT_MYHOST, pdp->slot.MyHostName);
	//	自スロット名
	if ((ix = AjcGetDlgItemCboFind(hDlg, IDC_CBO_MYSLOT, -1, pdp->slot.MySlotName, AJCCBF_EXACT)) == -1) {
		ix = 0;
		AjcSetDlgItemCboAdd(hDlg, IDC_CBO_MYSLOT, ix, pdp->slot.MySlotName, 0);
	}
	AjcSetDlgItemCboIx(hDlg, IDC_CBO_MYSLOT, ix);
	//	相手ホスト名
	if (pdp->slot.RmtHostName[0] != 0) {
		if ((ix = AjcGetDlgItemCboFind(hDlg, IDC_CBO_RMTHOST, -1, pdp->slot.RmtHostName, AJCCBF_EXACT)) == -1) {
			ix = 0;
			AjcSetDlgItemCboAdd(hDlg, IDC_CBO_RMTHOST, ix, pdp->slot.RmtHostName, 0);
		}
		AjcSetDlgItemCboIx(hDlg, IDC_CBO_RMTHOST, ix);
	}
	else {
		AjcSetDlgItemCboAdd(hDlg, IDC_CBO_RMTHOST, 0, L"", 0);
		AjcSetDlgItemCboIx (hDlg, IDC_CBO_RMTHOST, 0);
	}
	//	相手スロット名
	if ((ix = AjcGetDlgItemCboFind(hDlg, IDC_CBO_RMTSLOT, -1, pdp->slot.RmtSlotName, AJCCBF_EXACT)) == -1) {
		ix = 0;
		AjcSetDlgItemCboAdd(hDlg, IDC_CBO_RMTSLOT, ix, pdp->slot.RmtSlotName, 0);
	}
	AjcSetDlgItemCboIx(hDlg, IDC_CBO_RMTSLOT, ix);
	//	送信速度制限チェックボックス
	AjcSetDlgItemChk (hDlg, IDC_CHK_TXDELAY, pdp->slot.fTxDelay);
	//	制限速度
	AjcSetDlgItemUInt(hDlg, IDC_INP_TXDELAY, pdp->slot.TxDelayBPS);
}
//--------------------------------------------------------------------------------------------------------------//
//	ダイアログ設定値を（ＣＢＯへ登録し）メールスロット情報へ反映												//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	SetDialogToSlot(HWND hDlg, LPDLGPROP pdp)
{
	BOOL		rc = TRUE;
	int			ix;

	//	自ホスト名設定
	AjcGetDlgItemStr(hDlg, IDC_TXT_MYHOST, pdp->slot.MyHostName, AJCTSIZE(pdp->slot.MyHostName));
	//	自スロット名
//	memset(pdp->slot.MySlotName, 0, sizeof pdp->slot.MySlotName);
	AjcGetDlgItemStr	(hDlg, IDC_CBO_MYSLOT, pdp->slot.MySlotName, AJCTSIZE(pdp->slot.MySlotName));
	AjcSetDlgItemCboAdd (hDlg, IDC_CBO_MYSLOT,	0, pdp->slot.MySlotName, 0);
	if ((ix = AjcGetDlgItemCboFind(hDlg, IDC_CBO_MYSLOT, -1, pdp->slot.MySlotName, AJCCBF_EXACT)) >= 0) {
		AjcSetDlgItemCboIx(hDlg, IDC_CBO_MYSLOT, ix);
	}

	//	相手ホスト名
//	memset(pdp->slot.RmtHostName, 0, sizeof pdp->slot.RmtHostName);
	AjcGetDlgItemStr	(hDlg, IDC_CBO_RMTHOST, pdp->slot.RmtHostName, AJCTSIZE(pdp->slot.RmtHostName));
	AjcSetDlgItemCboAdd (hDlg, IDC_CBO_RMTHOST,  0, pdp->slot.RmtHostName, 0);
	if ((ix = AjcGetDlgItemCboFind(hDlg, IDC_CBO_RMTHOST, -1, pdp->slot.RmtHostName, AJCCBF_EXACT)) >= 0) {
		AjcSetDlgItemCboIx(hDlg, IDC_CBO_RMTHOST, ix);
	}
	//	相手スロット名
//	memset(pdp->slot.RmtSlotName, 0, sizeof pdp->slot.RmtSlotName);
	AjcGetDlgItemStr	(hDlg, IDC_CBO_RMTSLOT, pdp->slot.RmtSlotName, AJCTSIZE(pdp->slot.RmtSlotName));
	AjcSetDlgItemCboAdd (hDlg, IDC_CBO_RMTSLOT,  0, pdp->slot.RmtSlotName, 0);
	if ((ix = AjcGetDlgItemCboFind(hDlg, IDC_CBO_RMTSLOT, -1, pdp->slot.RmtSlotName, AJCCBF_EXACT)) >= 0) {
		AjcSetDlgItemCboIx(hDlg, IDC_CBO_RMTSLOT, ix);
	}
	//	送信速度制限チェックボックス
	pdp->slot.fTxDelay = AjcGetDlgItemChk(hDlg, IDC_CHK_TXDELAY);
	//	制限速度
	pdp->slot.TxDelayBPS = AjcGetDlgItemUInt(hDlg, IDC_INP_TXDELAY);

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	ソケット情報を、ダイアログへ反映																			//
//--------------------------------------------------------------------------------------------------------------//
static	VO	SetSocketToDialog(HWND hDlg, LPDLGPROP pdp)
{
	int			ix;
	UI			len;
	WC			szHost[AJCMAX_HOSTNAME_LENGTH];
	WC			szPort[AJCMAX_PORTNAME_LENGTH];

	//	自ホスト名設定
	len = (sizeof szHost);
	GetComputerName(szHost, &len);
	AjcSetDlgItemStr(hDlg, IDC_TXT_MYHOST_SOCK, szHost);

	//	相手ホスト名（サーバ名）
	if (pdp->sock.ServName[0] != 0) {
		if ((ix = AjcGetDlgItemCboFind(hDlg, IDC_CBO_SERVNAME, -1, pdp->sock.ServName, AJCCBF_EXACT)) == -1) {
			ix = 0;
			AjcSetDlgItemCboAdd(hDlg, IDC_CBO_SERVNAME, ix, pdp->sock.ServName, 0);
		}
		AjcSetDlgItemCboIx(hDlg, IDC_CBO_SERVNAME, ix);
	}
	//	ポート
	AjcSnPrintF(szPort, AJCTSIZE(szPort), L"%u", pdp->sock.PortNo);
	if ((ix = AjcGetDlgItemCboFind(hDlg, IDC_CBO_PORTNO, -1, szPort, AJCCBF_EXACT)) == -1) {
		ix = 0;
		AjcSetDlgItemCboAdd(hDlg, IDC_CBO_PORTNO, ix, szPort, 0);
	}
	AjcSetDlgItemCboIx(hDlg, IDC_CBO_PORTNO, ix);
}
//--------------------------------------------------------------------------------------------------------------//
//	ダイアログ設定値を（ＣＢＯへ登録し）ソケット情報へ反映														//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	SetDialogToSocket(HWND hDlg, LPDLGPROP pdp)
{
	BOOL		rc = TRUE;
	int			ix;
	UI			pno;
	WC			szPort[AJCMAX_PORTNAME_LENGTH];

	//	相手ホスト名（サーバ名）
	AjcGetDlgItemStr	(hDlg, IDC_CBO_SERVNAME, pdp->sock.ServName, AJCTSIZE(pdp->sock.ServName));
	AjcSetDlgItemCboAdd (hDlg, IDC_CBO_SERVNAME,  0, pdp->sock.ServName, 0);
	if ((ix = AjcGetDlgItemCboFind(hDlg, IDC_CBO_SERVNAME, -1, pdp->sock.ServName, AJCCBF_EXACT)) >= 0) {
		AjcSetDlgItemCboIx(hDlg, IDC_CBO_SERVNAME, ix);
	}
	//	ポート
	AjcGetDlgItemStr	(hDlg, IDC_CBO_PORTNO, szPort, AJCTSIZE(szPort));
	AjcStrTrim			(			   szPort, szPort, AJCTSIZE(szPort));
	if ((pno = _wtoi(szPort)) <= 65535) {
		if (szPort[0] != 0) {
			AjcSetDlgItemCboAdd (hDlg, IDC_CBO_PORTNO,	0, szPort, 0);
			if ((ix = AjcGetDlgItemCboFind(hDlg, IDC_CBO_PORTNO, -1, szPort, AJCCBF_EXACT)) >= 0) {
				AjcSetDlgItemCboIx(hDlg, IDC_CBO_PORTNO, ix);
				pdp->sock.PortNo = pno;
			}
		}
	}
	else {
		WC		txt[64];
		AjcSnPrintF(txt, AJCTSIZE(txt), LNGSEL(L"不正なポート番号(%s)です。", L"Illegal port number(%s)."), szPort);
		MessageBox(hDlg, txt, L"Socket", MB_ICONERROR);
		rc = FALSE;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	ＣＯＭポートのデバイス名表示																				//
//--------------------------------------------------------------------------------------------------------------//
static	VO	ShowDevName(HWND hDlg, UI pno)
{
	WC		name[16];
	WC		dev [256];
//	WC		txt [300];

	AjcSnPrintF(name, AJCTSIZE(name), L"COM%d", pno);

	if (AjcScpGetPortDevName(name, dev, AJCTSIZE(dev))) {
	//	AjcSnPrintF(txt, AJCTSIZE(txt), L"%s : %s", name, dev);
		AjcSetDlgItemStr(hDlg, IDC_TXT_DEVNAME, dev);
	}
	else {
		AjcSetDlgItemStr(hDlg, IDC_TXT_DEVNAME, L"<No device>");
	}
}

