﻿#include	"AjcInternal.h"
#include	"AjcSerialComPortDef.h"
#include	<commctrl.h>
//**************************************************************************************************************//
//																												//
//	ＣＯＭポート入出力								ポート設定ダイアログ（詳細）								//
//																												//
//**************************************************************************************************************//

//==============================================================================================================//
//	日英テキスト																								//
//==============================================================================================================//
#define	STR_HEADER						LNGSEL(L" ＤＣＢ／タイムアウト設定"				, L"SET DCB/TIMEOUTS"				)

#define	STR_LBL_PORT					LNGSEL(L" ポート番号"							, L" Port Number"					)
#define	STR_LBL_BaudRate				LNGSEL(L" 伝送レート (BaudRate)"				, L" Rate (BaudRate)"				)
#define	STR_LBL_ByteSize				LNGSEL(L" データ長 (ByteSize)"					, L" Data Length (ByteSize)"		)
#define	STR_LBL_StopBits				LNGSEL(L" ストップビット (StopBits)"			, L" Stop Bits (StopBits)"			)

#define	STR_GRP_ParityCheck				LNGSEL(L"パリティビット"						, L"Parity Bit"						)
#define	STR_CHK_fParity					LNGSEL(L"パリティあり (fParity)"				, L"Enable Parity Bit (fParity)"	)
#define	STR_LBL_Parity					LNGSEL(L"パリティモード (Parity)"				, L"Parity Mode (Parity)"			)

#define	STR_GRP_TxFlowControl			LNGSEL(L"送信フロー制御"						, L"Tx Flow Control"				)
#define	STR_CHK_fOutX					LNGSEL(L"ソフトウェア XON/XOFF (fOutX)"			, L"XON/XOFF Flow Control (fOutX)"	)
#define	STR_CHK_fOutxCtsFlow			LNGSEL(L"ハードウェア CTS (fOutxCtsFlow)"		, L"CTS Flow Control (fOutxCtsFlow)")
#define	STR_CHK_fOutxDsrFlow			LNGSEL(L"ハードウェア DSR (fOutxDsrFlow)"		, L"DSR Flow Control (fOutxDsrFlow)")

#define	STR_GRP_RxFlowControl			LNGSEL(L"受信フロー制御"						, L"Rx Flow Control"				)
#define	STR_CHK_fInX					LNGSEL(L"ソフトウェア XON/XOFF (fInX)"			, L"XON/XOFF Flow Control (fInX)"	)
#define	STR_CHK_fTXContinueOnXoff		LNGSEL(L"XOFF送信後も送信を継続 (fTXContinueOnXoff)"	, \
											   L"Continue TX when XOFF sent (fTXContinueOnXoff)"	)

#define	STR_GRP_DtrControl				LNGSEL(L"DTR 制御 (fDtrControl)"				, L"DTR Control (fDtrControl)"		)
#define	STR_DtrControl_Disable			LNGSEL(L"禁止"									, L"Disable"						)
#define	STR_DtrControl_Enable			LNGSEL(L"許可"									, L"Enable"							)
#define	STR_DtrControl_Handshake		LNGSEL(L"ハンドシェーク"						, L"Handshake"						)

#define	STR_GRP_RtsControl				LNGSEL(L"RTS 制御 (fRtsControl)"				, L"RTS Control (fRtsControl)"		)
#define	STR_RtsControl_Disable			LNGSEL(L"禁止"									, L"Disable"						)
#define	STR_RtsControl_Enable			LNGSEL(L"許可"									, L"Enable"							)
#define	STR_RtsControl_Handshake		LNGSEL(L"ハンドシェーク"						, L"Handshake"						)
#define	STR_RtsControl_Toggle			LNGSEL(L"トグル"								, L"Toggle"							)

#define	STR_LBL_XoffLim					LNGSEL(L"高位しきい値 (XoffLim)"				, L"High Water Mark (XoffLim)"		)
#define	STR_LBL_XonLim					LNGSEL(L"低位しきい値 (XonLim )"				, L"Low Water Mark  (XonLim)"		)

#define	STR_GRP_OtherFlags				LNGSEL(L"その他のフラグ"						, L"Other Flags"						)
#define	STR_CHK_fBinary					LNGSEL(L"バイナリモード (fBinary)現状無効"		, L"Binary Mode (fBinary) - Invalid"	)
#define	STR_CHK_fDsrSensitivity			LNGSEL(L"DSR 検知 (fDsrSensitivity)"			, L"DSR Sensitivity (fDsrSensitivity)"	)
#define	STR_CHK_fErrorChar				LNGSEL(L"受信エラー時,文字置換 (fErrChar)"		, L"Enable Error Replacement (fErrChar)")
#define	STR_CHK_fNull					LNGSEL(L"ヌル文字受信破棄 (fNull)"				, L"Enable Null Stripping (fNull)"		)
#define	STR_CHK_fAbortOnError			LNGSEL(L"エラー時,アボート (fAbortOnError)", \
											   L"Abort all reads and writes on Error (fAbortOnError)"		)

#define	STR_GRP_Characters				LNGSEL(L"文字コード（16進）"					, L"Characters (Hexa decimal)"				)
#define	STR_LBL_XonChar					LNGSEL(L"XON  文字        (XonChar )"			, L"XON Character  (XonChar )"				)
#define	STR_LBL_XoffChar				LNGSEL(L"XOFF 文字        (XoffChar)"			, L"XOFF Character (XoffChar)"				)
#define	STR_LBL_ErrorChar				LNGSEL(L"エラー置換文字   (ErrorChar)"			, L"Error Replacement character (ErrorChar)")
#define	STR_LBL_EofChar					LNGSEL(L"データ終了文字   (EofChar)"			, L"End of input character (EofChar)"		)
#define	STR_LBL_EvtChar					LNGSEL(L"受信イベント文字 (EvtChar)"			, L"Received event character (EvtChar)"		)

#define	STR_GRP_Timeouts				LNGSEL(L"タイムアウト"							  , L"Timeouts"						 )
#define	STR_ReadIntervalTimeout			LNGSEL(L"受信バイト間タイムアウト"				  , L"Read Interval Timeout"		 )
#define	STR_ReadTotalTimeoutMultiplier	LNGSEL(L"受信総タイムアウト（操作バイト数を乗算）", L"Read Total Timeout Multiplier" )
#define	STR_ReadTotalTimeoutConstant	LNGSEL(L"受信総タイムアウト（定数）"			  , L"Read Total Timeout Constant"	 )
#define	STR_WriteTotalTimeoutMultiplier	LNGSEL(L"送信総タイムアウト（操作バイト数を乗算）", L"Write Total Timeout Multiplier")
#define	STR_WriteTotalTimeoutConstant	LNGSEL(L"送信総タイムアウト（定数）"			  , L"Write Total Timeout Constant"	 )

#define	STR_NONE						LNGSEL(L" なし"			, L" None"	)
#define	STR_ODD							LNGSEL(L" 奇数"			, L" Odd"	)
#define	STR_EVEN						LNGSEL(L" 偶数"			, L" Even"	)
#define	STR_MARK						LNGSEL(L" マーク"		, L" Mark"	)
#define	STR_SPACE						LNGSEL(L" スペース"		, L" Space"	)

#define	STR_OK							LNGSEL(L"ＯＫ"			, L"OK"				)
#define	STR_CANCEL						LNGSEL(L"キャンセル"	, L"Cancel"			)
#define	STR_SETDEFAULT					LNGSEL(L"ﾃﾞﾌｫﾙﾄ設定"	, L"Set default"	)

#define	STR_PRMERR						LNGSEL(L"不正なパラメタ設定です", L"Illegal Parameter setting")


//==============================================================================================================//
//	ダイアログプロシジャワーク																					//
//==============================================================================================================//
typedef struct {
	UI				port;				//	ポート番号（１～９）
	UI				mskGray;			//	グレー化項目のマスク
	DCB				dcb;				//	ＤＣＢ
	COMMTIMEOUTS	tmo;				//	COMMTIMEOUT
	UI				SysRxBufSize;		//	システムの受信バッファサイズ
	//---- ウインド位置情報 -----//
	BOOL			fWndPos;			//	ウインド位置情報有無フラグ
	POINT			ptWnd;				//	Ｘ，Ｙ位置（スクリーン座標）
	//---- ワーク ---------------//
	UI				SvPortNo;			//	ポート選択中のポート番号退避

} DLGPROP, *LPDLGPROP;

//==============================================================================================================//
//	スタティック領域																							//
//==============================================================================================================//
static	const	WC	WndProp[] = L"KWLSCP_PROP";
static			UI	lang=0x411;

//==============================================================================================================//
//	内部サブ関数																								//
//==============================================================================================================//
static	LRESULT	CALLBACK DlgPortDCB(HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam);
static	VO	HexaCheck(HWND hDlg, UI id, char *pChar);
static	VO	SetGrayInParity(HWND hDlg, LPDLGPROP pdp);
static	VO	SetGrayInRxFlow(HWND hDlg, LPDLGPROP pdp);
static	VO	SetGrayInXonXoffChar(HWND hDlg, LPDLGPROP pdp);
static	VO	SetGrayInErrorChar(HWND hDlg, LPDLGPROP pdp);
static	VO	SetGray(HWND hDlg, UI id, BOOL fGray);
static	VO	SetPortListToCBO(HWND hDlg, UI CurrentPort);
static	VO	SetDcbToDialog(HWND hDlg, LPDLGPROP pdp);
static	VO	SetDialogToDcb(HWND hDlg, LPDLGPROP pdp);
static	VO	ShowDevName(HWND hDlg, UI pno);


//==============================================================================================================//
//	ダイアログボックスによる、ＤＣＢ／タイムアウト編集															//
//																												//
//	引数	：	hWnd	 - オーナーウインドのウインドハンドル													//
//				pPort	 - 初期ポート番号／選択されたポート番号（1～9 : COM1～COM9）を格納するバッファのアドレス//
//				pDCB	 - 初期ＤＣＢ値　／設定したＤＣＢ値を格納するバッファのアドレス							//
//				pTMO	 - 初期タイマ値　／設定したタイマ値を格納するバッファのアドレス							//
//				SysRxBufSize - システムの受信バッファサイズ（SetupCommで設定した値）							//
//				mskGray  - グレー（入力を受け付けない）項目指定													//
//				pPt			- ダイアログ表示位置（ＮＵＬＬ時は無効）											//
//																												//
//	戻り値	：	≠０：ＯＫボタンで終了	Bit7 ( AJCSCPDGR_OKBUTTON	  ) - ＯＫボタンで終了						//
//										Bit6 ( AJCSCPDGR_PORTCHANGED  ) - ポート番号変更						//
//										Bit5 ( AJCSCPDGR_DCBCHANGED   ) - ＤＣＢ情報変更						//
//										Bit4 ( AJCSCPDGR_TMOCHANGED   ) - タイマ情報変更						//
//				＝０：CANCELボタンで終了																		//
//==============================================================================================================//
UI	AjcScpDlgSetParamDetail(HWND hWnd, UIP pPort, LPDCB pDCB,
														 LPCOMMTIMEOUTS pTMO, UI SysRxBufSize, UI mskGray, LPPOINT pPt)
{
	UI			rc = 0;
	DLGPROP		dp;

	mskGray |= AJCSCPGRY_fBinary;									//	バイナリモードフラグは、常にグレー化

	memset(&dp, 0, sizeof dp);										//	ダイアログプロシジャ用ワーク設定
	dp.port = *pPort;												//		編集用ポート番号
	dp.mskGray = mskGray;											//		グレー化項目マスク
	memcpy(&dp.dcb, pDCB, sizeof dp.dcb);							//		編集用ＤＣＢ情報
	memcpy(&dp.tmo, pTMO, sizeof dp.tmo);							//		編集用タイムアウト情報
	dp.SysRxBufSize = (SysRxBufSize < 128 ? 128 : SysRxBufSize);	//		システムの受信バッファサイズ
	if (pPt != NULL) {
		dp.fWndPos = TRUE;
		dp.ptWnd.x = pPt->x;
		dp.ptWnd.y = pPt->y;
	}

	if (DialogBoxParam(hDllInst, MAKEINTRESOURCE(IDD_SETDCB),		//	ダイアログボックス実行，ＯＫボタン押下？
					hWnd, DlgPortDCB, (LPARAM)&dp) == IDOK) {		//	・
		rc |= AJCSCPDGR_OKBUTTON;
		if (dp.port != *pPort) {									//		ポート番号変更？
			rc |= AJCSCPDGR_PORTCHANGED;							//			戻り値（ポート変更インジケータ）設定
		}
		if (memcmp(&dp.dcb, pDCB, sizeof dp.dcb) != 0) {			//		ＤＣＢ変更？
			rc |= AJCSCPDGR_DCBCHANGED;								//			戻り値（ＤＣＢ変更インジケータ）設定
		}
		if (memcmp(&dp.tmo, pTMO, sizeof dp.tmo) != 0) {			//		タイマ変更？
			rc |= AJCSCPDGR_TMOCHANGED;								//			戻り値（タイマ変更インジケータ）設定
		}
		*pPort = dp.port;											//		設定ポート番号設定
		memcpy(pDCB, &dp.dcb, sizeof *pDCB);						//		設定ＤＣＢ値コピー
		memcpy(pTMO, &dp.tmo, sizeof *pTMO);						//		設定タイマ値コピー
	}
	else {															//	キャンセルボタン押下／ウインドクローズ？
		rc = 0;														//		戻り値：キャンセル終了
	}

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
static	LRESULT	CALLBACK DlgPortDCB(HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam)
{
	BOOL				rc = FALSE;
	LPDLGPROP			pdp;
	UI					NewPort;
	WC					ComPortName[16];
	WC					txt[32];

	if (msg == WM_INITDIALOG) {pdp = (LPDLGPROP)lParam; SetProp(hDlg, WndProp, (HANDLE)pdp);}
	else					  {pdp = (LPDLGPROP)GetProp(hDlg, WndProp);}

	if (pdp == NULL) {
		return rc;
	}

	switch (msg) {
		case WM_INITDIALOG:																	//	● WM_INITDIALOG
			//	ダイアログボックスの位置設定
			if (pdp->fWndPos) {
				SetWindowPos(hDlg, NULL, pdp->ptWnd.x, pdp->ptWnd.y, 0, 0, SWP_NOSIZE);
			}

			SendMessage  (hDlg, WM_SETICON, ICON_SMALL, (LPARAM)hIcoApp);
			SetWindowText(hDlg, STR_HEADER);

			SetDlgItemText(hDlg, IDOK				, STR_OK		  );
			SetDlgItemText(hDlg, IDCANCEL			, STR_CANCEL	  );
			SetDlgItemText(hDlg, IDC_CMD_SETDEFAULT , STR_SETDEFAULT  );

			SetDlgItemText(hDlg, IDC_LBL_PORT	 , STR_LBL_PORT    );
			SetPortListToCBO(hDlg, pdp->port);

			SetDlgItemText(hDlg, IDC_LBL_BaudRate, STR_LBL_BaudRate);
			SendDlgItemMessage(hDlg, IDC_CBO_BaudRate, CB_INSERTSTRING, 0, (LPARAM)L"    300");
			SendDlgItemMessage(hDlg, IDC_CBO_BaudRate, CB_INSERTSTRING, 1, (LPARAM)L"    600");
			SendDlgItemMessage(hDlg, IDC_CBO_BaudRate, CB_INSERTSTRING, 2, (LPARAM)L"   1200");
			SendDlgItemMessage(hDlg, IDC_CBO_BaudRate, CB_INSERTSTRING, 3, (LPARAM)L"   2400");
			SendDlgItemMessage(hDlg, IDC_CBO_BaudRate, CB_INSERTSTRING, 4, (LPARAM)L"   4800");
			SendDlgItemMessage(hDlg, IDC_CBO_BaudRate, CB_INSERTSTRING, 5, (LPARAM)L"   9600");
			SendDlgItemMessage(hDlg, IDC_CBO_BaudRate, CB_INSERTSTRING, 6, (LPARAM)L"  14400");
			SendDlgItemMessage(hDlg, IDC_CBO_BaudRate, CB_INSERTSTRING, 7, (LPARAM)L"  19200");
			SendDlgItemMessage(hDlg, IDC_CBO_BaudRate, CB_INSERTSTRING, 8, (LPARAM)L"  38400");
			SendDlgItemMessage(hDlg, IDC_CBO_BaudRate, CB_INSERTSTRING, 9, (LPARAM)L"  57600");
			SendDlgItemMessage(hDlg, IDC_CBO_BaudRate, CB_INSERTSTRING,10, (LPARAM)L" 115200");


			SetDlgItemText(hDlg, IDC_LBL_ByteSize, STR_LBL_ByteSize    );
			SendDlgItemMessage(hDlg, IDC_CBO_ByteSize, CB_INSERTSTRING, 0, (LPARAM)L" 5 bits");
			SendDlgItemMessage(hDlg, IDC_CBO_ByteSize, CB_INSERTSTRING, 1, (LPARAM)L" 6 bits");
			SendDlgItemMessage(hDlg, IDC_CBO_ByteSize, CB_INSERTSTRING, 2, (LPARAM)L" 7 bits");
			SendDlgItemMessage(hDlg, IDC_CBO_ByteSize, CB_INSERTSTRING, 3, (LPARAM)L" 8 bits");

			SetDlgItemText(hDlg, IDC_LBL_StopBits, STR_LBL_StopBits);
			SendDlgItemMessage(hDlg, IDC_CBO_StopBits, CB_INSERTSTRING, 0, (LPARAM)L" 1 bit");
			SendDlgItemMessage(hDlg, IDC_CBO_StopBits, CB_INSERTSTRING, 1, (LPARAM)L" 2 bits");

			SetDlgItemText(hDlg, IDC_GRP_ParityCheck, STR_GRP_ParityCheck);
			SetDlgItemText(hDlg, IDC_CHK_fParity	, STR_CHK_fParity	 );
			SetDlgItemText(hDlg, IDC_LBL_Parity 	, STR_LBL_Parity	 );
			SendDlgItemMessage(hDlg, IDC_CBO_Parity, CB_INSERTSTRING, 0, (LPARAM)STR_NONE);
			SendDlgItemMessage(hDlg, IDC_CBO_Parity, CB_INSERTSTRING, 1, (LPARAM)STR_ODD);
			SendDlgItemMessage(hDlg, IDC_CBO_Parity, CB_INSERTSTRING, 2, (LPARAM)STR_EVEN);
			SendDlgItemMessage(hDlg, IDC_CBO_Parity, CB_INSERTSTRING, 3, (LPARAM)STR_MARK);
			SendDlgItemMessage(hDlg, IDC_CBO_Parity, CB_INSERTSTRING, 4, (LPARAM)STR_SPACE);

			SetDlgItemText(hDlg, IDC_GRP_TXFLOWCONTROL, STR_GRP_TxFlowControl);
			SetDlgItemText(hDlg, IDC_CHK_fOutX, 		STR_CHK_fOutX		 );
			SetDlgItemText(hDlg, IDC_CHK_fOutxCtsFlow , STR_CHK_fOutxCtsFlow );
			SetDlgItemText(hDlg, IDC_CHK_fOutxDsrFlow , STR_CHK_fOutxDsrFlow );

			SetDlgItemText(hDlg, IDC_GRP_RxFlowControl	  , STR_GRP_RxFlowControl	 );
			SendDlgItemMessage(hDlg, IDC_SLD_XonLim , TBM_SETRANGE, TRUE, (pdp->SysRxBufSize - 32) * 65536 + 32);
			SendDlgItemMessage(hDlg, IDC_SLD_XonLim , TBM_SETPAGESIZE, 0, 1);
			SendDlgItemMessage(hDlg, IDC_SLD_XoffLim, TBM_SETRANGE, TRUE, (pdp->SysRxBufSize - 32) * 65536 + 32);
			SendDlgItemMessage(hDlg, IDC_SLD_XoffLim, TBM_SETPAGESIZE, 0, 1);
			SetDlgItemText(hDlg, IDC_CHK_fInX			  , STR_CHK_fInX			 );
			SetDlgItemText(hDlg, IDC_CHK_fTXContinueOnXoff, STR_CHK_fTXContinueOnXoff);
			SetDlgItemText(hDlg, IDC_LBL_XoffLim		  , STR_LBL_XoffLim 		 );
			SetDlgItemText(hDlg, IDC_LBL_XonLim 		  , STR_LBL_XonLim			 );
			
			SetDlgItemText(hDlg, IDC_GRP_DtrControl 	 , STR_GRP_DtrControl	   );
			SetDlgItemText(hDlg, IDC_DtrControl_Disable  , STR_DtrControl_Disable  );
			SetDlgItemText(hDlg, IDC_DtrControl_Enable	 , STR_DtrControl_Enable   );
			SetDlgItemText(hDlg, IDC_DtrControl_Handshake, STR_DtrControl_Handshake);

			SetDlgItemText(hDlg, IDC_GRP_RtsControl 	 , STR_GRP_RtsControl	   );
			SetDlgItemText(hDlg, IDC_RtsControl_Disable  , STR_RtsControl_Disable  );
			SetDlgItemText(hDlg, IDC_RtsControl_Enable	 , STR_RtsControl_Enable   );
			SetDlgItemText(hDlg, IDC_RtsControl_Handshake, STR_RtsControl_Handshake);
			SetDlgItemText(hDlg, IDC_RtsControl_Toggle	 , STR_RtsControl_Toggle   );

			SetDlgItemText(hDlg, IDC_GRP_OtherFlags 	 , STR_GRP_OtherFlags	   );
			SetDlgItemText(hDlg, IDC_CHK_fBinary		 , STR_CHK_fBinary		   );
			SetDlgItemText(hDlg, IDC_CHK_fDsrSensitivity , STR_CHK_fDsrSensitivity );
			SetDlgItemText(hDlg, IDC_CHK_fErrorChar 	 , STR_CHK_fErrorChar	   );
			SetDlgItemText(hDlg, IDC_CHK_fNull			 , STR_CHK_fNull		   );
			SetDlgItemText(hDlg, IDC_CHK_fAbortOnError	 , STR_CHK_fAbortOnError   );

			SetDlgItemText(hDlg, IDC_GRP_Characters 	 , STR_GRP_Characters	   );
			SetDlgItemText(hDlg, IDC_LBL_XonChar		 , STR_LBL_XonChar		   );
			SetDlgItemText(hDlg, IDC_LBL_XoffChar		 , STR_LBL_XoffChar 	   );
			SetDlgItemText(hDlg, IDC_LBL_ErrorChar		 , STR_LBL_ErrorChar	   );
			SetDlgItemText(hDlg, IDC_LBL_EofChar		 , STR_LBL_EofChar		   );
			SetDlgItemText(hDlg, IDC_LBL_EvtChar		 , STR_LBL_EvtChar		   );

			SetDlgItemText(hDlg, IDC_GRP_Timeouts					, STR_GRP_Timeouts				);
			SetDlgItemText(hDlg, IDC_LBL_ReadIntervalTimeout		, STR_ReadIntervalTimeout		 );
			SetDlgItemText(hDlg, IDC_LBL_ReadTotalTimeoutMultiplier	, STR_ReadTotalTimeoutMultiplier );
			SetDlgItemText(hDlg, IDC_LBL_ReadTotalTimeoutConstant	, STR_ReadTotalTimeoutConstant	 );
			SetDlgItemText(hDlg, IDC_LBL_WriteTotalTimeoutMultiplier, STR_WriteTotalTimeoutMultiplier);
			SetDlgItemText(hDlg, IDC_LBL_WriteTotalTimeoutConstant	, STR_WriteTotalTimeoutConstant  );


			SetGray(hDlg, IDC_LBL_PORT			, pdp->mskGray & AJCSCPGRY_Port);
			SetGray(hDlg, IDC_CBO_PORT			, pdp->mskGray & AJCSCPGRY_Port);
			SetGray(hDlg, IDC_LBL_BaudRate		, pdp->mskGray & AJCSCPGRY_BaudRate);
			SetGray(hDlg, IDC_CBO_BaudRate		, pdp->mskGray & AJCSCPGRY_BaudRate);
			SetGray(hDlg, IDC_LBL_ByteSize		, pdp->mskGray & AJCSCPGRY_ByteSize);
			SetGray(hDlg, IDC_CBO_ByteSize		, pdp->mskGray & AJCSCPGRY_ByteSize);
			SetGray(hDlg, IDC_LBL_StopBits		, pdp->mskGray & AJCSCPGRY_StopBits);
			SetGray(hDlg, IDC_CBO_StopBits		, pdp->mskGray & AJCSCPGRY_StopBits);

			SetGray(hDlg, IDC_GRP_ParityCheck	,(pdp->mskGray & AJCSCPGRY_Paritys) == AJCSCPGRY_Paritys);
			SetGray(hDlg, IDC_CHK_fParity		, pdp->mskGray & AJCSCPGRY_fParity);
			SetGray(hDlg, IDC_LBL_Parity		, pdp->mskGray & AJCSCPGRY_Parity );
			SetGray(hDlg, IDC_CBO_Parity		, pdp->mskGray & AJCSCPGRY_Parity );

			SetGray(hDlg, IDC_GRP_TXFLOWCONTROL	,(pdp->mskGray & AJCSCPGRY_TxFlowControl) == AJCSCPGRY_TxFlowControl);
			SetGray(hDlg, IDC_CHK_fOutX			, pdp->mskGray & AJCSCPGRY_fOutX		);
			SetGray(hDlg, IDC_CHK_fOutxCtsFlow	, pdp->mskGray & AJCSCPGRY_fOutxCtsFlow	);
			SetGray(hDlg, IDC_CHK_fOutxDsrFlow	, pdp->mskGray & AJCSCPGRY_fOutxDsrFlow	);

			SetGray(hDlg, IDC_GRP_RxFlowControl		,(pdp->mskGray & AJCSCPGRY_RxFlowControl) == AJCSCPGRY_RxFlowControl);
			SetGray(hDlg, IDC_CHK_fInX				, pdp->mskGray & AJCSCPGRY_fInX				);
			SetGray(hDlg, IDC_LBL_XoffLim			, pdp->mskGray & AJCSCPGRY_XoffLim			);
			SetGray(hDlg, IDC_SLD_XoffLim			, pdp->mskGray & AJCSCPGRY_XoffLim			);
			SetGray(hDlg, IDC_TXT_XoffLim			, pdp->mskGray & AJCSCPGRY_XoffLim			);
			SetGray(hDlg, IDC_LBL_XonLim			, pdp->mskGray & AJCSCPGRY_XonLim			);
			SetGray(hDlg, IDC_SLD_XonLim			, pdp->mskGray & AJCSCPGRY_XonLim			);
			SetGray(hDlg, IDC_TXT_XonLim			, pdp->mskGray & AJCSCPGRY_XonLim			);
			SetGray(hDlg, IDC_CHK_fTXContinueOnXoff	, pdp->mskGray & AJCSCPGRY_fTXContinueOnXoff);

			SetGray(hDlg, IDC_GRP_DtrControl		, pdp->mskGray & AJCSCPGRY_DtrControl	);
			SetGray(hDlg, IDC_DtrControl_Disable	, pdp->mskGray & AJCSCPGRY_DtrControl	);
			SetGray(hDlg, IDC_DtrControl_Enable		, pdp->mskGray & AJCSCPGRY_DtrControl	);
			SetGray(hDlg, IDC_DtrControl_Handshake	, pdp->mskGray & AJCSCPGRY_DtrControl	);

			SetGray(hDlg, IDC_GRP_RtsControl		, pdp->mskGray & AJCSCPGRY_RtsControl	);
			SetGray(hDlg, IDC_RtsControl_Disable	, pdp->mskGray & AJCSCPGRY_RtsControl	);
			SetGray(hDlg, IDC_RtsControl_Enable		, pdp->mskGray & AJCSCPGRY_RtsControl	);
			SetGray(hDlg, IDC_RtsControl_Handshake	, pdp->mskGray & AJCSCPGRY_RtsControl	);
			SetGray(hDlg, IDC_RtsControl_Toggle		, pdp->mskGray & AJCSCPGRY_RtsControl	);

			SetGray(hDlg, IDC_GRP_OtherFlags		,(pdp->mskGray & AJCSCPGRY_Flags) == AJCSCPGRY_Flags);
			SetGray(hDlg, IDC_CHK_fBinary			, pdp->mskGray & AJCSCPGRY_fBinary			);
			SetGray(hDlg, IDC_CHK_fDsrSensitivity	, pdp->mskGray & AJCSCPGRY_fDsrSensitivity	);
			SetGray(hDlg, IDC_CHK_fErrorChar		, pdp->mskGray & AJCSCPGRY_fErrorChar		);
			SetGray(hDlg, IDC_CHK_fNull				, pdp->mskGray & AJCSCPGRY_fNull			);
			SetGray(hDlg, IDC_CHK_fAbortOnError		, pdp->mskGray & AJCSCPGRY_fAbortOnError	);

			SetGray(hDlg, IDC_GRP_Characters		,(pdp->mskGray & AJCSCPGRY_Characters) == AJCSCPGRY_Characters);
			SetGray(hDlg, IDC_LBL_XonChar								, pdp->mskGray & AJCSCPGRY_XonChar	   );
			SendDlgItemMessage(hDlg, IDC_EDT_XonChar  , EM_SETREADONLY	, pdp->mskGray & AJCSCPGRY_XonChar	, 0);
			SetGray(hDlg, IDC_LBL_XoffChar								, pdp->mskGray & AJCSCPGRY_XoffChar    );
			SendDlgItemMessage(hDlg, IDC_EDT_XoffChar , EM_SETREADONLY	, pdp->mskGray & AJCSCPGRY_XoffChar , 0);
			SetGray(hDlg, IDC_LBL_ErrorChar								, pdp->mskGray & AJCSCPGRY_ErrorChar   );
			SendDlgItemMessage(hDlg, IDC_EDT_ErrorChar, EM_SETREADONLY	, pdp->mskGray & AJCSCPGRY_ErrorChar, 0);
			SetGray(hDlg, IDC_LBL_EofChar								, pdp->mskGray & AJCSCPGRY_EofChar	   );
			SendDlgItemMessage(hDlg, IDC_EDT_EofChar  , EM_SETREADONLY	, pdp->mskGray & AJCSCPGRY_EofChar	, 0);
			SetGray(hDlg, IDC_LBL_EvtChar								, pdp->mskGray & AJCSCPGRY_EvtChar	   );
			SendDlgItemMessage(hDlg, IDC_EDT_EvtChar  , EM_SETREADONLY	, pdp->mskGray & AJCSCPGRY_EvtChar	, 0);

			SetGray(hDlg, IDC_GRP_Timeouts			,(pdp->mskGray & AJCSCPGRY_Timeouts) == AJCSCPGRY_Timeouts);

			SetGray			  (hDlg, IDC_LBL_ReadIntervalTimeout						  , pdp->mskGray & AJCSCPGRY_ReadIntervalTimeout		   );
			SendDlgItemMessage(hDlg, IDC_EDT_ReadIntervalTimeout		 , EM_SETREADONLY , pdp->mskGray & AJCSCPGRY_ReadIntervalTimeout		, 0);
			SetGray			  (hDlg, IDC_MS_ReadIntervalTimeout							  , pdp->mskGray & AJCSCPGRY_ReadIntervalTimeout		   );

			SetGray			  (hDlg, IDC_LBL_ReadTotalTimeoutMultiplier					  , pdp->mskGray & AJCSCPGRY_ReadTotalTimeoutMultiplier    );
			SendDlgItemMessage(hDlg, IDC_EDT_ReadTotalTimeoutMultiplier  , EM_SETREADONLY , pdp->mskGray & AJCSCPGRY_ReadTotalTimeoutMultiplier , 0);
			SetGray			  (hDlg, IDC_MS_ReadTotalTimeoutMultiplier					  , pdp->mskGray & AJCSCPGRY_ReadTotalTimeoutMultiplier    );

			SetGray			  (hDlg, IDC_LBL_ReadTotalTimeoutConstant					  , pdp->mskGray & AJCSCPGRY_ReadTotalTimeoutConstant	   );
			SendDlgItemMessage(hDlg, IDC_EDT_ReadTotalTimeoutConstant	 , EM_SETREADONLY , pdp->mskGray & AJCSCPGRY_ReadTotalTimeoutConstant	, 0);
			SetGray			  (hDlg, IDC_MS_ReadTotalTimeoutConstant					  , pdp->mskGray & AJCSCPGRY_ReadTotalTimeoutConstant	   );

			SetGray			  (hDlg, IDC_LBL_WriteTotalTimeoutMultiplier				  , pdp->mskGray & AJCSCPGRY_WriteTotalTimeoutMultiplier   );
			SendDlgItemMessage(hDlg, IDC_EDT_WriteTotalTimeoutMultiplier , EM_SETREADONLY , pdp->mskGray & AJCSCPGRY_WriteTotalTimeoutMultiplier, 0);
			SetGray			  (hDlg, IDC_MS_WriteTotalTimeoutMultiplier					  , pdp->mskGray & AJCSCPGRY_WriteTotalTimeoutMultiplier   );

			SetGray			  (hDlg, IDC_LBL_WriteTotalTimeoutConstant					  , pdp->mskGray & AJCSCPGRY_WriteTotalTimeoutConstant	   );
			SendDlgItemMessage(hDlg, IDC_EDT_WriteTotalTimeoutConstant	 , EM_SETREADONLY , pdp->mskGray & AJCSCPGRY_WriteTotalTimeoutConstant	, 0);
			SetGray			  (hDlg, IDC_MS_WriteTotalTimeoutConstant					  , pdp->mskGray & AJCSCPGRY_WriteTotalTimeoutConstant	   );

			SetDcbToDialog(hDlg, pdp);			//	ＤＣＢ値表示

			ShowDevName(hDlg, pdp->port);		//	ＣＯＭポートのデバイス名表示

			rc = TRUE;
			break;

		case WM_TIMER:
		{	WCP			p;
			UI			ix, NewPort;
			WC			ComPortName[16];

			//	ポート選択中、リアルタイムにデバイス名表示
			if ((ix  = (int)SendMessage(GetDlgItem(hDlg, IDC_CBO_PORT), CB_GETCURSEL, 0, 0)) != CB_ERR) {
				memset(ComPortName, 0, sizeof ComPortName);
				GetDlgItemText(hDlg, IDC_CBO_PORT, ComPortName, AJCTSIZE(ComPortName));		//	ポート番号設定
				p = ComPortName;															//	・
				while (!_ismbcdigit(*p) && *p != 0) p++;									//	・
				NewPort = (_wtoi(p) & 255);													//	・
				if (NewPort != pdp->SvPortNo) {												//	直前のポート番号と異なる？
					pdp->SvPortNo = NewPort;												//		選択ポート番号退避
					ShowDevName(hDlg, NewPort);												//		デバイス名表示		
				}
			}
			rc = TRUE;
			break;
		}

		case WM_COMMAND:																	//	● WM_COMMAND
			switch (LOWORD(wParam)) {
				case IDC_CBO_PORT:															//		◎ポート・コンボボックス
					switch (HIWORD(wParam)) {
						case CBN_DROPDOWN:													//			●リストボックス表示開始
							//	直前の選択ポート番号初期化
							pdp->SvPortNo = -1;
							//	監視タイマ起動
							SetTimer(hDlg, 1, 100, NULL);
							break;
						case CBN_SELCHANGE:													//			●選択変更
						{	WCP		p;
							//	選択ポート設定
							memset(ComPortName, 0, sizeof ComPortName);
							GetDlgItemText(hDlg, IDC_CBO_PORT, ComPortName, AJCTSIZE(ComPortName)); //		新ポート番号取得
							p = ComPortName;													//			・
							while (!_ismbcdigit(*p) && *p != 0) p++;							//			・
							NewPort = (_wtoi(p) & 255);											//			・
							if (NewPort != pdp->port) {											//			ポート変更？
								SetDialogToDcb(hDlg, pdp);										//				ﾀﾞｲｱﾛｸﾞ編集値をDCBﾊﾞｯﾌｧへｾｯﾄ
								pdp->port = NewPort;											//				新ポート番号設定
								ShowDevName(hDlg, NewPort);										//				デバイス名表示
							}
							break;
						}
						case CBN_CLOSEUP:													//			●リストボックスが閉じられた
						case CBN_SELENDCANCEL:												//			●選択中止
						case CBN_KILLFOCUS:													//			●フォーカス喪失
						case CBN_SELENDOK:													//			●選択完了
							//	監視タイマ停止
							KillTimer(hDlg, 1);
							break;
					}
					rc = TRUE;
					break;

				case IDC_LBL_BaudRate:
					if (HIWORD(wParam) == STN_DBLCLK) {{
						WC buf[32]; UI rate;
						GetDlgItemText(hDlg, IDC_CBO_BaudRate, buf, AJCTSIZE(buf));			//			レート値取得
						rate = _wtoi(buf);													//			・
						if (rate >= 4 && rate <= 115200) {									//			レート＝４～１１５２００？
							AjcSnPrintF(buf, AJCTSIZE(buf), L"Raw rate : %.3f bps",			//				生レート値表示
								 (double)(115200.0 / (double)(115200 / rate)));				//				・
							SetDlgItemText(hDlg, IDC_LBL_RAWBAUD, buf);						//				・
						}
						else {																//			レート≠４～１１５２００？
							SetDlgItemText(hDlg, IDC_LBL_RAWBAUD, L"Raw rate : Out of range");	//			生レート値非表示不可
						}
					}}
					rc = TRUE;
					break;

				case IDC_CBO_BaudRate:														//		◎ボーレート・コンボボックス
					if (HIWORD(wParam) == CBN_SELCHANGE || HIWORD(wParam) == CBN_EDITCHANGE) {
						SetDlgItemText(hDlg, IDC_LBL_RAWBAUD, L"");							//				生レート値非表示
					}
					rc = TRUE;
					break;

				case IDC_CHK_fParity:														//		◎パリティ有無チェック
					SetGrayInParity(hDlg, pdp);
					rc = TRUE;
					break;

				case IDC_CHK_fOutX:															//		◎送信フロー制御チェック
					SetGrayInXonXoffChar(hDlg, pdp);
					rc = TRUE;
					break;

				case IDC_CHK_fInX:															//		◎受信フロー制御チェック
					SetGrayInRxFlow(hDlg, pdp);
					SetGrayInXonXoffChar(hDlg, pdp);
					rc = TRUE;
					rc = TRUE;
					break;

				case IDC_CHK_fErrorChar:													//		◎エラー文字置換チェック
					SetGrayInErrorChar(hDlg, pdp);
					rc = TRUE;
					break;

				case IDC_EDT_XonChar:														//		◎ＸＯＮ文字編集
					if (HIWORD(wParam) == EN_KILLFOCUS)
						HexaCheck(hDlg, IDC_EDT_XonChar  , &pdp->dcb.XonChar  );
					rc = TRUE;
					break;
				case IDC_EDT_XoffChar:														//		◎ＸＯＦＦ文字編集
					if (HIWORD(wParam) == EN_KILLFOCUS)
						HexaCheck(hDlg, IDC_EDT_XoffChar , &pdp->dcb.XoffChar );
					rc = TRUE;
					break;
				case IDC_EDT_ErrorChar:														//		◎エラー置換文字編集
					if (HIWORD(wParam) == EN_KILLFOCUS)
						HexaCheck(hDlg, IDC_EDT_ErrorChar, &pdp->dcb.ErrorChar);
					rc = TRUE;
					break;
				case IDC_EDT_EofChar:														//		◎データ終了文字編集
					if (HIWORD(wParam) == EN_KILLFOCUS)
						HexaCheck(hDlg, IDC_EDT_EofChar  , &pdp->dcb.EofChar  );
					rc = TRUE;
					break;
				case IDC_EDT_EvtChar:														//		◎受信イベント文字編集
					if (HIWORD(wParam) == EN_KILLFOCUS)
						HexaCheck(hDlg, IDC_EDT_EvtChar  , &pdp->dcb.EvtChar  );
					rc = TRUE;
					break;

				case IDOK:																	//		◎「ＯＫ」ボタン
					SetDialogToDcb(hDlg, pdp);												//			ﾀﾞｲｱﾛｸﾞ編集値をDCBﾊﾞｯﾌｧへｾｯﾄ
					EndDialog(hDlg, IDOK);													//			→ダイアログ終了
					rc = TRUE;
					break;

				case IDCANCEL:																//		◎「キャンセル」ボタン
					EndDialog(hDlg, IDCANCEL);												//			→ダイアログ終了
					rc = TRUE;
					break;
				case IDC_CMD_SETDEFAULT:													//		◎「ﾃﾞﾌｫﾙﾄ設定」ボタン
					AjcScpGetDefaultParam(&pdp->dcb, &pdp->tmo);
					SetDcbToDialog(hDlg, pdp);
					rc = TRUE;
					break;
			}
			break;

		case WM_NOTIFY:																		//	● WM_NOTIFY
			switch (wParam) {
				case IDC_SLD_XoffLim:
					pdp->dcb.XoffLim = (UI)SendDlgItemMessage(hDlg, IDC_SLD_XoffLim, TBM_GETPOS , 0, 0);
					if (pdp->dcb.XoffLim <= pdp->dcb.XonLim) {
						pdp->dcb.XonLim = pdp->dcb.XoffLim;
						SendDlgItemMessage(hDlg, IDC_SLD_XonLim, TBM_SETPOS , TRUE, pdp->dcb.XonLim);
					}
					AjcSnPrintF(txt, AJCTSIZE(txt), L"%3u%% (%5u bytes)", pdp->dcb.XoffLim * 100 / pdp->SysRxBufSize, pdp->dcb.XoffLim);
					SetDlgItemText(hDlg, IDC_TXT_XoffLim, txt);
					rc = TRUE;
					break;

				case IDC_SLD_XonLim:
					pdp->dcb.XonLim = (UI)SendDlgItemMessage(hDlg, IDC_SLD_XonLim , TBM_GETPOS , 0, 0);
					if (pdp->dcb.XonLim >= pdp->dcb.XoffLim) {
						pdp->dcb.XoffLim = pdp->dcb.XonLim;
						SendDlgItemMessage(hDlg, IDC_SLD_XoffLim , TBM_SETPOS , TRUE, pdp->dcb.XoffLim );
					}
					AjcSnPrintF(txt, AJCTSIZE(txt), L"%3u%% (%5u bytes)", pdp->dcb.XonLim * 100 / pdp->SysRxBufSize, pdp->dcb.XonLim);
					SetDlgItemText(hDlg, IDC_TXT_XonLim , txt);
					rc = TRUE;
					break;

			}
			break;

		case WM_CLOSE:																		//	● WM_CLOSE
			RemoveProp(hDlg, WndProp);														//		ｳｲﾝﾄﾞﾌﾟﾛﾊﾟﾃｨ削除
			EndDialog(hDlg, IDCANCEL);														//		ﾀﾞｲｱﾛｸﾞ終了
			rc = 0;
			break;

		case WM_QUERYENDSESSION:															//	● WM_QUERYENDSESSION
			rc = TRUE;
			break;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	１６進チェック																								//
//--------------------------------------------------------------------------------------------------------------//
static	VO	HexaCheck(HWND hDlg, UI id, char *pChar)
{
	UI		stl;
	WC		buf[8];

	GetDlgItemText(hDlg, id, buf, AJCTSIZE(buf));
	stl = (UI)wcslen(buf);
	if ((stl == 1 && MAjcIsXDigitW(buf[0])) || (stl == 2 && MAjcIsXDigitW(buf[0]) && MAjcIsXDigitW(buf[1]))) {
		*pChar = AjcHexToUI(buf);
	}
	else {
		AjcSnPrintF(buf, AJCTSIZE(buf), L"%02X", *pChar);
		SetDlgItemText(hDlg, id, buf);
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	パリティ項目の無効／有効化																					//
//--------------------------------------------------------------------------------------------------------------//
static	VO	SetGrayInParity(HWND hDlg, LPDLGPROP pdp)
{
	if (pdp->dcb.fParity = (UI)SendDlgItemMessage(hDlg, IDC_CHK_fParity, BM_GETCHECK, 0, 0)) {
		SetGray(hDlg, IDC_CBO_Parity, pdp->mskGray & AJCSCPGRY_Parity);
		SetGray(hDlg, IDC_LBL_Parity, pdp->mskGray & AJCSCPGRY_Parity);
	}
	else {
		SetGray(hDlg, IDC_CBO_Parity, TRUE);
		SetGray(hDlg, IDC_LBL_Parity, TRUE);
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	受信フロー制御項目の無効／有効化																			//
//--------------------------------------------------------------------------------------------------------------//
static	VO	SetGrayInRxFlow(HWND hDlg, LPDLGPROP pdp)
{
	if (pdp->dcb.fInX = (UI)SendDlgItemMessage(hDlg, IDC_CHK_fInX, BM_GETCHECK, 0, 0)) {
		SetGray(hDlg, IDC_LBL_XoffLim, pdp->mskGray & AJCSCPGRY_XoffLim);
		SetGray(hDlg, IDC_SLD_XoffLim, pdp->mskGray & AJCSCPGRY_XoffLim);
		SetGray(hDlg, IDC_TXT_XoffLim, pdp->mskGray & AJCSCPGRY_XoffLim);
		SetGray(hDlg, IDC_LBL_XonLim , pdp->mskGray & AJCSCPGRY_XonLim);
		SetGray(hDlg, IDC_SLD_XonLim , pdp->mskGray & AJCSCPGRY_XonLim);
		SetGray(hDlg, IDC_TXT_XonLim , pdp->mskGray & AJCSCPGRY_XonLim);
		SetGray(hDlg, IDC_CHK_fTXContinueOnXoff, pdp->mskGray & AJCSCPGRY_fTXContinueOnXoff);
	}
	else {
		SetGray(hDlg, IDC_LBL_XoffLim, TRUE);
		SetGray(hDlg, IDC_SLD_XoffLim, TRUE);
		SetGray(hDlg, IDC_TXT_XoffLim, TRUE);
		SetGray(hDlg, IDC_LBL_XonLim , TRUE);
		SetGray(hDlg, IDC_SLD_XonLim , TRUE);
		SetGray(hDlg, IDC_TXT_XonLim , TRUE);
		SetGray(hDlg, IDC_CHK_fTXContinueOnXoff, TRUE);
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	ＸＯＮ／ＸＯＦＦ文字編集の無効／有効化																		//
//--------------------------------------------------------------------------------------------------------------//
static	VO	SetGrayInXonXoffChar(HWND hDlg, LPDLGPROP pdp)
{
	pdp->dcb.fOutX = (UI)SendDlgItemMessage(hDlg, IDC_CHK_fOutX, BM_GETCHECK, 0, 0);
	pdp->dcb.fInX  = (UI)SendDlgItemMessage(hDlg, IDC_CHK_fInX , BM_GETCHECK, 0, 0);

	if (pdp->dcb.fOutX || pdp->dcb.fInX) {
		SetGray(hDlg, IDC_LBL_XonChar								, pdp->mskGray & AJCSCPGRY_XonChar	  );
		SendDlgItemMessage(hDlg, IDC_EDT_XonChar  , EM_SETREADONLY	, pdp->mskGray & AJCSCPGRY_XonChar , 0);
		SetGray(hDlg, IDC_LBL_XoffChar								, pdp->mskGray & AJCSCPGRY_XoffChar   );
		SendDlgItemMessage(hDlg, IDC_EDT_XoffChar , EM_SETREADONLY	, pdp->mskGray & AJCSCPGRY_XoffChar, 0);
	}
	else {
		SetGray(hDlg, IDC_LBL_XonChar								, TRUE	 );
		SendDlgItemMessage(hDlg, IDC_EDT_XonChar  , EM_SETREADONLY	, TRUE, 0);
		SetGray(hDlg, IDC_LBL_XoffChar								, TRUE	 );
		SendDlgItemMessage(hDlg, IDC_EDT_XoffChar , EM_SETREADONLY	, TRUE, 0);
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	エラー置換文字編集の無効／有効化																			//
//--------------------------------------------------------------------------------------------------------------//
static	VO	SetGrayInErrorChar(HWND hDlg, LPDLGPROP pdp)
{
	if (pdp->dcb.fErrorChar = (UI)SendDlgItemMessage(hDlg, IDC_CHK_fErrorChar, BM_GETCHECK, 0, 0)) {
		SetGray(hDlg, IDC_LBL_ErrorChar								, pdp->mskGray & AJCSCPGRY_ErrorChar	);
		SendDlgItemMessage(hDlg, IDC_EDT_ErrorChar	, EM_SETREADONLY, pdp->mskGray & AJCSCPGRY_ErrorChar , 0);
	}
	else {
		SetGray(hDlg, IDC_LBL_ErrorChar								, TRUE	 );
		SendDlgItemMessage(hDlg, IDC_EDT_ErrorChar	, EM_SETREADONLY, TRUE, 0);
	}

}
//--------------------------------------------------------------------------------------------------------------//
//	指定ダイアログ項目のグレー化																				//
//--------------------------------------------------------------------------------------------------------------//
static	VO	SetGray(HWND hDlg, UI id, BOOL fGray)
{
	UL	style;
	HWND	hWnd = GetDlgItem(hDlg, id);

	style = GetWindowLong(hWnd, GWL_STYLE);
	if (fGray) style |=  WS_DISABLED;
	else	   style &= ~WS_DISABLED;
	SetWindowLong(hWnd, GWL_STYLE, style);
	InvalidateRect(hWnd, NULL, FALSE);
}
//--------------------------------------------------------------------------------------------------------------//
//	コンボボックスへポートリストを設定																			//
//--------------------------------------------------------------------------------------------------------------//
static	VO	SetPortListToCBO(HWND hDlg, UI CurrentPort)
{
	UI		i, n, ix, pno;
	UB		PortMap[256];
	WC		ComPortName[64];

	n = AjcScpEnumSerialPorts(PortMap, 256, CurrentPort);
	ix = 0;
	pno = 0;
	for (i=0; i<n; i++) {
		pno = PortMap[i];
		AjcSnPrintF(ComPortName, AJCTSIZE(ComPortName), L" COM %u", pno);
		SendDlgItemMessage(hDlg, IDC_CBO_PORT, CB_INSERTSTRING, ix++, (LPARAM)ComPortName);
	}

	AjcSnPrintF(ComPortName, AJCTSIZE(ComPortName), L" COM %u", CurrentPort);
	SendDlgItemMessage(hDlg, IDC_CBO_PORT, CB_SELECTSTRING, -1, (WPARAM)ComPortName);
}

//--------------------------------------------------------------------------------------------------------------//
//	ＤＣＢ値を、ダイアログへ反映																				//
//--------------------------------------------------------------------------------------------------------------//
static	VO	SetDcbToDialog(HWND hDlg, LPDLGPROP pdp)
{
	WC	txt[32];

	if (pdp->dcb.Parity > 4) pdp->dcb.Parity = 0;
	if (pdp->dcb.ByteSize < 5 || pdp->dcb.ByteSize > 8) pdp->dcb.ByteSize = 8; 
	if (pdp->dcb.StopBits > 3) pdp->dcb.StopBits = 0;

	if		(pdp->dcb.BaudRate ==	300) SendDlgItemMessage(hDlg, IDC_CBO_BaudRate, CB_SETCURSEL,  0, 0);
	else if (pdp->dcb.BaudRate ==	600) SendDlgItemMessage(hDlg, IDC_CBO_BaudRate, CB_SETCURSEL,  1, 0);
	else if (pdp->dcb.BaudRate ==  1200) SendDlgItemMessage(hDlg, IDC_CBO_BaudRate, CB_SETCURSEL,  2, 0);
	else if (pdp->dcb.BaudRate ==  2400) SendDlgItemMessage(hDlg, IDC_CBO_BaudRate, CB_SETCURSEL,  3, 0);
	else if (pdp->dcb.BaudRate ==  4800) SendDlgItemMessage(hDlg, IDC_CBO_BaudRate, CB_SETCURSEL,  4, 0);
	else if (pdp->dcb.BaudRate ==  9600) SendDlgItemMessage(hDlg, IDC_CBO_BaudRate, CB_SETCURSEL,  5, 0);
	else if (pdp->dcb.BaudRate == 14400) SendDlgItemMessage(hDlg, IDC_CBO_BaudRate, CB_SETCURSEL,  6, 0);
	else if (pdp->dcb.BaudRate == 19200) SendDlgItemMessage(hDlg, IDC_CBO_BaudRate, CB_SETCURSEL,  7, 0);
	else if (pdp->dcb.BaudRate == 38400) SendDlgItemMessage(hDlg, IDC_CBO_BaudRate, CB_SETCURSEL,  8, 0);
	else if (pdp->dcb.BaudRate == 57600) SendDlgItemMessage(hDlg, IDC_CBO_BaudRate, CB_SETCURSEL,  9, 0);
	else if (pdp->dcb.BaudRate ==115200) SendDlgItemMessage(hDlg, IDC_CBO_BaudRate, CB_SETCURSEL, 10, 0);
	else  {_itow(pdp->dcb.BaudRate, txt, 10); SetDlgItemText(hDlg, IDC_CBO_BaudRate, txt);}
	SendMessage(hDlg, WM_COMMAND, (CBN_EDITCHANGE << 16) | IDC_CBO_BaudRate, 0);

	SendDlgItemMessage(hDlg, IDC_CBO_ByteSize, CB_SETCURSEL, pdp->dcb.ByteSize - 5, 0);
	SendDlgItemMessage(hDlg, IDC_CBO_StopBits, CB_SETCURSEL, pdp->dcb.StopBits!=0, 0);

	SendDlgItemMessage(hDlg, IDC_CHK_fParity, BM_SETCHECK , pdp->dcb.fParity != 0, 0);
	SendDlgItemMessage(hDlg, IDC_CBO_Parity , CB_SETCURSEL, pdp->dcb.Parity 	 , 0);

	SendDlgItemMessage(hDlg, IDC_CHK_fOutX, BM_SETCHECK , pdp->dcb.fOutX != 0, 0);
	SendDlgItemMessage(hDlg, IDC_CHK_fOutxCtsFlow, BM_SETCHECK , pdp->dcb.fOutxCtsFlow != 0, 0);
	SendDlgItemMessage(hDlg, IDC_CHK_fOutxDsrFlow, BM_SETCHECK , pdp->dcb.fOutxDsrFlow != 0, 0);

	SendDlgItemMessage(hDlg, IDC_CHK_fInX			  , BM_SETCHECK , pdp->dcb.fInX 			 != 0, 0);
	AjcSnPrintF(txt, AJCTSIZE(txt), L"%3u%% (%5u bytes)", pdp->dcb.XoffLim * 100 / pdp->SysRxBufSize, pdp->dcb.XoffLim);
	SetDlgItemText(hDlg, IDC_TXT_XoffLim, txt);
	AjcSnPrintF(txt, AJCTSIZE(txt), L"%3u%% (%5u bytes)", pdp->dcb.XonLim  * 100 / pdp->SysRxBufSize, pdp->dcb.XonLim );
	SetDlgItemText(hDlg, IDC_TXT_XonLim , txt);
	SendDlgItemMessage(hDlg, IDC_SLD_XoffLim, TBM_SETPOS , TRUE, pdp->dcb.XoffLim);
	SendDlgItemMessage(hDlg, IDC_SLD_XonLim , TBM_SETPOS , TRUE, pdp->dcb.XonLim );

	SendDlgItemMessage(hDlg, IDC_CHK_fTXContinueOnXoff, BM_SETCHECK , pdp->dcb.fTXContinueOnXoff != 0, 0);

	SendDlgItemMessage(hDlg, IDC_DtrControl_Disable  , BM_SETCHECK , pdp->dcb.fDtrControl == 0, 0);
	SendDlgItemMessage(hDlg, IDC_DtrControl_Enable	 , BM_SETCHECK , pdp->dcb.fDtrControl == 1, 0);
	SendDlgItemMessage(hDlg, IDC_DtrControl_Handshake, BM_SETCHECK , pdp->dcb.fDtrControl == 2, 0);

	SendDlgItemMessage(hDlg, IDC_RtsControl_Disable  , BM_SETCHECK , pdp->dcb.fRtsControl == 0, 0);
	SendDlgItemMessage(hDlg, IDC_RtsControl_Enable	 , BM_SETCHECK , pdp->dcb.fRtsControl == 1, 0);
	SendDlgItemMessage(hDlg, IDC_RtsControl_Handshake, BM_SETCHECK , pdp->dcb.fRtsControl == 2, 0);
	SendDlgItemMessage(hDlg, IDC_RtsControl_Toggle	 , BM_SETCHECK , pdp->dcb.fRtsControl == 3, 0);

	SendDlgItemMessage(hDlg, IDC_CHK_fBinary		, BM_SETCHECK , pdp->dcb.fBinary		 != 0, 0);
	SendDlgItemMessage(hDlg, IDC_CHK_fDsrSensitivity, BM_SETCHECK , pdp->dcb.fDsrSensitivity != 0, 0);
	SendDlgItemMessage(hDlg, IDC_CHK_fErrorChar 	, BM_SETCHECK , pdp->dcb.fErrorChar 	 != 0, 0);
	SendDlgItemMessage(hDlg, IDC_CHK_fNull			, BM_SETCHECK , pdp->dcb.fNull			 != 0, 0);
	SendDlgItemMessage(hDlg, IDC_CHK_fAbortOnError	, BM_SETCHECK , pdp->dcb.fAbortOnError	 != 0, 0);

	AjcSnPrintF(txt, AJCTSIZE(txt), L"%02X", pdp->dcb.XonChar  ); SetDlgItemText(hDlg, IDC_EDT_XonChar	 , txt);
	AjcSnPrintF(txt, AJCTSIZE(txt), L"%02X", pdp->dcb.XoffChar ); SetDlgItemText(hDlg, IDC_EDT_XoffChar  , txt);
	AjcSnPrintF(txt, AJCTSIZE(txt), L"%02X", pdp->dcb.ErrorChar); SetDlgItemText(hDlg, IDC_EDT_ErrorChar , txt);
	AjcSnPrintF(txt, AJCTSIZE(txt), L"%02X", pdp->dcb.EofChar  ); SetDlgItemText(hDlg, IDC_EDT_EofChar	 , txt);
	AjcSnPrintF(txt, AJCTSIZE(txt), L"%02X", pdp->dcb.EvtChar  ); SetDlgItemText(hDlg, IDC_EDT_EvtChar	 , txt);

	SetDlgItemInt(hDlg, IDC_EDT_ReadIntervalTimeout			, pdp->tmo.ReadIntervalTimeout		  , FALSE);
	SetDlgItemInt(hDlg, IDC_EDT_ReadTotalTimeoutMultiplier	, pdp->tmo.ReadTotalTimeoutMultiplier , FALSE);
	SetDlgItemInt(hDlg, IDC_EDT_ReadTotalTimeoutConstant	, pdp->tmo.ReadTotalTimeoutConstant	  , FALSE);
	SetDlgItemInt(hDlg, IDC_EDT_WriteTotalTimeoutMultiplier	, pdp->tmo.WriteTotalTimeoutMultiplier, FALSE);
	SetDlgItemInt(hDlg, IDC_EDT_WriteTotalTimeoutConstant	, pdp->tmo.WriteTotalTimeoutConstant  , FALSE);

	SetGrayInParity		(hDlg, pdp);
	SetGrayInRxFlow		(hDlg, pdp);
	SetGrayInXonXoffChar(hDlg, pdp);
	SetGrayInErrorChar	(hDlg, pdp);

}
//--------------------------------------------------------------------------------------------------------------//
//	ダイアログで編集した値をＤＣＢバッファへ設定																//
//--------------------------------------------------------------------------------------------------------------//
static	VO	SetDialogToDcb(HWND hDlg, LPDLGPROP pdp)
{
	BOOL	rsu;
	WC		buf[16];

	GetDlgItemText(hDlg, IDC_CBO_BaudRate, buf, AJCTSIZE(buf));
	pdp->dcb.BaudRate = _wtoi(buf);

	switch (SendDlgItemMessage(hDlg, IDC_CBO_ByteSize, CB_GETCURSEL, 0, 0)) {
		case 0:		pdp->dcb.ByteSize =    5;	break;
		case 1:		pdp->dcb.ByteSize =    6;	break;
		case 2:		pdp->dcb.ByteSize =    7;	break;
		default:	pdp->dcb.ByteSize =    8;	break;
	}
	switch (SendDlgItemMessage(hDlg, IDC_CBO_StopBits, CB_GETCURSEL, 0, 0)) {
		case 0:		pdp->dcb.StopBits = 0;	break;
		default:	pdp->dcb.StopBits = 2;	break;
	}
	pdp->dcb.fParity	= (UI)SendDlgItemMessage(hDlg, IDC_CHK_fParity, BM_GETCHECK , 0, 0);
	pdp->dcb.Parity		= (UI)SendDlgItemMessage(hDlg, IDC_CBO_Parity , CB_GETCURSEL, 0, 0);

	pdp->dcb.fOutX		 = (UI)SendDlgItemMessage(hDlg, IDC_CHK_fOutX		, BM_GETCHECK, 0, 0);
	pdp->dcb.fOutxCtsFlow= (UI)SendDlgItemMessage(hDlg, IDC_CHK_fOutxCtsFlow, BM_GETCHECK, 0, 0);
	pdp->dcb.fOutxDsrFlow= (UI)SendDlgItemMessage(hDlg, IDC_CHK_fOutxDsrFlow, BM_GETCHECK, 0, 0);

	pdp->dcb.fInX			  = (UI)SendDlgItemMessage(hDlg, IDC_CHK_fInX			  , BM_GETCHECK, 0, 0);
	pdp->dcb.XoffLim		  = (UI)SendDlgItemMessage(hDlg, IDC_SLD_XoffLim		  , TBM_GETPOS , 0, 0);
	pdp->dcb.XonLim 		  = (UI)SendDlgItemMessage(hDlg, IDC_SLD_XonLim 		  , TBM_GETPOS , 0, 0);
	pdp->dcb.fTXContinueOnXoff= (UI)SendDlgItemMessage(hDlg, IDC_CHK_fTXContinueOnXoff, BM_GETCHECK, 0, 0);

	if		(SendDlgItemMessage(hDlg, IDC_DtrControl_Disable  , BM_GETCHECK, 0, 0)) pdp->dcb.fDtrControl = 0;
	else if (SendDlgItemMessage(hDlg, IDC_DtrControl_Enable   , BM_GETCHECK, 0, 0)) pdp->dcb.fDtrControl = 1;
	else																			pdp->dcb.fDtrControl = 2;

	if		(SendDlgItemMessage(hDlg, IDC_RtsControl_Disable  , BM_GETCHECK, 0, 0)) pdp->dcb.fRtsControl = 0;
	else if (SendDlgItemMessage(hDlg, IDC_RtsControl_Enable   , BM_GETCHECK, 0, 0)) pdp->dcb.fRtsControl = 1;
	else if (SendDlgItemMessage(hDlg, IDC_RtsControl_Handshake, BM_GETCHECK, 0, 0)) pdp->dcb.fRtsControl = 2;
	else																			pdp->dcb.fRtsControl = 3;

	pdp->dcb.fBinary		= (UI)SendDlgItemMessage(hDlg, IDC_CHK_fBinary		   , BM_GETCHECK, 0, 0);
	pdp->dcb.fDsrSensitivity= (UI)SendDlgItemMessage(hDlg, IDC_CHK_fDsrSensitivity , BM_GETCHECK, 0, 0);
	pdp->dcb.fErrorChar		= (UI)SendDlgItemMessage(hDlg, IDC_CHK_fErrorChar	   , BM_GETCHECK, 0, 0);
	pdp->dcb.fNull			= (UI)SendDlgItemMessage(hDlg, IDC_CHK_fNull		   , BM_GETCHECK, 0, 0);
	pdp->dcb.fAbortOnError	= (UI)SendDlgItemMessage(hDlg, IDC_CHK_fAbortOnError   , BM_GETCHECK, 0, 0);

	GetDlgItemText(hDlg, IDC_EDT_XonChar	, buf, AJCTSIZE(buf));	pdp->dcb.XonChar	= AjcHexToUI(buf);
	GetDlgItemText(hDlg, IDC_EDT_XoffChar	, buf, AJCTSIZE(buf));	pdp->dcb.XoffChar	= AjcHexToUI(buf);
	GetDlgItemText(hDlg, IDC_EDT_ErrorChar	, buf, AJCTSIZE(buf));	pdp->dcb.ErrorChar	= AjcHexToUI(buf);
	GetDlgItemText(hDlg, IDC_EDT_EofChar	, buf, AJCTSIZE(buf));	pdp->dcb.EofChar	= AjcHexToUI(buf);
	GetDlgItemText(hDlg, IDC_EDT_EvtChar	, buf, AJCTSIZE(buf));	pdp->dcb.EvtChar	= AjcHexToUI(buf);

	pdp->tmo.ReadIntervalTimeout		= GetDlgItemInt(hDlg, IDC_EDT_ReadIntervalTimeout		 ,&rsu, FALSE);
	pdp->tmo.ReadTotalTimeoutMultiplier	= GetDlgItemInt(hDlg, IDC_EDT_ReadTotalTimeoutMultiplier ,&rsu, FALSE);
	pdp->tmo.ReadTotalTimeoutConstant	= GetDlgItemInt(hDlg, IDC_EDT_ReadTotalTimeoutConstant	 ,&rsu, FALSE);
	pdp->tmo.WriteTotalTimeoutMultiplier= GetDlgItemInt(hDlg, IDC_EDT_WriteTotalTimeoutMultiplier,&rsu, FALSE);
	pdp->tmo.WriteTotalTimeoutConstant	= GetDlgItemInt(hDlg, IDC_EDT_WriteTotalTimeoutConstant	 ,&rsu, FALSE);

}
//--------------------------------------------------------------------------------------------------------------//
//	ＣＯＭポートのデバイス名表示																				//
//--------------------------------------------------------------------------------------------------------------//
static	VO	ShowDevName(HWND hDlg, UI pno)
{
	WC		name[16];
	WC		dev [256];
	WC		txt [300];

	AjcSnPrintF(name, AJCTSIZE(name), L"COM%d", pno);

	if (AjcScpGetPortDevName(name, dev, AJCTSIZE(dev))) {
		AjcSnPrintF(txt, AJCTSIZE(txt), L"%s : %s", name, dev);
		AjcSetDlgItemStr(hDlg, IDC_TXT_DEVNAME, txt);
	}
	else {
		AjcSetDlgItemStr(hDlg, IDC_TXT_DEVNAME, L"<No device>");
	}
}
