﻿#include	"AjcInternal.h"
#include	"AjcSerialComPortDef.h"
//**************************************************************************************************************//
//																												//
//	ＣＯＭポート入出力								ＭＳＩＬ（.NET Framework）対応処理							//
//																												//
//**************************************************************************************************************//
AJC_WNDPROC_DEF(MSIL);

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	ＭＳＩＬ用サポートコード																					//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//----- ワーク形式 ---------------------------------------------------------------------------------------------//
typedef struct {
	HAJCSCP		hScp;
	VO (CALLBACK *cbPortState )(int state, C_WCP pPortName);
	VO (CALLBACK *cbRxChunkTxt)(C_WCP text);
	VO (CALLBACK *cbRxChunkBin)(C_VOP pData, int lData);
	VO (CALLBACK *cbRxText	  )(C_WCP text);
	VO (CALLBACK *cbRxEsc	  )(C_WCP esc);
	VO (CALLBACK *cbRxCtrl	  )(int   ctrl);
	VO (CALLBACK *cbRxPacket  )(C_VOP pData, int lData);
	VO (CALLBACK *cbTxEmpty   )(VO);
	VO (CALLBACK *cbRxNoPkt	  )(C_WCP text);
	VO (CALLBACK *cbRxWord14  )(int   data);
	VO (CALLBACK *cbRxInvChunk)(C_VOP pData, int lData);
	VO (CALLBACK *cbError	  )(int err);
	VO (CALLBACK *cbNtcRING   )(BOOL cts, BOOL dsr, BOOL rlsd, BOOL ring);
	VO (CALLBACK *cbNtcRLSD   )(BOOL cts, BOOL dsr, BOOL rlsd, BOOL ring);
	VO (CALLBACK *cbNtcDSR	  )(BOOL cts, BOOL dsr, BOOL rlsd, BOOL ring);
	VO (CALLBACK *cbNtcCTS	  )(BOOL cts, BOOL dsr, BOOL rlsd, BOOL ring);
	VO (CALLBACK *cbRxFlag	  )(VO);
	VO (CALLBACK *cbRxChar	  )(VO);
} WKMSIL, *PWKMSIL;
//==============================================================================================================//
//																												//
//	ウインドプロシージャ・エントリポイントを返す																//
//																												//
//==============================================================================================================//
WNDPROC		ScpWndProcMSIL()
{
	return AJC_WNDPROC_NAME(MSIL);
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	コントロールウインド生成																					//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
AJCEXPORT HAJCSCP WINAPI AjcScpCreateForMSIL(	VO (CALLBACK *cbPortState )(int state, C_WCP pPortName),
												VO (CALLBACK *cbRxChunkTxt)(C_WCP text),
												VO (CALLBACK *cbRxChunkBin)(C_VOP pData, int lData),
												VO (CALLBACK *cbRxText	  )(C_WCP text),
												VO (CALLBACK *cbRxEsc	  )(C_WCP esc),
												VO (CALLBACK *cbRxCtrl	  )(int   ctrl),
												VO (CALLBACK *cbRxPacket  )(C_VOP pData, int lData),
												VO (CALLBACK *cbTxEmpty   )(VO),
												VO (CALLBACK *cbRxNoPkt   )(C_WCP text),
												VO (CALLBACK *cbRxWord14  )(int   data),
												VO (CALLBACK *cbRxInvChunk)(C_VOP pData, int lData),
												VO (CALLBACK *cbError	  )(int err),
												VO (CALLBACK *cbNtcRING   )(BOOL cts, BOOL dsr, BOOL rlsd, BOOL ring),
												VO (CALLBACK *cbNtcRLSD   )(BOOL cts, BOOL dsr, BOOL rlsd, BOOL ring),
												VO (CALLBACK *cbNtcDSR	  )(BOOL cts, BOOL dsr, BOOL rlsd, BOOL ring),
												VO (CALLBACK *cbNtcCTS	  )(BOOL cts, BOOL dsr, BOOL rlsd, BOOL ring))
{
	HAJCSCP		hScp   = NULL;
	HWND		hDummy = NULL;
	PWKMSIL		pWk    = NULL;

	do {
		//----- ワーク領域確保 ---------------------------------------------------------------------------------//
		if ((pWk = (PWKMSIL)AJCMEM(sizeof(WKMSIL))) == NULL) break;
		memset(pWk, 0, sizeof(WKMSIL));
		pWk->cbPortState  = cbPortState;
		pWk->cbRxChunkTxt = cbRxChunkTxt;
		pWk->cbRxChunkBin = cbRxChunkBin;
		pWk->cbRxText	  = cbRxText;
		pWk->cbRxEsc	  = cbRxEsc;
		pWk->cbRxCtrl	  = cbRxCtrl;
		pWk->cbRxPacket   = cbRxPacket;
		pWk->cbTxEmpty	  = cbTxEmpty;
		pWk->cbRxNoPkt	  = cbRxNoPkt;
		pWk->cbRxWord14	  = cbRxWord14;
		pWk->cbRxInvChunk = cbRxInvChunk;
		pWk->cbError	  = cbError;
		pWk->cbNtcRING	  = cbNtcRING;
		pWk->cbNtcRLSD	  = cbNtcRLSD;
		pWk->cbNtcDSR	  = cbNtcDSR;
		pWk->cbNtcCTS	  = cbNtcCTS;
		//----- MSILウインド生成 -------------------------------------------------------------------------------//
		hDummy = CreateWindow((WCP)ScpClassForMSIL,			// window class name
								L"",						// window caption
								WS_OVERLAPPEDWINDOW,		// window style
								0,							// initial x position
								0,							// initial y position
								0,							// initial x size
								0,							// initial y size
								NULL,						// parent window handle
								NULL,						// window menu handle
								hDllInst,					// program instance handle
								(VOP)pWk);					// creation parameters
		if (hDummy == NULL) break;
		//----- 戻り値（コントロールハンドル）設定 -------------------------------------------------------------//
		hScp = pWk->hScp;
		//----- ダミーウインドハンドルをＳＣＰインスタンスに退避 -----------------------------------------------//
		hScp->hWndForMsil = hDummy;
		//----- ウインド非表示 ---------------------------------------------------------------------------------//
		ShowWindow(hDummy, SW_HIDE);
	} while(0);

	//----- エラーならばリソース解放 ---------------------------------------------------------------------------//
	if (hDummy == NULL) {
		if (pWk != NULL) free(pWk);
		hScp = NULL;
	}

	return hScp;
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	ウインドプロシージャ																						//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
AJC_WNDPROC(MSIL, WM_CREATE		)
{
	LRESULT		rc	  = -1;
	HWND		hCtrl = NULL;
	PWKMSIL		pWk   = (PWKMSIL)(((LPCREATESTRUCT)lParam)->lpCreateParams);

	do {
		//----- ワークポインタ退避 -----------------------------------------------------------------------------//
		MAjcSetWindowLong(hwnd, 0, (UX)pWk);
		//----- ＳＣＰインスタンス生成 -------------------------------------------------------------------------//
		pWk->hScp = AjcScpCreateExW(NULL, FALSE, NULL, NULL, NULL);
		if (pWk->hScp == NULL) break;
		//----- 戻り値=正常 ------------------------------------------------------------------------------------//
		rc = 0;
	} while(0);

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(MSIL, WM_DESTROY	)
{
	PWKMSIL		pWk = (PWKMSIL)MAjcGetWindowLong(hwnd, 0);

	if (pWk != NULL) {
		free(pWk);
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(MSIL, WM_SCP_FORMSIL	)
{
	PWKMSIL		pWk = (PWKMSIL)MAjcGetWindowLong(hwnd, 0);
	VOP			pDat;
	UI			len, param;

	AjcScpGetEventData(pWk->hScp, lParam, &pDat, &len, &param);

	//----- ポート状態通知 -------------------------------------------------------------------------------------//
	if		((wParam & AJCSCP_EV_PORTSTATE) != 0  &&  pWk->cbPortState	!= NULL) {
		pWk->cbPortState(param, (C_WCP)pDat);
	}
	//----- チャンクデータ受信通知 （バイナリ）-----------------------------------------------------------------//
	if		((wParam & AJCSCP_EV_RXCHUNK  ) != 0  &&  param == 0  &&  pWk->cbRxChunkBin != NULL) {
		pWk->cbRxChunkBin(pDat, len);
	}
	//----- チャンクデータ受信通知（テキスト，MSILの場合はワイド文字(param==2)で通知）--------------------------//
	if		((wParam & AJCSCP_EV_RXCHUNK  ) != 0  &&  param != 0  &&  pWk->cbRxChunkTxt != NULL) {
		pWk->cbRxChunkTxt(pDat);
	}
	//----- テキスト受信通知 -----------------------------------------------------------------------------------//
	if		((wParam & AJCSCP_EV_RXTEXT   ) != 0  &&  pWk->cbRxText		!= NULL) {
		pWk->cbRxText(pDat);
	}
	//----- ＥＳＣコード受信通知 -------------------------------------------------------------------------------//
	if		((wParam & AJCSCP_EV_RXESC	  ) != 0  &&  pWk->cbRxEsc		!= NULL) {
		pWk->cbRxEsc(pDat);
	}
	//----- 制御コード受信通知 ---------------------------------------------------------------------------------//
	if		((wParam & AJCSCP_EV_RXCTRL   ) != 0  &&  pWk->cbRxCtrl		!= NULL) {
		pWk->cbRxCtrl(*((UBP)pDat));
	}
	//----- パケットデータ受信通知 -----------------------------------------------------------------------------//
	if		((wParam & AJCSCP_EV_RXPKT	  ) != 0  &&  pWk->cbRxPacket	!= NULL) {
		pWk->cbRxPacket(pDat, len);
	}
	//----- 送信完了 -------------------------------------------------------------------------------------------//
	if		((wParam & AJCSCP_EV_TXEMPTY  ) != 0  &&  pWk->cbTxEmpty	!= NULL) {
		pWk->cbTxEmpty();
	}
	//----- パケット外テキスト受信 -----------------------------------------------------------------------------//
	if		((wParam & AJCSCP_EV_RXNOPKT  ) != 0  &&  pWk->cbRxNoPkt 	!= NULL) {
		pWk->cbRxNoPkt(pDat);
	}
	//----- バイトペアによるワード(14Bit値)受信 ----------------------------------------------------------------//
	if		((wParam & AJCSCP_EV_RXWORD14 ) != 0  &&  pWk->cbRxWord14	!= NULL) {
		pWk->cbRxWord14(*((UWP)pDat));
	}
	//----- 不正チャンクテキスト受信 ---------------------------------------------------------------------------//
	if		((wParam & AJCSCP_EV_INVCHUNK) != 0  &&  pWk->cbRxInvChunk	!= NULL) {
		pWk->cbRxInvChunk(pDat, len);
	}
	//----- エラー通知 -----------------------------------------------------------------------------------------//
	if		((wParam & AJCSCP_EV_ERR	  ) != 0  &&  pWk->cbError		!= NULL) {
		pWk->cbError(param);
	}
	//----- RING変化通知 ---------------------------------------------------------------------------------------//
	if		((wParam & AJCSCP_EV_RING	  ) != 0  &&  pWk->cbNtcRING	!= NULL) {
		pWk->cbNtcRING((param & AJCSCP_CTS) != 0, (param & AJCSCP_DSR) != 0, (param & AJCSCP_RLSD) != 0, (param & AJCSCP_RING) != 0);
	}
	//----- RLSD変化通知 ---------------------------------------------------------------------------------------//
	if		((wParam & AJCSCP_EV_RLSD	  ) != 0  &&  pWk->cbNtcRLSD	!= NULL) {
		pWk->cbNtcRLSD((param & AJCSCP_CTS) != 0, (param & AJCSCP_DSR) != 0, (param & AJCSCP_RLSD) != 0, (param & AJCSCP_RING) != 0);
	}
	//----- DSR変化通知 ----------------------------------------------------------------------------------------//
	if		((wParam & AJCSCP_EV_DSR	  ) != 0  &&  pWk->cbNtcDSR		!= NULL) {
		pWk->cbNtcDSR((param & AJCSCP_CTS) != 0, (param & AJCSCP_DSR) != 0, (param & AJCSCP_RLSD) != 0, (param & AJCSCP_RING) != 0);
	}
	//----- CTS変化通知 ----------------------------------------------------------------------------------------//
	if		((wParam & AJCSCP_EV_CTS	  ) != 0  &&  pWk->cbNtcCTS		!= NULL) {
		pWk->cbNtcCTS((param & AJCSCP_CTS) != 0, (param & AJCSCP_DSR) != 0, (param & AJCSCP_RLSD) != 0, (param & AJCSCP_RING) != 0);
	}

	AjcScpRelEventData(pWk->hScp, lParam);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(MSIL)
	AJC_WNDMAP_MSG(MSIL, WM_CREATE			)
	AJC_WNDMAP_MSG(MSIL, WM_DESTROY			)
	AJC_WNDMAP_MSG(MSIL, WM_SCP_FORMSIL			)
AJC_WNDMAP_END
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	自スロット生成（この関数はＭＳＩＬ初期化用で、メールスロット生成を失敗しても何もしない）					//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
AJCEXPORT VO WINAPI AjcScpCreateMySlotForMSIL(HAJCSCP hScp)
{
	ScpCreateMySlot(hScp);
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	モード設定																									//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
AJCEXPORT VO WINAPI AjcScpSetModeForMSIL(HAJCSCP hScp, BOOL fEventMode)
{
	BOOL	rc = FALSE;

	if (fEventMode) {
		hScp->hWndNtc  = hScp->hWndForMsil;
		hScp->MsgNtc   = WM_SCP_FORMSIL;
	}
	else {
		hScp->hWndNtc  = NULL;
		hScp->MsgNtc   = 0;
	}
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	ポート名取得																								//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
AJCEXPORT VO WINAPI AjcScpGetPortNameForMSIL(HAJCSCP hScp, WCP pBuf, int lBuf)
{
	if (hScp != NULL && pBuf != NULL  && lBuf > 0) {
		AjcSnPrintFW(pBuf, lBuf, L"%s", AjcScpGetPortNameW(hScp));
	}
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	ポートパス名取得																							//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
AJCEXPORT VO WINAPI AjcScpGetPortPathNameForMSIL(HAJCSCP hScp, WCP pBuf, int lBuf)
{
	if (hScp != NULL && pBuf != NULL  && lBuf > 0) {
		AjcSnPrintFW(pBuf, lBuf, L"%s", AjcScpGetPortPathNameW(hScp));
	}
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	自スロットパス名取得																						//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
AJCEXPORT VO WINAPI AjcScpGetMySlotPathNameForMSIL(HAJCSCP hScp, WCP pBuf, int lBuf)
{
	if (hScp != NULL && pBuf != NULL  && lBuf > 0) {
		AjcSnPrintFW(pBuf, lBuf, L"%s", AjcScpGetMySlotPathNameW(hScp));
	}
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	終了処理																									//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
AJCEXPORT VO WINAPI AjcScpDeleteForMSIL(HAJCSCP hScp)
{
	if (hScp != NULL && hScp->hWndForMsil != NULL) {
		if (hScp->hWndForMsil != NULL) {
			DestroyWindow(hScp->hWndForMsil);
			hScp->hWndForMsil = NULL;
		}
		AjcScpDelete(hScp);
	}
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	プロファイルセクション名設定／取得																			//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//	設定
AJCEXPORT VO WINAPI AjcScpSetProfileSectForMSIL(HAJCSCP hScp, C_WCP pProfileSect)
{
	//	プロファイルセクション名設定
	if (hScp != NULL && pProfileSect != NULL) {
		wcsncpy(hScp->ProfileSect, pProfileSect, AJCTSIZE(hScp->ProfileSect));
		hScp->ProfileSect[AJCTSIZE(hScp->ProfileSect) - 1] = 0;
	}
}
//	取得
AJCEXPORT VO WINAPI AjcScpGetProfileSectForMSIL(HAJCSCP hScp, WCP pProfileSect, int lProfileSect)
{
	if (hScp != NULL && pProfileSect != NULL && lProfileSect > 0) {
		wcsncpy(pProfileSect, hScp->ProfileSect, lProfileSect);
		pProfileSect[lProfileSect - 1] = 0;
	}
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	自スロット名設定／取得																						//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//	設定
AJCEXPORT VO WINAPI AjcScpSetMySlotForMSIL(HAJCSCP hScp, C_WCP pMySlot)
{
	//	自スロット名設定
	if (hScp != NULL && pMySlot != NULL) {
		wcsncpy(hScp->SlotInfo.MySlotName, pMySlot, AJCTSIZE(hScp->SlotInfo.MySlotName));
		hScp->SlotInfo.MySlotName[AJCTSIZE(hScp->SlotInfo.MySlotName) - 1] = 0;
	}
}
//	取得
AJCEXPORT VO WINAPI AjcScpGetMySlotForMSIL(HAJCSCP hScp,   WCP pMySlot, int lMySlot)
{
	if (hScp != NULL && pMySlot != NULL && lMySlot > 0) {
		wcsncpy(pMySlot, hScp->SlotInfo.MySlotName, lMySlot);
		pMySlot[lMySlot - 1] = 0;
	}
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	リモートホスト名設定／取得																					//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//	設定
AJCEXPORT VO WINAPI AjcScpSetRmtHostForMSIL(HAJCSCP hScp, C_WCP pRmtHost)
{
	if (hScp != NULL && pRmtHost != NULL) {
		wcsncpy(hScp->SlotInfo.RmtHostName, pRmtHost, AJCTSIZE(hScp->SlotInfo.RmtHostName));
		hScp->SlotInfo.RmtHostName[AJCTSIZE(hScp->SlotInfo.RmtHostName) - 1] = 0;
	}
}
//	取得
AJCEXPORT VO WINAPI AjcScpGetRmtHostForMSIL(HAJCSCP hScp,	WCP pRmtHost, int lRmtHost)
{
	if (hScp != NULL && pRmtHost != NULL && lRmtHost > 0) {
		wcsncpy(pRmtHost, hScp->SlotInfo.RmtHostName, lRmtHost);
		pRmtHost[lRmtHost - 1] = 0;
	}
}

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	リモートスロット名設定／取得																				//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//	設定
AJCEXPORT VO WINAPI AjcScpSetRmtSlotForMSIL(HAJCSCP hScp, C_WCP pRmtSlot)
{
	if (hScp != NULL && pRmtSlot != NULL) {
		wcsncpy(hScp->SlotInfo.RmtSlotName,  pRmtSlot, AJCTSIZE(hScp->SlotInfo.RmtSlotName));
		hScp->SlotInfo.RmtSlotName[AJCTSIZE(hScp->SlotInfo.RmtSlotName) - 1] = 0;
	}
}
//	取得
AJCEXPORT VO WINAPI AjcScpGetRmtSlotForMSIL(HAJCSCP hScp,	WCP pRmtSlot, int lRmtSlot)
{
	if (hScp != NULL && pRmtSlot != NULL && lRmtSlot > 0) {
		wcsncpy(pRmtSlot, hScp->SlotInfo.RmtSlotName, lRmtSlot);
		pRmtSlot[lRmtSlot - 1] = 0;
	}
}

