﻿#include	"AjcInternal.h"
#include	"AjcSerialComPortDef.h"
//**************************************************************************************************************//
//																												//
//	ＣＯＭポート入出力								グローバル サブ関数											//
//																												//
//**************************************************************************************************************//

//==============================================================================================================//
//																												//
//	ユーザＡＰへポート状態通知																					//
//																												//
//==============================================================================================================//
VO	ScpNtcPortStateToUser	 (HAJCSCP pW, UI param)
{
	if (pW->fUnicode) {
		WCP		pName;
		WCP		pDat;
		UI		stl;

		if ((pName = AjcScpGetPortNameW(pW)) == NULL) pName = L"";
		stl = (UI)wcslen(pName);
		if (pDat = AJCMEM((stl + 1) * 2)) {
			wcscpy(pDat, pName);
			ScpNtcEvtToUser(pW, AJCSCP_EV_PORTSTATE, pDat, stl, param);
		}
	}
	else {
		BCP		pName;
		BCP		pDat;
		UI		stl;

		if ((pName = AjcScpGetPortNameA(pW)) == NULL) pName = "";
		stl = (UI)strlen(pName);
		if (pDat = AJCMEM(stl + 1)) {
			strcpy(pDat, pName);
			ScpNtcEvtToUser(pW, AJCSCP_EV_PORTSTATE, pDat, stl, param);
		}
	}
}
//==============================================================================================================//
//	ユーザＡＰへイベント通知																					//
//																												//
//	※	イベント通知用のリソース（EVTENF）は、プログラム終了時に残留する可能性があるため、						//
//	   AjcAllocInstance/AjcReleaseInstanceで確保／開放し、プロセス終了時にクリーンアップする。					//
//==============================================================================================================//
static	VO CALLBACK cbReleaseEvtInf(VOP pVop);
//--------------------------------------------------------------------------------------------------------------//
VO	ScpNtcEvtToUser	 (HAJCSCP pW, UI EvtMask, VOP pDat, UI lDat, UI param)
{
	PSCP_EVTINF	pEvtInf;

	//	通知対象イベント？
	if (pW->EvtMask & EvtMask) {
		//	イベント通知情報確保，成功？
		if (pEvtInf = AjcAllocInstance(sizeof(SCP_EVTINF), (VOP)cbReleaseEvtInf)) {
			pEvtInf->Evt   = EvtMask;
			pEvtInf->pDat  = pDat;
			pEvtInf->lDat  = lDat;
			pEvtInf->param = param;
			//	ウインドメッセージによる通知？
			if (pW->hWndNtc != NULL) {
				//	通知先ウインドは有効・・・
				if (IsWindow(pW->hWndNtc)) {
					if (!PostMessage(pW->hWndNtc, pW->MsgNtc, EvtMask, (LPARAM)pEvtInf)) {
						//	失敗時は、最小時間ウェイト後、リトライ
						Sleep(1);
						if (!PostMessage(pW->hWndNtc, pW->MsgNtc, EvtMask, (LPARAM)pEvtInf)) {
							//	再度失敗時は、通知情報消去
							AjcReleaseInstance(pEvtInf);
						}
					}
				}
				//	通知先ウインドが無効ならば、通知情報消去
				else {
					AjcReleaseInstance(pEvtInf);
				}
			}
			//	イベントオブジェクトによる通知？
			else {
				//	イベントオブジェクトにより通知
				if (!AjcFMbxEnque(pW->hFMbxNtc, &pEvtInf)) {
					//	失敗時は、通知情報確消去
					AjcReleaseInstance(pEvtInf);
				}
			}
		}
		//	イベント通知情報確保，失敗？
		else {
			if (pDat != NULL) {
				free(pDat);
			}
		}
	}
	//	通知対象外のイベント？
	else {
		if (pDat != NULL) {
			free(pDat);
		}
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	残留イベント通知用リソース開放（プロセス終了時に実行）														//
//--------------------------------------------------------------------------------------------------------------//
static	VO CALLBACK cbReleaseEvtInf(VOP pVop)
{
	PSCP_EVTINF pEvtInf = (PSCP_EVTINF)pVop;

	if (pEvtInf->pDat != NULL) {
		free(pEvtInf->pDat);
		pEvtInf->pDat = NULL;
	}
}


//==============================================================================================================//
//																												//
//	COMMイベント → SCPイベントコード変換																		//
//																												//
//==============================================================================================================//
UI	CommEvtToScpEvt(UI CommEvt)
{
	UI		rc = 0;

	if (CommEvt & EV_TXEMPTY) rc |= AJCSCP_EV_TXEMPTY;
	if (CommEvt & EV_RING	) rc |= AJCSCP_EV_RING;
	if (CommEvt & EV_ERR	) rc |= AJCSCP_EV_ERR;
	if (CommEvt & EV_RLSD	) rc |= AJCSCP_EV_RLSD;
	if (CommEvt & EV_DSR	) rc |= AJCSCP_EV_DSR;
	if (CommEvt & EV_CTS	) rc |= AJCSCP_EV_CTS;

	return rc;
}
//==============================================================================================================//
//																												//
//	SCPイベント → COMMイベントコード変換																		//
//																												//
//==============================================================================================================//
UI	ScpEvtToCommEvt(UI ScpEvt)
{
	UI		rc = 0;

	if (ScpEvt & AJCSCP_EV_TXEMPTY) rc |= EV_TXEMPTY;
	if (ScpEvt & AJCSCP_EV_RING	  ) rc |= EV_RING;
	if (ScpEvt & AJCSCP_EV_ERR	  ) rc |= EV_ERR;
	if (ScpEvt & AJCSCP_EV_RLSD	  ) rc |= EV_RLSD;
	if (ScpEvt & AJCSCP_EV_DSR	  ) rc |= EV_DSR;
	if (ScpEvt & AJCSCP_EV_CTS	  ) rc |= EV_CTS;

	return rc;
}
//==============================================================================================================//
//																												//
//	SSEPイベント → SCPイベントコード変換																		//
//																												//
//==============================================================================================================//
UI	SsepEvtToScpEvt(UI SsepEvt)
{
	UI		rc = 0;

	if (SsepEvt & AJCSSEP_EV_TXT )	rc |= AJCSCP_EV_RXTEXT;
	if (SsepEvt & AJCSSEP_EV_ESC )	rc |= AJCSCP_EV_RXESC;
	if (SsepEvt & AJCSSEP_EV_PKT )	rc |= AJCSCP_EV_RXPKT;
	if (SsepEvt & AJCSSEP_EV_CTRL)	rc |= AJCSCP_EV_RXCTRL;
	if (SsepEvt & AJCSSEP_EV_NOPKT) rc |= AJCSCP_EV_RXNOPKT;

	return rc;
}
//==============================================================================================================//
//																												//
//	SCPイベント → SSEPイベントコード変換																		//
//																												//
//==============================================================================================================//
UI	ScpEvtToSsepEvt(UI ScpEvt)
{
	UI		rc = 0;

	if (ScpEvt & AJCSCP_EV_RXTEXT ) rc |= AJCSSEP_EV_TXT;
	if (ScpEvt & AJCSCP_EV_RXESC  ) rc |= AJCSSEP_EV_ESC;
	if (ScpEvt & AJCSCP_EV_RXPKT  ) rc |= AJCSSEP_EV_PKT;
	if (ScpEvt & AJCSCP_EV_RXCTRL ) rc |= AJCSSEP_EV_CTRL;
	if (ScpEvt & AJCSCP_EV_RXNOPKT) rc |= AJCSSEP_EV_NOPKT;

	return rc;
}

//==============================================================================================================//
//	自メールスロット生成とエラー通知																			//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
BOOL	ScpCreateMySlotAndNtcErr(HAJCSCP pW)
{
	BOOL	rc;

	if (!(rc = ScpCreateMySlot(pW))) {
		ScpNtcPortStateToUser(pW, AJCSCP_MYSLOTFAIL);
	}

	return rc;
}
//==============================================================================================================//
//	自メールスロット生成																						//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
BOOL	ScpCreateMySlot(HAJCSCP pW)
{
	BOOL	rc = FALSE;

	//----- 自スロットパス名設定 -------------------------------------------------------------------------------//
	AjcSnPrintF(pW->MySlotPath, AJCTSIZE(pW->MySlotPath), L"\\\\.\\mailslot\\%s", pW->SlotInfo.MySlotName);

	//----- 生成済ならば、一旦破棄 -----------------------------------------------------------------------------//
	if (pW->hSlot != NULL) {
		CloseHandle(pW->hSlot);
		pW->hSlot = NULL;
	}

	//----- 自スロット生成 -------------------------------------------------------------------------------------//
	if (pW->SlotInfo.MySlotName[0] != 0) {
		if ((pW->hSlot = CreateMailslot(pW->MySlotPath, pW->MaxMsgSize, pW->ReadTimeout, pW->pSecAttr)) != INVALID_HANDLE_VALUE) {
			rc = TRUE;
		}
		else {
			pW->hSlot = NULL;
			rc = FALSE;
		}
	}
	else rc = TRUE;

	return rc;
}
//==============================================================================================================//
//	セキュリティ情報退避																						//
//																												//
//	引　数	：	pW						- インスタンスハンドル													//
//				lpSecurityAttributes	- セキュリティ属性へのポインタ											//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
BOOL	ScpSaveSlot(HAJCSCP pW, LPSECURITY_ATTRIBUTES lpSecurityAttributes)
{
	BOOL	rc = FALSE;

	//	既存のセキュリティ情報解放
	if (pW->pSecAttr != NULL) {
		AJCFREE(pW->pSecAttr);
		pW->pSecAttr = NULL;
	}

	//	セキュリティ情報退避
	if (lpSecurityAttributes != NULL) {
		if (pW->pSecAttr = (LPSECURITY_ATTRIBUTES)AJCMEM(lpSecurityAttributes->nLength)) {
			//	セキュリティ属性退避
			memcpy(pW->pSecAttr, lpSecurityAttributes, lpSecurityAttributes->nLength);
			//	セキュリティ記述子退避
			if (lpSecurityAttributes->lpSecurityDescriptor != NULL) {
				memcpy(&pW->secDesc, lpSecurityAttributes->lpSecurityDescriptor, sizeof(SECURITY_DESCRIPTOR));
				pW->pSecAttr->lpSecurityDescriptor = &pW->secDesc;
			}
			rc = TRUE;
		}
		else {
			rc = FALSE;
		}
	}
	else {
		pW->pSecAttr = NULL;
		rc = TRUE;
	}
	return rc;
}
