﻿#include	"AjcInternal.h"
#include	"AjcSerialComPortDef.h"
//**************************************************************************************************************//
//																												//
//	ＣＯＭポート入出力								信号監視スレッド											//
//																												//
//**************************************************************************************************************//
static	UI _stdcall ThreadObsSignal(VOP pParam);

//==============================================================================================================//
//																												//
//	ＣＯＭポートの信号監視スレッド開始																			//
//																												//
//==============================================================================================================//
BOOL	ScpStartThreadObs(HAJCSCP pW)
{
	BOOL	rc = FALSE;

	pW->fThrSObsEnd = FALSE;
	if ((pW->hThreadObs = (HANDLE)_beginthreadex(NULL,				//	セキュリティ
												 0,					//	スタックサイズ
												 ThreadObsSignal,	//	スレッド関数
												 (VOP)pW,			//	スレッド引数
												 0,					//	スレッド初期フラグ
												 &pW->idThreadObs)	//	スレッド識別子
									) != NULL) {
		rc = TRUE;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	ＣＯＭポートの信号監視スレッド																				//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	UI _stdcall ThreadObsSignal(VOP pParam)
{
	HAJCSCP pW	= (HAJCSCP)pParam;
	DWORD	sst;

	while (!pW->fThreadEnd) {
		sst = 0;
		if (ScpGetCommModemStatus(pW, &sst)) {
			if ((pW->GpiState & AJCSCP_FIRST) != 0) {
				ScpNtcEvtToUser(pW, AJCSCP_EV_CTS, NULL, 0, sst);
				ScpNtcEvtToUser(pW, AJCSCP_EV_DSR, NULL, 0, sst);
				pW->GpiState =	sst;
			}
			else {
				if (pW->GpiState != sst) {
					sst &= (MS_CTS_ON | MS_DSR_ON | MS_RING_ON | MS_RLSD_ON);
					if ((sst & MS_CTS_ON ) != (pW->GpiState & MS_CTS_ON )) ScpNtcEvtToUser(pW, AJCSCP_EV_CTS , NULL, 0, sst);
					if ((sst & MS_DSR_ON ) != (pW->GpiState & MS_DSR_ON )) ScpNtcEvtToUser(pW, AJCSCP_EV_DSR , NULL, 0, sst);
					if ((sst & MS_RING_ON) != (pW->GpiState & MS_RING_ON)) ScpNtcEvtToUser(pW, AJCSCP_EV_RING, NULL, 0, sst);
					if ((sst & MS_RLSD_ON) != (pW->GpiState & MS_RLSD_ON)) ScpNtcEvtToUser(pW, AJCSCP_EV_RLSD, NULL, 0, sst);
					pW->GpiState = sst;
				}
			}
		}
		Sleep(1);
	}
	pW->fThrSObsEnd = TRUE;

	return 0;
}
