﻿#include	"AjcInternal.h"
#include	"AjcSerialComPortDef.h"
//**************************************************************************************************************//
//																												//
//	ＣＯＭポート入出力								受信スレッド												//
//																												//
//**************************************************************************************************************//
static	UI _stdcall ThreadReceive(VOP pParam);
static BOOL CALLBACK cbSsepWithRxData(UI evt, VOP pvData, UI lDat, UX cbp);

//==============================================================================================================//
//																												//
//	受信スレッド開始																							//
//																												//
//==============================================================================================================//
BOOL	ScpStartThreadRx(HAJCSCP pW)
{
	BOOL	rc = FALSE;

	//----- ストリーム分離インスタンス生成（受信テキストはバイト文字なので、AjcSsepCreateA()を使用）------------//
	pW->hSsep = AjcSsepCreateA(ScpEvtToSsepEvt(pW->EvtMask), (UX)pW, cbSsepWithRxData);
	AjcSsepEnableMultiThread(pW->hSsep, TRUE);		//	マルチスレッド許可
	AjcSsepSetPktTimeOut	(pW->hSsep, 3000);		//	パケット受信タイムアウト＝３秒
	//----- 受信スレッド開始 -----------------------------------------------------------------------------------//
	pW->fThrRecvEnd = FALSE;
	if ((pW->hThreadRx = (HANDLE)_beginthreadex(NULL,				//	セキュリティ
												0,					//	スタックサイズ
												ThreadReceive,		//	スレッド関数
												(VOP)pW,			//	スレッド引数
												0,					//	スレッド初期フラグ
												&pW->idThreadRx)	//	スレッド識別子
									) != NULL) {
		rc = TRUE;
	}
	return rc;
}

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	ポートからの受信スレッド																					//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	UI _stdcall ThreadReceive(VOP pParam)
{
	HAJCSCP pW	= (HAJCSCP)pParam;

	DWORD		lrx, err, bytes, count;
	COMSTAT		cst;
	BOOL		rsu;
	AJCMBCKIND	mbk;				//	受信テキストコード

	UI		cnt = 0;				//	Tick取得タイミングカウンタ
	ULL		ts = GetTickCount64();	//	最後に受信した時刻
	ULL		tc;						//	最後の受信時刻からの経過時間[ms]

	while (!pW->fThreadEnd) {
		//	クローズ状態ならば、最小時間ウェイト（メールスロット以外）
		if (pW->PortSel != AJCSCP_SEL_MAILSLOT && pW->hPort == NULL) {
			Sleep(1);
			continue;
		}
		//	変数初期化
		lrx = err = bytes = count = 0;
		rsu = FALSE;
		//----- 受信操作 ---------------------------------------------------------------------------------------//
		switch (pW->PortSel) {
			case AJCSCP_SEL_COMPORT:		//	●ＣＯＭポート
				if (rsu = ScpClearCommError(pW, &err, &cst)) {
					//	最大受信サイズをバッファサイズで制限
					lrx = __min(cst.cbInQue, AJCSCPMAX_RXSIZE);
					if (err == 0) {
						if (rsu = ScpReadFile(pW, pW->RxBin, lrx, &bytes, NULL)) {
							memcpy(&pW->RxBuf[pW->ixRxb], pW->RxBin, bytes);
							lrx = bytes;
						}
					}
					else {
						ScpNtcEvtToUser(pW, AJCSCP_EV_ERR, NULL, 0, err);
					}
				}
				break;

			case AJCSCP_SEL_MAILSLOT:		//	●メールスロット
				if (rsu = ScpGetMailslotInfo(pW, NULL, &lrx, &count, NULL)) {

					//	最大受信サイズをバッファサイズで制限する
					//	（実際は、送信側で最大送信サイズを４２０バイトに制限しているので必要ないが、安全の為制限する
					//	　また、メールスロットはデータグラムであるため、lrxを小さくすると受信できない）
					lrx = __min(lrx, AJCSCPMAX_RXSIZE);

					if (count != 0) {
						if (rsu = ScpReadFile(pW, &pW->RxBin, lrx, &bytes, NULL)) {
							memcpy(&pW->RxBuf[pW->ixRxb], pW->RxBin, bytes);
							lrx = bytes;
						}
					}
					else {
						lrx = 0;
					}
				}
				break;

			case AJCSCP_SEL_SOCKET:			//	●ソケット
				//	ソケットイベント検知
				if (WaitForSingleObject(pW->hEvtSock, 0) == WAIT_OBJECT_0) {
					WSANETWORKEVENTS nwev;
					//	非シグナル状態設定
					WSAResetEvent(pW->hEvtSock);
					//	ソケットイベント処理
					if (WSAEnumNetworkEvents((SOCKET)pW->hPort, pW->hEvtSock, &nwev) != SOCKET_ERROR) {
						//	●接続通知
						if (nwev.lNetworkEvents & FD_CONNECT) {
							if (nwev.iErrorCode[FD_CONNECT_BIT] == 0) {
								//	「接続状態」
								pW->fConnect = TRUE;
								//	ポートオープン通知
								ScpNtcPortStateToUser(pW, AJCSCP_OPENED);
							}
							else {
								//	ソケットクローズ
								closesocket((SOCKET)pW->hPort);
								pW->hPort = NULL;
								pW->fConnect   = FALSE;
								pW->fSockRead  = FALSE;
								pW->fSockWrite = FALSE;
								//	ポートオープン失敗通知
								ScpNtcPortStateToUser(pW, AJCSCP_OPENFAIL);
							}
						}
						//	●受信通知
						if (nwev.lNetworkEvents & FD_READ) {
							pW->fSockRead = TRUE;
							if (rsu = ScpReadFile(pW, pW->RxBin, AJCSCPMAX_RXSIZE, &bytes, NULL)) {
								memcpy(&pW->RxBuf[pW->ixRxb], pW->RxBin, bytes);
								lrx = bytes;
							}
						}
						//	●書き込み通知
						if (nwev.lNetworkEvents & FD_WRITE) {
							pW->fSockWrite = TRUE;
						}
						//	●切断通知
						if (nwev.lNetworkEvents & FD_CLOSE) {
							//	フラグクリアー
							pW->fConnect   = FALSE;
							pW->fSockRead  = FALSE;
							pW->fSockWrite = FALSE;
							//	ポートクローズ通知
							ScpNtcPortStateToUser(pW, AJCSCP_CLOSED);
						}
					}
				}
				break;
		}

		//----- 受信操作成功＆受信データ有りならば、受信通知処理 -----------------------------------------------//
		if (rsu && lrx != 0) {	//	受信成功，受信データ有り？
			//	文字コード判定用データ投与
			pW->RxBuf[pW->ixRxb + bytes] = 0;
			AjcSsepPutMbc(pW->hSsep, (C_BCP)pW->RxBuf);
			//	受信テキストコード設定
			switch (pW->RxTxtCode) {
				default:
				case AJCSCP_TXT_SJIS:	mbk = AJCMBC_SJIS;					break;	//	シフトＪＩＳ
				case AJCSCP_TXT_EUC:	mbk = AJCMBC_EUC;					break;	//	ＥＵＣ　　　
				case AJCSCP_TXT_UTF8:	mbk = AJCMBC_UTF8;					break;	//	ＵＴＦ－８　
				case AJCSCP_TXT_AUTO:	mbk = AjcSsepGetMbcKind(pW->hSsep);	break;	//	自動判別　
			}
			//	ストリーム分離処理(前部の中途マルチバイトをスキップした実受信データ) 
			if (bytes != 0 && (pW->EvtMask & AJCSCP_EV_SSEP)) {
				AjcSsepPutData(pW->hSsep, &pW->RxBuf[pW->ixRxb], bytes);
			}
			//	文字列終端(0x00)設定
			pW->RxBuf[pW->ixRxb + lrx] = 0;
			//	実際のデータ長設定（前部の中途マルチバイト数を加算）
			lrx += pW->ixRxb;
			//	チャンクデータ受信通知
			if (pW->EvtMask & AJCSCP_EV_RXCHUNK) {
				//----- バイナリチャンク受信通知 ---------------------------------------------------------------//
				if (pW->ChunkMode & AJCSCP_CM_BIN) {
					UBP		pBin;
					if (pBin = (UBP)AJCMEM(bytes)) {
						memcpy(pBin, &pW->RxBin, bytes);
						ScpNtcEvtToUser(pW, AJCSCP_EV_RXCHUNK, pBin, bytes, 0);
					}
					pW->ixRxb = 0;
				}
				//----- テキストチャンク受信通知 ---------------------------------------------------------------//
				if (pW->ChunkMode & AJCSCP_CM_TEXT) {
					UI			i;
					BCP			p;
					BOOL		fInvChunk = FALSE;

					//	途中に制御コード(0x09～0x0D, 0x1B以外)があるかチェック
					for (i = 0, p = (BCP)&pW->RxBuf[pW->ixRxb]; i < bytes && !pW->fThreadEnd; i++, p++) {
						if (MAjcIsCntrlA((UB)*p) && !MAjcIsSpaceA((UB)*p) && (UB)*p != 0x1B) {
							fInvChunk = TRUE;
							break;
						}
					}
					if (!pW->fThreadEnd) {
						//	有効テキスト長チェック
						if (lrx != 0) {
							//	途中に制御コード(0x09～0x0D以外)がある場合は、不正チャンクテキストとしてバイナリのまま通知する
							if (fInvChunk) {
								UBP		pBin;
								if (pBin = (UBP)AJCMEM(lrx)) {
									memcpy(pBin, pW->RxBuf, lrx);
									ScpNtcEvtToUser(pW, AJCSCP_EV_INVCHUNK, pBin, lrx, 0);
								}
								pW->ixRxb = 0;
							}
							//	正常なテキストチャンク通知
							else {
								//	文字列終端設定
								pW->RxBuf[lrx] = 0;
								//	バッファインデクス設定（前保留データと新受信データを含めたバイト数）
								pW->ixRxb = lrx;
								//	完結した文字列取得とユーザへの通知
								if (pW->fUnicode) {
									WCP		pWcs;
									if (pWcs = AjcExtractCompletedTextW((BCP)pW->RxBuf, AJCSCPMAX_RXSIZE, (UIP)&lrx, mbk)) {
										pW->ixRxb = lrx;
										pW->RxBuf[lrx] = 0;
										ScpNtcEvtToUser(pW, AJCSCP_EV_RXCHUNK, pWcs, (UI)wcslen(pWcs), 2);
									}
								}
								else {
									BCP		pSJis;
									if (pSJis = AjcExtractCompletedTextA((BCP)pW->RxBuf, AJCSCPMAX_RXSIZE, (UIP)&lrx, mbk)) {
										pW->ixRxb = lrx;
										pW->RxBuf[lrx] = 0;
										ScpNtcEvtToUser(pW, AJCSCP_EV_RXCHUNK, pSJis, (UI)strlen(pSJis), 1);
									}
								}
							}
						}
					}
				}
			}
			//----- バイトペアによるワード（14Bit）データ受信 --------------------------------------------------//
			if (pW->EvtMask & AJCSCP_EV_RXWORD14) {
				PAJCSCPUNIWORD	pDat;
				UI				i;
				for (i = 0; i < bytes && !pW->fThreadEnd; i++) {
					if		(pW->BpSeq == 0 && (pW->RxBin[i] & 0x80) != 0) {
						if (pW->fBpLBFirst) pW->BpDat.s.l = pW->RxBin[i];
						else				pW->BpDat.s.h = pW->RxBin[i];
						pW->BpSeq = 1;
					}
					else if (pW->BpSeq == 1 && (pW->RxBin[i] & 0x80) == 0) {
						if (pDat = (PAJCSCPUNIWORD)AJCMEM(sizeof pW->BpDat)) {
							if (pW->fBpLBFirst) pW->BpDat.s.h = pW->RxBin[i];
							else				pW->BpDat.s.l = pW->RxBin[i];
							pDat->w = (((pW->BpDat.w >> 1) & 0x3F80) | (pW->BpDat.w & 0x7F));
							ScpNtcEvtToUser(pW, AJCSCP_EV_RXWORD14, pDat, 2, pW->fBpLBFirst);
						}
						pW->BpSeq = 0;
					}
				}
			}
			//----- パケット外受信テキスト通知（完結した文字列取得とユーザへの通知）----------------------------//
			if (pW->EvtMask & AJCSCP_EV_RXNOPKT) {
				if (pW->ixNpk != 0) {	//	パケット外データ有り
					if (pW->fUnicode) {
						WCP		pWcs;
						if (pWcs = AjcExtractCompletedTextW((BCP)pW->NpBuf, AJCSCPMAX_RXSIZE, (UIP)&pW->ixNpk, mbk)) {
							pW->NpBuf[pW->ixNpk] = 0;
							ScpNtcEvtToUser(pW, AJCSCP_EV_RXNOPKT, pWcs, (UI)wcslen(pWcs), 2);
						}
					}
					else {
						BCP		pSJis;
						if (pSJis = AjcExtractCompletedTextA((BCP)pW->NpBuf, AJCSCPMAX_RXSIZE, (UIP)&pW->ixNpk, mbk)) {
							pW->NpBuf[pW->ixNpk] = 0;
							ScpNtcEvtToUser(pW, AJCSCP_EV_RXNOPKT, pSJis, (UI)strlen(pSJis), 1);
						}
					}
				}
			}
			//	「送信途切れ」算出情報クリアー
			ts = GetTickCount64();	//	最後に受信した時刻
			tc = 0;					//	最後の受信からの経過時間
		}
		else {						//	受信失敗／受信データなし?
			//	最後の受信からの経過時間算出
			if ((cnt++ & 255) == 0) {
				tc = GetTickCount64() - ts;
			}
			//	「受信データ無し」から所定時間経過したら最小時間ウェイト
			if (tc >= pW->MesRxTime) {
				Sleep(1);
			}
		}
	}
	pW->fThrRecvEnd = TRUE;

	return 0;
}

//--------------------------------------------------------------------------------------------------------------//
//	ＳＳＥＰコールバック（AjcSsepPutData()により発生する、分離されたストリームデータ通知）						//
//																												//
//	引	数	：	evt  	- 分離データ種別(AJCSSEP_EV_XXXXX)														//
//				pvData 	- 分離データのアドレス																	//
//				lDat 	- 分離データのバイト数																	//
//				cbp  	- コールバックパラメタ																	//
//																												//
//	戻り値	：	TRUE  - データメモリを開放する																	//
//				FALSE - データメモリを開放しない																//
//--------------------------------------------------------------------------------------------------------------//
static BOOL CALLBACK cbSsepWithRxData(UI evt, VOP pvData, UI lDat, UX cbp)
{
	BOOL		rc = TRUE;
	HAJCSCP		pW = (HAJCSCP)cbp;
	UI			ScpEvt = SsepEvtToScpEvt(evt);	//	イベントコード変換（SSEP→SCP)
	AJCMBCKIND	mbk;							//	受信テキストコード
	BCP			pDat =(BCP)pvData;

	switch (evt) {
		case AJCSSEP_EV_TXT:												//	●テキストデータ
			//	受信テキストコード設定
			switch (pW->RxTxtCode) {
				default:
				case AJCSCP_TXT_SJIS:	mbk = AJCMBC_SJIS;					break;	//	シフトＪＩＳ
				case AJCSCP_TXT_EUC:	mbk = AJCMBC_EUC;					break;	//	ＥＵＣ　　　
				case AJCSCP_TXT_UTF8:	mbk = AJCMBC_UTF8;					break;	//	ＵＴＦ－８　
				case AJCSCP_TXT_AUTO:	mbk = AjcSsepGetMbcKind(pW->hSsep);	break;	//	自動判別　
			}
			//----- UNICODE ------------------------------------------------------------------------------------//
			if (pW->fUnicode) {
				//	● S-JIS
				if (mbk == AJCMBC_SJIS) {
					WCP		pWid;
					UI		lWid;
					lWid = MultiByteToWideChar(CP_ACP, 0, pDat, -1, NULL, 0);
					if (lWid != 0 && (pWid = (WCP)AJCMEM(lWid * 2))) {
						MultiByteToWideChar(CP_ACP, 0, pDat, -1, pWid, lWid);		//	ワイド文字へ変換
						ScpNtcEvtToUser(pW, ScpEvt, pWid, (UI)wcslen(pWid), 2);		//	ワイド文字通知
					}
				}
				//	● EUC
				else if (mbk == AJCMBC_EUC) {
					BCP		pSJis;
					WCP		pWid;
					UI		lSJis, lWid;
					lSJis = AjcEucToSJis(pDat, NULL, 0);
					if (pSJis = (BCP)AJCMEM(lSJis)) {
						AjcEucToSJis(pDat, pSJis, lSJis);
						lWid = MultiByteToWideChar(CP_ACP, 0, pSJis, -1, NULL, 0);	//	EUC->SJIS 変換
						if (lWid != 0 && (pWid = (WCP)AJCMEM(lWid * 2))) {
							MultiByteToWideChar(CP_ACP, 0, pSJis, -1, pWid, lWid);	//	ワイド文字へ変換
							ScpNtcEvtToUser(pW, ScpEvt, pWid, (UI)wcslen(pWid), 2);	//	ワイド文字通知
						}
						free(pSJis);
					}
				}
				//	● UTF-8
				else if (mbk == AJCMBC_UTF8) {
					WCP		pWid;
					UI		lWid;
					lWid = MultiByteToWideChar(CP_UTF8, 0, pDat, -1, NULL, 0);
					if (lWid != 0 && (pWid = (WCP)AJCMEM(lWid * 2))) {
						MultiByteToWideChar(CP_UTF8, 0, pDat, -1, pWid, lWid);
						ScpNtcEvtToUser(pW, ScpEvt, pWid, (UI)wcslen(pWid), 2);		//	ワイド文字通知
					}
				}
				rc = TRUE;															//	pDatを開放する
			}
			//----- マルチバイト -------------------------------------------------------------------------------//
			else {
				BCP		pSJis = pDat;
				UI		lSJis = lDat;
				//	● S-JIS
				if (mbk == AJCMBC_SJIS) {
					ScpNtcEvtToUser(pW, ScpEvt, pDat, lDat, 1);				//	Ｓ－ＪＩＳのまま通知
					rc = FALSE;												//	pDatは解放しない
				}
				//	● EUC
				else if (mbk == AJCMBC_EUC) {
					lSJis = AjcEucToSJis(pDat, NULL, 1);
					if (pSJis = (BCP)AJCMEM(lSJis)) {						//	変換可能？
						AjcEucToSJis(pDat, pSJis, lSJis);					//		Ｓ－ＪＩＳへ変換
						lSJis = (UI)strlen(pSJis);
						ScpNtcEvtToUser(pW, ScpEvt, pSJis, lSJis, 1);			//		変換した文字列を通知
					}
					rc = TRUE;												//	pDatは解放する
				}
				//	● UTF-8
				else if (mbk == AJCMBC_UTF8) {
					lSJis = AjcUtf8ToMbc(pDat, NULL, 1);					//
					if (pSJis = (BCP)AJCMEM(lSJis)) {						//	変換可能？
						AjcUtf8ToMbc(pDat, pSJis, lSJis);					//		Ｓ－ＪＩＳへ変換
						lSJis = (UI)strlen(pSJis);
						ScpNtcEvtToUser(pW, ScpEvt, pSJis, lSJis, 1);			//		変換した文字列を通知
					}
					rc = TRUE;												//	pDatは解放する
				}
			}
			break;

		case AJCSSEP_EV_ESC:												//	●ＥＳＣコードデータ
		case AJCSSEP_EV_CTRL:												//	●制御コード
			if (pW->fUnicode) {												//		ワイド文字？
				WCP		pWid;
				UI		lWid;
				lWid = MultiByteToWideChar(CP_ACP, 0, pDat, -1, NULL, 0);
				if (lWid != 0 && (pWid = (WCP)AJCMEM(lWid * 2))) {
					MultiByteToWideChar(CP_ACP, 0, pDat, -1, pWid, lWid);	//			ワイド文字へ変換
					ScpNtcEvtToUser(pW, ScpEvt, pWid, (UI)wcslen(pWid), 2);	//			ワイド文字通知
				}
				rc = TRUE;													//			pDatを開放する
			}
			else {															//		バイト文字？
				ScpNtcEvtToUser(pW, ScpEvt, pDat, lDat, 1);					//			通知データのまま通知
				rc = FALSE;													//			pDatは解放しない
			}
			break;

		case AJCSSEP_EV_PKT:												//	●パケットデータ
			ScpNtcEvtToUser(pW, ScpEvt, pDat, lDat, 0);						//		パケットデータ通知
			rc = FALSE;														//		pDatは解放しない
			break;

		case AJCSSEP_EV_NOPKT:												//	●パケット外バイトデータ
			if (pW->ixNpk < AJCSCPMAX_RXSIZE) {								//		パケット外データバッファにデータ格納
				pW->NpBuf[pW->ixNpk++] = *pDat;
				pW->NpBuf[pW->ixNpk  ] = 0;
			}
			rc = TRUE;														//		pDatは解放する
			break;
	}
	return rc;
}
