﻿#include	"AjcInternal.h"
#include	"AjcSerialComPortDef.h"
//**************************************************************************************************************//
//																												//
//	ＣＯＭポート入出力								送信スレッド												//
//																												//
//**************************************************************************************************************//
static	UI _stdcall ThreadTransmit(VOP pParam);

//==============================================================================================================//
//																												//
//	送信スレッド開始																							//
//																												//
//==============================================================================================================//
BOOL	ScpStartThreadTx(HAJCSCP pW)
{
	BOOL	rc = FALSE;

	pW->fThrSendEnd = FALSE;
	if ((pW->hThreadTx = (HANDLE)_beginthreadex(NULL,				//	セキュリティ
												0,					//	スタックサイズ
												ThreadTransmit,		//	スレッド関数
												(VOP)pW,			//	スレッド引数
												0,					//	スレッド初期フラグ
												&pW->idThreadTx)	//	スレッド識別子
									) != NULL) {
		rc = TRUE;
	}
	return rc;
}

//--------------------------------------------------------------------------------------------------------------//
//																												//
//	ポートへの送信スレッド																						//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	UI _stdcall ThreadTransmit(VOP pParam)
{
	HAJCSCP pW	= (HAJCSCP)pParam;
	UBP		p;
	int		len;
	DWORD	ltx;
	UB		txd[AJCSCPMAX_TXSIZE_COMPORT];

	UI		cnt = 0;				//	Tick取得タイミングカウンタ
	ULL		ts = GetTickCount64();	//	最後に送信を実行した時刻
	ULL		tc;						//	最後に送信を実行した時刻からの経過時間[ms]

	while (!pW->fThreadEnd) {
		if (pW->hPort != NULL) {		//	ポートオープン状態？
			if (len = AjcVMbxDeque(pW->hVMbxTxD, txd, sizeof txd, 0)) {	//	送信データあり？
				//	送信中の旨、フラグ設定
				pW->fTxBusy = TRUE;
				//	データ送信ループ
				p			= txd;
				while (len > 0 && !pW->fThreadEnd) {
					//	データ送信
					if (!ScpWriteFile(pW, p, len, &ltx, NULL)) {
						ScpNtcPortStateToUser(pW, AJCSCP_TXFAILURE);
						break;
					}
					//	バイト数カウンタ，ポインタ更新
					p	+= ltx;
					len -= ltx;
					//	送信データ投与未了の場合、最小時間ウェイト
					if (len > 0) {
						Sleep(1);
					}
				}
				//	「送信途切れ」算出情報クリアー
				ts = GetTickCount64();	//	最後に送信した時刻
				tc = 0;					//	最後の送信からの経過時間
			}
			else {														//	送信データ無し？
				//	最後の送信からの経過時間算出
				if ((cnt++ & 255) == 0) {
					tc = GetTickCount64() - ts;
				}
				//	最後の送信から所定時間経過したら最小時間ウェイト＆送信速度制限情報初期化
				if (tc >= pW->MesTxTime) {
					//	最小時間ウェイト
					Sleep(1);
					//	メールスロット時の送信速度制限情報初期化
					EnterCriticalSection(&pW->CsTxDelay);
					pW->TxDelayBytesCount	= 0;						//	送信遅延用バイトカウンタ
					pW->TxDelayTickCount	= 0;						//	送信遅延用計測時間[us]
					LeaveCriticalSection(&pW->CsTxDelay);
				}
				//	ユーザへ送信完了通知
				if (pW->fTxBusy) {
					pW->fTxBusy = FALSE;
					ScpNtcEvtToUser(pW, AJCSCP_EV_TXEMPTY , NULL, 0, 0);
				}
			}
		}
		else {							//	ポート・クローズ状態?
			//	全送信データ破棄
			AjcVMbxPurge(pW->hVMbxTxD);
			//	最小時間ウェイト
			Sleep(1);
		}
	}
	pW->fThrSendEnd = TRUE;

	return 0;
}
