﻿#include	"AjcInternal.h"
#include	"AjcSerialComPortDef.h"
//**************************************************************************************************************//
//																												//
//	ＣＯＭポート入出力								システムＡＰＩのラッパー									//
//																												//
//**************************************************************************************************************//

//┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓
//┃																											┃
//┃ポート入出力ＡＰＩのラッパー																				┃
//┃																											┃
//┗━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┛
//----- メールスロット受信情報設定 ------------------------------------------------------------------------------//
BOOL			ScpGetMailslotInfo(HAJCSCP pW, LPDWORD lpMaxMessageSize, LPDWORD lpNextSize, LPDWORD lpMessageCount, LPDWORD lpReadTimeout)
{
	BOOL	rc = FALSE;
	EnterCriticalSection(&pW->CsCommApi);
	if (pW->hSlot != NULL) {
		rc = GetMailslotInfo(pW->hSlot, lpMaxMessageSize, lpNextSize, lpMessageCount, lpReadTimeout);
	}
	LeaveCriticalSection(&pW->CsCommApi);
	return rc;
}
//==============================================================================================================//
BOOL			ScpClearCommBreak		(HAJCSCP pW)
{
	BOOL	rc = FALSE;

	EnterCriticalSection(&pW->CsCommApi);
	if (pW->hPort != NULL) {
		rc = ClearCommBreak(pW->hPort);
	}
	LeaveCriticalSection(&pW->CsCommApi);
	return rc;
}
//==============================================================================================================//
BOOL		   ScpClearCommError		(HAJCSCP pW, LPDWORD lpErrors, LPCOMSTAT lpStat)
{
	BOOL	rc = FALSE;

	EnterCriticalSection(&pW->CsCommApi);
	if (pW->hPort != NULL) {
		rc = ClearCommError(pW->hPort, lpErrors, lpStat);
	}
	LeaveCriticalSection(&pW->CsCommApi);
	return rc;
}
//==============================================================================================================//
BOOL		   ScpEscapeCommFunction	(HAJCSCP pW, DWORD dwFunc)
{
	BOOL	rc = FALSE;

	EnterCriticalSection(&pW->CsCommApi);
	if (pW->hPort != NULL) {
		rc = EscapeCommFunction(pW->hPort, dwFunc);
	}
	LeaveCriticalSection(&pW->CsCommApi);
	return rc;
}
//==============================================================================================================//
BOOL		   ScpGetCommModemStatus	(HAJCSCP pW, LPDWORD lpModemStat)
{
	BOOL	rc = FALSE;

	EnterCriticalSection(&pW->CsCommApi);
	if (pW->hPort != NULL) {
		rc = GetCommModemStatus(pW->hPort, lpModemStat);
	}
	LeaveCriticalSection(&pW->CsCommApi);
	return rc;
}
//==============================================================================================================//
BOOL		   ScpGetCommState			(HAJCSCP pW, LPDCB lpDCB)
{
	BOOL	rc = FALSE;

	EnterCriticalSection(&pW->CsCommApi);
	if (pW->hPort != NULL) {
		rc = GetCommState(pW->hPort, lpDCB);
	}
	LeaveCriticalSection(&pW->CsCommApi);
	return rc;
}
//==============================================================================================================//
BOOL		   ScpGetCommTimeouts		(HAJCSCP pW, LPCOMMTIMEOUTS lpCommTimeouts)
{
	BOOL	rc = FALSE;

	EnterCriticalSection(&pW->CsCommApi);
	if (pW->hPort != NULL) {
		rc = GetCommTimeouts(pW->hPort, lpCommTimeouts);
	}
	LeaveCriticalSection(&pW->CsCommApi);
	return rc;
}
//==============================================================================================================//
BOOL		   ScpPurgeComm				(HAJCSCP pW, DWORD dwFlags)
{
	BOOL	rc = FALSE;

	EnterCriticalSection(&pW->CsCommApi);
	if (pW->hPort != NULL) {
		rc = PurgeComm(pW->hPort, dwFlags);
	}
	LeaveCriticalSection(&pW->CsCommApi);
	return rc;
}
//==============================================================================================================//
BOOL		   ScpSetCommBreak			(HAJCSCP pW)
{
	BOOL	rc = FALSE;

	EnterCriticalSection(&pW->CsCommApi);
	if (pW->hPort != NULL) {
		rc = SetCommBreak(pW->hPort);
	}
	LeaveCriticalSection(&pW->CsCommApi);
	return rc;
}
//==============================================================================================================//
BOOL		   ScpSetCommMask			(HAJCSCP pW, DWORD dwMask)
{
	BOOL	rc = FALSE;

	EnterCriticalSection(&pW->CsCommApi);
	if (pW->hPort != NULL) {
		rc = SetCommMask(pW->hPort, dwMask);
	}
	LeaveCriticalSection(&pW->CsCommApi);
	return rc;
}
//==============================================================================================================//
BOOL		   ScpSetCommState			(HAJCSCP pW, LPDCB lpDCB)
{
	BOOL	rc = FALSE;

	EnterCriticalSection(&pW->CsCommApi);
	if (pW->hPort != NULL) {
		rc = SetCommState(pW->hPort, lpDCB);
	}
	LeaveCriticalSection(&pW->CsCommApi);
	return rc;
}
//==============================================================================================================//
BOOL		   ScpSetCommTimeouts		(HAJCSCP pW, LPCOMMTIMEOUTS lpCommTimeouts)
{
	BOOL	rc = FALSE;

	EnterCriticalSection(&pW->CsCommApi);
	if (pW->hPort != NULL) {
		rc = SetCommTimeouts(pW->hPort, lpCommTimeouts);
	}
	LeaveCriticalSection(&pW->CsCommApi);
	return rc;
}
//==============================================================================================================//
BOOL		   ScpSetupComm				(HAJCSCP pW, DWORD dwInQUeue, DWORD dwOutQueue)
{
	BOOL	rc = FALSE;

	EnterCriticalSection(&pW->CsCommApi);
	if (pW->hPort != NULL) {
		rc = SetupComm(pW->hPort, dwInQUeue, dwOutQueue);
	}
	LeaveCriticalSection(&pW->CsCommApi);
	return rc;
}
//==============================================================================================================//
BOOL		   ScpWaitCommEvent			(HAJCSCP pW, LPDWORD lpEvtMask, LPOVERLAPPED lpOverlapped)
{
	BOOL	rc = FALSE;

	EnterCriticalSection(&pW->CsCommApi);
	if (pW->hPort != NULL) {
		rc = WaitCommEvent(pW->hPort, lpEvtMask, lpOverlapped);
	}
	LeaveCriticalSection(&pW->CsCommApi);
	return rc;
}
//==============================================================================================================//
HANDLE			ScpOpenFile(HAJCSCP pW)
{
	HANDLE		rc = NULL;
	WC			PortName[MAX_PATH];

	EnterCriticalSection(&pW->CsCommApi);
	switch (pW->PortSel) {
		case AJCSCP_SEL_COMPORT:		//	●ＣＯＭポート
			AjcSnPrintF(PortName, AJCTSIZE(PortName), L"\\\\.\\COM%u"		, pW->PortNo	);
			rc = CreateFile(PortName, GENERIC_WRITE | GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
			break;

		case AJCSCP_SEL_MAILSLOT:		//	●メールスロット
			if (pW->SlotInfo.RmtHostName[0] == 0 || AjcStrSameAsAllChar(pW->SlotInfo.RmtHostName, L' ')) 
				AjcSnPrintF(PortName, AJCTSIZE(PortName), L"\\\\.\\mailslot\\%s" ,							 pW->SlotInfo.RmtSlotName);
			else
				AjcSnPrintF(PortName, AJCTSIZE(PortName), L"\\\\%s\\mailslot\\%s", pW->SlotInfo.RmtHostName, pW->SlotInfo.RmtSlotName);

			rc = CreateFile(PortName, GENERIC_WRITE, FILE_SHARE_READ | FILE_SHARE_WRITE, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
			break;

		case AJCSCP_SEL_SOCKET:			//	●ソケット
		{	ADDRINFOW	hints;
			ADDRINFOW	*pAI = NULL;
			UI			rsu;
			WC			szPort[AJCMAX_PORTNAME_LENGTH + 1];
			//	ソケット接続
			AjcSnPrintF(szPort, AJCTSIZE(szPort), L"%u", pW->SockInfo.PortNo);
			memset(&hints, 0, sizeof hints);
			hints.ai_family   = AF_INET;
			hints.ai_socktype = SOCK_STREAM;
			hints.ai_flags    = AI_PASSIVE;
			if (GetAddrInfoW(pW->SockInfo.ServName, szPort, &hints, &pAI) == 0 && pAI != NULL) {
				pW->hPort = (HANDLE)socket(pAI->ai_family,  pAI->ai_socktype, pAI->ai_protocol);
				if ((SOCKET)pW->hPort != INVALID_SOCKET) {
					WSAEventSelect((SOCKET)pW->hPort, pW->hEvtSock, FD_CONNECT | FD_WRITE | FD_READ | FD_CLOSE);
					//	接続
					rsu = connect((SOCKET)pW->hPort, pAI->ai_addr, (int)pAI->ai_addrlen);
					//	connect成功ならば、戻り値＝ソケットハンドル
					if (rsu != SOCKET_ERROR || WSAGetLastError() == WSAEWOULDBLOCK) {
						rc = pW->hPort;
					}
					//	connect失敗ならば、ソケットを閉じてNULLを返す
					else {
						closesocket((SOCKET)pW->hPort);
						rc = (HANDLE)INVALID_SOCKET;
					}
				}
				FreeAddrInfoW(pAI);
			}
			break;
		}
	}

	if (rc != INVALID_HANDLE_VALUE) {	// ※INVALID_HANDLE_VALUE と INVALID_SOCKETは同じ値( -1 )
		pW->hPort = rc;
	}
	else {
		pW->hPort = NULL;
		rc		  = NULL;
	}
	LeaveCriticalSection(&pW->CsCommApi);
	return rc;
}
//==============================================================================================================//
BOOL			ScpCloseFile(HAJCSCP pW)
{
	BOOL	rc = FALSE;

	EnterCriticalSection(&pW->CsCommApi);
	switch (pW->PortSel) {
		case AJCSCP_SEL_COMPORT:	if (pW->hPort != NULL) {								//	●ＣＯＭポート
										rc =  CloseHandle(pW->hPort);
									}
									break;

		case AJCSCP_SEL_MAILSLOT:	if (pW->fTxSlotOpened) {								//	●メールスロット
										if (pW->hPort != NULL) {
											rc =  CloseHandle(pW->hPort);
										}
										else {
											rc = TRUE;	//	送信スロット未オープン時は、クローズ成功を仮定
										}
										pW->fTxSlotOpened = FALSE;
									}
									break;

		case AJCSCP_SEL_SOCKET:		if (pW->hPort != NULL) {
										WSAEventSelect((SOCKET)pW->hEvtSock, NULL, 0);			//	●ソケット
										rc = TRUE;
										if (shutdown   ((SOCKET)pW->hPort, SD_BOTH) != 0) rc = FALSE;
										if (closesocket((SOCKET)pW->hPort		  ) != 0) rc = FALSE;
										pW->fConnect   = FALSE;
										pW->fSockRead  = FALSE;
										pW->fSockWrite = FALSE;
									}
									break;
	}
	pW->hPort = NULL;
	LeaveCriticalSection(&pW->CsCommApi);

	return rc;
}
//==============================================================================================================//
BOOL		   ScpReadFile(HAJCSCP pW, LPVOID lpBuffer, DWORD dwNumberOfBytesToRead,
											LPDWORD lpdwNumberOfBytesRead, LPOVERLAPPED lpOverLapped)
{
	BOOL	rc = FALSE;

	EnterCriticalSection(&pW->CsCommApi);

	*lpdwNumberOfBytesRead = 0;

	switch (pW->PortSel) {
		case AJCSCP_SEL_COMPORT:		//	●ＣＯＭポート
			if (pW->hPort != NULL) {
				//	ＣＯＭポート読み出し
				if (!(rc = ReadFile(pW->hPort, lpBuffer, dwNumberOfBytesToRead, lpdwNumberOfBytesRead, lpOverLapped))) {
					ScpNtcEvtToUser(pW, AJCSCP_EV_ERR, NULL, 0, AJCSCP_CE_RXERR);
				}
			}
			break;

		case AJCSCP_SEL_MAILSLOT:		//	●メールスロット
			if (pW->hSlot != NULL) {
				//	自メールスロットからデータ読み出し
				if (!(rc = ReadFile(pW->hSlot, lpBuffer, dwNumberOfBytesToRead, lpdwNumberOfBytesRead, lpOverLapped))) {
					ScpNtcEvtToUser(pW, AJCSCP_EV_ERR, NULL, 0, AJCSCP_CE_RXERR);
				}
				//	メールスロットがオープン状態でない場合は、読み出しバイト数＝０とする
				//	※ ポートクローズ(AjcScpClose)しても、自メールスロットは生きている。
				//	   このため、ポートクローズ(AjcScpClose)しても、自メールスロットによる受信メカニズムは生きている。
				//	   ポートクローズ(AjcScpClose)した場合は、受信バイト数を０として、あたかも受信されていないように偽装する。
				if (!pW->fTxSlotOpened) {
					*lpdwNumberOfBytesRead = 0;
				}
			}
			break;

		case AJCSCP_SEL_SOCKET:			//	●ソケット
		{	UI		rxl;
			UI		RetryCnt;
			if (pW->hPort != NULL) {
				//	ソケット読み出し
				if (pW->fSockRead) {
					pW->fSockRead = FALSE;
					//	受信データ読み出し
					rxl = recv((SOCKET)pW->hPort, (BCP)lpBuffer, dwNumberOfBytesToRead, 0);
					//	すぐには完了できない非ブロッキング・ソケットの操作の場合はリトライ
					RetryCnt = 0;
					while (rxl == SOCKET_ERROR && WSAGetLastError() == WSAEWOULDBLOCK && RetryCnt < SCP_RTY_WSAEWOULDBLOCK && !pW->fThreadEnd) {
						LeaveCriticalSection(&pW->CsCommApi);
						Sleep(SCP_TIM_WSAEWOULDBLOCK);
						EnterCriticalSection(&pW->CsCommApi);
						RetryCnt++;
						rxl = recv((SOCKET)pW->hPort, (BCP)lpBuffer, dwNumberOfBytesToRead, 0);
					}
					//	受信ＯＫならば、受信バイト数設定
					if (rxl != SOCKET_ERROR) {
						*lpdwNumberOfBytesRead = rxl;
						rc = TRUE;
					}
					//	受信ＮＧならば、受信エラー通知
					else {
						ScpNtcEvtToUser(pW, AJCSCP_EV_ERR, NULL, 0, AJCSCP_CE_RXERR);
					}
				}
			}
			break;
		}
	}
	LeaveCriticalSection(&pW->CsCommApi);
	return rc;
}
//==============================================================================================================//
BOOL		   ScpWriteFile(HAJCSCP pW, LPVOID lpBuffer, DWORD dwNumberOfBytesToWrite,
										LPDWORD lpdwNumberOfBytesWrite, LPOVERLAPPED lpOverLapped)
{
	BOOL	rc = FALSE;

	EnterCriticalSection(&pW->CsCommApi);

	*lpdwNumberOfBytesWrite = 0;

	switch (pW->PortSel) {
		case AJCSCP_SEL_COMPORT:		//	●ＣＯＭポート
			if (pW->hPort != NULL) {
				if (!(rc = WriteFile(pW->hPort, lpBuffer, dwNumberOfBytesToWrite, lpdwNumberOfBytesWrite, lpOverLapped))) {
					ScpNtcEvtToUser(pW, AJCSCP_EV_ERR, NULL, 0, AJCSCP_CE_TXERR);
				}
			}
			break;

		case AJCSCP_SEL_MAILSLOT:		//	●メールスロット
		{	ULL		cyc;
			UI		bps;
			if (pW->hPort != NULL) {
				//----- 送信速度制限情報の排他制御 -----------------------------------------------------------------//
				if (pW->fTxDelay) {
					EnterCriticalSection(&pW->CsTxDelay);
				}
				//----- 送信開始時からの経過時間算出 ---------------------------------------------------------------//
				if (pW->fTxDelay) {
					if (pW->TxDelayBytesCount == 0) {
					//	AjcTrace(L"TxDelayBytesCount == 0\n");	// @@@
						pW->TxDelayTickCount = 0;
						AjcMesTimeInterval(pW->hMesTxDelay);
					}
					else {
						//	周期時間[us]取得
						cyc = AjcMesTimeInterval(pW->hMesTxDelay);
						//	送信時間加算
						pW->TxDelayTickCount += cyc;
					}
					//	送信バイト数加算
					pW->TxDelayBytesCount  += dwNumberOfBytesToWrite;
				}
				//----- メールスロットへデータ送信 -----------------------------------------------------------------//
				if (rc = WriteFile(pW->hPort, lpBuffer, dwNumberOfBytesToWrite, lpdwNumberOfBytesWrite, lpOverLapped)) {
					//----- 送信速度制限 ---------------------------------------------------------------------------//
					if (pW->fTxDelay) {
						if (pW->TxDelayTickCount != 0) {
							bps = (UI)((pW->TxDelayBytesCount * (ULL)1000000) / pW->TxDelayTickCount);
							if (bps > pW->TxDelayBPS) {
							//	AjcTrace(L"bps = %d, TxDelayBytesCount=%lld, TxDelayTickCount=%lld\n", bps, pW->TxDelayBytesCount, pW->TxDelayTickCount);	// @@@
								Sleep(1); // 最小時間ウェイト
							}
						}
					}
				}
				else {
					ScpNtcEvtToUser(pW, AJCSCP_EV_ERR, NULL, 0, AJCSCP_CE_TXERR);
				}
				//----- 送信速度制限情報の排他制御 -----------------------------------------------------------------//
				if (pW->fTxDelay) {
					LeaveCriticalSection(&pW->CsTxDelay);
				}
			}
			break;
		}
		case AJCSCP_SEL_SOCKET:			//	●ソケット
		{	UI		txl;
			UI		RetryCnt;
			if (pW->hPort != NULL) {
				if (pW->fSockWrite) {
					//	データ送信
					txl = send((SOCKET)pW->hPort, (BCP)lpBuffer, dwNumberOfBytesToWrite, 0);
					//	すぐには完了できない非ブロッキング・ソケットの操作の場合はリトライ
					RetryCnt = 0;
					while (txl == SOCKET_ERROR && WSAGetLastError() == WSAEWOULDBLOCK && RetryCnt < SCP_RTY_WSAEWOULDBLOCK && !pW->fThreadEnd) {
						LeaveCriticalSection(&pW->CsCommApi);
						Sleep(SCP_TIM_WSAEWOULDBLOCK);
						EnterCriticalSection(&pW->CsCommApi);
						RetryCnt++;
						txl = send((SOCKET)pW->hPort, (BCP)lpBuffer, dwNumberOfBytesToWrite, 0);
					}
				//	#ifdef _DEBUG
				//		if (RetryCnt != 0) {
				//			AjcTrace("RetryCnt = %d\n", RetryCnt);
				//		}
				//	#endif
					//	送信ＯＫならば、送信バイト数設定
					if (txl != SOCKET_ERROR) {
						*lpdwNumberOfBytesWrite = txl;
						rc = TRUE;
					}
					//	送信ＮＧならば、送信エラー通知
					else {
						ScpNtcEvtToUser(pW, AJCSCP_EV_ERR, NULL, 0, AJCSCP_CE_TXERR);
					}
				}
			}
			break;
		}
	}
	LeaveCriticalSection(&pW->CsCommApi);

	return rc;
}
