﻿#include	"AjcInternal.h"
#include	"AjcSockClientDef.h"
//**************************************************************************************************************//
//																												//
//	ソケット ( TCP/IP ) クライアント処理						ＭＳＩＬ（.NET Framework）対応処理				//
//																												//
//**************************************************************************************************************//
#define	WM_SCT_FORMSIL	(WM_APP + 101)

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC_DEF(MSIL);

//==============================================================================================================//
//																												//
//	ウインドプロシージャ・エントリポイントを返す																//
//																												//
//==============================================================================================================//
WNDPROC		SctWndProcMSIL()
{
	return AJC_WNDPROC_NAME(MSIL);
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	ＭＳＩＬ用サポートコード																					//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//----- ワーク形式 ---------------------------------------------------------------------------------------------//
typedef struct {
	HAJCSCT		hSct;
	VO	 (CALLBACK *cbRxText		)(C_WCP text);
	VO	 (CALLBACK *cbRxEsc			)(C_WCP text);
	VO	 (CALLBACK *cbRxCtrl		)(int	ctrl);
	VO	 (CALLBACK *cbRxPacket		)(C_VOP pData, int lData);
	VO	 (CALLBACK *cbRxNoPkt		)(C_WCP text);
	VO	 (CALLBACK *cbTxEmpty		)(VO);
	VO	 (CALLBACK *cbRxChunkTxt	)(C_WCP text);
	VO	 (CALLBACK *cbRxChunkBin	)(C_VOP pData, int lData);
	VO	 (CALLBACK *cbRxInvChunk	)(C_VOP pData, int lData);
	VO	 (CALLBACK *cbConnect		)(VO);
	VO	 (CALLBACK *cbDisconnect	)(VO);
	VO	 (CALLBACK *cbCnFail		)(int err);
	VO	 (CALLBACK *cbRecvError		)(BOOL fOverlapped);
	VO	 (CALLBACK *cbSendError		)(BOOL fOverlapped);
	VO	 (CALLBACK *cbGeneralError	)(UI ErrCode);
} WKMSIL, *PWKMSIL;
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	コントロールウインド生成																					//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
AJCEXPORT HAJCSCT WINAPI AjcSctCreateForMSIL(	VO	 (CALLBACK *cbRxText		)(C_WCP text),
												VO	 (CALLBACK *cbRxEsc			)(C_WCP text),
												VO	 (CALLBACK *cbRxCtrl		)(int	ctrl),
												VO	 (CALLBACK *cbRxPacket		)(C_VOP pData, int lData),
												VO	 (CALLBACK *cbRxNoPkt		)(C_WCP text),
												VO	 (CALLBACK *cbTxEmpty		)(VO),
												VO	 (CALLBACK *cbRxChunkTxt	)(C_WCP text),
												VO	 (CALLBACK *cbRxChunkBin	)(C_VOP pData, int lData),
												VO	 (CALLBACK *cbRxInvChunk	)(C_VOP pData, int lData),
												VO	 (CALLBACK *cbConnect		)(VO),
												VO	 (CALLBACK *cbDisconnect	)(VO),
												VO	 (CALLBACK *cbCnFail		)(int err),
												VO	 (CALLBACK *cbRecvError		)(BOOL fOverlapped),
												VO	 (CALLBACK *cbSendError		)(BOOL fOverlapped),
												VO	 (CALLBACK *cbGeneralError	)(UI ErrCode))
{
	HAJCSCT		hSct   = NULL;
	HWND		hDummy = NULL;
	PWKMSIL		pWk    = NULL;

	do {
		//----- ワーク領域確保 ---------------------------------------------------------------------------------//
		if ((pWk = (PWKMSIL)AJCMEM(sizeof(WKMSIL))) == NULL) break;
		memset(pWk, 0, sizeof(WKMSIL));
		pWk->hSct			= AjcSctCreate();	//	ＳＳＶインスタンス生成
		if (pWk->hSct == NULL) break;
		pWk->cbRxText		= cbRxText;
		pWk->cbRxEsc		= cbRxEsc;
		pWk->cbRxCtrl		= cbRxCtrl;
		pWk->cbRxPacket	 	= cbRxPacket;
		pWk->cbRxNoPkt		= cbRxNoPkt;
		pWk->cbTxEmpty		= cbTxEmpty;
		pWk->cbRxChunkTxt	= cbRxChunkTxt;
		pWk->cbRxChunkBin	= cbRxChunkBin;
		pWk->cbRxInvChunk	= cbRxInvChunk;
		pWk->cbConnect		= cbConnect;
		pWk->cbDisconnect	= cbDisconnect;
		pWk->cbCnFail		= cbCnFail;
		pWk->cbRecvError	= cbRecvError;
		pWk->cbSendError	= cbSendError;
		pWk->cbGeneralError	= cbGeneralError;

		//----- MSILウインド生成 -------------------------------------------------------------------------------//
		hDummy = CreateWindow((WCP)SctClassForMSIL,		// window class name
								L"",							// window caption
								WS_OVERLAPPEDWINDOW,		// window style
								0,							// initial x position
								0,							// initial y position
								0,							// initial x size
								0,							// initial y size
								NULL,						// parent window handle
								NULL,						// window menu handle
								hDllInst,					// program instance handle
								(VOP)pWk);					// creation parameters
		if (hDummy == INVALID_HANDLE_VALUE) {hDummy = NULL; break;}
		//----- 戻り値（コントロールハンドル）設定 -------------------------------------------------------------//
		hSct = pWk->hSct;
		//----- ダミーウインドハンドルをＳＣＰインスタンスに退避 -----------------------------------------------//
		hSct->hWndForMsil = hDummy;
		//----- ウインド非表示 ---------------------------------------------------------------------------------//
		ShowWindow(hDummy, SW_HIDE);
	} while(0);

	//----- エラーならばリソース解放 ---------------------------------------------------------------------------//
	if (hSct == NULL || hDummy == NULL) {
		if (pWk != NULL) {
			if (hSct   != NULL) AjcSctDelete(hSct);
			if (hDummy != NULL) DestroyWindow(hDummy);
			free(pWk);
		}
		hSct = NULL;
	}
	return hSct;
}

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	ウインドプロシージャ																						//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
AJC_WNDPROC(MSIL, WM_CREATE		)
{
	LRESULT		rc	  = -1;
	HWND		hCtrl = NULL;
	PWKMSIL		pWk   = (PWKMSIL)(((LPCREATESTRUCT)lParam)->lpCreateParams);

	do {
		//----- ワークポインタ退避 -----------------------------------------------------------------------------//
		MAjcSetWindowLong(hwnd, 0, (UX)pWk);
		//----- 戻り値=正常 ------------------------------------------------------------------------------------//
		rc = 0;
	} while(0);

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(MSIL, WM_DESTROY	)
{
	PWKMSIL		pWk = (PWKMSIL)MAjcGetWindowLong(hwnd, 0);

	if (pWk != NULL) {
		free(pWk);
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(MSIL, WM_SCT_FORMSIL)
{
	PWKMSIL			pWk = (PWKMSIL)MAjcGetWindowLong(hwnd, 0);
	VOP				pDat;
	UI				len, param;

	AjcSctGetEventData(pWk->hSct, lParam, &pDat, &len, &param);

	//----- 接続通知 -------------------------------------------------------------------------------------------//
	if		((wParam & AJCSCT_EV_CONNECT	) != 0	&&	pWk->cbRxText		!= NULL) {
		pWk->cbConnect();
	}
	//----- 切断通知 -------------------------------------------------------------------------------------------//
	if		((wParam & AJCSCT_EV_DISCONNECT	) != 0	&&	pWk->cbRxText		!= NULL) {
		pWk->cbDisconnect();
	}
	//----- 接続失敗通知 ---------------------------------------------------------------------------------------//
	if		((wParam & AJCSCT_EV_CNFAIL		) != 0	&&	pWk->cbCnFail		!= NULL) {
		pWk->cbCnFail(param);
	}
	//----- テキスト受信通知 -----------------------------------------------------------------------------------//
	if		((wParam & AJCSCT_EV_RXTEXT		) != 0	&&	pWk->cbRxText		!= NULL) {
		pWk->cbRxText(pDat);
	}
	//----- ＥＳＣコード受信通知 -------------------------------------------------------------------------------//
	if		((wParam & AJCSCT_EV_RXESC		) != 0	&&	pWk->cbRxEsc		!= NULL) {
		pWk->cbRxEsc(pDat);
	}
	//----- 制御コード受信通知 ---------------------------------------------------------------------------------//
	if		((wParam & AJCSCT_EV_RXCTRL		) != 0	&&	pWk->cbRxCtrl		!= NULL) {
		pWk->cbRxCtrl(*((UBP)pDat));
	}
	//----- パケットデータ受信通知 -----------------------------------------------------------------------------//
	if		((wParam & AJCSCT_EV_RXPKT		) != 0	&&	pWk->cbRxPacket	!= NULL) {
		pWk->cbRxPacket(pDat, len);
	}
	//----- パケット外データ受信 -------------------------------------------------------------------------------//
	if		((wParam & AJCSCT_EV_RXNOPKT	) != 0	&&	pWk->cbRxNoPkt 	!= NULL) {
		pWk->cbRxNoPkt((C_WCP)pDat);
	}
	//----- 送信完了 -------------------------------------------------------------------------------------------//
	if		((wParam & AJCSCT_EV_TXEMPTY	) != 0	&&	pWk->cbTxEmpty	!= NULL) {
		pWk->cbTxEmpty();
	}
	//----- チャンクデータ受信通知 -----------------------------------------------------------------------------//
	if		((wParam & AJCSCT_EV_RXCHUNK	) != 0	&&	pWk->cbRxChunkTxt != NULL) {
		if		(param == 0)  {		//	バイナリチャンク？
			pWk->cbRxChunkBin(pDat, len);
		}
		else {						// テキストチャンク（MSILの場合はワイド文字(param==2)で通知）？
			pWk->cbRxChunkTxt((C_WCP)pDat);
		}
	}
	//----- 不正チャンクテキスト受信 ---------------------------------------------------------------------------//
	if		((wParam & AJCSCT_EV_INVCHUNK	) != 0	&&	pWk->cbRxInvChunk	!= NULL) {
		pWk->cbRxInvChunk(pDat, len);
	}
	//----- 受信エラー通知 -------------------------------------------------------------------------------------//
	if		((wParam & AJCSCT_EV_RXERR		) != 0	&&	pWk->cbRecvError	!= NULL) {
		pWk->cbRecvError(param);
	}
	//----- 送信エラー通知 -------------------------------------------------------------------------------------//
	if		((wParam & AJCSCT_EV_TXERR		) != 0	&&	pWk->cbSendError	!= NULL) {
		pWk->cbSendError(param);
	}
	//----- その他のエラー通知 ---------------------------------------------------------------------------------//
	if		((wParam & AJCSCT_EV_ERR	  	) != 0	&&	pWk->cbGeneralError	!= NULL) {
		pWk->cbGeneralError(param);
	}

	AjcSctRelEventData(pWk->hSct, lParam);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(MSIL)
	AJC_WNDMAP_MSG(MSIL, WM_CREATE			)
	AJC_WNDMAP_MSG(MSIL, WM_DESTROY			)
	AJC_WNDMAP_MSG(MSIL, WM_SCT_FORMSIL		)
AJC_WNDMAP_END
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	回線接続																									//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
AJCEXPORT BOOL WINAPI AjcSctConnectForMSIL(HAJCSCT hSct, C_WCP pServ, C_WCP pPort, int AddressFamily, BOOL fOnEvent)
{
	BOOL	rc = FALSE;

	if (hSct != NULL && hSct->hWndForMsil != NULL) {
		if (fOnEvent) {
			rc = AjcSctConnectW(hSct, pServ, pPort, AddressFamily, hSct->hWndForMsil, WM_SCT_FORMSIL);
		}
		else {
			rc = AjcSctConnectW(hSct, pServ, pPort, AddressFamily, NULL				, 0			);
		}
	}
	return rc;
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	インスタンス消去																							//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
AJCEXPORT BOOL WINAPI AjcSctDeleteForMSIL(HAJCSCT hSct)
{
	BOOL	rc = FALSE;
	if (hSct != NULL && hSct->hWndForMsil != NULL) {
		DestroyWindow(hSct->hWndForMsil);
		hSct->hWndForMsil = NULL;
		rc = AjcSctDelete(hSct);
	}
	return rc;
}
