﻿#include	"AjcInternal.h"
#include	"AjcSockClientDef.h"
//**************************************************************************************************************//
//																												//
//	ソケット ( TCP/IP ) クライアント処理						グローバルサブ関数								//
//																												//
//**************************************************************************************************************//
static	VO CALLBACK cbReleaseEvtInf(VOP pVoid);

//==============================================================================================================//
//	ユーザＡＰへイベント通知																					//
//																												//
//	※	イベント通知用のリソース（EVTENF）は、プログラム終了時に残留する可能性があるため、						//
//	   AjcAllocInstance/AjcReleaseInstanceで確保／開放し、プロセス終了時にクリーンアップする。					//
//==============================================================================================================//
VO	SctNtcEvtToUser	 (HAJCSCT pW, UI EvtMask, VOP pDat, UI lDat, UI param)
{
	PSCTEVTINF	pEvtInf;

	//	通常処理中 and 通知対象イベント？
	if (!pW->fEnding && (pW->EvtMask & EvtMask)) {
		if (pEvtInf = (PSCTEVTINF)AjcAllocInstance(sizeof(SCTEVTINF), cbReleaseEvtInf)) {
			pEvtInf->Evt   = EvtMask;
			pEvtInf->pDat  = pDat;
			pEvtInf->lDat  = lDat;
			pEvtInf->param = param;
			//	ウインドメッセージによる通知？
			if (pW->hWndNtc != NULL) {
				//	通知先ウインドは有効・・・
				if (IsWindow(pW->hWndNtc)) {
					//	ウインドメッセージにより通知
					if (!PostMessage(pW->hWndNtc, pW->MsgNtc, EvtMask, (LPARAM)pEvtInf)) {
						//	失敗時は、最小時間ウェイト後、リトライ
						Sleep(1);
						if (!PostMessage(pW->hWndNtc, pW->MsgNtc, EvtMask, (LPARAM)pEvtInf)) {
							//	再度失敗時は、通知情報消去
							AjcReleaseInstance(pEvtInf);
						}
					}
				}
				//	通知先ウインドが無効ならば、通知情報消去
				else {
					AjcReleaseInstance(pEvtInf);
				}
			}
			//	イベントオブジェクトによる通知？
			else {
				//	イベントオブジェクトにより通知
				if (!AjcFMbxEnque(pW->hFMbxNtc, &pEvtInf)) {
					//	失敗時は、通知情報確消去
					AjcReleaseInstance(pEvtInf);
				}
			}
		}
		//	イベント通知情報確保，失敗？
		else {
			if (pDat != NULL) {
				free(pDat);
			}
		}
	}
	//	終了処理中 or 通知対象外イベント？
	else {
		if (pDat != NULL) {
			free(pDat);
		}
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	残留イベント通知用リソース開放（プロセス終了時に実行）														//
//--------------------------------------------------------------------------------------------------------------//
static	VO CALLBACK cbReleaseEvtInf(VOP pVoid)
{
	PSCTEVTINF	pEvtInf = (PSCTEVTINF)pVoid;

	//	通知データ解放
	if (pEvtInf->pDat != NULL) {
		free(pEvtInf->pDat);
		pEvtInf->pDat = NULL;
	}
}

