﻿#include	"AjcInternal.h"
#include	"AjcSockClientDef.h"
//**************************************************************************************************************//
//																												//
//	ソケット ( TCP/IP ) クライアント処理						接続，送受信スレッド							//
//																												//
//**************************************************************************************************************//
//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
static	UI _stdcall 	CommThread(VOP pVoid);
static	VO				CommProc  (VOP pVoid);
static	VO	ReceivedDataProc(HAJCSCT pW, UL rxbytes, LPWSABUF pWsaBuf);
static	BOOL CALLBACK	cbEvtSsep(UI evt, VOP pDat, UI lDat, UX cbp);

//==============================================================================================================//
//																												//
//	ストリーム分離インスタンス生成																				//
//																												//
//==============================================================================================================//
BOOL	SctCreSsep(HAJCSCT pW)
{
	BOOL	rc = FALSE;

	//	ストリーム分離インスタンス生成
	if ((pW->hSsep = AjcSsepCreateA(pW->EvtMask & AJCSCT_EV_SSEP, (UX)pW, cbEvtSsep)) != NULL) {
		AjcSsepEnableMultiThread(pW->hSsep, TRUE);				//	マルチスレッド許可
		AjcSsepSetPktTimeOut	(pW->hSsep, pW->PktTimeout);	//	パケット受信タイムアウト設定
		AjcSsepSetStx			(pW->hSsep, pW->stx);			//	STX設定
		AjcSsepSetEtx			(pW->hSsep, pW->etx);			//	ETX設定
		AjcSsepSetDle			(pW->hSsep, pW->dle);			//	DLE設定
		rc = TRUE;
	}

	return rc;
}
//==============================================================================================================//
//																												//
//	受信スレッド開始																							//
//																												//
//==============================================================================================================//
BOOL	SctStartThreadComm(HAJCSCT pW)
{
	BOOL	rc = FALSE;

	//----- 受信スレッド開始 -----------------------------------------------------------------------------------//
	pW->fExit = FALSE;
	if ((pW->hThread = (HANDLE)_beginthreadex(NULL,				//	セキュリティ
											  0,				//	スタックサイズ
											  CommThread,		//	スレッド関数
											  (VOP)pW,			//	スレッド引数
											  0,				//	スレッド初期フラグ
											  &pW->idThread)	//	スレッド識別子
									) != NULL) {
		rc = TRUE;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	接続，通信スレッド																							//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static	UI _stdcall CommThread(VOP pVoid)
{
	HAJCSCT		pW	   = (HAJCSCT)pVoid;
	int			nLen;
	ADDRINFOW	aiHint;
	PADDRINFOW	pAi    = NULL;
	HANDLE		hEvtCn = NULL;
	WSANETWORKEVENTS nwev;

	if (!pW->fThreadBusy) {
		pW->fThreadBusy = TRUE;

		do {
			//	アドレス情報取得
			memset(&aiHint, 0, sizeof aiHint);
			aiHint.ai_family   = pW->AddressFamily;
			aiHint.ai_socktype = SOCK_STREAM;
			aiHint.ai_flags    = AI_PASSIVE;
			if (GetAddrInfoW(pW->pServ, pW->pPort, &aiHint, &pAi) == 0 && pAi != NULL) {

				//	接続用ソケット生成
				if ((pW->hSock = socket(pAi->ai_family, pAi->ai_socktype, pAi->ai_protocol)) == INVALID_SOCKET) {
					pW->hSock = 0;
					//	接続要求待機用ソケット生成失敗エラー通知
					SctNtcEvtToUser(pW, AJCSCT_EV_ERR, NULL, 0, AJCSCT_ERR_SOCKET);
					SctNtcEvtToUser(pW, AJCSCT_EV_CNFAIL, NULL, 0, WSAGetLastError());
					break;	//	→終了
				}

				//	IPV6の設定
				if (pAi->ai_family == AF_INET6) {
					int on = 1;
					if (setsockopt(pW->hSock, IPPROTO_IPV6, IPV6_V6ONLY, (C_BCP)&on, sizeof(on)) == SOCKET_ERROR) {
						//	IPV6の設定失敗エラー通知
						SctNtcEvtToUser(pW, AJCSCT_EV_ERR, NULL, 0, AJCSCT_ERR_SOCKOPT);
						SctNtcEvtToUser(pW, AJCSCT_EV_CNFAIL, NULL, 0, WSAGetLastError());
						break;	//	→終了
					}
				}

				//	接続待ち用イベントオブジェクト生成
				if ((hEvtCn = WSACreateEvent()) == NULL) {
					SctNtcEvtToUser(pW, AJCSCT_EV_ERR   , NULL, 0, AJCSCT_ERR_CREATEEVENT);
					SctNtcEvtToUser(pW, AJCSCT_EV_CNFAIL, NULL, 0, WSAGetLastError());
					break;	//	→終了
				}

				//	ネットワークイベント設定
				if ((WSAEventSelect((SOCKET)pW->hSock, hEvtCn, FD_CONNECT)) == SOCKET_ERROR) {
					SctNtcEvtToUser(pW, AJCSCT_EV_ERR   , NULL, 0, AJCSCT_ERR_EVENTSELECT);
					SctNtcEvtToUser(pW, AJCSCT_EV_CNFAIL, NULL, 0, WSAGetLastError());
					break;	//	→終了
				}

				//	接続
				nLen = sizeof(AJCSCTSAIN);
				if (connect(pW->hSock, pAi->ai_addr, (int)pAi->ai_addrlen) == SOCKET_ERROR) {
					//	接続操作保留ならば、接続終了を待つ
					if (WSAGetLastError() == WSAEWOULDBLOCK) {
						while (!pW->fExit) {
							if (WSAEnumNetworkEvents((SOCKET)pW->hSock, hEvtCn, &nwev) != SOCKET_ERROR) {
								if (nwev.lNetworkEvents & FD_CONNECT) {
									if (nwev.iErrorCode[FD_CONNECT_BIT] == 0) {
										break;	//	→通信処理
									}
									else {
										SctNtcEvtToUser(pW, AJCSCT_EV_ERR   , NULL, 0, 0x80000000 | nwev.iErrorCode[FD_CONNECT_BIT]);
										SctNtcEvtToUser(pW, AJCSCT_EV_CNFAIL, NULL, 0, WSAGetLastError());
										goto exit_connect_block;	//	→終了
									}
								}
							}
							else {
								SctNtcEvtToUser(pW, AJCSCT_EV_ERR   , NULL, 0, AJCSCT_ERR_ENUMNETWORKEVENTS);
								SctNtcEvtToUser(pW, AJCSCT_EV_CNFAIL, NULL, 0, WSAGetLastError());
								goto exit_connect_block;	//	→終了
							}
							Sleep(1);
						}
					}
					//	接続失敗ならば、エラー通知
					else {
						int		err;
						//	CONNECT失敗エラー通知
						//	通信終了時(まだ、未接続ならば)ソケットをクローズする為、connect()は失敗する
						err = WSAGetLastError();
						if (err != WSAENOTSOCK) {	// 非ソケットでのソケット操作（=ソケットクローズによるエラー）以外？
							SctNtcEvtToUser(pW, AJCSCT_EV_CNFAIL, NULL, 0, err);
						}
						break;	//	→終了
					}
				}

				//	ネットワークイベント解除
				WSAEventSelect(pW->hSock, NULL, 0);

				//	接続通知
				SctNtcEvtToUser(pW, AJCSCT_EV_CONNECT, NULL, 0, 0);
				//	回線接続状態
				pW->State = AJCSCT_CONNECT;
				//	接続中フラグ設定
				pW->fConnected = TRUE;

				//	アドレス情報を解放
				FreeAddrInfoW(pAi);
				pAi = NULL;

				//	通信処理
				CommProc(pW);
			}
			//	アドレス情報取得失敗
			else {
				SctNtcEvtToUser(pW, AJCSCT_EV_ERR, NULL, 0, AJCSCT_ERR_ADDRINFO);
				SctNtcEvtToUser(pW, AJCSCT_EV_CNFAIL, NULL, 0, WSAGetLastError());
			}
		} while(0);

exit_connect_block:;

		//	アドレス情報を解放（エラーブレーク時の残留を解放）
		if (pAi != NULL) {
			FreeAddrInfoW(pAi);
			pAi = NULL;
		}

		//	ソケットクローズ
		if (pW->hSock != 0) {
			closesocket(pW->hSock);
			pW->hSock = 0;
		}
		//	回線切断状態
		pW->State = AJCSCT_DISCONNECT;

		//	通信終了中フラグ リセット
		pW->fEnding  = FALSE;

		//	切断通知，通信中フラグ リセット
		if (pW->fConnected) {
			SctNtcEvtToUser(pW, AJCSCT_EV_DISCONNECT, NULL, 0, 0);
			pW->fConnected = FALSE;
			pW->State      = AJCSCT_DISCONNECT;
		}
	}
	else {
		SctNtcEvtToUser(pW, AJCSCT_EV_ERR, NULL, 0, AJCSCT_ERR_THREADBUSY);
	}

	pW->fThreadBusy = FALSE;

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
//	通信処理																									//
//--------------------------------------------------------------------------------------------------------------//
static	VO		CommProc(VOP pVoid)
{
	HAJCSCT			pW = (HAJCSCT)pVoid;
	HANDLE			hEvtSel  = NULL;
	BOOL			fRxPend  = FALSE;	//	受信操作保留中フラグ
	BOOL			fTxPend  = FALSE;	//	送信操作保留中フラグ
	UL				rxflags  = 0	, txflags = 0;
	UL				rxbytes  = 0	, txbytes = 0;
	WSABUF			rxwsabuf = {0}	, txwsabuf = {0};
	WSAOVERLAPPED	rxover	 = {0}	, txover   = {0};
	UB								  txbuf[AJCSCTMAX_TXBUF];

	do {
		//	イベントセレクト用イベントオブジェクト生成
		if ((hEvtSel = WSACreateEvent()) == NULL) {
			SctNtcEvtToUser(pW, AJCSCT_EV_ERR, NULL, 0, AJCSCT_ERR_CREEVT);
			break;
		}
		//	イベントセレクト設定
		WSAEventSelect(pW->hSock, hEvtSel, FD_CLOSE);

		//	送信操作情報設定
		txwsabuf.buf  = (BCP)txbuf;
		txwsabuf.len  = sizeof txbuf;
		if ((txover.hEvent = WSACreateEvent()) == NULL) {
			SctNtcEvtToUser(pW, AJCSCT_EV_ERR, NULL, 0, AJCSCT_ERR_CREEVT);
			break;
		}
		//	受信操作情報設定
		rxwsabuf.buf  = &pW->RxBuf[pW->ixRxb];
		rxwsabuf.len  = AJCSCTMAX_RXBUF;
		//	受信重複操作要イベントオブジェクト生成
		if ((rxover.hEvent = WSACreateEvent()) == NULL) {
			SctNtcEvtToUser(pW, AJCSCT_EV_ERR, NULL, 0, AJCSCT_ERR_CREEVT);
			break;
		}
		//	データ送受信ループ
		while (!pW->fExit) {
			//	通信切断の場合、もう送信しないことを宣言する
			if (pW->fExit) {
				shutdown(pW->hSock, SD_SEND);
			}
			//	切断チェック
			if (WaitForSingleObject(hEvtSel, 0) == WAIT_OBJECT_0) {
				WSANETWORKEVENTS nwev;
				if (WSAEnumNetworkEvents(pW->hSock, hEvtSel, &nwev) != SOCKET_ERROR) {
					if (nwev.lNetworkEvents & FD_CLOSE) {
						break;
					}
				}
			}
			//--- データ受信処理 ---//
			if (!fRxPend) {		//	受信操作保留中以外
				//	受信操作実行
				rxbytes = 0;
				rxflags = 0;
				rxwsabuf.buf  = pW->RxBin;
				rxwsabuf.len  = AJCSCTMAX_RXBUF;
				if (WSARecv(pW->hSock, &rxwsabuf, 1, &rxbytes, &rxflags, &rxover, NULL) == 0) {
					//	受信データ処理
					ReceivedDataProc(pW, rxbytes, &rxwsabuf);
				}
				else {
					//	受信保留ならば、受信完了待ちへ移行
					if (WSAGetLastError() == WSA_IO_PENDING) {
						//	受信操作保留かな設定（次は、WaitoForSingleObject()実行）
						fRxPend = TRUE;
					}
					//	受信失敗ならば、エラー通知
					else {
						//	受信操作失敗エラー通知
						SctNtcEvtToUser(pW, AJCSCT_EV_RXERR, NULL, 0, FALSE);
						//	最小時間ウェイト
						Sleep(1);
					}
				}
			}
			else {				//	受信操作保留中
				if (WaitForSingleObject(rxover.hEvent, 0) == WAIT_OBJECT_0) {
					//	受信を非シグナル状態に設定
					WSAResetEvent(rxover.hEvent);
					//	データ受信完了情報取得
					if (WSAGetOverlappedResult(pW->hSock, &rxover, &rxbytes, FALSE, &rxflags)) {
						//	受信データ処理
						ReceivedDataProc(pW, rxbytes, &rxwsabuf);
					}
					else {	//	WSAGetOverlappedResult()失敗
						//	受信重複Ｉ／Ｏ失敗エラー通知
						SctNtcEvtToUser(pW, AJCSCT_EV_RXERR, NULL, 0, TRUE);
						//	最小時間ウェイト
						Sleep(1);
					}
					//	受信操作漂流中解除（次は、WSARecv()実行）
					fRxPend = FALSE;
				}
				else {	//	WaitForSingleObject()のタイムアウト（まだ、受信データは無い）
					//	回線切断の場合、相手に会話が終了したことを告げ、終了する
					if (pW->fExit) {
						shutdown(pW->hSock, SD_BOTH);
						break;
					}
				}
			}
			//--- データ送信処理 ---//
			if (!pW->fExit) {
				if (!fTxPend) {		//	送信操作保留中以外
					if ((txwsabuf.len = AjcVMbxDequeEx(pW->hVMbxTxD, txbuf, sizeof txbuf, 0)) != -1) {
						pW->fTxBusy = TRUE;
						txbytes = 0;
						txflags = 0;
						if (WSASend(pW->hSock, &txwsabuf, 1, &txbytes, txflags, &txover, NULL) != 0) {
							if (WSAGetLastError() == WSA_IO_PENDING) {
								//	送信操作保留中設定（次は、WaitForSingleObject()を実行）
								fTxPend = TRUE;
							}
							else {
								//	送信操作失敗エラー通知
								SctNtcEvtToUser(pW, AJCSCT_EV_TXERR, NULL, 0, FALSE);
								//	最小時間ウェイト
								Sleep(1);
							}
						}
					}
					else {	//	送信データなし？
						//	送信完了通知
						if (pW->fTxBusy) {
							pW->fTxBusy = FALSE;
							SctNtcEvtToUser(pW, AJCSCT_EV_TXEMPTY , NULL, 0, 0);
						}
					}
				}
				else {			//	送信操作保留中
					//	送信完了ならば、次の送信操作へ・・
					if (WaitForSingleObject(txover.hEvent, 0) == WAIT_OBJECT_0) {
						//	送信を非シグナル状態に設定
						WSAResetEvent(txover.hEvent);
						//	データ送信完了情報取得
						if (!WSAGetOverlappedResult(pW->hSock, &txover, &txbytes, FALSE, &txflags)) {
							//	送信用重複Ｉ／Ｏ失敗エラー通知
							SctNtcEvtToUser(pW, AJCSCT_EV_TXERR, NULL, 0, TRUE);
						}
						//	送信操作保留中解除（次は、WSASend()実行）
						fTxPend = FALSE;
					}
				}
			}
			//	送受信捜操作中以外ならば最小時間スリープする
			if (!fRxPend && !fTxPend) {
				Sleep(1);
			}
		} // データ送受信ループ終端
	} while(0);

	//	相手に会話が終了したことを告げる
	shutdown(pW->hSock, SD_BOTH);

	//	リソース解放
	if (hEvtSel 		!= NULL) {CloseHandle(hEvtSel		 ); hEvtSel			= NULL;}
	if (rxover.hEvent	!= NULL) {CloseHandle(rxover.hEvent  ); rxover.hEvent	= NULL;}
	if (txover.hEvent	!= NULL) {CloseHandle(txover.hEvent  ); txover.hEvent	= NULL;}
	//	ソケットクローズ
	if (pW->hSock != 0		   ) {closesocket(pW->hSock);		pW->hSock		= 0;   }
}
//--------------------------------------------------------------------------------------------------------------//
//	受信データ処理																								//
//--------------------------------------------------------------------------------------------------------------//
static	VO	ReceivedDataProc(HAJCSCT pW, UL rxbytes, LPWSABUF pWsaBuf)
{
	AJCMBCKIND		mbk;				//	受信テキストコード
	UL				lrx;

	if (rxbytes != 0) {
		//	受信バッファへ受信バイナリデータを転送
		memcpy(&pW->RxBuf[pW->ixRxb], pW->RxBin, rxbytes);
		//	文字コード判定用データ投与
		pW->RxBuf[pW->ixRxb + rxbytes] = 0;
		AjcSsepPutMbc(pW->hSsep, (C_BCP)pW->RxBuf);
		//	受信テキストコード設定
		switch (pW->RxTxtCode) {
			default:
			case AJCSCT_TXT_SJIS:	mbk = AJCMBC_SJIS;					break;	//	シフトＪＩＳ
			case AJCSCT_TXT_EUC:	mbk = AJCMBC_EUC;					break;	//	ＥＵＣ　　　
			case AJCSCT_TXT_UTF8:	mbk = AJCMBC_UTF8;					break;	//	ＵＴＦ－８　
			case AJCSCT_TXT_AUTO:	mbk = AjcSsepGetMbcKind(pW->hSsep);	break;	//	自動判別　
		}
		//	受信バイトストリーム分離
		if (rxbytes != 0 && (pW->EvtMask & AJCSCT_EV_SSEP)) {
			AjcSsepPutData(pW->hSsep, &pW->RxBuf[pW->ixRxb], rxbytes);
		}
		//	受信バッファにテキスト終端設定
		pW->RxBuf[pW->ixRxb + rxbytes] = 0;
		//	実際のデータ長設定（前部の中途マルチバイト数を加算）
		lrx = pW->ixRxb + rxbytes;
		//	チャンクデータ受信通知
		if (pW->EvtMask & AJCSCT_EV_RXCHUNK) {
			//	バイナリチャンク受信通知
			if (pW->ChunkMode & AJCSCT_CM_BIN) {
				UBP		pBin;
				if (pBin = (UBP)AJCMEM(rxbytes)) {
					memcpy(pBin, pW->RxBin, rxbytes);
					SctNtcEvtToUser(pW, AJCSCT_EV_RXCHUNK, pBin, rxbytes, 0);
				}
			}
			//	テキストチャンク受信通知
			if (pW->ChunkMode & AJCSCT_CM_TEXT) {
				UI			i;
				BOOL		fInvChunk = FALSE;
				//	途中に制御コード(0x09～0x0D, 0x1B以外)があるかチェック
				for (i = 0; i < rxbytes; i++) {
					if (MAjcIsCntrlA(pWsaBuf->buf[i]) && !MAjcIsSpaceA(pWsaBuf->buf[i]) &&
																	   pWsaBuf->buf[i] != 0x1B) {
						fInvChunk = TRUE;
						break;
					}
				}
				//	有効テキスト長チェック
				if (lrx != 0) {
					//	途中に制御コード(0x09～0x0D以外)がある場合は、不正チャンクテキストとしてバイナリのまま通知する
					if (fInvChunk) {
						UBP		pBin;
						if (pBin = (UBP)AJCMEM(lrx)) {
							memcpy(pBin, pW->RxBuf, lrx);
							SctNtcEvtToUser(pW, AJCSCT_EV_INVCHUNK, pBin, lrx, 0);
						}
						pW->ixRxb = 0;
					}
					//	正常なテキストチャンク通知
					else {
						//	文字列終端設定
						pW->RxBuf[lrx] = 0;
						//	バッファインデクス設定（前保留データと新受信データを含めたバイト数）
						pW->ixRxb = lrx;
						//	完結した文字列取得とユーザへの通知
						if (pW->fUnicode) {
							WCP		pWcs;
							if (pWcs = AjcExtractCompletedTextW((BCP)pW->RxBuf, AJCSCTMAX_RXBUF, (UIP)&lrx, mbk)) {
								pW->ixRxb = lrx;
								pW->RxBuf[lrx] = 0;
								SctNtcEvtToUser(pW, AJCSCT_EV_RXCHUNK, pWcs, (UI)wcslen(pWcs), 2);
							}
						}
						else {
							BCP		pSJis;
							if (pSJis = AjcExtractCompletedTextA((BCP)pW->RxBuf, AJCSCTMAX_RXBUF, (UIP)&lrx, mbk)) {
								pW->ixRxb = lrx;
								pW->RxBuf[lrx] = 0;
								SctNtcEvtToUser(pW, AJCSCT_EV_RXCHUNK, pSJis, (UI)strlen(pSJis), 1);
							}
						}
					}
				}
			}
		}
		//	パケット外受信テキスト通知（完結した文字列取得とユーザへの通知）
		if (pW->fUnicode) {
			WCP		pWcs;
			if (pWcs = AjcExtractCompletedTextW((BCP)pW->NpBuf, AJCSCTMAX_RXBUF, (UIP)&pW->ixNpk, mbk)) {
				pW->NpBuf[pW->ixNpk] = 0;
				SctNtcEvtToUser(pW, AJCSCT_EV_RXNOPKT, pWcs, (UI)wcslen(pWcs), 2);
			}
		}
		else {
			BCP		pSJis;
			if (pSJis = AjcExtractCompletedTextA((BCP)pW->NpBuf, AJCSCTMAX_RXBUF, (UIP)&pW->ixNpk, mbk)) {
				pW->NpBuf[pW->ixNpk] = 0;
				SctNtcEvtToUser(pW, AJCSCT_EV_RXNOPKT, pSJis, (UI)strlen(pSJis), 1);
			}
		}
	}
}

//--------------------------------------------------------------------------------------------------------------//
//	ストリーム分離通知																							//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL CALLBACK cbEvtSsep(UI evt, VOP pvData, UI lDat, UX cbp)
{
	BOOL		rc = TRUE;
	HAJCSCT		pW = (HAJCSCT)cbp;
	AJCMBCKIND	mbk;							//	受信テキストコード
	BCP			pDat =(BCP)pvData;

	switch (evt) {
		case AJCSSEP_EV_TXT:												//	●テキストデータ
			//	受信テキストコード設定
			switch (pW->RxTxtCode) {
				default:
				case AJCSCT_TXT_SJIS:	mbk = AJCMBC_SJIS;					break;	//	シフトＪＩＳ
				case AJCSCT_TXT_EUC:	mbk = AJCMBC_EUC;					break;	//	ＥＵＣ　　　
				case AJCSCT_TXT_UTF8:	mbk = AJCMBC_UTF8;					break;	//	ＵＴＦ－８　
				case AJCSCT_TXT_AUTO:	mbk = AjcSsepGetMbcKind(pW->hSsep);	break;	//	自動判別　
			}
			//----- UNICODE ------------------------------------------------------------------------------------//
			if (pW->fUnicode) {
				//	● S-JIS
				if (mbk == AJCMBC_SJIS) {
					WCP		pWid;
					UI		lWid;
					lWid = MultiByteToWideChar(CP_ACP, 0, pDat, -1, NULL, 0);
					if (lWid != 0 && (pWid = (WCP)AJCMEM(lWid * 2))) {
						MultiByteToWideChar(CP_ACP, 0, pDat, -1, pWid, lWid);			//	ワイド文字へ変換
						SctNtcEvtToUser(pW, evt, pWid, (UI)wcslen(pWid), 2);			//	ワイド文字通知
					}
				}
				//	● EUC
				else if (mbk == AJCMBC_EUC) {
					BCP		pSJis;
					WCP		pWid;
					UI		lSJis, lWid;
					lSJis = AjcEucToSJis(pDat, NULL, 0);
					if (pSJis = (BCP)AJCMEM(lSJis)) {
						AjcEucToSJis(pDat, pSJis, lSJis);
						lWid = MultiByteToWideChar(CP_ACP, 0, pSJis, -1, NULL, 0);		//	EUC->SJIS 変換
						if (lWid != 0 && (pWid = (WCP)AJCMEM(lWid * 2))) {
							MultiByteToWideChar(CP_ACP, 0, pSJis, -1, pWid, lWid);		//	ワイド文字へ変換
							SctNtcEvtToUser(pW, evt, pWid, (UI)wcslen(pWid), 2);		//	ワイド文字通知
						}
						free(pSJis);
					}
				}
				//	● UTF-8
				else if (mbk == AJCMBC_UTF8) {
					WCP		pWid;
					UI		lWid;
					lWid = MultiByteToWideChar(CP_UTF8, 0, pDat, -1, NULL, 0);
					if (lWid != 0 && (pWid = (WCP)AJCMEM(lWid * 2))) {
						MultiByteToWideChar(CP_UTF8, 0, pDat, -1, pWid, lWid);
						SctNtcEvtToUser(pW, evt, pWid, (UI)wcslen(pWid), 2);			//	ワイド文字通知
					}
				}
				rc = TRUE;																//	pDatを開放する
			}
			//----- マルチバイト -------------------------------------------------------------------------------//
			else {
				BCP		pSJis = pDat;
				UI		lSJis = lDat;
				//	● S-JIS
				if (mbk == AJCMBC_SJIS) {
					SctNtcEvtToUser(pW, evt, pDat, lDat, 1);					//	Ｓ－ＪＩＳのまま通知
					rc = FALSE;													//	pDatは解放しない
				}
				//	● EUC
				else if (mbk == AJCMBC_EUC) {
					lSJis = AjcEucToSJis(pDat, NULL, 1);
					if (pSJis = (BCP)AJCMEM(lSJis)) {							//	変換可能？
						AjcEucToSJis(pDat, pSJis, lSJis);						//		Ｓ－ＪＩＳへ変換
						lSJis = (UI)strlen(pSJis);
						SctNtcEvtToUser(pW, evt, pSJis, lSJis, 1);				//		変換した文字列を通知
					}
					rc = TRUE;													//	pDatは解放する
				}
				//	● UTF-8
				else if (mbk == AJCMBC_UTF8) {
					lSJis = AjcUtf8ToMbc(pDat, NULL, 1);						//
					if (pSJis = (BCP)AJCMEM(lSJis)) {							//	変換可能？
						AjcUtf8ToMbc(pDat, pSJis, lSJis);						//		Ｓ－ＪＩＳへ変換
						lSJis = (UI)strlen(pSJis);
						SctNtcEvtToUser(pW, evt, pSJis, lSJis, 1);				//		変換した文字列を通知
					}
					rc = TRUE;													//	pDatは解放する
				}
			}
			break;

		case AJCSSEP_EV_ESC:													//	●ＥＳＣコードデータ
		case AJCSSEP_EV_CTRL:													//	●制御コード
			if (pW->fUnicode) {													//		ワイド文字？
				WCP		pWid;
				UI		lWid;
				lWid = MultiByteToWideChar(CP_ACP, 0, pDat, -1, NULL, 0);
				if (lWid != 0 && (pWid = (WCP)AJCMEM(lWid * 2))) {
					MultiByteToWideChar(CP_ACP, 0, pDat, -1, pWid, lWid);		//			ワイド文字へ変換
					SctNtcEvtToUser(pW, evt, pWid, (UI)wcslen(pWid), 2);		//			ワイド文字通知
				}
				rc = TRUE;														//			pDatを開放する
			}
			else {																//		バイト文字？
				SctNtcEvtToUser(pW, evt, pDat, lDat, 1);						//			通知データのまま通知
				rc = FALSE;														//			pDatは解放しない
			}
			break;

		case AJCSSEP_EV_PKT:													//	●パケットデータ
			SctNtcEvtToUser(pW, evt, pDat, lDat, 0);							//		パケットデータ通知
			rc = FALSE;															//		pDatは解放しない
			break;

		case AJCSSEP_EV_NOPKT:													//	●パケット外バイトデータ
			if (pW->ixNpk < AJCSCTMAX_RXBUF) {									//		パケット外データバッファにデータ格納
				pW->NpBuf[pW->ixNpk++] = *pDat;
				pW->NpBuf[pW->ixNpk  ] = 0;
			}
			rc = TRUE;															//		pDatは解放する
			break;
	}
	return rc;
}
