﻿#include	"AjcInternal.h"
#include	"AjcSockServerDef.h"
//**************************************************************************************************************//
//																												//
//	ソケット ( TCP/IP ) サーバ							ＡＰＩ													//
//																												//
//**************************************************************************************************************//
//--------------------------------------------------------------------------------------------------------------//
//	グローバルワーク																							//
//--------------------------------------------------------------------------------------------------------------//
ATOM	SsvClassForMSIL	= 0;

//==============================================================================================================//
//	起動時初期設定																								//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - エラー																					//
//==============================================================================================================//
BOOL	AjcCtrlSockServerInit(VO)
{
	BOOL		rc = FALSE;
	WNDCLASS	wndclass;

	do {
		//----- ＭＳＩＬコードサポート用 ---------------------//
		wndclass.style			= 0;
		wndclass.lpfnWndProc	= SsvWndProcMSIL();
		wndclass.cbClsExtra		= 0;
		wndclass.cbWndExtra		= sizeof(VOP);
		wndclass.hInstance		= hDllInst;
		wndclass.hIcon			= NULL;
		wndclass.hCursor		= LoadCursor(NULL, IDC_ARROW);
		wndclass.hbrBackground	= (HBRUSH)GetStockObject(WHITE_BRUSH);
		wndclass.lpszMenuName	= NULL;
		wndclass.lpszClassName	= L"AjcSsvForMSIL";
		if ((SsvClassForMSIL = RegisterClass(&wndclass)) == 0) break;

		rc = TRUE;
	} while(0);

	if (rc == FALSE) {
		AjcCtrlSockServerEnd();
	}

	return rc;
}
//==============================================================================================================//
//	終了時後処理																								//
//																												//
//	引　数	：	なし																							//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
VO		AjcCtrlSockServerEnd (VO)
{
	if (SsvClassForMSIL != 0 ) {UnregisterClass((WCP)SsvClassForMSIL, hDllInst); SsvClassForMSIL = 0;}
}
//==============================================================================================================//
//	インスタンス生成																							//
//																												//
//	引　数	：	pPort			- TCP/IPポート番号／サービス名文字列											//
//				AddressFamily	- アドレスファミリ(AF_INET or AF_INET6)											//
//				MaxClients		- 最大クライアント数															//
//																												//
//	戻り値	：	インスタンスハンドル																			//
//==============================================================================================================//
AJCEXPORT HAJCSSV	 WINAPI AjcSsvCreate(VO)
{
	HAJCSSV		pW		 = NULL;
	BOOL		success	 = FALSE;

	do {
		//	インスタンスワーク確保
		if ((pW = AJCMEM(sizeof(AJCSSV))) == NULL) {
			break;
		}
		memset(pW, 0, sizeof(AJCSSV));
		pW->InstID = SSV_INST_ID;

		//	デフォルトイベントマスク設定
		pW->EvtMask = AJCSSV_EV_ALL;

		//	バイナリチャンクモードを仮定
		pW->ChunkMode		= AJCSSV_CM_BIN;

		//	送受信データ＝SJISを仮定
		pW->RxTxtCode		= AJCSSV_TXT_SJIS;
		pW->TxTxtCode		= AJCSSV_TXT_SJIS;

		//	パケット受信タイムアウト[ms]
		pW->PktTimeout = 3000;

		//	パケットを認識するための制御コード
		pW->stx = 0x02;
		pW->etx = 0x03;
		pW->dle = 0x10;	

		//	ユーザＡＰへのイベント通知用メールボックスハンドル生成
		if ((pW->hFMbxNtc = AjcFMbxCreate(sizeof(PSSVEVTINF), 0, NULL)) == NULL) {
			//	イベント通知用メールボックス生成失敗エラー通知（インスタンス生成失敗の為、通知不可）
		//	SsvNtcEvtToUser(pW, AJCSSV_EV_ERR, NULL, 0, AJCSSV_ERR_CREMBXNTC, NULL);
			break;
		}

		//	クライアントインスタンス登録用ＡＶＬ生成
		if ((pW->hAvlCli = AjcAvlCreate(0, NULL, NULL)) == NULL) {
			//	クライアントインスタンス登録用ＡＶＬ生成失敗エラー通知（インスタンス生成失敗の為、通知不可）
		//	SsvNtcEvtToUser(pW, AJCSSV_EV_ERR, NULL, 0, AJCSSV_ERR_CREAVLCLI, NULL);
			break;
		}
		//	ＡＶＬのマルチスレッドアクセス許可
		AjcAvlEnableMultiThread(pW->hAvlCli, TRUE);

		//	成功の旨設定
		success = TRUE;

	} while(0);

	//	失敗ならば、リソース解放
	if (!success) {
		if (pW != NULL) {
			if (pW->hFMbxNtc != NULL) {AjcFMbxDelete(pW->hFMbxNtc); pW->hFMbxNtc = NULL;}
			if (pW->hAvlCli  != NULL) {AjcAvlDelete (pW->hAvlCli ); pW->hAvlCli  = NULL;}
			AJCFREE(pW);
			pW = NULL;
		}
	}
	return pW;
}
//==============================================================================================================//
//	インスタンス消去																							//
//																												//
//	引　数	：	pW				- インスタンスハンドル															//
//				msTimeout		- サーバ終了待ち時間[ms]														//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
static	BOOL CALLBACK cbAvlRelCli(UX key, VOP pNodeData, UI len, UI nest, UX cbp)
{
	HAJCSSVCLI	pC = (HAJCSSVCLI)key;

	//	クライアント・インスタンス解放
	//	※ここで SsvCbEndOfClientThread() をコールしてはならない。
	//	（SsvCbEndOfClientThread()ではAVLのノード削除を行っている為、AVLのコールバックからAVLノード削除で、クラッシュする）
	//
	AJCFREE(pC);

	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT BOOL		 WINAPI AjcSsvDelete(HAJCSSV pW)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		//	インスタンス消去中の旨、設定
		pW->fEnding = TRUE;
		//	サーバ停止
		AjcSsvStop(pW, 10000);
		//	解放漏れのクライアントインスタンス解放(エンディング中の「AJCSSV_EV_DISCONNECT」は通知されない為ここで解放)
		AjcAvlEnumNodes(pW->hAvlCli, cbAvlRelCli, FALSE);
		//	リソース解放
		if (pW->hFMbxNtc != NULL) {AjcFMbxDelete(pW->hFMbxNtc); pW->hFMbxNtc = NULL;}
		if (pW->hAvlCli	 != NULL) {AjcAvlDelete (pW->hAvlCli ); pW->hAvlCli	 = NULL;}
		if (pW->pIxMap	 != NULL) {free 		(pW->pIxMap  ); pW->pIxMap	 = NULL;}
		AJCFREE(pW);
		pW = NULL;
	}
	return rc;
}
//==============================================================================================================//
//	サーバオプション設定																						//
//																												//
//	引　数	：	pW				- インスタンスハンドル															//
//				opt				- オプション																	//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT	BOOL			WINAPI	AjcSsvSetOpt		(HAJCSSV pW, AJCSSV_SERVOPT opt)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		pW->opt = (opt & AJCSSV_SERVOPT_MASK);
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	サーバオプション取得																						//
//																												//
//	引　数	：	pW				- インスタンスハンドル															//
//				opt				- オプション																	//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT	AJCSSV_SERVOPT	WINAPI	AjcSsvGetOpt		(HAJCSSV pW)
{
	AJCSSV_SERVOPT	rc = 0;

	if (IS_MY_INST(pW)) {
		rc = pW->opt;
	}
	return rc;
}
//==============================================================================================================//
//	サーバ開始																									//
//																												//
//	引　数	：	pW				- インスタンスハンドル															//
//				pPort			- TCP/IPポート番号／サービス名文字列											//
//				AddressFamily	- アドレスファミリ(AF_INET or AF_INET6)											//
//				MaxClients		- 最大クライアント数															//
//				hWndNtc			- ユーザＡＰへのイベント通知用ウインドハンドル									//
//				WndMsgNtc		- ユーザＡＰへのイベント通知用ウインドメッセージ								//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
static	 BOOL	 SubStart(HAJCSSV pW, C_WCP pPort, int AddressFamily, UI MaxClients, HWND hWndNtc, UI WndMsgNtc, BOOL fUniCode);
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL		 WINAPI AjcSsvStartA(HAJCSSV pW, C_BCP pPort, int AddressFamily, UI MaxClients, HWND hWndNtc, UI WndMsgNtc)
{
	BOOL	rc = FALSE;
	int		len;
	WCP		pTmp = NULL;

	if (pPort != NULL) {
		len = MultiByteToWideChar(CP_ACP, 0, pPort, -1, NULL, 0);
		if (len != 0 && (pTmp = AjcTAlloc(len))) {
			MultiByteToWideChar(CP_ACP, 0, pPort, -1, pTmp, len);
			rc = SubStart(pW, pTmp, AddressFamily, MaxClients, hWndNtc, WndMsgNtc, FALSE);
			free(pTmp);
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL		 WINAPI AjcSsvStartW(HAJCSSV pW, C_WCP pPort, int AddressFamily, UI MaxClients, HWND hWndNtc, UI WndMsgNtc)
{
	BOOL	rc = FALSE;

	rc = SubStart(pW, pPort, AddressFamily, MaxClients, hWndNtc, WndMsgNtc, TRUE);

	return rc;
}
//----- 共通サブ -----------------------------------------------------------------------------------------------//
static	 BOOL	 SubStart(HAJCSSV pW, C_WCP pPort, int AddressFamily, UI MaxClients, HWND hWndNtc, UI WndMsgNtc, BOOL fUniCode)
{
	BOOL		rc = FALSE;
	ADDRINFOW	aiHint;
	PADDRINFOW	pAiServer = NULL;
	UI			len;

	if (IS_MY_INST(pW) && !pW->fStarted) {
		do {
			//	バイト文字／ワイド文字モード設定
			pW->fUnicode = fUniCode;
			//	クライアント最大接続数
			pW->MaxClients = __max(MaxClients, 1);

			//	ユーザウインドへの通知情報設定
			pW->hWndNtc = hWndNtc;
			pW->MsgNtc	= WndMsgNtc;

			//	ユーザＡＰへのイベント通知用メールボックス・リセット
			AjcFMbxPurge(pW->hFMbxNtc);
			//	クライアントインスタンス登録用ＡＶＬ・リセット
			AjcAvlDelAllNodes(pW->hAvlCli);

			//	インデクス割り当て用マップテーブル生成
			len = ((pW->MaxClients / 32) + ((pW->MaxClients % 32) != 0)) * sizeof(UI);
			if ((pW->pIxMap = (UIP)malloc(len)) == NULL) {
				SsvNtcEvtToUser(pW, AJCSSV_EV_ERR, NULL, 0, AJCSSV_ERR_CREIXMAP, NULL);
				break;
			}
			memset(pW->pIxMap, 0, len);

			//	終了通知イベントオブジェクト生成
			if ((pW->hEvtExit = CreateEvent(NULL,		//	セキュリティ
											TRUE,		//	手動リセット
											FALSE,		//	初期状態
											NULL)		//	名前
								) == NULL) {
				SsvNtcEvtToUser(pW, AJCSSV_EV_ERR, NULL, 0, AJCSSV_ERR_CREEVT, NULL);
				break;
			}

			//	アドレス情報取得
			memset(&aiHint, 0, sizeof aiHint);
			aiHint.ai_family   = AddressFamily;
			aiHint.ai_socktype = SOCK_STREAM;
			aiHint.ai_flags    = AI_PASSIVE;
			if (GetAddrInfoW(NULL, pPort, &aiHint, &pAiServer) != 0 || pAiServer == NULL) {
				SsvNtcEvtToUser(pW, AJCSSV_EV_ERR, NULL, 0, AJCSSV_ERR_ADDRINFO, NULL);
				break;
			}

			//	接続待機用ソケット生成
			if ((pW->hSockListen = socket(pAiServer->ai_family, pAiServer->ai_socktype, pAiServer->ai_protocol)) == INVALID_SOCKET) {
				pW->hSockListen = 0;
				//	接続要求待機用ソケット生成失敗エラー通知
				SsvNtcEvtToUser(pW, AJCSSV_EV_ERR, NULL, 0, AJCSSV_ERR_SOCKET, NULL);
				break;
			}

			//	IPV6の設定
			if (pAiServer->ai_family == AF_INET6) {
				int on = 1;
				if (setsockopt(pW->hSockListen, IPPROTO_IPV6, IPV6_V6ONLY, (C_BCP)&on, sizeof(on)) == SOCKET_ERROR) {
					//	IPV6の設定失敗エラー通知
					SsvNtcEvtToUser(pW, AJCSSV_EV_ERR, NULL, 0, AJCSSV_ERR_SOCKOPT, NULL);
					break;
				}
			}

			//	名前をソケットにバインド
			if ((bind(pW->hSockListen, pAiServer->ai_addr, (int)pAiServer->ai_addrlen)) == SOCKET_ERROR) {
				//	バインド失敗エラー通知
				SsvNtcEvtToUser(pW, AJCSSV_EV_ERR, NULL, 0, AJCSSV_ERR_BIND, NULL);
				break;
			}

			//	ソケットを待機状態にする
			if ((listen(pW->hSockListen, SOMAXCONN)) == SOCKET_ERROR) {
				//	LISTEN失敗エラー通知
				SsvNtcEvtToUser(pW, AJCSSV_EV_ERR, NULL, 0, AJCSSV_ERR_LISTEN, NULL);
				break;
			}

			//	電源制御スレッドを生成する
			if (!SsvStartThreadPowCtrl(pW)) {
				//	電源制御スレッド生成失敗エラー通知
				SsvNtcEvtToUser(pW, AJCSSV_EV_ERR, NULL, 0, AJCSSV_ERR_THREADPOWCTRL, NULL);
				break;
			}

			//	接続待機スレッドを生成する
			if (!SsvStartThreadListen(pW)) {
				//	接続待機スレッド生成失敗エラー通知
				SsvNtcEvtToUser(pW, AJCSSV_EV_ERR, NULL, 0, AJCSSV_ERR_THREADLISTEN, NULL);
				break;
			}
			//	サーバ開始通知
			SsvNtcEvtToUser(pW, AJCSSV_EV_START, NULL, 0, 0, NULL);
			//	成功の旨設定
			rc = TRUE;
		} while(0);

		//	アドレス情報を解放
		if (pAiServer != NULL) {
			FreeAddrInfoW(pAiServer);
			pAiServer = NULL;
		}

		//	成功ならば・・・
		if (rc) {
			pW->fStarted = TRUE;
			pW->CliSeqNo = 0;
		}
		//	失敗ならば、リソース解放
		else {
			if (pW->hEvtExit	  != NULL) {CloseHandle  (pW->hEvtExit	 ); pW->hEvtExit	= NULL;}
			if (pW->hSockListen   != 0	 ) {closesocket  (pW->hSockListen); pW->hSockListen = 0;   }
			if (pW->hThreadListen != NULL) {
				//	スレッド終了待ち（pW->hSockListenクローズにより、スレッドはaccept()失敗により終了する）
				WaitForSingleObject(pW->hThreadListen, 10000);
				//	スレッドハンドル クローズ
				CloseHandle(pW->hThreadListen);
				pW->hThreadListen = NULL;
			}
		}
	}
	return rc;
}

//==============================================================================================================//
//	サーバ停止																									//
//																												//
//	引　数	：	pW				- インスタンスハンドル															//
//				msTimeout		- サーバ終了待ち時間[ms]														//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT BOOL		 WINAPI AjcSsvStop(HAJCSSV pW, UI msTimeout)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW) && pW->fStarted) {
		//	開始済フラグリセット
		pW->fStarted = FALSE;

		//	サーバ終了イベントをシグナル状態にセット
		if (pW->hEvtExit != NULL) {
			SetEvent(pW->hEvtExit);
		}
		//	待機ソケットクローズ
		if (pW->hSockListen != 0) {
			closesocket(pW->hSockListen);
			pW->hSockListen = 0;
		}
		//	待機スレッド，電源制御スレッド終了を待つ
		if (pW->hThreadPowCtrl != NULL || pW->hThreadListen != NULL) {
			DWORD	cnt 	   = 0;
			HANDLE	hThread[2] = {NULL};
			if (pW->hThreadPowCtrl != NULL) hThread[cnt++] = pW->hThreadPowCtrl;
			if (pW->hThreadListen  != NULL) hThread[cnt++] = pW->hThreadListen;
			if (WaitForMultipleObjects(cnt, (HANDLE)hThread, TRUE, msTimeout) == WAIT_TIMEOUT) {
				SsvNtcEvtToUser(pW, AJCSSV_EV_ERR, NULL, 0, AJCSSV_ERR_TIMEOUT, NULL);
			}
			if (pW->hThreadPowCtrl != NULL) {CloseHandle(pW->hThreadPowCtrl);  pW->hThreadPowCtrl = NULL;}
			if (pW->hThreadListen  != NULL) {CloseHandle(pW->hThreadListen );  pW->hThreadListen  = NULL;}
		}
		//	サーバ終了イベントオブジェクト解放
		if (pW->hEvtExit != NULL) {
			CloseHandle(pW->hEvtExit);
			pW->hEvtExit = NULL;
		}
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	チャンクデータの受信モード（テキスト／バイナリ）設定														//
//																												//
//	引　数	：	pW				- インスタンスハンドル															//
//				ChunkMode		- チャンクデータ通知モード														//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcSsvSetChunkMode		(HAJCSSV pW, AJCSSV_CHUNKMODE ChunkMode)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		pW->ChunkMode = ChunkMode;
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	チャンクデータの受信モード（テキスト／バイナリ）取得														//
//																												//
//	引　数	：	pW				- インスタンスハンドル															//
//																												//
//	戻り値	：	チャンクデータ通知モード																		//
//==============================================================================================================//
AJCEXPORT	AJCSSV_CHUNKMODE	WINAPI	AjcSsvGetChunkMode		(HAJCSSV pW)
{
	AJCSSV_CHUNKMODE	rc = 0;

	if (IS_MY_INST(pW)) {
		rc = pW->ChunkMode;
	}
	return rc;
}
//==============================================================================================================//
//	イベントマスク設定																							//
//																												//
//	引　数	：	pW				- インスタンスハンドル															//
//				EvtMsk			- イベントマスク																//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
static	BOOL CALLBACK cbAvlSetEvtMask(UX key, VOP pNodeData, UI len, UI nest, UX cbp)
{
	HAJCSSVCLI	pC = (HAJCSSVCLI)key;

	AjcSsepSetEvent(pC->hSsep, (UI)cbp);

	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT BOOL		 WINAPI AjcSsvSetEvtMask(HAJCSSV pW, UI EvtMsk)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		pW->EvtMask = EvtMsk;
		//	全クライアントのストリーム分離用イベントマスク設定
		AjcAvlEnumNodesEx(pW->hAvlCli, EvtMsk, cbAvlSetEvtMask, FALSE);
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	イベントマスク取得																							//
//																												//
//	引　数	：	pW				- インスタンスハンドル															//
//																												//
//	戻り値	：	イベントマスク																					//
//==============================================================================================================//
AJCEXPORT UI		 WINAPI AjcSsvGetEvtMask(HAJCSSV pW)
{
	UI		rc = 0;

	if (IS_MY_INST(pW)) {
		rc = pW->EvtMask;
	}
	return rc;
}
//==============================================================================================================//
//	受信テキストの文字コード設定																				//
//																												//
//	引　数		：	pW				- インスタンスハンドル														//
//					code			- 文字コード種別															//
//																												//
//	戻り値		：	TRUE  - OK																					//
//					FALSE - Error																				//
//==============================================================================================================//
//	コールバック（クライアントインスタンス通知）
static	BOOL CALLBACK cbAvlSetRxTextCode(UX key, VOP pNodeData, UI len, UI nest, UX cbp)
{
	HAJCSSVCLI	pC = (HAJCSSVCLI)key;

	AjcSsepMbcReset(pC->hSsep);

	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcSsvSetRxTextCode(HAJCSSV pW, AJCSSV_TEXTCODE code)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		switch (code) {
			case AJCSSV_TXT_SJIS:				//	シフトＪＩＳ
			case AJCSSV_TXT_EUC:				//	ＥＵＣ　　　
			case AJCSSV_TXT_UTF8:				//	ＵＴＦ－８　
			case AJCSSV_TXT_AUTO:				//	自動判別　　
				//	文字コード判定バッファリセット
				AjcAvlEnumNodes(pW->hAvlCli, cbAvlSetRxTextCode, FALSE);
				//	文字コード種別設定
				pW->RxTxtCode = code;
				rc = TRUE;
				break;

			default:
				rc = FALSE;
				break;
		}
	}
	return rc;
}
//==============================================================================================================//
//	受信テキストの文字コード取得																				//
//																												//
//	引　数		：	pW				- インスタンスハンドル														//
//																												//
//	戻り値		：	文字コード種別（AJCSSV_TXT_SJIS / EUC / UTF8 / AUTO）										//
//==============================================================================================================//
AJCEXPORT	AJCSSV_TEXTCODE	WINAPI	AjcSsvGetRxTextCode(HAJCSSV pW)
{
	AJCSSV_TEXTCODE	rc = (AJCSSV_TEXTCODE)0;

	if (IS_MY_INST(pW)) {
		rc = pW->RxTxtCode;
	}
	return rc;
}
//==============================================================================================================//
//	送信テキストの文字コード設定																				//
//																												//
//	引　数		：	pW				- インスタンスハンドル														//
//					code			- 文字コード種別															//
//																												//
//	戻り値		：	TRUE  - OK																					//
//					FALSE - Error																				//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcSsvSetTxTextCode(HAJCSSV pW, AJCSSV_TEXTCODE code)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		switch (code) {
			case AJCSSV_TXT_SJIS:				//	シフトＪＩＳ
			case AJCSSV_TXT_EUC:				//	ＥＵＣ　　　
			case AJCSSV_TXT_UTF8:				//	ＵＴＦ－８　
			case AJCSSV_TXT_AUTO:				//	自動判別
				//	文字コード種別設定
				pW->TxTxtCode = code;
				rc = TRUE;
				break;

			default:
				rc = FALSE;
				break;
		}
	}
	return rc;
}
//==============================================================================================================//
//	送信テキストの文字コード取得																				//
//																												//
//	引　数		：	pW				- インスタンスハンドル														//
//																												//
//	戻り値		：	文字コード種別（AJCSSV_TXT_SJIS / EUC / UTF8 / AUTO）										//
//==============================================================================================================//
AJCEXPORT	AJCSSV_TEXTCODE	WINAPI	AjcSsvGetTxTextCode(HAJCSSV pW)
{
	AJCSSV_TEXTCODE	rc = (AJCSSV_TEXTCODE)0;

	if (IS_MY_INST(pW)) {
		rc = pW->TxTxtCode;
	}
	return rc;
}
//==============================================================================================================//
//	イベント発生待ち																							//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pwParam		- イベントコードを格納するバッファのアドレス										//
//				plParam		- イベントデータ情報を格納するバッファのアドレス									//
//				msTime		- イベント発生待ち時間[ms]															//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - タイムアウト																			//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcSsvWaitEvent		(HAJCSSV pW, WPARAM *pwParam, LPARAM *plParam, UI msTime)
{
	BOOL		rc = FALSE;
	PSSVEVTINF	pEvtInf;

	if (IS_MY_INST(pW) && pwParam != NULL && plParam != NULL) {
		if (AjcFMbxDeque(pW->hFMbxNtc, &pEvtInf, msTime)) {
			if (pEvtInf != NULL) {
				*pwParam = pEvtInf->Evt;
				*plParam = (LPARAM)pEvtInf;
				rc = TRUE;
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	イベントデータ取得																							//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				lParam		- イベントデータ情報																//
//				ppDat		- 受信データのアドレスを格納するバッファのアドレス									//
//				plDat		- 受信データのバイト数を格納するバッファのアドレス									//
//				pParam		- パラメタ情報を格納するバッファのアドレス											//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - イベントデータなし																		//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcSsvGetEventData	(HAJCSSV pW, LPARAM lParam, VOP *ppDat, UIP plDat, UIP pParam)
{
	BOOL		rc = FALSE;
	PSSVEVTINF		pEvtInf;

	if (IS_MY_INST(pW) && lParam != 0) {
		pEvtInf = (PSSVEVTINF)lParam;
		if (ppDat  != NULL) *ppDat	= pEvtInf->pDat;
		if (plDat  != NULL) *plDat	= pEvtInf->lDat;
		if (pParam != NULL) *pParam = pEvtInf->param;
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	クライアントハンドル取得																					//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				lParam		- イベントデータ情報																//
//				pC			- クライアントハンドルを格納するバッファのアドレス	（不要時はNULL)					//
//																												//
//	戻り値	：	１～  - クライアント接続順序番号																//
//				０	  - クライアントハンドル無し／エラー														//
//==============================================================================================================//
AJCEXPORT	UI		WINAPI	AjcSsvGetClient(HAJCSSV pW, LPARAM lParam, HAJCSSVCLI *pC)
{
	UI			rc = 0;
	PSSVEVTINF	pEvtInf;

	if (IS_MY_INST(pW) && lParam != 0) {
		pEvtInf = (PSSVEVTINF)lParam;
		if (pEvtInf->pC != NULL) {
			if (AjcAvlGetNodePtr(pW->hAvlCli, (UX)pEvtInf->pC, NULL) != NULL) {
				if (pC != NULL) {
					*pC = pEvtInf->pC;
				}
				rc = pEvtInf->pC->SeqNo;
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	クライアントハンドルの有効性チェック																		//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pC			- クライアントハンドル																//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - 無効なクライアントハンドル																//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcSsvIsClientValid(HAJCSSV pW, HAJCSSVCLI pC)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW) && pC != NULL) {
		rc = (AjcAvlGetNodePtr(pW->hAvlCli, (UX)pC, NULL) != NULL);
	}
	return rc;
}
//==============================================================================================================//
//	イベントデータ開放																							//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				lParam		- イベントデータ情報																//
//																												//
//	戻り値	：	なし																							//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcSsvRelEventData	(HAJCSSV pW, LPARAM lParam)
{
	BOOL		rc = FALSE;
	PSSVEVTINF		pEvtInf;

	if (IS_MY_INST(pW) && lParam != 0) {
		pEvtInf = (PSSVEVTINF)lParam;
		//	最終的なクライアントスレッドのリソース解放
		if (pEvtInf->Evt & AJCSSV_EV_DISCONNECT) {
			SsvCbEndOfClientThread(pEvtInf->pC);
		}
		//	イベント情報解放（イベントデータ(pDat)は AjcMain::AjcReleaseInstance() -> AjcSockServerSubFunc::cbReleaseEvtInf()経由で解放）
		AjcReleaseInstance(pEvtInf);
		rc = TRUE;
	}
	return rc;
}

//==============================================================================================================//
//	パケットフレームを認識する為の制御コード設定																//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				stx			- ＳＴＸコード値																	//
//				etx			- ＥＴＸコード値																	//
//				dle			- ＤＬＥコード値																	//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcSsvSetPktCtrlCode(HAJCSSV pW, UI stx, UI etx, UI dle)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		if (stx != 0) pW->stx = stx;
		if (etx != 0) pW->etx = etx;
		if (dle != 0) pW->dle = dle;
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	パケットフレームを認識する為の制御コード取得																//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pStx		- ＳＴＸコード値を格納するバッファのアドレス（不要時はＮＵＬＬ）					//
//				pEtx		- ＥＴＸコード値を格納するバッファのアドレス（不要時はＮＵＬＬ）					//
//				pDle		- ＤＬＥコード値を格納するバッファのアドレス（不要時はＮＵＬＬ）					//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcSsvGetPktCtrlCode(HAJCSSV pW, UIP pStx, UIP pEtx, UIP pDle)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		if (pStx != NULL) *pStx= pW->stx;
		if (pEtx != NULL) *pEtx= pW->etx;
		if (pDle != NULL) *pDle= pW->dle;
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	パケットフレーム受信タイムアウト値設定																		//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				msTime		- タイムアウト時間[ms]																//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcSsvSetPktTimeout (HAJCSSV pW, UI msTime)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		pW->PktTimeout;
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	パケットフレーム受信タイムアウト値取得																		//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pMsTime		- タイムアウト時間[ms]を格納するバッファのアドレス（不要時はＮＵＬＬ）				//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcSsvGetPktTimeout (HAJCSSV pW, UIP pMsTime)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		if (pMsTime != NULL) {
			*pMsTime = pW->PktTimeout;
		}
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	サーバ起動状態取得																							//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//																												//
//	戻り値	：	TRUE  - 起動中																					//
//				FALSE - 停止中／エラー																			//
//==============================================================================================================//
AJCEXPORT BOOL WINAPI AjcSsvIsStarted(HAJCSSV pW)
{
	BOOL	rc = FALSE;

	if (IS_MY_INST(pW)) {
		rc = pW->fStarted;
	}
	return rc;
}
//==============================================================================================================//
//	接続済の全クライアント数取得																				//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//																												//
//	戻り値	：	接続済のクライアント数（エラー時は0を返す）														//
//==============================================================================================================//
AJCEXPORT UI WINAPI AjcSsvGetClientCount(HAJCSSV pW)
{
	UI		rc = 0;

	if (IS_MY_INST(pW)) {
		rc = AjcAvlGetCount(pW->hAvlCli);
	}
	return rc;
}
//==============================================================================================================//
//	通算接続回数取得																							//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//																												//
//	戻り値	：	通算接続回数（エラー時は0を返す）																//
//==============================================================================================================//
AJCEXPORT UI WINAPI AjcSsvGetConnectCount(HAJCSSV pW)
{
	UI		rc = 0;

	if (IS_MY_INST(pW)) {
		rc = pW->CliSeqNo;
	}
	return rc;
}
//==============================================================================================================//
//	接続済の全クライアント情報取得																				//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				cbNtcClient	- クライアント情報を通知するコールバック関数	（不要時はNULL)						//
//																												//
//	戻り値	：	接続済のクライアント数（エラー時は0を返す）														//
//==============================================================================================================//
typedef struct {
	UX		cbp;
	BOOL (CALLBACK *cb)(HAJCSSVCLI pC, UX cbp);
} AVLNTCCLI, *PAVLNTCCLI;
typedef const AVLNTCCLI *PCAVLNTCCLI;
//--------------------------------------------------------------------------------------------------------------//
static	BOOL CALLBACK cbAvlNtcClients(UX key, VOP pNode, UI len, UI nest, UX cbp)
{
	BOOL		rc	 = FALSE;
	PAVLNTCCLI	pPrm = (PAVLNTCCLI)cbp;

	if (pPrm->cb != NULL) {
		rc = pPrm->cb((HAJCSSVCLI)key, pPrm->cbp);
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT UI WINAPI AjcSsvEnumClients(HAJCSSV pW, UX cbp, BOOL (CALLBACK *cbNtcClients)(HAJCSSVCLI pC, UX cbp))
{
	UI			rc = 0;
	AVLNTCCLI	prm;

	if (IS_MY_INST(pW)) {
		prm.cbp = cbp;
		prm.cb	= cbNtcClients;
		rc = AjcAvlEnumNodesEx(pW->hAvlCli, (UX)&prm, cbAvlNtcClients, FALSE);
	}
	return rc;
}
//==============================================================================================================//
//	クライアントを切断する																						//
//																												//
//	引　数	：	pC			- クライアントハンドル																//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - エラー																					//
//==============================================================================================================//
AJCEXPORT BOOL WINAPI AjcSsvDisconnect(HAJCSSVCLI pC)
{
	BOOL		rc = FALSE;

	if (IS_MY_CLIT(pC)) {
		pC->fExit = TRUE;
	}
	return rc;
}

//==============================================================================================================//
//	クライアントへ１文字送信																					//
//																												//
//	引　数	：	pC			- クライアントハンドル																//
//				code		- 送信する文字の文字コード															//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//																												//
//	備考	：	マルチバイト文字を送信する場合は、この関数を２度コールしてください								//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcSsvSendCharA		(HAJCSSVCLI pC, BC code)
{
	BOOL	rc = FALSE;
	BC		txt[4];

	if (IS_MY_CLIT(pC)) {
		//	全角１バイト目退避なし？
		if (pC->SvSndA == 0) {
			if (MAjcIsLeadA(code)) {
				pC->SvSndA = code;
				rc = TRUE;
			}
			else {
				txt[0] = code;
				txt[1] = 0;
				rc = AjcSsvSendTextA(pC, txt, 1);
			}
		}
		//	全角１バイト目退避あり？
		else {
			//	２バイト作成し送信
			txt[0] = pC->SvSndA;
			txt[1] = code;
			txt[2] = 0;
			rc = AjcSsvSendTextA(pC, txt, 2);
			//	全角１バイト目退避クリアー
			pC->SvSndA = 0;
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcSsvSendCharW		(HAJCSSVCLI pC, WC code)
{
	BOOL	rc = FALSE;
	WC		txt[2];

	if (IS_MY_CLIT(pC)) {
		//	サロゲート１ワード目退避なし？
		if (pC->SvSndW == 0) {
			if (MAjcIsLeadW(code)) {
				pC->SvSndW = code;
				rc = TRUE;
			}
			else {
				txt[0] = code;
				txt[1] = 0;
				rc = AjcSsvSendTextW(pC, txt, 1);
			}
		}
		//	サロゲート１ワード目退避あり？
		else {
			//	２ワード作成し送信
			txt[0] = pC->SvSndW;
			txt[1] = code;
			txt[2] = 0;
			rc = AjcSsvSendTextW(pC, txt, 2);
			//	サロゲート１ワード目退避クリアー
			pC->SvSndW = 0;
		}
	}
	return rc;
}
//==============================================================================================================//
//	クライアントへテキストデータ送信																			//
//																												//
//	引　数	：	pC			- クライアントハンドル																//
//				pTxt		- 送信するテキストデータのアドレス（シフトＪＩＳ／ＵＮＩＣＯＤＥテキスト）			//
//				lTxt		- 送信するテキストデータの文字数（－１の場合は自動算出）							//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcSsvSendTextA		(HAJCSSVCLI pC, C_BCP pTxt, UI lTxt)
{
	BOOL		rc	= FALSE;
	AJCMBCKIND	mbk = AJCMBC_SJIS;
	BCP			pAlt = NULL;

	if (IS_MY_CLIT(pC)) {
		rc = TRUE;
		do {
			//	ソーステキスト長設定
			lTxt = AjcStrAdjustLenA(pTxt, lTxt);
			if (lTxt == 0) break;
			//	前回の半端バイトとテキストを動的バッファに格納
			if (pC->SvSndA != 0) {
				if (pAlt = AjcTAllocA(1 + lTxt + 1)) {
					*pAlt = pC->SvSndA;
					strncpy(pAlt + 1, pTxt, lTxt);
					*(pAlt + (1 + lTxt)) = 0;
					//	テキストポインタ切り替え
					pTxt = pAlt;
					lTxt++;
				}
				else {
					rc = FALSE;
				}
				pC->SvSndA = 0;
			}
			if (!rc) break;
			//	テキストの末尾が全角１バイト目ならば、退避して末尾を除外
			if (mbsbtype(pTxt, lTxt - 1) == _MBC_LEAD) {
				pC->SvSndA = pTxt[lTxt - 1];
				lTxt--;
			}
			if (lTxt == 0) break;
			//	送信テキストコード設定
			switch (pC->pW->TxTxtCode) {
				default:
				case AJCSSV_TXT_SJIS:	mbk = AJCMBC_SJIS;						break;	//	シフトＪＩＳ
				case AJCSSV_TXT_EUC:	mbk = AJCMBC_EUC;						break;	//	ＥＵＣ　　　
				case AJCSSV_TXT_UTF8:	mbk = AJCMBC_UTF8;						break;	//	ＵＴＦ－８　
				case AJCSCP_TXT_AUTO:													//	自動判別
										switch (pC->pW->RxTxtCode) {
											case AJCSCP_TXT_SJIS:	mbk = AJCMBC_SJIS;						break;
											case AJCSCP_TXT_EUC:	mbk = AJCMBC_EUC;						break;
											case AJCSCP_TXT_UTF8:	mbk = AJCMBC_UTF8;						break;
											case AJCSCP_TXT_AUTO:	mbk = AjcSsepGetLastMbcKind(pC->hSsep);	break;
										}
										break;
			}
			//	送信コード＝シフトＪＩＳ
			if (mbk == AJCMBC_SJIS) {
				C_BCP	p = pTxt;
				UI		len;
				//	送信テキストエンキュー
				while (lTxt > 0) {
					len = __min(lTxt, AJCSSVMAX_TXBUF);
					if (!(rc = AjcVMbxEnque(pC->hVMbxTxD, p, len))) break;
					p	 += len;
					lTxt -= len;
				}
			}
			//	送信コード＝ＥＵＣ／ＵＴＦ８
			else {
				BCP			pTop = NULL;
				BCP			pTmp = NULL;
				UI			lTmp = 0;
				UI			len;
				do {
					//	文字コード変換
					if (mbk == AJCMBC_EUC) {
						lTmp = AjcSJisToEucEx(pTxt, lTxt, NULL, 0);
						if ((pTop = AJCMEM(lTmp)) == NULL) break;
						AjcSJisToEucEx(pTxt, lTxt, pTop, lTmp);
					}
					else {
						lTmp = AjcMbcToUtf8Ex(pTxt, lTxt, NULL, 0);
						if ((pTop = AJCMEM(lTmp)) == NULL) break;
						AjcMbcToUtf8Ex(pTxt, lTxt, pTop, lTmp);
					}
					//	送信テキストエンキュー
					pTmp = pTop;
					while (lTmp > 0) {
						len = __min(lTmp, AJCSSVMAX_TXBUF);
						if (!(rc = AjcVMbxEnque(pC->hVMbxTxD, pTmp, len))) break;
						pTmp += len;
						lTmp -= len;
					}
					//	変換バッファ解放
					free(pTop);
				} while (0);
			}
		} while(0);
		//	切り替えバッファ解放
		if (pAlt != NULL) free(pAlt);
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI	AjcSsvSendTextW		(HAJCSSVCLI pC, C_WCP pTxt, UI lTxt)
{
	BOOL		rc	= FALSE;
	AJCMBCKIND	mbk = AJCMBC_SJIS;
	WCP			pAlt = NULL;

	if (IS_MY_CLIT(pC)) {
		rc = TRUE;
		do {
			//	ソーステキスト長設定
			lTxt = AjcStrAdjustLenW(pTxt, lTxt);
			if (lTxt == 0) break;
			//	前回の半端ワードとテキストを動的バッファに格納
			if (pC->SvSndW != 0) {
				if (pAlt = AjcTAllocW(1 + lTxt + 1)) {
					*pAlt = pC->SvSndW;
					wcsncpy(pAlt + 1, pTxt, lTxt);
					*(pAlt + (1 + lTxt)) = 0;
					//	テキストポインタ切り替え
					pTxt = pAlt;
					lTxt++;
				}
				else {
					rc = FALSE;
				}
				pC->SvSndW = 0;
			}
			if (!rc) break;
			//	テキストの末尾がサロゲート１ワード目ならば、退避して末尾を除外
			if (MAjcIsLeadW(pTxt[lTxt - 1])) {
				pC->SvSndW = pTxt[lTxt - 1];
				lTxt--;
			}
			if (lTxt == 0) break;
			//	送信テキストコード設定
			switch (pC->pW->TxTxtCode) {
				default:
				case AJCSCP_TXT_SJIS:	mbk = AJCMBC_SJIS;						break;	//	シフトＪＩＳ
				case AJCSCP_TXT_EUC:	mbk = AJCMBC_EUC;						break;	//	ＥＵＣ
				case AJCSCP_TXT_UTF8:	mbk = AJCMBC_UTF8;						break;	//	ＵＴＦ－８
				case AJCSCP_TXT_AUTO:													//	自動判別
										switch (pC->pW->RxTxtCode) {
											case AJCSCP_TXT_SJIS:	mbk = AJCMBC_SJIS;						break;
											case AJCSCP_TXT_EUC:	mbk = AJCMBC_EUC;						break;
											case AJCSCP_TXT_UTF8:	mbk = AJCMBC_UTF8;						break;
											case AJCSCP_TXT_AUTO:	mbk = AjcSsepGetLastMbcKind(pC->hSsep);	break;
										}
										break;
			}
			//	送信コード＝シフトＪＩＳ
			if (mbk == AJCMBC_SJIS) {
				BCP		pTxd;
				UI		lTxd;
				C_BCP	p;
				UI		len;
				lTxd = WideCharToMultiByte(CP_ACP, 0, pTxt, lTxt, NULL, 0, NULL, NULL);
				if (pTxd = AjcTAllocA(lTxd)) {
					WideCharToMultiByte(CP_ACP, 0, pTxt, lTxt, pTxd, lTxd, NULL, NULL);
					//	送信テキストエンキュー
					p = pTxd;
					while (lTxd > 0) {
						len = __min(lTxd, AJCSSVMAX_TXBUF);
						if (!(rc = AjcVMbxEnque(pC->hVMbxTxD, p, len))) break;
						p	 += len;
						lTxd -= len;
					}
					free(pTxd);
				}
			}
			//	送信コード＝ＥＵＣ／ＵＴＦ８
			else {
				BCP			pTop = NULL;
				BCP			pTmp = NULL;
				UI			lTmp = 0;
				UI			len;
				do {
					//	文字コード変換(UNICODE -> EUC)
					if (mbk == AJCMBC_EUC) {
						BCP		pSJis;
						UI		lSJis;
						lSJis = WideCharToMultiByte(CP_ACP, 0, pTxt, lTxt, NULL, 0, NULL, NULL);
						if ((pSJis = AjcTAllocA(lSJis)) == NULL) break;
						WideCharToMultiByte(CP_ACP, 0, pTxt, lTxt, pSJis, lSJis, NULL, NULL);
						lTmp = AjcSJisToEucEx(pSJis, lSJis, NULL, 0);
						if ((pTop = AjcTAllocA(lTmp)) == NULL) {free(pSJis); break;}
						AjcSJisToEucEx(pSJis, lSJis, pTop, lTmp);
					}
					//	文字コード変換(UNICODE -> UTF-8)
					else {
						lTmp = WideCharToMultiByte(CP_UTF8, 0, pTxt, lTxt, NULL, 0, NULL, NULL);
						if ((pTop = AjcTAllocA(lTmp)) == NULL) break;
						WideCharToMultiByte(CP_UTF8, 0, pTxt, lTxt, pTop, lTmp, NULL, NULL);
					}
					//	送信テキストエンキュー
					pTmp = pTop;
					while (lTmp > 0) {
						len = __min(lTmp, AJCSSVMAX_TXBUF);
						if (!(rc = AjcVMbxEnque(pC->hVMbxTxD, pTmp, len))) break;
						pTmp += len;
						lTmp -= len;
					}
					//	変換バッファ解放
					free(pTop);
				} while (0);
			}
		} while(0);
		//	切り替えバッファ解放
		if (pAlt != NULL) free(pAlt);
	}
	return rc;
}
//==============================================================================================================//
//	書式テキストデータ送信																						//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pFmt		- 書式テキスト																		//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI		AjcSsvSendTextFA	(HAJCSSVCLI pC, C_BCP pFmt, ...)
{
	BOOL	rc = FALSE;
	va_list vls;
	BC		txt[2048];

	if (pFmt != NULL) {
		va_start(vls, pFmt);
		_vsnprintf(txt, 2048, pFmt, vls);
		txt[2047] = 0;
		va_end	(vls);
		rc = AjcSsvSendTextA(pC, txt, -1);
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL		WINAPI		AjcSsvSendTextFW	(HAJCSSVCLI pC, C_WCP pFmt, ...)
{
	BOOL	rc = FALSE;
	va_list vls;
	WC		txt[2048];

	if (pFmt != NULL) {
		va_start(vls, pFmt);
		_vsnwprintf(txt, 2048, pFmt, vls);
		txt[2047] = 0;
		va_end	(vls);
		rc = AjcSsvSendTextW(pC, txt, -1);
	}
	return rc;
}
//==============================================================================================================//
//	クライアントへバイナリデータ送信																			//
//																												//
//	引　数	：	pC			- クライアントハンドル																//
//				pDat		- 送信するバイナリデータのアドレス													//
//				lDat		- 送信するバイナリデータのバイト数													//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcSsvSendBinData	(HAJCSSVCLI pC, C_VOP pDat, UI lDat)
{
	BOOL	rc = FALSE;
	C_UBP	p = (C_UBP)pDat;
	UI		len;

	if (IS_MY_CLIT(pC)) {
		if (pDat != NULL) {
			rc = TRUE;
			while (lDat > 0) {
				len = __min(lDat, AJCSSVMAX_TXBUF);
				if (!(rc = AjcVMbxEnque(pC->hVMbxTxD, p, len))) break;
				p	 += len;
				lDat -= len;
			}
		}
		else rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	クライアントへパケットデータ送信																			//
//																												//
//	引　数	：	pC			- クライアントハンドル																//
//				pPkt		- 送信するパケットデータのアドレス（空パケット送信時はNUULでもOK)					//
//				lPkt		- 送信するパケットデータのバイト数（空パケット送信時は０)							//
//																												//
//	戻り値	：	４以上	- OK（実際の送信バイト数）																//
//				０		- Error																					//
//==============================================================================================================//
AJCEXPORT	UI		WINAPI	AjcSsvSendPacket	(HAJCSSVCLI pC, C_VOP pPkt, UI lPkt)
{
	UI			rc = 0;
	UBP			pImg;
	UI			lImg, len;
	UBP			p;

	if (IS_MY_CLIT(pC) && (pPkt != NULL || lPkt == 0)) {
		if (pImg = (UBP)AjcSsepMakePacket(pC->hSsep, pPkt, lPkt, &lImg)) {
			rc = lImg;
			p = pImg;
			while (lImg > 0) {
				len = __min(lImg, AJCSSVMAX_TXBUF);
				if (!AjcVMbxEnque(pC->hVMbxTxD, p, len)) {rc = 0; break;}
				p	 += len;
				lImg -= len;
			}
			AjcSsepRelease(pImg);
		}
	}
	return rc;
}
//==============================================================================================================//
//	全受信済データ破棄																							//
//																												//
//	引　数	：	pC			- クライアントハンドル																//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcSsvPurgeRecvData	(HAJCSSVCLI pC)
{
	BOOL	rc = TRUE;

	if (IS_MY_CLIT(pC)) {
		AjcFMbxPurge(pC->pW->hFMbxNtc);
	}
	else rc = FALSE;

	return rc;
}
//==============================================================================================================//
//	全送信待ちデータ破棄																						//
//																												//
//	引　数	：	pC			- クライアントハンドル																//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcSsvPurgeSendData	(HAJCSSVCLI pC)
{
	BOOL	rc = TRUE;

	if (IS_MY_CLIT(pC)) {
		AjcVMbxPurge(pC->hVMbxTxD);
	}
	else rc = FALSE;

	return rc;
}
//==============================================================================================================//
//	全送受信データ破棄																							//
//																												//
//	引　数	：	pC			- クライアントハンドル																//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT	BOOL		WINAPI	AjcSsvPurgeAllData	(HAJCSSVCLI pC)
{
	BOOL	rc = TRUE;

	if (IS_MY_CLIT(pC)) {
		AjcVMbxPurge(pC->hVMbxTxD);
		AjcFMbxPurge(pC->pW->hFMbxNtc);
	}
	else rc = FALSE;

	return rc;
}
//==============================================================================================================//
//	クライアントにデータを関連付ける																			//
//																												//
//	引　数	：	pC			- クライアントハンドル																//
//				data		- クライアントに関連付けるデータ													//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT	BOOL			WINAPI	AjcSsvSetClientData	(HAJCSSVCLI pC, UX	 data)
{
	BOOL	rc = TRUE;

	if (IS_MY_CLIT(pC)) {
		pC->UserData = data;
	}
	else rc = FALSE;

	return rc;
}
//==============================================================================================================//
//	クライアントに関連付けられたデータを取得する																//
//																												//
//	引　数	：	pC			- クライアントハンドル																//
//				pData		- クライアントに関連付けたデータを格納するバッファアドレス							//
//																												//
//	戻り値	：	TRUE  - OK																						//
//				FALSE - Error																					//
//==============================================================================================================//
AJCEXPORT	BOOL			WINAPI	AjcSsvGetClientData	(HAJCSSVCLI pC, UXP pData)
{
	BOOL	rc = FALSE;

	if (IS_MY_CLIT(pC)) {
		if (pData != NULL) {
			*pData = pC->UserData;
		}
		rc = TRUE;
	}
	else rc = FALSE;

	return rc;
}
//==============================================================================================================//
//	クライアントのアドレス文字列取得																			//
//																												//
//	引　数	：	pC			- クライアントハンドル																//
//				pBuft		- 変換した文字列を格納するバッファのアドレス										//
//				lBuf		- 変換した文字列を格納するバッファの文字数											//
//																												//
//	戻り値	：	≠ NULL - 変換した文字列のアドレス（= pBuf）													//
//				＝ NULL - Error																					//
//																												//
//	備　考	：	変換に失敗した場合は、バッファの先頭に０を設定します（つまり空文字列を返します）				//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	C_BCP		WINAPI	AjcSsvGetIpAddrStrA(HAJCSSVCLI pC, BCP pBuf, UI lBuf)
{
	C_BCP	rc = NULL;
	WC		buf[1024];

	if (IS_MY_CLIT(pC) && pBuf != NULL && lBuf != 0) {
		if (AjcSsvGetIpAddrStrW(pC, buf, AJCTSIZE(buf))) {
			AjcWideCharToByteChar(buf, pBuf, lBuf);
			rc = pBuf;
		}
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT	C_WCP		WINAPI	AjcSsvGetIpAddrStrW(HAJCSSVCLI pC, WCP pBuf, UI lBuf)
{
	C_WCP		rc = NULL;

	if (IS_MY_CLIT(pC) && pBuf != NULL && lBuf != 0) {
		*pBuf = 0;
		if (pC->SockAddr.sain.sin_family == AF_INET) rc = InetNtopW(AF_INET , &pC->SockAddr.sain.sin_addr  , pBuf, lBuf);
		else										 rc = InetNtopW(AF_INET6, &pC->SockAddr.sain6.sin6_addr, pBuf, lBuf);
	}
	return rc;
}
//==============================================================================================================//
//	クライアント接続順序番号取得																				//
//																												//
//	引　数	：	pC			- クライアントハンドル																//
//																												//
//	戻り値	：	≠ 0 - クライアント接続順序番号																	//
//				＝ 0 - Error																					//
//==============================================================================================================//
AJCEXPORT	UI		WINAPI	AjcSsvGetSeqNo(HAJCSSVCLI pC)
{
	UI		rc = 0;
	if (IS_MY_CLIT(pC)) {
		rc = pC->SeqNo;
	}
	return rc;
}
//==============================================================================================================//
//	クライアントに割り当てられたインデクス取得																	//
//																												//
//	引　数	：	pC			- クライアントハンドル																//
//																												//
//	戻り値	：	クライアントに割り当てられたインデクス（エラー時は-1を返す）									//
//==============================================================================================================//
AJCEXPORT	UI		WINAPI AjcSsvGetIndex(HAJCSSVCLI pC)
{
	UI		rc = -1;

	if (IS_MY_CLIT(pC)) {
		rc = pC->ix;
	}
	return rc;
}
//==============================================================================================================//
//	クライアントスレッドのスレッドＩＤ取得																		//
//																												//
//	引　数	：	pC			- クライアントハンドル																//
//																												//
//	戻り値	：	≠ 0 - クライアントスレッドのスレッドＩＤ														//
//				＝ 0 - Error																					//
//==============================================================================================================//
AJCEXPORT	UI		WINAPI	AjcSsvGetThreadId(HAJCSSVCLI pC)
{
	UI		rc = 0;
	if (IS_MY_CLIT(pC)) {
		rc = pC->idThreadClient;
	}
	return rc;
}
//==============================================================================================================//
//	クライアントのソケット記述子取得																			//
//																												//
//	引　数	：	pC			- クライアントハンドル																//
//																												//
//	戻り値	：	≠ 0 - クライアントのソケット																	//
//				＝ 0 - Error																					//
//==============================================================================================================//
AJCEXPORT	SOCKET	WINAPI	AjcSsvGetSocket(HAJCSSVCLI pC)
{
	SOCKET		rc = 0;
	if (IS_MY_CLIT(pC)) {
		rc = pC->hSockClient;
	}
	return rc;
}
//==============================================================================================================//
//	実際の受信文字エンコード種別取得																			//
//																												//
//	引　数		：	pW				- インスタンスハンドル														//
//																												//
//	戻り値		：	文字コード種別（AJCSCP_TXT_SJIS / EUC / UTF8）												//
//==============================================================================================================//
AJCEXPORT	AJCSSV_TEXTCODE	WINAPI	AjcSsvGetActualRxTextCode(HAJCSSVCLI pC)
{
	AJCSSV_TEXTCODE	rc = (AJCSSV_TEXTCODE)0;
	AJCMBCKIND		mbk;

	if (IS_MY_CLIT(pC)) {
		if ((rc = pC->pW->RxTxtCode) == AJCSSV_TXT_AUTO) {
			mbk = AjcSsepGetMbcKind(pC->hSsep);
			switch (mbk) {
				case AJCMBC_SJIS:	rc = AJCSSV_TXT_SJIS;	break;
				case AJCMBC_EUC:	rc = AJCSSV_TXT_EUC	;	break;
				case AJCMBC_UTF8:	rc = AJCSSV_TXT_UTF8;	break;
			}
		}
	}
	return rc;
}
//==============================================================================================================//
//	実際の送信文字エンコード種別取得																			//
//																												//
//	引　数		：	pW				- インスタンスハンドル														//
//																												//
//	戻り値		：	文字コード種別（AJCSSV_TXT_SJIS / EUC / UTF8）												//
//==============================================================================================================//
AJCEXPORT	AJCSSV_TEXTCODE	WINAPI	AjcSsvGetActualTxTextCode(HAJCSSVCLI pC)
{
	AJCSSV_TEXTCODE	rc = (AJCSSV_TEXTCODE)0;

	if (IS_MY_INST(pC)) {
		if ((rc = pC->pW->TxTxtCode) == AJCSSV_TXT_AUTO) {
			rc = AjcSsvGetActualRxTextCode(pC);
		}
	}
	return rc;
}
