﻿#include	"AjcInternal.h"
#include	"AjcSockServerDef.h"
//**************************************************************************************************************//
//																												//
//	ソケット ( TCP/IP ) サーバ							ＭＳＩＬ（.NET Framework）対応処理						//
//																												//
//**************************************************************************************************************//
AJC_WNDPROC_DEF(MSIL);
#define	WM_SSV_FORMSIL	(WM_APP + 101)

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	ＭＳＩＬ用サポートコード																					//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//----- ワーク形式 ---------------------------------------------------------------------------------------------//
typedef struct {
	HAJCSSV		hSsv;
	VO	 (CALLBACK *cbRxText		)(HAJCSSVCLI pC, C_WCP text);
	VO	 (CALLBACK *cbRxEsc			)(HAJCSSVCLI pC, C_WCP text);
	VO	 (CALLBACK *cbRxCtrl		)(HAJCSSVCLI pC, int	ctrl);
	VO	 (CALLBACK *cbRxPacket		)(HAJCSSVCLI pC, C_VOP pData, int lData);
	VO	 (CALLBACK *cbRxNoPkt		)(HAJCSSVCLI pC, C_WCP text);
	VO	 (CALLBACK *cbTxEmpty		)(HAJCSSVCLI pC);
	VO	 (CALLBACK *cbRxChunkTxt	)(HAJCSSVCLI pC, C_WCP text);
	VO	 (CALLBACK *cbRxChunkBin	)(HAJCSSVCLI pC, C_VOP pData, int lData);
	VO	 (CALLBACK *cbRxInvChunk	)(HAJCSSVCLI pC, C_VOP pData, int lData);
	VO	 (CALLBACK *cbConnect		)(HAJCSSVCLI pC);
	VO	 (CALLBACK *cbDisconnect	)(HAJCSSVCLI pC);
	VO	 (CALLBACK *cbRecvError		)(HAJCSSVCLI pC, BOOL fOverlapped);
	VO	 (CALLBACK *cbSendError		)(HAJCSSVCLI pC, BOOL fOverlapped);
	VO	 (CALLBACK *cbStart			)(VO);
	VO	 (CALLBACK *cbStop			)(VO);
	VO	 (CALLBACK *cbGeneralError	)(UI ErrCode);
	BOOL (CALLBACK *cbEnumClients	)(HAJCSSVCLI pC, UX cbp);
} WKMSIL, *PWKMSIL;
//==============================================================================================================//
//																												//
//	ウインドプロシージャ・エントリポイントを返す																//
//																												//
//==============================================================================================================//
WNDPROC		SsvWndProcMSIL()
{
	return AJC_WNDPROC_NAME(MSIL);
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	コントロールウインド生成																					//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
AJCEXPORT HAJCSSV WINAPI AjcSsvCreateForMSIL(	VO	 (CALLBACK *cbRxText		)(HAJCSSVCLI pC, C_WCP text),
												VO	 (CALLBACK *cbRxEsc			)(HAJCSSVCLI pC, C_WCP text),
												VO	 (CALLBACK *cbRxCtrl		)(HAJCSSVCLI pC, int	ctrl),
												VO	 (CALLBACK *cbRxPacket		)(HAJCSSVCLI pC, C_VOP pData, int lData),
												VO	 (CALLBACK *cbRxNoPkt		)(HAJCSSVCLI pC, C_WCP text),
												VO	 (CALLBACK *cbTxEmpty		)(HAJCSSVCLI pC),
												VO	 (CALLBACK *cbRxChunkTxt	)(HAJCSSVCLI pC, C_WCP text),
												VO	 (CALLBACK *cbRxChunkBin	)(HAJCSSVCLI pC, C_VOP pData, int lData),
												VO	 (CALLBACK *cbRxInvChunk	)(HAJCSSVCLI pC, C_VOP pData, int lData),
												VO	 (CALLBACK *cbConnect		)(HAJCSSVCLI pC),
												VO	 (CALLBACK *cbDisconnect	)(HAJCSSVCLI pC),
												VO	 (CALLBACK *cbRecvError		)(HAJCSSVCLI pC, BOOL fOverlapped),
												VO	 (CALLBACK *cbSendError		)(HAJCSSVCLI pC, BOOL fOverlapped),
												VO	 (CALLBACK *cbStart			)(VO),
												VO	 (CALLBACK *cbStop			)(VO),
												VO	 (CALLBACK *cbGeneralError	)(UI ErrCode),
												BOOL (CALLBACK *cbEnumClients	)(HAJCSSVCLI pC, UX cbp))
{
	HAJCSSV		hSsv   = NULL;
	HWND		hDummy = NULL;
	PWKMSIL		pWk    = NULL;

	do {
		//----- ワーク領域確保 ---------------------------------------------------------------------------------//
		if ((pWk = (PWKMSIL)AJCMEM(sizeof(WKMSIL))) == NULL) break;
		memset(pWk, 0, sizeof(WKMSIL));
		pWk->hSsv			= AjcSsvCreate();	//	ＳＳＶインスタンス生成
		if (pWk->hSsv == NULL) break;
		pWk->cbRxText		= cbRxText;
		pWk->cbRxEsc		= cbRxEsc;
		pWk->cbRxCtrl		= cbRxCtrl;
		pWk->cbRxPacket	 	= cbRxPacket;
		pWk->cbRxNoPkt		= cbRxNoPkt;
		pWk->cbTxEmpty		= cbTxEmpty;
		pWk->cbRxChunkTxt	= cbRxChunkTxt;
		pWk->cbRxChunkBin	= cbRxChunkBin;
		pWk->cbRxInvChunk	= cbRxInvChunk;
		pWk->cbConnect		= cbConnect;
		pWk->cbDisconnect	= cbDisconnect;
		pWk->cbRecvError	= cbRecvError;
		pWk->cbSendError	= cbSendError;
		pWk->cbStart		= cbStart;
		pWk->cbStop			= cbStop;
		pWk->cbGeneralError	= cbGeneralError;
		pWk->cbEnumClients	= cbEnumClients;

		//----- MSILウインド生成 -------------------------------------------------------------------------------//
		hDummy = CreateWindow((WCP)SsvClassForMSIL,			// window class name
								L"",						// window caption
								WS_OVERLAPPEDWINDOW,		// window style
								0,							// initial x position
								0,							// initial y position
								0,							// initial x size
								0,							// initial y size
								NULL,						// parent window handle
								NULL,						// window menu handle
								hDllInst,					// program instance handle
								(VOP)pWk);					// creation parameters
		if (hDummy == INVALID_HANDLE_VALUE) {hDummy = NULL; break;}
		//----- 戻り値（コントロールハンドル）設定 -------------------------------------------------------------//
		hSsv = pWk->hSsv;
		//----- ダミーウインドハンドルをＳＣＰインスタンスに退避 -----------------------------------------------//
		hSsv->hWndForMsil = hDummy;
		//----- ウインド非表示 ---------------------------------------------------------------------------------//
		ShowWindow(hDummy, SW_HIDE);
	} while(0);

	//----- エラーならばリソース解放 ---------------------------------------------------------------------------//
	if (hSsv == NULL || hDummy == NULL) {
		if (pWk != NULL) {
			if (hSsv   != NULL) AjcSsvDelete(hSsv);
			if (hDummy != NULL) DestroyWindow(hDummy);
			free(pWk);
		}
		hSsv = NULL;
	}
	return hSsv;
}

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	ウインドプロシージャ																						//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
AJC_WNDPROC(MSIL, WM_CREATE		)
{
	LRESULT		rc	  = -1;
	HWND		hCtrl = NULL;
	PWKMSIL		pWk   = (PWKMSIL)(((LPCREATESTRUCT)lParam)->lpCreateParams);

	do {
		//----- ワークポインタ退避 -----------------------------------------------------------------------------//
		MAjcSetWindowLong(hwnd, 0, (UX)pWk);
		//----- 戻り値=正常 ------------------------------------------------------------------------------------//
		rc = 0;
	} while(0);

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(MSIL, WM_DESTROY	)
{
	PWKMSIL		pWk = (PWKMSIL)MAjcGetWindowLong(hwnd, 0);

	if (pWk != NULL) {
		free(pWk);
	}
	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDPROC(MSIL, WM_SSV_FORMSIL)
{
	PWKMSIL			pWk = (PWKMSIL)MAjcGetWindowLong(hwnd, 0);
	VOP				pDat;
	UI				len, param;
	HAJCSSVCLI		pC;

	AjcSsvGetEventData(pWk->hSsv, lParam, &pDat, &len, &param);
	AjcSsvGetClient   (pWk->hSsv, lParam, &pC);

	//----- 接続通知 -------------------------------------------------------------------------------------------//
	if		((wParam & AJCSSV_EV_CONNECT	) != 0	&&	pWk->cbRxText		!= NULL) {
		pWk->cbConnect(pC);
	}
	//----- 切断通知 -------------------------------------------------------------------------------------------//
	if		((wParam & AJCSSV_EV_DISCONNECT	) != 0	&&	pWk->cbRxText		!= NULL) {
		pWk->cbDisconnect(pC);
	}
	//----- テキスト受信通知 -----------------------------------------------------------------------------------//
	if		((wParam & AJCSSV_EV_RXTEXT		) != 0	&&	pWk->cbRxText		!= NULL) {
		pWk->cbRxText(pC, pDat);
	}
	//----- ＥＳＣコード受信通知 -------------------------------------------------------------------------------//
	if		((wParam & AJCSSV_EV_RXESC		) != 0	&&	pWk->cbRxEsc		!= NULL) {
		pWk->cbRxEsc(pC, pDat);
	}
	//----- 制御コード受信通知 ---------------------------------------------------------------------------------//
	if		((wParam & AJCSSV_EV_RXCTRL		) != 0	&&	pWk->cbRxCtrl		!= NULL) {
		pWk->cbRxCtrl(pC, *((UBP)pDat));
	}
	//----- パケットデータ受信通知 -----------------------------------------------------------------------------//
	if		((wParam & AJCSSV_EV_RXPKT		) != 0	&&	pWk->cbRxPacket	!= NULL) {
		pWk->cbRxPacket(pC, pDat, len);
	}
	//----- パケット外データ受信 -------------------------------------------------------------------------------//
	if		((wParam & AJCSSV_EV_RXNOPKT	) != 0	&&	pWk->cbRxNoPkt 	!= NULL) {
		pWk->cbRxNoPkt(pC, (C_WCP)pDat);
	}
	//----- 送信完了 -------------------------------------------------------------------------------------------//
	if		((wParam & AJCSSV_EV_TXEMPTY	) != 0	&&	pWk->cbTxEmpty	!= NULL) {
		pWk->cbTxEmpty(pC);
	}
	//----- チャンクデータ受信通知（テキスト）------------------------------------------------------------------//
	if		((wParam & AJCSSV_EV_RXCHUNK	) != 0	&&	pWk->cbRxChunkTxt != NULL) {
		if		(param == 0)  {		//	バイナリチャンク？
			pWk->cbRxChunkBin(pC, pDat, len);
		}
		else {						// テキストチャンク（MSILの場合はワイド文字(param==2)で通知）？
			pWk->cbRxChunkTxt(pC, pDat);
		}
	}
	//----- 不正チャンクテキスト受信 ---------------------------------------------------------------------------//
	if		((wParam & AJCSSV_EV_INVCHUNK	) != 0	&&	pWk->cbRxInvChunk	!= NULL) {
		pWk->cbRxInvChunk(pC, pDat, len);
	}
	//----- 受信エラー通知 -------------------------------------------------------------------------------------//
	if		((wParam & AJCSSV_EV_RXERR		) != 0	&&	pWk->cbRecvError	!= NULL) {
		pWk->cbRecvError(pC, param);
	}
	//----- 送信エラー通知 -------------------------------------------------------------------------------------//
	if		((wParam & AJCSSV_EV_TXERR		) != 0	&&	pWk->cbSendError	!= NULL) {
		pWk->cbSendError(pC, param);
	}
	//----- サーバ開始通知 -------------------------------------------------------------------------------------//
	if		((wParam & AJCSSV_EV_START		) != 0	&&	pWk->cbStart		!= NULL) {
		pWk->cbStart();
	}
	//----- サーバ停止通知 -------------------------------------------------------------------------------------//
	if		((wParam & AJCSSV_EV_STOP		) != 0	&&	pWk->cbStop			!= NULL) {
		pWk->cbStop();
	}
	//----- その他のエラー通知 ---------------------------------------------------------------------------------//
	if		((wParam & AJCSSV_EV_ERR	  	) != 0	&&	pWk->cbGeneralError	!= NULL) {
		pWk->cbGeneralError(param);
	}

	AjcSsvRelEventData(pWk->hSsv, lParam);

	return 0;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_WNDMAP_DEF(MSIL)
	AJC_WNDMAP_MSG(MSIL, WM_CREATE			)
	AJC_WNDMAP_MSG(MSIL, WM_DESTROY			)
	AJC_WNDMAP_MSG(MSIL, WM_SSV_FORMSIL		)
AJC_WNDMAP_END
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	サーバ開始																									//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
AJCEXPORT BOOL WINAPI AjcSsvStartForMSIL(HAJCSSV hSsv, C_WCP pPort, int AddressFamily, UI MaxClients, BOOL fOnEvent)
{
	BOOL	rc = FALSE;

	if (hSsv != NULL && hSsv->hWndForMsil != NULL) {
		if (fOnEvent) {
			rc = AjcSsvStartW(hSsv, pPort, AddressFamily, MaxClients, hSsv->hWndForMsil, WM_SSV_FORMSIL);
		}
		else {
			rc = AjcSsvStartW(hSsv, pPort, AddressFamily, MaxClients, NULL			   , 0			);
		}
	}
	return rc;
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	クライアント列挙																							//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
typedef struct {
	PWKMSIL	pWk;
	UX		cbp;
} SENUMCLIENTS, *PSENUMCLIENTS;
//--------------------------------------------------------------------------------------------------------------//
static BOOL CALLBACK cbNtcClients(HAJCSSVCLI hCli, UX cbp)
{
	BOOL			rc	 = FALSE;
	PSENUMCLIENTS	pPrm = (PSENUMCLIENTS)cbp;

	rc = pPrm->pWk->cbEnumClients(hCli, pPrm->cbp);

	return rc; 
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT UI WINAPI AjcSsvEnumClientsForMSIL(HAJCSSV hSsv, UX cbp)
{
	UI				rc	= 0;
	SENUMCLIENTS	prm;

	if (hSsv != NULL && hSsv->hWndForMsil != NULL) {
		prm.pWk = (PWKMSIL)MAjcGetWindowLong(hSsv->hWndForMsil, 0);
		prm.cbp = cbp;
		rc = AjcSsvEnumClients(hSsv, (UX)&prm, cbNtcClients);
	}
	return rc;
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	終了処理																									//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
AJCEXPORT BOOL WINAPI AjcSsvDeleteForMSIL(HAJCSSV hSsv)
{
	BOOL	rc = FALSE;
	if (hSsv != NULL && hSsv->hWndForMsil != NULL) {
		DestroyWindow(hSsv->hWndForMsil);
		hSsv->hWndForMsil = NULL;
		rc = AjcSsvDelete(hSsv);
	}
	return rc;
}
