﻿#include	"AjcInternal.h"
#include	"AjcSockServerDef.h"
//**************************************************************************************************************//
//																												//
//	ソケット ( TCP/IP ) サーバ							グローバルサブ関数										//
//																												//
//**************************************************************************************************************//
//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
static	VO	 CALLBACK	cbReleaseEvtInf(VOP pVoid);

//==============================================================================================================//
//	クライアントカウンタ初期化																					//
//==============================================================================================================//
HANDLE	SsvInitClientCount(HAJCSSV pW)
{
	pW->ClientCount = 0;
	InitializeCriticalSection(&pW->csClients);
	if ((pW->hEvtNoClients = CreateEvent(NULL, TRUE, TRUE, NULL)) == NULL) {
		SsvNtcEvtToUser(pW, AJCSSV_EV_ERR, NULL, 0, AJCSSV_ERR_CREEVT, NULL);
	}
	return pW->hEvtNoClients;
}
//==============================================================================================================//
//	クライアントカウンタ削除																					//
//==============================================================================================================//
VO		SsvDeleteClientCount(HAJCSSV pW)
{
	DeleteCriticalSection(&pW->csClients);
	CloseHandle(pW->hEvtNoClients);
}
//==============================================================================================================//
//	クライアントカウンタ更新																					//
//==============================================================================================================//
VO		SsvIncrementClientCount(HAJCSSV pW)
{
	EnterCriticalSection(&pW->csClients);
	pW->ClientCount++;
	LeaveCriticalSection(&pW->csClients);
	ResetEvent(pW->hEvtNoClients);
}
//==============================================================================================================//
//	クライアントカウンタ減算																					//
//==============================================================================================================//
VO		SsvDecrementClientCount(HAJCSSV pW)
{
	EnterCriticalSection(&pW->csClients);
	if (pW->ClientCount > 0) pW->ClientCount--;
	LeaveCriticalSection(&pW->csClients);
	if (pW->ClientCount == 0) SetEvent(pW->hEvtNoClients);
}
//==============================================================================================================//
//	インデクス番号割り当て																						//
//==============================================================================================================//
UI		SsvAllocIx(HAJCSSV pW)
{
	UI		rc = 0;
	UI		n  = (pW->MaxClients / 32) + ((pW->MaxClients % 32) != 0);
	UI		i, j, ix, msk;

	for (i = 0; i < n; i++) {
		if (pW->pIxMap[i] != 0xFFFFFFFF) {
			for (j = 0, msk = 0x01; j < 32; j++, msk <<= 1) {
				if ((pW->pIxMap[i] & msk) == 0) {
					ix = i * 32 + j;
					if (ix < pW->MaxClients) {
						pW->pIxMap[i] |= msk;
						rc = ix;
						goto aix_exit;
					}
				}
			}
		}
	}
aix_exit:;
	return rc;
}
//==============================================================================================================//
//	インデクス番号割り当て解除																					//
//==============================================================================================================//
VO		SsvReleaseIx(HAJCSSV pW, UI ix)
{
	pW->pIxMap[ix / 32] &= ~(0x01 << (ix % 32));
}

//┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓
//┃																											┃
//┃ユーザＡＰへイベント通知																					┃
//┃																											┃
//┗━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┛

//==============================================================================================================//
//	ユーザＡＰへイベント通知																					//
//																												//
//	※	イベント通知用のリソース（EVTENF）は、プログラム終了時に残留する可能性があるため、						//
//	   AjcAllocInstance/AjcReleaseInstanceで確保／開放し、プロセス終了時にクリーンアップする。					//
//==============================================================================================================//
VO	SsvNtcEvtToUser	 (HAJCSSV pW, UI EvtMask, VOP pDat, UI lDat, UI param, HAJCSSVCLI pC)
{
	PSSVEVTINF	pEvtInf;

	//	通常処理中 and 通知対象イベント？
	if (!pW->fEnding && (pW->EvtMask & EvtMask)) {
		//	イベント通知情報確保，成功？
		if (pEvtInf = (PSSVEVTINF)AjcAllocInstance(sizeof(SSVEVTINF), cbReleaseEvtInf)) {
			pEvtInf->Evt   = EvtMask;
			pEvtInf->pDat  = pDat;
			pEvtInf->lDat  = lDat;
			pEvtInf->param = param;
			pEvtInf->pC    = pC;
			//	ウインドメッセージによる通知？
			if (pW->hWndNtc != NULL) {
				//	通知先ウインドは有効・・・
				if (IsWindow(pW->hWndNtc)) {
					//	ウインドメッセージにより通知
					if (!PostMessage(pW->hWndNtc, pW->MsgNtc, EvtMask, (LPARAM)pEvtInf)) {
						//	失敗時は、最小時間ウェイト後、リトライ
						Sleep(1);
						if (!PostMessage(pW->hWndNtc, pW->MsgNtc, EvtMask, (LPARAM)pEvtInf)) {
							//	再度失敗時は、通知情報消去
							AjcReleaseInstance(pEvtInf);
						}
					}
				}
				//	通知先ウインドが無効ならば、通知情報消去
				else {
					AjcReleaseInstance(pEvtInf);
				}
			}
			//	イベントオブジェクトによる通知？
			else {
				//	イベントオブジェクトにより通知
				if (!AjcFMbxEnque(pW->hFMbxNtc, &pEvtInf)) {
					//	失敗時は、通知情報確消去
					AjcReleaseInstance(pEvtInf);
				}
			}
		}
		//	イベント通知情報確保，失敗？
		else {
			if (pDat != NULL) {
				free(pDat);
			}
		}
	}
	//	終了処理中 or 通知対象外イベント？
	else {
		if (pDat != NULL) {
			free(pDat);
		}
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	残留イベント通知用リソース開放（プロセス終了時に実行）														//
//--------------------------------------------------------------------------------------------------------------//
static	VO CALLBACK cbReleaseEvtInf(VOP pVoid)
{
	PSSVEVTINF	pEvtInf = (PSSVEVTINF)pVoid;

	//	クライアントワーク解放
	if (pEvtInf->Evt & AJCSSV_EV_DISCONNECT) {
		if (pEvtInf->pC != NULL) {
			SsvCbEndOfClientThread(pEvtInf->pC);
			pEvtInf->pC = NULL;
		}
	}
	//	通知データ解放
	if (pEvtInf->pDat != NULL) {
		free(pEvtInf->pDat);
		pEvtInf->pDat = NULL;
	}
}
