﻿#include	"AjcInternal.h"
#include	"AjcSockServerDef.h"
//**************************************************************************************************************//
//																												//
//	ソケット ( TCP/IP ) サーバ							クライアント通信スレッド								//
//																												//
//**************************************************************************************************************//
static	UI	_stdcall	ClientThread (VOP pVoid);
static	BOOL CALLBACK	cbEvtSsep(UI evt, VOP pDat, UI lDat, UX cbp);
static	VO	ReceivedDataProc(HAJCSSVCLI pC, UL rxbytes, LPWSABUF pWsaBuf);

//==============================================================================================================//
//																												//
//	クライアント通信スレッド開始																				//
//																												//
//==============================================================================================================//
BOOL	SsvStartThreadClient(HAJCSSV pW, HAJCSSVCLI pC)
{
	BOOL	rc = FALSE;

	if ((pC->hThreadClient = (HANDLE)_beginthreadex(NULL,				//	セキュリティ
												0,						//	スタックサイズ
												ClientThread,			//	スレッド関数
												(VOP)pC,				//	スレッド関数への引数
												0,						//	スレッド関数の初期値
												&pC->idThreadClient)	//	スレッド識別子
								) != NULL) {
		//	インデクス番号割り当て
		pC->ix = SsvAllocIx(pW);
		//	スレッドハンドルは未使用の為、ここでクローズする。
		//	但し、スレッドの処理は継続します。
		CloseHandle(pC->hThreadClient);

		rc = TRUE;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	クライアントスレッド																						//
//--------------------------------------------------------------------------------------------------------------//
static	UI _stdcall ClientThread(VOP pVoid)
{
	HAJCSSVCLI		pC = (HAJCSSVCLI)pVoid;
	HANDLE			hEvtSel  = NULL;
	BOOL			fRxPend  = FALSE;	//	受信操作フラグ(TRUE:WSARecv発行要，FALSE:WaitForSingleObject実行要）
	BOOL			fTxPend  = FALSE;	//	送信操作フラグ(TRUE:WSASEnd発行要，FALSE:WaitForSingleObject実行要）
	UL				rxflags  = 0	, txflags = 0;
	UL				rxbytes  = 0	, txbytes = 0;
	WSABUF			rxwsabuf = {0}	, txwsabuf = {0};
	WSAOVERLAPPED	rxover	 = {0}	, txover   = {0};
	UB								  txbuf[AJCSSVMAX_TXBUF];

	//	クライアントカウンタ更新
	SsvIncrementClientCount(pC->pW);

	//	接続通知
	SsvNtcEvtToUser(pC->pW, AJCSSV_EV_CONNECT, NULL, 0, 0, pC);

	do {
		//	イベントセレクト用イベントオブジェクト生成
		if ((hEvtSel = WSACreateEvent()) == NULL) {
			SsvNtcEvtToUser(pC->pW, AJCSSV_EV_ERR, NULL, 0, AJCSSV_ERR_CREEVT, NULL);
			break;
		}
		//	イベントセレクト設定
		WSAEventSelect(pC->hSockClient, hEvtSel, FD_CLOSE);

		//	ストリーム分離インスタンス生成
		if ((pC->hSsep = AjcSsepCreateA(pC->pW->EvtMask & AJCSSV_EV_SSEP, (UX)pC, cbEvtSsep)) == NULL) {
			//	ストリーム分離インスタンス生成失敗エラー通知
			SsvNtcEvtToUser(pC->pW, AJCSSV_EV_ERR, NULL, 0, AJCSSV_ERR_CRESSEP, pC);
			break;
		}
		AjcSsepEnableMultiThread(pC->hSsep, TRUE);					//	マルチスレッド許可
		AjcSsepSetPktTimeOut	(pC->hSsep, pC->pW->PktTimeout);	//	パケット受信タイムアウト設定
		AjcSsepSetStx			(pC->hSsep, pC->pW->stx);			//	ＳＴＸ設定
		AjcSsepSetEtx			(pC->hSsep, pC->pW->etx);			//	ＥＴＸ設定
		AjcSsepSetDle			(pC->hSsep, pC->pW->dle);			//	ＤＬＥ設定
		//	送信データ用メールボックス生成
		if ((pC->hVMbxTxD = AjcVMbxCreate(0, NULL)) == NULL) {
			//	送信データ用メールボックス生成失敗エラー通知
			SsvNtcEvtToUser(pC->pW, AJCSSV_EV_ERR, NULL, 0, AJCSSV_ERR_CREMBXTXD, pC);
			break;
		}
		//	送信操作情報設定
		txwsabuf.buf  = (BCP)txbuf;
		txwsabuf.len  = sizeof txbuf;
		if ((txover.hEvent = WSACreateEvent()) == NULL) {
			SsvNtcEvtToUser(pC->pW, AJCSSV_EV_ERR, NULL, 0, AJCSSV_ERR_CREEVT, NULL);
			break;
		}
		//	受信操情報設定
		rxwsabuf.buf  = &pC->RxBuf[pC->ixRxb];
		rxwsabuf.len  = AJCSSVMAX_RXBUF;
		if ((rxover.hEvent = WSACreateEvent()) == NULL) {
			SsvNtcEvtToUser(pC->pW, AJCSSV_EV_ERR, NULL, 0, AJCSSV_ERR_CREEVT, NULL);
			break;
		}
		//	データ送受信ループ
		for (;;) {
			BOOL	fBusy = FALSE;	//	送受信操作（WSARecv/WSASend）中を示すフラグ（ループ毎にクリアー）
			//	クライアント切断／サーバ終了の場合、もう送信しないことを宣言する
			if (pC->fExit || WaitForSingleObject(pC->pW->hEvtExit, 0) == WAIT_OBJECT_0) {
				shutdown(pC->hSockClient, SD_SEND);
			}
			//	切断チェック
			if (WaitForSingleObject(hEvtSel, 0) == WAIT_OBJECT_0) {
				WSANETWORKEVENTS nwev;
				if (WSAEnumNetworkEvents(pC->hSockClient, hEvtSel, &nwev) != SOCKET_ERROR) {
					if (nwev.lNetworkEvents & FD_CLOSE) {
						break;
					}
				}
			}
			//--- データ受信処理 ---//
			if (!fRxPend) {		//	受信操作保留中以外
				//	受信操作実行
				rxbytes = 0;
				rxflags = 0;
				rxwsabuf.buf  = (CHAR*)pC->RxBin;
				rxwsabuf.len  = AJCSSVMAX_RXBUF;
				if (WSARecv(pC->hSockClient, &rxwsabuf, 1, &rxbytes, &rxflags, &rxover, NULL) == 0) {
					//	受信データ処理
					ReceivedDataProc(pC, rxbytes, &rxwsabuf);
				}
				else {
					//	受信保留ならば、受信完了待ちへ移行
					if (WSAGetLastError() == WSA_IO_PENDING) {
						//	次は、WaitoForSingleObject()実行
						fRxPend = TRUE;
						//	送受信捜操作(WSARecv/WSASend）有りの旨、設定
						fBusy = TRUE;
					}
					//	受信失敗ならば、エラー通知
					else {
						//	受信操作失敗エラー通知
						SsvNtcEvtToUser(pC->pW, AJCSSV_EV_RXERR, NULL, 0, FALSE, pC);
						//	最小時間ウェイト
						Sleep(1);
					}
				}
			}
			else {				//	受信操作保留中
				if (WaitForSingleObject(rxover.hEvent, 0) == WAIT_OBJECT_0) {
					//	受信を非シグナル状態に設定
					WSAResetEvent(rxover.hEvent);
					//	データ受信完了情報取得
					if (WSAGetOverlappedResult(pC->hSockClient, &rxover, &rxbytes, FALSE, &rxflags)) {
						//	受信データ処理
						ReceivedDataProc(pC, rxbytes, &rxwsabuf);
					}
					else {	//	WSAGetOverlappedResult()失敗
						//	受信重複Ｉ／Ｏ失敗エラー通知
						SsvNtcEvtToUser(pC->pW, AJCSSV_EV_RXERR, NULL, 0, TRUE, pC);
						//	最小時間ウェイト
						Sleep(1);
					}
					//	次は、WSARecv()実行
					fRxPend = FALSE;
				}
				else {	//	WaitForSingleObject()のタイムアウト（まだ、受信データは無い）
					//	クライアント切断／サーバ終了の場合、相手に会話が終了したことを告げ、終了する
					if (pC->fExit || WaitForSingleObject(pC->pW->hEvtExit, 0) == WAIT_OBJECT_0) {
						shutdown(pC->hSockClient, SD_BOTH);
						break;
					}
				}
			}
			//--- データ送信処理（クライアント継続中 ＆ サーバ継続中）---//
			if (!(pC->fExit || WaitForSingleObject(pC->pW->hEvtExit, 0) == WAIT_OBJECT_0)) {
				if (!fTxPend) {	//	送信操作
					if ((txwsabuf.len = AjcVMbxDequeEx(pC->hVMbxTxD, txbuf, sizeof txbuf, 0)) != -1) {
						pC->fTxBusy = TRUE;
						txbytes = 0;
						txflags = 0;
						if (WSASend(pC->hSockClient, &txwsabuf, 1, &txbytes, txflags, &txover, NULL) == 0 || WSAGetLastError() == WSA_IO_PENDING) {
							//	次は、WaitForSingleObject()を実行する
							fTxPend = TRUE;
							//	送受信捜操作(WSARecv/WSASend）有りの旨、設定
							fBusy	= TRUE;
						}
						else {
							//	送信操作失敗エラー通知
							SsvNtcEvtToUser(pC->pW, AJCSSV_EV_TXERR, NULL, 0, FALSE, pC);
							//	最小時間ウェイト
							Sleep(1);
						}
					}
					else {
						//	送信完了通知
						if (pC->fTxBusy) {
							pC->fTxBusy = FALSE;
							SsvNtcEvtToUser(pC->pW, AJCSSV_EV_TXEMPTY , NULL, 0, 0, pC);
						}
					}
				}
				else {			//	送信完了待ち
					//	送信完了ならば、次の送信操作へ・・
					if (WaitForSingleObject(txover.hEvent, 0) == WAIT_OBJECT_0) {
						//	送信を非シグナル状態に設定
						WSAResetEvent(txover.hEvent);
						//	データ送信完了情報取得
						if (!WSAGetOverlappedResult(pC->hSockClient, &txover, &txbytes, FALSE, &txflags)) {
							//	送信用重複Ｉ／Ｏ失敗エラー通知
							SsvNtcEvtToUser(pC->pW, AJCSSV_EV_TXERR, NULL, 0, TRUE, pC);
							//	最小時間ウェイト
							Sleep(1);
						}
						//	次は、WSASend()実行
						fTxPend = FALSE;
					}
				}
			}
			//	送受信捜操作が無ければ（WSARecv/WSASend発行直後以外(=受信完了待ち)ならば）最小時間スリープする
			if (!fBusy) {
				Sleep(1);
			}
		} // データ送受信ループ終端
	} while(0);

	//	クライアントインデクス割り当て解除
	SsvReleaseIx(pC->pW, pC->ix);

	//	リソース解放
	if (pC->hSsep		!= NULL) {AjcSsepDelete(pC->hSsep	 ); pC->hSsep		= NULL;}
	if (pC->hVMbxTxD	!= NULL) {AjcVMbxDelete(pC->hVMbxTxD ); pC->hVMbxTxD	= NULL;}
	if (hEvtSel 		!= NULL) {CloseHandle(hEvtSel		 ); hEvtSel			= NULL;}
	if (rxover.hEvent	!= NULL) {CloseHandle(rxover.hEvent  ); rxover.hEvent	= NULL;}
	if (txover.hEvent	!= NULL) {CloseHandle(txover.hEvent  ); txover.hEvent	= NULL;}
	//	クライアントソケットクローズ
	if (pC->hSockClient != 0   ) {closesocket(pC->hSockClient); pC->hSockClient = 0;   }

	//	クライアントカウンタ減算
	SsvDecrementClientCount(pC->pW);

	//	相手に会話が終了したことを告げる
	shutdown(pC->hSockClient, SD_BOTH);

	//	切断通知（このイベントを発行するとクライアントインスタンスは破棄されます）
	SsvNtcEvtToUser(pC->pW, AJCSSV_EV_DISCONNECT, NULL, 0, 0, pC);

	return 0;
}
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
//	クライアントの最終的なリソース解放は、AJCSSV_EV_DISCONNECTイベント終了時に実行します。
//	この関数は、AjcSsvRelEventData()からコールバックされます。
VO	CALLBACK SsvCbEndOfClientThread(HAJCSSVCLI pC)
{
	if (IS_MY_CLIT(pC)) {
		//	クライアントインスタンス登録解除
		AjcAvlDelNode(pC->pW->hAvlCli, (UX)pC);

		//	クライアントスレッド用ワーク解放
		AJCFREE(pC);
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	受信データ処理																								//
//--------------------------------------------------------------------------------------------------------------//
static	VO	ReceivedDataProc(HAJCSSVCLI pC, UL rxbytes, LPWSABUF pWsaBuf)
{
	AJCMBCKIND		mbk;				//	受信テキストコード
	UL				lrx;

	if (rxbytes != 0) {
		//	受信バッファへ受信バイナリデータを転送
		memcpy(&pC->RxBuf[pC->ixRxb], pC->RxBin, rxbytes);
		//	文字コード判定用データ投与
		pC->RxBuf[pC->ixRxb + rxbytes] = 0;
		AjcSsepPutMbc(pC->hSsep, (C_BCP)pC->RxBuf);
		//	受信テキストコード設定
		switch (pC->pW->RxTxtCode) {
			default:
			case AJCSSV_TXT_SJIS:	mbk = AJCMBC_SJIS;					break;	//	シフトＪＩＳ
			case AJCSSV_TXT_EUC:	mbk = AJCMBC_EUC;					break;	//	ＥＵＣ　　　
			case AJCSSV_TXT_UTF8:	mbk = AJCMBC_UTF8;					break;	//	ＵＴＦ－８　
			case AJCSSV_TXT_AUTO:	mbk = AjcSsepGetMbcKind(pC->hSsep);	break;	//	自動判別　
		}
		//	受信バイトストリーム分離
		if (rxbytes != 0 && (pC->pW->EvtMask & AJCSSV_EV_SSEP)) {
			AjcSsepPutData(pC->hSsep, &pC->RxBuf[pC->ixRxb], rxbytes);
		}
		//	受信バッファにテキスト終端設定
		pC->RxBuf[pC->ixRxb + rxbytes] = 0;
		//	実際のデータ長設定（前部の中途マルチバイト数を加算）
		lrx = pC->ixRxb + rxbytes;
		//	チャンクデータ受信通知
		if (pC->pW->EvtMask & AJCSSV_EV_RXCHUNK) {
			//	バイナリチャンク受信通知
			if (pC->pW->ChunkMode & AJCSSV_CM_BIN) {
				UBP		pBin;
				if (pBin = (UBP)AJCMEM(rxbytes)) {
					memcpy(pBin, pC->RxBin, rxbytes);
					SsvNtcEvtToUser(pC->pW, AJCSSV_EV_RXCHUNK, pBin, rxbytes, 0, pC);
				}
			}
			//	テキストチャンク受信通知
			if (pC->pW->ChunkMode & AJCSSV_CM_TEXT) {
				UI			i;
				BOOL		fInvChunk = FALSE;
				//	途中に制御コード(0x09～0x0D以外)があるかチェック
				for (i = 0; i < rxbytes; i++) {
					if (MAjcIsCntrlA(pWsaBuf->buf[i]) && !MAjcIsSpaceA(pWsaBuf->buf[i]) &&
																	   pWsaBuf->buf[i] != 0x1B) {
						fInvChunk = TRUE;
						break;
					}
				}
				//	有効テキスト長チェック
				if (lrx != 0) {
					//	途中に制御コード(0x09～0x0D以外)がある場合は、不正チャンクテキストとしてバイナリのまま通知する
					if (fInvChunk) {
						UBP		pBin;
						if (pBin = (UBP)AJCMEM(lrx)) {
							memcpy(pBin, pC->RxBuf, lrx);
							SsvNtcEvtToUser(pC->pW, AJCSSV_EV_INVCHUNK, pBin, lrx, 0, pC);
						}
						pC->ixRxb = 0;
					}
					//	正常なテキストチャンク通知
					else {
						//	文字列終端設定
						pC->RxBuf[lrx] = 0;
						//	バッファインデクス設定（前保留データと新受信データを含めたバイト数）
						pC->ixRxb = lrx;
						//	完結した文字列取得とユーザへの通知
						if (pC->pW->fUnicode) {
							WCP		pWcs;
							if (pWcs = AjcExtractCompletedTextW((BCP)pC->RxBuf, AJCSSVMAX_RXBUF, (UIP)&lrx, mbk)) {
								pC->ixRxb = lrx;
								pC->RxBuf[lrx] = 0;
								SsvNtcEvtToUser(pC->pW, AJCSSV_EV_RXCHUNK, pWcs, (UI)wcslen(pWcs), 2, pC);
							}
						}
						else {
							BCP		pSJis;
							if (pSJis = AjcExtractCompletedTextA((BCP)pC->RxBuf, AJCSSVMAX_RXBUF, (UIP)&lrx, mbk)) {
								pC->ixRxb = lrx;
								pC->RxBuf[lrx] = 0;
								SsvNtcEvtToUser(pC->pW, AJCSSV_EV_RXCHUNK, pSJis, (UI)strlen(pSJis), 1, pC);
							}
						}
					}
				}
			}
		}
		//	パケット外受信テキスト通知（完結した文字列取得とユーザへの通知）
		if (pC->pW->fUnicode) {
			WCP		pWcs;
			if (pWcs = AjcExtractCompletedTextW((BCP)pC->NpBuf, AJCSSVMAX_RXBUF, (UIP)&pC->ixNpk, mbk)) {
				pC->NpBuf[pC->ixNpk] = 0;
				SsvNtcEvtToUser(pC->pW, AJCSSV_EV_RXNOPKT, pWcs, (UI)wcslen(pWcs), 2, pC);
			}
		}
		else {
			BCP		pSJis;
			if (pSJis = AjcExtractCompletedTextA((BCP)pC->NpBuf, AJCSSVMAX_RXBUF, (UIP)&pC->ixNpk, mbk)) {
				pC->NpBuf[pC->ixNpk] = 0;
				SsvNtcEvtToUser(pC->pW, AJCSSV_EV_RXNOPKT, pSJis, (UI)strlen(pSJis), 1, pC);
			}
		}
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	ストリーム分離通知（クライアントスレッド）																	//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL CALLBACK cbEvtSsep(UI evt, VOP pvData, UI lDat, UX cbp)
{
	BOOL		rc = TRUE;
	HAJCSSVCLI	pC = (HAJCSSVCLI)cbp;
	AJCMBCKIND	mbk;							//	受信テキストコード
	BCP			pDat =(BCP)pvData;

	switch (evt) {
		case AJCSSEP_EV_TXT:												//	●テキストデータ
			//	受信テキストコード設定
			switch (pC->pW->RxTxtCode) {
				default:
				case AJCSSV_TXT_SJIS:	mbk = AJCMBC_SJIS;					break;	//	シフトＪＩＳ
				case AJCSSV_TXT_EUC:	mbk = AJCMBC_EUC;					break;	//	ＥＵＣ　　　
				case AJCSSV_TXT_UTF8:	mbk = AJCMBC_UTF8;					break;	//	ＵＴＦ－８　
				case AJCSSV_TXT_AUTO:	mbk = AjcSsepGetMbcKind(pC->hSsep);	break;	//	自動判別　
			}
			//----- UNICODE ------------------------------------------------------------------------------------//
			if (pC->pW->fUnicode) {
				//	● S-JIS
				if (mbk == AJCMBC_SJIS) {
					WCP		pWid;
					UI		lWid;
					lWid = MultiByteToWideChar(CP_ACP, 0, pDat, -1, NULL, 0);
					if (lWid != 0 && (pWid = (WCP)AJCMEM(lWid * 2))) {
						MultiByteToWideChar(CP_ACP, 0, pDat, -1, pWid, lWid);			//	ワイド文字へ変換
						SsvNtcEvtToUser(pC->pW, evt, pWid, (UI)wcslen(pWid), 2, pC);	//	ワイド文字通知
					}
				}
				//	● EUC
				else if (mbk == AJCMBC_EUC) {
					BCP		pSJis;
					WCP		pWid;
					UI		lSJis, lWid;
					lSJis = AjcEucToSJis(pDat, NULL, 0);
					if (pSJis = (BCP)AJCMEM(lSJis)) {
						AjcEucToSJis(pDat, pSJis, lSJis);
						lWid = MultiByteToWideChar(CP_ACP, 0, pSJis, -1, NULL, 0);		//	EUC->SJIS 変換
						if (lWid != 0 && (pWid = (WCP)AJCMEM(lWid * 2))) {
							MultiByteToWideChar(CP_ACP, 0, pSJis, -1, pWid, lWid);		//	ワイド文字へ変換
							SsvNtcEvtToUser(pC->pW, evt, pWid, (UI)wcslen(pWid), 2, pC);//	ワイド文字通知
						}
						free(pSJis);
					}
				}
				//	● UTF-8
				else if (mbk == AJCMBC_UTF8) {
					WCP		pWid;
					UI		lWid;
					lWid = MultiByteToWideChar(CP_UTF8, 0, pDat, -1, NULL, 0);
					if (lWid != 0 && (pWid = (WCP)AJCMEM(lWid * 2))) {
						MultiByteToWideChar(CP_UTF8, 0, pDat, -1, pWid, lWid);
						SsvNtcEvtToUser(pC->pW, evt, pWid, (UI)wcslen(pWid), 2, pC);	//	ワイド文字通知
					}
				}
				rc = TRUE;																//	pDatを開放する
			}
			//----- マルチバイト -------------------------------------------------------------------------------//
			else {
				BCP		pSJis = pDat;
				UI		lSJis = lDat;
				//	● S-JIS
				if (mbk == AJCMBC_SJIS) {
					SsvNtcEvtToUser(pC->pW, evt, pDat, lDat, 1, pC);			//	Ｓ－ＪＩＳのまま通知
					rc = FALSE;													//	pDatは解放しない
				}
				//	● EUC
				else if (mbk == AJCMBC_EUC) {
					lSJis = AjcEucToSJis(pDat, NULL, 1);
					if (pSJis = (BCP)AJCMEM(lSJis)) {							//	変換可能？
						AjcEucToSJis(pDat, pSJis, lSJis);						//		Ｓ－ＪＩＳへ変換
						lSJis = (UI)strlen(pSJis);
						SsvNtcEvtToUser(pC->pW, evt, pSJis, lSJis, 1, pC);		//		変換した文字列を通知
					}
					rc = TRUE;													//	pDatは解放する
				}
				//	● UTF-8
				else if (mbk == AJCMBC_UTF8) {
					lSJis = AjcUtf8ToMbc(pDat, NULL, 1);						//
					if (pSJis = (BCP)AJCMEM(lSJis)) {							//	変換可能？
						AjcUtf8ToMbc(pDat, pSJis, lSJis);						//		Ｓ－ＪＩＳへ変換
						lSJis = (UI)strlen(pSJis);
						SsvNtcEvtToUser(pC->pW, evt, pSJis, lSJis, 1, pC);		//		変換した文字列を通知
					}
					rc = TRUE;													//	pDatは解放する
				}
			}
			break;

		case AJCSSEP_EV_ESC:													//	●ＥＳＣコードデータ
		case AJCSSEP_EV_CTRL:													//	●制御コード
			if (pC->pW->fUnicode) {												//		ワイド文字？
				WCP		pWid;
				UI		lWid;
				lWid = MultiByteToWideChar(CP_ACP, 0, pDat, -1, NULL, 0);
				if (lWid != 0 && (pWid = (WCP)AJCMEM(lWid * 2))) {
					MultiByteToWideChar(CP_ACP, 0, pDat, -1, pWid, lWid);		//			ワイド文字へ変換
					SsvNtcEvtToUser(pC->pW, evt, pWid, (UI)wcslen(pWid), 2, pC);//			ワイド文字通知
				}
				rc = TRUE;														//			pDatを開放する
			}
			else {																//		バイト文字？
				SsvNtcEvtToUser(pC->pW, evt, pDat, lDat, 1, pC);				//			通知データのまま通知
				rc = FALSE;														//			pDatは解放しない
			}
			break;

		case AJCSSEP_EV_PKT:													//	●パケットデータ
			SsvNtcEvtToUser(pC->pW, evt, pDat, lDat, 0, pC);					//		パケットデータ通知
			rc = FALSE;															//		pDatは解放しない
			break;

		case AJCSSEP_EV_NOPKT:													//	●パケット外バイトデータ
			if (pC->ixNpk < AJCSSVMAX_RXBUF) {									//		パケット外データバッファにデータ格納
				pC->NpBuf[pC->ixNpk++] = *pDat;
				pC->NpBuf[pC->ixNpk  ] = 0;
			}
			rc = TRUE;															//		pDatは解放する
			break;
	}
	return rc;
}
