﻿#include	"AjcInternal.h"
#include	"AjcSockServerDef.h"
//**************************************************************************************************************//
//																												//
//	ソケット ( TCP/IP ) サーバ							接続待機スレッド										//
//																												//
//**************************************************************************************************************//
static	UI	_stdcall	ListenThread (VOP pVoid);

//==============================================================================================================//
//																												//
//	接続要求待機スレッド開始																				//
//																												//
//==============================================================================================================//
BOOL	SsvStartThreadListen(HAJCSSV pW)
{
	BOOL	rc = FALSE;

	if ((pW->hThreadListen = (HANDLE)_beginthreadex(NULL,					//	セキュリティ
													0,						//	スタックサイズ
													ListenThread,			//	スレッド関数
													(VOP)pW,				//	スレッド引数
													0,						//	スレッド初期フラグ
													&pW->idThreadListen)	//	スレッド識別子
									) != NULL) {
		rc = TRUE;
	}

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	接続要求待機スレッド																						//
//--------------------------------------------------------------------------------------------------------------//
//	コールバック（クライアントインスタンス通知）
static	BOOL CALLBACK cbAvlDiscSameClient(UX key, VOP pNodeData, UI len, UI nest, UX cbp)
{
	HAJCSSVCLI	pC = (HAJCSSVCLI)key;
	PAJCSSVSAIN	pSockAddr = (PAJCSSVSAIN)cbp;
	int			rsu;

	if (pSockAddr->sain.sin_family == AF_INET) {
		rsu = memcmp(&pC->SockAddr.sain.sin_addr  , &pSockAddr->sain.sin_addr  , sizeof(struct in_addr ));
	}
	else {
		rsu = memcmp(&pC->SockAddr.sain6.sin6_addr, &pSockAddr->sain6.sin6_addr, sizeof(struct in6_addr));
	}
	pC->fExit = (rsu == 0);		//	

	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
static	UI _stdcall ListenThread(VOP pVoid)
{
	HAJCSSV		pW	  = (HAJCSSV)pVoid;
	HAJCSSVCLI	pC	  = NULL;
	SOCKET		hSock = 0;

	//	クライアントカウンタ初期化
	if ((pW->hEvtNoClients = SsvInitClientCount(pW)) != NULL) {
		//	接続待ちループ
		for (;;) {
			int			nLen;
			AJCSSVSAIN	SockAddr;
			//	クライアント接続(accept()はブロックされる）
			nLen = sizeof(AJCSSVSAIN);
			if ((hSock = accept(pW->hSockListen, (LPSOCKADDR)&SockAddr, &nLen)) == INVALID_SOCKET) {
				int		err = WSAGetLastError();
				hSock = 0;
				//	ACCEPT失敗エラー通知
				//	サーバ終了時、待機ソケット（hSockListen）をクローズする為、accept()は失敗する
				if (err != WSAEINTR) {	// ブロッキング操作の中断（=ソケットクローズによるエラー）以外？
					SsvNtcEvtToUser(pW, AJCSSV_EV_ERR, NULL, 0, AJCSSV_ERR_ACCEPT, NULL);
				}
				break;
			}

			//	既に同一クライアントとの接続があれば、これを切断する
			AjcAvlEnumNodesEx(pW->hAvlCli, (UX)&SockAddr, cbAvlDiscSameClient, FALSE);
			Sleep(1);

			//	最大クライアント接続数チェック
			if (AjcSsvGetClientCount(pW) < pW->MaxClients) {
				//	クライアントスレッド用ワーク確保
				if (pC = (HAJCSSVCLI)AJCMEM(sizeof(AJCSSVCLI))) {
					memset(pC, 0, sizeof(AJCSSVCLI));
					//	インスタンス識別ＩＤ設定
					pC->InstID = SSV_CLIT_ID;
					//	クライアント接続順序番号設定
					pC->SeqNo = ++pW->CliSeqNo;
					//	インスタンスワークアドレス設定
					pC->pW = pW;
					//	クライアントのソケットハンドル設定
					pC->hSockClient = hSock;
					//	クライアントスレッド起動
					if (!SsvStartThreadClient(pW, pC)) {
						//	クライアントスレッド開始失敗エラー通知
						SsvNtcEvtToUser(pW, AJCSSV_EV_ERR, NULL, 0, AJCSSV_ERR_THREADCLIENT, NULL);
						//	クライアント通信ソケットクローズ
						closesocket(pC->hSockClient);
						//	クライアントスレッド用ワーク解放
						AJCFREE(pC);
						break;
					}
					//	クライアント情報設定
					memcpy(&pC->SockAddr, &SockAddr, sizeof SockAddr);
					pC->ThreadId = pC->idThreadClient;
					//	クライアントインスタンス登録
					AjcAvlInsNode(pW->hAvlCli, (UX)pC, (C_VOP)&pC, sizeof pC);
				}
				else {
					//	クライアントスレッド用ワーク確保失敗エラー通知
					SsvNtcEvtToUser(pW, AJCSSV_EV_ERR, NULL, 0, AJCSSV_ERR_CRETHREADWORK, NULL);
					//	クライアント通信ソケットクローズ
					closesocket(hSock);
				}
			}
			else {
				//	クライアント接続数オーバー エラー通知
				SsvNtcEvtToUser(pW, AJCSSV_EV_ERR, NULL, 0, AJCSSV_ERR_CONNOVER, NULL);
				//	クライアント通信ソケットクローズ
				closesocket(hSock);
			}
		}

		//	サーバの終了指示を待つ
		WaitForSingleObject(pW->hEvtExit, INFINITE);

		//	全てのクライアント終了を待つ
		WaitForSingleObject(pW->hEvtNoClients, 5000);

		//	クライアントカウンタ削除
		SsvDeleteClientCount(pW);

		//	サーバの終了を通知
		SsvNtcEvtToUser(pW, AJCSSV_EV_STOP, NULL, 0, 0, NULL);
	}
	else {
		//	接続待機スレッド開始失敗（通知不要，スレッドが即座に終了する為、_beginthread()のエラーとなる）
	//	SsvNtcEvtToUser(pW, AJCSSV_EV_ERR, NULL, 0, AJCSSV_ERR_THREADLISTEN, NULL);
	}
	return 0;
}
