﻿#include	"AjcInternal.h"
#include	"AjcSockServerDef.h"
//**************************************************************************************************************//
//																												//
//	ソケット ( TCP/IP ) サーバ							電源制御スレッド										//
//																												//
//**************************************************************************************************************//
static	UI	_stdcall	PowCtrlThread(VOP pVoid);

//==============================================================================================================//
//																												//
//	電源制御スレッド開始																						//
//																												//
//==============================================================================================================//
BOOL	SsvStartThreadPowCtrl(HAJCSSV pW)
{
	BOOL	rc = FALSE;

	if ((pW->hThreadPowCtrl = (HANDLE)_beginthreadex(NULL,					//	セキュリティ
													0,						//	スタックサイズ
													PowCtrlThread,			//	スレッド関数
													(VOP)pW,				//	スレッド引数
													0,						//	スレッド初期フラグ
													&pW->idThreadPowCtrl)	//	スレッド識別子
									) != NULL) {
		rc = TRUE;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	電源制御スレッド																							//
//--------------------------------------------------------------------------------------------------------------//
static	UI _stdcall PowCtrlThread(VOP pVoid)
{
	HAJCSSV		pW	  = (HAJCSSV)pVoid;
	int			Count = 0;

	while (WaitForSingleObject(pW->hEvtExit, 200) == WAIT_TIMEOUT) {
		if (Count >= 100) {
			//	スリープ抑止
			if (pW->opt & AJCSSV_SOP_SUP_SLEEP) {
				SetThreadExecutionState(ES_SYSTEM_REQUIRED);
			}
			//	ディスプレィＯＦＦ抑止
			if (pW->opt & AJCSSV_SOP_SUP_DISPOFF) {
				SetThreadExecutionState(ES_DISPLAY_REQUIRED);
			}
			Count = 0;
		}
		Count++;
	}
	return 0;
}
