﻿#include	"AjcInternal.h"



//==============================================================================================================//
//	インスタンス生成																							//
//																												//
//	引　数	：	cbp			- インスタンスハンドル																//
//																												//
//	戻り値	：	≠NULL : 成功（インスタンスハンドル）															//
//				＝NULL : 失敗																					//
//==============================================================================================================//
AJCEXPORT	HAJCSPD	WINAPI	AjcSpdCreate(UI seed)
{
	HAJCSPD		pW = NULL;
	int			rnd;

	if (pW = (HAJCSPD)AJCMEM(sizeof(AJCSPD))) {
		memset(pW, 0, sizeof(AJCSPD));
		pW->param.vCent.x = 0.0;
		pW->param.vCent.y = 0.0;
		pW->param.vCent.z = 0.0;
		pW->param.radius  = 1.0;
		pW->param.noise   = 3.0;
		pW->param.xrot	  = 0.5;;
		pW->param.yrot	  = 0.5;
		pW->param.pitch   = 8.0;

		//	乱数系列初期化
		if (seed != 0) {
			srand(seed);
		}

		//	回転軸
		rnd = rand(); pW->vAxis.x = (rnd & 1) ? rnd : -rnd;
		rnd = rand(); pW->vAxis.y = (rnd & 1) ? rnd : -rnd;
		rnd = rand(); pW->vAxis.z = (rnd & 1) ? rnd : -rnd;
		AjcV3dNormal(&pW->vAxis, &pW->vAxis);
		AjcV3dMult	(&pW->vAxis, pW->param.radius, &pW->vAxis);

		//	プロット点
		rnd = rand(); pW->vPt.x = (rnd & 1) ? rnd : -rnd;
		rnd = rand(); pW->vPt.y	= (rnd & 1) ? rnd : -rnd;
		rnd = rand(); pW->vPt.z	= (rnd & 1) ? rnd : -rnd;
		AjcV3dNormal(&pW->vPt, &pW->vPt);
		AjcV3dMult	(&pW->vPt, pW->param.radius, &pW->vPt);

		pW->cnt 	= 0;
	}
	return pW;
}
//==============================================================================================================//
//	インスタンス消去																							//
//																												//
//	引　数	：	pW			 - インスタンスハンドル																//
//																												//
//	戻り値	：	TRUE  : 成功																					//
//				FALSE : 失敗																					//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcSpdDelete(HAJCSPD pW)
{
	BOOL	rc = FALSE;

	if (pW != NULL) {
		free(pW);
		rc = TRUE;
	}

	return rc;
}
//==============================================================================================================//
//	パラメタ設定																								//
//																												//
//	引　数	：	pW			 - インスタンスハンドル																//
//				pParam		 - パラメタのアドレス																//
//																												//
//	戻り値	：	TRUE  : 成功																					//
//				FALSE : 失敗																					//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcSpdSetParam(HAJCSPD pW, PCAJCSPD_PARAM pParam)
{
	BOOL	rc = FALSE;

	if (pW != NULL) {
		//	パラメタ値
		memcpy(&pW->param, pParam, sizeof(AJCSPD_PARAM));

		//	回転軸
		AjcV3dNormal(&pW->vAxis, &pW->vAxis);
		AjcV3dMult	(&pW->vAxis, pW->param.radius, &pW->vAxis);

		//	プロット点
		AjcV3dNormal(&pW->vPt, &pW->vPt);
		AjcV3dMult	(&pW->vPt, pW->param.radius, &pW->vPt);
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	パラメタ取得																								//
//																												//
//	引　数	：	pW			 - インスタンスハンドル																//
//				pParam		 - パラメタを格納するバッファのアドレス												//
//																												//
//	戻り値	：	TRUE  : 成功																					//
//				FALSE : 失敗																					//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcSpdGetParam(HAJCSPD pW, PAJCSPD_PARAM  pBuf)
{
	BOOL	rc = FALSE;

	if (pW != NULL) {
		memcpy(pBuf, &pW->param, sizeof(AJCSPD_PARAM));
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	演算																										//
//																												//
//	引　数	：	pW			- インスタンスハンドル																//
//				pBuf		- 演算結果を格納するバッファのアドレス												//
//																												//
//	戻り値	：	TRUE  : 成功																					//
//				FALSE : 失敗																					//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcSpdCalc(HAJCSPD pW, double *x, double *y, double *z)
{
	BOOL		rc = FALSE;
	AJC3DVEC	v;

	if (rc = AjcSpdCalcV(pW, &v)) {
		if (x != NULL) *x = v.x;
		if (y != NULL) *y = v.y;
		if (z != NULL) *z = v.z;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
AJCEXPORT	BOOL	WINAPI	AjcSpdCalcV(HAJCSPD pW, PAJC3DVEC pBuf)
{
	BOOL		rc = FALSE;
	int			rnd;
	double		t, r, dl;

	if (pW != NULL) {
		//	ノイズ注入した半径算出
		rnd = rand();
		dl	= (pW->param.radius * pW->param.noise / 100.0) * ((double)rnd / (double)RAND_MAX);
		if (rnd & 1) r = pW->param.radius - dl;
		else		 r = pW->param.radius + dl;

		//	プロット点算出
		AjcV3dNormal(&pW->vPt, pBuf);
		AjcV3dMult	(pBuf, r, pBuf);

		//	中心位置加算
		AjcV3dAdd(pBuf, &pW->param.vCent, pBuf);

		//	次のプロット点算出
		if (pW->cnt < 900) {
			//	回転軸をＸ軸回りに回転
			if (pW->param.xrot != 0.0) {
				t = pW->param.xrot * (double)rand() / (double)RAND_MAX;
				AjcV3dRotateX(&pW->vAxis, t, &pW->vAxis);
			}
			//	回転軸をＹ軸回りに回転
			if (pW->param.xrot != 0.0) {
				t = pW->param.yrot * (double)rand() / (double)RAND_MAX;
				AjcV3dRotateY(&pW->vAxis, t, &pW->vAxis);
			}
			//	プロット点を回転軸回りに回転
			t = pW->param.pitch * (double)rand() / (double)RAND_MAX;
			AjcV3dRotateAny(&pW->vPt, t, &pW->vAxis, &pW->vPt);
			//	半径を正規の長さに調整
			AjcV3dNormal(&pW->vPt, &pW->vPt);
			AjcV3dMult	(&pW->vPt, pW->param.radius, &pW->vPt);
		}

		//	カウンタ更新
		if (pW->cnt++ >= 1000) {
			pW->cnt = 0;
		}

		rc = TRUE;
	}
	return rc;
}
