﻿#include	"AjcInternal.h"

//**************************************************************************************************************//
//																												//
//	スプライン補間																								//
//																												//
//**************************************************************************************************************//
//==============================================================================================================//
//	１価関数用テーブル作成																						//
//																												//
//	引　数	：	n		- データ個数																			//
//				x		- Ｘ値配列																				//
//				y		- Ｙ値配列																				//
//				x		- 補間３次式の２次導関数の1/6値を格納する配列											//
//																												//
//	戻り値	：	TRUE  - 成功																					//
//				FALSE - 失敗																					//
//==============================================================================================================//
AJCEXPORT	BOOL	WINAPI	AjcSplMkTbl(int n, const double x[], const double y[], double z[])
{
	BOOL		rc = FALSE;
	int			i;
	double		t;
	double		*h = NULL;
	double		*d = NULL;

	if (x != NULL && y != NULL && z != NULL) {
		if (n > 2 && (h = (double *)AJCMEM(sizeof(double) * n)) != NULL && (d = (double *)AJCMEM(sizeof(double) * n)) != NULL){
			z[0] = z[n - 1] = 0.0;
			for (i = 0; i < n - 1; i++) {
				h[i    ] =	x[i + 1] - x[i];
				d[i + 1] = (y[i + 1] - y[i]) / h[i];
			}
			z[1] = d[2] - d[1] - h[0] * z[0];
			d[1] = 2.0 * (x[2] - x[0]);
			for (i = 1; i < n - 2; i++) {
				t = h[i] / d[i];
				z[i + 1] = d[i + 2] - d[i + 1] - z[i] * t;
				d[i + 1] = 2.0 * (x[i + 2] - x[i]) - h[i] * t;
			}
			z[n - 2] -= h[n - 2] * z[n - 1];
			for (i = n - 2; i > 0; i--) {
				z[i] = (z[i] - h[i] * z[i + 1]) / d[i];
			}
			rc = TRUE;
		}
		if (h != NULL) free(h);
		if (d != NULL) free(d);
	}
	return rc;
}
//==============================================================================================================//
//	１価関数用補間値算出																						//
//																												//
//	引　数	：	n		- データ個数																			//
//				t		- 補間値(y)を算出する x 値																//
//				x		- Ｘ値配列																				//
//				y		- Ｙ値配列																				//
//				x		- 補間３次式の２次導関数の1/6値の配列													//
//																												//
//	戻り値	：	補間値(y)																						//
//==============================================================================================================//
AJCEXPORT	double	WINAPI	AjcSplCalc (int n, double t, const double x[], const double y[], const double z[])
{
	double	rc = 0.0;
	int		i, j, k;
	double	d, h;

	if (x != NULL && y != NULL && z != NULL) {
		i = 0;
		j = n - 1;
		while (i < j) {
			k = (i + j) / 2;
			if (x[k] < t) i = k + 1;
			else		  j = k;
		}
		if (i > 0) i--;
		h = x[i + 1] - x[i];
		d = t - x[i];

		rc = (((z[i + 1] - z[i]) * d / h + z[i] * 3.0) * d
			+ ((y[i + 1] - y[i]) / h
			- (z[i] * 2.0 + z[i + 1]) * h)) * d + y[i];
	}
	return rc;
}

