﻿#include	"AjcInternal.h"

//**************************************************************************************************************//
//																												//
//	標準入力																									//
//																												//
//**************************************************************************************************************//

//#define	USE_KBHIT	//	_kbhit()は使用不可(Windowsバグ)の為、この行はコメント化しておくこと

#define		IX2CP(IX)		AciIxToCp(pW, IX)		/*	バッファインデクス → 相対カーソル位置変換	*/

//--------------------------------------------------------------------------------------------------------------//
//	ワーク																										//
//--------------------------------------------------------------------------------------------------------------//
static	HAJCAVL		hAvlConInp = NULL;		//	コンソールウインドハンドル管理用ＡＶＬ

//--------------------------------------------------------------------------------------------------------------//
//	定数																										//
//--------------------------------------------------------------------------------------------------------------//
//	個数，サイズ定数
//#ifdef _DEBUG
//	#define	ACIMAX_REFTXT	4		//	前回入力の参照テキストの最大数
//	#define	ACIMAX_AGAIN	32		//	やり直しの最大数
//	#define	ACIMAX_BUFLEN	64		//	最大入力バッファサイズ
//#else
	#define	ACIMAX_REFTXT	64		//	前回入力の参照テキストの最大数
	#define	ACIMAX_AGAIN	128		//	やり直しの最大数
	#define	ACIMAX_BUFLEN	4096	//	最大入力バッファサイズ
//#endif

//	処理状態
typedef	enum {
	ACIST_NORMAL		=	0,	//	通常モード
	ACIST_HUNT_00			 ,	//	0x00の次のバイト
	ACIST_HUNT_E0			 ,	//	0xE0の次のバイト
} ACISTATE, *PACISTATE;

//	ヘルプ表示スレッドへのコマンド
typedef enum {					//								val1	val2
	ACICCD_SHOWHELP		=  1,	//	ヘルプ表示					－		－	
	ACICCD_SHOWTEXT			,	//	テキスト表示				－		－	
	ACICCD_SHOWGUIDE		,	//	簡易ガイド表示				－		－	
	ACICCD_HIDE				,	//	ツールチップ非表示			－		－	
	ACICCD_SHOWREDO			,	//	やり直し位置表示			分子	分母
	ACICCD_SHOWPREV			,	//	参照テキスト位置表示		分子	分母
	ACICCD_END			=  9,	//	スレッド終了				－		－	
} ACICCD, *PACICCD;

//	ヘルプ種別
typedef enum {
	HELP_F1		= 1	,
	HELP_F2			,
} HELP_KIND;

//		ヘルプ表示スレッドへのコマンド形式
typedef struct {
	ACICCD	ccd;
	int		val1, val2;
} ACICMD, *PACICMD;

//--------------------------------------------------------------------------------------------------------------//
//	ヘルプテキスト																								//
//--------------------------------------------------------------------------------------------------------------//
static const WC		HelpTextJ[] = 	L" ===== キー入力操作 ================\n"
									L"   ENTER -- 入力確定\n"
									L"   ESC ---- 入力中止\n"
									L"   [^]DEL - １文字削除[行クリアー]\n"
									L"   BS ----- １文字後退\n"
									L"   [^]← -- カーソル左[左端]移動\n"
									L"   [^]→ -- カーソル右[右端]移動\n"
									L"   [^]↑ -- 前回[最古]入力テキスト\n"
									L"   [^]↓ -- 次の[ 現 ]入力テキスト\n"
									L"   ^C ----- 入力テキストをコピー\n"
									L"   ^S ----- 入力テキスト全体を表示\n"
									L"   ^X ----- コピー＆クリアー\n"
									L"   ^V ----- テキスト貼り付け\n"
									L"   ^Z ----- やり直し\n"
									L"   ^Y ----- やり直しのやり直し\n"
									L"   F1/F2 -- ヘルプ表示 / 非表示\n\n"
									L" カーソルを外へ移動で非表示となります";

static const WC		HelpTextE[] = 	L" ===== Key Operations ===============\n"
									L"   ENTER -- End of input\n"
									L"   ESC ---- Cancel input\n"
									L"   [^]DEL - Delete a character[Clear line]\n"
									L"   BS ----- One character backward\n"
									L"   [^]← -- Move cursor left[top]\n"
									L"   [^]→ -- Move cursor right[tail]\n"
									L"   [^]↑ -- Last input[Most old] text\n"
									L"   [^]↓ -- Next input[Current ] text\n"
									L"   ^C ----- Copy the entered text\n"
									L"   ^S ----- Show entire input text\n"
									L"   ^X ----- Copy & clear\n"
									L"   ^V ----- Paste text\n"
									L"   ^Z ----- Redo\n"
									L"   ^Y ----- Redo of Redo\n"
									L"   F1/F2 -- Help display / hide\n\n"
									L" Move the cursor out to hide it.";

static const WC		Guide1J[] =	L"\n Ｆ１キーでヘルプを表示します。\n";
static const WC		Guide2J[] =	L"\n Ｆ１ / Ｆ２ キーでヘルプを表示します。\n";

static const WC		Guide1E[] =	L"\n Display help with F1 key. \n";
static const WC		Guide2E[] =	L"\n Display help with F1 or F2 key. \n";


//--------------------------------------------------------------------------------------------------------------//
//	コンソール入力インスタンスワーク																			//
//--------------------------------------------------------------------------------------------------------------//
typedef struct {
	CONSOLE_SCREEN_BUFFER_INFOEX bi;	//	コンソールスクリーンバッファ情報
	int			sty;					//	コンソールウインドスタイル
	UI			fOpt;					//	オプションフラグ（AJCCIN_XXXXX）
	ACISTATE	mode;					//	処理状態
	HWND		hCon;					//	コンソールウインドハンドル
	HANDLE		hStd;					//	標準出力ハンドル
	HAJCSPL		hSpl;					//	文字列プール
	HFONT		hFont;					//	コンソールのフォント
	int			xtop, xend;				//	カーソル先頭Ｘ位置（起動時のＸ位置），終端位置
	int			ytop;					//	カーソル先頭Ｙ位置（起動時のＹ位置）
	COORD		pos;					//	カーソル現在位置
	BOOL		fRefTxt;				//	過去の参照テキスト表示中フラグ
	int			rfn;					//	参照テキストの個数
	int			rix;					//	参照テキストインデクス（0:最古 ～ n-1:最新）
	C_WCP		pRef[ACIMAX_REFTXT];	//	参照テキスト（文字列へのポインタ）
	int			agn;					//	やり直しデータの個数
	int			aix;					//	やり直しデータインデクス（最終テキストの次／最古のテキスト）
	int			acp;					//	やり直しデータインデクス（現在位置）
	WCP			pAgn[ACIMAX_AGAIN];		//	やり直しデータポインタ
	int			bAgn[ACIMAX_AGAIN];		//	やり直しデータのバッファインデクス（カーソル位置）
	int			vAgn[ACIMAX_AGAIN];		//	やり直しデータの表示先頭位置
	int			fdl;					//	フィールド長
	int			vix;					//	表示先頭インデクス
	int			bix;					//	入力バッファインデクス
	int			bfl;					//	入力バッファサイズ
	WC			buf  [ACIMAX_BUFLEN];	//	入力バッファ
	WC			svbuf[ACIMAX_BUFLEN];	//	入力バッファ退避
	int			svbix;					//	入力バッファ退避時のカーソル位置
	int			svvix;					//	入力バッファ退避時の表示先頭位置

	WCP			pHelp;					//	ユーザヘルプテキスト(F2)
	HANDLE		hThread;				//	ヘルプ表示スレッドハンドル
	UL			idThread;				//	ヘルプ表示スレッドＩＤ
	HAJCFMBX	hFMbxCmd;				//	メールボックスハンドル（スレッドへの指示コマンド）
	HANDLE		hEvtStart;				//	スレッド開始通知用イベントハンドル
	HANDLE		hEvtCmdEnd;				//	コマンド終了待ち用イベントハンドル
} WKCONINP, *PWKCONINP;

//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
static BOOL	SubConInputEx(PWKCONINP pW, C_WCP pIniTxt, WCP pBuf, UI lBuf, UI fOpt, COLORREF TextColor, COLORREF BackColor);
static	VO			AciEnding				(PWKCONINP pW);
static	BOOL		AciInsChar				(PWKCONINP pW, WC c);
static	int			AciIxToCp				(PWKCONINP pW, int ix);
static	BOOL		AciSetCursorPos			(PWKCONINP pW, int ix);
static	BOOL		AciCursorToLeft			(PWKCONINP pW);
static	BOOL		AciCursorToRight		(PWKCONINP pW);
static	BOOL		AciDelChar				(PWKCONINP pW);
static	BOOL		AciBackSpace			(PWKCONINP pW);
static	BOOL		AciCopy					(PWKCONINP pW);
static	BOOL		AciCut					(PWKCONINP pW);
static	VO			AciClearLine			(PWKCONINP pW);
static	BOOL		AciPaste				(PWKCONINP pW);
static	BOOL		AciRedo					(PWKCONINP pW);
static	BOOL		AciRedoOfRedo			(PWKCONINP pW);
static	BOOL		AciUpdateAgainText		(PWKCONINP pW);
static	BOOL		SubUpdateAgainText		(PWKCONINP pW, C_WCP pTxt, int bix, int vix);
static	VO			AciLoadRefText			(PWKCONINP pW);
static	VO			AciSaveRefText			(PWKCONINP pW);
static	BOOL		AciRegistRefText		(PWKCONINP pW);
static	BOOL		AciSetRefTextBackword	(PWKCONINP pW);
static	BOOL		AciSetRefTextForword	(PWKCONINP pW);
static	VO			AciSetTextToBuffer		(PWKCONINP pW, C_WCP pTxt);
static	VO			AciSetTailOfText		(PWKCONINP pW);
static	VO			AciShowBufferText		(PWKCONINP pW);
static	VO			AciSendCmdToThread		(PWKCONINP pW, ACICCD ccd, int val1, int val2);
static	COLORREF	AciGetConsoleForColor	(PWKCONINP pW);
static	COLORREF	AciGetConsoleBackColor	(PWKCONINP pW);
static	VO			AciChangeConsoleColor	(PWKCONINP pW, COLORREF cText, COLORREF cBack);
static	VO	 		AciChangeConsole16Color	(PWKCONINP pW, COLORREF cText, COLORREF cBack);
static	VO	 		AciChangeConsoleFullColor(PWKCONINP pW, COLORREF cText, COLORREF cBack);
static	VO			AciRecoverConsoleColor	(PWKCONINP pW);

static	BOOL		AciPrintF				(C_WCP pFmt, ...);

static	UI _stdcall threadHelp(VOP pVoid);
static BOOL CALLBACK hdlConsole(UL CtrlType);


//==============================================================================================================//
//	起動時初期設定																								//
//==============================================================================================================//
BOOL		AjcConInpInit(VO)
{
	BOOL	rc = FALSE;

	if (hAvlConInp = AjcAvlCreate (0, NULL, NULL)) {
		AjcAvlEnableMultiThread(hAvlConInp, TRUE);
		rc = TRUE;
	}
	return rc;
}
//==============================================================================================================//
//	終了時後処理																								//
//==============================================================================================================//
VO			AjcConInpEnd(VO)
{
	//	ＡＶＬ消去
	if (hAvlConInp != NULL) {
		AjcAvlDelete(hAvlConInp);
		hAvlConInp = NULL;
	}
}

//==============================================================================================================//
//	１行入力（簡易）																							//
//																												//
//	引　数：	pBuf	- 初期文字列／入力文字格納バッファ														//
//				lBuf	- 入力文字格納バッファのバイト数／文字数												//
//																												//
//	戻り値：	TRUE  - 正常（ENTERで終了）																		//
//				FALSE - キャンセル／エラー																		//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcConInputEasyA(BCP pBuf, UI lBuf)
{
	return AjcConInputExA(NULL, lBuf, pBuf, lBuf, 0, -1, -1, NULL, 0, NULL);
}

//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcConInputEasyW(WCP pBuf, UI lBuf)
{
	return AjcConInputExW(NULL, lBuf, pBuf, lBuf, 0, -1, -1, NULL, 0, NULL);
}

//==============================================================================================================//
//	１行入力（コールバック）																					//
//																												//
//	引　数：	pBuf	- 初期文字列／入力文字格納バッファ														//
//				lBuf	- 入力文字格納バッファのバイト数／文字数												//
//																												//
//	戻り値：	TRUE  - 正常（ENTERで終了）																		//
//				FALSE - キャンセル／エラー																		//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcConInputByNtcA(UX cbp, VO (CALLBACK *cbNtcArgs)(int argc, BC *argv[], C_BCP pTxt, UX cbp))
{
	BC		buf[256];
	return AjcConInputExA(NULL, AJCTSIZE(buf), buf, AJCTSIZE(buf), 0, -1, -1, NULL, cbp, cbNtcArgs);
}

//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcConInputByNtcW(UX cbp, VO (CALLBACK *cbNtcArgs)(int argc, WC *argv[], C_WCP pTxt, UX cbp))
{
	WC		buf[256];
	return AjcConInputExW(NULL, AJCTSIZE(buf), buf, AJCTSIZE(buf), 0, -1, -1, NULL, cbp, cbNtcArgs);
}

//==============================================================================================================//
//	１行入力																									//
//																												//
//	引　数：	pInitialText	- 初期表示テキスト								(不要時はNULL）					//
//				lInpField		- 入力域の長さ（=半角文字数 + 1)												//
//				pBuf	  - 初期文字列／入力文字格納バッファ													//
//				lBuf	  - 入力文字格納バッファのバイト数／文字数												//
//				fOpt	  - オプションフラグ(AJCCIP_XXXXX)														//
//																												//
//	戻り値：	TRUE  - 正常（ENTERで終了）																		//
//				FALSE - キャンセル／エラー																		//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcConInputA(C_BCP pInitialText, UI lInpField, BCP pBuf, UI lBuf, UI fOpt)
{
	return AjcConInputExA(pInitialText, lInpField, pBuf, lBuf, fOpt, -1, -1, NULL, 0, NULL);
}

//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcConInputW(C_WCP pInitialText, UI lInpField, WCP pBuf, UI lBuf, UI fOpt)
{
	return AjcConInputExW(pInitialText, lInpField, pBuf, lBuf, fOpt, -1, -1, NULL, 0, NULL);
}
//==============================================================================================================//
//	１行入力（詳細指定）																						//
//																												//
//	引　数：	pInitialText	- 初期表示テキスト								(不要時はNULL）					//
//				lInpField		- 入力域の長さ（=半角文字数 + 1)												//
//				pBuf	  		- 初期文字列／入力文字格納バッファ				(NULL:内部でバッファを生成）	//
//				lBuf	  		- 入力文字格納バッファのバイト数／文字数										//
//				fOpt	  		- オプションフラグ(AJCCIP_XXXXX)												//
//				TextColor 		- テキスト色									(-1：デフォルト）				//
//				BackColor 		- 背景色										(-1：デフォルト）				//
//				pHelp	  		- ヘルプテキスト								(不要時はNULL）					//
//				cbp		  		- コールバックパラメタ															//
//				cbNtcArgs 		- 入力文字を引数化した情報の通知用コールバック	(不要時はNULL）					//
//																												//
//	戻り値：	TRUE  - 正常（ENTERで終了）																		//
//				FALSE - キャンセル／エラー																		//
//==============================================================================================================//
//----- バイト文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcConInputExA (C_BCP pInitialText, UI lInpField,
										BCP pBuf, UI lBuf,
										UI fOpt, COLORREF TextColor, COLORREF BackColor, C_BCP pHelpText,
										UX cbp, VO (CALLBACK *cbNtcArgs)(int argc, BC *argv[], C_BCP pTxt, UX cbp))
{
	BOOL		rc	  = FALSE;
	WKCONINP	wrk;
	PWKCONINP	pW;
	UI			stl;
	WCP			pIniTxt = NULL;
	WC			tmp[ACIMAX_BUFLEN] = {0};

	//	入力域の長さ０ → MAX
	if (lInpField == 0) {
		lInpField = ACIMAX_BUFLEN;
	}

	if (lInpField >= 1 && pBuf != NULL && lBuf >= 2 && lBuf <= ACIMAX_BUFLEN) {

		//	ワーククリアー
		memset(&wrk, 0, sizeof wrk);
		pW = &wrk;

		//	入力バッファ長設定（入力文字数はバッファ長で制限する）
		pW->bfl = lBuf;

		//	入力フィールド長設定
		pW->fdl = __min(lInpField, ACIMAX_BUFLEN);

		//	初期テキスト作成（ワイド文字へ変換）
		if (pInitialText != NULL) {
			stl = MultiByteToWideChar(CP_ACP, 0, pInitialText, -1, NULL, 0);
			if (pIniTxt = AjcTAllocW(stl)) {
				MultiByteToWideChar(CP_ACP, 0, pInitialText, -1, pIniTxt, stl);
			}
		}
		//	ヘルプテキスト設定
		if (pHelpText != NULL) {
			stl = MultiByteToWideChar(CP_ACP, 0, pHelpText, -1, NULL, 0);
			if (pW->pHelp = AjcTAllocW(stl + 1)) {
				MultiByteToWideChar(CP_ACP, 0, pHelpText, -1, pW->pHelp, stl + 1);
			}
		}

		//	行テキスト入力
		if (rc = SubConInputEx(pW, pIniTxt, tmp, ACIMAX_BUFLEN, fOpt, TextColor, BackColor)) {
			//	入力テキストをバイト文字に変換
			WideCharToMultiByte(CP_ACP, 0, tmp, -1, pBuf, lBuf, NULL, NULL);
			pBuf[lBuf - 1] = 0;
			//	コールバック
			if (cbNtcArgs != NULL) {
				UI		argc;
				BCP		*argv;
				if (argv = AjcParseCmdArgsA(pBuf, &argc)) {
					cbNtcArgs(argc, argv, pBuf, cbp);
					AjcReleaseCmdArgs(argv);
				}
			}
		}

		//	初期テキスト解放
		if (pIniTxt != NULL) free(pIniTxt);
	}
	return rc;
}
//----- ワイド文字 ---------------------------------------------------------------------------------------------//
AJCEXPORT BOOL	 WINAPI AjcConInputExW (C_WCP pInitialText, UI lInpField,
										WCP pBuf, UI lBuf,
										UI fOpt, COLORREF TextColor, COLORREF BackColor, C_WCP pHelpText,
										UX cbp, VO (CALLBACK *cbNtcArgs)(int argc, WC *argv[], C_WCP pTxt, UX cbp))
{
	BOOL		rc	  = FALSE;
	WKCONINP	wrk;
	PWKCONINP	pW;
	UI			stl;
	WCP			pIniTxt = NULL;

	if (lInpField >= 1 && pBuf != NULL && lBuf >= 2 && lBuf <= ACIMAX_BUFLEN / 2) {
		//	ワーククリアー
		memset(&wrk, 0, sizeof wrk);
		pW = &wrk;

		//	入力バッファ長設定（最大長を指定する）
		pW->bfl = ACIMAX_BUFLEN;

		//	入力フィールド長設定
		pW->fdl = __min(lInpField, ACIMAX_BUFLEN);

		//	初期テキストコピー
		if (pInitialText != NULL) {
			stl = (int)wcslen(pInitialText);
			if (pIniTxt = AjcTAllocW(stl + 1)) {
				wcscpy(pIniTxt, pInitialText);
			}
		}
		//	ヘルプテキスト設定
		if (pHelpText != NULL) {
			stl = (UI)wcslen(pHelpText);
			if (pW->pHelp = AjcTAllocW(stl + 1)) {
				wcscpy(pW->pHelp, pHelpText);
			}
		}

		//	行テキスト入力
		if (rc = SubConInputEx(pW, pIniTxt, pBuf, lBuf, fOpt, TextColor, BackColor)) {
			//	コールバック
			if (cbNtcArgs != NULL) {
				UI		argc;
				WCP		*argv;
				if (argv = AjcParseCmdArgsW(pBuf, &argc)) {
					cbNtcArgs(argc, argv, pBuf, cbp);
					AjcReleaseCmdArgs(argv);
				}
			}
		}

		//	初期テキスト解放
		if (pIniTxt != NULL) free(pIniTxt);

	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	共通サブ																									//
//--------------------------------------------------------------------------------------------------------------//
static BOOL	SubConInputEx(PWKCONINP pW, C_WCP pIniTxt, WCP pBuf, UI lBuf, UI fOpt, COLORREF TextColor, COLORREF BackColor)
{
	BOOL		rc	= FALSE;
	WC			c;						//	入力文字
	COORD		pos;

	do {
		//	オプションフラグ退避
		pW->fOpt = fOpt;
		//	文字列プール生成
		pW->hSpl = AjcSplCreate(AJCCMP_EXACT_WIDTH);
		if (pW->hSpl == NULL) break;
		//	コンソールウインドハンドル取得
		pW->hCon = GetConsoleWindow();
		if (pW->hCon == NULL) break;
		//	コンソールウインドハンドル登録
		AjcAvlInsNode(hAvlConInp, (UX)pW->hCon, (C_VOP)&pW, sizeof(pW));
		//	コンソールウインドのサイズ変更を禁止
		pW->sty = (int)MAjcGetWindowLong(pW->hCon, GWL_STYLE);
		MAjcSetWindowLong(pW->hCon, GWL_STYLE, pW->sty & ~WS_THICKFRAME);
		//	標準出力ハンドル取得
		pW->hStd = GetStdHandle(STD_OUTPUT_HANDLE);
		if (pW->hStd == NULL) break;
		//	参照テキストロード
		AciLoadRefText(pW);
		//	カーソル位置取得と先頭，末尾桁位置設定
		pW->bi.cbSize = sizeof(pW->bi);
		GetConsoleScreenBufferInfoEx(pW->hStd, &pW->bi);
		pW->xtop  = pW->bi.dwCursorPosition.X;
		pW->ytop  = pW->bi.dwCursorPosition.Y;
		pW->xend  = pW->bi.srWindow.Right;
		//	フィールド長設定
		pW->fdl   = __min(pW->fdl, (pW->xend - pW->xtop));
		pW->fdl   = __min(pW->fdl, sizeof pW->buf - 1);
		pW->fdl   = __min(pW->fdl, (int)lBuf - 1);

		//	背景を少し変える
		AciChangeConsoleColor(pW, TextColor, BackColor);

		//	バッファへ初期テキスト設定
		AciSetTextToBuffer(pW, pIniTxt);

		//	スレッドからのコマンド終了待ち用イベントオブジェクト生成（手動リセット，非シグナル状態）
		if ((pW->hEvtCmdEnd = CreateEvent(NULL, TRUE, FALSE, NULL)) == NULL) {
			break;
		}
		//	スレッドへのコマンド送信用メールボックス生成
		if ((pW->hFMbxCmd = AjcFMbxCreate(sizeof(ACICMD), 0, NULL)) == NULL) {
			break;
		}
		//	ヘルプ表示スレッドを生成する
		if ((pW->hThread = (HANDLE)_beginthreadex(NULL,					//	セキュリティ
												  0,					//	スタックサイズ
												  threadHelp,			//	スレッド関数
												  (VOP)pW,				//	スレッド引数
												  0,					//	スレッド初期フラグ
												  (UIP)&pW->idThread)	//	スレッド識別子
							) == NULL) {
			break;
		}
		//	スレッドからの開始通知用イベントオブジェクト生成（手動リセット，非シグナル状態）
		if ((pW->hEvtStart = CreateEvent(NULL, TRUE, FALSE, NULL)) == NULL) {
			break;
		}
		//	スレッドの開始待ち
		if (WaitForSingleObject(pW->hEvtStart, 1000) != WAIT_OBJECT_0) {
			break;
		}
		//	コンソールハンドラ追加
		SetConsoleCtrlHandler(hdlConsole, TRUE);
		//	初期ガイド表示
		AciSendCmdToThread(pW, ACICCD_SHOWGUIDE, 0, 0);
		//	テキストバッファ退避
		wcscpy(pW->svbuf, pW->buf);
		pW->svbix = pW->bix;
		pW->svvix = pW->vix;
		//	バッファデータ表示＆カーソル位置設定
		AciShowBufferText(pW);

		//	キー入力ループ
		while (TRUE) {
		#ifdef USE_KBHIT
		//	※	0x00, 0xE0の次のバイトは _kbhit()でチェックできない為、強制的に読み出す。(->Windowsのバグ)
		//		また、_getch()では全角２バイト目が_kbhit()でチェックできない為、_getwch()により、UNICODEで読み出す。(->Windowsのバグ)
			if (_kbhit() ||														//	キーデータ有り or
					 pW->mode == ACIST_HUNT_E0 || pW->mode == ACIST_HUNT_00) {	//	00 / E0 後のバイトデータ
		#endif
			//	キーデータ読み出し
				c = _getwch_nolock();
				#ifdef _DEBUG
				//	AjcTrace("%02X\n", c);	//	@@@
				#endif
				//	●通常モード
				if	(pW->mode == ACIST_NORMAL) {
					//	２バイト入力(00, XX)
					if		(c == 0x00	  ) {
						pW->mode = ACIST_HUNT_00;
					}
					//	２バイト入力(E0, XX)
					else if (c == 0xE0	  ) {
						pW->mode = ACIST_HUNT_E0;
					}
					//	ENTER
					else if (c == 0x0D) {
						//	参照テキスト登録
						AciRegistRefText(pW);
						//	戻り情報（入力テキスト）設定
						wcscpy(pBuf, pW->buf);
						//	戻り値＝ＯＫ
						rc = TRUE;
						break;
					}
					//	ESC
					else if (c == 0x1B) {
						break;
					}
					//	BS
					else if (c == 0x08) {
						AciBackSpace(pW);
					}
					//	Ctrl + C（コピー）
					else if (c == 0x03) {
						AciCopy(pW);
					}
					//	Ctrl + S（テキスト表示）
					else if (c == 0x13) {
						AciSendCmdToThread(pW, ACICCD_SHOWTEXT, 0, 0);
					}
					//	Ctrl + X（切り取り）
					else if (c == 0x18) {
						AciCut(pW);
					}
					//	Ctrl + V（貼り付け）
					else if (c == 0x16) {
						AciPaste(pW);
					}
					//	Ctrl + Z（やり直し）
					else if (c == 0x1A) {
						AciRedo(pW);
					}
					//	Ctrl + Y（やり直しのやり直し）
					else if (c == 0x19) {
						//	やり直しのやり直し
						AciRedoOfRedo(pW);
					}
					//	１文字
					else {
						if (!MAjcIsTrail(c)) {
							if		(iswcntrl	(c)) c = L' ';
							else if (MAjcIsLeadW(c)) c = L'?';
							AciInsChar(pW, c);
						}
					}
				}
				//	●0x00の次
				else if (pW->mode == ACIST_HUNT_00) {
					switch (c) {
						case 0x3B:		//	F1（ヘルプ表示）
							AciSendCmdToThread(pW, ACICCD_SHOWHELP, HELP_F1, 0);
							break;

						case 0x3C:		//	F2（ユーザヘルプ表示）
							AciSendCmdToThread(pW, ACICCD_SHOWHELP, HELP_F2, 0);
							break;
					}
					pW->mode = ACIST_NORMAL;
				}
				//	●0xE0の次
				else if (pW->mode == ACIST_HUNT_E0) {
					switch (c) {
						case 0x53:		//	DEL（１文字削除）
							AciDelChar(pW);
							break;

						case 0x4B:		//	←（カーソル左移動）
							AciCursorToLeft(pW);
							break;

						case 0x4D:		//	→（カーソル右移動）
							AciCursorToRight(pW);
							break;

						case 0x48:		//	↑（前の参照テキスト）
							AciSetRefTextBackword(pW);
							break;

						case 0x50:		//	↓（次の参照テキスト）
							AciSetRefTextForword(pW);
							break;

						case 0x73:		//	CTRL + ←（カーソル左端移動）
							//	表示先頭，バッファインデクスを先頭に設定
							pW->bix = pW->vix = 0;
							//	バッファテキスト表示
							AciShowBufferText(pW);
							break;

						case 0x74:		//	CTRL + →（カーソル右端移動）
						{	int stl = (int)wcslen(pW->buf);
							int	ix	= stl - 1;
							int	fl = 0;
							//	表示先頭インデクス設定
							AciSetTailOfText(pW);
							//	バッファインデクスを末尾に設定
							pW->bix = stl;
							//	バッファテキスト表示
							AciShowBufferText(pW);
							break;
						}
						case 0x8D:		//	CTRL + ↑（最古の参照テキスト）
							pW->rix = 0;
							AciSetRefTextBackword(pW);
							break;

						case 0x91:		//	CTRL + ↓（現在のテキスト）
							pW->rix = pW->rfn;
							AciSetRefTextForword(pW);
							break;

						case 0x93:		//	CTRL + DEL （行クリアー）
							AciClearLine(pW);
							break;
					}
					pW->mode = ACIST_NORMAL;
				}
		#ifdef USE_KBHIT
			}
			//	キー入力無し
			else {
				AjcDoEventA();
				Sleep(1);
			}
		#endif
		}
		//	参照テキストセーブ
		AciSaveRefText(pW);
		//	コンソールハンドラ削除
		SetConsoleCtrlHandler(hdlConsole, FALSE);
	} while(0);

	//	コンソール表示色を元に戻す
	AciRecoverConsoleColor(pW);

	//	入力データ表示消去
	pos.X = pW->xtop;
	pos.Y = pW->ytop;
	SetConsoleCursorPosition(pW->hStd, pos);
	AciPrintF(L"%*c", pW->fdl, ' ');
	//	入力カーソル位置設定
	pos.X = pW->xtop;
	SetConsoleCursorPosition(pW->hStd, pos);
	//	入力テキスト表示
	if (fOpt & AJCCIN_SHOWTEXT) {
		if (rc) AciPrintF(L"%s\n"	  , pW->buf);
		else	AciPrintF(L"%s<ESC>\n", pW->buf);
	}
	//	コンソールウインドハンドル登録解除
	if (pW->hCon != NULL) {
		AjcAvlDelNode(hAvlConInp, (UX)pW->hCon);
	}
	//	コンソールウインドのサイズ変更を許可
	if (pW->hCon != NULL) {
		MAjcSetWindowLong(pW->hCon, GWL_STYLE, pW->sty);
	}

	//	終了時後処理
	AciEnding(pW);

	return rc;
}

//--------------------------------------------------------------------------------------------------------------//
//	終了時後処理																								//
//--------------------------------------------------------------------------------------------------------------//
static	VO	AciEnding(PWKCONINP pW)
{
	int		ix;

	//	チップテキスト破棄
	AjcTipTextDeleteForConApp();

	//	スレッド終了
	if (pW->hThread != NULL) {
		UI	cmd = ACICCD_END;
		AjcFMbxEnque(pW->hFMbxCmd, &cmd);
		WaitForSingleObject((HANDLE)pW->hThread, 10000);
		CloseHandle(pW->hThread);  pW->hThread = NULL;
	}
	//	スレッドハンドル クローズ
	if (pW->hThread != NULL) {
		CloseHandle(pW->hThread);
		pW->hThread = NULL;
	}
	//	メールボックス消去
	if (pW->hFMbxCmd != NULL) {
		AjcFMbxDelete(pW->hFMbxCmd);
		 pW->hFMbxCmd = NULL;
	}
	//	やり直しバッファ解放
	for (ix = 0; ix < pW->agn; ix++) {
		AJCFREE(pW->pAgn[ix]);
	}
	//	ヘルプテキスト解放
	if (pW->pHelp != NULL) {
		free(pW->pHelp);
		pW->pHelp = NULL;
	}
	//	文字列プール消去
	if (pW->hSpl != NULL) {
		AjcSplDelete(pW->hSpl);
		pW->hSpl = NULL;
	}
	//	スレッド開始通知用イベントオブジェクト消去
	if (pW->hEvtStart != NULL) {
		CloseHandle(pW->hEvtStart);
		pW->hEvtStart = NULL;
	}
	//	コマンド終了通知用イベントオブジェクト消去
	if (pW->hEvtCmdEnd != NULL) {
		CloseHandle(pW->hEvtCmdEnd);
		pW->hEvtCmdEnd = NULL;
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	１文字挿入																									//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	AciInsChar(PWKCONINP pW, WC c)
{
	BOOL	rc = FALSE;
	int		stl;

	if (MAjcIsPrintW(c)) {
		stl = (int)wcslen(pW->buf);
		if ((stl + 1) < pW->bfl) {
			//	やり直しテキスト更新
			AciUpdateAgainText(pW);
			//	半角文字挿入
			memmove(&pW->buf[pW->bix + 1], &pW->buf[pW->bix], (pW->bfl - (pW->bix + 1)) * 2);  pW->buf[pW->bix] = c;
			//	バッファインデクス前進
			pW->bix++;
			//	カーソル位置が表示右端以前ならばカーソル位置設定
			if (IX2CP(pW->bix) < IX2CP(pW->vix) + pW->fdl) {
				AciSetCursorPos(pW, pW->bix);
			}
			//	カーソル位置が表示右端より右・・
			else {
				//	テキスト末尾を表示するように表示先頭位置を設定
				AciSetTailOfText(pW);
			}
			//	バッファテキスト表示＆カーソル設定
			AciShowBufferText(pW);
			//	テキストバッファ退避
			wcscpy(pW->svbuf, pW->buf);
			pW->svbix = pW->bix;
			pW->svvix = pW->vix;
			rc = TRUE;
		}
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	カーソル位置算出（バッファインデクス → 相対カーソル位置（０～，バッファ先頭をカーソル位置０とする））		//
//--------------------------------------------------------------------------------------------------------------//
static	int		AciIxToCp(PWKCONINP pW, int bix)
{
	int		x  = 0;
	int		ix, cl;

	for (ix = 0; ix < bix; ) {
		if (MAjcIsLeadW(pW->buf[ix]) && MAjcIsTrailW(pW->buf[ix + 1])) cl = 2;
		else														   cl = 1;
		if (AjcIsBigCharW(&pW->buf[ix])) {
			x += 2;
		}
		else {
			x++;
		}
		ix += cl;
	}
	return x;
}

//--------------------------------------------------------------------------------------------------------------//
//	カーソル位置設定																							//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	AciSetCursorPos(PWKCONINP pW, int bix)
{
	int		x  = pW->xtop;
	int		ix, cl;
	COORD	pos;

	for (ix = pW->vix; ix < bix;) {
		if (MAjcIsLeadW(pW->buf[ix]) && MAjcIsTrailW(pW->buf[ix + 1])) cl = 2;
		else														   cl = 1;
		if (AjcIsBigCharW(&pW->buf[ix])) {
			x += 2;
		}
		else {
			x++;
		}
		ix += cl;
	}
	pos.X = x;
	pos.Y = pW->ytop;
	SetConsoleCursorPosition(pW->hStd, pos);

	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
//	カーソル左移動 																								//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	AciCursorToLeft(PWKCONINP pW)
{
	BOOL	rc = FALSE;

	if (pW->bix > 0) {
		//	バッファインデクスを左移動
		pW->bix--;
		//	カーソル位置が表示先頭以降ならばカーソル位置設定
		if (IX2CP(pW->bix) >= IX2CP(pW->vix)) {
			AciSetCursorPos(pW, pW->bix);
		}
		//	カーソル位置が表示先頭より左・・
		else {
			//	表示先頭位置後退
			pW->vix--;
			//	バッファテキスト表示＆カーソル設定
			AciShowBufferText(pW);
		}
		//	カーソル位置退避
		pW->svbix = pW->bix;
		pW->svvix = pW->vix;

		rc = TRUE;
	}
	return rc;
}

//--------------------------------------------------------------------------------------------------------------//
//	カーソル右移動 																								//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	AciCursorToRight(PWKCONINP pW)
{
	BOOL	rc = FALSE;
	int		stl;

	stl = (int)wcslen(pW->buf);
	if (pW->bix < stl) {
		//	バッファインデクスを右移動
		pW->bix++;
		//	カーソル位置が表示右端以前・・
		if (IX2CP(pW->bix) < IX2CP(pW->vix) + pW->fdl) {
			AciSetCursorPos(pW, pW->bix);
		}
		//	カーソル位置が表示右端より右・・
		else {
			//	表示先頭位置前進
			pW->vix++;
			//	バッファテキスト表示＆カーソル設定
			AciShowBufferText(pW);
		}
		//	カーソル位置退避
		pW->svbix = pW->bix;
		pW->svvix = pW->vix;

		rc = TRUE;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	１文字削除																									//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	AciDelChar(PWKCONINP pW)
{
	BOOL	rc = FALSE;
	int		stl;

	stl = (int)wcslen(pW->buf);
	if (pW->bix < stl) {
		//	やり直しテキスト更新
		AciUpdateAgainText(pW);
		//	テキスト後部移動（左へ詰める）
		memmove(&pW->buf[pW->bix], &pW->buf[pW->bix + 1], (pW->bfl - (pW->bix + 1)) * 2);
		//	テキスト末尾をクリアー
		memset(&pW->buf[stl - 1], 0, 2);
		//	表示先頭がテキスト末尾ならば、表示先頭を後退
		stl = (int)wcslen(pW->buf);
		if (stl != 0 && pW->vix >= stl) {
			pW->vix--;
		}
		//	バッファテキスト表示＆カーソル設定
		AciShowBufferText(pW);
		//	テキストバッファ退避
		wcscpy(pW->svbuf, pW->buf);
		pW->svbix = pW->bix;
		pW->svvix = pW->vix;
		rc = TRUE;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	１文字後退																									//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	AciBackSpace(PWKCONINP pW)
{
	BOOL	rc = FALSE;
	int		stl;

	stl = (int)wcslen(pW->buf);
	if (pW->bix > 0) {
		//	１文字後退
		if (pW->bix >= 1) {
			//	やり直しテキスト更新
			AciUpdateAgainText(pW);
			//	バッファインデクス後退
			pW->bix--;
			//	テキスト後部移動（左へ詰める）
			memmove(&pW->buf[pW->bix], &pW->buf[pW->bix + 1], (pW->bfl - (pW->bix + 1)) * 2);
			//	テキスト末尾をクリアー
			memset(&pW->buf[stl - 1], 0, 2);
			//	カーソル位置が表示先頭より左ならば、表示先頭位置後退
			if (pW->vix > 0 && IX2CP(pW->bix) <= IX2CP(pW->vix)) {
				//	表示先頭位置後退
				pW->vix--;
			}
			//	バッファテキスト表示＆カーソル設定
			AciShowBufferText(pW);
			//	テキストバッファ退避
			wcscpy(pW->svbuf, pW->buf);
			pW->svbix = pW->bix;
			pW->svvix = pW->vix;
			rc = TRUE;
		}
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	コピー																										//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	AciCopy(PWKCONINP pW)
{
	BOOL	rc = FALSE;
	HGLOBAL	hGlobal;
	int		stl;
	WCP		pTxt;

	//	クリップボードへデータ格納(バイト文字)
	if (stl = (int)wcslen(pW->buf)) {
		if (hGlobal = GlobalAlloc(GHND | GMEM_SHARE, (stl + 1) * 2)) {
			pTxt = (WCP)GlobalLock(hGlobal);
			wcscpy(pTxt, pW->buf);
			GlobalUnlock(hGlobal);
			OpenClipboard(pW->hCon);
			EmptyClipboard();
			SetClipboardData(CF_UNICODETEXT, hGlobal);
			CloseClipboard();
			rc = TRUE;
		}
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	切り取り																									//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	AciCut(PWKCONINP pW)
{
	BOOL	rc = FALSE;

	//	コピー
	if (AciCopy(pW)) {
		//	行クリアー
		AciClearLine(pW);
		rc = TRUE;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	行クリアー																									//
//--------------------------------------------------------------------------------------------------------------//
static	VO		AciClearLine(PWKCONINP pW)
{
	//	やり直しテキスト更新
	AciUpdateAgainText(pW);
	//	テキストクリアー
	AciSetTextToBuffer(pW, L"");
	//	バッファテキスト表示＆カーソル設定
	AciShowBufferText(pW);
	//	テキストバッファ退避
	wcscpy(pW->svbuf, pW->buf);
	pW->svbix = pW->bix;
	pW->svvix = pW->vix;
}

//--------------------------------------------------------------------------------------------------------------//
//	貼り付け																									//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	AciPaste(PWKCONINP pW)
{
	BOOL	rc = FALSE;
	HGLOBAL	hGlobal;
	C_WCP	pTxt;
	int		stl, len;
	WC		c;

	//	やり直しテキスト更新
	AciUpdateAgainText(pW);
	//	クリップボードデータを読み出してバッファに格納
	if (OpenClipboard(pW->hCon)) {
		if (hGlobal = GetClipboardData(CF_UNICODETEXT)) {
			if (pTxt = (C_WCP)GlobalLock(hGlobal)) {
				stl  = (int)wcslen(pW->buf);
				len  = 0;
				while (*pTxt != 0) {
					if ((stl + 1) < pW->bfl) {
						c = *pTxt;
						if (!MAjcIsTrailW(c)) {
							if		(iswcntrl	(c)) c = L' ';
							else if (MAjcIsLeadW(c)) c = L'?';
							//	文字挿入
							memmove(&pW->buf[pW->bix + 1], &pW->buf[pW->bix], (pW->bfl - (pW->bix + 1)) * 2);  pW->buf[pW->bix] = c;
							pW->bix++;
							//	文字列長更新
							stl++;
							len++;
						}
						pTxt++;
					}
					else break;
				}
				GlobalUnlock(hGlobal);

				//	カーソル位置が表示右端以前ならばカーソル位置設定
				if (IX2CP(pW->bix) < IX2CP(pW->vix) + pW->fdl) {
					AciSetCursorPos(pW, pW->bix);
				}
				//	カーソル位置が表示右端より右・・
				else {
					//	表示先頭位置前進
					pW->vix += len;
				}
				//	バッファテキスト表示＆カーソル設定
				AciShowBufferText(pW);
				//	テキストバッファ退避
				wcscpy(pW->svbuf, pW->buf);
				pW->svbix = pW->bix;
				pW->svvix = pW->vix;
				rc = TRUE;
			}
		}
		CloseClipboard();
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	やり直し																									//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	AciRedo(PWKCONINP pW)
{
	BOOL	rc = FALSE;
	int		agp;

	//	やり直しデータ有・・
	if (pW->agn != 0) {
		//	やり直しテキストに空あり・・
		if (pW->agn < ACIMAX_AGAIN) {
			//	やり直し位置表示
			AciSendCmdToThread(pW, ACICCD_SHOWREDO, pW->agn - pW->acp, pW->agn);
			//	やり直しテキストをバッファに設定
			AciSetTextToBuffer(pW, pW->pAgn[pW->acp]);
			//	カーソル位置設定
			pW->bix   = pW->bAgn[pW->acp];
			pW->vix   = pW->vAgn[pW->acp];
			//	やり直しテキスト先頭以外・・
			if (pW->acp != 0) {
				//	やり直しテキスト現在位置更新
				pW->acp--;
				rc = TRUE;
			}
		}
		//	やり直しテキスト満杯
		else {
			//	やり直し位置表示
			agp = pW->acp - pW->aix;
			if (agp < 0) agp = pW->agn + agp;
			AciSendCmdToThread(pW, ACICCD_SHOWREDO, pW->agn - agp, pW->agn);
			//	やり直しテキストをバッファに設定
			AciSetTextToBuffer(pW, pW->pAgn[pW->acp]);
			//	カーソル位置設定
			pW->bix   = pW->bAgn[pW->acp];
			pW->vix   = pW->vAgn[pW->acp];
			//	やり直しテキストは最古以外・・
			if (pW->acp != pW->aix) {
				//	やり直しテキスト現在位置更新
				pW->acp = ((pW->acp != 0) ? pW->acp - 1 : ACIMAX_AGAIN - 1);
				rc = TRUE;
			}
		}
	}
	//	やり直しデータ無し
	else {
		//	やり直しテキストをバッファに設定
		AciSetTextToBuffer(pW, pW->svbuf);
		//	カーソル位置設定
		pW->bix   = pW->svbix;
		pW->vix   = pW->svvix;
		//	やり直し位置表示
		AciSendCmdToThread(pW, ACICCD_SHOWREDO, 0, pW->agn);
	}
	//	バッファテキスト表示＆カーソル設定
	AciShowBufferText(pW);

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	やり直しのやり直し																							//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	AciRedoOfRedo(PWKCONINP pW)
{
	BOOL	rc = FALSE;
	int		nix, agp;

	if (pW->agn != 0) {
		//	１つ進めたやり直しインデクス設定
		nix = (pW->acp + 1) % ACIMAX_AGAIN;
		//	やり直しテキストは最古以外・・
		if (nix != pW->aix) {
			//	やり直しテキスト現在位置更新
			pW->acp = nix;
			//	やり直し位置表示
			agp = pW->acp - pW->aix;
			if (agp < 0) agp = pW->agn + agp;
			AciSendCmdToThread(pW, ACICCD_SHOWREDO, pW->agn - agp, pW->agn);
			//	やり直しテキストをバッファに設定
			AciSetTextToBuffer(pW, pW->pAgn[pW->acp]);
			//	カーソル位置設定
			pW->bix   = pW->bAgn[pW->acp];
			pW->vix   = pW->vAgn[pW->acp];
			rc = TRUE;
		}
		//	やり直しテキストは最古・・
		else {
			//	やり直し位置表示
			AciSendCmdToThread(pW, ACICCD_SHOWREDO, 0, pW->agn);
			//	現入力テキスト設定
			AciSetTextToBuffer(pW, pW->svbuf);
			//	カーソル位置設定
			pW->bix   = pW->svbix;
			pW->vix   = pW->svvix;
		}
		//	バッファテキスト表示＆カーソル設定
		AciShowBufferText(pW);
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	やり直しバッファ更新																						//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	AciUpdateAgainText(PWKCONINP pW)
{
	BOOL	rc = FALSE;

	//	過去の参照テキスト表示中ならば、退避テキストをやり直し登録
	if (pW->fRefTxt) {
		SubUpdateAgainText(pW, pW->svbuf, pW->svbix, pW->svvix);
		pW->fRefTxt = FALSE;
	}

	//	現テキストをやり直し登録
	rc = SubUpdateAgainText(pW, pW->buf, pW->bix, pW->vix);

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	SubUpdateAgainText(PWKCONINP pW, C_WCP pTxt, int bix, int vix)
{
	BOOL	rc = FALSE;
	int		ixLas, stl;
	WCP		pTmp;

	//	新テキストの長さ設定
	stl = (int)wcslen(pTxt);
	//	やり直しデータ無し／最新データと異なる場合にやり直し登録
	ixLas = (pW->aix != 0 ? pW->aix - 1 : ACIMAX_AGAIN - 1);
	if (pW->agn == 0 || wcscmp(pTxt, pW->pAgn[ixLas]) != 0) {
		//	やり直しバッファ確保
		if (pTmp = AjcTAllocW(stl + 1)) {
			//	満杯ならば最古のデータ破棄
			if (pW->agn >= ACIMAX_AGAIN) {
				if (pW->pAgn[pW->aix] != NULL) {
					AJCFREE(pW->pAgn[pW->aix]);
					pW->pAgn[pW->aix] = NULL;
				}
			}
			//	新テキスト設定
			pW->pAgn[pW->aix] = pTmp;
			pW->bAgn[pW->aix] = bix;
			pW->vAgn[pW->aix] = vix;
			wcscpy(pW->pAgn[pW->aix], pTxt);
			//	やり直し現在位置設定
			pW->acp = pW->aix;
			//	やり直しインデクス更新（次の格納位置）
			pW->aix = ((pW->aix + 1) % ACIMAX_AGAIN);
			//	やり直しデータ数更新
			if (pW->agn < ACIMAX_AGAIN) {
				pW->agn++;
			}
			rc = TRUE;
		}
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	参照テキストロード 																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO		AciLoadRefText(PWKCONINP pW)
{
	int		i;
	WC		key[32];
	WC		buf[ACIMAX_BUFLEN];

	pW->rfn = 0;
	for (i = 0; i < ACIMAX_REFTXT; i++) {
		AjcSnPrintFW(key, sizeof key, L"AjcConInputKey%03d", i);
		AjcGetProfileStrW(AJCCIN_SECTW, key, L"@@#$NoData$#@@", buf, ACIMAX_BUFLEN);
		if (wcscmp(buf, L"@@#$NoData$#@@") == 0) break;
		if (pW->pRef[pW->rfn] = AjcSplRegistW(pW->hSpl, buf)) {
			pW->rfn++;
		}
	}
	//	初期インデクス設定
	pW->rix = pW->rfn;		//	rix = オーバーエントリ
}

//--------------------------------------------------------------------------------------------------------------//
//	参照テキストセーブ 																							//
//--------------------------------------------------------------------------------------------------------------//
static	VO		AciSaveRefText(PWKCONINP pW)
{
	int		ix;
	WC		key[32];

	//	参照テキストセーブ
	for (ix = 0; ix < pW->rfn; ix++) {
		AjcSnPrintFW(key, AJCTSIZE(key), L"AjcConInputKey%03d", ix);
		AjcPutProfileStrW(AJCCIN_SECTW, key, pW->pRef[ix]);
	}
	//	後続の参照テキスト削除
	for (; ix < ACIMAX_REFTXT; ix++) {
		AjcSnPrintFW(key, AJCTSIZE(key), L"AjcConInputKey%03d", ix);
		AjcDelProfileKeyW(AJCCIN_SECTW, key);
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	参照テキスト登録 																							//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	AciRegistRefText(PWKCONINP pW)
{
	BOOL	rc = FALSE;
	int		ix, nix, ixSame;
	C_WCP	pTmp;

	if (pW->buf[0] != 0) {
		//	同一テキスト検索
		for (ix = 0; ix < pW->rfn; ix++) {
			if (wcscmp(pW->pRef[ix], pW->buf) == 0) {
				ixSame = ix;
				break;
			}
		}
		//	同一テキスト登録済ならば、同一テキストを最新にする
		if (ix < pW->rfn) {
			//	バッファテキスト登録
			if (pTmp = AjcSplRegistW(pW->hSpl, pW->buf)) {
				//	同一テキスト～最新テキストをシフト
				for (ix = ixSame, nix = ixSame + 1; nix < pW->rfn; ix = nix, nix++) {
					C_WCP pSav;
					pSav		  = pW->pRef[ix];
					pW->pRef[ix]  = pW->pRef[nix];
					pW->pRef[nix] = pSav;
				}
				rc = TRUE;
			}
		}
		//	同一テキスト未登録ならば、追加登録
		else {
			//	参照テキスト満杯ならば、最古のデータを破棄し１つシフトする
			if (pW->rfn >= ACIMAX_REFTXT) {
				//	最古のデータ破棄
				AjcSplRemoveW(pW->hSpl, pW->pRef[0]);
				//	シフト
				for (ix = 0, nix = 1; nix < ACIMAX_REFTXT; ix = nix, nix++) {
					pW->pRef[ix] = pW->pRef[nix];
				}
				//	設定位置＝末尾エントリ
				ix = ACIMAX_REFTXT - 1;
			}
			//	参照テキストに空きありならば・・・
			else {
				//	設定位置＝空きエントリ
				ix = pW->rfn;
			}
			//	バッファテキスト登録，エントリ数更新
			if (pTmp = AjcSplRegistW(pW->hSpl, pW->buf)) {
				//	バッファテキスト設定
				pW->pRef[ix] = pTmp;
				//	エントリ数更新
				if (pW->rfn < ACIMAX_REFTXT) pW->rfn++;
				rc = TRUE;
			}
		}
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	過去の参照テキストをバッファに設定 																			//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	AciSetRefTextBackword(PWKCONINP pW)
{
	BOOL	rc = FALSE;

	if (pW->rfn != 0) {
		//	参照テキスト・インデクス更新
		if (pW->rix != 0) {
			pW->rix--;
		}
		//	参照テキスト位置表示
		AciSendCmdToThread(pW, ACICCD_SHOWPREV, pW->rfn - pW->rix, pW->rfn);
		//	参照テキスト設定
		AciSetTextToBuffer(pW, pW->pRef[pW->rix]);
		//	バッファテキスト表示＆カーソル設定
		AciShowBufferText(pW);
		//	過去の参照テキスト表示中の旨、フラグ設定
		pW->fRefTxt = TRUE;

		rc = TRUE;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	次の参照テキストをバッファに設定																			//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	AciSetRefTextForword(PWKCONINP pW)
{
	BOOL	rc = FALSE;

	if (pW->rfn != 0) {
		//	参照テキストインデクス＝中途
		if (pW->rix < pW->rfn - 1) {
			//	参照テキストインデクス更新
			pW->rix++;
			//	参照テキスト位置表示
			AciSendCmdToThread(pW, ACICCD_SHOWPREV, pW->rfn - pW->rix, pW->rfn);
			//	参照テキスト設定
			AciSetTextToBuffer(pW, pW->pRef[pW->rix]);
			//	過去の参照テキスト表示中の旨、フラグ設定
			pW->fRefTxt = TRUE;
		}
		//	参照テキストインデクス＝終端
		else {
			//	参照テキストインデクス＝終端の旨設定
			pW->rix = pW->rfn;
			//	参照テキスト位置表示 ( 0 / n )
			AciSendCmdToThread(pW, ACICCD_SHOWPREV, pW->rfn - pW->rix, pW->rfn);
			//	現入力テキスト設定
			AciSetTextToBuffer(pW, pW->svbuf);
			//	カーソル位置設定
			pW->bix   = pW->svbix;
			pW->vix   = pW->svvix;
			//	過去の参照テキスト表示中フラグクリアー
			pW->fRefTxt = FALSE;
		}
		//	バッファテキスト表示＆カーソル設定
		AciShowBufferText(pW);
		rc = TRUE;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	テキストをバッファに設定 																					//
//--------------------------------------------------------------------------------------------------------------//
static	VO		AciSetTextToBuffer(PWKCONINP pW, C_WCP pTxt)
{
	int		i, stl;

	//	バッファクリアー
	memset(pW->buf, 0, sizeof pW->buf);
	//	NULLならば空文字列を仮定
	if (pTxt == NULL) pTxt = L"";
	//	不要文字を除去しながらバッファに転送
	i = 0;
	while (*pTxt != 0) {
		if (MAjcIsPrintW(*pTxt)) {
			if ((i + 1) < pW->bfl) {
				pW->buf[i++] = *pTxt++;
			}
			else break;
		}
		else {
			pTxt++;
		}
	}
	//	初期表示インデクス設定（テキストの末尾表示）
	stl = (int)wcslen(pW->buf);
	if (stl > 0 && IX2CP(stl - 1) < pW->fdl) {
		pW->vix = 0;
	}
	else {
		//	テキスト末尾を表示するように設定
		AciSetTailOfText(pW);
		//	カーソルをテキスト末尾に設定
		pW->bix = stl;
	}
	pW->bix = stl;
}
//--------------------------------------------------------------------------------------------------------------//
//	テキスト末尾を表示するように表示先頭インデクスを設定														//
//--------------------------------------------------------------------------------------------------------------//
static	VO		AciSetTailOfText(PWKCONINP pW)
{
	int		stl = (int)wcslen(pW->buf);
	int		ix	= stl - 1;
	int		fl	= 0;

	//	末尾を表示するように表示開始インデクス(vix)を設定
	while (ix >= 0) {
		if (AjcIsBigChar(&pW->buf[ix])) fl += 2;
		else							fl++;
		if (fl >= pW->fdl) {
			ix++;
			break;
		}
		ix--;
	}
	pW->vix = (ix >= 0 ? ix : 0);

	//	バッファインデクス(bix)が表示開始インデクス(vix)より左の場合は、vixに合わせる
	if (pW->bix < pW->vix) {
		pW->bix = pW->vix;
	}
}

//--------------------------------------------------------------------------------------------------------------//
//	バッファテキスト表示	（vix以降のテキストを表示し、カーソル位置をbixに合わせて設定）						//
//--------------------------------------------------------------------------------------------------------------//
static	VO	AciShowBufferText(PWKCONINP pW)
{
	int		stl, fl;
	int		ix, six, eix;
	COORD	pos;

	if (pW->hStd != NULL) {
		//	バッファテキスト長設定
		stl = (int)wcslen(pW->buf);
		//	先頭，末尾インデクス設定
		six = pW->vix;
		eix = stl;
		//	行頭へカーソル設定
		pos.X = pW->xtop;
		pos.Y = pW->ytop;
		SetConsoleCursorPosition(pW->hStd, pos);
		//	テキスト表示
		fl	= 0;
		for (ix = six; ix < eix; ix++) {
			if (AjcIsBigCharW(&pW->buf[ix])) fl += 2;
			else							 fl++;
			if (fl > pW->fdl) break;
			_putwch(pW->buf[ix]);
		}
		//	後部余白表示
		while (fl < pW->fdl) {
			_putwch(0x20);
			fl++;
		}
		//	カーソル位置設定
		AciSetCursorPos(pW, pW->bix);
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	ヘルプ表示制御スレッドへコマンド送信																		//
//--------------------------------------------------------------------------------------------------------------//
static	VO		AciSendCmdToThread(PWKCONINP pW, ACICCD ccd, int val1, int val2)
{
	ACICMD	cmd = {0};
	//	コマンド送信
	cmd.ccd   = ccd;
	cmd.val1  = val1;
	cmd.val2  = val2;
	AjcFMbxEnque(pW->hFMbxCmd, &cmd);
	//	コマンド終了待ち
	WaitForSingleObject(pW->hEvtCmdEnd, 100);
	//	イベントリセット
	ResetEvent(pW->hEvtCmdEnd);
}
//--------------------------------------------------------------------------------------------------------------//
//	コンソール前景色取得 																						//
//--------------------------------------------------------------------------------------------------------------//
static COLORREF AciGetConsoleForColor(PWKCONINP pW)
{
	COLORREF	rc = 0;
	UI			ix = 0;

	if (pW->bi.wAttributes & FOREGROUND_INTENSITY) ix |= 0x04;
	if (pW->bi.wAttributes & FOREGROUND_RED 	 ) ix |= 0x04;
	if (pW->bi.wAttributes & FOREGROUND_GREEN	 ) ix |= 0x02;
	if (pW->bi.wAttributes & FOREGROUND_BLUE	 ) ix |= 0x01;

	rc = pW->bi.ColorTable[ix];

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	コンソール背景色取得																						//
//--------------------------------------------------------------------------------------------------------------//
static COLORREF AciGetConsoleBackColor(PWKCONINP pW)
{
	COLORREF	rc = 0;
	UI			ix = 0;

	if (pW->bi.wAttributes & BACKGROUND_INTENSITY) ix |= 0x04;
	if (pW->bi.wAttributes & BACKGROUND_RED 	 ) ix |= 0x04;
	if (pW->bi.wAttributes & BACKGROUND_GREEN	 ) ix |= 0x02;
	if (pW->bi.wAttributes & BACKGROUND_BLUE	 ) ix |= 0x01;

	rc = pW->bi.ColorTable[ix];

	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	コンソール文字色，背景色の変更																				//
//--------------------------------------------------------------------------------------------------------------//
static VO	 AciChangeConsoleColor(PWKCONINP pW, COLORREF cText, COLORREF cBack)
{
	if ((cText & 0xFF000000) == 0x80000000 || (cBack & 0xFF000000) == 0x80000000) {
		AciChangeConsole16Color(pW, cText, cBack);
	}
	else if (cText != -1 || cBack != -1) {
		AciChangeConsoleFullColor(pW, cText, cBack);
	}
}
//--------------------------------------------------------------------------------------------------------------//
//	コンソール文字色，背景色の変更（１６カラー）																//
//--------------------------------------------------------------------------------------------------------------//
static VO	 AciChangeConsole16Color(PWKCONINP pW, COLORREF cText, COLORREF cBack)
{
	UW	att = 0;
	CONSOLE_SCREEN_BUFFER_INFOEX bi;

	//	コンソールバッファ情報取得
	bi.cbSize = sizeof(bi);
	GetConsoleScreenBufferInfoEx(pW->hStd, &bi);
	att = bi.wAttributes;

	//	テキスト表示色設定
	if ((cText & 0xF0000000) == 0x80000000) {
		att &= ~(FOREGROUND_INTENSITY | FOREGROUND_RED | FOREGROUND_GREEN | FOREGROUND_BLUE);
		if (cText & 0x08) att |= FOREGROUND_INTENSITY;
		if (cText & 0x04) att |= FOREGROUND_RED;
		if (cText & 0x02) att |= FOREGROUND_GREEN;
		if (cText & 0x01) att |= FOREGROUND_BLUE;
	}
	//	背景表示色設定
	if ((cBack & 0xF0000000) == 0x80000000) {
		att &= ~(BACKGROUND_INTENSITY | BACKGROUND_RED | BACKGROUND_GREEN | BACKGROUND_BLUE);
		if (cBack & 0x08) att |= BACKGROUND_INTENSITY;
		if (cBack & 0x04) att |= BACKGROUND_RED;
		if (cBack & 0x02) att |= BACKGROUND_GREEN;
		if (cBack & 0x01) att |= BACKGROUND_BLUE;
	}

	SetConsoleTextAttribute(pW->hStd, att);
}
//--------------------------------------------------------------------------------------------------------------//
//	コンソール文字色，背景色の変更（フルカラー）																//
//--------------------------------------------------------------------------------------------------------------//
static VO	 AciChangeConsoleFullColor(PWKCONINP pW, COLORREF cText, COLORREF cBack)
{
	UI			bix = 0, fix = 0;		//	現パレットインデクス
	UI			bnx = 0, fnx = 0;		//	新パレットインデクス
	UW			att;
	UI			i;
	UI			ixtbl[16];
	CONSOLE_SCREEN_BUFFER_INFOEX bi;

	//	コンソールバッファ情報取得
	bi.cbSize = sizeof(bi);
	GetConsoleScreenBufferInfoEx(pW->hStd, &bi);
	//	パレットインデクス設定
	if (bi.wAttributes & FOREGROUND_INTENSITY) fix |= 0x08;
	if (bi.wAttributes & FOREGROUND_RED 	 ) fix |= 0x04;
	if (bi.wAttributes & FOREGROUND_GREEN	 ) fix |= 0x02;
	if (bi.wAttributes & FOREGROUND_BLUE	 ) fix |= 0x01;
	if (bi.wAttributes & BACKGROUND_INTENSITY) bix |= 0x08;
	if (bi.wAttributes & BACKGROUND_RED 	 ) bix |= 0x04;
	if (bi.wAttributes & BACKGROUND_GREEN	 ) bix |= 0x02;
	if (bi.wAttributes & BACKGROUND_BLUE	 ) bix |= 0x01;

	//	新パレットインデクス設定（空きパレット＃設定）
	memset(ixtbl, 0, sizeof ixtbl);
	ixtbl[fix] = 1;
	ixtbl[bix] = 1;
	for (i = 0; i < 16; i++) {
		if (ixtbl[i] == 0) {
			ixtbl[fnx = i] = 1;
			break;
		}
	}
	for (i = 0; i < 16; i++) {
		if (ixtbl[i] == 0) {
			ixtbl[bnx = i] = 1;
			break;
		}
	}

	//	新パレットへ文字色設定
	if (cText != -1) {
		bi.ColorTable[fnx] = cText;
	}
	else {
		fnx = fix;
	}
	//	新パレットイへ背景色設定
	if (cBack != -1) {
		bi.ColorTable[bnx] = cBack;
	}
	else {
		bnx = bix;
	}
	//	新コンソールバッファ情報設定
	bi.srWindow.Bottom++; // 設定する場合Bottomを+1する（WindowsAPIバグ？）
	SetConsoleScreenBufferInfoEx(pW->hStd, &bi);
	//	コンソール表示色設定
	att = 0;
	if (fnx & 0x08) att |= FOREGROUND_INTENSITY;
	if (fnx & 0x04) att |= FOREGROUND_RED;
	if (fnx & 0x02) att |= FOREGROUND_GREEN;
	if (fnx & 0x01) att |= FOREGROUND_BLUE;
	if (bnx & 0x08) att |= BACKGROUND_INTENSITY;
	if (bnx & 0x04) att |= BACKGROUND_RED;
	if (bnx & 0x02) att |= BACKGROUND_GREEN;
	if (bnx & 0x01) att |= BACKGROUND_BLUE;
	SetConsoleTextAttribute(pW->hStd, att);
}
//--------------------------------------------------------------------------------------------------------------//
//	コンソール表示色を元に戻す																					//
//--------------------------------------------------------------------------------------------------------------//
static VO AciRecoverConsoleColor(PWKCONINP pW)
{
	CONSOLE_SCREEN_BUFFER_INFOEX bi;

	memcpy(&bi, &pW->bi, sizeof bi);
	bi.srWindow.Bottom++; // 設定する場合Bottomを+1する（WindowsAPIバグ？）
	SetConsoleScreenBufferInfoEx(pW->hStd, &bi);
	SetConsoleTextAttribute(pW->hStd, bi.wAttributes);
}
//--------------------------------------------------------------------------------------------------------------//
//	書式出力																									//
//--------------------------------------------------------------------------------------------------------------//
static	BOOL	AciPrintF(C_WCP pFmt, ...)
{
	BOOL		rc = FALSE;
	va_list 	vls;
	WCP			p;
	WC			buf[ACIMAX_BUFLEN];

	if (pFmt != NULL) {
		va_start(vls, pFmt);
		_vsnwprintf(buf, ACIMAX_BUFLEN, pFmt, vls);
		buf[ACIMAX_BUFLEN - 1] = 0;
		va_end	(vls);

		for (p = buf; *p != 0; p++) {
			_putwch(*p);
		}
		rc = TRUE;
	}
	return rc;
}
//--------------------------------------------------------------------------------------------------------------//
//	ヘルプ表示制御スレッド																						//
//																												//
//	以下の理由（Windows10 64bit, Build:18363.1082 のバグ）から、ヘルプ制御をスレッド化する。					//
//																												//
//		１）_kbhit()動作不具合																					//
//				・バイトモードで全角文字入力時、(不定回数)TRUEを返し続ける										//
//				・ワイドモード時、全角文字読み出し後（次の全角文字が無いにもかかわらず）_kbhit()==TRUEとなる	//
//																												//
//		２）_getch() / _getwch()不具合																			//
//				・バイトモードで全角文字入力時、_getch() が固定値を返し続ける									//
//				・バイトモード時、_getch() で、全角２バイト目が読み出せない										//
//																												//
//		※	バイトモードで全角文字入力は使用不可																//
//		※	ワイドモードで全角文字入力時、_kbhit()==TRUEとなり、_getwch() を実行することになるも、実際には入力	//
//			文字が無いため、入力待ちとなりブロックされる（ヘルプ表示はウインド制御要の為、ブロックは不可）		//
//--------------------------------------------------------------------------------------------------------------//
static	VO		ShowFullText(PWKCONINP pW);
static	VO		ShowFraction(PWKCONINP pW, C_WCP pTxt, int val1, int val2, COLORREF cFore, COLORREF cBack, COLORREF cBorder);
//--------------------------------------------------------------------------------------------------------------//
static	UI _stdcall threadHelp(VOP pVoid)
{
	PWKCONINP	pW	= (PWKCONINP)pVoid;
	MSG			msg;
	ACICMD		cmd;

	//	スレッド開始通知
	SetEvent(pW->hEvtStart);


	for (;;) {
		//	メッセージハンドル
		if (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE)) {
			//	ディスパッチ
			TranslateMessage(&msg);
			DispatchMessage (&msg);
		}
		else {
			//	メインスレッドからのコマンド処理
			if (AjcFMbxDeque(pW->hFMbxCmd, &cmd, 0)) {
				//	●ヘルプ表示／非表示
				if		(cmd.ccd == ACICCD_SHOWHELP) {
					//	ヘルプ非表示中
					if (!AjcTipTextGetRect(NULL)) {
						C_WCP		pHelp = ((cmd.val1 == HELP_F1) ? AJCLNGSEL(HelpTextJ, HelpTextE) : pW->pHelp);
						COLORREF	FrRgb, BkRgb;
						CONSOLE_FONT_INFO cfi;
						HFONT		hFont = NULL;
						RECT		rect;
						SIZE		szTip, szWnd;
						int			x, y;
						if (pHelp != NULL) {
							//	コンソールの背景色取得
							FrRgb = AciGetConsoleForColor (pW);
							BkRgb = AciGetConsoleBackColor(pW);
							//	コンソールのフォント設定
							if (GetCurrentConsoleFont(pW->hStd, FALSE, &cfi)) {
								hFont = AjcGetDefFontFix(cfi.dwFontSize.Y);
							}
							//	ツールチップサイズ取得
							AjcTipTextGetSize(pHelp, hFont, TRUE, &szTip);
							//	コンソールウインドサイズ取得
							GetClientRect(pW->hCon, &rect);
							MapWindowPoints(pW->hCon, NULL, (LPPOINT)&rect , 2);
							szWnd.cx = rect.right - rect.left;
							szWnd.cy = rect.bottom - rect.top;
							//	ヘルプチップ表示
							x = rect.right - (szTip.cx + 4);
							y = rect.top + 4;
							AjcTipTextShowExW(x, y,								//	ウインドの表示位置
											  0,								//	ウインドの最小幅
											  0,								//	ウインドの高さ（０の場合は文字の大きさに合わせる）
											  pHelp,							//	ヘルプテキスト
											  1000,								//	表示時間（ms）
											  hFont,							//	フォント
											  FrRgb,							//	テキスト色
											  BkRgb,							//	背景色
											  FrRgb);							//	外枠色
							//	チップテキストウインド矩形情報取得しチップツール内にカーソル移動
							if (AjcTipTextGetRect(&rect)) {
								//	カーソル移動
								SetCursorPos((rect.left + rect.right) / 2, (rect.top + rect.bottom) / 2);
							}
							else {
								//	カーソル移動
								SetCursorPos( x + szTip.cx - 40, y + szTip.cy - 40);
							}
						}
					}
					//	ヘルプ表示中
					else {
						AjcTipTextHide();
					}
				}
				//	●テキスト表示／非表示
				else if	(cmd.ccd == ACICCD_SHOWTEXT) {
					if (!AjcTipTextGetRect(NULL)) {
						ShowFullText(pW);
					}
					else {
						AjcTipTextHide();
					}
				}
				//	●簡易ガイド表示
				else if (cmd.ccd == ACICCD_SHOWGUIDE) {
					if (pW->fOpt & AJCCIN_F1GUIDE) {
						int					x=0, y=0;
						RECT				rect;
						SIZE				sz;
						C_WCP				pGuide = (pW->pHelp == NULL ? AJCLNGSEL(Guide1J, Guide1E) :
																		  AJCLNGSEL(Guide2J, Guide2E));
						//	コンソールウインド矩形取得
						GetClientRect(pW->hCon, &rect);
						MapWindowPoints(pW->hCon, NULL, (LPPOINT)&rect , 2);
						//	コンソール画面表示中央位置算出
						AjcTipTextGetSizeW(AJCLNGSEL(Guide1J, 	Guide1E), NULL, TRUE, &sz);
						x = rect.left + (rect.right - rect.left - sz.cx) / 2;
						y = rect.top  + (rect.bottom - rect.top - sz.cy) / 2;
						//	簡易ガイド表示
							AjcTipTextShowExW(x, y,								//	ウインドの表示位置
											  0,								//	ウインドの最小幅
											  0,								//	ウインドの高さ（０の場合は文字の大きさに合わせる）
											  pGuide,							//	チップテキスト
											  2000,								//	表示時間（ms）
											  NULL,								//	フォント
											  -1,								//	テキスト色
											  -1,								//	背景色
											  RGB(255, 255, 255));				//	外枠色
						//	コンソールウインドをフォーカス
						AjcSetFocusWindow(pW->hCon);
					}
				}
				//	●ツールチップ非表示
				else if (cmd.ccd == ACICCD_HIDE) {
					AjcTipTextHide();
				}
				//	●やり直し位置表示
				else if (cmd.ccd == ACICCD_SHOWREDO) {
					if (pW->fOpt & AJCCIN_SHOWREDO) {
						ShowFraction(pW, L"Redo", cmd.val1, cmd.val2, -1, RGB(181, 228, 171), RGB(64, 128, 64));
					}
				}
				//	●参照テキスト位置表示
				else if (cmd.ccd == ACICCD_SHOWPREV) {
					if (pW->fOpt & AJCCIN_SHOWPREV) {
						ShowFraction(pW, L"Prev.", cmd.val1, cmd.val2, -1, RGB(181, 171, 228), RGB(64, 64, 128));
					}
				}
				//	●スレッド終了
				else if (cmd.ccd == ACICCD_END) {
					AjcTipTextHide();
					break;
				}
				//	コマンド終了通知
				SetEvent(pW->hEvtCmdEnd);
			}
			Sleep(1);
		}
	}
	return 0;
}
//----- 入力域直下に入力テキスト表示 ---------------------------------------------------------------------------//
static	VO		ShowFullText(PWKCONINP pW)
{
	RECT	rect;
	int		x, y;
	CONSOLE_FONT_INFO cfi;

	//	コンソールウインドサイズ取得
	GetClientRect(pW->hCon, &rect);
	MapWindowPoints(pW->hCon, NULL, (LPPOINT)&rect , 2);
	//	仮の表示位置算出（画面左上）
	x = rect.left + 2;
	y = rect.top  + 2;
	//	フォントサイズから表示位置算出
	if (GetCurrentConsoleFont(pW->hStd, FALSE, &cfi)) {
		int		a;
		a = cfi.dwFontSize.X *	pW->xtop; // 表示域先頭までの長さ
		x = rect.left + a;
		y = rect.top + cfi.dwFontSize.Y * ((pW->ytop - pW->bi.srWindow.Top) + 1) + 1;
		//	ウインド下端を超える場合、直上行位置に変更
		if (y >= rect.bottom) {
			y = rect.top + cfi.dwFontSize.Y * ((pW->ytop - pW->bi.srWindow.Top) - 2);
		}
	}
	//	テキスト表示
	AjcTipTextShowW(x, y,			//	ウインドの表示位置
					pW->buf,		//	表示テキスト
					10000,			//	表示時間（ms）
					NULL);			//	フォント
}
//----- 入力フィールド直下に分数表示 ---------------------------------------------------------------------------//
static	VO		ShowFraction(PWKCONINP pW, C_WCP pTxt, int val1, int val2, COLORREF cFore, COLORREF cBack, COLORREF cBorder)
{
	HFONT	hFont = AjcGetDefFontVar(18);
	SIZE	szTip, szWnd;
	RECT	rect;
	int		x, y;
	WC		txt[256];
	CONSOLE_FONT_INFO cfi;

	//	表示テキスト作成
	AjcSnPrintFW(txt, AJCTSIZE(txt), L"%s %3d / %-3d", pTxt, val1, val2);
	//	ツールチップサイズ取得
	AjcTipTextGetSizeW(txt, hFont, TRUE, &szTip);
	//	コンソールウインドサイズ取得
	GetClientRect(pW->hCon, &rect);
	MapWindowPoints(pW->hCon, NULL, (LPPOINT)&rect , 2);
	szWnd.cx = rect.right - rect.left;
	szWnd.cy = rect.bottom - rect.top;
	//	仮の表示位置算出（画面右上）
	x = rect.right - (szTip.cx + 2);
	y = rect.top + 2;
	//	フォントサイズから表示位置算出
	if (GetCurrentConsoleFont(pW->hStd, FALSE, &cfi)) {
		int		a;
		a = cfi.dwFontSize.X *	pW->xtop; // 表示域先頭までの長さ
		x = rect.left + a + (szWnd.cx - a - szTip.cx) / 2;
		y = rect.top + cfi.dwFontSize.Y * ((pW->ytop - pW->bi.srWindow.Top) + 2) + 1;
		//	ウインド下端を超える場合、直上行位置に変更
		if (y >= rect.bottom) {
			y = rect.top + cfi.dwFontSize.Y * ((pW->ytop - pW->bi.srWindow.Top) - 3);
		}
	}
	//	分数テキスト表示
	AjcTipTextShowExW(x, y,				//	ウインドの表示位置
					  0,				//	ウインドの最小幅
					  0,				//	ウインドの高さ（０の場合は文字の大きさに合わせる）
					  txt,				//	表示テキスト
					  1000,				//	表示時間（ms）
					  hFont,			//	フォント
					  cFore,			//	テキスト色
					  cBack,			//	背景色
					  cBorder);			//	外枠色
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	コンソールハンドラ（このハンドラは、同一プロセスの別スレッドで実行されます）								//
//																												//
//--------------------------------------------------------------------------------------------------------------//
static BOOL CALLBACK hdlConsole(UL CtrlType)
{
	BOOL		rc = FALSE;
	PWKCONINP	pW = NULL;
	HWND		hCon;
	WC			szTtl[256];

	do {
		//	コンソールウインドハンドル取得
		GetConsoleTitle(szTtl, AJCTSIZE(szTtl));
		hCon = FindWindow(NULL, szTtl);
		if (hCon == NULL) break;

		//	インスタンスワークアドレス取得
		AjcAvlGetNode (hAvlConInp, (UX)hCon, (VOP)&pW, sizeof pW);
		if (pW == NULL) break;

		//	Ctrl + C
		if (CtrlType == CTRL_C_EVENT) {
			do {
				//	コピー
				if (pW != NULL) {
					AciCopy(pW);
				}
			} while(0);

			// TRUE : 次のハンドラをコールしない
			rc = TRUE;
		}
		//	その他（CTRL_BREAK_EVENT / CTRL_CLOSE_EVENT / CTRL_LOGOFF_EVENT / CTRL_SHUTDOWN_EVENT）
		else {
			//	インスタンスワーク消去
			AciEnding(pW);
			//	ＡＶＬ消去
			if (hAvlConInp != NULL) {
				AjcAvlDelete(hAvlConInp);
				hAvlConInp = NULL;
			}
		}
	} while(0);

	return rc;
}
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//																												//
//	ＭＳＩＬ用サポートコード																					//
//																												//
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
//==============================================================================================================//
//	１行入力																									//
//																												//
//	引　数：	pStr	  - 初期文字列																			//
//				pBuf	  - 入力文字列格納バッファ																//
//				lBuf	  - 入力文字格納バッファのバイト数／文字数												//
//				len		  - 入力文字数（＝入力域の長さ）														//
//				fOpt	  - オプションフラグ(AJCCIP_XXXXX)														//
//				TextColor - テキスト色																			//
//				BackColor - 背景色																				//
//				cbp		  - コールバックパラメタ（入力文字を引数化した情報の通知用コールバック）				//
//				cbNtcArgs - 入力文字列内用コールバック															//
//																												//
//	戻り値：	TRUE  - 正常																					//
//				FALSE - エラー																					//
//==============================================================================================================//
AJCEXPORT BOOL	 WINAPI AjcConInputForMSIL(C_WCP pInitialText, UI lInpField,
										WCP pBuf, UI lBuf,
										UI fOpt, COLORREF TextColor, COLORREF BackColor, C_WCP pHelpText,
										UX cbp, VO (CALLBACK *cbNtcStr)(int argc, C_WCP pStr, UX cbp))
{
	BOOL	rc = FALSE;
	int		i, stl, argc;
	WCP		*argv;
	WCP		pNtc = NULL;

	//	最大入力文字数補正
	if (lBuf == 0 || lBuf >= (ACIMAX_BUFLEN / 2)) {
		lBuf = ACIMAX_BUFLEN / 2;
	}

	//	コンソール入力
	if (rc = AjcConInputExW(pInitialText, lInpField, pBuf, lBuf, fOpt, TextColor, BackColor, pHelpText, 0, NULL)) {
		//	コールバック・・
		if (cbNtcStr != NULL) {
			//	分離文字列作成
			if (argv = AjcParseCmdArgsW(pBuf, (UIP)&argc)) {
				stl = (UI)wcslen(pBuf);
				//	統合文字列用バッファ確保
				if (pNtc = (WCP)AJCMEM((stl + 1) * 2)) {
					//	統合文字列作成（分離文字列群をタブで区切って統合）
					*pNtc = 0;
					for (i = 0; i < argc; i++) {
						if (i != 0) wcscat(pNtc, L"\t");
						wcscat(pNtc, argv[i]);
					}
					//	統合文字列通知
					cbNtcStr(argc, pNtc, cbp);
					free(pNtc);
				}
				AjcReleaseCmdArgs(argv);
			}
		}
	}
	return rc;
}

